/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.Hashtable;

final class XmlReader
extends Reader {
    private static final int MAXPUSHBACK = 512;
    private Reader in;
    private String assignedEncoding;
    private boolean closed;
    private static final Hashtable charsets = new Hashtable(31);

    public static Reader createReader(InputStream inputStream) throws IOException {
        return new XmlReader(inputStream);
    }

    public static Reader createReader(InputStream inputStream, String string) throws IOException {
        if (string == null) {
            return new XmlReader(inputStream);
        }
        if ("UTF-8".equalsIgnoreCase(string) || "UTF8".equalsIgnoreCase(string)) {
            return new Utf8Reader(inputStream);
        }
        if ("US-ASCII".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string)) {
            return new AsciiReader(inputStream);
        }
        if ("ISO-8859-1".equalsIgnoreCase(string)) {
            return new Iso8859_1Reader(inputStream);
        }
        return new InputStreamReader(inputStream, XmlReader.std2java(string));
    }

    private static String std2java(String string) {
        String string2 = string.toUpperCase();
        return (string2 = (String)charsets.get(string2)) != null ? string2 : string;
    }

    public String getEncoding() {
        return this.assignedEncoding;
    }

    private XmlReader(InputStream inputStream) throws IOException {
        super(inputStream);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 512);
        byte[] byArray = new byte[4];
        int n2 = pushbackInputStream.read(byArray);
        if (n2 > 0) {
            pushbackInputStream.unread(byArray, 0, n2);
        }
        if (n2 == 4) {
            block0 : switch (byArray[0] & 0xFF) {
                case 0: {
                    if (byArray[1] != 60 || byArray[2] != 0 || byArray[3] != 63) break;
                    this.setEncoding(pushbackInputStream, "UnicodeBig");
                    return;
                }
                case 60: {
                    switch (byArray[1] & 0xFF) {
                        default: {
                            break block0;
                        }
                        case 0: {
                            if (byArray[2] != 63 || byArray[3] != 0) break block0;
                            this.setEncoding(pushbackInputStream, "UnicodeLittle");
                            return;
                        }
                        case 63: 
                    }
                    if (byArray[2] != 120 || byArray[3] != 109) break;
                    this.useEncodingDecl(pushbackInputStream, "UTF8");
                    return;
                }
                case 76: {
                    if (byArray[1] != 111 || (0xFF & byArray[2]) != 167 || (0xFF & byArray[3]) != 148) break;
                    this.useEncodingDecl(pushbackInputStream, "CP037");
                    return;
                }
                case 254: {
                    if ((byArray[1] & 0xFF) != 255) break;
                    this.setEncoding(pushbackInputStream, "UTF-16");
                    return;
                }
                case 255: {
                    if ((byArray[1] & 0xFF) != 254) break;
                    this.setEncoding(pushbackInputStream, "UTF-16");
                    return;
                }
            }
        }
        this.setEncoding(pushbackInputStream, "UTF-8");
    }

    /*
     * Unable to fully structure code
     */
    private void useEncodingDecl(PushbackInputStream var1_1, String var2_2) throws IOException {
        var3_3 = new byte[512];
        var4_4 = var1_1.read(var3_3, 0, var3_3.length);
        var1_1.unread(var3_3, 0, var4_4);
        var5_5 = new InputStreamReader((InputStream)new ByteArrayInputStream(var3_3, 4, var4_4), var2_2);
        var6_6 = var5_5.read();
        if (var6_6 != 108) {
            this.setEncoding(var1_1, "UTF-8");
            return;
        }
        var7_7 = new StringBuffer();
        var8_8 = null;
        var9_9 = null;
        var10_10 = false;
        var11_11 = '\u0000';
        var12_12 = false;
        var13_13 = 0;
        block0: while (var13_13 < 507) {
            block19: {
                block20: {
                    var6_6 = var5_5.read();
                    if (var6_6 == -1) break;
                    if (var6_6 == 32 || var6_6 == 9 || var6_6 == 10 || var6_6 == 13) break block19;
                    if (var13_13 == 0) break;
                    if (var6_6 == 63) {
                        var12_12 = true;
                    } else if (var12_12) {
                        if (var6_6 == 62) break;
                        var12_12 = false;
                    }
                    if (var9_9 != null && var10_10) break block20;
                    if (var8_8 == null) {
                        if (!Character.isWhitespace((char)var6_6)) {
                            var8_8 = var7_7;
                            var7_7.setLength(0);
                            var7_7.append((char)var6_6);
                            var10_10 = false;
                        }
                    } else if (Character.isWhitespace((char)var6_6)) {
                        var9_9 = var8_8.toString();
                    } else if (var6_6 == 61) {
                        if (var9_9 == null) {
                            var9_9 = var8_8.toString();
                        }
                        var10_10 = true;
                        var8_8 = null;
                        var11_11 = '\u0000';
                    } else {
                        var8_8.append((char)var6_6);
                    }
                    break block19;
                }
                if (Character.isWhitespace((char)var6_6)) break block19;
                if (var6_6 != 34 && var6_6 != 39) ** GOTO lbl-1000
                if (var11_11 == '\u0000') {
                    var11_11 = (char)var6_6;
                    var7_7.setLength(0);
                } else if (var6_6 == var11_11) {
                    if ("encoding".equals(var9_9)) {
                        this.assignedEncoding = var7_7.toString();
                        var13_13 = 0;
                        while (var13_13 < this.assignedEncoding.length()) {
                            var6_6 = this.assignedEncoding.charAt(var13_13);
                            if (!(var6_6 >= 65 && var6_6 <= 90 || var6_6 >= 97 && var6_6 <= 122) && (var13_13 == 0 || var13_13 <= 0 || var6_6 != 45 && (var6_6 < 48 || var6_6 > 57) && var6_6 != 46 && var6_6 != 95)) break block0;
                            ++var13_13;
                        }
                        this.setEncoding(var1_1, this.assignedEncoding);
                        return;
                    }
                    var9_9 = null;
                } else lbl-1000:
                // 2 sources

                {
                    var7_7.append((char)var6_6);
                }
            }
            ++var13_13;
        }
        this.setEncoding(var1_1, "UTF-8");
    }

    private void setEncoding(InputStream inputStream, String string) throws IOException {
        this.assignedEncoding = string;
        this.in = XmlReader.createReader(inputStream, string);
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n4 = this.in.read(cArray, n2, n3);
        if (n4 == -1) {
            this.close();
        }
        return n4;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n2 = this.in.read();
        if (n2 == -1) {
            this.close();
        }
        return n2;
    }

    public boolean markSupported() {
        return this.in == null ? false : this.in.markSupported();
    }

    public void mark(int n2) throws IOException {
        if (this.in != null) {
            this.in.mark(n2);
        }
    }

    public void reset() throws IOException {
        if (this.in != null) {
            this.in.reset();
        }
    }

    public long skip(long l2) throws IOException {
        return this.in == null ? 0L : this.in.skip(l2);
    }

    public boolean ready() throws IOException {
        return this.in == null ? false : this.in.ready();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.in.close();
        this.in = null;
        this.closed = true;
    }

    static {
        charsets.put("UTF-16", "Unicode");
        charsets.put("ISO-10646-UCS-2", "Unicode");
        charsets.put("EBCDIC-CP-US", "cp037");
        charsets.put("EBCDIC-CP-CA", "cp037");
        charsets.put("EBCDIC-CP-NL", "cp037");
        charsets.put("EBCDIC-CP-WT", "cp037");
        charsets.put("EBCDIC-CP-DK", "cp277");
        charsets.put("EBCDIC-CP-NO", "cp277");
        charsets.put("EBCDIC-CP-FI", "cp278");
        charsets.put("EBCDIC-CP-SE", "cp278");
        charsets.put("EBCDIC-CP-IT", "cp280");
        charsets.put("EBCDIC-CP-ES", "cp284");
        charsets.put("EBCDIC-CP-GB", "cp285");
        charsets.put("EBCDIC-CP-FR", "cp297");
        charsets.put("EBCDIC-CP-AR1", "cp420");
        charsets.put("EBCDIC-CP-HE", "cp424");
        charsets.put("EBCDIC-CP-BE", "cp500");
        charsets.put("EBCDIC-CP-CH", "cp500");
        charsets.put("EBCDIC-CP-ROECE", "cp870");
        charsets.put("EBCDIC-CP-YU", "cp870");
        charsets.put("EBCDIC-CP-IS", "cp871");
        charsets.put("EBCDIC-CP-AR2", "cp918");
    }

    static final class Iso8859_1Reader
    extends BaseReader {
        Iso8859_1Reader(InputStream inputStream) {
            super(inputStream);
        }

        public int read(char[] cArray, int n2, int n3) throws IOException {
            if (this.instream == null) {
                return -1;
            }
            if (n2 + n3 > cArray.length || n2 < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n4 = 0;
            while (n4 < n3) {
                if (this.start >= this.finish) {
                    this.start = 0;
                    this.finish = this.instream.read(this.buffer, 0, this.buffer.length);
                    if (this.finish <= 0) {
                        if (this.finish > 0) break;
                        this.close();
                        break;
                    }
                }
                cArray[n2 + n4] = (char)(0xFF & this.buffer[this.start++]);
                ++n4;
            }
            if (n4 == 0 && this.finish <= 0) {
                return -1;
            }
            return n4;
        }
    }

    static final class AsciiReader
    extends BaseReader {
        AsciiReader(InputStream inputStream) {
            super(inputStream);
        }

        public int read(char[] cArray, int n2, int n3) throws IOException {
            if (this.instream == null) {
                return -1;
            }
            if (n2 + n3 > cArray.length || n2 < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n4 = 0;
            while (n4 < n3) {
                byte by;
                if (this.start >= this.finish) {
                    this.start = 0;
                    this.finish = this.instream.read(this.buffer, 0, this.buffer.length);
                    if (this.finish <= 0) {
                        if (this.finish > 0) break;
                        this.close();
                        break;
                    }
                }
                if (((by = this.buffer[this.start++]) & 0x80) != 0) {
                    throw new CharConversionException("Illegal ASCII character, 0x" + Integer.toHexString(by & 0xFF));
                }
                cArray[n2 + n4] = (char)by;
                ++n4;
            }
            if (n4 == 0 && this.finish <= 0) {
                return -1;
            }
            return n4;
        }
    }

    static final class Utf8Reader
    extends BaseReader {
        private char nextChar;

        Utf8Reader(InputStream inputStream) {
            super(inputStream);
        }

        public int read(char[] cArray, int n2, int n3) throws IOException {
            int n4 = 0;
            int n5 = 0;
            if (n3 <= 0) {
                return 0;
            }
            if (n2 + n3 > cArray.length || n2 < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.nextChar != '\u0000') {
                cArray[n2 + n4++] = this.nextChar;
                this.nextChar = '\u0000';
            }
            while (n4 < n3) {
                int n6;
                block20: {
                    if (this.finish <= this.start) {
                        if (this.instream == null) {
                            n5 = -1;
                            break;
                        }
                        this.start = 0;
                        this.finish = this.instream.read(this.buffer, 0, this.buffer.length);
                        if (this.finish <= 0) {
                            this.close();
                            n5 = -1;
                            break;
                        }
                    }
                    if (((n5 = this.buffer[this.start] & 0xFF) & 0x80) == 0) {
                        ++this.start;
                        cArray[n2 + n4++] = (char)n5;
                        continue;
                    }
                    n6 = this.start;
                    try {
                        if ((this.buffer[n6] & 0xE0) == 192) {
                            n5 = (this.buffer[n6++] & 0x1F) << 6;
                            n5 += this.buffer[n6++] & 0x3F;
                            break block20;
                        }
                        if ((this.buffer[n6] & 0xF0) == 224) {
                            n5 = (this.buffer[n6++] & 0xF) << 12;
                            n5 += (this.buffer[n6++] & 0x3F) << 6;
                            n5 += this.buffer[n6++] & 0x3F;
                            break block20;
                        }
                        if ((this.buffer[n6] & 0xF8) == 240) {
                            n5 = (this.buffer[n6++] & 7) << 18;
                            n5 += (this.buffer[n6++] & 0x3F) << 12;
                            n5 += (this.buffer[n6++] & 0x3F) << 6;
                            if ((n5 += this.buffer[n6++] & 0x3F) > 0x10FFFF) {
                                throw new CharConversionException("UTF-8 encoding of character 0x00" + Integer.toHexString(n5) + " can't be converted to Unicode.");
                            }
                            if (n5 > 65535) {
                                this.nextChar = (char)(56320 + ((n5 -= 65536) & 0x3FF));
                                n5 = 55296 + (n5 >> 10);
                            }
                            break block20;
                        }
                        throw new CharConversionException("Unconvertible UTF-8 character beginning with 0x" + Integer.toHexString(this.buffer[this.start] & 0xFF));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n5 = 0;
                    }
                }
                if (n6 > this.finish) {
                    System.arraycopy(this.buffer, this.start, this.buffer, 0, this.finish - this.start);
                    this.finish -= this.start;
                    this.start = 0;
                    n6 = this.instream.read(this.buffer, this.finish, this.buffer.length - this.finish);
                    if (n6 < 0) {
                        this.close();
                        throw new CharConversionException("Partial UTF-8 char");
                    }
                    this.finish += n6;
                    continue;
                }
                ++this.start;
                while (this.start < n6) {
                    if ((this.buffer[this.start] & 0xC0) != 128) {
                        this.close();
                        throw new CharConversionException("Malformed UTF-8 char -- is an XML encoding declaration missing?");
                    }
                    ++this.start;
                }
                cArray[n2 + n4++] = (char)n5;
                if (this.nextChar == '\u0000' || n4 >= n3) continue;
                cArray[n2 + n4++] = this.nextChar;
                this.nextChar = '\u0000';
            }
            if (n4 > 0) {
                return n4;
            }
            return n5 == -1 ? -1 : 0;
        }
    }

    static abstract class BaseReader
    extends Reader {
        protected InputStream instream;
        protected byte[] buffer;
        protected int start;
        protected int finish;

        BaseReader(InputStream inputStream) {
            super(inputStream);
            this.instream = inputStream;
            this.buffer = new byte[8192];
        }

        public boolean ready() throws IOException {
            return this.instream == null || this.finish - this.start > 0 || this.instream.available() != 0;
        }

        public void close() throws IOException {
            if (this.instream != null) {
                this.instream.close();
                this.finish = 0;
                this.start = 0;
                this.buffer = null;
                this.instream = null;
            }
        }
    }
}

