/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;

abstract class GapVector
implements Serializable {
    private Object array;
    private int g0;
    private int g1;

    public GapVector() {
        this(10);
    }

    public GapVector(int n2) {
        this.array = this.allocateArray(n2);
        this.g0 = 0;
        this.g1 = n2;
    }

    protected abstract Object allocateArray(int var1);

    protected abstract int getArrayLength();

    protected final Object getArray() {
        return this.array;
    }

    protected final int getGapStart() {
        return this.g0;
    }

    protected final int getGapEnd() {
        return this.g1;
    }

    protected void replace(int n2, int n3, Object object, int n4) {
        int n5 = 0;
        if (n4 == 0) {
            this.close(n2, n3);
            return;
        }
        if (n3 > n4) {
            this.close(n2 + n4, n3 - n4);
        } else {
            int n6 = n4 - n3;
            int n7 = this.open(n2 + n3, n6);
            System.arraycopy(object, n3, this.array, n7, n6);
            n4 = n3;
        }
        System.arraycopy(object, n5, this.array, n2, n4);
    }

    void close(int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        int n4 = n2 + n3;
        int n5 = this.g1 - this.g0 + n3;
        if (n4 <= this.g0) {
            if (this.g0 != n4) {
                this.shiftGap(n4);
            }
            this.shiftGapStartDown(this.g0 - n3);
        } else if (n2 >= this.g0) {
            if (this.g0 != n2) {
                this.shiftGap(n2);
            }
            this.shiftGapEndUp(this.g0 + n5);
        } else {
            this.shiftGapStartDown(n2);
            this.shiftGapEndUp(this.g0 + n5);
        }
    }

    int open(int n2, int n3) {
        int n4 = this.g1 - this.g0;
        if (n3 == 0) {
            if (n2 > this.g0) {
                n2 += n4;
            }
            return n2;
        }
        this.shiftGap(n2);
        if (n3 >= n4) {
            this.shiftEnd(this.getArrayLength() - n4 + n3);
            n4 = this.g1 - this.g0;
        }
        this.g0 += n3;
        return n2;
    }

    void resize(int n2) {
        Object object = this.allocateArray(n2);
        System.arraycopy(this.array, 0, object, 0, Math.min(n2, this.getArrayLength()));
        this.array = object;
    }

    protected void shiftEnd(int n2) {
        int n3 = this.getArrayLength();
        int n4 = this.g1;
        int n5 = n3 - n4;
        int n6 = (n2 + 1) * 2;
        int n7 = n6 - n5;
        this.resize(n6);
        this.g1 = n7;
        if (n5 != 0) {
            System.arraycopy(this.array, n4, this.array, n7, n5);
        }
    }

    protected void shiftGap(int n2) {
        if (n2 == this.g0) {
            return;
        }
        int n3 = this.g0;
        int n4 = n2 - n3;
        int n5 = this.g1;
        int n6 = n5 + n4;
        int n7 = n5 - n3;
        this.g0 = n2;
        this.g1 = n6;
        if (n4 > 0) {
            System.arraycopy(this.array, n5, this.array, n3, n4);
        } else if (n4 < 0) {
            System.arraycopy(this.array, n2, this.array, n6, -n4);
        }
    }

    protected void shiftGapStartDown(int n2) {
        this.g0 = n2;
    }

    protected void shiftGapEndUp(int n2) {
        this.g1 = n2;
    }
}

