/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public abstract class ImageReader {
    protected ImageReaderSpi originatingProvider;
    protected Object input = null;
    protected boolean seekForwardOnly = false;
    protected boolean ignoreMetadata = false;
    protected int minIndex = 0;
    protected Locale[] availableLocales = null;
    protected Locale locale = null;
    protected List warningListeners = null;
    protected List warningLocales = null;
    protected List progressListeners = null;
    protected List updateListeners = null;
    private boolean abortFlag = false;

    protected ImageReader(ImageReaderSpi imageReaderSpi) {
        this.originatingProvider = imageReaderSpi;
    }

    public String getFormatName() throws IOException {
        return this.originatingProvider.getFormatNames()[0];
    }

    public ImageReaderSpi getOriginatingProvider() {
        return this.originatingProvider;
    }

    public void setInput(Object object, boolean bl2, boolean bl3) {
        if (object != null) {
            boolean bl4 = false;
            if (this.originatingProvider != null) {
                Class[] classArray = this.originatingProvider.getInputTypes();
                int n2 = 0;
                while (n2 < classArray.length) {
                    if (classArray[n2].isInstance(object)) {
                        bl4 = true;
                        break;
                    }
                    ++n2;
                }
            } else if (object instanceof ImageInputStream) {
                bl4 = true;
            }
            if (!bl4) {
                throw new IllegalArgumentException("Incorrect input type!");
            }
            this.seekForwardOnly = bl2;
            this.ignoreMetadata = bl3;
            this.minIndex = 0;
        }
        this.input = object;
    }

    public void setInput(Object object, boolean bl2) {
        this.setInput(object, bl2, false);
    }

    public void setInput(Object object) {
        this.setInput(object, false, false);
    }

    public Object getInput() {
        return this.input;
    }

    public boolean isSeekForwardOnly() {
        return this.seekForwardOnly;
    }

    public boolean isIgnoringMetadata() {
        return this.ignoreMetadata;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            return null;
        }
        return (Locale[])this.availableLocales.clone();
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            Locale[] localeArray = this.getAvailableLocales();
            boolean bl2 = false;
            if (localeArray != null) {
                int n2 = 0;
                while (n2 < localeArray.length) {
                    if (locale.equals(localeArray[n2])) {
                        bl2 = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl2) {
                throw new IllegalArgumentException("Invalid locale!");
            }
        }
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract int getNumImages(boolean var1) throws IOException;

    public abstract int getWidth(int var1) throws IOException;

    public abstract int getHeight(int var1) throws IOException;

    public boolean isRandomAccessEasy(int n2) throws IOException {
        return false;
    }

    public float getAspectRatio(int n2) throws IOException {
        return (float)this.getWidth(n2) / (float)this.getHeight(n2);
    }

    public ImageTypeSpecifier getRawImageType(int n2) throws IOException {
        return (ImageTypeSpecifier)this.getImageTypes(n2).next();
    }

    public abstract Iterator getImageTypes(int var1) throws IOException;

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public abstract IIOMetadata getStreamMetadata() throws IOException;

    public IIOMetadata getStreamMetadata(String string, Set set) throws IOException {
        return this.getMetadata(string, set, true, 0);
    }

    private IIOMetadata getMetadata(String string, Set set, boolean bl2, int n2) throws IOException {
        IIOMetadata iIOMetadata;
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (set == null) {
            throw new IllegalArgumentException("nodeNames == null!");
        }
        IIOMetadata iIOMetadata2 = iIOMetadata = bl2 ? this.getStreamMetadata() : this.getImageMetadata(n2);
        if (iIOMetadata != null) {
            if (iIOMetadata.isStandardMetadataFormatSupported() && string.equals("javax_imageio_1.0")) {
                return iIOMetadata;
            }
            String string2 = iIOMetadata.getNativeMetadataFormatName();
            if (string2 != null && string.equals(string2)) {
                return iIOMetadata;
            }
            String[] stringArray = iIOMetadata.getExtraMetadataFormatNames();
            if (stringArray != null) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (string.equals(stringArray[n3])) {
                        return iIOMetadata;
                    }
                    ++n3;
                }
            }
        }
        return null;
    }

    public abstract IIOMetadata getImageMetadata(int var1) throws IOException;

    public IIOMetadata getImageMetadata(int n2, String string, Set set) throws IOException {
        return this.getMetadata(string, set, false, n2);
    }

    public BufferedImage read(int n2) throws IOException {
        return this.read(n2, null);
    }

    public abstract BufferedImage read(int var1, ImageReadParam var2) throws IOException;

    public IIOImage readAll(int n2, ImageReadParam imageReadParam) throws IOException {
        if (n2 < this.getMinIndex()) {
            throw new IndexOutOfBoundsException("imageIndex < getMinIndex()!");
        }
        BufferedImage bufferedImage = this.read(n2, imageReadParam);
        List list = null;
        int n3 = this.getNumThumbnails(n2);
        int n4 = 0;
        while (n4 < n3) {
            list.add(this.readThumbnail(n2, n4));
            ++n4;
        }
        IIOMetadata iIOMetadata = this.getImageMetadata(n2);
        return new IIOImage(bufferedImage, list, iIOMetadata);
    }

    public Iterator readAll(Iterator iterator) throws IOException {
        ArrayList arrayList = new ArrayList();
        int n2 = this.getMinIndex();
        this.processSequenceStarted(n2);
        while (true) {
            Object object;
            ImageReadParam imageReadParam = null;
            if (iterator != null && iterator.hasNext() && (object = iterator.next()) != null) {
                if (object instanceof ImageReadParam) {
                    imageReadParam = (ImageReadParam)object;
                } else {
                    throw new IllegalArgumentException("Non-ImageReadParam supplied as part of params!");
                }
            }
            object = null;
            try {
                object = this.read(n2, imageReadParam);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            List list = null;
            int n3 = this.getNumThumbnails(n2);
            int n4 = 0;
            while (n4 < n3) {
                list.add(this.readThumbnail(n2, n4));
                ++n4;
            }
            IIOMetadata iIOMetadata = this.getImageMetadata(n2);
            IIOImage iIOImage = new IIOImage((RenderedImage)object, list, iIOMetadata);
            arrayList.add(iIOImage);
            ++n2;
        }
        this.processSequenceComplete();
        return arrayList.iterator();
    }

    public boolean canReadRaster() {
        return false;
    }

    public Raster readRaster(int n2, ImageReadParam imageReadParam) throws IOException {
        throw new UnsupportedOperationException("readRaster not supported!");
    }

    public boolean isImageTiled(int n2) throws IOException {
        return false;
    }

    public int getTileWidth(int n2) throws IOException {
        return this.getWidth(n2);
    }

    public int getTileHeight(int n2) throws IOException {
        return this.getHeight(n2);
    }

    public int getTileGridXOffset(int n2) throws IOException {
        return 0;
    }

    public int getTileGridYOffset(int n2) throws IOException {
        return 0;
    }

    public BufferedImage readTile(int n2, int n3, int n4) throws IOException {
        if (n3 != 0 || n4 != 0) {
            throw new IllegalArgumentException("Invalid tile indices");
        }
        return this.read(n2);
    }

    public Raster readTileRaster(int n2, int n3, int n4) throws IOException {
        if (!this.canReadRaster()) {
            throw new UnsupportedOperationException("readTileRaster not supported!");
        }
        if (n3 != 0 || n4 != 0) {
            throw new IllegalArgumentException("Invalid tile indices");
        }
        return this.readRaster(n2, null);
    }

    public RenderedImage readAsRenderedImage(int n2, ImageReadParam imageReadParam) throws IOException {
        return this.read(n2, imageReadParam);
    }

    public boolean readerSupportsThumbnails() {
        return false;
    }

    public boolean hasThumbnails(int n2) throws IOException {
        return this.getNumThumbnails(n2) > 0;
    }

    public int getNumThumbnails(int n2) throws IOException {
        return 0;
    }

    public int getThumbnailWidth(int n2, int n3) throws IOException {
        return this.readThumbnail(n2, n3).getWidth();
    }

    public int getThumbnailHeight(int n2, int n3) throws IOException {
        return this.readThumbnail(n2, n3).getHeight();
    }

    public BufferedImage readThumbnail(int n2, int n3) throws IOException {
        throw new UnsupportedOperationException("Thumbnails not supported!");
    }

    public synchronized void abort() {
        this.abortFlag = true;
    }

    protected synchronized boolean abortRequested() {
        return this.abortFlag;
    }

    protected synchronized void clearAbortRequest() {
        this.abortFlag = false;
    }

    static List addToList(List list, Object object) {
        if (list == null) {
            list = new ArrayList();
        }
        list.add(object);
        return list;
    }

    static List removeFromList(List list, Object object) {
        if (list == null) {
            return list;
        }
        list.remove(object);
        if (list.size() == 0) {
            list = null;
        }
        return list;
    }

    public void addIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        if (iIOReadWarningListener == null) {
            return;
        }
        this.warningListeners = ImageReader.addToList(this.warningListeners, iIOReadWarningListener);
        this.warningLocales = ImageReader.addToList(this.warningLocales, this.getLocale());
    }

    public void removeIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        if (iIOReadWarningListener == null || this.warningListeners == null) {
            return;
        }
        int n2 = this.warningListeners.indexOf(iIOReadWarningListener);
        if (n2 != -1) {
            this.warningListeners.remove(n2);
            this.warningLocales.remove(n2);
            if (this.warningListeners.size() == 0) {
                this.warningLocales = null;
                this.warningListeners = null;
            }
        }
    }

    public void removeAllIIOReadWarningListeners() {
        this.warningListeners = null;
        this.warningLocales = null;
    }

    public void addIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        if (iIOReadProgressListener == null) {
            return;
        }
        this.progressListeners = ImageReader.addToList(this.progressListeners, iIOReadProgressListener);
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        if (iIOReadProgressListener == null || this.progressListeners == null) {
            return;
        }
        this.progressListeners = ImageReader.removeFromList(this.progressListeners, iIOReadProgressListener);
    }

    public void removeAllIIOReadProgressListeners() {
        this.progressListeners = null;
    }

    public void addIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        if (iIOReadUpdateListener == null) {
            return;
        }
        this.updateListeners = ImageReader.addToList(this.updateListeners, iIOReadUpdateListener);
    }

    public void removeIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        if (iIOReadUpdateListener == null || this.updateListeners == null) {
            return;
        }
        this.updateListeners = ImageReader.removeFromList(this.updateListeners, iIOReadUpdateListener);
    }

    public void removeAllIIOReadUpdateListeners() {
        this.updateListeners = null;
    }

    protected void processSequenceStarted(int n2) {
        if (this.progressListeners == null) {
            return;
        }
        int n3 = this.progressListeners.size();
        int n4 = 0;
        while (n4 < n3) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n4);
            iIOReadProgressListener.sequenceStarted(this, n2);
            ++n4;
        }
    }

    protected void processSequenceComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n3);
            iIOReadProgressListener.sequenceComplete(this);
            ++n3;
        }
    }

    protected void processImageStarted(int n2) {
        if (this.progressListeners == null) {
            return;
        }
        int n3 = this.progressListeners.size();
        int n4 = 0;
        while (n4 < n3) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n4);
            iIOReadProgressListener.imageStarted(this, n2);
            ++n4;
        }
    }

    protected void processImageProgress(float f2) {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n3);
            iIOReadProgressListener.imageProgress(this, f2);
            ++n3;
        }
    }

    protected void processImageComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n3);
            iIOReadProgressListener.imageComplete(this);
            ++n3;
        }
    }

    protected void processThumbnailStarted(int n2, int n3) {
        if (this.progressListeners == null) {
            return;
        }
        int n4 = this.progressListeners.size();
        int n5 = 0;
        while (n5 < n4) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n5);
            iIOReadProgressListener.thumbnailStarted(this, n2, n3);
            ++n5;
        }
    }

    protected void processThumbnailProgress(float f2) {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n3);
            iIOReadProgressListener.thumbnailProgress(this, f2);
            ++n3;
        }
    }

    protected void processThumbnailComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n3);
            iIOReadProgressListener.thumbnailComplete(this);
            ++n3;
        }
    }

    protected void processReadAborted() {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n3);
            iIOReadProgressListener.readAborted(this);
            ++n3;
        }
    }

    protected void processPassStarted(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n9 = this.updateListeners.size();
        int n10 = 0;
        while (n10 < n9) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n10);
            iIOReadUpdateListener.passStarted(this, bufferedImage, n2, n3, n4, n5, n6, n7, n8, nArray);
            ++n10;
        }
    }

    protected void processImageUpdate(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n8 = this.updateListeners.size();
        int n9 = 0;
        while (n9 < n8) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n9);
            iIOReadUpdateListener.imageUpdate(this, bufferedImage, n2, n3, n4, n5, n6, n7, nArray);
            ++n9;
        }
    }

    protected void processPassComplete(BufferedImage bufferedImage) {
        if (this.updateListeners == null) {
            return;
        }
        int n2 = this.updateListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n3);
            iIOReadUpdateListener.passComplete(this, bufferedImage);
            ++n3;
        }
    }

    protected void processThumbnailPassStarted(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n9 = this.updateListeners.size();
        int n10 = 0;
        while (n10 < n9) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n10);
            iIOReadUpdateListener.thumbnailPassStarted(this, bufferedImage, n2, n3, n4, n5, n6, n7, n8, nArray);
            ++n10;
        }
    }

    protected void processThumbnailUpdate(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n8 = this.updateListeners.size();
        int n9 = 0;
        while (n9 < n8) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n9);
            iIOReadUpdateListener.thumbnailUpdate(this, bufferedImage, n2, n3, n4, n5, n6, n7, nArray);
            ++n9;
        }
    }

    protected void processThumbnailPassComplete(BufferedImage bufferedImage) {
        if (this.updateListeners == null) {
            return;
        }
        int n2 = this.updateListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n3);
            iIOReadUpdateListener.thumbnailPassComplete(this, bufferedImage);
            ++n3;
        }
    }

    protected void processWarningOccurred(String string) {
        if (this.warningListeners == null) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("warning == null!");
        }
        int n2 = this.warningListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadWarningListener iIOReadWarningListener = (IIOReadWarningListener)this.warningListeners.get(n3);
            iIOReadWarningListener.warningOccurred(this, string);
            ++n3;
        }
    }

    protected void processWarningOccurred(String string, String string2) {
        if (this.warningListeners == null) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("baseName == null!");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("keyword == null!");
        }
        int n2 = this.warningListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadWarningListener iIOReadWarningListener = (IIOReadWarningListener)this.warningListeners.get(n3);
            Locale locale = (Locale)this.warningLocales.get(n3);
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = locale == null ? ResourceBundle.getBundle(string) : ResourceBundle.getBundle(string, locale);
            }
            catch (MissingResourceException missingResourceException) {
                throw new IllegalArgumentException("Bundle not found!");
            }
            String string3 = null;
            try {
                string3 = resourceBundle.getString(string2);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Resource is not a String!");
            }
            catch (MissingResourceException missingResourceException) {
                throw new IllegalArgumentException("Resource is missing!");
            }
            iIOReadWarningListener.warningOccurred(this, string3);
            ++n3;
        }
    }

    public void reset() {
        this.setInput(null, false, false);
        this.setLocale(null);
        this.removeAllIIOReadUpdateListeners();
        this.removeAllIIOReadProgressListeners();
        this.removeAllIIOReadWarningListeners();
        this.clearAbortRequest();
    }

    public void dispose() {
    }

    protected static Rectangle getSourceRegion(ImageReadParam imageReadParam, int n2, int n3) {
        Rectangle rectangle = new Rectangle(0, 0, n2, n3);
        if (imageReadParam != null) {
            Rectangle rectangle2 = imageReadParam.getSourceRegion();
            if (rectangle2 != null) {
                rectangle = rectangle.intersection(rectangle2);
            }
            int n4 = imageReadParam.getSubsamplingXOffset();
            int n5 = imageReadParam.getSubsamplingYOffset();
            rectangle.x += n4;
            rectangle.y += n5;
            rectangle.width -= n4;
            rectangle.height -= n5;
        }
        return rectangle;
    }

    protected static void computeRegions(ImageReadParam imageReadParam, int n2, int n3, BufferedImage bufferedImage, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            throw new IllegalArgumentException("srcRegion == null!");
        }
        if (rectangle2 == null) {
            throw new IllegalArgumentException("destRegion == null!");
        }
        rectangle.setBounds(0, 0, n2, n3);
        rectangle2.setBounds(0, 0, n2, n3);
        int n4 = 1;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        if (imageReadParam != null) {
            Rectangle rectangle3 = imageReadParam.getSourceRegion();
            if (rectangle3 != null) {
                rectangle.setBounds(rectangle.intersection(rectangle3));
            }
            n4 = imageReadParam.getSourceXSubsampling();
            n5 = imageReadParam.getSourceYSubsampling();
            n6 = imageReadParam.getSubsamplingXOffset();
            n7 = imageReadParam.getSubsamplingYOffset();
            rectangle.translate(n6, n7);
            rectangle.width -= n6;
            rectangle.height -= n7;
            rectangle2.setLocation(imageReadParam.getDestinationOffset());
        }
        if (rectangle2.x < 0) {
            int n8 = -rectangle2.x * n4;
            rectangle.x += n8;
            rectangle.width -= n8;
            rectangle2.x = 0;
        }
        if (rectangle2.y < 0) {
            int n9 = -rectangle2.y * n5;
            rectangle.y += n9;
            rectangle.height -= n9;
            rectangle2.y = 0;
        }
        int n10 = (rectangle.width + n4 - 1) / n4;
        int n11 = (rectangle.height + n5 - 1) / n5;
        rectangle2.width = n10;
        rectangle2.height = n11;
        if (bufferedImage != null) {
            int n12;
            Rectangle rectangle4 = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            rectangle2.setBounds(rectangle2.intersection(rectangle4));
            if (rectangle2.isEmpty()) {
                throw new IllegalArgumentException("Empty destination region!");
            }
            int n13 = rectangle2.x + n10 - bufferedImage.getWidth();
            if (n13 > 0) {
                rectangle.width -= n13 * n4;
            }
            if ((n12 = rectangle2.y + n11 - bufferedImage.getHeight()) > 0) {
                rectangle.height -= n12 * n5;
            }
        }
        if (rectangle.isEmpty() || rectangle2.isEmpty()) {
            throw new IllegalArgumentException("Empty region!");
        }
    }

    protected static void checkReadParamBandSettings(ImageReadParam imageReadParam, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray = null;
        int[] nArray2 = null;
        if (imageReadParam != null) {
            nArray = imageReadParam.getSourceBands();
            nArray2 = imageReadParam.getDestinationBands();
        }
        int n6 = nArray == null ? n2 : nArray.length;
        int n7 = n5 = nArray2 == null ? n3 : nArray2.length;
        if (n6 != n5) {
            throw new IllegalArgumentException("ImageReadParam num source & dest bands differ!");
        }
        if (nArray != null) {
            n4 = 0;
            while (n4 < nArray.length) {
                if (nArray[n4] >= n2) {
                    throw new IllegalArgumentException("ImageReadParam source bands contains a value >= the number of source bands!");
                }
                ++n4;
            }
        }
        if (nArray2 != null) {
            n4 = 0;
            while (n4 < nArray2.length) {
                if (nArray2[n4] >= n3) {
                    throw new IllegalArgumentException("ImageReadParam dest bands contains a value >= the number of dest bands!");
                }
                ++n4;
            }
        }
    }

    protected static BufferedImage getDestination(ImageReadParam imageReadParam, Iterator iterator, int n2, int n3) throws IIOException {
        Object object;
        Object object2;
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("imageTypes null or empty!");
        }
        if ((long)n2 * (long)n3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("width*height > Integer.MAX_VALUE!");
        }
        BufferedImage bufferedImage = null;
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageReadParam != null) {
            bufferedImage = imageReadParam.getDestination();
            if (bufferedImage != null) {
                return bufferedImage;
            }
            imageTypeSpecifier = imageReadParam.getDestinationType();
        }
        if (imageTypeSpecifier == null) {
            object2 = iterator.next();
            if (!(object2 instanceof ImageTypeSpecifier)) {
                throw new IllegalArgumentException("Non-ImageTypeSpecifier retrieved from imageTypes!");
            }
            imageTypeSpecifier = (ImageTypeSpecifier)object2;
        } else {
            boolean bl2 = false;
            while (iterator.hasNext()) {
                object = (ImageTypeSpecifier)iterator.next();
                if (!((ImageTypeSpecifier)object).equals(imageTypeSpecifier)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw new IIOException("Destination type from ImageReadParam does not match!");
            }
        }
        object2 = new Rectangle(0, 0, 0, 0);
        object = new Rectangle(0, 0, 0, 0);
        ImageReader.computeRegions(imageReadParam, n2, n3, null, (Rectangle)object2, (Rectangle)object);
        int n4 = ((Rectangle)object).x + ((Rectangle)object).width;
        int n5 = ((Rectangle)object).y + ((Rectangle)object).height;
        return imageTypeSpecifier.createBufferedImage(n4, n5);
    }
}

