/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.security.AccessController;
import java.util.Date;
import java.util.zip.ZipConstants;
import java.util.zip.ZipOutputStream;
import sun.security.action.LoadLibraryAction;

public class ZipEntry
implements ZipConstants,
Cloneable {
    String name;
    long time = -1L;
    long crc = -1L;
    long size = -1L;
    long csize = -1L;
    int method = -1;
    byte[] extra;
    String comment;
    int flag;
    int version;
    long offset;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    private static native void initIDs();

    public ZipEntry(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() > 65535) {
            throw new IllegalArgumentException("entry name too long");
        }
        this.name = string;
    }

    public ZipEntry(ZipEntry zipEntry) {
        this.name = zipEntry.name;
        this.time = zipEntry.time;
        this.crc = zipEntry.crc;
        this.size = zipEntry.size;
        this.csize = zipEntry.csize;
        this.method = zipEntry.method;
        this.extra = zipEntry.extra;
        this.comment = zipEntry.comment;
    }

    ZipEntry(String string, long l2) {
        this.name = string;
        this.initFields(l2);
    }

    private native void initFields(long var1);

    ZipEntry(long l2) {
        this.initFields(l2);
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long l2) {
        this.time = ZipEntry.javaToDosTime(l2);
    }

    public long getTime() {
        return this.time != -1L ? ZipEntry.dosToJavaTime(this.time) : -1L;
    }

    public void setSize(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry size");
        }
        this.size = l2;
    }

    public long getSize() {
        return this.size;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public void setCompressedSize(long l2) {
        this.csize = l2;
    }

    public void setCrc(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry crc-32");
        }
        this.crc = l2;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setMethod(int n2) {
        if (n2 != 0 && n2 != 8) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = n2;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] byArray) {
        if (byArray != null && byArray.length > 65535) {
            throw new IllegalArgumentException("invalid extra field length");
        }
        this.extra = byArray;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String string) {
        if (string != null && string.length() > 21845 && ZipOutputStream.getUTF8Length(string) > 65535) {
            throw new IllegalArgumentException("invalid entry comment length");
        }
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public String toString() {
        return this.getName();
    }

    private static long dosToJavaTime(long l2) {
        Date date = new Date((int)((l2 >> 25 & 0x7FL) + 80L), (int)((l2 >> 21 & 0xFL) - 1L), (int)(l2 >> 16 & 0x1FL), (int)(l2 >> 11 & 0x1FL), (int)(l2 >> 5 & 0x3FL), (int)(l2 << 1 & 0x3EL));
        return date.getTime();
    }

    private static long javaToDosTime(long l2) {
        Date date = new Date(l2);
        int n2 = date.getYear() + 1900;
        if (n2 < 1980) {
            return 0x210000L;
        }
        return n2 - 1980 << 25 | date.getMonth() + 1 << 21 | date.getDate() << 16 | date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Object clone() {
        try {
            ZipEntry zipEntry = (ZipEntry)super.clone();
            zipEntry.extra = this.extra == null ? null : (byte[])this.extra.clone();
            return zipEntry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("zip"));
        ZipEntry.initIDs();
    }
}

