/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.util.Collection;

public class CertStore {
    private static final String CERTSTORE_TYPE = "certstore.type";
    private CertStoreSpi storeSpi;
    private Provider provider;
    private String type;
    private CertStoreParameters params;
    private static final Class cl = class$java$security$Security == null ? (class$java$security$Security = CertStore.class$("java.security.Security")) : class$java$security$Security;
    private static final Class[] GET_IMPL_PARAMS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CertStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CertStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CertStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = CertStore.class$("java.lang.Object")) : class$java$lang$Object};
    private static final Class[] GET_IMPL_PARAMS2 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CertStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CertStore.class$("java.lang.String")) : class$java$lang$String, class$java$security$Provider == null ? (class$java$security$Provider = CertStore.class$("java.security.Provider")) : class$java$security$Provider, class$java$lang$Object == null ? (class$java$lang$Object = CertStore.class$("java.lang.Object")) : class$java$lang$Object};
    private static Method implMethod;
    private static Method implMethod2;
    private static Boolean implMethod2Set;
    static /* synthetic */ Class class$java$security$Security;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$security$Provider;

    protected CertStore(CertStoreSpi certStoreSpi, Provider provider, String string, CertStoreParameters certStoreParameters) {
        this.storeSpi = certStoreSpi;
        this.provider = provider;
        this.type = string;
        if (certStoreParameters != null) {
            this.params = (CertStoreParameters)certStoreParameters.clone();
        }
    }

    public final Collection getCertificates(CertSelector certSelector) throws CertStoreException {
        return this.storeSpi.engineGetCertificates(certSelector);
    }

    public final Collection getCRLs(CRLSelector cRLSelector) throws CertStoreException {
        return this.storeSpi.engineGetCRLs(cRLSelector);
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        try {
            if (implMethod == null) {
                throw new NoSuchAlgorithmException(string + " not found");
            }
            Object[] objectArray = (Object[])implMethod.invoke(null, new Object[]{string, "CertStore", null, certStoreParameters});
            return new CertStore((CertStoreSpi)objectArray[0], (Provider)objectArray[1], string, certStoreParameters);
        }
        catch (IllegalAccessException illegalAccessException) {
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(illegalAccessException);
            throw noSuchAlgorithmException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null) {
                if (throwable instanceof InvalidAlgorithmParameterException) {
                    throw (InvalidAlgorithmParameterException)throwable;
                }
                if (throwable instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)throwable;
                }
            }
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(invocationTargetException);
            throw noSuchAlgorithmException;
        }
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters, String string2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            if (implMethod == null) {
                throw new NoSuchAlgorithmException(string + " not found");
            }
            Object[] objectArray = (Object[])implMethod.invoke(null, new Object[]{string, "CertStore", string2, certStoreParameters});
            return new CertStore((CertStoreSpi)objectArray[0], (Provider)objectArray[1], string, certStoreParameters);
        }
        catch (IllegalAccessException illegalAccessException) {
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(illegalAccessException);
            throw noSuchAlgorithmException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null) {
                if (throwable instanceof NoSuchProviderException) {
                    throw (NoSuchProviderException)throwable;
                }
                if (throwable instanceof InvalidAlgorithmParameterException) {
                    throw (InvalidAlgorithmParameterException)throwable;
                }
                if (throwable instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)throwable;
                }
            }
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(invocationTargetException);
            throw noSuchAlgorithmException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters, Provider provider) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Object[] objectArray;
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        if (!implMethod2Set.booleanValue()) {
            objectArray = implMethod2Set;
            synchronized (objectArray) {
                if (!implMethod2Set.booleanValue()) {
                    implMethod2 = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            Method method = null;
                            try {
                                method = cl.getDeclaredMethod("getImpl", GET_IMPL_PARAMS2);
                                if (method != null) {
                                    method.setAccessible(true);
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            return method;
                        }
                    });
                    implMethod2Set = new Boolean(true);
                }
            }
        }
        if (implMethod2 == null) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
        try {
            objectArray = (Object[])implMethod2.invoke(null, new Object[]{string, "CertStore", provider, certStoreParameters});
            return new CertStore((CertStoreSpi)objectArray[0], (Provider)objectArray[1], string, certStoreParameters);
        }
        catch (IllegalAccessException illegalAccessException) {
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(illegalAccessException);
            throw noSuchAlgorithmException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null) {
                if (throwable instanceof InvalidAlgorithmParameterException) {
                    throw (InvalidAlgorithmParameterException)throwable;
                }
                if (throwable instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)throwable;
                }
            }
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(invocationTargetException);
            throw noSuchAlgorithmException;
        }
    }

    public final CertStoreParameters getCertStoreParameters() {
        return this.params == null ? null : (CertStoreParameters)this.params.clone();
    }

    public final String getType() {
        return this.type;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public static final String getDefaultType() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(CertStore.CERTSTORE_TYPE);
            }
        });
        if (string == null) {
            string = "LDAP";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        implMethod2Set = new Boolean(false);
        implMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    method = cl.getDeclaredMethod("getImpl", GET_IMPL_PARAMS);
                    if (method != null) {
                        method.setAccessible(true);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return method;
            }
        });
    }
}

