/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddressImpl;
import java.net.InetAddressImplFactory;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import sun.misc.Service;
import sun.net.InetAddressCachePolicy;
import sun.net.spi.nameservice.NameService;
import sun.net.spi.nameservice.NameServiceDescriptor;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class InetAddress
implements Serializable {
    static final int IPv4 = 1;
    static final int IPv6 = 2;
    static transient boolean preferIPv6Address = false;
    String hostName;
    int address;
    int family;
    private static NameService nameService = null;
    private transient String canonicalHostName = null;
    private static final long serialVersionUID = 3286316764910316507L;
    private static LinkedHashMap addressCache;
    static InetAddress[] unknown_array;
    static InetAddressImpl impl;
    private static HashMap lookupTable;
    static /* synthetic */ Class class$sun$net$spi$nameservice$NameServiceDescriptor;

    InetAddress() {
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.hostName, this.address);
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public String getHostName() {
        return this.getHostName(true);
    }

    String getHostName(boolean bl2) {
        if (this.hostName == null) {
            this.hostName = InetAddress.getHostFromNameService(this, bl2);
        }
        return this.hostName;
    }

    public String getCanonicalHostName() {
        if (this.canonicalHostName == null) {
            this.canonicalHostName = InetAddress.getHostFromNameService(this, true);
        }
        return this.canonicalHostName;
    }

    private static String getHostFromNameService(InetAddress inetAddress, boolean bl2) {
        String string;
        try {
            InetAddress[] inetAddressArray;
            string = nameService.getHostByAddr(inetAddress.getAddress());
            if (bl2 && (inetAddressArray = System.getSecurityManager()) != null) {
                inetAddressArray.checkConnect(string, -1);
            }
            inetAddressArray = InetAddress.getAllByName0(string, bl2);
            boolean bl3 = false;
            if (inetAddressArray != null) {
                int n2 = 0;
                while (!bl3 && n2 < inetAddressArray.length) {
                    bl3 = inetAddress.equals(inetAddressArray[n2]);
                    ++n2;
                }
            }
            if (!bl3) {
                string = inetAddress.getHostAddress();
                return string;
            }
        }
        catch (SecurityException securityException) {
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string = inetAddress.getHostAddress();
        }
        return string;
    }

    public byte[] getAddress() {
        return null;
    }

    public String getHostAddress() {
        return null;
    }

    public int hashCode() {
        return -1;
    }

    public boolean equals(Object object) {
        return false;
    }

    public String toString() {
        return (this.hostName != null ? this.hostName : "") + "/" + this.getHostAddress();
    }

    private static synchronized void cacheInitIfNeeded() {
        if (addressCache != null) {
            return;
        }
        addressCache = new LinkedHashMap();
        unknown_array = new InetAddress[1];
        InetAddress.unknown_array[0] = impl.anyLocalAddress();
        String string = impl.anyLocalAddress().getHostName();
        CacheEntry cacheEntry = new CacheEntry(string, unknown_array, -1L);
        addressCache.put(string, cacheEntry);
    }

    private static void cacheAddress(String string, Object object, boolean bl2) {
        int n2;
        int n3 = n2 = bl2 ? InetAddressCachePolicy.get() : InetAddressCachePolicy.getNegative();
        if (n2 == 0) {
            return;
        }
        long l2 = -1L;
        if (n2 != -1) {
            l2 = System.currentTimeMillis() + (long)(n2 * 1000);
        }
        InetAddress.cacheAddress(string, object, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAddress(String string, Object object, long l2) {
        string = string.toLowerCase();
        InetAddress.cacheInitIfNeeded();
        LinkedHashMap linkedHashMap = addressCache;
        synchronized (linkedHashMap) {
            CacheEntry cacheEntry = (CacheEntry)addressCache.get(string);
            if (cacheEntry == null) {
                cacheEntry = new CacheEntry(string, object, l2);
                addressCache.put(string, cacheEntry);
            } else if (!cacheEntry.address.equals(object)) {
                cacheEntry.address = object;
                cacheEntry.expiration = l2;
                addressCache.remove(string);
                addressCache.put(string, cacheEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getCachedAddress(String string) {
        string = string.toLowerCase();
        if (InetAddressCachePolicy.get() == 0 && InetAddressCachePolicy.getNegative() == 0) {
            return null;
        }
        InetAddress.cacheInitIfNeeded();
        LinkedHashMap linkedHashMap = addressCache;
        synchronized (linkedHashMap) {
            Object object;
            block7: {
                Iterator iterator = addressCache.keySet().iterator();
                iterator.next();
                Vector vector = new Vector();
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    object = (CacheEntry)addressCache.get(object2);
                    if (object == null || ((CacheEntry)object).expiration >= System.currentTimeMillis() || ((CacheEntry)object).expiration < 0L) break;
                    vector.add(object2);
                }
                int n2 = 0;
                while (n2 < vector.size()) {
                    object = vector.elementAt(n2);
                    addressCache.remove(object);
                    ++n2;
                }
                object = (CacheEntry)addressCache.get(string);
                if (object != null) break block7;
                Object var6_7 = null;
                return var6_7;
            }
            Object object3 = ((CacheEntry)object).address;
            return object3;
        }
    }

    public static InetAddress getByAddress(String string, byte[] byArray) throws UnknownHostException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        if (byArray != null) {
            if (byArray.length == 4) {
                return new Inet4Address(string, byArray);
            }
            if (byArray.length == 16) {
                byte[] byArray2 = Inet6Address.convertFromIPv4MappedAddress(byArray);
                if (byArray2 != null) {
                    return new Inet4Address(string, byArray2);
                }
                return new Inet6Address(string, byArray);
            }
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        return InetAddress.getAllByName(string)[0];
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        if (string == null || string.length() == 0) {
            InetAddress[] inetAddressArray = new InetAddress[]{impl.loopbackAddress()};
            return inetAddressArray;
        }
        if (string.charAt(0) == '[') {
            if (string.charAt(string.length() - 1) == ']') {
                string = string.substring(1, string.length() - 1);
            } else {
                throw new UnknownHostException(string);
            }
        }
        if (Character.digit(string.charAt(0), 16) != -1 || string.charAt(0) == ':') {
            byte[] byArray = null;
            byArray = Inet4Address.textToNumericFormat(string);
            if (byArray == null) {
                byArray = Inet6Address.textToNumericFormat(string);
            }
            InetAddress[] inetAddressArray = new InetAddress[1];
            if (byArray != null) {
                inetAddressArray[0] = byArray.length == 4 ? new Inet4Address(null, byArray) : new Inet6Address(null, byArray);
                return inetAddressArray;
            }
        }
        return InetAddress.getAllByName0(string);
    }

    private static InetAddress[] getAllByName0(String string) throws UnknownHostException {
        return InetAddress.getAllByName0(string, true);
    }

    static InetAddress[] getAllByName0(String string, boolean bl2) throws UnknownHostException {
        SecurityManager securityManager;
        Object object = null;
        Object object2 = null;
        if (bl2 && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkConnect(string, -1);
        }
        if ((object = InetAddress.getCachedAddress(string)) == null) {
            object = InetAddress.getAddressFromNameService(string);
        }
        if (object == unknown_array) {
            throw new UnknownHostException(string);
        }
        object2 = ((InetAddress[])object).clone();
        return (InetAddress[])object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getAddressFromNameService(String string) {
        InetAddress[] inetAddressArray = null;
        boolean bl2 = false;
        inetAddressArray = InetAddress.checkLookupTable(string);
        if (inetAddressArray != null) return inetAddressArray;
        try {
            try {
                byte[][] byArray = nameService.lookupAllHostAddr(string);
                InetAddress[] inetAddressArray2 = new InetAddress[byArray.length];
                int n2 = 0;
                while (true) {
                    if (n2 >= byArray.length) {
                        inetAddressArray = inetAddressArray2;
                        bl2 = true;
                        break;
                    }
                    byte[] byArray2 = byArray[n2];
                    inetAddressArray2[n2] = byArray2.length == 4 ? new Inet4Address(string, byArray2) : new Inet6Address(string, byArray2);
                    ++n2;
                }
            }
            catch (UnknownHostException unknownHostException) {
                inetAddressArray = unknown_array;
                bl2 = false;
                Object var8_9 = null;
                InetAddress.cacheAddress(string, (Object)inetAddressArray, bl2);
                InetAddress.updateLookupTable(string);
                return inetAddressArray;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            InetAddress.cacheAddress(string, (Object)inetAddressArray, bl2);
            InetAddress.updateLookupTable(string);
            throw throwable;
        }
        InetAddress.cacheAddress(string, (Object)inetAddressArray, bl2);
        InetAddress.updateLookupTable(string);
        return inetAddressArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object checkLookupTable(String var0) {
        var1_1 = null;
        var2_2 = InetAddress.lookupTable;
        synchronized (var2_2) {
            if (InetAddress.lookupTable.containsKey(var0)) ** GOTO lbl13
            InetAddress.lookupTable.put(var0, null);
            return var1_1;
lbl-1000:
            // 1 sources

            {
                try {
                    InetAddress.lookupTable.wait();
                    continue;
                }
                catch (InterruptedException var3_4) {
                    // empty catch block
                }
lbl13:
                // 3 sources

                ** while (InetAddress.lookupTable.containsKey((Object)var0))
            }
        }
lbl14:
        // 1 sources

        var1_1 = InetAddress.getCachedAddress(var0);
        if (var1_1 != null) return var1_1;
        var3_5 = InetAddress.lookupTable;
        synchronized (var3_5) {
            InetAddress.lookupTable.put(var0, null);
            return var1_1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLookupTable(String string) {
        HashMap hashMap = lookupTable;
        synchronized (hashMap) {
            lookupTable.remove(string);
            lookupTable.notifyAll();
        }
    }

    public static InetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        return InetAddress.getByAddress(null, byArray);
    }

    public static synchronized InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager securityManager = System.getSecurityManager();
        try {
            InetAddress inetAddress = impl.localHost();
            if (securityManager != null) {
                securityManager.checkConnect(inetAddress.getHostName(), -1);
            }
            return inetAddress;
        }
        catch (SecurityException securityException) {
            return impl.loopbackAddress();
        }
    }

    private static native void init();

    static InetAddress anyLocalAddress() {
        return impl.anyLocalAddress();
    }

    static Object loadImpl(String string) {
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("impl.prefix", ""));
        Object object = null;
        try {
            object = Class.forName("java.net." + string2 + string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access class: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        if (object == null) {
            try {
                object = Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        preferIPv6Address = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv6Addresses"));
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        InetAddress.init();
        addressCache = null;
        lookupTable = new HashMap();
        new InetAddressImplFactory();
        impl = InetAddressImplFactory.create();
        String string = null;
        String string2 = "sun.net.spi.nameservice.provider.";
        int n2 = 1;
        block2: while (nameService == null) {
            string = (String)AccessController.doPrivileged(new GetPropertyAction(string2 + n2, "default"));
            ++n2;
            if (string.equals("default")) {
                nameService = new NameService(){

                    public byte[][] lookupAllHostAddr(String string) throws UnknownHostException {
                        return impl.lookupAllHostAddr(string);
                    }

                    public String getHostByAddr(byte[] byArray) throws UnknownHostException {
                        return impl.getHostByAddr(byArray);
                    }
                };
                break;
            }
            Iterator iterator = Service.providers(class$sun$net$spi$nameservice$NameServiceDescriptor == null ? InetAddress.class$("sun.net.spi.nameservice.NameServiceDescriptor") : class$sun$net$spi$nameservice$NameServiceDescriptor);
            while (iterator.hasNext()) {
                NameServiceDescriptor nameServiceDescriptor = (NameServiceDescriptor)iterator.next();
                if (!string.equalsIgnoreCase(nameServiceDescriptor.getType() + "," + nameServiceDescriptor.getProviderName())) continue;
                try {
                    nameService = nameServiceDescriptor.createNameService();
                    continue block2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("Cannot create name service:" + string);
                }
            }
        }
    }

    static final class CacheEntry {
        String hostname;
        Object address;
        long expiration;

        CacheEntry(String string, Object object, long l2) {
            this.hostname = string;
            this.address = object;
            this.expiration = l2;
        }
    }
}

