/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.math.BigInteger;
import java.util.Arrays;
import sun.awt.image.BufImgSurfaceData;

public class IndexColorModel
extends ColorModel {
    private int[] rgb;
    private int map_size;
    private int transparent_index = -1;
    private boolean allgrayopaque;
    private BigInteger validBits;
    private static final int CACHESIZE = 40;
    private int[] lookupcache = new int[40];

    private static native void initIDs();

    public IndexColorModel(int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(n2, IndexColorModel.setBits(n2, false), ColorSpace.getInstance(1000), false, false, 1, ColorModel.getDefaultTransferType(n2));
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n3, byArray, byArray2, byArray3, null);
        this.checkAllGrayOpaque();
    }

    public IndexColorModel(int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, int n4) {
        super(n2, IndexColorModel.setBits(n2, n4 >= 0), ColorSpace.getInstance(1000), n4 > -1, false, 2, ColorModel.getDefaultTransferType(n2));
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n3, byArray, byArray2, byArray3, null);
        if (n4 > -1) {
            this.transparency = 2;
            this.setTransparentPixel(n4);
        }
        this.checkAllGrayOpaque();
    }

    public IndexColorModel(int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(n2, IndexColorModel.setBits(n2, true), ColorSpace.getInstance(1000), true, false, 3, ColorModel.getDefaultTransferType(n2));
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n3, byArray, byArray2, byArray3, byArray4);
        this.setTransparentPixel(-1);
        this.checkAllGrayOpaque();
    }

    public IndexColorModel(int n2, int n3, byte[] byArray, int n4, boolean bl2) {
        this(n2, n3, byArray, n4, bl2, -1);
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
    }

    public IndexColorModel(int n2, int n3, byte[] byArray, int n4, boolean bl2, int n5) {
        super(n2, IndexColorModel.setBits(n2, bl2 || n5 > -1), ColorSpace.getInstance(1000), bl2 || n5 > -1, false, bl2 ? 3 : (n5 >= 0 ? 2 : 1), ColorModel.getDefaultTransferType(n2));
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Map size (" + n3 + ") must be >= 1");
        }
        this.map_size = n3;
        this.rgb = new int[this.calcRealMapSize(n2, n3)];
        int n6 = n4;
        int n7 = 255;
        this.transparency = 1;
        int n8 = 0;
        while (n8 < n3) {
            this.rgb[n8] = (byArray[n6++] & 0xFF) << 16 | (byArray[n6++] & 0xFF) << 8 | byArray[n6++] & 0xFF;
            if (bl2 && (n7 = byArray[n6++]) != 255 && this.transparency != 3) {
                this.transparency = n7 == 0 ? 2 : 3;
            }
            int n9 = n8++;
            this.rgb[n9] = this.rgb[n9] | n7 << 24;
        }
        this.setTransparentPixel(n5);
        if (this.transparent_index >= 0) {
            if (this.transparency == 1) {
                this.transparency = 2;
            }
        } else if (this.transparency == 1) {
            this.supportsAlpha = false;
            this.numComponents = 3;
        }
        if (this.supportsAlpha) {
            this.nBits = new int[4];
            this.nBits[3] = 8;
            this.nBits[2] = 8;
            this.nBits[1] = 8;
            this.nBits[0] = 8;
        } else {
            if (this.transparent_index > -1) {
                this.nBits = new int[4];
                this.nBits[3] = 1;
            } else {
                this.nBits = new int[3];
            }
            this.nBits[2] = 8;
            this.nBits[1] = 8;
            this.nBits[0] = 8;
        }
        this.checkAllGrayOpaque();
    }

    public IndexColorModel(int n2, int n3, int[] nArray, int n4, boolean bl2, int n5, int n6) {
        super(n2, IndexColorModel.setBits(n2, bl2), ColorSpace.getInstance(1000), bl2 ? true : n5 >= 0, false, bl2 ? 3 : (n5 >= 0 ? 2 : 1), n6);
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Map size (" + n3 + ") must be >= 1");
        }
        if (n6 != 0 && n6 != 1) {
            throw new IllegalArgumentException("transferType must be eitherDataBuffer.TYPE_BYTE or DataBuffer.TYPE_USHORT");
        }
        this.map_size = n3;
        this.rgb = new int[this.calcRealMapSize(n2, n3)];
        int n7 = n4;
        int n8 = -16777216;
        this.transparency = 1;
        if (!bl2) {
            int n9 = 0;
            while (n9 < n3) {
                this.rgb[n9] = nArray[n7] | 0xFF000000;
                ++n9;
                ++n7;
            }
        } else {
            int n10 = 0;
            while (n10 < n3) {
                this.rgb[n10] = nArray[n7];
                n8 = nArray[n7] & 0xFF000000;
                if (n8 != -16777216 && this.transparency != 3) {
                    this.transparency = n8 == 0 ? 2 : 3;
                }
                ++n10;
                ++n7;
            }
        }
        this.setTransparentPixel(n5);
        if (this.transparent_index >= 0 && this.transparency == 1) {
            this.transparency = 2;
        }
        this.checkAllGrayOpaque();
    }

    public IndexColorModel(int n2, int n3, int[] nArray, int n4, int n5, BigInteger bigInteger) {
        super(n2, IndexColorModel.setBits(n2, true), ColorSpace.getInstance(1000), true, false, 3, n5);
        int n6;
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Map size (" + n3 + ") must be >= 1");
        }
        if (n5 != 0 && n5 != 1) {
            throw new IllegalArgumentException("transferType must be eitherDataBuffer.TYPE_BYTE or DataBuffer.TYPE_USHORT");
        }
        this.map_size = n3;
        if (bigInteger != null) {
            n6 = 0;
            while (n6 < n3) {
                if (!bigInteger.testBit(n6)) {
                    this.validBits = bigInteger;
                    break;
                }
                ++n6;
            }
        }
        this.rgb = new int[this.calcRealMapSize(n2, n3)];
        n6 = n4;
        this.transparency = 1;
        int n7 = 0;
        while (n7 < n3) {
            this.rgb[n7] = nArray[n6];
            int n8 = nArray[n6] & 0xFF000000;
            if (n8 != -16777216 && this.transparency != 3) {
                this.transparency = n8 == 0 ? 2 : 3;
            }
            ++n7;
            ++n6;
        }
        this.checkAllGrayOpaque();
    }

    private void setRGBs(int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Map size (" + n2 + ") must be >= 1");
        }
        this.map_size = n2;
        this.rgb = new int[this.calcRealMapSize(this.pixel_bits, n2)];
        int n3 = 255;
        this.transparency = 1;
        int n4 = 0;
        while (n4 < n2) {
            if (byArray4 != null && (n3 = byArray4[n4] & 0xFF) != 255 && this.transparency != 3) {
                this.transparency = n3 == 0 ? 2 : 3;
            }
            this.rgb[n4] = n3 << 24 | (byArray[n4] & 0xFF) << 16 | (byArray2[n4] & 0xFF) << 8 | byArray3[n4] & 0xFF;
            ++n4;
        }
        this.nBits = new int[4];
        this.nBits[3] = 8;
        this.nBits[2] = 8;
        this.nBits[1] = 8;
        this.nBits[0] = 8;
        this.maxBits = 8;
    }

    private int calcRealMapSize(int n2, int n3) {
        int n4 = Math.max(1 << n2, n3);
        return Math.max(n4, 256);
    }

    private BigInteger getAllValid() {
        int n2 = (this.map_size + 7) / 8;
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, (byte)-1);
        byArray[0] = (byte)(255 >>> n2 * 8 - this.map_size);
        return new BigInteger(1, byArray);
    }

    private void checkAllGrayOpaque() {
        this.allgrayopaque = false;
        if (this.transparent_index >= 0 || this.transparency == 3) {
            return;
        }
        int n2 = 0;
        while (n2 < this.map_size) {
            int n3 = this.rgb[n2];
            if (n3 != 0) {
                if ((n3 & 0xFF000000) != -16777216) {
                    return;
                }
                if ((n3 >> 16 & 0xFF) != (n3 >> 8 & 0xFF) || (n3 >> 8 & 0xFF) != (n3 & 0xFF)) {
                    return;
                }
            }
            ++n2;
        }
        this.allgrayopaque = true;
        this.transparency = 1;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public int[] getComponentSize() {
        if (this.nBits == null) {
            if (this.supportsAlpha) {
                this.nBits = new int[4];
                this.nBits[3] = 8;
            } else {
                this.nBits = new int[3];
            }
            this.nBits[2] = 8;
            this.nBits[1] = 8;
            this.nBits[0] = 8;
        }
        return this.nBits;
    }

    public final int getMapSize() {
        return this.map_size;
    }

    public final int getTransparentPixel() {
        return this.transparent_index;
    }

    public final void getReds(byte[] byArray) {
        int n2 = 0;
        while (n2 < this.map_size) {
            byArray[n2] = (byte)(this.rgb[n2] >> 16);
            ++n2;
        }
    }

    public final void getGreens(byte[] byArray) {
        int n2 = 0;
        while (n2 < this.map_size) {
            byArray[n2] = (byte)(this.rgb[n2] >> 8);
            ++n2;
        }
    }

    public final void getBlues(byte[] byArray) {
        int n2 = 0;
        while (n2 < this.map_size) {
            byArray[n2] = (byte)this.rgb[n2];
            ++n2;
        }
    }

    public final void getAlphas(byte[] byArray) {
        int n2 = 0;
        while (n2 < this.map_size) {
            byArray[n2] = (byte)(this.rgb[n2] >> 24);
            ++n2;
        }
    }

    public final void getRGBs(int[] nArray) {
        System.arraycopy(this.rgb, 0, nArray, 0, this.map_size);
    }

    private void setTransparentPixel(int n2) {
        if (n2 >= this.map_size || n2 < 0) {
            n2 = -1;
        } else {
            int n3 = n2;
            this.rgb[n3] = this.rgb[n3] & 0xFFFFFF;
        }
        this.transparent_index = n2;
    }

    public final int getRed(int n2) {
        return this.rgb[n2] >> 16 & 0xFF;
    }

    public final int getGreen(int n2) {
        return this.rgb[n2] >> 8 & 0xFF;
    }

    public final int getBlue(int n2) {
        return this.rgb[n2] & 0xFF;
    }

    public final int getAlpha(int n2) {
        return this.rgb[n2] >> 24 & 0xFF;
    }

    public final int getRGB(int n2) {
        return this.rgb[n2];
    }

    public synchronized Object getDataElements(int n2, Object object) {
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        int n6 = n2 >>> 24;
        int n7 = 0;
        int n8 = 38;
        while (n8 >= 0) {
            n7 = this.lookupcache[n8];
            if (n7 == 0) break;
            if (n2 == this.lookupcache[n8 + 1]) {
                return this.installpixel(object, ~n7);
            }
            n8 -= 2;
        }
        if (this.allgrayopaque) {
            int n9 = 256;
            int n10 = (n3 * 77 + n4 * 150 + n5 * 29 + 128) / 256;
            int n11 = 0;
            while (n11 < this.map_size) {
                if (this.rgb[n11] != 0) {
                    int n12 = (this.rgb[n11] & 0xFF) - n10;
                    if (n12 < 0) {
                        n12 = -n12;
                    }
                    if (n12 < n9) {
                        n7 = n11;
                        if (n12 == 0) break;
                        n9 = n12;
                    }
                }
                ++n11;
            }
        } else if (n6 == 0) {
            if (this.transparent_index > -1) {
                n7 = this.transparent_index;
            } else {
                int n13 = 0;
                while (n13 < this.map_size) {
                    if (this.rgb[n13] < 0x1000000) {
                        this.transparent_index = n13;
                        n7 = n13;
                        break;
                    }
                    ++n13;
                }
            }
        } else {
            int n14 = 16581375;
            int n15 = 255;
            int n16 = 0;
            while (n16 < this.map_size) {
                int n17 = this.rgb[n16];
                if (n17 == n2) {
                    n7 = n16;
                    break;
                }
                int n18 = (n17 >>> 24) - n6;
                if (n18 < 0) {
                    n18 = -n18;
                }
                if (n18 <= n15) {
                    n15 = n18;
                    n18 = (n17 >> 16 & 0xFF) - n3;
                    int n19 = n18 * n18;
                    if (n19 < n14 && (n19 += (n18 = (n17 >> 8 & 0xFF) - n4) * n18) < n14 && (n19 += (n18 = (n17 & 0xFF) - n5) * n18) < n14) {
                        n7 = n16;
                        n14 = n19;
                    }
                }
                ++n16;
            }
        }
        System.arraycopy(this.lookupcache, 2, this.lookupcache, 0, 38);
        this.lookupcache[39] = n2;
        this.lookupcache[38] = ~n7;
        return this.installpixel(object, n7);
    }

    private Object installpixel(Object object, int n2) {
        switch (this.transferType) {
            case 3: {
                int[] nArray;
                if (object == null) {
                    nArray = new int[1];
                    object = nArray;
                } else {
                    nArray = (int[])object;
                }
                nArray[0] = n2;
                break;
            }
            case 0: {
                byte[] byArray;
                if (object == null) {
                    byArray = new byte[1];
                    object = byArray;
                } else {
                    byArray = (byte[])object;
                }
                byArray[0] = (byte)n2;
                break;
            }
            case 1: {
                short[] sArray;
                if (object == null) {
                    sArray = new short[1];
                    object = sArray;
                } else {
                    sArray = (short[])object;
                }
                sArray[0] = (short)n2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return object;
    }

    public int[] getComponents(int n2, int[] nArray, int n3) {
        if (nArray == null) {
            nArray = new int[n3 + this.numComponents];
        }
        nArray[n3 + 0] = this.getRed(n2);
        nArray[n3 + 1] = this.getGreen(n2);
        nArray[n3 + 2] = this.getBlue(n2);
        if (this.supportsAlpha && nArray.length - n3 > 3) {
            nArray[n3 + 3] = this.getAlpha(n2);
        }
        return nArray;
    }

    public int[] getComponents(Object object, int[] nArray, int n2) {
        int n3;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n3 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n3 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                n3 = nArray2[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getComponents(n3, nArray, n2);
    }

    public int getDataElement(int[] nArray, int n2) {
        int n3;
        int n4 = nArray[n2 + 0] << 16 | nArray[n2 + 1] << 8 | nArray[n2 + 2];
        n4 = this.supportsAlpha ? (n4 |= nArray[n2 + 3] << 24) : (n4 |= 0xFF000000);
        Object object = this.getDataElements(n4, null);
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n3 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n3 = sArray[0];
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                n3 = nArray2[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return n3;
    }

    public Object getDataElements(int[] nArray, int n2, Object object) {
        int n3 = nArray[n2 + 0] << 16 | nArray[n2 + 1] << 8 | nArray[n2 + 2];
        n3 = this.supportsAlpha ? (n3 |= nArray[n2 + 3] << 24) : (n3 &= 0xFF000000);
        return this.getDataElements(n3, object);
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        WritableRaster writableRaster;
        if (this.pixel_bits == 1 || this.pixel_bits == 2 || this.pixel_bits == 4) {
            writableRaster = Raster.createPackedRaster(0, n2, n3, 1, this.pixel_bits, null);
        } else if (this.pixel_bits <= 8) {
            writableRaster = Raster.createInterleavedRaster(0, n2, n3, 1, null);
        } else if (this.pixel_bits <= 16) {
            writableRaster = Raster.createInterleavedRaster(1, n2, n3, 1, null);
        } else {
            throw new UnsupportedOperationException("This method is not supported  for pixel bits > 16.");
        }
        return writableRaster;
    }

    public boolean isCompatibleRaster(Raster raster) {
        int n2 = raster.getSampleModel().getSampleSize(0);
        return raster.getTransferType() == this.transferType && raster.getNumBands() == 1 && 1 << n2 >= this.map_size;
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        int[] nArray = new int[]{0};
        if (this.pixel_bits == 1 || this.pixel_bits == 2 || this.pixel_bits == 4) {
            return new MultiPixelPackedSampleModel(this.transferType, n2, n3, this.pixel_bits);
        }
        return new ComponentSampleModel(this.transferType, n2, n3, 1, n2, nArray);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel) && !(sampleModel instanceof MultiPixelPackedSampleModel)) {
            return false;
        }
        if (sampleModel.getTransferType() != this.transferType) {
            return false;
        }
        return sampleModel.getNumBands() == 1;
    }

    public BufferedImage convertToIntDiscrete(Raster raster, boolean bl2) {
        if (!this.isCompatibleRaster(raster)) {
            throw new IllegalArgumentException("This raster is not compatiblewith this IndexColorModel.");
        }
        ColorModel colorModel = bl2 || this.transparency == 3 ? ColorModel.getRGBdefault() : (this.transparency == 2 ? new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000) : new DirectColorModel(24, 0xFF0000, 65280, 255));
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
        Object object = null;
        int[] nArray = null;
        int n4 = raster.getMinX();
        int n5 = raster.getMinY();
        int n6 = 0;
        while (n6 < n3) {
            nArray = (object = raster.getDataElements(n4, n5, n2, 1, object)) instanceof int[] ? (int[])object : DataBuffer.toIntArray(object);
            int n7 = 0;
            while (n7 < n2) {
                nArray[n7] = this.rgb[nArray[n7]];
                ++n7;
            }
            writableRaster.setDataElements(0, n6, n2, 1, nArray);
            ++n6;
            ++n5;
        }
        return new BufferedImage(colorModel, writableRaster, false, null);
    }

    public boolean isValid(int n2) {
        if (this.validBits == null) {
            return n2 >= 0 && n2 < this.map_size;
        }
        return n2 < this.map_size && this.validBits.testBit(n2);
    }

    public boolean isValid() {
        return this.validBits == null;
    }

    public BigInteger getValidPixels() {
        if (this.validBits == null) {
            return this.getAllValid();
        }
        return this.validBits;
    }

    private static int[] setBits(int n2, boolean bl2) {
        int[] nArray = new int[3 + (bl2 ? 1 : 0)];
        nArray[2] = 8;
        nArray[1] = 8;
        nArray[0] = 8;
        if (bl2) {
            nArray[3] = 8;
        }
        return nArray;
    }

    public void finalize() {
        BufImgSurfaceData.freeNativeICMData(this);
    }

    public String toString() {
        return new String("IndexColorModel: #pixelBits = " + this.pixel_bits + " numComponents = " + this.numComponents + " color space = " + this.colorSpace + " transparency = " + this.transparency + " transIndex   = " + this.transparent_index + " has alpha = " + this.supportsAlpha + " isAlphaPre = " + this.isAlphaPremultiplied);
    }

    static {
        ColorModel.loadLibraries();
        IndexColorModel.initIDs();
    }
}

