/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Printer;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.AudioFileWriter;

abstract class SunFileWriter
extends AudioFileWriter {
    private static SunFileWriter[] fileWriters;
    protected static final int bufferSize = 16384;
    protected static final int bisBufferSize = 4096;
    private static final String[] fileWriterClassNames;
    final AudioFileFormat.Type[] types;
    private static JSSecurity jsSecurity;
    private static boolean securityPrivilege;
    private static Method[] m;
    private static Class[] cl;
    private static Object[][] args;

    SunFileWriter(AudioFileFormat.Type[] typeArray) {
        this.types = typeArray;
    }

    public AudioFileFormat.Type[] getAudioFileTypes() {
        AudioFileFormat.Type[] typeArray = new AudioFileFormat.Type[this.types.length];
        System.arraycopy(this.types, 0, typeArray, 0, this.types.length);
        return typeArray;
    }

    public abstract AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream var1);

    public abstract int write(AudioInputStream var1, AudioFileFormat.Type var2, OutputStream var3) throws IOException;

    public abstract int write(AudioInputStream var1, AudioFileFormat.Type var2, File var3) throws IOException;

    static int getNumFileWriters() {
        return fileWriters.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SunFileWriter getFileWriter(int n2) {
        SunFileWriter[] sunFileWriterArray = fileWriters;
        synchronized (sunFileWriterArray) {
            block10: {
                try {
                    if (fileWriters[n2] == null) {
                        Class clazz = Class.forName(fileWriterClassNames[n2]);
                        SunFileWriter.fileWriters[n2] = (SunFileWriter)clazz.newInstance();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (Printer.err) {
                        Printer.err("ClassNotFoundException: " + classNotFoundException);
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (Printer.err) {
                        Printer.err("InstantiationException: " + instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!Printer.err) break block10;
                    Printer.err("IllegalAccessException: " + illegalAccessException);
                }
            }
        }
        return fileWriters[n2];
    }

    protected static RandomAccessFile openRandomAccessFile(File file) throws IOException {
        RandomAccessFile randomAccessFile;
        block9: {
            randomAccessFile = null;
            if (!securityPrivilege) {
                try {
                    jsSecurity = JSSecurityManager.getJSSecurity();
                    securityPrivilege = true;
                }
                catch (SecurityException securityException) {
                    if (!Printer.err) break block9;
                    Printer.err("SunParser.java: Security Exception: " + securityException);
                }
            }
        }
        if (securityPrivilege && jsSecurity != null) {
            if (jsSecurity.getName().startsWith("JDK12")) {
                randomAccessFile = new RandomAccessFile(file, "rw");
            } else {
                block10: {
                    try {
                        jsSecurity.requestPermission(m, cl, args, 2);
                        m[0].invoke(cl[0], args[0]);
                        jsSecurity.requestPermission(m, cl, args, 4);
                        m[0].invoke(cl[0], args[0]);
                    }
                    catch (Exception exception) {
                        if (!Printer.err) break block10;
                        Printer.err("Unable to get file privileges: " + exception);
                    }
                }
                randomAccessFile = new RandomAccessFile(file, "rw");
            }
        } else {
            randomAccessFile = new RandomAccessFile(file, "rw");
        }
        return randomAccessFile;
    }

    protected int rllong(DataInputStream dataInputStream) throws IOException {
        int n2 = 0;
        n2 = dataInputStream.readInt();
        int n3 = (n2 & 0xFF) << 24;
        int n4 = (n2 & 0xFF00) << 8;
        int n5 = (n2 & 0xFF0000) >> 8;
        int n6 = (n2 & 0xFF000000) >>> 24;
        n2 = n3 | n4 | n5 | n6;
        return n2;
    }

    protected int big2little(int n2) {
        int n3 = (n2 & 0xFF) << 24;
        int n4 = (n2 & 0xFF00) << 8;
        int n5 = (n2 & 0xFF0000) >> 8;
        int n6 = (n2 & 0xFF000000) >>> 24;
        n2 = n3 | n4 | n5 | n6;
        return n2;
    }

    protected short rlshort(DataInputStream dataInputStream) throws IOException {
        short s2 = 0;
        s2 = dataInputStream.readShort();
        short s3 = (short)((s2 & 0xFF) << 8);
        short s4 = (short)((s2 & 0xFF00) >>> 8);
        s2 = (short)(s3 | s4);
        return s2;
    }

    protected short big2littleShort(short s2) {
        short s3 = (short)((s2 & 0xFF) << 8);
        short s4 = (short)((s2 & 0xFF00) >>> 8);
        s2 = (short)(s3 | s4);
        return s2;
    }

    static {
        fileWriterClassNames = new String[]{"com.sun.media.sound.AuFileWriter", "com.sun.media.sound.WaveFileWriter", "com.sun.media.sound.AiffFileWriter"};
        fileWriters = new SunFileWriter[fileWriterClassNames.length];
        jsSecurity = null;
        securityPrivilege = false;
        m = new Method[1];
        cl = new Class[1];
        args = new Object[1][0];
    }
}

