/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DisabledSecurity;
import com.sun.media.sound.JDK12;
import com.sun.media.sound.JDK12NewEventDispatcherAction;
import com.sun.media.sound.JDK12TopmostThreadGroupAction;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Printer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

class EventDispatcher
implements Runnable {
    private Vector eventQueue = new Vector();
    private boolean done = false;
    Thread thread = null;
    static boolean creatingThread = false;
    private static JSSecurity jsSecurity = null;
    private static boolean securityPrivilege = false;
    private static ThreadGroup topmostThreadGroup = null;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    EventDispatcher() {
    }

    private static void initSecurity() {
        securityPrivilege = true;
        if (Printer.debug) {
            Printer.debug("EventDispatcher.initSecurity(): securityPrivilege = " + securityPrivilege);
        }
        try {
            jsSecurity = JSSecurityManager.getJSSecurity();
        }
        catch (SecurityException securityException) {
            if (Printer.debug) {
                Printer.debug("Exception caught: " + securityException);
            }
            if (Printer.debug) {
                Printer.debug("Setting securityPrivilege to false");
            }
            securityPrivilege = false;
        }
        if (securityPrivilege) {
            if (Printer.debug) {
                Printer.debug("EventDispatcher.java: getting the real topmost thread group");
            }
            if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity != null && jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        Constructor constructor = JDK12TopmostThreadGroupAction.cons;
                        topmostThreadGroup = (ThreadGroup)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[0])});
                        if (Printer.debug) {
                            Printer.debug("Got topmost thread group with 1.2 style security");
                        }
                    }
                    catch (Exception exception) {
                        if (Printer.debug) {
                            Printer.debug("Exception getting topmost thread group with 1.2 style security");
                        }
                        topmostThreadGroup = EventDispatcher.getTopmostThreadGroup();
                    }
                } else {
                    topmostThreadGroup = EventDispatcher.getTopmostThreadGroup();
                }
            }
        } else {
            if (Printer.debug) {
                Printer.debug("EventDispatcher.java: no securityPrivilege, settling for current threadgroup");
            }
            topmostThreadGroup = Thread.currentThread().getThreadGroup();
        }
    }

    void start() {
        if (this.thread == null && !creatingThread || this.done) {
            EventDispatcher.initSecurity();
            EventDispatcher eventDispatcher = this;
            this.done = false;
            if (securityPrivilege && jsSecurity != null) {
                if (jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        creatingThread = true;
                        Constructor constructor = JDK12NewEventDispatcherAction.cons;
                        Object[] objectArray = new Object[]{topmostThreadGroup, eventDispatcher};
                        this.thread = (Thread)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(objectArray)});
                        if (Printer.debug) {
                            Printer.debug("Got EventDispatcher with 1.2 style security");
                        }
                        creatingThread = false;
                    }
                    catch (InstantiationException instantiationException) {
                        if (Printer.debug) {
                            Printer.debug("InstantiationException getting event dispatcher with 1.2 style security: " + instantiationException);
                        }
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (Printer.debug) {
                            Printer.debug("IllegalAccessException getting event dispatcher with 1.2 style security: " + illegalAccessException);
                        }
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (Printer.debug) {
                            Printer.debug("InvocationTargetException getting event dispatcher with 1.2 style security: " + invocationTargetException);
                        }
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                } else {
                    block23: {
                        try {
                            jsSecurity.requestPermission(this.m, this.cl, this.args, 16);
                            this.m[0].invoke(this.cl[0], this.args[0]);
                            if (Printer.debug) {
                                Printer.debug("EventDispatcher.start(): got THREAD permission");
                            }
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            if (Printer.debug) {
                                Printer.debug("EventDispatcher.start(): could not got THREAD permission");
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if (!Printer.debug) break block23;
                            Printer.debug("EventDispatcher.start(): could not got THREAD permission");
                        }
                    }
                    this.thread = new Thread(topmostThreadGroup, this);
                    this.thread.start();
                }
            } else {
                if (Printer.debug) {
                    Printer.debug("EventDispatcher.start(): no securityPrivilege or jsSecurity==null, not using security");
                }
                this.thread = new Thread(topmostThreadGroup, this);
                this.thread.start();
            }
            if (this.thread != null) {
                try {
                    this.thread.setName("Java Sound event dispatcher");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (Printer.debug) {
                    Printer.debug("Created thread in group " + this.thread.getThreadGroup());
                }
            }
        }
    }

    protected void processEvent(EventInfo eventInfo) {
        if (eventInfo.getEvent() instanceof LineEvent) {
            LineEvent lineEvent = (LineEvent)eventInfo.getEvent();
            Vector vector = eventInfo.getListeners();
            if (Printer.debug) {
                Printer.debug("Sending " + lineEvent + " to " + vector.size() + " listeners");
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                ((LineListener)vector.elementAt(n2)).update(lineEvent);
                ++n2;
            }
            return;
        }
        if (eventInfo.getEvent() instanceof MetaMessage) {
            MetaMessage metaMessage = (MetaMessage)eventInfo.getEvent();
            Vector vector = eventInfo.getListeners();
            int n3 = 0;
            while (n3 < vector.size()) {
                ((MetaEventListener)vector.elementAt(n3)).meta(metaMessage);
                ++n3;
            }
            return;
        }
        if (eventInfo.getEvent() instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)eventInfo.getEvent();
            int n4 = shortMessage.getStatus();
            if (n4 >> 4 == 11) {
                Vector vector = eventInfo.getListeners();
                int n5 = 0;
                while (n5 < vector.size()) {
                    ((ControllerEventListener)vector.elementAt(n5)).controlChange(shortMessage);
                    ++n5;
                }
            }
            return;
        }
        Printer.err("Unknown event type: " + eventInfo.getEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvents() {
        EventInfo eventInfo = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            block8: {
                try {
                    while (!this.done && this.eventQueue.size() == 0) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.done = true;
                    this.notifyAll();
                    if (!Printer.debug) break block8;
                    interruptedException.printStackTrace();
                }
            }
            if (!this.done) {
                eventInfo = (EventInfo)this.eventQueue.elementAt(0);
                this.eventQueue.removeElementAt(0);
            }
        }
        if (eventInfo != null) {
            this.processEvent(eventInfo);
        }
    }

    synchronized void postEvent(EventInfo eventInfo) {
        this.eventQueue.addElement(eventInfo);
        this.notifyAll();
    }

    synchronized void kill() {
        this.done = true;
        this.notifyAll();
    }

    public void run() {
        while (!this.done) {
            this.dispatchEvents();
        }
        if (Printer.debug) {
            Printer.debug("Exiting Java Sound EventDispatcher thread.");
        }
    }

    void sendAudioEvents(Object object, Vector vector) {
        this.start();
        Vector vector2 = (Vector)vector.clone();
        EventInfo eventInfo = new EventInfo(object, vector2);
        this.postEvent(eventInfo);
    }

    private static ThreadGroup getTopmostThreadGroup() {
        if (Printer.trace) {
            Printer.trace(">> EventDispatcher: getTopmostThreadGroup()");
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        if (Printer.trace) {
            Printer.trace("<< EventDispatcher: getTopmostThreadGroup() completed");
        }
        return threadGroup;
    }

    class EventInfo {
        private Object event;
        private Vector listeners;

        EventInfo(Object object, Vector vector) {
            this.event = object;
            this.listeners = vector;
        }

        Object getEvent() {
            return this.event;
        }

        Vector getListeners() {
            return this.listeners;
        }
    }
}

