/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.Printer;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;

abstract class AbstractMixer
extends AbstractDataLine
implements Mixer {
    protected static final int PCM = 0;
    protected static final int ULAW = 1;
    protected static final int ALAW = 2;
    private final Mixer.Info mixerInfo;
    protected Line.Info[] sourceLineInfo;
    protected Line.Info[] targetLineInfo;
    protected Vector formats = new Vector();
    protected Vector sourceLines = new Vector();
    protected Vector targetLines = new Vector();

    protected AbstractMixer(DataLine.Info info, Control[] controlArray, AudioFormat audioFormat, int n2, Mixer.Info info2, Line.Info[] infoArray, Line.Info[] infoArray2) {
        super(info, null, controlArray, audioFormat, n2);
        this.mixer = this;
        if (controlArray == null) {
            controlArray = new Control[]{};
        }
        this.mixerInfo = info2;
        this.sourceLineInfo = infoArray;
        this.targetLineInfo = infoArray2;
    }

    public Mixer.Info getMixerInfo() {
        return this.mixerInfo;
    }

    public Line.Info[] getSourceLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.sourceLineInfo.length];
        System.arraycopy(this.sourceLineInfo, 0, infoArray, 0, this.sourceLineInfo.length);
        return infoArray;
    }

    public Line.Info[] getTargetLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.targetLineInfo.length];
        System.arraycopy(this.targetLineInfo, 0, infoArray, 0, this.targetLineInfo.length);
        return infoArray;
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n2])) {
                vector.addElement(this.sourceLineInfo[n2]);
            }
            ++n2;
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        n2 = 0;
        while (n2 < infoArray.length) {
            infoArray[n2] = (Line.Info)vector.elementAt(n2);
            ++n2;
        }
        return infoArray;
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n2])) {
                vector.addElement(this.targetLineInfo[n2]);
            }
            ++n2;
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        n2 = 0;
        while (n2 < infoArray.length) {
            infoArray[n2] = (Line.Info)vector.elementAt(n2);
            ++n2;
        }
        return infoArray;
    }

    public boolean isLineSupported(Line.Info info) {
        int n2 = 0;
        while (n2 < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n2])) {
                return true;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public abstract Line getLine(Line.Info var1) throws LineUnavailableException;

    public abstract int getMaxLines(Line.Info var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line[] getSourceLines() {
        Line[] lineArray;
        Vector vector = this.sourceLines;
        synchronized (vector) {
            lineArray = new Line[this.sourceLines.size()];
            int n2 = 0;
            while (n2 < lineArray.length) {
                lineArray[n2] = (Line)this.sourceLines.elementAt(n2);
                ++n2;
            }
        }
        return lineArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line[] getTargetLines() {
        Line[] lineArray;
        Vector vector = this.targetLines;
        synchronized (vector) {
            lineArray = new Line[this.targetLines.size()];
            int n2 = 0;
            while (n2 < lineArray.length) {
                lineArray[n2] = (Line)this.targetLines.elementAt(n2);
                ++n2;
            }
        }
        return lineArray;
    }

    public void synchronize(Line[] lineArray, boolean bl2) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public void unsynchronize(Line[] lineArray) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public boolean isSynchronizationSupported(Line[] lineArray, boolean bl2) {
        return false;
    }

    public synchronized void open(AudioFormat audioFormat, int n2) throws LineUnavailableException {
        AudioFormat audioFormat2;
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open(format = " + audioFormat + "), bufferSize = " + n2);
        }
        if ((audioFormat2 = AbstractMixer.getSystemFormat()) != null && !audioFormat.matches(audioFormat2)) {
            throw new LineUnavailableException("Requested format incompatible with already established device format: " + audioFormat2);
        }
        super.open(audioFormat, n2);
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open(format = " + audioFormat + "), bufferSize = " + n2 + " succeeded");
        }
    }

    public synchronized void open() throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open()");
        }
        try {
            this.open(this.format, this.bufferSize);
        }
        catch (LineUnavailableException lineUnavailableException) {
            AudioFormat audioFormat = null;
            audioFormat = AbstractMixer.getSystemFormat();
            if (audioFormat != null) {
                this.open(audioFormat, -1);
            }
            throw lineUnavailableException;
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open() succeeded");
        }
    }

    protected void open(Line line) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open(line = " + line + ")");
        }
        if (this.equals(line)) {
            if (Printer.trace) {
                Printer.trace("<< AbstractMixer: open(" + line + ") nothing done");
            }
            return;
        }
        if (this.isSourceLine(line.getLineInfo())) {
            if (!this.sourceLines.contains(line)) {
                this.open();
                this.sourceLines.addElement(line);
            }
        } else if (this.isTargetLine(line.getLineInfo())) {
            if (!this.targetLines.contains(line)) {
                this.open();
                this.targetLines.addElement(line);
            }
        } else if (Printer.err) {
            Printer.err("Unknown line received for AbstractMixer.open(Line): " + line);
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open(" + line + ") completed");
        }
    }

    protected void open(DataLine dataLine, AudioFormat audioFormat, int n2) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open(line = " + dataLine + ", format, bufferSize)");
        }
        this.open(dataLine);
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open(line, format, bufferSize) completed");
        }
    }

    protected void close(Line line) {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: close(" + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (Printer.debug) {
            Printer.debug("AbstractMixer: close(line): sourceLines.size() now: " + this.sourceLines.size());
        }
        if (Printer.debug) {
            Printer.debug("AbstractMixer: close(line): targetLines.size() now: " + this.targetLines.size());
        }
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty()) {
            this.close();
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: close(" + line + ") succeeded");
        }
    }

    protected void start(Line line) {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: start(" + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        if (!this.isStartedRunning()) {
            if (Printer.debug) {
                Printer.debug("AbstractMixer: start(line): starting the mixer");
            }
            this.start();
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: start(" + line + ") succeeded");
        }
    }

    protected void stop(Line line) {
        Object object;
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: stop(" + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        Vector vector = (Vector)this.sourceLines.clone();
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) instanceof AbstractDataLine && ((AbstractDataLine)(object = (AbstractDataLine)vector.elementAt(n2))).isStartedRunning() && !object.equals(line)) {
                return;
            }
            ++n2;
        }
        object = (Vector)this.targetLines.clone();
        int n3 = 0;
        while (n3 < ((Vector)object).size()) {
            AbstractDataLine abstractDataLine = (AbstractDataLine)((Vector)object).elementAt(n3);
            if (abstractDataLine.isStartedRunning() && !abstractDataLine.equals(line)) {
                if (Printer.trace) {
                    Printer.trace("<< AbstractMixer: stop(" + line + ") found running targetLine: " + abstractDataLine);
                }
                return;
            }
            ++n3;
        }
        if (Printer.debug) {
            Printer.debug("AbstractMixer: stop(line): stopping the mixer");
        }
        this.stop();
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: stop(" + line + ") succeeded");
        }
    }

    boolean isSourceLine(Line.Info info) {
        int n2 = 0;
        while (n2 < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isTargetLine(Line.Info info) {
        int n2 = 0;
        while (n2 < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    Line.Info getLineInfo(Line.Info info) {
        int n2 = 0;
        while (n2 < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n2])) {
                return this.sourceLineInfo[n2];
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n2])) {
                return this.targetLineInfo[n2];
            }
            ++n2;
        }
        return null;
    }

    static AudioFormat getSystemFormat() {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n2 = 0;
        while (n2 < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n2]);
            if (mixer.isOpen() && mixer instanceof DataLine) {
                return ((DataLine)((Object)mixer)).getFormat();
            }
            ++n2;
        }
        return null;
    }
}

