/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.core;

import com.sun.corba.se.internal.corba.INSSubcontract;
import com.sun.corba.se.internal.core.ClientSubcontract;
import com.sun.corba.se.internal.core.INSObjectKeyEntry;
import com.sun.corba.se.internal.core.INSObjectKeyMap;
import com.sun.corba.se.internal.core.ServerSubcontract;
import com.sun.corba.se.internal.ior.IIOPProfileTemplate;
import com.sun.corba.se.internal.ior.IORTemplate;
import com.sun.corba.se.internal.ior.ObjectKey;
import com.sun.corba.se.internal.ior.ObjectKeyTemplate;
import com.sun.corba.se.internal.ior.WireObjectKeyTemplate;
import java.util.Iterator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;

public class SubcontractRegistry {
    protected ORB orb;
    protected int size;
    protected ServerSubcontract[] serverRegistry;
    protected Class[] clientFactory;
    protected int defaultId;
    private INSSubcontract insSubcontract = null;
    protected ServerSubcontract bootstrapServer = null;

    public void dumpServers() {
        System.out.println("Dump of registered server subcontracts:");
        int n2 = 0;
        while (n2 < this.serverRegistry.length) {
            ServerSubcontract serverSubcontract = this.serverRegistry[n2];
            if (serverSubcontract != null) {
                System.out.println("serverRegistry[" + n2 + "] = " + serverSubcontract);
            }
            ++n2;
        }
    }

    public SubcontractRegistry(ORB oRB, int n2) {
        this(oRB, n2, 256);
    }

    public SubcontractRegistry(ORB oRB, int n2, int n3) {
        this.orb = oRB;
        this.size = n3;
        this.defaultId = n2;
        this.serverRegistry = new ServerSubcontract[n3];
        this.clientFactory = new Class[n3];
    }

    public synchronized boolean registerClient(Class clazz, int n2) {
        if (n2 < this.size) {
            this.clientFactory[n2] = clazz;
            return true;
        }
        return false;
    }

    public synchronized boolean registerServer(ServerSubcontract serverSubcontract, int n2) {
        if (n2 < this.size) {
            this.serverRegistry[n2] = serverSubcontract;
            return true;
        }
        return false;
    }

    public void registerBootstrapServer(ServerSubcontract serverSubcontract) {
        this.bootstrapServer = serverSubcontract;
    }

    public ServerSubcontract getServerSubcontract(int n2) {
        ServerSubcontract serverSubcontract = null;
        if (n2 >= 0 && n2 < this.size) {
            serverSubcontract = this.serverRegistry[n2];
        }
        if (serverSubcontract == null) {
            return this.serverRegistry[this.defaultId];
        }
        return serverSubcontract;
    }

    public ServerSubcontract getServerSubcontract(ObjectKey objectKey) {
        ObjectKeyTemplate objectKeyTemplate = objectKey.getTemplate();
        if (objectKeyTemplate instanceof WireObjectKeyTemplate) {
            String string = new String(objectKey.getBytes(this.orb));
            if (string.equals("INIT") || string.equals("TINI")) {
                return this.bootstrapServer;
            }
            INSObjectKeyEntry iNSObjectKeyEntry = INSObjectKeyMap.getInstance().getEntry(string);
            if (iNSObjectKeyEntry != null) {
                return this.getINSSubcontract();
            }
        } else {
            int n2 = objectKeyTemplate.getSubcontractId();
            return this.getServerSubcontract(n2);
        }
        throw new INTERNAL(1398079690, CompletionStatus.COMPLETED_NO);
    }

    private synchronized INSSubcontract getINSSubcontract() {
        if (this.insSubcontract == null) {
            this.insSubcontract = new INSSubcontract(this.orb);
        }
        return this.insSubcontract;
    }

    public ClientSubcontract getClientSubcontract(ObjectKey objectKey) {
        return this.getClientSubcontract(objectKey.getTemplate());
    }

    public ClientSubcontract getClientSubcontract(IORTemplate iORTemplate) {
        if (iORTemplate.size() != 1) {
            throw new INTERNAL(1398079691, CompletionStatus.COMPLETED_NO);
        }
        Iterator iterator = iORTemplate.iteratorById(0);
        Object object = iterator.next();
        if (!(object instanceof IIOPProfileTemplate)) {
            throw new INTERNAL(1398079693, CompletionStatus.COMPLETED_NO);
        }
        IIOPProfileTemplate iIOPProfileTemplate = (IIOPProfileTemplate)object;
        return this.getClientSubcontract(iIOPProfileTemplate.getObjectKeyTemplate());
    }

    public ClientSubcontract getClientSubcontract(ObjectKeyTemplate objectKeyTemplate) {
        int n2 = objectKeyTemplate.getSubcontractId();
        return this.getClientSubcontract(n2);
    }

    public ClientSubcontract getClientSubcontract(int n2) {
        Class clazz = null;
        ClientSubcontract clientSubcontract = null;
        if (n2 >= 0 && n2 < this.size) {
            clazz = this.clientFactory[n2];
        }
        if (clazz == null) {
            n2 = this.defaultId;
            clazz = this.clientFactory[n2];
        }
        try {
            clientSubcontract = (ClientSubcontract)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new INTERNAL(1398079692, CompletionStatus.COMPLETED_NO);
        }
        clientSubcontract.setId(n2);
        return clientSubcontract;
    }
}

