/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import sun.applet.AppletClassLoader;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.TrustDecider;
import sun.plugin.usability.ProgressTracker;
import sun.plugin.usability.Trace;
import sun.security.action.GetPropertyAction;

public class PluginClassLoader
extends AppletClassLoader {
    private static RuntimePermission usePolicyPermission;
    private URL base;
    private HashMap JARJARtoJAR = new HashMap();

    public PluginClassLoader(URL uRL) {
        super(uRL);
        this.base = uRL;
    }

    public URL getBaseURL() {
        return this.base;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        PermissionCollection permissionCollection2 = null;
        Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        permissionCollection2 = policy.getPermissions(codeSource);
        permissionCollection.add(new RuntimePermission("accessClassInPackage.sun.audio"));
        permissionCollection.add(new PropertyPermission("browser", "read"));
        permissionCollection.add(new PropertyPermission("browser.version", "read"));
        permissionCollection.add(new PropertyPermission("browser.vendor", "read"));
        permissionCollection.add(new PropertyPermission("http.agent", "read"));
        permissionCollection.add(new PropertyPermission("javaplugin.version", "read"));
        permissionCollection.add(new PropertyPermission("javaplugin.proxy.config.type", "read"));
        permissionCollection.add(new PropertyPermission("javaplugin.proxy.config.list", "read"));
        permissionCollection.add(new PropertyPermission("javaplugin.proxy.config.bypass", "read"));
        if (usePolicyPermission == null) {
            usePolicyPermission = new RuntimePermission("usePolicy");
        }
        if (!permissionCollection2.implies(usePolicyPermission) && codeSource.getCertificates() != null) {
            try {
                if (TrustDecider.isAllPermissionGranted(codeSource)) {
                    permissionCollection.add(new AllPermission());
                }
            }
            catch (CertificateExpiredException certificateExpiredException) {
                Trace.securityPrintException(certificateExpiredException, ResourceHandler.getMessage("rsa.cert_expired"), ResourceHandler.getMessage("security_dialog.caption"));
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                Trace.securityPrintException(certificateNotYetValidException, ResourceHandler.getMessage("rsa.cert_notyieldvalid"), ResourceHandler.getMessage("security_dialog.caption"));
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception, ResourceHandler.getMessage("rsa.general_error"), ResourceHandler.getMessage("security_dialog.caption"));
            }
        }
        String string = AccessController.doPrivileged(new GetPropertyAction("java.home"));
        String string2 = string + File.separator + "lib" + File.separator + "applet" + File.separator;
        permissionCollection.add(new FilePermission(string2 + "*", "read"));
        return permissionCollection;
    }

    public void addMyJar(URL uRL) {
        this.addURL(uRL);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Trace.println(ResourceHandler.getMessage("applet.progress.loadClass") + string, 4);
        return super.findClass(string);
    }

    public URL findResource(String string) {
        if (string != null && string.indexOf("META-INF/services/javax.sound") == -1) {
            Trace.println(ResourceHandler.getMessage("applet.progress.loadResource") + string, 4);
        }
        return super.findResource(string);
    }

    public Enumeration findResources(String string) throws IOException {
        if (string != null && string.indexOf("META-INF/services/javax.sound") == -1) {
            Trace.println(ResourceHandler.getMessage("applet.progress.loadResource") + string, 4);
        }
        return this.findResourcesByURLPath(string);
    }

    private Enumeration findResourcesByURLPath(String string) throws IOException {
        if (string != null && string.indexOf("META-INF/services/javax.sound") != -1) {
            return new Enumeration(){

                public Object nextElement() {
                    throw new NoSuchElementException();
                }

                public boolean hasMoreElements() {
                    return false;
                }
            };
        }
        return super.findResources(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addJar(String string) throws IOException {
        block18: {
            if (!string.toUpperCase().endsWith(".JARJAR") || !this.base.getProtocol().equalsIgnoreCase("file")) break block18;
            String string2 = this.base.toString() + string;
            if (this.JARJARtoJAR.containsKey(string2)) return;
            ZipFile zipFile = null;
            File file = null;
            boolean bl = false;
            try {
                block19: {
                    boolean bl2;
                    FileOutputStream fileOutputStream;
                    FilterOutputStream filterOutputStream;
                    BufferedInputStream bufferedInputStream;
                    block17: {
                        zipFile = new JarFile(this.base.getPath() + string, true);
                        Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                        int n = 0;
                        if (!enumeration.hasMoreElements()) {
                            throw new IOException("Invalid jarjar file");
                        }
                        JarEntry jarEntry = null;
                        while (enumeration.hasMoreElements()) {
                            jarEntry = enumeration.nextElement();
                            if (jarEntry.toString().toUpperCase().startsWith("META-INF/")) continue;
                            if (!jarEntry.toString().toUpperCase().endsWith(".JAR")) {
                                throw new IOException("Invalid entry in jarjar file.");
                            }
                            if (++n > 1) break;
                        }
                        if (n > 1) {
                            jarEntry = null;
                            throw new IOException("Multiple JAR files inside JARJAR file");
                        }
                        byte[] byArray = new byte[8192];
                        bufferedInputStream = null;
                        filterOutputStream = null;
                        fileOutputStream = null;
                        InputStream inputStream = ((JarFile)zipFile).getInputStream(jarEntry);
                        bl2 = false;
                        try {
                            URL uRL;
                            int n2;
                            file = File.createTempFile(jarEntry.toString().substring(0, jarEntry.toString().lastIndexOf(46)), ".jar");
                            Trace.println(ResourceHandler.getMessage("pluginclassloader.created_file") + file.getPath(), 2);
                            ProgressTracker.onProgressComplete(this.base.toString() + string);
                            bufferedInputStream = new BufferedInputStream(inputStream);
                            fileOutputStream = new FileOutputStream(file);
                            filterOutputStream = new BufferedOutputStream(fileOutputStream);
                            while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
                            }
                            ((BufferedOutputStream)filterOutputStream).flush();
                            this.JARJARtoJAR.put(this.base.toString() + string, file);
                            bl2 = true;
                            try {
                                uRL = file.toURL();
                            }
                            catch (MalformedURLException malformedURLException) {
                                throw new IllegalArgumentException("name");
                            }
                            this.addURL(uRL);
                            Object var19_18 = null;
                            if (bufferedInputStream == null) break block17;
                        }
                        catch (Throwable throwable) {
                            Object var19_19 = null;
                            if (bufferedInputStream != null) {
                                bufferedInputStream.close();
                            }
                            if (filterOutputStream != null) {
                                filterOutputStream.close();
                            }
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                            bufferedInputStream = null;
                            filterOutputStream = null;
                            fileOutputStream = null;
                            if (bl2) throw throwable;
                            Trace.println(file.getName() + ResourceHandler.getMessage("pluginclassloader.empty_file"), 2);
                            if (file == null) throw throwable;
                            file.delete();
                            throw throwable;
                        }
                        bufferedInputStream.close();
                    }
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    bufferedInputStream = null;
                    filterOutputStream = null;
                    fileOutputStream = null;
                    if (bl2) break block19;
                    Trace.println(file.getName() + ResourceHandler.getMessage("pluginclassloader.empty_file"), 2);
                    if (file != null) {
                        file.delete();
                    }
                }
                Object var21_21 = null;
                if (zipFile == null) return;
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            zipFile.close();
            return;
        }
        super.addJar(string);
        if (!this.base.getProtocol().equalsIgnoreCase("file")) return;
        ProgressTracker.onProgressComplete(this.base.toString() + string);
    }

    protected void release() {
        if (!this.JARJARtoJAR.isEmpty()) {
            Trace.println(ResourceHandler.getMessage("pluginclassloader.deleting_files"), 2);
            Set set = this.JARJARtoJAR.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                File file = (File)this.JARJARtoJAR.get(k);
                if (file == null) continue;
                Trace.println(ResourceHandler.getMessage("pluginclassloader.file") + file.getPath(), 2);
                file.delete();
            }
            this.JARJARtoJAR.clear();
        }
        super.release();
    }
}

