/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.ZipConstants;

public class ZipEntry
implements ZipConstants,
Cloneable {
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    String comment;
    long compressedSize;
    long crc;
    byte[] extra;
    int method;
    String name;
    long size;
    long time;
    long relativeOffset;
    ZipEntry next;
    private static final short[] daysToMonthStart = new short[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};

    private /* synthetic */ void finit$() {
        this.compressedSize = -1;
        this.crc = -1;
        this.method = -1;
        this.size = -1;
        this.time = -1;
        this.relativeOffset = -1;
    }

    public ZipEntry(String name) {
        this.finit$();
        if (name.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public ZipEntry(ZipEntry ent) {
        this.finit$();
        this.comment = ent.comment;
        this.compressedSize = ent.compressedSize;
        this.crc = ent.crc;
        this.extra = ent.extra;
        this.method = ent.method;
        this.name = ent.name;
        this.size = ent.size;
        this.time = ent.time;
        this.relativeOffset = ent.relativeOffset;
    }

    public Object clone() {
        ZipEntry clone = new ZipEntry(this);
        clone.extra = (byte[])this.extra.clone();
        return clone;
    }

    public String getComment() {
        return this.comment;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getCrc() {
        return this.crc;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public int getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isDirectory() {
        int nlen;
        return this.name != null && (nlen = this.name.length()) > 0 && this.name.charAt(nlen - 1) == '/';
    }

    public void setComment(String comment) {
        if (comment != null && comment.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = comment;
    }

    public void setCompressedSize(long compressedSize) {
        if (compressedSize < 0L || compressedSize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.compressedSize = compressedSize;
    }

    public void setCrc(long crc) {
        if (crc < 0L || crc > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.crc = crc;
    }

    public void setExtra(byte[] extra) {
        if (extra != null && extra.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = extra;
    }

    public void setMethod(int method) {
        if (method != 8 && method != 0) {
            throw new IllegalArgumentException();
        }
        this.method = method;
    }

    public void setSize(long size) {
        if (size < 0L || size > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.size = size;
    }

    public void setTime(long time) {
        this.time = time;
    }

    static long timeFromDOS(int date, int time) {
        int sec = 2 * (time & 0x1F);
        int min = time >> 5 & 0x3F;
        int hrs = time >> 11 & 0x1F;
        int day = date & 0x1F;
        int mon = (date >> 5 & 0xF) - 1;
        int year = (date >> 9 & 0x7F) + 10;
        if (mon < 0 || mon > 11) {
            return -1;
        }
        long mtime = ((hrs * 60 + min) * 60 + sec) * 1000;
        int days = 365 * year + (year + 1 >> 2);
        days += daysToMonthStart[mon];
        if ((year & 3) == 0 && mon > 1) {
            ++days;
        }
        return ((long)((days += day) * 24 * 60) * (long)60 + (long)((hrs * 60 + min) * 60) + (long)sec) * (long)1000;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

