/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.PlainDatagramSocketImpl;
import java.net.SocketException;
import java.net.UnknownHostException;

public class DatagramSocket {
    DatagramSocketImpl impl;

    public DatagramSocket() throws SocketException {
        this(0, null);
    }

    public DatagramSocket(int port) throws SocketException {
        this(port, null);
    }

    public DatagramSocket(int port, InetAddress laddr) throws SocketException {
        String propVal;
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkListen(port);
        }
        if ((propVal = System.getProperty("impl.prefix")) == null || propVal.equals("")) {
            this.impl = new PlainDatagramSocketImpl();
        } else {
            try {
                this.impl = (DatagramSocketImpl)Class.forName("java.net." + propVal + "DatagramSocketImpl").newInstance();
            }
            catch (Exception e) {
                System.err.println("Could not instantiate class: java.net." + propVal + "DatagramSocketImpl");
                this.impl = new PlainDatagramSocketImpl();
            }
        }
        this.impl.create();
        if (this instanceof MulticastSocket) {
            this.impl.setOption(4, new Boolean(true));
        }
        this.impl.bind(port, laddr == null ? InetAddress.ANY_IF : laddr);
    }

    public void close() {
        this.impl.close();
    }

    public InetAddress getLocalAddress() {
        SecurityManager s = System.getSecurityManager();
        try {
            return (InetAddress)this.impl.getOption(15);
        }
        catch (SocketException ex) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException ex2) {
                return null;
            }
        }
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public synchronized int getSoTimeout() throws SocketException {
        Object timeout = this.impl.getOption(4102);
        if (timeout instanceof Integer) {
            return (Integer)timeout;
        }
        return 0;
    }

    public synchronized void receive(DatagramPacket p) throws IOException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkAccept(p.getAddress().getHostAddress(), p.getPort());
        }
        this.impl.receive(p);
    }

    public void send(DatagramPacket p) throws IOException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            InetAddress addr = p.getAddress();
            if (addr.isMulticastAddress()) {
                s.checkMulticast(addr);
            } else {
                s.checkConnect(addr.getHostAddress(), p.getPort());
            }
        }
        this.impl.send(p);
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + timeout);
        }
        this.impl.setOption(4102, new Integer(timeout));
    }

    public int getReceiveBufferSize() throws SocketException {
        Object obj = this.impl.getOption(4098);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new SocketException("Unexpected type");
    }

    public int getSendBufferSize() throws SocketException {
        Object obj = this.impl.getOption(4097);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new SocketException("Unexpected type");
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (size < 0) {
            throw new IllegalArgumentException("Buffer size is less than 0");
        }
        this.impl.setOption(4098, new Integer(size));
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (size < 0) {
            throw new IllegalArgumentException("Buffer size is less than 0");
        }
        this.impl.setOption(4097, new Integer(size));
    }
}

