/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;

    public FileOutputStream(String path, boolean append) throws SecurityException, FileNotFoundException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkWrite(path);
        }
        this.fd = new FileDescriptor(path, append ? 4 : 2);
    }

    public FileOutputStream(String path) throws SecurityException, FileNotFoundException {
        this(path, false);
    }

    public FileOutputStream(File file) throws SecurityException, FileNotFoundException {
        this(file.getPath(), false);
    }

    public FileOutputStream(FileDescriptor fdObj) throws SecurityException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkWrite(fdObj);
        }
        this.fd = fdObj;
    }

    protected void finalize() throws IOException {
    }

    public final FileDescriptor getFD() throws IOException {
        if (!this.fd.valid()) {
            throw new IOException();
        }
        return this.fd;
    }

    public void write(int b) throws IOException {
        this.fd.write(b);
    }

    public void write(byte[] b) throws IOException, NullPointerException {
        this.fd.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException, NullPointerException, IndexOutOfBoundsException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.fd.write(b, off, len);
    }

    public void close() throws IOException {
        if (this.fd.valid()) {
            this.fd.close();
        }
    }
}

