/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public class TypeSignature {
    public static String getEncodingOfClass(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unknown primitive class " + clazz);
        }
        if (clazz.isArray()) {
            return '[' + TypeSignature.getEncodingOfClass(clazz.getComponentType());
        }
        String classname = clazz.getName();
        int name_len = classname.length();
        char[] buf = new char[name_len + 2];
        buf[0] = 76;
        classname.getChars(0, name_len, buf, 1);
        for (int i = 1; i <= name_len; ++i) {
            if (buf[i] != '.') continue;
            buf[i] = 47;
        }
        buf[i] = 59;
        return new String(buf);
    }

    public static Class getClassForEncoding(String type_code) throws ClassNotFoundException {
        if (type_code.equals("B")) {
            return Byte.TYPE;
        }
        if (type_code.equals("C")) {
            return Character.TYPE;
        }
        if (type_code.equals("D")) {
            return Double.TYPE;
        }
        if (type_code.equals("F")) {
            return Float.TYPE;
        }
        if (type_code.equals("I")) {
            return Integer.TYPE;
        }
        if (type_code.equals("J")) {
            return Long.TYPE;
        }
        if (type_code.equals("S")) {
            return Short.TYPE;
        }
        if (type_code.equals("Z")) {
            return Boolean.TYPE;
        }
        if (type_code.charAt(0) == 'L') {
            return Class.forName(type_code.substring(1, type_code.length() - 1).replace('/', '.'));
        }
        if (type_code.charAt(0) == '[') {
            int last_bracket = type_code.lastIndexOf(91);
            String brackets = type_code.substring(0, last_bracket + 1);
            String component = type_code.substring(last_bracket + 1);
            if (component.charAt(0) == 'L') {
                component = component.replace('/', '.');
            }
            return Class.forName(brackets + component);
        }
        throw new ClassNotFoundException("Type code cannot be parsed as a valid class name");
    }

    public static String getEncodingOfMethod(Method m) {
        String returnEncoding = TypeSignature.getEncodingOfClass(m.getReturnType());
        Class[] paramTypes = m.getParameterTypes();
        String[] paramEncodings = new String[paramTypes.length];
        int size = 2;
        for (int i = 0; i < paramTypes.length; ++i) {
            String paramEncoding = TypeSignature.getEncodingOfClass(paramTypes[i]);
            size += paramEncoding.length();
            paramEncodings[i] = paramEncoding;
        }
        StringBuffer buf = new StringBuffer(size += returnEncoding.length());
        buf.append('(');
        for (int i = 0; i < paramTypes.length; ++i) {
            buf.append(paramEncodings[i]);
        }
        buf.append(')');
        buf.append(returnEncoding);
        return buf.toString();
    }

    public static String getEncodingOfConstructor(Constructor c) {
        Class[] paramTypes = c.getParameterTypes();
        String[] paramEncodings = new String[paramTypes.length];
        int size = 3;
        for (int i = 0; i < paramTypes.length; ++i) {
            String paramEncoding = TypeSignature.getEncodingOfClass(paramTypes[i]);
            size += paramEncoding.length();
            paramEncodings[i] = paramEncoding;
        }
        StringBuffer buf = new StringBuffer(size);
        buf.append('(');
        for (int i = 0; i < paramTypes.length; ++i) {
            buf.append(paramEncodings[i]);
        }
        buf.append(")V");
        return buf.toString();
    }

    public static String getEncodingOfMember(Member mem) {
        if (mem instanceof Constructor) {
            return TypeSignature.getEncodingOfConstructor((Constructor)mem);
        }
        if (mem instanceof Method) {
            return TypeSignature.getEncodingOfMethod((Method)mem);
        }
        return TypeSignature.getEncodingOfClass(((Field)mem).getType());
    }
}

