/*
 * RealAudio Lossless decoder
 *
 * Copyright (c) 2012 Konstantin Shishkov
 *
 * This file is part of Libav.
 *
 * Libav is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Libav is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Libav; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVCODEC_RALFDATA_H
#define AVCODEC_RALFDATA_H

#include <stdint.h>

#define FILTERPARAM_ELEMENTS   643
#define BIAS_ELEMENTS          255
#define CODING_MODE_ELEMENTS   140
#define FILTER_COEFFS_ELEMENTS  43
#define SHORT_CODES_ELEMENTS   169
#define LONG_CODES_ELEMENTS    441

static const uint8_t filter_param_def[3][324] = {
  {
    0x48, 0x86, 0x66, 0x8A, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB4, 0x54, 0x45,
    0x66, 0x88, 0xAA, 0xAB, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x65, 0x45, 0x55, 0x66, 0x77, 0x78,
    0x99, 0x99, 0xAA, 0xAB, 0xBB, 0xBC, 0xCB, 0xBF, 0xFF, 0xCF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xF9, 0x86, 0x55, 0x55, 0x55, 0x66, 0x67, 0x77, 0x88, 0x88, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0x9B, 0xBB, 0xCB, 0xBB, 0xCC, 0xCC,
    0xCF, 0xFF, 0xCC, 0xCF, 0xFC, 0xBC, 0xCC, 0xFB, 0xB9, 0xFC, 0xA8, 0x76,
    0x66, 0x56, 0x66, 0x67, 0x67, 0x77, 0x78, 0x88, 0x88, 0x89, 0x88, 0x89,
    0x99, 0x99, 0x9A, 0x9A, 0x9A, 0x9A, 0xAA, 0xAA, 0xAA, 0xAA, 0x9A, 0xA9,
    0xAB, 0xA9, 0xA9, 0x98, 0x86, 0xFF, 0xCA, 0x88, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x88, 0x88, 0x88, 0x88, 0x99, 0x99, 0x99, 0x98, 0x99, 0x99, 0x9A,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x98, 0x88, 0x87,
    0x65, 0xFF, 0xFB, 0xAA, 0xA9, 0x88, 0x88, 0x89, 0x99, 0x98, 0x99, 0x9A,
    0xA9, 0x9A, 0xA9, 0xAA, 0xA9, 0x9A, 0xAA, 0xA9, 0xAA, 0xA9, 0x99, 0x99,
    0xA9, 0x9A, 0x99, 0x99, 0x99, 0x98, 0x88, 0x77, 0x64, 0xFF, 0xFF, 0xFC,
    0xBB, 0xBA, 0xB9, 0xAA, 0xAB, 0xAA, 0xAA, 0xBA, 0xAB, 0xAB, 0xAB, 0xCB,
    0xBA, 0xAB, 0xBB, 0xBB, 0xAA, 0xBA, 0xAA, 0xAA, 0xAA, 0xA9, 0xAA, 0x99,
    0x99, 0x99, 0x88, 0x87, 0x64, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCB, 0xBB, 0xBC, 0xBB, 0xCC, 0xFB, 0xCC, 0xCF, 0xCF,
    0xCC, 0xFC, 0xFC, 0xCF, 0xCB, 0xCC, 0xBB, 0xBB, 0xCB, 0xBB, 0xAA, 0x99,
    0x86, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xB8, 0xA0, 0x00, 0x00,
  }, {
    0xFB, 0x95, 0x67, 0x8B, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x55, 0x56,
    0x77, 0x89, 0xBA, 0xBB, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB8, 0x65, 0x55, 0x55, 0x56, 0x77, 0x78,
    0x89, 0x9A, 0xAA, 0xAA, 0xBC, 0xBC, 0xCB, 0xBC, 0xCF, 0xCF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFB, 0x86, 0x55, 0x55, 0x55, 0x55, 0x56, 0x67, 0x77, 0x77, 0x88,
    0x89, 0x9A, 0x99, 0x99, 0xAA, 0xBB, 0xBB, 0xAB, 0xBF, 0xCB, 0xFA, 0xCC,
    0xFC, 0xEC, 0xEF, 0xFB, 0xBC, 0xFF, 0xBC, 0xBB, 0xA9, 0xFF, 0x98, 0x76,
    0x66, 0x66, 0x65, 0x66, 0x66, 0x76, 0x77, 0x77, 0x77, 0x88, 0x88, 0x88,
    0x89, 0x99, 0x99, 0x99, 0x99, 0xA9, 0x99, 0x99, 0x9A, 0x99, 0x99, 0xAA,
    0xAA, 0xA9, 0x99, 0x98, 0x76, 0xFF, 0xF9, 0x87, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x99, 0x99, 0x89, 0x99,
    0x99, 0x99, 0x99, 0x89, 0x99, 0x99, 0x99, 0x98, 0x99, 0x98, 0x77, 0x77,
    0x65, 0xFF, 0xCA, 0xA9, 0x99, 0x89, 0x88, 0x88, 0x98, 0x89, 0x99, 0x98,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0x99, 0x99, 0xA9, 0x9A, 0xA9, 0x99, 0x99,
    0x99, 0x99, 0xA9, 0x99, 0x99, 0x98, 0x88, 0x77, 0x64, 0xFF, 0xCB, 0xA9,
    0xA9, 0xAA, 0xAA, 0xAA, 0x9A, 0xAB, 0xAA, 0x9A, 0xBB, 0xAB, 0xAB, 0xBB,
    0xAB, 0xBA, 0xBB, 0xBA, 0xAA, 0xBA, 0xBA, 0xAA, 0xAA, 0xA9, 0xA9, 0x99,
    0x99, 0x99, 0x88, 0x77, 0x64, 0xFF, 0xFF, 0xFF, 0xBC, 0xFB, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBA, 0xBA, 0xAB, 0xBF, 0xCB, 0xBB, 0xBB, 0xBC, 0xBF, 0xCC,
    0xCB, 0xCB, 0xCC, 0xBB, 0xBB, 0xFB, 0xCB, 0xBC, 0xCA, 0xBC, 0xAA, 0xA9,
    0x86, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFC, 0xFF, 0xFF, 0xCF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xF0, 0x00, 0x00,
  }, {
    0x9B, 0x65, 0x67, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB5, 0x54, 0x56,
    0x67, 0x88, 0xA9, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0x65, 0x44, 0x45, 0x56, 0x67, 0x78,
    0x89, 0x99, 0xA9, 0xAA, 0xBB, 0xBB, 0xAB, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xF9, 0x76, 0x55, 0x54, 0x55, 0x55, 0x56, 0x67, 0x77, 0x77, 0x88,
    0x89, 0x99, 0x98, 0x99, 0x8A, 0x99, 0xBB, 0xAB, 0xBC, 0xAB, 0xBA, 0xAA,
    0xBB, 0xCB, 0xCC, 0xBB, 0xCC, 0xBB, 0xAC, 0xBA, 0x97, 0xFB, 0x97, 0x76,
    0x66, 0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x88, 0x88, 0x88, 0x88,
    0x99, 0x89, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9A, 0x98, 0x99, 0x99,
    0xA9, 0x99, 0x88, 0x87, 0x65, 0xFF, 0xCA, 0x98, 0x87, 0x77, 0x77, 0x87,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x88, 0x87, 0x77,
    0x64, 0xFF, 0xFC, 0xCA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0x99, 0xAA, 0x9A,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0x99, 0x99, 0x99, 0x89, 0x88, 0x87, 0x64, 0xFF, 0xFF, 0xFB,
    0xFF, 0xBC, 0xFC, 0xBB, 0xCB, 0xBB, 0xCA, 0xCB, 0xBC, 0xCC, 0xBF, 0xBC,
    0xBB, 0xBB, 0xBE, 0xBC, 0xCB, 0xCC, 0xBB, 0xFC, 0xBC, 0xCC, 0xAB, 0xCB,
    0xAB, 0xBB, 0xAA, 0xA9, 0x97, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xCF, 0xFB,
    0xCC, 0xFC, 0xCF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
  }
};

static const uint8_t bias_def[3][128] = {
  {
    0x4A, 0xAA, 0xAA, 0xAA, 0xBA, 0xBA, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xAA, 0xAB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x9A, 0xA9, 0xA9,
    0x99, 0xA9, 0x99, 0x99, 0xA9, 0xA9, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x88, 0x98, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x77, 0x78, 0x77, 0x77, 0x77, 0x77, 0x66, 0x66, 0x66, 0x55, 0x55, 0x55,
    0x55, 0x54, 0x44, 0x32, 0x44, 0x55, 0x55, 0x66, 0x66, 0x66, 0x66, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x87, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x89, 0x88, 0x89, 0x89, 0x99, 0x99, 0x98, 0x99, 0x9A,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xA9, 0x9A, 0x99, 0x9A, 0xA9, 0xA9, 0xA9,
    0xAA, 0xAA, 0xA9, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xAA, 0xAA, 0xAA,
    0xAA, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBA, 0x40,
  }, {
    0x4C, 0xBC, 0xAC, 0xBC, 0xBA, 0xAB, 0xAB, 0xBB, 0xBA, 0xAA, 0xAB, 0xAA,
    0xBB, 0xAA, 0xBB, 0xAA, 0xAB, 0xBA, 0xBA, 0xAA, 0xBB, 0xAA, 0xA9, 0xAA,
    0xBB, 0xAA, 0xAA, 0x9A, 0x9A, 0xAA, 0xA9, 0xAA, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x98, 0x98, 0x98, 0x89, 0x88, 0x88, 0x88, 0x88,
    0x87, 0x78, 0x77, 0x77, 0x77, 0x77, 0x67, 0x66, 0x66, 0x55, 0x44, 0x45,
    0x54, 0x44, 0x44, 0x33, 0x44, 0x45, 0x55, 0x56, 0x66, 0x66, 0x66, 0x67,
    0x77, 0x77, 0x77, 0x77, 0x87, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x99, 0x88, 0x99, 0x99, 0x89, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xA9,
    0xA9, 0xAA, 0x9A, 0xA9, 0xAA, 0x9A, 0xAA, 0x9A, 0xAA, 0xAB, 0xAA, 0xAA,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xBB, 0xBA, 0xAA, 0xAB, 0xAB, 0xAA,
    0xAB, 0xAB, 0xAC, 0xBB, 0xAA, 0xBB, 0xBB, 0x40,
  }, {
    0x5B, 0xBB, 0xBC, 0xBB, 0xCB, 0xCC, 0xBB, 0xBB, 0xBC, 0xCC, 0xBB, 0xCB,
    0xBA, 0xCB, 0xBC, 0xBB, 0xAA, 0xBB, 0xAB, 0xBA, 0xBB, 0xBB, 0xAB, 0xBB,
    0xAA, 0xBA, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA9, 0x9A,
    0x9A, 0x99, 0x9A, 0x99, 0x99, 0x99, 0x99, 0x99, 0x98, 0x98, 0x89, 0x99,
    0x88, 0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x66, 0x66, 0x55,
    0x54, 0x44, 0x43, 0x22, 0x34, 0x44, 0x55, 0x56, 0x66, 0x66, 0x67, 0x77,
    0x77, 0x77, 0x87, 0x88, 0x88, 0x88, 0x88, 0x88, 0x99, 0x89, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x9A, 0x9A, 0xA9, 0xA9, 0x9A, 0x9A, 0xAA, 0x9A, 0xAA,
    0xAA, 0xAA, 0xBA, 0xAA, 0xAA, 0xAA, 0xBA, 0xAA, 0xAA, 0xAB, 0xBA, 0xBB,
    0xAA, 0xBB, 0xAB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC,
    0xBB, 0xBC, 0xBB, 0xBB, 0xCC, 0xBC, 0xCB, 0x50,
  }
};

static const uint8_t coding_mode_def[3][72] = {
  {
    0xAA, 0x99, 0xAC, 0xB9, 0xBD, 0xAA, 0x7A, 0xA8, 0xA8, 0xA8, 0x79, 0x79,
    0x77, 0xA8, 0x97, 0x79, 0x89, 0x77, 0x87, 0x87, 0x68, 0x78, 0x66, 0x86,
    0x87, 0x67, 0x68, 0x66, 0x76, 0x76, 0x57, 0x67, 0x55, 0x75, 0x65, 0x56,
    0x56, 0x55, 0x65, 0x65, 0x56, 0x45, 0x55, 0x54, 0x55, 0x55, 0x45, 0x55,
    0x54, 0x55, 0x55, 0x45, 0x56, 0x64, 0x66, 0x76, 0x57, 0x67, 0x77, 0x77,
    0x98, 0x88, 0x9D, 0xBF, 0xBA, 0xEC, 0xFC, 0xBA, 0xEF, 0xFC, 0x00, 0x00,
  }, {
    0xCF, 0x9B, 0xAF, 0xFF, 0xFF, 0xAB, 0x8A, 0x98, 0xB8, 0xF9, 0x78, 0x89,
    0x77, 0xF9, 0xF7, 0x79, 0x89, 0x77, 0x97, 0x97, 0x68, 0x68, 0x66, 0xA6,
    0x87, 0x77, 0x68, 0x66, 0x75, 0x76, 0x67, 0x56, 0x65, 0x75, 0x75, 0x56,
    0x56, 0x55, 0x65, 0x65, 0x56, 0x56, 0x55, 0x54, 0x55, 0x55, 0x45, 0x55,
    0x53, 0x55, 0x65, 0x35, 0x67, 0x64, 0x66, 0x66, 0x56, 0x78, 0x86, 0x88,
    0xA8, 0xFB, 0xAF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  }, {
    0xDC, 0xAD, 0xCC, 0xCA, 0xCF, 0xFE, 0xDF, 0xFF, 0xE9, 0xFF, 0x99, 0x79,
    0x97, 0x97, 0x97, 0x79, 0x79, 0x77, 0x97, 0x97, 0x79, 0x79, 0x77, 0x86,
    0x87, 0x68, 0x68, 0x76, 0x76, 0x76, 0x67, 0x57, 0x66, 0x65, 0x76, 0x66,
    0x56, 0x55, 0x64, 0x65, 0x55, 0x45, 0x55, 0x54, 0x55, 0x55, 0x35, 0x55,
    0x53, 0x55, 0x65, 0x35, 0x67, 0x64, 0x67, 0x87, 0x57, 0x8A, 0x86, 0x8B,
    0xBA, 0x9A, 0xCD, 0xAA, 0xAF, 0xFC, 0xFF, 0xFF, 0xDF, 0xFF, 0x00, 0x00,
  }
};

static const uint8_t filter_coeffs_def[3][10][11][24] = {
 {
  {
   {
    0x47, 0x88, 0x76, 0x52, 0x12, 0x35, 0x44, 0x43, 0x34, 0x45, 0x77, 0x67,
    0x66, 0x87, 0x87, 0x7D, 0x8A, 0x89, 0x9D, 0xDD, 0x9C, 0xC0, 0x00, 0x00,
   },
   {
    0x7C, 0xCC, 0xC7, 0x65, 0xCC, 0x22, 0x23, 0x46, 0x32, 0x22, 0x46, 0x7B,
    0xB6, 0xBB, 0xBB, 0xBC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xC0, 0x00, 0x00,
   },
   {
    0xBB, 0xBB, 0xB4, 0x43, 0x25, 0x5B, 0x5A, 0xAB, 0x5B, 0x22, 0x22, 0x2B,
    0xBA, 0xAA, 0x46, 0x5B, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0, 0x00, 0x00,
   },
   {
    0x99, 0x89, 0x88, 0x89, 0x31, 0x88, 0x88, 0x89, 0x88, 0x38, 0x88, 0x13,
    0x28, 0x88, 0x88, 0x28, 0x88, 0x88, 0x88, 0x88, 0x99, 0x90, 0x00, 0x00,
   },
   {
    0x99, 0x89, 0x88, 0x89, 0x88, 0x88, 0x88, 0x39, 0x98, 0x88, 0x88, 0x88,
    0x08, 0x88, 0x88, 0x81, 0x99, 0x88, 0x99, 0x99, 0x99, 0x20, 0x00, 0x00,
   },
   {
    0xAA, 0xD9, 0x86, 0xCD, 0xDD, 0xDD, 0x98, 0x76, 0x43, 0x65, 0x35, 0x63,
    0x23, 0x44, 0x33, 0x24, 0x45, 0x44, 0x45, 0x59, 0xA8, 0x90, 0x00, 0x00,
   },
   {
    0x99, 0x89, 0x88, 0x89, 0x98, 0x88, 0x88, 0x89, 0x98, 0x08, 0x88, 0x88,
    0x28, 0x88, 0x88, 0x83, 0x19, 0x98, 0x88, 0x99, 0x99, 0x90, 0x00, 0x00,
   },
   {
    0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA5, 0xA4, 0x01, 0x4A, 0xAA,
    0x53, 0x4A, 0xA4, 0xAA, 0x5A, 0xAA, 0xAA, 0xAA, 0xAA, 0xB0, 0x00, 0x00,
   },
   {
    0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x9A, 0xAA, 0xA3, 0x31, 0x31,
    0x34, 0x34, 0xA9, 0xA5, 0x44, 0x4A, 0xAA, 0xAA, 0xAA, 0xA0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xED, 0xDE, 0xEE, 0xED, 0xDD, 0xDE, 0xE8, 0xEE, 0xE7, 0x64,
    0x47, 0x43, 0x30, 0x43, 0x43, 0x36, 0x7E, 0xEE, 0xEE, 0x90, 0x00, 0x00,
   },
   {
    0x67, 0x87, 0x87, 0x66, 0x65, 0x55, 0x44, 0x45, 0x65, 0x54, 0x54, 0x32,
    0x34, 0x66, 0x63, 0x55, 0x44, 0x54, 0x34, 0x45, 0x56, 0x60, 0x00, 0x00,
   },
  },
  {
   {
    0x56, 0x66, 0x65, 0x54, 0x33, 0x34, 0x33, 0x33, 0x33, 0x34, 0x44, 0x45,
    0x56, 0x66, 0x67, 0x77, 0x77, 0x77, 0x78, 0x89, 0x89, 0x60, 0x00, 0x00,
   },
   {
    0x78, 0x89, 0x98, 0x65, 0x65, 0x32, 0x22, 0x32, 0x33, 0x33, 0x45, 0x77,
    0x77, 0x8B, 0x9A, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xF0, 0x00, 0x00,
   },
   {
    0x9D, 0xD8, 0x8D, 0x57, 0x56, 0x55, 0x44, 0x45, 0x22, 0x22, 0x23, 0x34,
    0x57, 0x78, 0x88, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD0, 0x00, 0x00,
   },
   {
    0xDC, 0xCC, 0x8C, 0xCC, 0x87, 0x65, 0x55, 0x54, 0x23, 0x44, 0x21, 0x23,
    0x46, 0x56, 0x87, 0x7C, 0x8C, 0x8C, 0xCC, 0xCC, 0xCC, 0xD0, 0x00, 0x00,
   },
   {
    0xDD, 0xCD, 0xCC, 0xCD, 0xDC, 0xC7, 0x64, 0x58, 0x31, 0x25, 0x33, 0x22,
    0x44, 0x56, 0x66, 0x6D, 0xDD, 0xDD, 0xDC, 0xDC, 0xDC, 0xD0, 0x00, 0x00,
   },
   {
    0xB9, 0x99, 0xA6, 0x67, 0x78, 0x76, 0x78, 0x88, 0x66, 0x55, 0x44, 0x43,
    0x23, 0x33, 0x33, 0x33, 0x34, 0x45, 0x56, 0x66, 0x88, 0xB0, 0x00, 0x00,
   },
   {
    0xDD, 0xCD, 0xDC, 0xCD, 0xDC, 0xCC, 0x77, 0xC5, 0x53, 0x12, 0x23, 0x33,
    0x33, 0x46, 0x65, 0x75, 0x8D, 0xDD, 0xDD, 0xDC, 0xDC, 0xD0, 0x00, 0x00,
   },
   {
    0xDD, 0xCD, 0xCC, 0xCD, 0xDC, 0xCC, 0x8C, 0x85, 0x55, 0x33, 0x21, 0x23,
    0x33, 0x44, 0x56, 0x56, 0x56, 0x8D, 0xDD, 0xCC, 0xDC, 0xD0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xDD, 0xDE, 0xDD, 0xDD, 0xDD, 0x87, 0x75, 0x55, 0x43, 0x22,
    0x21, 0x25, 0x65, 0x55, 0x66, 0x77, 0xD8, 0x8D, 0xDD, 0x90, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xAA, 0x98, 0x77, 0x55, 0x43,
    0x33, 0x33, 0x21, 0x33, 0x34, 0x66, 0x89, 0xAF, 0xFF, 0xC0, 0x00, 0x00,
   },
   {
    0x57, 0x77, 0x76, 0x66, 0x65, 0x55, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x33, 0x44, 0x43, 0x44, 0x44, 0x45, 0x56, 0x66, 0x77, 0x50, 0x00, 0x00,
   },
  },
  {
   {
    0x57, 0x76, 0x66, 0x65, 0x44, 0x44, 0x43, 0x33, 0x33, 0x33, 0x33, 0x34,
    0x45, 0x56, 0x67, 0x77, 0x77, 0x89, 0x88, 0x89, 0x99, 0x60, 0x00, 0x00,
   },
   {
    0x8A, 0x99, 0x88, 0x77, 0x66, 0x44, 0x43, 0x32, 0x32, 0x22, 0x33, 0x45,
    0x67, 0x89, 0xEB, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFB, 0xBA, 0xA7, 0x78, 0x66, 0x65, 0x54, 0x22, 0x21, 0x23, 0x44,
    0x56, 0x8A, 0x9E, 0xAF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xAF, 0xFD, 0xDF, 0xAC, 0x98, 0x77, 0x66, 0x44, 0x31, 0x11, 0x35,
    0x67, 0x88, 0x8A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xEF, 0xEE, 0xEF, 0xA8, 0x8E, 0x97, 0x66, 0x43, 0x22, 0x21, 0x23,
    0x45, 0x67, 0x97, 0x7F, 0xFF, 0xEE, 0xE9, 0xEE, 0xEE, 0xF0, 0x00, 0x00,
   },
   {
    0xAA, 0xA9, 0x97, 0x65, 0x45, 0x45, 0x67, 0x66, 0x55, 0x54, 0x44, 0x44,
    0x33, 0x33, 0x33, 0x33, 0x44, 0x45, 0x56, 0x68, 0x8B, 0xB0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xED, 0xDE, 0xED, 0xDD, 0xD8, 0x77, 0x65, 0x43, 0x11, 0x22,
    0x34, 0x66, 0x78, 0x87, 0xEE, 0xEE, 0xEE, 0x9D, 0xED, 0xE0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xDC, 0xFF, 0xAE, 0xEA, 0x98, 0x76, 0x54, 0x31, 0x11,
    0x34, 0x56, 0x88, 0x99, 0x9B, 0xFF, 0xFF, 0xBF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xCF, 0xDF, 0xFF, 0xFD, 0x9A, 0x76, 0x65, 0x43, 0x21,
    0x12, 0x35, 0x56, 0x67, 0x89, 0x99, 0xAF, 0xAF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFE, 0xEF, 0xDB, 0xBA, 0xAA, 0x99, 0x76, 0x55, 0x43, 0x22,
    0x22, 0x33, 0x33, 0x44, 0x55, 0x67, 0x8A, 0xFA, 0xFB, 0xA0, 0x00, 0x00,
   },
   {
    0x57, 0x77, 0x77, 0x66, 0x65, 0x55, 0x54, 0x44, 0x44, 0x44, 0x43, 0x33,
    0x33, 0x34, 0x44, 0x44, 0x55, 0x55, 0x66, 0x77, 0x88, 0x60, 0x00, 0x00,
   },
  },
  {
   {
    0x58, 0x77, 0x76, 0x66, 0x55, 0x54, 0x44, 0x33, 0x33, 0x23, 0x33, 0x33,
    0x45, 0x56, 0x66, 0x77, 0x88, 0x88, 0x88, 0x88, 0x99, 0x60, 0x00, 0x00,
   },
   {
    0x9A, 0xA9, 0xA9, 0x88, 0x76, 0x55, 0x44, 0x33, 0x22, 0x22, 0x23, 0x45,
    0x56, 0x99, 0x9D, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFD, 0xBB, 0xAA, 0xBA, 0xA9, 0x87, 0x77, 0x54, 0x33, 0x21, 0x12, 0x45,
    0x68, 0x8A, 0xAA, 0xCB, 0xFF, 0xCF, 0xFF, 0xFF, 0xFE, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xEF, 0xFE, 0xA9, 0x98, 0x87, 0x65, 0x41, 0x02, 0x45,
    0x77, 0x88, 0xAC, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xBF, 0xFC, 0xAB, 0xFB, 0xBA, 0xAB, 0xB8, 0x88, 0x76, 0x52, 0x01, 0x35,
    0x78, 0x99, 0xAB, 0xAA, 0xCF, 0xBB, 0xCF, 0xFC, 0xFC, 0xF0, 0x00, 0x00,
   },
   {
    0xBA, 0xCA, 0x98, 0x75, 0x21, 0x35, 0x77, 0x77, 0x76, 0x65, 0x54, 0x44,
    0x44, 0x34, 0x44, 0x44, 0x45, 0x56, 0x78, 0x88, 0x9A, 0xC0, 0x00, 0x00,
   },
   {
    0xDF, 0xCF, 0xCC, 0xFF, 0xAB, 0xC9, 0xB9, 0x98, 0x97, 0x75, 0x20, 0x13,
    0x56, 0x89, 0x89, 0xAA, 0xFC, 0xBC, 0xAF, 0xCC, 0xFF, 0xD0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xBB, 0xFB, 0xFF, 0xFB, 0xBA, 0xA8, 0x77, 0x54, 0x21, 0x11,
    0x45, 0x67, 0x88, 0x8A, 0xEF, 0xBB, 0xFF, 0xBB, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFB, 0xCB, 0xB9, 0x88, 0x65, 0x31, 0x12,
    0x23, 0x35, 0x67, 0x88, 0xAA, 0xAC, 0xFC, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFC, 0xEF, 0xFF, 0xBB, 0xAA, 0xA9, 0x76, 0x55, 0x32, 0x22,
    0x22, 0x33, 0x34, 0x56, 0x67, 0x68, 0x9A, 0xAA, 0xCD, 0xE0, 0x00, 0x00,
   },
   {
    0x58, 0x77, 0x77, 0x66, 0x66, 0x55, 0x54, 0x44, 0x44, 0x43, 0x33, 0x33,
    0x33, 0x34, 0x44, 0x55, 0x55, 0x66, 0x67, 0x78, 0x88, 0x60, 0x00, 0x00,
   },
  },
  {
   {
    0x57, 0x77, 0x76, 0x66, 0x55, 0x55, 0x54, 0x43, 0x33, 0x22, 0x33, 0x34,
    0x45, 0x55, 0x66, 0x67, 0x77, 0x77, 0x78, 0x88, 0x99, 0x50, 0x00, 0x00,
   },
   {
    0xAC, 0x99, 0x98, 0x87, 0x76, 0x66, 0x54, 0x43, 0x32, 0x21, 0x23, 0x45,
    0x66, 0x89, 0x99, 0x99, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xB9, 0xAA, 0x98, 0x77, 0x65, 0x42, 0x21, 0x12, 0x45,
    0x78, 0x8A, 0xBA, 0xAA, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFD, 0xBC, 0xBB, 0xB9, 0x98, 0x76, 0x32, 0x01, 0x46,
    0x79, 0xAB, 0xBB, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xAA, 0xAA, 0x99, 0x76, 0x42, 0x01, 0x36,
    0x79, 0x9A, 0xAB, 0xBF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xCC, 0xDC, 0xB9, 0x75, 0x10, 0x47, 0x89, 0x99, 0x98, 0x87, 0x76, 0x66,
    0x55, 0x55, 0x55, 0x56, 0x66, 0x67, 0x78, 0x99, 0xBE, 0xE0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFC, 0xCC, 0xFF, 0xFB, 0xAB, 0x87, 0x64, 0x10, 0x23,
    0x67, 0x99, 0x9A, 0xAD, 0xCE, 0xFF, 0xFC, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFD, 0xFA, 0xB9, 0x97, 0x65, 0x20, 0x13,
    0x56, 0x78, 0xAA, 0x9B, 0xFB, 0xFC, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xCF, 0xFC, 0xC9, 0xAC, 0x98, 0x87, 0x54, 0x31, 0x12,
    0x23, 0x45, 0x67, 0x78, 0x9A, 0xAA, 0xEB, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFE, 0xCA, 0xFA, 0x99, 0x98, 0x88, 0x65, 0x44, 0x32, 0x22,
    0x22, 0x33, 0x45, 0x56, 0x67, 0x78, 0x99, 0xBB, 0xAB, 0xA0, 0x00, 0x00,
   },
   {
    0x48, 0x77, 0x76, 0x66, 0x65, 0x55, 0x55, 0x44, 0x44, 0x43, 0x33, 0x33,
    0x33, 0x34, 0x45, 0x55, 0x55, 0x66, 0x67, 0x77, 0x78, 0x60, 0x00, 0x00,
   },
  },
  {
   {
    0x68, 0x87, 0x77, 0x77, 0x66, 0x55, 0x54, 0x43, 0x33, 0x22, 0x23, 0x34,
    0x45, 0x55, 0x66, 0x78, 0x88, 0x98, 0x88, 0x88, 0x89, 0x60, 0x00, 0x00,
   },
   {
    0xAB, 0xBA, 0xAA, 0xBA, 0x99, 0x87, 0x76, 0x54, 0x33, 0x21, 0x12, 0x46,
    0x67, 0x89, 0x9A, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFD, 0xCA, 0x98, 0x87, 0x76, 0x54, 0x21, 0x11, 0x45,
    0x78, 0x8A, 0x9A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBC, 0xAA, 0x99, 0x76, 0x32, 0x01, 0x46,
    0x78, 0x9A, 0xAB, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCA, 0xE9, 0x89, 0x76, 0x52, 0x01, 0x35,
    0x68, 0x98, 0x9A, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xAD, 0xCB, 0xA9, 0x74, 0x10, 0x46, 0x89, 0x9A, 0xA9, 0x98, 0x77, 0x76,
    0x66, 0x55, 0x55, 0x56, 0x66, 0x66, 0x78, 0x88, 0x8A, 0xD0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xAA, 0xAA, 0x87, 0x63, 0x10, 0x24,
    0x67, 0x89, 0xAF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0x9A, 0x97, 0x64, 0x20, 0x13,
    0x67, 0x89, 0x9A, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x99, 0x87, 0x76, 0x43, 0x21, 0x12,
    0x34, 0x56, 0x67, 0x88, 0x89, 0xAE, 0xCF, 0xFD, 0xEF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xAA, 0x87, 0x66, 0x54, 0x31, 0x12,
    0x33, 0x44, 0x55, 0x67, 0x77, 0x89, 0xAB, 0xAB, 0xCF, 0xC0, 0x00, 0x00,
   },
   {
    0x58, 0x87, 0x87, 0x77, 0x76, 0x66, 0x55, 0x55, 0x44, 0x43, 0x32, 0x22,
    0x33, 0x44, 0x55, 0x56, 0x67, 0x77, 0x78, 0x88, 0x88, 0x70, 0x00, 0x00,
   },
  },
  {
   {
    0x67, 0x76, 0x66, 0x76, 0x66, 0x55, 0x44, 0x44, 0x33, 0x22, 0x22, 0x34,
    0x56, 0x67, 0x77, 0x89, 0x88, 0x99, 0xAB, 0x9A, 0xAB, 0x70, 0x00, 0x00,
   },
   {
    0x9B, 0xA9, 0x88, 0x88, 0x87, 0x77, 0x65, 0x54, 0x43, 0x21, 0x12, 0x45,
    0x67, 0x9A, 0x9A, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFC, 0xCB, 0xBA, 0xAA, 0x98, 0x87, 0x65, 0x31, 0x02, 0x56,
    0x89, 0xAB, 0xCB, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0x9A, 0x98, 0x76, 0x42, 0x01, 0x36,
    0x79, 0xAF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x78, 0xA9, 0x98, 0x76, 0x52, 0x01, 0x35,
    0x78, 0x8E, 0xCB, 0xBF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0x8C, 0xBA, 0x99, 0x74, 0x10, 0x36, 0x89, 0x9A, 0xA9, 0x99, 0x88, 0x87,
    0x76, 0x66, 0x66, 0x66, 0x66, 0x56, 0x66, 0x78, 0x89, 0xC0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x8A, 0xA9, 0x88, 0x63, 0x10, 0x24,
    0x67, 0x8B, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x99, 0x76, 0x54, 0x10, 0x24,
    0x56, 0x78, 0x9A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD9, 0x87, 0x54, 0x20, 0x22,
    0x45, 0x67, 0x77, 0x89, 0xAC, 0xAB, 0xFB, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0xAB, 0x86, 0x54, 0x21, 0x12,
    0x34, 0x45, 0x66, 0x77, 0x67, 0x77, 0x88, 0x99, 0x9A, 0x90, 0x00, 0x00,
   },
   {
    0x57, 0x77, 0x76, 0x66, 0x65, 0x55, 0x55, 0x55, 0x54, 0x43, 0x32, 0x23,
    0x33, 0x44, 0x55, 0x55, 0x66, 0x67, 0x88, 0x77, 0x77, 0x50, 0x00, 0x00,
   },
  },
  {
   {
    0x35, 0x44, 0x45, 0x55, 0x54, 0x44, 0x44, 0x43, 0x33, 0x33, 0x23, 0x44,
    0x68, 0x99, 0xAA, 0xAA, 0xCB, 0xAB, 0xAF, 0xFE, 0xEB, 0xE0, 0x00, 0x00,
   },
   {
    0x77, 0x66, 0x67, 0x66, 0x66, 0x66, 0x54, 0x44, 0x33, 0x22, 0x12, 0x45,
    0x68, 0xAA, 0xBE, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xEA, 0x98, 0x88, 0x87, 0x77, 0x65, 0x55, 0x44, 0x32, 0x02, 0x46,
    0x78, 0x89, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xAB, 0x99, 0x76, 0x65, 0x42, 0x01, 0x45,
    0x78, 0xAA, 0xAD, 0xAC, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xEB, 0xBA, 0xA9, 0x86, 0x42, 0x01, 0x36,
    0x77, 0x8A, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xAC, 0xBB, 0x98, 0x74, 0x10, 0x36, 0x77, 0x89, 0x99, 0x99, 0x88, 0x77,
    0x76, 0x66, 0x66, 0x55, 0x56, 0x67, 0x89, 0xAA, 0xAB, 0xC0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xC9, 0x99, 0x99, 0x88, 0x64, 0x10, 0x24,
    0x55, 0x68, 0x89, 0xBB, 0xAD, 0xBF, 0xBF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x97, 0x65, 0x65, 0x54, 0x20, 0x23,
    0x45, 0x56, 0x77, 0x77, 0x8E, 0xCB, 0xBE, 0xDF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0x76, 0x53, 0x21, 0x13,
    0x34, 0x55, 0x45, 0x55, 0x67, 0x79, 0xAB, 0xFA, 0xFB, 0xA0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFE, 0x87, 0x54, 0x21, 0x23,
    0x33, 0x44, 0x55, 0x55, 0x44, 0x45, 0x57, 0x8A, 0xAA, 0x80, 0x00, 0x00,
   },
   {
    0x79, 0x99, 0x99, 0x97, 0x77, 0x76, 0x54, 0x44, 0x44, 0x44, 0x32, 0x33,
    0x33, 0x33, 0x44, 0x45, 0x56, 0x67, 0x88, 0x77, 0x78, 0x60, 0x00, 0x00,
   },
  },
  {
   {
    0x34, 0x54, 0x45, 0x55, 0x54, 0x44, 0x44, 0x33, 0x32, 0x43, 0x34, 0x44,
    0x56, 0x77, 0xBB, 0xB6, 0xCC, 0xCC, 0xCC, 0xC8, 0xCB, 0x70, 0x00, 0x00,
   },
   {
    0x7E, 0x67, 0x55, 0x65, 0x44, 0x55, 0x44, 0x33, 0x22, 0x23, 0x23, 0x57,
    0x98, 0xDD, 0xDD, 0xDE, 0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0xE0, 0x00, 0x00,
   },
   {
    0xFF, 0xEF, 0xEE, 0x97, 0x75, 0x54, 0x43, 0x33, 0x33, 0x32, 0x12, 0x58,
    0x88, 0xEE, 0xAE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEE, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x88, 0x87, 0x66, 0x53, 0x22, 0x02, 0x57,
    0x9D, 0xFF, 0xFF, 0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xA9, 0x78, 0x76, 0x42, 0x01, 0x36,
    0x99, 0x9A, 0xFF, 0xDF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xAB, 0xAA, 0xA8, 0x75, 0x10, 0x26, 0x79, 0x88, 0x77, 0x77, 0x66, 0x66,
    0x57, 0x78, 0x88, 0x89, 0x98, 0x9A, 0xBB, 0xBB, 0xDD, 0xC0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFE, 0xEF, 0xFF, 0xFE, 0xA8, 0x78, 0x76, 0x54, 0x20, 0x22,
    0x45, 0x6E, 0x8E, 0xEF, 0xFF, 0xF9, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFA, 0xE7, 0x66, 0x64, 0x20, 0x23,
    0x34, 0x56, 0x78, 0x88, 0xAF, 0xFC, 0xFF, 0xFF, 0xAF, 0xF0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xED, 0xDE, 0xED, 0x8D, 0xDD, 0xD9, 0xE6, 0x63, 0x21, 0x23,
    0x43, 0x34, 0x35, 0x55, 0x65, 0x47, 0xEE, 0xED, 0xED, 0xE0, 0x00, 0x00,
   },
   {
    0xDD, 0xCD, 0xDC, 0xCD, 0xDD, 0xCC, 0xCC, 0xCD, 0xDD, 0x76, 0x43, 0x44,
    0x44, 0x43, 0x34, 0x33, 0x22, 0x33, 0x35, 0xD8, 0xCC, 0xD0, 0x00, 0x00,
   },
   {
    0x6B, 0x77, 0xBB, 0xB6, 0x96, 0x55, 0x55, 0x54, 0x44, 0x44, 0x33, 0x43,
    0x33, 0x33, 0x45, 0x34, 0x44, 0x68, 0x57, 0x78, 0x86, 0x50, 0x00, 0x00,
   },
  },
  {
   {
    0x4A, 0xAA, 0xAA, 0x9A, 0x44, 0x44, 0x45, 0x23, 0x24, 0x22, 0xA3, 0x3A,
    0x44, 0x99, 0x99, 0x9A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA0, 0x00, 0x00,
   },
   {
    0xAA, 0x45, 0x34, 0x94, 0x4A, 0x4A, 0x32, 0x23, 0x32, 0x24, 0x4A, 0xAA,
    0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA0, 0x00, 0x00,
   },
   {
    0xAA, 0xAA, 0xAA, 0xAA, 0x4A, 0xA4, 0x44, 0x21, 0x43, 0x32, 0x23, 0x5A,
    0xAA, 0xAA, 0x99, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA0, 0x00, 0x00,
   },
   {
    0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0x7D, 0x8D, 0x74, 0x21, 0x11, 0x35, 0x7D,
    0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD0, 0x00, 0x00,
   },
   {
    0xFE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE9, 0x64, 0x32, 0x01, 0x57,
    0xE8, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xF0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xE9, 0x55, 0x10, 0x27, 0x98, 0x65, 0x48, 0xAE, 0x99, 0x88,
    0x77, 0x87, 0x79, 0x89, 0xEA, 0xEE, 0xAE, 0xEE, 0xEE, 0xE0, 0x00, 0x00,
   },
   {
    0xCB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xB6, 0x45, 0x11, 0x13,
    0x44, 0x3B, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xC0, 0x00, 0x00,
   },
   {
    0xBB, 0xAB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x5A, 0x31, 0x12,
    0x23, 0x34, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xB0, 0x00, 0x00,
   },
   {
    0xBB, 0xBB, 0xBB, 0xAB, 0xBB, 0xBB, 0xAA, 0xAB, 0xBB, 0xBB, 0xB5, 0x55,
    0x64, 0x22, 0x24, 0x55, 0x32, 0x14, 0xBB, 0xBB, 0xBB, 0xB0, 0x00, 0x00,
   },
   {
    0xAA, 0xAA, 0xA9, 0x9A, 0xAA, 0xA9, 0x99, 0x9A, 0x4A, 0xAA, 0xA3, 0x33,
    0x32, 0x34, 0x35, 0x44, 0x42, 0x24, 0xA4, 0xAA, 0xAA, 0xA0, 0x00, 0x00,
   },
   {
    0xAA, 0x9A, 0x99, 0x9A, 0xA9, 0x54, 0x94, 0x95, 0x44, 0x53, 0x34, 0x53,
    0x23, 0x34, 0x34, 0x45, 0x33, 0x4A, 0x99, 0x99, 0xA9, 0xA0, 0x00, 0x00,
   },
  },
 },
 {
  {
   {
    0x57, 0xAB, 0x66, 0x52, 0x12, 0x44, 0x45, 0x43, 0x33, 0x45, 0x77, 0xA6,
    0x77, 0xA7, 0xA7, 0x65, 0x77, 0xBB, 0xB7, 0xBB, 0x7B, 0xB0, 0x00, 0x00,
   },
   {
    0xBB, 0x5B, 0xBB, 0x5B, 0xBB, 0x21, 0x22, 0x45, 0x62, 0x26, 0x56, 0xBB,
    0xBB, 0xBA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0, 0x00, 0x00,
   },
   {
    0xAA, 0x3A, 0x99, 0x93, 0x19, 0x99, 0x99, 0x99, 0x99, 0x24, 0x19, 0x33,
    0x99, 0x93, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xA0, 0x00, 0x00,
   },
   {
    0x77, 0x67, 0x66, 0x67, 0x76, 0x66, 0x66, 0x67, 0x77, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x10, 0x77, 0x76, 0x77, 0x77, 0x77, 0x70, 0x00, 0x00,
   },
   {
    0x77, 0x67, 0x66, 0x67, 0x76, 0x66, 0x66, 0x67, 0x77, 0x66, 0x66, 0x66,
    0x61, 0x66, 0x66, 0x67, 0x07, 0x76, 0x77, 0x77, 0x77, 0x70, 0x00, 0x00,
   },
   {
    0xDD, 0xDD, 0xD6, 0xCD, 0xDD, 0xD9, 0x88, 0xC9, 0x64, 0x76, 0x34, 0x42,
    0x12, 0x54, 0x53, 0x34, 0x54, 0x56, 0x66, 0x79, 0xDD, 0xD0, 0x00, 0x00,
   },
   {
    0x88, 0x78, 0x77, 0x78, 0x77, 0x77, 0x77, 0x78, 0x87, 0x07, 0x77, 0x77,
    0x21, 0x77, 0x77, 0x78, 0x88, 0x87, 0x87, 0x88, 0x88, 0x80, 0x00, 0x00,
   },
   {
    0xAA, 0x9A, 0x99, 0x9A, 0x99, 0x99, 0x99, 0x9A, 0x99, 0x01, 0x99, 0x99,
    0x43, 0x99, 0x34, 0x99, 0x94, 0x99, 0x99, 0x99, 0xAA, 0xA0, 0x00, 0x00,
   },
   {
    0x99, 0x89, 0x88, 0x89, 0x88, 0x88, 0x88, 0x89, 0x88, 0x82, 0x88, 0x21,
    0x82, 0x82, 0x83, 0x88, 0x82, 0x88, 0x88, 0x88, 0x99, 0x90, 0x00, 0x00,
   },
   {
    0xDD, 0xDD, 0xDD, 0xCD, 0xDD, 0xDD, 0xCC, 0xCD, 0xDD, 0xDD, 0xD6, 0x74,
    0x56, 0x64, 0x20, 0x54, 0x42, 0x38, 0xDD, 0xDD, 0xDD, 0xD0, 0x00, 0x00,
   },
   {
    0x79, 0x87, 0x96, 0x76, 0x76, 0x55, 0x66, 0x44, 0x55, 0x44, 0x55, 0x32,
    0x24, 0x88, 0x62, 0x55, 0x45, 0x43, 0x47, 0x66, 0x76, 0x60, 0x00, 0x00,
   },
  },
  {
   {
    0x57, 0x66, 0x65, 0x54, 0x43, 0x34, 0x33, 0x33, 0x33, 0x33, 0x44, 0x45,
    0x55, 0x66, 0x77, 0x77, 0x77, 0x77, 0x98, 0x88, 0x79, 0x60, 0x00, 0x00,
   },
   {
    0x88, 0x98, 0x8D, 0x65, 0x66, 0x32, 0x33, 0x22, 0x23, 0x33, 0x45, 0x67,
    0x78, 0x68, 0x8D, 0xCD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD0, 0x00, 0x00,
   },
   {
    0x8D, 0xCD, 0xDC, 0xC5, 0x56, 0x46, 0x45, 0x54, 0x22, 0x22, 0x22, 0x45,
    0x57, 0x6C, 0xCC, 0xCD, 0xDD, 0xDD, 0xDD, 0xDC, 0xCC, 0xD0, 0x00, 0x00,
   },
   {
    0xCC, 0xCC, 0xCB, 0xBC, 0xCC, 0xC7, 0xB5, 0x54, 0x12, 0x33, 0x22, 0x25,
    0x56, 0xB6, 0x7B, 0xB7, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xC0, 0x00, 0x00,
   },
   {
    0xBB, 0xAB, 0xBA, 0xAB, 0xBB, 0xA5, 0xA5, 0x55, 0x21, 0x2B, 0x33, 0x23,
    0x44, 0x55, 0xA6, 0x5B, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0, 0x00, 0x00,
   },
   {
    0xAC, 0xAB, 0xC6, 0x66, 0x87, 0x87, 0x77, 0x98, 0x66, 0x54, 0x43, 0x43,
    0x33, 0x32, 0x33, 0x33, 0x44, 0x45, 0x66, 0x68, 0x79, 0xA0, 0x00, 0x00,
   },
   {
    0xBB, 0xBB, 0xBB, 0xAB, 0xBB, 0xBB, 0xBA, 0x4B, 0x43, 0x22, 0x22, 0x32,
    0x44, 0x34, 0xA5, 0xA6, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0, 0x00, 0x00,
   },
   {
    0xBB, 0xAB, 0xAA, 0xAB, 0xBA, 0xAA, 0xA6, 0x65, 0x54, 0x43, 0x21, 0x23,
    0x34, 0x34, 0x55, 0x56, 0x6B, 0xBB, 0xB6, 0xBA, 0xBA, 0xB0, 0x00, 0x00,
   },
   {
    0xDD, 0xCD, 0xDC, 0xCD, 0xDD, 0xCC, 0xCC, 0xC6, 0x66, 0x44, 0x43, 0x32,
    0x21, 0x25, 0x65, 0x46, 0x54, 0x8D, 0xDD, 0xDC, 0xD7, 0xC0, 0x00, 0x00,
   },
   {
    0xFF, 0xEF, 0xEE, 0xEF, 0xEE, 0xEE, 0xEE, 0x9A, 0xF7, 0x66, 0x55, 0x43,
    0x33, 0x22, 0x22, 0x33, 0x34, 0x78, 0x98, 0xEE, 0xFE, 0x90, 0x00, 0x00,
   },
   {
    0x57, 0x67, 0x66, 0x76, 0x65, 0x55, 0x44, 0x54, 0x44, 0x43, 0x43, 0x34,
    0x43, 0x44, 0x44, 0x44, 0x45, 0x45, 0x55, 0x67, 0x77, 0x60, 0x00, 0x00,
   },
  },
  {
   {
    0x78, 0x88, 0x76, 0x66, 0x55, 0x54, 0x44, 0x33, 0x22, 0x23, 0x33, 0x44,
    0x55, 0x67, 0x67, 0x78, 0x98, 0x98, 0x99, 0x9A, 0xA9, 0x90, 0x00, 0x00,
   },
   {
    0x99, 0xAA, 0xAB, 0x97, 0x65, 0x55, 0x44, 0x32, 0x22, 0x22, 0x33, 0x45,
    0x67, 0x89, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFC, 0xBB, 0xA8, 0x88, 0x77, 0x76, 0x54, 0x32, 0x11, 0x23, 0x46,
    0x77, 0x8A, 0xF8, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xED, 0xDE, 0xE9, 0xDD, 0x77, 0x65, 0x43, 0x21, 0x12, 0x34,
    0x57, 0x7D, 0x78, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE0, 0x00, 0x00,
   },
   {
    0xEE, 0xEE, 0xEE, 0xDE, 0xEE, 0xE7, 0x7D, 0x96, 0x54, 0x22, 0x11, 0x24,
    0x56, 0x87, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE0, 0x00, 0x00,
   },
   {
    0xCB, 0xAA, 0x97, 0x65, 0x44, 0x45, 0x77, 0x76, 0x66, 0x55, 0x44, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x44, 0x55, 0x68, 0x99, 0x9A, 0xC0, 0x00, 0x00,
   },
   {
    0xDD, 0xDD, 0xDD, 0x7D, 0xDD, 0xDC, 0xCC, 0x66, 0x66, 0x43, 0x11, 0x22,
    0x34, 0x56, 0x8C, 0xCD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD0, 0x00, 0x00,
   },
   {
    0xFF, 0xEF, 0xFE, 0xEF, 0xFF, 0xEE, 0xE9, 0x88, 0x76, 0x54, 0x31, 0x11,
    0x34, 0x57, 0x77, 0x8F, 0xAF, 0xFF, 0xFF, 0xFE, 0xFE, 0xF0, 0x00, 0x00,
   },
   {
    0xFE, 0xEE, 0xEE, 0xEA, 0xAE, 0xEE, 0xA9, 0xE9, 0x87, 0x65, 0x43, 0x11,
    0x22, 0x35, 0x56, 0x66, 0x88, 0x9A, 0xEE, 0xEA, 0xEE, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFB, 0xEA, 0x98, 0x76, 0x55, 0x43, 0x22,
    0x22, 0x33, 0x33, 0x44, 0x46, 0x78, 0xAA, 0xFF, 0xFB, 0xB0, 0x00, 0x00,
   },
   {
    0x79, 0x99, 0x77, 0x77, 0x66, 0x55, 0x54, 0x44, 0x43, 0x43, 0x33, 0x33,
    0x33, 0x34, 0x44, 0x55, 0x55, 0x66, 0x66, 0x79, 0x99, 0x80, 0x00, 0x00,
   },
  },
  {
   {
    0x68, 0x87, 0x77, 0x66, 0x55, 0x55, 0x54, 0x43, 0x32, 0x22, 0x33, 0x34,
    0x45, 0x66, 0x77, 0x78, 0x88, 0x89, 0x98, 0x88, 0x88, 0x60, 0x00, 0x00,
   },
   {
    0xAA, 0xAB, 0xAB, 0xA9, 0x88, 0x66, 0x65, 0x43, 0x22, 0x21, 0x23, 0x46,
    0x78, 0xA9, 0xBF, 0xEF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFD, 0xFF, 0xFF, 0xBC, 0x99, 0x98, 0x76, 0x65, 0x42, 0x21, 0x12, 0x46,
    0x67, 0x99, 0xFF, 0xEF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xFA, 0xB9, 0x87, 0x65, 0x31, 0x02, 0x56,
    0x79, 0x9A, 0xAF, 0xEA, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0x9B, 0xAE, 0xBE, 0x9B, 0xBB, 0xAB, 0xAA, 0x98, 0x76, 0x52, 0x01, 0x35,
    0x88, 0x99, 0x9A, 0xAC, 0xBA, 0xBB, 0xEA, 0xBA, 0xEA, 0xB0, 0x00, 0x00,
   },
   {
    0xCC, 0xBC, 0xA7, 0x65, 0x21, 0x46, 0x88, 0x87, 0x77, 0x65, 0x44, 0x44,
    0x43, 0x33, 0x44, 0x45, 0x55, 0x56, 0x78, 0x9A, 0x9B, 0xC0, 0x00, 0x00,
   },
   {
    0x9E, 0x9E, 0xA9, 0xAB, 0xAA, 0xA9, 0x9D, 0x99, 0x87, 0x65, 0x10, 0x23,
    0x68, 0x88, 0x98, 0x9A, 0xA9, 0xAA, 0xDA, 0xAD, 0xAA, 0x90, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFE, 0xEF, 0xFF, 0xFC, 0xBB, 0xA9, 0xA7, 0x65, 0x30, 0x12,
    0x56, 0x78, 0x9A, 0x9A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xBA, 0x98, 0x76, 0x41, 0x11,
    0x24, 0x47, 0x77, 0x89, 0xBB, 0xED, 0xCF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xCF, 0xFF, 0xEF, 0xCF, 0xCE, 0x9B, 0xA9, 0x87, 0x65, 0x42, 0x11,
    0x23, 0x44, 0x55, 0x66, 0x67, 0x9A, 0xAB, 0xCF, 0xCC, 0xD0, 0x00, 0x00,
   },
   {
    0x68, 0x78, 0x77, 0x76, 0x66, 0x55, 0x55, 0x54, 0x44, 0x33, 0x33, 0x32,
    0x33, 0x34, 0x55, 0x55, 0x66, 0x66, 0x77, 0x77, 0x88, 0x60, 0x00, 0x00,
   },
  },
  {
   {
    0x68, 0x77, 0x76, 0x66, 0x55, 0x55, 0x54, 0x44, 0x32, 0x22, 0x33, 0x34,
    0x55, 0x56, 0x66, 0x66, 0x67, 0x78, 0x88, 0x99, 0x99, 0x50, 0x00, 0x00,
   },
   {
    0xCB, 0xCA, 0xAA, 0xA9, 0x97, 0x77, 0x66, 0x54, 0x32, 0x21, 0x13, 0x46,
    0x79, 0xAA, 0xAB, 0xBF, 0xCD, 0xFD, 0xCF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFC, 0xFF, 0xBB, 0xA9, 0xA8, 0x87, 0x65, 0x31, 0x02, 0x56,
    0x89, 0xAB, 0xBB, 0xBB, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFB, 0xFF, 0xCD, 0xCF, 0x99, 0x87, 0x65, 0x42, 0x01, 0x45,
    0x67, 0x9A, 0xBB, 0xAF, 0xBD, 0xBF, 0xFC, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xF9, 0xA8, 0x86, 0x42, 0x01, 0x36,
    0x78, 0x8A, 0xBF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00, 0x00,
   },
   {
    0xCF, 0xDB, 0xBA, 0x85, 0x10, 0x47, 0x89, 0x99, 0x99, 0x87, 0x66, 0x65,
    0x55, 0x55, 0x55, 0x56, 0x66, 0x77, 0x89, 0xAC, 0xCE, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xBF, 0xBB, 0xFF, 0x98, 0x63, 0x10, 0x24,
    0x59, 0x99, 0xBF, 0xFB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0xBB, 0xAF, 0x97, 0x65, 0x20, 0x13,
    0x56, 0x78, 0x99, 0xAB, 0xFD, 0xAF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xBB, 0xAA, 0x97, 0x65, 0x30, 0x13,
    0x44, 0x56, 0x88, 0x89, 0xA9, 0xBF, 0xFF, 0xCF, 0xFC, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFD, 0xFF, 0xFA, 0xBA, 0xBA, 0xB9, 0x87, 0x65, 0x32, 0x11,
    0x23, 0x45, 0x56, 0x67, 0x77, 0x9A, 0xBA, 0xBF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0x57, 0x78, 0x77, 0x66, 0x66, 0x55, 0x55, 0x44, 0x44, 0x43, 0x33, 0x23,
    0x33, 0x44, 0x45, 0x55, 0x56, 0x66, 0x66, 0x77, 0x78, 0x60, 0x00, 0x00,
   },
  },
  {
   {
    0x68, 0x87, 0x87, 0x77, 0x66, 0x55, 0x54, 0x44, 0x32, 0x22, 0x23, 0x44,
    0x45, 0x56, 0x66, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x50, 0x00, 0x00,
   },
   {
    0x9A, 0xB9, 0xA9, 0xA8, 0x87, 0x76, 0x65, 0x54, 0x43, 0x21, 0x12, 0x45,
    0x68, 0x88, 0xAA, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFC, 0xCF, 0xBA, 0x98, 0x77, 0x65, 0x31, 0x02, 0x56,
    0x89, 0xAC, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0x87, 0x76, 0x42, 0x01, 0x36,
    0x89, 0xAA, 0xBD, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xBF, 0xFF, 0xEF, 0xBF, 0xAC, 0x99, 0x87, 0x42, 0x01, 0x35,
    0x79, 0xAA, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xCD, 0xCC, 0xB9, 0x74, 0x10, 0x46, 0x8A, 0xA9, 0x99, 0x98, 0x77, 0x66,
    0x66, 0x55, 0x55, 0x55, 0x66, 0x67, 0x89, 0x9A, 0xAB, 0xD0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xDA, 0xA8, 0x53, 0x10, 0x24,
    0x68, 0x9A, 0xAE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFB, 0x98, 0x74, 0x10, 0x23,
    0x57, 0x89, 0xAB, 0xBC, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xBA, 0x98, 0x65, 0x20, 0x13,
    0x56, 0x78, 0x89, 0x9A, 0xAC, 0xEF, 0xFB, 0xFF, 0xDF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0x99, 0x86, 0x54, 0x21, 0x12,
    0x34, 0x45, 0x56, 0x67, 0x67, 0x99, 0xAB, 0xEB, 0xFF, 0xB0, 0x00, 0x00,
   },
   {
    0x57, 0x87, 0x77, 0x77, 0x66, 0x66, 0x65, 0x55, 0x44, 0x43, 0x32, 0x22,
    0x33, 0x44, 0x55, 0x56, 0x67, 0x77, 0x77, 0x88, 0x99, 0x70, 0x00, 0x00,
   },
  },
  {
   {
    0x78, 0x88, 0x88, 0x77, 0x76, 0x65, 0x54, 0x44, 0x33, 0x32, 0x12, 0x34,
    0x46, 0x78, 0x99, 0x9A, 0xBA, 0xAC, 0xAB, 0xCB, 0xAA, 0x90, 0x00, 0x00,
   },
   {
    0x9A, 0x98, 0x88, 0x98, 0x87, 0x77, 0x65, 0x54, 0x43, 0x21, 0x12, 0x45,
    0x67, 0x8B, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xBD, 0xA9, 0x99, 0x87, 0x77, 0x55, 0x41, 0x02, 0x46,
    0x79, 0xAB, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFE, 0xFF, 0xFF, 0xDB, 0x9A, 0xBA, 0x98, 0x76, 0x42, 0x01, 0x36,
    0x79, 0xBB, 0xCB, 0xFC, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFA, 0x9A, 0xAA, 0x87, 0x42, 0x01, 0x35,
    0x78, 0xDA, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xBC, 0xCC, 0xA9, 0x74, 0x10, 0x36, 0x8A, 0xAA, 0xA9, 0x99, 0x88, 0x77,
    0x76, 0x66, 0x65, 0x66, 0x55, 0x66, 0x78, 0x88, 0xAB, 0xC0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xAA, 0x97, 0x63, 0x10, 0x24,
    0x67, 0x88, 0x9B, 0xFD, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFC, 0xBB, 0x97, 0x64, 0x10, 0x23,
    0x67, 0x88, 0xAA, 0xAB, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xBD, 0xA7, 0x64, 0x20, 0x14,
    0x55, 0x77, 0x78, 0x8A, 0xAA, 0xAB, 0xFD, 0xCC, 0xBF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0x76, 0x54, 0x21, 0x12,
    0x34, 0x45, 0x56, 0x67, 0x77, 0x8A, 0xAA, 0x99, 0xBA, 0x90, 0x00, 0x00,
   },
   {
    0x68, 0x88, 0x77, 0x66, 0x66, 0x55, 0x55, 0x55, 0x54, 0x43, 0x22, 0x23,
    0x34, 0x44, 0x44, 0x56, 0x77, 0x77, 0x78, 0x99, 0x99, 0x60, 0x00, 0x00,
   },
  },
  {
   {
    0x45, 0x56, 0x66, 0x65, 0x55, 0x54, 0x44, 0x44, 0x44, 0x42, 0x12, 0x35,
    0x68, 0x8E, 0x9A, 0xBC, 0xEB, 0xBB, 0xEB, 0xBB, 0xBE, 0xB0, 0x00, 0x00,
   },
   {
    0x87, 0x77, 0x76, 0x76, 0x66, 0x66, 0x55, 0x54, 0x43, 0x31, 0x12, 0x45,
    0x56, 0xA9, 0xEE, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xAF, 0x98, 0x97, 0x78, 0x75, 0x55, 0x44, 0x32, 0x02, 0x45,
    0x68, 0x8E, 0x9C, 0xEF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xBA, 0x98, 0x77, 0x65, 0x42, 0x01, 0x45,
    0x69, 0x9C, 0x9B, 0xDF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xCA, 0xAA, 0xA8, 0x76, 0x52, 0x01, 0x35,
    0x67, 0x8A, 0xEA, 0xBF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xA9, 0xAB, 0x98, 0x74, 0x10, 0x36, 0x89, 0x99, 0x99, 0x88, 0x87, 0x87,
    0x76, 0x66, 0x66, 0x55, 0x56, 0x67, 0x79, 0x9B, 0x9B, 0xB0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB8, 0x88, 0x87, 0x54, 0x10, 0x24,
    0x56, 0x77, 0x89, 0xBF, 0xFF, 0xEC, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xDC, 0xFF, 0xFB, 0xDB, 0xB9, 0x86, 0x53, 0x20, 0x23,
    0x44, 0x56, 0x88, 0x78, 0xAA, 0xFF, 0xAB, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xBF, 0xFA, 0x97, 0x64, 0x20, 0x23,
    0x44, 0x55, 0x56, 0x67, 0x77, 0x89, 0x9B, 0xB9, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xD9, 0x75, 0x43, 0x21, 0x23,
    0x34, 0x44, 0x44, 0x55, 0x55, 0x66, 0x66, 0x78, 0x8A, 0x80, 0x00, 0x00,
   },
   {
    0x79, 0x89, 0x98, 0x88, 0x77, 0x77, 0x54, 0x44, 0x44, 0x43, 0x22, 0x33,
    0x33, 0x44, 0x45, 0x45, 0x66, 0x68, 0x77, 0x98, 0x88, 0x60, 0x00, 0x00,
   },
  },
  {
   {
    0x25, 0x45, 0x57, 0x45, 0x45, 0x55, 0x43, 0x33, 0x33, 0x33, 0x34, 0x44,
    0x55, 0xBB, 0xBB, 0x6B, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0, 0x00, 0x00,
   },
   {
    0x86, 0x76, 0x75, 0x55, 0x55, 0x65, 0x74, 0x44, 0x33, 0x32, 0x12, 0x35,
    0x6C, 0xCC, 0xCC, 0xCD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xD0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xDD, 0x8E, 0x76, 0x55, 0x43, 0x44, 0x32, 0x32, 0x12, 0x46,
    0x87, 0x99, 0x9D, 0xDE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xE0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFE, 0xEF, 0xFF, 0xA9, 0x96, 0x55, 0x43, 0x32, 0x02, 0x45,
    0x88, 0xEE, 0xE9, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAF, 0x89, 0x66, 0x42, 0x01, 0x36,
    0xD9, 0x8A, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xAA, 0xEA, 0xF9, 0x74, 0x10, 0x35, 0x79, 0x98, 0x87, 0x66, 0x66, 0x55,
    0x56, 0x67, 0x77, 0x77, 0x88, 0x99, 0xAA, 0xFC, 0xEE, 0xB0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xE9, 0x97, 0xF7, 0x65, 0x20, 0x13,
    0x56, 0x79, 0xEA, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xEE, 0xEE, 0xED, 0xDE, 0xEE, 0xED, 0xDD, 0xDE, 0x75, 0x63, 0x11, 0x22,
    0x34, 0x45, 0x67, 0x78, 0x9E, 0xEE, 0xEE, 0xEE, 0xEE, 0xE0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xDD, 0xDE, 0xED, 0xD8, 0xDD, 0xDE, 0x87, 0x54, 0x20, 0x23,
    0x46, 0x46, 0x56, 0x67, 0x76, 0x79, 0x8E, 0xED, 0xED, 0xE0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xDD, 0xDE, 0xDD, 0xDD, 0xDD, 0xD9, 0x98, 0x54, 0x32, 0x23,
    0x45, 0x44, 0x34, 0x43, 0x23, 0x66, 0x36, 0xD8, 0xDD, 0x90, 0x00, 0x00,
   },
   {
    0x7B, 0x7B, 0xA7, 0x77, 0x6A, 0x57, 0x56, 0x55, 0x45, 0x43, 0x33, 0x33,
    0x33, 0x33, 0x44, 0x43, 0x35, 0xBB, 0xBA, 0xAA, 0xB7, 0x50, 0x00, 0x00,
   },
  },
  {
   {
    0x24, 0xA3, 0x44, 0x44, 0xAA, 0x49, 0x34, 0x43, 0x24, 0x42, 0x35, 0xA9,
    0x99, 0x49, 0x99, 0x9A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA0, 0x00, 0x00,
   },
   {
    0x99, 0x39, 0x94, 0x94, 0x39, 0x43, 0x92, 0x33, 0x29, 0x22, 0x39, 0x99,
    0x99, 0x99, 0x88, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x90, 0x00, 0x00,
   },
   {
    0x99, 0x99, 0x99, 0x99, 0x49, 0x49, 0x33, 0x34, 0x33, 0x21, 0x23, 0x99,
    0x99, 0x99, 0x98, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x90, 0x00, 0x00,
   },
   {
    0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xC6, 0x32, 0x21, 0x12, 0x45,
    0xC7, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xD0, 0x00, 0x00,
   },
   {
    0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD7, 0xDD, 0x75, 0x42, 0x01, 0x38,
    0xDD, 0x7D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xE0, 0x00, 0x00,
   },
   {
    0xCC, 0x8C, 0x87, 0x64, 0x10, 0x37, 0x86, 0x66, 0x67, 0x69, 0x78, 0x77,
    0x76, 0x66, 0x66, 0x67, 0x68, 0x77, 0x88, 0xCC, 0xCC, 0xC0, 0x00, 0x00,
   },
   {
    0xBB, 0xAB, 0xAA, 0xAB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA4, 0x20, 0x22,
    0x44, 0xA5, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBA, 0xB0, 0x00, 0x00,
   },
   {
    0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x4B, 0x33, 0x03,
    0x23, 0x46, 0x4B, 0x5B, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0, 0x00, 0x00,
   },
   {
    0xBB, 0xBB, 0xBB, 0xAB, 0xBB, 0xBB, 0xAA, 0xAB, 0xBB, 0xBB, 0xB2, 0x43,
    0x44, 0x32, 0x13, 0x46, 0x34, 0x35, 0xBB, 0xBB, 0xBB, 0xB0, 0x00, 0x00,
   },
   {
    0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA9, 0x9A, 0xAA, 0xAA, 0xA4, 0x23,
    0x32, 0xA5, 0x32, 0xA2, 0x24, 0xA3, 0xAA, 0x4A, 0xAA, 0xA0, 0x00, 0x00,
   },
   {
    0xA9, 0x59, 0x99, 0x99, 0x99, 0x54, 0x49, 0x45, 0x55, 0x45, 0x43, 0x39,
    0x52, 0x33, 0x43, 0x44, 0x25, 0x59, 0x59, 0x99, 0x59, 0xA0, 0x00, 0x00,
   },
  },
 },
 {
  {
   {
    0x58, 0x76, 0x5B, 0x53, 0x21, 0x25, 0x54, 0x43, 0x33, 0x48, 0x88, 0x56,
    0x67, 0x6B, 0x87, 0xBC, 0x7C, 0x8C, 0xCC, 0xCC, 0x8C, 0xB0, 0x00, 0x00,
   },
   {
    0xCC, 0xCC, 0x6C, 0x4C, 0xCC, 0x12, 0x12, 0x45, 0x53, 0x35, 0x7C, 0xCC,
    0xCC, 0xCC, 0xBB, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xC0, 0x00, 0x00,
   },
   {
    0xAA, 0xAA, 0xA4, 0xA1, 0x44, 0x55, 0xA9, 0x9A, 0xAA, 0xA2, 0x22, 0x24,
    0xA5, 0xA4, 0x49, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA0, 0x00, 0x00,
   },
   {
    0x99, 0x88, 0x33, 0x88, 0x88, 0x88, 0x88, 0x28, 0x88, 0x88, 0x88, 0x21,
    0x33, 0x88, 0x83, 0x82, 0x88, 0x88, 0x88, 0x88, 0x89, 0x90, 0x00, 0x00,
   },
   {
    0x66, 0x56, 0x55, 0x56, 0x65, 0x55, 0x55, 0x56, 0x06, 0x65, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x56, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x00, 0x00,
   },
   {
    0xEE, 0x9D, 0xA6, 0x9D, 0xDA, 0xD9, 0x97, 0x55, 0x42, 0x64, 0x43, 0x32,
    0x24, 0x44, 0x33, 0x44, 0x66, 0x55, 0x58, 0x7D, 0xDD, 0xA0, 0x00, 0x00,
   },
   {
    0x88, 0x78, 0x77, 0x78, 0x77, 0x77, 0x77, 0x78, 0x82, 0x07, 0x77, 0x77,
    0x72, 0x27, 0x77, 0x78, 0x87, 0x77, 0x87, 0x88, 0x88, 0x80, 0x00, 0x00,
   },
   {
    0xBB, 0xAB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x01, 0x3A, 0xAA,
    0x4A, 0x4A, 0x45, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xB0, 0x00, 0x00,
   },
   {
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x89, 0x99, 0x92, 0x39, 0x21,
    0x49, 0x43, 0x33, 0x99, 0x34, 0x39, 0x99, 0x99, 0x99, 0x90, 0x00, 0x00,
   },
   {
    0xEE, 0xEE, 0xED, 0xDE, 0xEE, 0xED, 0xDD, 0xDE, 0xEE, 0xEE, 0x97, 0x75,
    0x55, 0x75, 0x20, 0x34, 0x63, 0x26, 0x8E, 0xEE, 0xEE, 0xE0, 0x00, 0x00,
   },
   {
    0x69, 0xB8, 0x77, 0x8B, 0x85, 0x56, 0x55, 0x44, 0x65, 0x44, 0x33, 0x32,
    0x23, 0x67, 0xA4, 0x74, 0x45, 0x44, 0x45, 0x68, 0x86, 0x70, 0x00, 0x00,
   },
  },
  {
   {
    0x67, 0x76, 0x66, 0x54, 0x43, 0x43, 0x33, 0x33, 0x33, 0x33, 0x44, 0x44,
    0x55, 0x66, 0x67, 0x67, 0x77, 0x77, 0x89, 0x89, 0x99, 0x60, 0x00, 0x00,
   },
   {
    0xA9, 0x99, 0x99, 0x66, 0x66, 0x43, 0x33, 0x22, 0x22, 0x33, 0x34, 0x57,
    0x78, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFE, 0xE9, 0xE9, 0x87, 0x65, 0x55, 0x44, 0x44, 0x32, 0x22, 0x22, 0x34,
    0x56, 0x79, 0x8E, 0xEA, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xF0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xDD, 0xD8, 0xDD, 0x75, 0x54, 0x54, 0x33, 0x44, 0x31, 0x13,
    0x45, 0x66, 0x88, 0x89, 0x8E, 0xDD, 0xDD, 0xDD, 0xED, 0xE0, 0x00, 0x00,
   },
   {
    0xCC, 0xBC, 0xBB, 0xBC, 0xCB, 0x75, 0x65, 0x45, 0x32, 0x24, 0x43, 0x12,
    0x46, 0x54, 0x77, 0xBC, 0xCC, 0xCC, 0xCB, 0xCB, 0xCB, 0xC0, 0x00, 0x00,
   },
   {
    0xA9, 0x8B, 0x97, 0x56, 0x88, 0x76, 0x77, 0x66, 0x55, 0x44, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x45, 0x56, 0x67, 0x8A, 0xCA, 0xC0, 0x00, 0x00,
   },
   {
    0xDD, 0xCD, 0xCC, 0xCD, 0xDC, 0xCC, 0x68, 0x55, 0x53, 0x21, 0x23, 0x33,
    0x33, 0x45, 0x77, 0x67, 0xDD, 0xDD, 0xDD, 0xDC, 0xDC, 0xD0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xDD, 0xDE, 0xE9, 0x8D, 0xD8, 0x67, 0x44, 0x32, 0x22, 0x22,
    0x33, 0x44, 0x46, 0x87, 0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xE0, 0x00, 0x00,
   },
   {
    0xFF, 0xEF, 0xEE, 0xEF, 0xFE, 0xEE, 0xE9, 0x78, 0x67, 0x54, 0x43, 0x22,
    0x12, 0x35, 0x53, 0x55, 0x56, 0x7A, 0xFE, 0xEE, 0xFE, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0xFB, 0x87, 0x66, 0x54, 0x33,
    0x33, 0x22, 0x22, 0x33, 0x46, 0x67, 0x7A, 0xCF, 0xCF, 0xF0, 0x00, 0x00,
   },
   {
    0x67, 0x77, 0x77, 0x66, 0x66, 0x55, 0x55, 0x44, 0x43, 0x44, 0x33, 0x34,
    0x43, 0x44, 0x43, 0x44, 0x44, 0x55, 0x66, 0x76, 0x88, 0x70, 0x00, 0x00,
   },
  },
  {
   {
    0x78, 0x77, 0x76, 0x66, 0x55, 0x44, 0x44, 0x33, 0x33, 0x22, 0x33, 0x34,
    0x45, 0x67, 0x78, 0x88, 0x88, 0x99, 0x89, 0xA9, 0xA9, 0x70, 0x00, 0x00,
   },
   {
    0xA9, 0x9B, 0x99, 0x87, 0x77, 0x54, 0x44, 0x33, 0x22, 0x22, 0x23, 0x45,
    0x67, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFD, 0xAA, 0x98, 0x87, 0x77, 0x65, 0x32, 0x11, 0x23, 0x44,
    0x57, 0x9A, 0xCE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x88, 0x77, 0x65, 0x54, 0x31, 0x11, 0x35,
    0x57, 0x88, 0x8F, 0xDF, 0xFC, 0x9F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xEF, 0xEE, 0xEF, 0xFE, 0x99, 0x87, 0x77, 0x54, 0x22, 0x11, 0x24,
    0x66, 0x77, 0x78, 0xEA, 0xF9, 0xFF, 0xEE, 0xEE, 0xFE, 0xF0, 0x00, 0x00,
   },
   {
    0xAB, 0xAA, 0x97, 0x65, 0x44, 0x45, 0x66, 0x65, 0x54, 0x44, 0x43, 0x33,
    0x33, 0x33, 0x33, 0x44, 0x55, 0x66, 0x78, 0x8B, 0xAB, 0xB0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xED, 0xDE, 0x98, 0x8D, 0xDD, 0x67, 0x66, 0x43, 0x11, 0x22,
    0x34, 0x57, 0x77, 0x8E, 0xEE, 0xEE, 0xEE, 0xED, 0xDD, 0xE0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xEF, 0xFB, 0xFF, 0xBB, 0x98, 0x66, 0x54, 0x31, 0x11,
    0x34, 0x56, 0x98, 0xBF, 0xDC, 0xBF, 0xBF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0xAA, 0x88, 0x66, 0x32, 0x11,
    0x23, 0x35, 0x66, 0x77, 0x99, 0xCE, 0xFE, 0xCD, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xCA, 0xA9, 0x76, 0x54, 0x42, 0x22,
    0x22, 0x33, 0x34, 0x55, 0x56, 0x77, 0x9B, 0xBF, 0xFF, 0xC0, 0x00, 0x00,
   },
   {
    0x69, 0x88, 0x77, 0x77, 0x76, 0x65, 0x55, 0x44, 0x43, 0x43, 0x33, 0x33,
    0x33, 0x34, 0x44, 0x44, 0x55, 0x67, 0x77, 0x88, 0x89, 0x70, 0x00, 0x00,
   },
  },
  {
   {
    0x79, 0x98, 0x87, 0x77, 0x66, 0x55, 0x44, 0x43, 0x33, 0x22, 0x23, 0x33,
    0x45, 0x66, 0x77, 0x88, 0x89, 0x99, 0x9A, 0xA9, 0x99, 0x70, 0x00, 0x00,
   },
   {
    0xBB, 0xFB, 0xBA, 0xA9, 0x98, 0x76, 0x65, 0x44, 0x32, 0x21, 0x22, 0x35,
    0x79, 0xAE, 0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xCF, 0xFA, 0xAA, 0x99, 0x88, 0x77, 0x65, 0x33, 0x21, 0x12, 0x44,
    0x57, 0x89, 0xAB, 0xBE, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xBF, 0xDB, 0xA9, 0x99, 0x86, 0x65, 0x41, 0x02, 0x45,
    0x78, 0x89, 0xCA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xA9, 0x98, 0x76, 0x52, 0x01, 0x35,
    0x68, 0x89, 0x9E, 0xEF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00,
   },
   {
    0xDB, 0xCA, 0x98, 0x75, 0x21, 0x46, 0x77, 0x76, 0x66, 0x54, 0x44, 0x44,
    0x33, 0x34, 0x44, 0x45, 0x66, 0x77, 0x89, 0xAC, 0xCB, 0xD0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0x98, 0x77, 0x65, 0x10, 0x23,
    0x56, 0x89, 0xAA, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBB, 0xCA, 0x87, 0x65, 0x30, 0x12,
    0x56, 0x78, 0xA9, 0xBA, 0xFD, 0xCF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xED, 0xAA, 0xA9, 0x97, 0x64, 0x31, 0x12,
    0x23, 0x45, 0x56, 0x78, 0xA9, 0xAC, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFC, 0xCB, 0xA8, 0x65, 0x54, 0x32, 0x12,
    0x23, 0x34, 0x45, 0x56, 0x77, 0x88, 0xAC, 0xDF, 0xDF, 0xE0, 0x00, 0x00,
   },
   {
    0x68, 0x98, 0x88, 0x77, 0x77, 0x66, 0x55, 0x54, 0x44, 0x43, 0x32, 0x22,
    0x33, 0x44, 0x55, 0x56, 0x66, 0x77, 0x78, 0x89, 0x99, 0x70, 0x00, 0x00,
   },
  },
  {
   {
    0x8A, 0xA9, 0x88, 0x87, 0x66, 0x65, 0x54, 0x43, 0x33, 0x22, 0x23, 0x33,
    0x45, 0x55, 0x67, 0x78, 0x88, 0x88, 0x88, 0x99, 0x99, 0x60, 0x00, 0x00,
   },
   {
    0xCF, 0xBF, 0xCA, 0xAA, 0x98, 0x87, 0x76, 0x54, 0x33, 0x21, 0x12, 0x45,
    0x78, 0x8A, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xEF, 0xBE, 0xBA, 0x99, 0x77, 0x65, 0x31, 0x02, 0x56,
    0x89, 0x9B, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBB, 0x97, 0x76, 0x32, 0x01, 0x46,
    0x88, 0x9B, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFC, 0xA8, 0x97, 0x42, 0x01, 0x35,
    0x78, 0x9A, 0xBC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xDC, 0xCB, 0xB9, 0x75, 0x10, 0x47, 0x89, 0x89, 0x88, 0x76, 0x66, 0x55,
    0x55, 0x55, 0x55, 0x66, 0x77, 0x78, 0x9A, 0xAC, 0xFE, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xCA, 0xA9, 0x87, 0x63, 0x10, 0x24,
    0x67, 0x8A, 0xCA, 0xFF, 0xFE, 0xCF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xAA, 0x98, 0x74, 0x20, 0x13,
    0x57, 0x8A, 0x9E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBC, 0xA9, 0x87, 0x65, 0x30, 0x13,
    0x44, 0x56, 0x78, 0x9A, 0xBE, 0xEF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0x98, 0x65, 0x54, 0x31, 0x12,
    0x33, 0x44, 0x55, 0x67, 0x78, 0x9A, 0xAC, 0xFC, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0x68, 0x88, 0x87, 0x77, 0x77, 0x76, 0x55, 0x54, 0x44, 0x43, 0x32, 0x22,
    0x33, 0x44, 0x45, 0x56, 0x67, 0x78, 0x89, 0x9A, 0xBB, 0x90, 0x00, 0x00,
   },
  },
  {
   {
    0x8A, 0x99, 0x88, 0x77, 0x76, 0x66, 0x55, 0x43, 0x33, 0x22, 0x22, 0x33,
    0x45, 0x67, 0x77, 0x88, 0x88, 0x99, 0xAA, 0x9A, 0xAA, 0x80, 0x00, 0x00,
   },
   {
    0xBC, 0xAA, 0xAB, 0xA9, 0x98, 0x87, 0x66, 0x54, 0x33, 0x21, 0x12, 0x45,
    0x89, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xEF, 0xFC, 0xCC, 0xBA, 0x98, 0x87, 0x65, 0x31, 0x02, 0x56,
    0x79, 0xBB, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFD, 0xBA, 0x98, 0x76, 0x42, 0x01, 0x36,
    0x78, 0x9A, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xBB, 0xA9, 0x87, 0x42, 0x01, 0x35,
    0x78, 0xAB, 0xFB, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xDD, 0xEC, 0xC9, 0x74, 0x10, 0x47, 0x89, 0x99, 0x99, 0x87, 0x76, 0x66,
    0x55, 0x55, 0x55, 0x56, 0x67, 0x78, 0x89, 0xBC, 0xCD, 0xE0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x98, 0x63, 0x10, 0x24,
    0x58, 0x9A, 0xBF, 0xEF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xDB, 0x97, 0x74, 0x10, 0x23,
    0x57, 0x9A, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCA, 0xA8, 0x65, 0x20, 0x13,
    0x56, 0x77, 0x89, 0x9B, 0xCE, 0xCF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0x9A, 0xAA, 0x76, 0x54, 0x21, 0x12,
    0x34, 0x45, 0x56, 0x66, 0x78, 0x99, 0xAF, 0xEC, 0xEF, 0xB0, 0x00, 0x00,
   },
   {
    0x78, 0x88, 0x87, 0x77, 0x66, 0x66, 0x65, 0x55, 0x54, 0x43, 0x22, 0x22,
    0x33, 0x44, 0x55, 0x67, 0x77, 0x88, 0x98, 0x99, 0xAA, 0x80, 0x00, 0x00,
   },
  },
  {
   {
    0x67, 0x77, 0x86, 0x66, 0x66, 0x65, 0x54, 0x44, 0x33, 0x32, 0x12, 0x34,
    0x57, 0x99, 0xAC, 0x9A, 0xAC, 0xFB, 0xCF, 0xEE, 0xEB, 0xA0, 0x00, 0x00,
   },
   {
    0xAA, 0x99, 0x88, 0x87, 0x77, 0x77, 0x66, 0x55, 0x43, 0x21, 0x12, 0x35,
    0x8A, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFA, 0xDA, 0x99, 0x98, 0x77, 0x76, 0x65, 0x53, 0x32, 0x02, 0x45,
    0x67, 0x9A, 0xCF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xCF, 0xFB, 0xBB, 0xE9, 0x87, 0x76, 0x42, 0x01, 0x36,
    0x89, 0xBB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA9, 0x76, 0x52, 0x01, 0x35,
    0x67, 0x8A, 0x9A, 0xC9, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xEC, 0xCC, 0xA9, 0x74, 0x10, 0x37, 0x88, 0x89, 0x99, 0x88, 0x87, 0x76,
    0x66, 0x55, 0x55, 0x56, 0x77, 0x78, 0xAA, 0xFE, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xBA, 0x87, 0x64, 0x10, 0x24,
    0x46, 0x77, 0xAB, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xCF, 0xFF, 0x88, 0x64, 0x10, 0x24,
    0x46, 0x78, 0x88, 0xAA, 0xBF, 0xCC, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xDC, 0xA7, 0x65, 0x20, 0x14,
    0x55, 0x57, 0x77, 0x88, 0x9A, 0xAA, 0xBB, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xF9, 0x97, 0x76, 0x53, 0x21, 0x13,
    0x34, 0x45, 0x55, 0x66, 0x66, 0x77, 0x88, 0xAA, 0xDC, 0xA0, 0x00, 0x00,
   },
   {
    0x9D, 0xAC, 0xBA, 0x98, 0x88, 0x77, 0x65, 0x54, 0x54, 0x43, 0x21, 0x23,
    0x34, 0x45, 0x55, 0x66, 0x67, 0x79, 0x99, 0x9D, 0xBB, 0x80, 0x00, 0x00,
   },
  },
  {
   {
    0x47, 0x7C, 0x65, 0x45, 0x45, 0x45, 0x45, 0x33, 0x43, 0x22, 0x23, 0x44,
    0x57, 0x77, 0xCC, 0xB8, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xC0, 0x00, 0x00,
   },
   {
    0x89, 0x88, 0x67, 0x68, 0x67, 0x76, 0x55, 0x55, 0x43, 0x21, 0x12, 0x46,
    0x8E, 0xEA, 0xEE, 0xEF, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xF0, 0x00, 0x00,
   },
   {
    0xEE, 0xDE, 0xD9, 0xD8, 0x87, 0x66, 0x64, 0x55, 0x44, 0x42, 0x02, 0x45,
    0x67, 0x8D, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xED, 0xDD, 0xE0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFA, 0xFF, 0xCF, 0xB7, 0x98, 0x66, 0x54, 0x42, 0x01, 0x57,
    0x89, 0xFA, 0xFF, 0xEF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xAA, 0x88, 0x76, 0x42, 0x01, 0x36,
    0x78, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xBC, 0xAA, 0xB8, 0x75, 0x10, 0x35, 0x78, 0x88, 0x87, 0x66, 0x66, 0x55,
    0x55, 0x66, 0x77, 0x77, 0x88, 0x99, 0x9A, 0xDB, 0xBB, 0xD0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFD, 0x99, 0x87, 0x65, 0x10, 0x23,
    0x56, 0x78, 0x9E, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xEF, 0xFE, 0xEF, 0xFF, 0xEE, 0xE9, 0xE8, 0x65, 0x54, 0x20, 0x23,
    0x34, 0x67, 0x7A, 0x99, 0x9F, 0xF9, 0xFF, 0xFE, 0xFE, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xEF, 0xEE, 0xEF, 0xFE, 0xEE, 0xE9, 0xEF, 0x87, 0x53, 0x20, 0x23,
    0x55, 0x55, 0x56, 0x68, 0x98, 0x8A, 0x9F, 0xFE, 0xFE, 0xF0, 0x00, 0x00,
   },
   {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x8A, 0x77, 0x54, 0x31, 0x23,
    0x44, 0x34, 0x44, 0x44, 0x43, 0x45, 0x57, 0xFA, 0xFB, 0xF0, 0x00, 0x00,
   },
   {
    0x7C, 0xB7, 0x8B, 0x76, 0x76, 0x66, 0x55, 0x54, 0x44, 0x43, 0x33, 0x32,
    0x33, 0x44, 0x54, 0x44, 0x44, 0x57, 0x98, 0x87, 0xCB, 0x50, 0x00, 0x00,
   },
  },
  {
   {
    0x46, 0xAB, 0x6A, 0x6B, 0x65, 0x54, 0x54, 0x32, 0x22, 0x32, 0x43, 0x44,
    0xA4, 0x6A, 0xAA, 0xAB, 0xBB, 0xBB, 0xBB, 0xAA, 0xAA, 0xB0, 0x00, 0x00,
   },
   {
    0x67, 0x66, 0x6B, 0x6C, 0x56, 0xB5, 0x55, 0x34, 0x32, 0x21, 0x23, 0x64,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCB, 0xC0, 0x00, 0x00,
   },
   {
    0xCC, 0xCC, 0xCC, 0xBC, 0x76, 0x57, 0x55, 0x54, 0x43, 0x21, 0x12, 0x46,
    0x7C, 0xBB, 0xBB, 0xBC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xC0, 0x00, 0x00,
   },
   {
    0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0x77, 0x43, 0x22, 0x02, 0x57,
    0x8D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD0, 0x00, 0x00,
   },
   {
    0xDD, 0xCD, 0xCC, 0xCD, 0xCC, 0xCC, 0xCC, 0xCC, 0x65, 0x42, 0x01, 0x3C,
    0x7C, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDC, 0xD0, 0x00, 0x00,
   },
   {
    0xEE, 0x8E, 0xD9, 0x75, 0x10, 0x35, 0x77, 0x66, 0x68, 0x77, 0x66, 0x65,
    0x66, 0x65, 0x66, 0x68, 0x88, 0xEE, 0xAE, 0xED, 0xDD, 0xE0, 0x00, 0x00,
   },
   {
    0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD8, 0xDD, 0x55, 0x20, 0x14,
    0x56, 0x4D, 0x7D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD0, 0x00, 0x00,
   },
   {
    0xCC, 0xCC, 0xCC, 0xBC, 0xCC, 0xCC, 0xCB, 0xBC, 0xC7, 0x63, 0x20, 0x23,
    0x44, 0x55, 0x76, 0x7C, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xC0, 0x00, 0x00,
   },
   {
    0xBB, 0xBB, 0xBA, 0xAB, 0xBB, 0xBA, 0xAA, 0xAB, 0xB5, 0xB6, 0x31, 0x22,
    0x34, 0x43, 0x34, 0x54, 0x45, 0x4B, 0xBB, 0xBB, 0xBB, 0xB0, 0x00, 0x00,
   },
   {
    0xCC, 0xBC, 0xCB, 0xBC, 0xCB, 0xBB, 0xBB, 0xB7, 0x66, 0x55, 0x42, 0x22,
    0x23, 0x34, 0x43, 0x35, 0x54, 0x55, 0x6C, 0xCB, 0xCB, 0xC0, 0x00, 0x00,
   },
   {
    0xCB, 0xBB, 0x6B, 0xB7, 0xBB, 0x6B, 0x65, 0x55, 0x34, 0x33, 0x43, 0x32,
    0x23, 0x34, 0x55, 0x44, 0x46, 0xBB, 0xBB, 0xB6, 0xBB, 0xC0, 0x00, 0x00,
   },
  },
  {
   {
    0x88, 0x78, 0x71, 0x78, 0x77, 0x77, 0x77, 0x78, 0x27, 0x71, 0x77, 0x17,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x77, 0x88, 0x87, 0x88, 0x80, 0x00, 0x00,
   },
   {
    0x99, 0x89, 0x88, 0x89, 0x88, 0x82, 0x88, 0x83, 0x83, 0x12, 0x22, 0x38,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x98, 0x90, 0x00, 0x00,
   },
   {
    0x99, 0x89, 0x88, 0x89, 0x88, 0x88, 0x38, 0x89, 0x22, 0x11, 0x28, 0x88,
    0x88, 0x88, 0x88, 0x89, 0x98, 0x88, 0x88, 0x98, 0x98, 0x90, 0x00, 0x00,
   },
   {
    0xAA, 0x9A, 0x99, 0x9A, 0x39, 0x99, 0x99, 0x33, 0x99, 0x42, 0x02, 0x99,
    0x99, 0x99, 0x99, 0x9A, 0xA9, 0x99, 0x99, 0x99, 0xA9, 0xA0, 0x00, 0x00,
   },
   {
    0xAA, 0x9A, 0x99, 0x9A, 0x99, 0x99, 0x99, 0x9A, 0xA9, 0x92, 0x01, 0x34,
    0x99, 0x99, 0x99, 0x9A, 0xA9, 0x99, 0x9A, 0xA9, 0xA9, 0xA0, 0x00, 0x00,
   },
   {
    0xAA, 0xAA, 0xAA, 0xAA, 0x30, 0x4A, 0xAA, 0x9A, 0xAA, 0xA4, 0x43, 0x43,
    0x35, 0x4A, 0x3A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA0, 0x00, 0x00,
   },
   {
    0xAA, 0x9A, 0x99, 0x9A, 0x99, 0x99, 0x99, 0x9A, 0x99, 0x93, 0x11, 0x13,
    0x34, 0x99, 0x99, 0x9A, 0x99, 0x99, 0x99, 0x99, 0xA9, 0xA0, 0x00, 0x00,
   },
   {
    0x99, 0x89, 0x88, 0x89, 0x88, 0x88, 0x88, 0x89, 0x88, 0x88, 0x31, 0x12,
    0x88, 0x18, 0x88, 0x89, 0x98, 0x88, 0x89, 0x99, 0x98, 0x90, 0x00, 0x00,
   },
   {
    0x88, 0x78, 0x77, 0x78, 0x77, 0x77, 0x77, 0x78, 0x77, 0x77, 0x71, 0x11,
    0x72, 0x77, 0x77, 0x78, 0x87, 0x77, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00,
   },
   {
    0xAA, 0x9A, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x39, 0x92, 0x21,
    0x19, 0x39, 0x99, 0x94, 0x93, 0x99, 0x99, 0x99, 0xAA, 0xA0, 0x00, 0x00,
   },
   {
    0x88, 0x78, 0x77, 0x78, 0x77, 0x77, 0x77, 0x78, 0x77, 0x72, 0x77, 0x72,
    0x17, 0x27, 0x77, 0x78, 0x87, 0x71, 0x78, 0x87, 0x88, 0x80, 0x00, 0x00,
   },
  },
 },
};

static const uint8_t short_codes_def[3][15][88] = {
 {
  {
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xDD, 0xFC, 0xCD, 0xFF, 0xFF, 0xFF, 0xCC, 0xCB, 0xBC,
    0xDF, 0xFF, 0xFD, 0xDB, 0xC9, 0x69, 0xBC, 0xFF, 0xFC, 0xFF, 0xB9, 0x42,
    0x5A, 0xCD, 0xFF, 0xFD, 0xDC, 0x62, 0x03, 0x9B, 0xCF, 0xFF, 0xFD, 0xC9,
    0x53, 0x4A, 0xCC, 0xFF, 0xFF, 0xFF, 0xBA, 0x9A, 0xBC, 0xFF, 0xFF, 0xFC,
    0xDC, 0xBC, 0xBC, 0xFF, 0xFF, 0xFF, 0xFE, 0xCC, 0xCD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xDF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCD, 0xFF,
    0xFF, 0xFF, 0xFC, 0xFC, 0xCC, 0xCF, 0xDF, 0xFF, 0xFF, 0xDB, 0xA9, 0x9B,
    0xCF, 0xDF, 0xFF, 0xCB, 0x97, 0x67, 0x9B, 0xFF, 0xFF, 0xDC, 0xA7, 0x42,
    0x47, 0xAD, 0xFF, 0xFF, 0xC9, 0x63, 0x03, 0x69, 0xBF, 0xFF, 0xFC, 0xA7,
    0x53, 0x47, 0xAC, 0xDF, 0xFD, 0xDC, 0x97, 0x77, 0x8C, 0xBD, 0xFF, 0xFF,
    0xCC, 0xAA, 0xAB, 0xCF, 0xFF, 0xFF, 0xFF, 0xCC, 0xCC, 0xCF, 0xFF, 0xFF,
    0xFF, 0xFE, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xDC, 0xFF, 0xDF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0xAF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x96, 0x56, 0x9F, 0xFF, 0xFF, 0xFF, 0xA6, 0x43,
    0x47, 0xEF, 0xFF, 0xFF, 0xF9, 0x53, 0x03, 0x6A, 0xFF, 0xFF, 0xFF, 0xA6,
    0x43, 0x46, 0xAF, 0xFF, 0xFF, 0xFF, 0x96, 0x56, 0x9F, 0xFF, 0xFF, 0xFF,
    0xFF, 0xC9, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xDD, 0xFF, 0xFF, 0xFD, 0xFF, 0xFD, 0xFD, 0xFF,
    0xFF, 0xFF, 0xFF, 0xDD, 0xDB, 0xBC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFA, 0x43,
    0x6B, 0xFF, 0xDF, 0xFF, 0xFD, 0xA3, 0x02, 0xAD, 0xFF, 0xFF, 0xFD, 0xFB,
    0x52, 0x3A, 0xDF, 0xFF, 0xFF, 0xFF, 0xCB, 0xAA, 0xCE, 0xFF, 0xDF, 0xFF,
    0xFE, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xFD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xCF, 0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xCC, 0xCA,
    0xFF, 0xCF, 0xFB, 0xAA, 0xAA, 0xCF, 0xCB, 0xFC, 0xFF, 0xAA, 0xA9, 0x99,
    0xAC, 0xBF, 0xFC, 0xA9, 0x98, 0x88, 0x99, 0xAA, 0xCF, 0xCA, 0xA8, 0x53,
    0x58, 0x9F, 0xCC, 0xCC, 0xB9, 0x73, 0x02, 0x68, 0xAC, 0xCF, 0xCA, 0x98,
    0x53, 0x37, 0x9B, 0xAC, 0xFB, 0xAA, 0x97, 0x78, 0x8A, 0xFB, 0xFF, 0xFA,
    0xBB, 0x99, 0x9A, 0xAB, 0xFF, 0xFF, 0xEB, 0xBA, 0xAA, 0xAC, 0xCB, 0xFF,
    0xBF, 0xBC, 0xBC, 0xCF, 0xFF, 0xFF, 0xCF, 0xFC, 0xFC, 0xFF, 0xFF, 0xCF,
    0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFD, 0xFC, 0xFF,
    0xFF, 0xFF, 0xFC, 0xAB, 0xBA, 0xFC, 0xFF, 0xFF, 0xFF, 0xA9, 0x77, 0x78,
    0xAF, 0xFF, 0xFF, 0xA8, 0x65, 0x45, 0x68, 0xFF, 0xFC, 0xFB, 0x74, 0x33,
    0x35, 0x7B, 0xFF, 0xFF, 0xB7, 0x43, 0x23, 0x46, 0xAF, 0xFF, 0xCB, 0x75,
    0x33, 0x35, 0x7A, 0xCC, 0xFF, 0xF8, 0x65, 0x45, 0x68, 0xAC, 0xCF, 0xCC,
    0xA8, 0x77, 0x78, 0xBF, 0xFF, 0xFF, 0xFF, 0xB9, 0x99, 0xFC, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0xFC, 0xFF,
    0xFF, 0xFC, 0xFB, 0x9A, 0x99, 0xBA, 0xFF, 0xFF, 0xFB, 0x97, 0x77, 0x77,
    0x9C, 0xCF, 0xFC, 0x98, 0x65, 0x45, 0x68, 0xAF, 0xFF, 0xC9, 0x75, 0x33,
    0x35, 0x79, 0xFF, 0xFB, 0x86, 0x43, 0x23, 0x47, 0x9F, 0xFF, 0xC9, 0x75,
    0x33, 0x35, 0x7B, 0xBF, 0xFF, 0xA8, 0x65, 0x45, 0x68, 0xAF, 0xFF, 0xFA,
    0xA8, 0x77, 0x78, 0x9B, 0xFF, 0xFF, 0xFF, 0xFB, 0x99, 0xBB, 0xFF, 0xFF,
    0xFF, 0xFE, 0xCE, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBB, 0xBC, 0xEF,
    0xFF, 0xFF, 0xDB, 0x99, 0x89, 0xAC, 0xDF, 0xFF, 0xDB, 0x97, 0x66, 0x67,
    0x9C, 0xFF, 0xEC, 0x97, 0x65, 0x45, 0x67, 0xAC, 0xFF, 0xB9, 0x65, 0x33,
    0x35, 0x69, 0xBF, 0xFB, 0x86, 0x43, 0x33, 0x46, 0x9B, 0xEE, 0xB9, 0x65,
    0x33, 0x35, 0x69, 0xBE, 0xFD, 0xA7, 0x65, 0x45, 0x67, 0xAC, 0xDF, 0xDB,
    0x97, 0x66, 0x67, 0x9B, 0xDF, 0xFF, 0xDC, 0xA9, 0x89, 0x9B, 0xCF, 0xFF,
    0xFF, 0xDC, 0xBB, 0xBC, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xEF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xBB, 0xFF,
    0xFF, 0xFF, 0xFF, 0xAA, 0x99, 0xAB, 0xFF, 0xFF, 0xFA, 0x98, 0x76, 0x67,
    0xAC, 0xCF, 0xFA, 0xA7, 0x64, 0x45, 0x67, 0x9B, 0xFF, 0xF8, 0x74, 0x33,
    0x34, 0x68, 0xAF, 0xFB, 0x96, 0x43, 0x33, 0x46, 0x8B, 0xFF, 0xF9, 0x75,
    0x43, 0x35, 0x69, 0xBF, 0xCC, 0x98, 0x65, 0x45, 0x67, 0x9A, 0xBF, 0xFF,
    0x98, 0x66, 0x68, 0x8F, 0xFF, 0xFF, 0xFF, 0x98, 0x88, 0xAF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xBA, 0xBA, 0xBE, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF,
    0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF,
    0xFF, 0xAA, 0xFF, 0xF9, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x88, 0x7F,
    0xAF, 0xFA, 0xFF, 0xF8, 0x75, 0x55, 0x79, 0xFF, 0xFF, 0xF9, 0x75, 0x32,
    0x34, 0x8A, 0xFF, 0xFF, 0xB8, 0x43, 0x22, 0x58, 0xFF, 0xFF, 0xCF, 0x95,
    0x33, 0x46, 0x7A, 0xFF, 0xFA, 0xFF, 0x75, 0x46, 0x79, 0xFA, 0xFF, 0xAF,
    0xF9, 0x89, 0x8A, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xAA, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFA,
    0x90, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xBA, 0xAA, 0x99, 0xAA, 0xBD, 0xBB, 0xBA, 0x99, 0x88, 0x89, 0x9B,
    0xCC, 0xBA, 0x98, 0x77, 0x77, 0x78, 0x9A, 0xBA, 0x98, 0x76, 0x65, 0x66,
    0x78, 0xAB, 0xA8, 0x76, 0x55, 0x45, 0x56, 0x79, 0xA9, 0x87, 0x55, 0x44,
    0x44, 0x67, 0x8A, 0x98, 0x75, 0x44, 0x44, 0x45, 0x68, 0x9A, 0x87, 0x65,
    0x44, 0x45, 0x67, 0x8A, 0xA9, 0x76, 0x55, 0x45, 0x56, 0x79, 0xAB, 0x98,
    0x76, 0x55, 0x56, 0x78, 0x9A, 0xBA, 0x98, 0x77, 0x77, 0x78, 0x9A, 0xCD,
    0xCB, 0xA9, 0x88, 0x89, 0xAA, 0xBB, 0xDD, 0xCA, 0xA9, 0x9A, 0xAB, 0xCC,
    0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xCA, 0xAA, 0xAA, 0xAB, 0xCE, 0xDC, 0xCB, 0xA9, 0x88, 0x89, 0x9B,
    0xCD, 0xBB, 0x98, 0x87, 0x77, 0x78, 0xAB, 0xDA, 0xA8, 0x76, 0x65, 0x66,
    0x78, 0xAC, 0xA9, 0x76, 0x55, 0x44, 0x56, 0x79, 0xAA, 0x97, 0x65, 0x44,
    0x44, 0x67, 0x9A, 0xA8, 0x75, 0x44, 0x34, 0x45, 0x79, 0x9A, 0x87, 0x65,
    0x44, 0x45, 0x67, 0x9A, 0xB9, 0x76, 0x55, 0x45, 0x56, 0x79, 0xAB, 0xA8,
    0x76, 0x65, 0x66, 0x78, 0xBB, 0xCB, 0xA8, 0x77, 0x77, 0x78, 0xAB, 0xBD,
    0xCB, 0xA9, 0x98, 0x99, 0xAA, 0xCD, 0xFD, 0xFB, 0xAA, 0xAB, 0xAB, 0xCC,
    0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xCB, 0xAA, 0xAA, 0xAB, 0xCE, 0xED, 0xCB, 0xA9, 0x88, 0x89, 0xAB,
    0xCE, 0xCB, 0x98, 0x77, 0x77, 0x78, 0x9B, 0xCB, 0xA8, 0x76, 0x65, 0x56,
    0x78, 0xAB, 0xA9, 0x76, 0x55, 0x45, 0x56, 0x79, 0xBA, 0x87, 0x55, 0x44,
    0x45, 0x57, 0x8A, 0xA8, 0x75, 0x44, 0x34, 0x45, 0x78, 0xAA, 0x87, 0x65,
    0x44, 0x45, 0x67, 0x8A, 0xA9, 0x76, 0x55, 0x45, 0x56, 0x79, 0xAB, 0xA8,
    0x76, 0x65, 0x66, 0x78, 0xAB, 0xCB, 0x98, 0x77, 0x77, 0x78, 0x9B, 0xCD,
    0xCB, 0xA9, 0x88, 0x89, 0xAB, 0xCD, 0xED, 0xCB, 0xAA, 0xAA, 0xAB, 0xCD,
    0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xCB, 0xB9, 0xAA, 0xBB, 0xFF, 0xDD, 0xCB, 0xA9, 0x89, 0x89, 0x9B,
    0xEF, 0xBB, 0xA8, 0x77, 0x77, 0x78, 0x9B, 0xFC, 0xA8, 0x76, 0x55, 0x56,
    0x78, 0xAB, 0xB9, 0x76, 0x55, 0x45, 0x56, 0x79, 0xBB, 0x97, 0x65, 0x44,
    0x44, 0x57, 0x8A, 0xA8, 0x75, 0x44, 0x44, 0x45, 0x68, 0xAA, 0x87, 0x65,
    0x44, 0x45, 0x57, 0x9A, 0xB9, 0x76, 0x55, 0x45, 0x56, 0x79, 0xBB, 0x98,
    0x76, 0x55, 0x66, 0x78, 0xAB, 0xFB, 0xA8, 0x77, 0x77, 0x78, 0xAB, 0xBD,
    0xFB, 0xA9, 0x88, 0x89, 0xAC, 0xCC, 0xBC, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB,
    0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xAB, 0xA9, 0xAA, 0xAB, 0xCC, 0xDC, 0xBA, 0x98, 0x88, 0x88, 0x9A,
    0xBD, 0xBA, 0x98, 0x77, 0x77, 0x78, 0x9B, 0xCA, 0xA8, 0x76, 0x65, 0x56,
    0x78, 0xAB, 0xA9, 0x76, 0x55, 0x45, 0x56, 0x79, 0xBA, 0x87, 0x55, 0x44,
    0x45, 0x57, 0x89, 0x98, 0x75, 0x44, 0x44, 0x45, 0x68, 0x9A, 0x87, 0x55,
    0x44, 0x45, 0x57, 0x89, 0xA8, 0x76, 0x55, 0x55, 0x56, 0x79, 0xAB, 0xA8,
    0x76, 0x55, 0x56, 0x78, 0x9A, 0xCB, 0xA8, 0x77, 0x77, 0x78, 0x9B, 0xDC,
    0xCB, 0xA9, 0x88, 0x89, 0x9A, 0xBD, 0xCB, 0xCB, 0xA9, 0xA9, 0xAA, 0xBB,
    0xB0, 0x00, 0x00, 0x00,
  },
 },
 {
  {
    0xAF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0xAF,
    0xFF, 0xFF, 0xFF, 0xFB, 0x96, 0x56, 0x9F, 0xFF, 0xFF, 0xFF, 0xA6, 0x32,
    0x36, 0xAF, 0xFF, 0xFF, 0xF9, 0x63, 0x12, 0x6A, 0xFF, 0xFF, 0xFF, 0x96,
    0x33, 0x36, 0xBF, 0xFF, 0xFF, 0xFF, 0x96, 0x56, 0x9A, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDA, 0x9A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x56, 0xFC, 0xCF, 0xFF, 0xFF, 0xF6, 0x32,
    0x39, 0xFF, 0xFF, 0xFF, 0xF8, 0x62, 0x12, 0x6F, 0xFF, 0xFF, 0xFF, 0xF6,
    0x43, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xA6, 0x58, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x96, 0x56, 0x9F, 0xFF, 0xFF, 0xFF, 0xB6, 0x43,
    0x36, 0xFF, 0xFF, 0xFF, 0xFB, 0x62, 0x12, 0x5B, 0xFF, 0xFF, 0xFF, 0xD6,
    0x42, 0x36, 0xFF, 0xFF, 0xFF, 0xFF, 0x96, 0x56, 0x9F, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFA, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x43,
    0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xA3, 0x11, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x61, 0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x8A, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x53,
    0x5E, 0xFF, 0xFF, 0xFF, 0xFF, 0x93, 0x11, 0x8F, 0xFF, 0xFF, 0xFF, 0xFE,
    0x51, 0x39, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0xCF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x77, 0x67, 0x76, 0x67, 0x77, 0x66, 0x66, 0x67, 0x77, 0x77, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x70, 0x00, 0x00, 0x00,
  },
  {
    0x77, 0x67, 0x76, 0x67, 0x77, 0x66, 0x66, 0x67, 0x77, 0x77, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x70, 0x00, 0x00, 0x00,
  },
  {
    0x77, 0x67, 0x76, 0x67, 0x77, 0x66, 0x66, 0x67, 0x77, 0x77, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x70, 0x00, 0x00, 0x00,
  },
  {
    0x77, 0x67, 0x76, 0x67, 0x77, 0x66, 0x66, 0x67, 0x77, 0x77, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x70, 0x00, 0x00, 0x00,
  },
  {
    0x77, 0x67, 0x76, 0x67, 0x77, 0x66, 0x66, 0x67, 0x77, 0x77, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x70, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xAA, 0xAA, 0xAC, 0xDE, 0xCB, 0xBA, 0xA9, 0x98, 0x99, 0xAB,
    0xDE, 0xBA, 0x98, 0x77, 0x77, 0x78, 0xAB, 0xEA, 0xA8, 0x76, 0x65, 0x66,
    0x79, 0xAC, 0xA9, 0x86, 0x54, 0x44, 0x56, 0x79, 0xAA, 0x87, 0x65, 0x44,
    0x45, 0x57, 0x9A, 0xA9, 0x75, 0x44, 0x34, 0x45, 0x78, 0x9A, 0x87, 0x65,
    0x44, 0x45, 0x67, 0x9A, 0xB9, 0x86, 0x55, 0x45, 0x56, 0x89, 0xAC, 0xA8,
    0x76, 0x65, 0x66, 0x78, 0x9A, 0xCC, 0xA8, 0x87, 0x77, 0x89, 0x9B, 0xBF,
    0xDB, 0xA9, 0x98, 0x99, 0x9B, 0xBC, 0xDF, 0xCB, 0xAA, 0xB9, 0xAB, 0xBB,
    0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xCB, 0xAA, 0x9A, 0xAB, 0xCE, 0xCD, 0xCB, 0x99, 0x88, 0x89, 0x9B,
    0xCD, 0xCA, 0x98, 0x77, 0x67, 0x78, 0x9B, 0xCB, 0xA8, 0x76, 0x65, 0x56,
    0x78, 0xAB, 0xA9, 0x76, 0x55, 0x45, 0x56, 0x79, 0xAA, 0x87, 0x65, 0x44,
    0x45, 0x57, 0x8A, 0x98, 0x65, 0x44, 0x44, 0x45, 0x78, 0xAA, 0x87, 0x55,
    0x44, 0x45, 0x57, 0x8A, 0xA9, 0x76, 0x55, 0x45, 0x56, 0x79, 0xAB, 0xA8,
    0x76, 0x55, 0x66, 0x78, 0x9B, 0xCB, 0xA8, 0x77, 0x67, 0x78, 0x9B, 0xCD,
    0xDB, 0xA9, 0x88, 0x89, 0x9B, 0xCD, 0xDC, 0xDB, 0xAA, 0xA9, 0xAB, 0xBE,
    0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xBB, 0xAA, 0xAA, 0xAB, 0xCD, 0xDC, 0xCB, 0x99, 0x88, 0x89, 0xAB,
    0xCD, 0xBB, 0x98, 0x77, 0x77, 0x78, 0x9B, 0xCB, 0xA8, 0x76, 0x55, 0x56,
    0x78, 0xAB, 0xA9, 0x76, 0x55, 0x44, 0x56, 0x79, 0xAA, 0x87, 0x65, 0x44,
    0x45, 0x57, 0x8A, 0xA8, 0x75, 0x44, 0x44, 0x45, 0x68, 0xAA, 0x87, 0x55,
    0x44, 0x45, 0x67, 0x89, 0xA9, 0x76, 0x55, 0x45, 0x56, 0x79, 0xAB, 0xA8,
    0x76, 0x65, 0x66, 0x78, 0xAA, 0xCB, 0x98, 0x77, 0x77, 0x78, 0x9A, 0xBD,
    0xCB, 0xA9, 0x88, 0x89, 0xAB, 0xBB, 0xDD, 0xCB, 0xAA, 0x9A, 0xAA, 0xBB,
    0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xEC, 0xBA, 0xAA, 0xBD, 0xEF, 0xDD, 0xCB, 0xA9, 0x99, 0x9A, 0xBD,
    0xCF, 0xDB, 0x98, 0x77, 0x77, 0x88, 0xAC, 0xDE, 0xA9, 0x76, 0x55, 0x66,
    0x79, 0x9F, 0xB9, 0x86, 0x55, 0x45, 0x56, 0x89, 0xBB, 0x97, 0x65, 0x44,
    0x45, 0x67, 0x9B, 0xB8, 0x75, 0x44, 0x34, 0x45, 0x79, 0xAA, 0x97, 0x64,
    0x44, 0x45, 0x57, 0x9B, 0xC9, 0x86, 0x55, 0x44, 0x56, 0x79, 0xBC, 0xA8,
    0x76, 0x55, 0x66, 0x79, 0xBF, 0xFC, 0xA8, 0x87, 0x77, 0x78, 0xAA, 0xFF,
    0xFC, 0xAA, 0x99, 0x99, 0xAC, 0xCF, 0xFF, 0xCB, 0xBA, 0xAB, 0xBC, 0xBE,
    0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xBB, 0xBB, 0x9B, 0xBB, 0xFE, 0xCD, 0xCC, 0xA9, 0x99, 0x99, 0xAC,
    0xED, 0xCC, 0xA8, 0x87, 0x77, 0x88, 0xAB, 0xCB, 0xA8, 0x76, 0x56, 0x66,
    0x79, 0xBC, 0xA9, 0x86, 0x55, 0x44, 0x56, 0x79, 0xCA, 0x97, 0x65, 0x44,
    0x44, 0x67, 0x8A, 0xA9, 0x75, 0x44, 0x34, 0x45, 0x79, 0xBB, 0x97, 0x64,
    0x44, 0x45, 0x67, 0x9A, 0xB9, 0x86, 0x54, 0x45, 0x56, 0x89, 0xBC, 0xA9,
    0x76, 0x66, 0x66, 0x79, 0xAC, 0xFC, 0xA8, 0x87, 0x77, 0x79, 0x9B, 0xDE,
    0xDC, 0xA9, 0x99, 0x9A, 0xAB, 0xBD, 0xBD, 0xDB, 0xBA, 0xAA, 0xBB, 0xCD,
    0xB0, 0x00, 0x00, 0x00,
  },
 },
 {
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x7F, 0xFC, 0xAF, 0xFF, 0xFF, 0xF6, 0x32,
    0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0x62, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x63, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xBF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xCC, 0xCF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0x99, 0xBB,
    0xFF, 0xFF, 0xFC, 0xBB, 0x86, 0x56, 0x9B, 0xFF, 0xFF, 0xFB, 0xA7, 0x42,
    0x36, 0xAF, 0xFF, 0xFF, 0xF9, 0x62, 0x13, 0x59, 0xFF, 0xFF, 0xFF, 0xA6,
    0x32, 0x47, 0xAF, 0xEF, 0xFF, 0xFF, 0x96, 0x57, 0x9A, 0xCC, 0xFF, 0xFF,
    0xFB, 0xAA, 0xAA, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xBF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x99, 0x9B,
    0xFF, 0xFF, 0xFF, 0xFA, 0x86, 0x56, 0x8B, 0xFF, 0xFF, 0xFF, 0xA6, 0x42,
    0x36, 0xAF, 0xFF, 0xFF, 0xF9, 0x52, 0x13, 0x58, 0xFF, 0xFF, 0xFF, 0xA5,
    0x33, 0x36, 0x9F, 0xFF, 0xFF, 0xFE, 0x86, 0x56, 0x8B, 0xFF, 0xFF, 0xFF,
    0xFE, 0xA8, 0x9A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x7F,
    0xFF, 0xFF, 0xFF, 0xFF, 0x75, 0x45, 0x68, 0xCF, 0xFF, 0xFF, 0xB5, 0x43,
    0x35, 0x8F, 0xFF, 0xFF, 0xF8, 0x43, 0x23, 0x57, 0xCF, 0xFF, 0xFF, 0xA5,
    0x32, 0x34, 0x8F, 0xFF, 0xFF, 0xFF, 0x64, 0x44, 0x6F, 0xFF, 0xFF, 0xFF,
    0xFF, 0x87, 0x98, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xAF, 0xFF, 0xFF, 0xFF, 0xF3,
    0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x52, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x8F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x88, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xF8, 0x67, 0x87,
    0xFF, 0xFF, 0xFF, 0xF8, 0x76, 0x54, 0x77, 0xEF, 0xFF, 0xFF, 0x84, 0x33,
    0x35, 0x7F, 0xFF, 0xF8, 0x86, 0x53, 0x23, 0x57, 0xFF, 0xFF, 0xFF, 0x65,
    0x33, 0x35, 0x78, 0xFF, 0xFF, 0xF8, 0x55, 0x44, 0x58, 0xEE, 0xEE, 0xFE,
    0xFE, 0x67, 0x88, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFC, 0xCC, 0xFC, 0xFF, 0xFF, 0xFF, 0xBC, 0xA9, 0xA9, 0xCF,
    0xFF, 0xFC, 0xBA, 0x98, 0x77, 0x89, 0xBF, 0xFF, 0xB9, 0x87, 0x66, 0x67,
    0x8A, 0xCF, 0xBA, 0x87, 0x65, 0x44, 0x67, 0x9F, 0xFB, 0xA8, 0x65, 0x43,
    0x45, 0x69, 0xCF, 0xEA, 0x76, 0x43, 0x33, 0x46, 0x8F, 0xFC, 0xA8, 0x65,
    0x43, 0x34, 0x68, 0xAF, 0xF9, 0x97, 0x64, 0x44, 0x57, 0xAF, 0xFF, 0xFA,
    0x97, 0x66, 0x67, 0x9C, 0xFF, 0xFF, 0xFB, 0xA9, 0x99, 0x9B, 0xFF, 0xFF,
    0xFF, 0xFF, 0xCB, 0xCC, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xDC, 0xCD, 0xCF, 0xFF,
    0xFF, 0xCC, 0xCB, 0xA9, 0x9A, 0xBC, 0xFF, 0xFD, 0xDB, 0xA8, 0x76, 0x78,
    0xAD, 0xFF, 0xDC, 0xA8, 0x65, 0x45, 0x68, 0xBF, 0xFE, 0xCA, 0x75, 0x33,
    0x35, 0x7A, 0xCF, 0xFC, 0xA6, 0x43, 0x23, 0x47, 0x9C, 0xFF, 0xC9, 0x75,
    0x33, 0x35, 0x79, 0xCE, 0xFD, 0xB8, 0x65, 0x45, 0x68, 0xAC, 0xDF, 0xFC,
    0xA8, 0x76, 0x78, 0xAB, 0xDF, 0xFF, 0xFD, 0xBA, 0x99, 0xAB, 0xCF, 0xFF,
    0xFF, 0xFD, 0xDD, 0xCD, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF,
    0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x9D, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xAF, 0x77, 0x8A,
    0xFF, 0xFF, 0xFF, 0xF9, 0x75, 0x45, 0x68, 0xFF, 0xFF, 0xFF, 0x84, 0x33,
    0x35, 0x9A, 0xFF, 0xFF, 0xF6, 0x43, 0x23, 0x47, 0xFF, 0xFF, 0xFF, 0x75,
    0x33, 0x35, 0x7A, 0xFF, 0xFF, 0xF8, 0x64, 0x45, 0x69, 0xFF, 0xFF, 0xFF,
    0x97, 0x86, 0x78, 0x9F, 0xFF, 0xFF, 0xAF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF,
    0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x77, 0x67, 0x76, 0x67, 0x77, 0x66, 0x66, 0x67, 0x77, 0x77, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x70, 0x00, 0x00, 0x00,
  },
  {
    0x77, 0x67, 0x76, 0x67, 0x77, 0x66, 0x66, 0x67, 0x77, 0x77, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x70, 0x00, 0x00, 0x00,
  },
  {
    0xEE, 0xDD, 0xDD, 0xDD, 0x5D, 0xDD, 0x4D, 0xDD, 0xDD, 0xD6, 0xDD, 0xD5,
    0xDD, 0xDD, 0x5D, 0xDD, 0x6D, 0xDD, 0xDD, 0xD5, 0xDD, 0xDD, 0xD6, 0xDD,
    0xDD, 0x6D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD6, 0xDD, 0xDD, 0xD6,
    0xD5, 0xDD, 0x5D, 0x6D, 0x55, 0xDD, 0x0D, 0x55, 0x65, 0xDD, 0x5D, 0xDD,
    0x66, 0xDD, 0xDD, 0xDD, 0xDD, 0xD5, 0xD5, 0x5D, 0x5D, 0xD6, 0xDD, 0xDD,
    0xDD, 0xDD, 0xD6, 0xD5, 0x6D, 0x6D, 0x6D, 0xD4, 0x6D, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0x55, 0xD6, 0xDD, 0xDE,
    0xE0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0x9B, 0xA9, 0x9B, 0xAC, 0xCC, 0xFA, 0xBA, 0xBB, 0xA9, 0xAA, 0xBF,
    0xFF, 0xAA, 0xAA, 0x98, 0x88, 0x88, 0xAD, 0xF9, 0x99, 0x88, 0x76, 0x66,
    0x79, 0xAA, 0x99, 0x98, 0x75, 0x54, 0x56, 0x8F, 0xFA, 0xA9, 0x75, 0x43,
    0x34, 0x68, 0xAB, 0xBA, 0x86, 0x53, 0x33, 0x56, 0x8A, 0xBC, 0xB8, 0x64,
    0x33, 0x45, 0x79, 0xAC, 0xCB, 0x86, 0x54, 0x55, 0x67, 0x8A, 0xAC, 0xCA,
    0x76, 0x67, 0x78, 0x89, 0xBB, 0xFF, 0xB9, 0x78, 0x88, 0x9A, 0xBB, 0x9F,
    0xFD, 0xF9, 0xAB, 0x9A, 0xAB, 0xAA, 0xFF, 0xFC, 0xFA, 0xAB, 0x99, 0xAA,
    0x80, 0x00, 0x00, 0x00,
  },
  {
    0xCC, 0xBC, 0xBB, 0xBC, 0xBB, 0xBB, 0xBB, 0xBC, 0xCB, 0xBB, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xB4, 0xBB,
    0xBB, 0xBB, 0xBB, 0xB4, 0x44, 0xB4, 0x2B, 0xBC, 0xCC, 0xCB, 0xBB, 0x33,
    0x4B, 0xBB, 0xBB, 0xBB, 0xB4, 0xBB, 0x44, 0x3B, 0xBB, 0xBB, 0xBB, 0xBB,
    0xB3, 0xB4, 0xBB, 0xBB, 0xBB, 0xBB, 0xB4, 0x44, 0x3B, 0xBB, 0xBB, 0xBB,
    0xB4, 0xB3, 0xBB, 0xBC, 0xCC, 0xCC, 0xCC, 0xCB, 0xB4, 0xBB, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCB, 0xCC, 0xCC,
    0xC0, 0x00, 0x00, 0x00,
  },
  {
    0x77, 0x67, 0x76, 0x67, 0x77, 0x66, 0x66, 0x67, 0x77, 0x77, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x70, 0x00, 0x00, 0x00,
  },
 },
};

static const uint8_t long_codes_def[3][125][224] = {
 {
  {
    0xBE, 0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF,
    0xFE, 0xED, 0xDD, 0xCC, 0xDE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE, 0xED, 0xDC,
    0xCB, 0xCB, 0xBB, 0xCC, 0xDE, 0xEF, 0xFF, 0xFE, 0xED, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xDD, 0xFF, 0xFF, 0xFE, 0xDC, 0xBB, 0xA9, 0x99, 0x99,
    0x99, 0xAB, 0xCD, 0xEF, 0xFE, 0xEC, 0xCB, 0xA9, 0x88, 0x87, 0x78, 0x89,
    0xAB, 0xCD, 0xFF, 0xFE, 0xCB, 0xA9, 0x87, 0x77, 0x66, 0x77, 0x89, 0xAB,
    0xDE, 0xFD, 0xDC, 0xAA, 0x87, 0x76, 0x65, 0x66, 0x67, 0x89, 0xBC, 0xEF,
    0xDD, 0xBA, 0x98, 0x76, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xED, 0xDC,
    0xA9, 0x87, 0x65, 0x54, 0x45, 0x56, 0x79, 0xAC, 0xDD, 0xDD, 0xCA, 0x98,
    0x65, 0x54, 0x44, 0x55, 0x67, 0x9A, 0xBD, 0xDE, 0xEB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x66, 0x89, 0xAB, 0xDD, 0xED, 0xCA, 0x98, 0x76, 0x55, 0x55,
    0x56, 0x78, 0x9A, 0xCC, 0xDE, 0xFC, 0xBA, 0x87, 0x76, 0x65, 0x66, 0x77,
    0x89, 0xBB, 0xDD, 0xFE, 0xDB, 0xA9, 0x87, 0x76, 0x67, 0x77, 0x89, 0xAB,
    0xCD, 0xDF, 0xEF, 0xCB, 0xA9, 0x88, 0x87, 0x88, 0x89, 0xAB, 0xCC, 0xED,
    0xFF, 0xED, 0xCB, 0xA9, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xEF, 0xFF,
    0xFD, 0xDB, 0xBA, 0xAA, 0xAA, 0xAB, 0xCC, 0xDE, 0xFD, 0xFF, 0xFF, 0xFD,
    0xDC, 0xCC, 0xBC, 0xCC, 0xDC, 0xDE, 0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0xDE,
    0xDD, 0xCD, 0xDD, 0xEE, 0xFF, 0xFE, 0xDF, 0xFF, 0xFF, 0xEF, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDD, 0xFD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xCD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xEF, 0xFF, 0xFF, 0xCF, 0xFE,
    0xDC, 0xDC, 0xCC, 0xBB, 0xCC, 0xCC, 0xDE, 0xEF, 0xFF, 0xEE, 0xDD, 0xCC,
    0xCB, 0xBA, 0xAA, 0xBB, 0xBC, 0xDD, 0xFF, 0xDC, 0xDD, 0xCB, 0xBA, 0xA9,
    0x99, 0x9A, 0x9A, 0xBC, 0xDF, 0xFF, 0xBD, 0xDB, 0xBA, 0x99, 0x88, 0x88,
    0x88, 0x9A, 0xBC, 0xEF, 0xDD, 0xCC, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x67, 0x78, 0x9A,
    0xCC, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x65, 0x66, 0x67, 0x88, 0xAB, 0xCC,
    0xCC, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x67, 0x89, 0xBC, 0xCC, 0xCA,
    0x98, 0x76, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xCC, 0xBB, 0xA9, 0x87,
    0x66, 0x55, 0x55, 0x56, 0x67, 0x89, 0xAC, 0xBC, 0xCA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCC, 0xB9, 0x87, 0x66, 0x55, 0x55,
    0x56, 0x77, 0x89, 0xAB, 0xCD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x67,
    0x89, 0xAB, 0xBD, 0xDF, 0xCA, 0x98, 0x87, 0x76, 0x66, 0x77, 0x89, 0x9A,
    0xBC, 0xCF, 0xDD, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x88, 0x9A, 0xBC, 0xDD,
    0xFF, 0xDC, 0xBA, 0x99, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBC, 0xDF, 0xFF,
    0xDC, 0xBA, 0xAA, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xFF, 0xFF, 0xEC,
    0xBB, 0xBA, 0xAA, 0xAB, 0xBB, 0xDC, 0xDF, 0xDF, 0xFF, 0xFD, 0xEE, 0xCC,
    0xBC, 0xBB, 0xCC, 0xDD, 0xCE, 0xFE, 0xCF, 0xFF, 0xDD, 0xDD, 0xCD, 0xDC,
    0xCB, 0xBD, 0xCD, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEF, 0xFF, 0xDD, 0xEE,
    0xDD, 0xCD, 0xCC, 0xCC, 0xCC, 0xCD, 0xDF, 0xFF, 0xFF, 0xDE, 0xDD, 0xCC,
    0xBB, 0xBB, 0xBA, 0xBB, 0xCD, 0xDE, 0xFF, 0xFD, 0xDD, 0xCC, 0xBA, 0xAA,
    0x99, 0x9A, 0xAA, 0xBC, 0xDE, 0xFF, 0xCD, 0xCB, 0xBA, 0x99, 0x98, 0x88,
    0x89, 0x9A, 0xBC, 0xDF, 0xED, 0xCC, 0xBA, 0x98, 0x88, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xDE, 0xCC, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x67, 0x78, 0x9A,
    0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x76, 0x65, 0x56, 0x67, 0x89, 0xAB, 0xCC,
    0xCC, 0xBA, 0x98, 0x76, 0x55, 0x55, 0x56, 0x67, 0x89, 0xBC, 0xCC, 0xCA,
    0x98, 0x76, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCC, 0xCC, 0xB9, 0x87,
    0x65, 0x55, 0x45, 0x56, 0x67, 0x89, 0xAC, 0xCC, 0xCB, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x66, 0x78, 0x9B, 0xCC, 0xCC, 0xBA, 0x87, 0x76, 0x55, 0x55,
    0x56, 0x78, 0x99, 0xBC, 0xCD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCC, 0xDD, 0xCB, 0x98, 0x87, 0x76, 0x66, 0x77, 0x89, 0x9B,
    0xBC, 0xCE, 0xED, 0xBA, 0x98, 0x87, 0x77, 0x78, 0x89, 0x9A, 0xBC, 0xDC,
    0xEE, 0xDC, 0xBA, 0x99, 0x88, 0x88, 0x99, 0x9A, 0xBC, 0xCD, 0xCF, 0xFE,
    0xDD, 0xBB, 0xAA, 0x99, 0x9A, 0xAA, 0xBC, 0xCC, 0xDC, 0xFF, 0xFE, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xDF, 0xFF, 0xFF, 0xED, 0xCC,
    0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xFD, 0xDF, 0xFF, 0xED, 0xDD, 0xDC, 0xCC,
    0xCC, 0xCC, 0xCC, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xCD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDF, 0xFF, 0xFF, 0xDD, 0xFF,
    0xDF, 0xEC, 0xCC, 0xDC, 0xCD, 0xDD, 0xDF, 0xFF, 0xFF, 0xEE, 0xCC, 0xCC,
    0xBB, 0xBB, 0xBB, 0xAC, 0xCC, 0xEF, 0xEF, 0xFD, 0xDD, 0xCC, 0xBB, 0xAA,
    0x99, 0x9A, 0xAB, 0xBC, 0xDF, 0xFF, 0xDD, 0xCB, 0xBA, 0x99, 0x98, 0x88,
    0x89, 0x9A, 0xBC, 0xDD, 0xFC, 0xDB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xED, 0xBC, 0xBA, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x88, 0x9A,
    0xBD, 0xDD, 0xCB, 0xA9, 0x87, 0x66, 0x65, 0x56, 0x67, 0x89, 0xAC, 0xCE,
    0xCC, 0xBA, 0x98, 0x76, 0x55, 0x55, 0x56, 0x67, 0x8A, 0xBC, 0xDC, 0xDB,
    0xA9, 0x76, 0x65, 0x55, 0x55, 0x56, 0x78, 0xAA, 0xCC, 0xCC, 0xB9, 0x87,
    0x66, 0x55, 0x45, 0x55, 0x67, 0x89, 0xBC, 0xCC, 0xDB, 0xA8, 0x76, 0x65,
    0x55, 0x55, 0x66, 0x78, 0x9B, 0xCC, 0xCC, 0xBA, 0x97, 0x66, 0x55, 0x55,
    0x56, 0x78, 0x9A, 0xBC, 0xCF, 0xDC, 0xA9, 0x87, 0x66, 0x65, 0x66, 0x77,
    0x89, 0xAB, 0xCC, 0xFD, 0xCB, 0xA8, 0x87, 0x76, 0x66, 0x77, 0x89, 0xAB,
    0xBC, 0xCF, 0xFD, 0xCB, 0x99, 0x87, 0x77, 0x78, 0x89, 0xAA, 0xCC, 0xCC,
    0xFF, 0xDC, 0xBA, 0xA9, 0x98, 0x88, 0x99, 0x9A, 0xBC, 0xDD, 0xCF, 0xFE,
    0xDD, 0xBB, 0xAA, 0xA9, 0xAA, 0xAA, 0xBB, 0xBD, 0xDC, 0xFF, 0xFF, 0xDD,
    0xBC, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xFE, 0xCF, 0xFF, 0xFD, 0xFD, 0xDD,
    0xDC, 0xCC, 0xCC, 0xDD, 0xDE, 0xFE, 0xCF, 0xFF, 0xDD, 0xCD, 0xDD, 0xCC,
    0xCD, 0xCC, 0xCD, 0xCD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBF, 0xEE, 0xDD, 0xDD, 0xCD, 0xDD, 0xDD, 0xEF, 0xFF, 0xFF, 0xDE, 0xFF,
    0xFD, 0xED, 0xDD, 0xCC, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEF, 0xDD,
    0xCC, 0xCB, 0xBB, 0xCC, 0xDE, 0xFF, 0xFF, 0xFE, 0xFD, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCD, 0xDF, 0xFF, 0xFF, 0xDC, 0xBA, 0xA9, 0x99, 0x89,
    0x99, 0xAB, 0xCD, 0xFF, 0xFD, 0xDD, 0xCA, 0xA9, 0x88, 0x87, 0x78, 0x89,
    0xAB, 0xCD, 0xFF, 0xDE, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x77, 0x89, 0xAB,
    0xDF, 0xFE, 0xDC, 0xA9, 0x87, 0x76, 0x65, 0x56, 0x67, 0x89, 0xAC, 0xEF,
    0xED, 0xCA, 0x98, 0x76, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xED, 0xDB,
    0xA9, 0x76, 0x65, 0x54, 0x55, 0x56, 0x79, 0xAB, 0xCE, 0xDD, 0xBA, 0x87,
    0x66, 0x54, 0x44, 0x55, 0x67, 0x9A, 0xBD, 0xDD, 0xDB, 0xA9, 0x86, 0x65,
    0x54, 0x55, 0x66, 0x79, 0xAB, 0xCD, 0xDD, 0xCA, 0x98, 0x76, 0x55, 0x55,
    0x56, 0x78, 0x9A, 0xCD, 0xDF, 0xFC, 0xB9, 0x87, 0x66, 0x65, 0x66, 0x77,
    0x89, 0xBC, 0xDD, 0xFF, 0xDC, 0xA9, 0x87, 0x76, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDF, 0xFF, 0xCB, 0xA9, 0x88, 0x87, 0x78, 0x89, 0xAB, 0xBC, 0xED,
    0xFF, 0xFD, 0xCB, 0xA9, 0x99, 0x99, 0x99, 0xAB, 0xBC, 0xDF, 0xEF, 0xFF,
    0xED, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xCC, 0xCD, 0xED, 0xFF, 0xFF, 0xFD,
    0xDC, 0xCB, 0xBC, 0xCC, 0xCD, 0xDE, 0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0xED,
    0xDE, 0xDD, 0xDE, 0xDD, 0xDF, 0xFF, 0xBF, 0xFF, 0xEF, 0xDF, 0xED, 0xDC,
    0xDD, 0xDD, 0xDE, 0xED, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xBC, 0xDC,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDD, 0xBC, 0xCB, 0xBA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCD, 0xDB, 0xCB, 0xAA, 0xA9, 0x98,
    0x88, 0x88, 0x99, 0x9A, 0xBB, 0xCC, 0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0xAB, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xAA, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xAA, 0xA9,
    0x88, 0x76, 0x66, 0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xAA, 0x98, 0x87,
    0x66, 0x65, 0x55, 0x56, 0x67, 0x88, 0x9A, 0xAA, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0xAA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x78, 0x99, 0xAA, 0xBA, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xAB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0xAA, 0xBA,
    0xBC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBC, 0xCB,
    0xBA, 0x99, 0x98, 0x88, 0x89, 0x99, 0x9A, 0xAB, 0xCB, 0xCC, 0xCB, 0xBA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBD, 0xDD, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDC, 0xBD, 0xCC, 0xBB, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xAA, 0xAA, 0x9A, 0x9A, 0xAA, 0xAB, 0xBB, 0xCD, 0xBB, 0xCC,
    0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDC, 0xBC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xCA, 0xBB, 0xAA, 0x99, 0x98,
    0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCB, 0xAB, 0xAA, 0x99, 0x88, 0x88, 0x77,
    0x88, 0x89, 0x9A, 0xAB, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0xAA, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x67, 0x78, 0x89,
    0xAA, 0xAA, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x66, 0x67, 0x78, 0x89, 0xAA,
    0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xA9, 0xA9,
    0x88, 0x76, 0x66, 0x65, 0x66, 0x66, 0x77, 0x89, 0xAA, 0xAA, 0x98, 0x77,
    0x66, 0x65, 0x55, 0x66, 0x67, 0x78, 0x9A, 0x99, 0xA9, 0x88, 0x76, 0x66,
    0x65, 0x66, 0x66, 0x78, 0x89, 0xA9, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x78, 0x89, 0xAA, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAA, 0xAB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78, 0x89, 0x9A, 0xAA,
    0xBB, 0xBA, 0x99, 0x88, 0x87, 0x78, 0x88, 0x89, 0x9A, 0xAB, 0xAB, 0xCB,
    0xAA, 0x99, 0x98, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xBA, 0xCC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xBD, 0xDC, 0xCC, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDB, 0xBD, 0xCC, 0xBA, 0xAA, 0xA9, 0x99,
    0xAA, 0xAA, 0xAB, 0xBB, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xAA, 0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xBB, 0xDC,
    0xBB, 0xAA, 0xAA, 0x99, 0x9A, 0xAA, 0xBB, 0xBC, 0xDD, 0xBC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCB, 0xBB, 0xAA, 0x99, 0x88,
    0x88, 0x88, 0x89, 0x99, 0xAB, 0xBB, 0xAB, 0xAA, 0x99, 0x88, 0x87, 0x77,
    0x78, 0x88, 0x99, 0xAB, 0xBA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x76, 0x66, 0x67, 0x77, 0x89,
    0x9A, 0xAA, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x66, 0x67, 0x78, 0x89, 0xAA,
    0x9A, 0x98, 0x87, 0x76, 0x66, 0x66, 0x66, 0x77, 0x78, 0x99, 0x99, 0x99,
    0x87, 0x76, 0x66, 0x66, 0x66, 0x66, 0x77, 0x89, 0x99, 0x99, 0x98, 0x77,
    0x66, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0x99, 0xA9, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x66, 0x77, 0x89, 0x99, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0x9A, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x78, 0x89, 0xA9, 0xAA, 0x99, 0x88, 0x77, 0x76, 0x66, 0x77, 0x78, 0x89,
    0x9A, 0xAA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78, 0x89, 0x9A, 0xBA,
    0xBB, 0xAA, 0x98, 0x88, 0x87, 0x77, 0x88, 0x89, 0x9A, 0xAB, 0xAB, 0xBB,
    0xA9, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBB, 0xCC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xBC, 0xDC, 0xBB, 0xBA, 0xAA,
    0x99, 0xAA, 0xAA, 0xBB, 0xBC, 0xCB, 0xBC, 0xCB, 0xBA, 0xAA, 0x99, 0x99,
    0x99, 0xAA, 0xAA, 0xBB, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0xCD, 0xBB, 0xCC,
    0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDC, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0x99, 0x9A, 0xBB, 0xBC, 0xCB, 0xBB, 0xAA, 0x99, 0x98,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB, 0xAB, 0xAA, 0x99, 0x88, 0x88, 0x78,
    0x88, 0x88, 0x9A, 0xAB, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x66, 0x77, 0x78, 0x89,
    0x9A, 0xAA, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x66, 0x67, 0x78, 0x89, 0xAA,
    0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0x99, 0xA9,
    0x88, 0x76, 0x66, 0x65, 0x66, 0x66, 0x77, 0x89, 0xA9, 0x9A, 0x98, 0x77,
    0x66, 0x65, 0x55, 0x66, 0x67, 0x88, 0x9A, 0x99, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x66, 0x66, 0x78, 0x89, 0xA9, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0x9A, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x78, 0x99, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x77, 0x78, 0x89,
    0xAA, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78, 0x89, 0x9A, 0xBA,
    0xBB, 0xAA, 0x99, 0x88, 0x87, 0x77, 0x88, 0x89, 0x9A, 0xAB, 0xAB, 0xBB,
    0xAA, 0x99, 0x98, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCB, 0xCD, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xBD, 0xDC, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDB, 0xBC, 0xCB, 0xBA, 0xAA, 0x9A, 0x99,
    0x99, 0xAA, 0xAA, 0xBB, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xCC, 0xDC,
    0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xED, 0xBC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xCB, 0xCB, 0xAA, 0x99, 0x98,
    0x88, 0x88, 0x99, 0x9A, 0xBB, 0xCC, 0xBB, 0xAA, 0x99, 0x88, 0x88, 0x78,
    0x88, 0x89, 0x9A, 0xBC, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBB, 0xAA, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x77, 0x78, 0x89,
    0xAA, 0xBA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA, 0xA9,
    0x88, 0x76, 0x66, 0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xAA, 0x98, 0x87,
    0x66, 0x65, 0x55, 0x66, 0x67, 0x88, 0x9A, 0xAA, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0xAA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67,
    0x78, 0x99, 0xAA, 0xAB, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x77, 0x78, 0x89,
    0xAA, 0xAB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78, 0x89, 0x9A, 0xBA,
    0xBC, 0xBA, 0x99, 0x88, 0x88, 0x78, 0x88, 0x89, 0x9A, 0xBB, 0xBC, 0xCB,
    0xBA, 0xA9, 0x98, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCB, 0xDD, 0xCB, 0xBA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xCD, 0xED, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDC, 0xBD, 0xDC, 0xBB, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xBF, 0xEE, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF,
    0xFE, 0xED, 0xDD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFE, 0xDD,
    0xCC, 0xCB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFE, 0xFE, 0xDC, 0xCB, 0xBA,
    0xAA, 0xAB, 0xBC, 0xDD, 0xFF, 0xFF, 0xEE, 0xDD, 0xBB, 0xA9, 0x99, 0x99,
    0x9A, 0xBC, 0xDE, 0xFF, 0xFD, 0xDC, 0xBB, 0xA9, 0x88, 0x77, 0x88, 0x99,
    0xAC, 0xDF, 0xFF, 0xDD, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x78, 0x8A, 0xBC,
    0xEF, 0xFD, 0xDC, 0xB9, 0x87, 0x66, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xFF,
    0xDD, 0xBA, 0x98, 0x76, 0x55, 0x45, 0x56, 0x78, 0xAB, 0xDE, 0xFD, 0xDB,
    0xA9, 0x76, 0x55, 0x44, 0x45, 0x67, 0x89, 0xBC, 0xEF, 0xED, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0x9B, 0xCD, 0xEE, 0xDC, 0xA9, 0x86, 0x55,
    0x44, 0x55, 0x67, 0x89, 0xBC, 0xDD, 0xEE, 0xCB, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0xAB, 0xCE, 0xEF, 0xFD, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xCD, 0xEE, 0xFF, 0xDC, 0xBA, 0x88, 0x77, 0x77, 0x78, 0x9A, 0xBC,
    0xDF, 0xEF, 0xFF, 0xDC, 0xBA, 0x98, 0x88, 0x89, 0x9A, 0xBC, 0xCD, 0xEF,
    0xFF, 0xFE, 0xDC, 0xBA, 0xA9, 0x99, 0xAA, 0xBB, 0xCD, 0xEF, 0xEF, 0xFF,
    0xFE, 0xDC, 0xCB, 0xBB, 0xBB, 0xBC, 0xDD, 0xEF, 0xFE, 0xFF, 0xFF, 0xFE,
    0xDD, 0xDC, 0xCC, 0xCD, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xEF, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFE, 0xED,
    0xDE, 0xEE, 0xEF, 0xEF, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAD, 0xCD, 0xCB, 0xBC, 0xCB, 0xCC, 0xCD, 0xDD, 0xDE, 0xEF, 0xBD, 0xDE,
    0xDD, 0xCC, 0xCC, 0xCC, 0xDC, 0xDD, 0xFF, 0xFF, 0xFF, 0xDD, 0xDD, 0xCB,
    0xBB, 0xBB, 0xBB, 0xBB, 0xDD, 0xEF, 0xEF, 0xDD, 0xDC, 0xCC, 0xBB, 0xAA,
    0xA9, 0xAA, 0xBB, 0xCC, 0xFF, 0xFE, 0xCD, 0xCC, 0xAA, 0x99, 0x98, 0x88,
    0x99, 0xAB, 0xCE, 0xFE, 0xCC, 0xCB, 0xBA, 0x98, 0x88, 0x77, 0x77, 0x89,
    0xAB, 0xCD, 0xFE, 0xCD, 0xBB, 0x99, 0x87, 0x76, 0x66, 0x77, 0x89, 0xAC,
    0xDE, 0xDC, 0xDB, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x67, 0x8A, 0xBC, 0xFD,
    0xCC, 0xBA, 0x98, 0x76, 0x55, 0x55, 0x56, 0x78, 0x9B, 0xCD, 0xDC, 0xCB,
    0x99, 0x76, 0x55, 0x44, 0x45, 0x67, 0x89, 0xAB, 0xDD, 0xCC, 0xBA, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xCD, 0xDC, 0xCB, 0xA8, 0x76, 0x65,
    0x54, 0x55, 0x67, 0x89, 0xAB, 0xDC, 0xCD, 0xBA, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xCD, 0xEC, 0xB9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBB, 0xDC, 0xDE, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xCE, 0xFD, 0xCB, 0xA9, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xCC, 0xDD,
    0xEF, 0xFD, 0xDB, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDD, 0xDF, 0xFD,
    0xFD, 0xCC, 0xBB, 0xAA, 0xAA, 0xBB, 0xBC, 0xDD, 0xFC, 0xEF, 0xEF, 0xED,
    0xDD, 0xCC, 0xBC, 0xBC, 0xCC, 0xED, 0xEE, 0xDF, 0xFF, 0xFF, 0xFD, 0xED,
    0xDC, 0xDC, 0xDD, 0xDD, 0xDD, 0xED, 0xBE, 0xDD, 0xDD, 0xDD, 0xDC, 0xDC,
    0xCD, 0xCC, 0xCC, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEF, 0xFF, 0xDD, 0xFE,
    0xDD, 0xCC, 0xCC, 0xCB, 0xCC, 0xDD, 0xDE, 0xFF, 0xFF, 0xDE, 0xDD, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDE, 0xFF, 0xFD, 0xDD, 0xCB, 0xAA, 0xA9,
    0x99, 0x99, 0xAB, 0xBC, 0xEF, 0xFF, 0xCD, 0xCB, 0xAA, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xDE, 0xEC, 0xCB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xEE, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x67, 0x89, 0xAB,
    0xCD, 0xEC, 0xCA, 0x99, 0x87, 0x66, 0x55, 0x56, 0x67, 0x89, 0xAB, 0xDD,
    0xCB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x55, 0x55, 0x66, 0x78, 0xAB, 0xCD, 0xCB, 0xA9, 0x87,
    0x65, 0x55, 0x45, 0x56, 0x67, 0x8A, 0xBC, 0xCC, 0xCA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x79, 0xAB, 0xCC, 0xCC, 0xB9, 0x87, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xDD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCC, 0xDD, 0xCB, 0x99, 0x87, 0x76, 0x67, 0x77, 0x89, 0xAB,
    0xCD, 0xDE, 0xDD, 0xBA, 0x99, 0x88, 0x77, 0x88, 0x89, 0xAA, 0xBC, 0xDD,
    0xEF, 0xDC, 0xBA, 0xA9, 0x98, 0x88, 0x99, 0xAA, 0xBC, 0xDD, 0xDF, 0xFF,
    0xDC, 0xCB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xED, 0xFF, 0xFE, 0xDC,
    0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xEF, 0xEF, 0xFF, 0xFF, 0xED, 0xDC,
    0xCC, 0xCC, 0xCD, 0xDE, 0xEE, 0xFE, 0xDF, 0xFF, 0xFE, 0xED, 0xDD, 0xDC,
    0xCD, 0xDD, 0xDD, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xBE, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEF, 0xEF, 0xCD, 0xFD,
    0xED, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xEE, 0xFF, 0xFF, 0xDE, 0xDC, 0xCB,
    0xBB, 0xBA, 0xAB, 0xBB, 0xCC, 0xDD, 0xFF, 0xFD, 0xDD, 0xCB, 0xAA, 0xA9,
    0x99, 0x9A, 0xAB, 0xBC, 0xDE, 0xFE, 0xCD, 0xCB, 0xBA, 0x99, 0x88, 0x88,
    0x89, 0xAA, 0xBD, 0xEF, 0xDC, 0xDC, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x89,
    0x9A, 0xCD, 0xFD, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x67, 0x89, 0xAC, 0xDD,
    0xCC, 0xB9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xCC, 0xCA,
    0x98, 0x76, 0x55, 0x54, 0x55, 0x67, 0x79, 0xAB, 0xDD, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x67, 0x8A, 0xBC, 0xCC, 0xCB, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xCC, 0xBA, 0x97, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xCD, 0xDB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xDC, 0xDD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xED, 0xBA, 0xA9, 0x88, 0x77, 0x88, 0x89, 0x9B, 0xBC, 0xDD,
    0xDE, 0xDC, 0xBB, 0xA9, 0x99, 0x99, 0x99, 0xAB, 0xBC, 0xCE, 0xCF, 0xFE,
    0xDC, 0xCB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xED, 0xFF, 0xEE, 0xED,
    0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCE, 0xEE, 0xDF, 0xFF, 0xFF, 0xED, 0xDD,
    0xDC, 0xCC, 0xCD, 0xDD, 0xFE, 0xFE, 0xBF, 0xFE, 0xDD, 0xDD, 0xCD, 0xCC,
    0xDD, 0xCC, 0xDD, 0xEE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBF, 0xFF, 0xFE, 0xEE, 0xEE, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF,
    0xFF, 0xEE, 0xDD, 0xDD, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xED,
    0xCC, 0xCB, 0xCC, 0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFE, 0xDC, 0xCB, 0xBA,
    0xAA, 0xAB, 0xBC, 0xDF, 0xFF, 0xFF, 0xEE, 0xDC, 0xBB, 0xA9, 0x99, 0x99,
    0x9A, 0xBC, 0xDF, 0xFF, 0xFE, 0xED, 0xCB, 0xA9, 0x88, 0x77, 0x88, 0x9A,
    0xBC, 0xDF, 0xFF, 0xEE, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x78, 0x8A, 0xBC,
    0xEF, 0xFD, 0xDC, 0xB9, 0x87, 0x66, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xFF,
    0xDD, 0xCA, 0x98, 0x76, 0x55, 0x45, 0x56, 0x78, 0xAB, 0xDF, 0xFE, 0xDC,
    0xA9, 0x76, 0x55, 0x44, 0x45, 0x67, 0x89, 0xBC, 0xEF, 0xED, 0xCA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0x9B, 0xCE, 0xEE, 0xDC, 0xA9, 0x76, 0x55,
    0x44, 0x55, 0x67, 0x89, 0xBC, 0xEE, 0xEE, 0xCB, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0xAB, 0xCE, 0xEF, 0xFD, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBD, 0xEF, 0xFF, 0xEC, 0xB9, 0x98, 0x77, 0x77, 0x78, 0x9A, 0xBC,
    0xDF, 0xFF, 0xFF, 0xDC, 0xBA, 0x98, 0x88, 0x88, 0x9A, 0xBB, 0xDE, 0xFF,
    0xFF, 0xFE, 0xDC, 0xBA, 0xA9, 0x99, 0xAA, 0xBB, 0xCD, 0xFF, 0xFF, 0xFF,
    0xFE, 0xEC, 0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xED, 0xDC, 0xCC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xEE, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDE, 0xBC, 0xDD,
    0xCB, 0xBB, 0xBA, 0xAA, 0xBB, 0xBB, 0xCC, 0xDD, 0xED, 0xCC, 0xCB, 0xBA,
    0xAA, 0xA9, 0x99, 0xAA, 0xBB, 0xCC, 0xDE, 0xDB, 0xCB, 0xBA, 0xA9, 0x99,
    0x99, 0x99, 0x9A, 0xAB, 0xCD, 0xDC, 0xBC, 0xBA, 0xA9, 0x98, 0x88, 0x88,
    0x88, 0x99, 0xAB, 0xCD, 0xCB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xAB, 0xCC, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x67, 0x78, 0x9A,
    0xBC, 0xCA, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67, 0x89, 0x9A, 0xBB,
    0xAA, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xBA, 0xA9,
    0x98, 0x76, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBB, 0xAA, 0x99, 0x87,
    0x66, 0x55, 0x55, 0x56, 0x67, 0x89, 0xAB, 0xBB, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xBB, 0xA9, 0x87, 0x66, 0x65, 0x55,
    0x66, 0x78, 0x89, 0xAB, 0xBB, 0xBA, 0x98, 0x87, 0x66, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xBB, 0xAA, 0x98, 0x87, 0x77, 0x67, 0x77, 0x88, 0x9A,
    0xBB, 0xBC, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x78, 0x88, 0x9A, 0xAB, 0xCB,
    0xCC, 0xCB, 0xAA, 0x99, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBC, 0xBD, 0xDC,
    0xCB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDC, 0xDE, 0xED, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xCD, 0xEE, 0xDD, 0xCC, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xDC, 0xAE, 0xDD, 0xCC, 0xBB, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xAA, 0xAA, 0xA9, 0xAA, 0xAA, 0xBB, 0xBC, 0xDC, 0xAB, 0xCB,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xED, 0xBB, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xCD, 0xDA, 0xBA, 0xAA, 0x99, 0x98,
    0x88, 0x88, 0x99, 0xAA, 0xBC, 0xCC, 0xAB, 0xAA, 0x99, 0x88, 0x87, 0x77,
    0x88, 0x89, 0xAA, 0xBC, 0xCA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x89, 0xAB, 0xBB, 0xAA, 0x99, 0x88, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xBA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x87, 0x66, 0x66, 0x56, 0x66, 0x77, 0x89, 0xAB, 0xAA, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x66, 0x78, 0x99, 0xAA, 0xAA, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x67, 0x89, 0x9A, 0xAA, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0xAA, 0x99, 0x87, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xAA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBA, 0xBB, 0xA9, 0x88, 0x77, 0x76, 0x67, 0x77, 0x88, 0x99,
    0xAB, 0xAB, 0xBA, 0xA9, 0x88, 0x87, 0x77, 0x77, 0x88, 0x89, 0xAA, 0xBA,
    0xBB, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xAC, 0xDB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xCD, 0xCC, 0xBB,
    0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xBC, 0xED, 0xDC, 0xBB, 0xBA,
    0xAA, 0xAA, 0xBA, 0xBB, 0xCC, 0xCC, 0xAC, 0xCC, 0xCB, 0xBB, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBB, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBB, 0xCC,
    0xBA, 0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xDC, 0xBB, 0xBA, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xCA, 0xBA, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xAB, 0xBA, 0xAA, 0x98, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0x9A, 0x99, 0x87, 0x77, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAA, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x66, 0x55, 0x66, 0x66, 0x78, 0x89, 0xA9, 0x99, 0x98, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x77, 0x88, 0x9A, 0x99, 0x99, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x78, 0x89, 0xA9, 0x99, 0x98, 0x77, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x99, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x67, 0x77, 0x78, 0x89,
    0xAA, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0x9A, 0xBA,
    0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xAB, 0xBB,
    0xAA, 0x99, 0x98, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xBB, 0xCC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xBC, 0xDC, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xCB, 0xBC, 0xCB, 0xBB, 0xAA, 0xAA, 0x99,
    0x9A, 0xAA, 0xAB, 0xBB, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xAA, 0xAA, 0xA9, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xAB, 0xDC,
    0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xEC, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0x99, 0xAB, 0xBC, 0xCD, 0xCB, 0xBB, 0xAA, 0x99, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xBC, 0xCC, 0xAB, 0xAA, 0x99, 0x88, 0x88, 0x78,
    0x88, 0x89, 0xAA, 0xBC, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBB, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x78, 0x99,
    0xAB, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x87, 0x66, 0x65, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x66, 0x78, 0x99, 0xAA, 0xAA, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x67, 0x89, 0x9A, 0xAA, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0xAA, 0x99, 0x87, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x89, 0xAB, 0xAA, 0xAA, 0x98, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBA, 0xAB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAB, 0xBA, 0xA9, 0x88, 0x87, 0x77, 0x77, 0x88, 0x99, 0xAB, 0xBA,
    0xBC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xBB, 0xCB,
    0xBA, 0xA9, 0x99, 0x98, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xCD, 0xCB, 0xBA,
    0xAA, 0xAA, 0x99, 0x9A, 0xAA, 0xBB, 0xCD, 0xCD, 0xED, 0xDC, 0xBB, 0xBB,
    0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDC, 0xAC, 0xCC, 0xBB, 0xBA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xCC, 0xCE, 0xAC, 0xDD,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xFE, 0xBC, 0xCB, 0xBA,
    0xAA, 0x99, 0x9A, 0xAA, 0xAB, 0xCC, 0xDE, 0xDB, 0xCB, 0xBA, 0xA9, 0x99,
    0x98, 0x99, 0x9A, 0xAB, 0xCC, 0xDD, 0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x99, 0xAB, 0xCD, 0xCB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xCC, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x67, 0x78, 0x9A,
    0xBC, 0xCA, 0xAA, 0x98, 0x77, 0x66, 0x65, 0x66, 0x67, 0x88, 0x9A, 0xBB,
    0xAA, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xBA, 0xA9,
    0x88, 0x76, 0x65, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0x99, 0x87,
    0x66, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xBA, 0xAA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x89, 0xAB, 0xBB, 0xBA, 0x98, 0x87, 0x66, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBB, 0xBB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xBB, 0xBC, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x78, 0x88, 0x9A, 0xAB, 0xCB,
    0xCC, 0xCB, 0xA9, 0x99, 0x88, 0x88, 0x89, 0x99, 0xAB, 0xBC, 0xBD, 0xDC,
    0xCB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDC, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xCE, 0xFE, 0xDC, 0xCC, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xEC, 0xBE, 0xDC, 0xCC, 0xCB, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xDE, 0xDD, 0xDD, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xBE, 0xFF,
    0xEE, 0xDD, 0xDD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xED, 0xDC,
    0xCC, 0xBC, 0xCC, 0xCD, 0xEE, 0xFF, 0xFF, 0xFD, 0xED, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAB, 0xBC, 0xDF, 0xFF, 0xFF, 0xDD, 0xDC, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xBC, 0xDF, 0xFF, 0xFD, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A,
    0xBC, 0xEF, 0xFF, 0xDD, 0xCB, 0x98, 0x87, 0x66, 0x66, 0x78, 0x9A, 0xBD,
    0xEF, 0xFD, 0xDC, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9B, 0xCD, 0xFF,
    0xDD, 0xBA, 0x97, 0x66, 0x54, 0x45, 0x56, 0x79, 0xAC, 0xDE, 0xFE, 0xDB,
    0xA9, 0x76, 0x55, 0x44, 0x45, 0x67, 0x8A, 0xBD, 0xFF, 0xDD, 0xCA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCE, 0xEE, 0xDC, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x8A, 0xBD, 0xEF, 0xEE, 0xCB, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x79, 0xAB, 0xDE, 0xEF, 0xED, 0xBA, 0x98, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBD, 0xFE, 0xEF, 0xEC, 0xBA, 0x98, 0x77, 0x77, 0x78, 0x9A, 0xBC,
    0xDE, 0xEF, 0xFF, 0xDC, 0xBA, 0x99, 0x88, 0x89, 0x9A, 0xAB, 0xCD, 0xEE,
    0xFF, 0xFE, 0xDC, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xEF, 0xEF, 0xFF,
    0xFF, 0xDC, 0xCC, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF,
    0xED, 0xDD, 0xCD, 0xCD, 0xDD, 0xDF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xFE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xEE, 0xEE,
    0xEE, 0xEF, 0xEF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xDD, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xEF, 0xFF, 0xCE, 0xFE,
    0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xEE, 0xFF, 0xFF, 0xDF, 0xED, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDF, 0xFF, 0xFE, 0xED, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAB, 0xCD, 0xDF, 0xFF, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xEF, 0xFD, 0xDB, 0xB9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAB, 0xCD, 0xFE, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x67, 0x89, 0xAB,
    0xCD, 0xFC, 0xCB, 0x98, 0x77, 0x66, 0x55, 0x56, 0x67, 0x89, 0xAC, 0xDE,
    0xCB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xCA,
    0x98, 0x76, 0x55, 0x54, 0x55, 0x67, 0x79, 0xAB, 0xCD, 0xDC, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xCA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xBA, 0x87, 0x66, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xCC, 0xDD, 0xDB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x89, 0xBC, 0xDD, 0xED, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCE, 0xDE, 0xEC, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x89, 0xAB, 0xCD, 0xEE,
    0xFF, 0xEC, 0xBB, 0xA9, 0x99, 0x99, 0x99, 0xAB, 0xCC, 0xDF, 0xEF, 0xFF,
    0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBD, 0xDE, 0xFF, 0xFF, 0xFF, 0xED,
    0xCC, 0xCB, 0xBB, 0xCC, 0xCC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xDD,
    0xDC, 0xDD, 0xDD, 0xEE, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xEF, 0xED, 0xDD,
    0xDD, 0xDF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEF, 0xFF, 0xCE, 0xFE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFF, 0xEE, 0xDD, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xCC, 0xDE, 0xFF, 0xFD, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xFF, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xDF, 0xED, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xEE, 0xCC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x67, 0x89, 0x9B,
    0xCD, 0xEC, 0xBA, 0x98, 0x76, 0x66, 0x55, 0x56, 0x67, 0x89, 0xAB, 0xDD,
    0xCB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x55, 0x55, 0x67, 0x78, 0xAB, 0xCD, 0xCB, 0xA9, 0x87,
    0x65, 0x55, 0x55, 0x56, 0x67, 0x8A, 0xBC, 0xDC, 0xBA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x78, 0xAB, 0xCD, 0xCC, 0xA9, 0x87, 0x66, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xDD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCD, 0xDD, 0xCA, 0x98, 0x87, 0x77, 0x67, 0x77, 0x89, 0xAB,
    0xCD, 0xDE, 0xEC, 0xBA, 0x99, 0x88, 0x77, 0x78, 0x89, 0xAA, 0xBC, 0xDD,
    0xEE, 0xDC, 0xBA, 0xA9, 0x98, 0x89, 0x99, 0xAA, 0xBC, 0xDE, 0xEF, 0xFE,
    0xDC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xCC, 0xDE, 0xFE, 0xFF, 0xFE, 0xED,
    0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDE, 0xFF, 0xEF, 0xFF, 0xFF, 0xED, 0xDC,
    0xCC, 0xCC, 0xDD, 0xDE, 0xFF, 0xFF, 0xDF, 0xFF, 0xEE, 0xDD, 0xDD, 0xCD,
    0xDD, 0xDE, 0xEE, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDC, 0xDC, 0xCC, 0xBC, 0xCC, 0xCD, 0xDD, 0xDE, 0xEE, 0xBE, 0xFE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xCC, 0xCD, 0xEE, 0xFF, 0xFF, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xEF, 0xFF, 0xFD, 0xDD, 0xCB, 0xAA, 0x99,
    0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xFE, 0xCD, 0xCB, 0xAA, 0x98, 0x88, 0x88,
    0x89, 0xAA, 0xCC, 0xEE, 0xEC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAB, 0xCD, 0xED, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCE, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x55, 0x56, 0x77, 0x8A, 0xAC, 0xDD,
    0xCB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xDC, 0xCA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xDC, 0xCC, 0xBA, 0x87, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xDC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x99, 0xAC, 0xDC, 0xDD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xEC, 0xCA, 0xA9, 0x88, 0x88, 0x88, 0x89, 0xAB, 0xBC, 0xDD,
    0xDE, 0xDC, 0xCB, 0xA9, 0x99, 0x99, 0x99, 0xAB, 0xBC, 0xDE, 0xDE, 0xFE,
    0xDD, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xDD, 0xEF, 0xEE, 0xDD,
    0xCC, 0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xEF, 0xEF, 0xFF, 0xFE, 0xEE, 0xDD,
    0xCD, 0xCD, 0xCD, 0xDD, 0xFF, 0xFE, 0xCE, 0xED, 0xEE, 0xDD, 0xDD, 0xCC,
    0xDD, 0xCD, 0xDE, 0xDE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xBE, 0xEE, 0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0xEE, 0xEF, 0xFF, 0xBE, 0xFF,
    0xFE, 0xDD, 0xDC, 0xCD, 0xDD, 0xEE, 0xFF, 0xFF, 0xFF, 0xEF, 0xED, 0xDC,
    0xCB, 0xBB, 0xBB, 0xCC, 0xDD, 0xFF, 0xFF, 0xFD, 0xEE, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBC, 0xDE, 0xFF, 0xFF, 0xDD, 0xDC, 0xBA, 0x99, 0x98, 0x89,
    0x9A, 0xAB, 0xDD, 0xFF, 0xFD, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x78, 0x99,
    0xAC, 0xDE, 0xFF, 0xDD, 0xCB, 0x98, 0x87, 0x66, 0x66, 0x78, 0x9A, 0xBC,
    0xDF, 0xED, 0xDC, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xEE,
    0xDC, 0xBA, 0x97, 0x66, 0x55, 0x45, 0x56, 0x78, 0xAB, 0xCE, 0xED, 0xDB,
    0xA8, 0x76, 0x55, 0x44, 0x45, 0x67, 0x89, 0xBC, 0xDE, 0xDC, 0xBA, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9B, 0xCE, 0xDD, 0xDB, 0xA9, 0x76, 0x65,
    0x44, 0x55, 0x67, 0x89, 0xBC, 0xDE, 0xDD, 0xCA, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0xAB, 0xDD, 0xEE, 0xEC, 0xBA, 0x98, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBD, 0xEE, 0xEF, 0xDC, 0xB9, 0x98, 0x77, 0x77, 0x78, 0x9A, 0xBC,
    0xDE, 0xEE, 0xFE, 0xDB, 0xAA, 0x98, 0x88, 0x88, 0x9A, 0xAB, 0xCE, 0xFE,
    0xFF, 0xED, 0xDB, 0xBA, 0xAA, 0x99, 0xAA, 0xBB, 0xCD, 0xEF, 0xEF, 0xFF,
    0xFE, 0xDC, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEF, 0xFE, 0xFF, 0xFF, 0xFE,
    0xED, 0xCC, 0xCC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE,
    0xDE, 0xDE, 0xEE, 0xEF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFE, 0xEE, 0xED, 0xDE,
    0xED, 0xDE, 0xEE, 0xFE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xCC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEE, 0xBC, 0xDD,
    0xCC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEE, 0xFE, 0xCD, 0xCB, 0xBA,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xEE, 0xEC, 0xCB, 0xBA, 0xA9, 0x99,
    0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xED, 0xBC, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xBB, 0xCD, 0xDB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xDD, 0xBB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBC, 0xCB, 0xBA, 0x98, 0x77, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xCC,
    0xBB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xA9,
    0x98, 0x76, 0x65, 0x44, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xBB, 0xA9, 0x87,
    0x66, 0x54, 0x45, 0x56, 0x77, 0x89, 0xAB, 0xBB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBB, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xBB, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCC, 0xCC, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xCC, 0xCB, 0xBA, 0x99, 0x88, 0x87, 0x88, 0x88, 0x9A, 0xAB, 0xCC,
    0xDD, 0xCB, 0xBA, 0x99, 0x98, 0x88, 0x99, 0x9A, 0xAB, 0xCD, 0xCD, 0xED,
    0xCB, 0xBA, 0xAA, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDC, 0xDF, 0xED, 0xCC,
    0xBB, 0xBA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDD, 0xDE, 0xFE, 0xED, 0xDC, 0xCB,
    0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xFD, 0xAE, 0xDD, 0xDD, 0xCC, 0xCB, 0xBB,
    0xBB, 0xCC, 0xCC, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xBB, 0xCC,
    0xBA, 0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xDD, 0xBC, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xCA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xBB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAA, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x66, 0x55, 0x56, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x89, 0xAA, 0x9A, 0x98, 0x77, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0xAA, 0xBB,
    0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xBB, 0xCB,
    0xAA, 0x99, 0x99, 0x88, 0x89, 0x99, 0xAA, 0xBB, 0xCB, 0xCC, 0xCB, 0xBA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xCC, 0xDC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDC, 0xAD, 0xCC, 0xBB, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xAB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDC, 0xAB, 0xAA, 0xA9,
    0x99, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xCA, 0xBA, 0x99, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBB, 0xAA, 0xA9, 0x88, 0x87, 0x77, 0x77,
    0x78, 0x88, 0x9A, 0xAB, 0xB9, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAA, 0xA9, 0x99, 0x87, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0x99, 0x88, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x98,
    0x87, 0x76, 0x66, 0x66, 0x66, 0x67, 0x78, 0x89, 0xA9, 0x99, 0x88, 0x77,
    0x66, 0x66, 0x56, 0x66, 0x77, 0x88, 0x9A, 0x99, 0x98, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x78, 0x89, 0xA9, 0x99, 0x98, 0x77, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0x99, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x78, 0x99, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x89,
    0xAA, 0xAA, 0xAA, 0x98, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0x9A, 0xBA,
    0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xAB, 0xBB,
    0xAA, 0x99, 0x98, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCB, 0xBC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xBC, 0xDC, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xCC, 0xBC, 0xCB, 0xBA, 0xAA, 0x99, 0x99,
    0x9A, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0xBC, 0xAB, 0xDC,
    0xBB, 0xAA, 0xAA, 0x9A, 0xAA, 0xAA, 0xBB, 0xCD, 0xDC, 0xBC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xCA, 0xBB, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCC, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBB, 0xAA, 0x99, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xAA,
    0x9A, 0x98, 0x87, 0x66, 0x66, 0x56, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0xA9,
    0x87, 0x76, 0x66, 0x55, 0x56, 0x67, 0x78, 0x89, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0xAA, 0x98, 0x87, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xAA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x99, 0xAB, 0xBB,
    0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xBB, 0xCB,
    0xAA, 0xA9, 0x99, 0x89, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xCC, 0xCB, 0xBA,
    0xAA, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xCD, 0xDD, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDC, 0xAD, 0xCB, 0xBB, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xCC, 0xBB, 0xBB, 0xAB, 0xAB, 0xBB, 0xBC, 0xCC, 0xDD, 0xAC, 0xDD,
    0xCC, 0xBB, 0xBB, 0xBA, 0xBB, 0xBC, 0xCD, 0xDE, 0xFD, 0xCD, 0xCB, 0xBA,
    0xAA, 0xA9, 0xAA, 0xAA, 0xBC, 0xCD, 0xDE, 0xDB, 0xCC, 0xBA, 0xA9, 0x99,
    0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xED, 0xBC, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xAB, 0xCD, 0xCB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBB, 0xDC, 0xBB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBC, 0xCB, 0xBA, 0x98, 0x77, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xCC,
    0xAA, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xBA, 0xAA,
    0x98, 0x76, 0x65, 0x44, 0x55, 0x67, 0x88, 0x9A, 0xBB, 0xBB, 0xA9, 0x87,
    0x66, 0x54, 0x45, 0x56, 0x77, 0x89, 0xAB, 0xBB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xBB, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCB, 0xCC, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xCC, 0xCB, 0xBA, 0x98, 0x88, 0x87, 0x88, 0x89, 0x9A, 0xAC, 0xCC,
    0xCD, 0xCB, 0xBA, 0x99, 0x98, 0x88, 0x99, 0x9A, 0xAB, 0xCD, 0xCD, 0xDD,
    0xCB, 0xBA, 0xAA, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xDC, 0xDE, 0xDD, 0xCC,
    0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xDD, 0xFE, 0xED, 0xDC, 0xCB,
    0xBB, 0xBB, 0xCC, 0xCC, 0xDD, 0xED, 0xBD, 0xED, 0xDC, 0xCC, 0xBB, 0xBB,
    0xBB, 0xCC, 0xCC, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xFF, 0xFF, 0xEF, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF,
    0xFF, 0xFE, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE,
    0xDD, 0xDC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xCC, 0xBB,
    0xBB, 0xBC, 0xCE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCB, 0xAA, 0x99, 0x9A,
    0xAB, 0xCD, 0xFF, 0xFF, 0xFF, 0xFE, 0xCB, 0xA9, 0x88, 0x88, 0x89, 0xAB,
    0xCD, 0xFF, 0xFF, 0xEF, 0xDC, 0xA9, 0x87, 0x77, 0x77, 0x88, 0xAB, 0xCE,
    0xFF, 0xFE, 0xED, 0xBA, 0x87, 0x66, 0x55, 0x66, 0x79, 0xAC, 0xDF, 0xFF,
    0xFF, 0xCB, 0x98, 0x76, 0x54, 0x45, 0x67, 0x8A, 0xBC, 0xFF, 0xFF, 0xEC,
    0xB9, 0x86, 0x54, 0x33, 0x45, 0x68, 0x9B, 0xDE, 0xFF, 0xFE, 0xDB, 0x98,
    0x75, 0x43, 0x34, 0x56, 0x89, 0xBC, 0xEF, 0xFF, 0xED, 0xBA, 0x87, 0x65,
    0x44, 0x55, 0x78, 0x9B, 0xCE, 0xFF, 0xFF, 0xDC, 0xA9, 0x86, 0x65, 0x55,
    0x67, 0x8A, 0xBC, 0xEF, 0xFF, 0xFE, 0xDB, 0xA8, 0x87, 0x66, 0x77, 0x89,
    0xAC, 0xDF, 0xFF, 0xFF, 0xED, 0xCB, 0xA9, 0x88, 0x88, 0x89, 0xAB, 0xCD,
    0xFF, 0xFF, 0xFF, 0xED, 0xCB, 0xA9, 0x99, 0x9A, 0xAB, 0xCD, 0xEF, 0xFF,
    0xFF, 0xFF, 0xED, 0xCC, 0xBB, 0xBB, 0xBB, 0xCD, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFE, 0xDD, 0xCC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xCC, 0xCC, 0xCC, 0xBC, 0xDC, 0xDD, 0xEE, 0xFF, 0xBD, 0xFD,
    0xDC, 0xCC, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFF, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xFF, 0xED, 0xDC, 0xBB, 0xAA, 0x99,
    0x99, 0x99, 0xAB, 0xBC, 0xDD, 0xEE, 0xCC, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xDF, 0xEC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0x9B, 0xCD, 0xFD, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDC, 0xCB, 0x98, 0x77, 0x66, 0x55, 0x56, 0x67, 0x89, 0xBC, 0xDD,
    0xCB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xDC, 0xCA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xDC, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xCC, 0xCA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xB9, 0x87, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xDD, 0xDB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBB, 0xDD, 0xDD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xEC, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xCC, 0xEE,
    0xEE, 0xDC, 0xBB, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xEE, 0xFE,
    0xDC, 0xBB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF, 0xFE, 0xDD,
    0xCC, 0xBC, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xEF, 0xFF, 0xFE, 0xED, 0xDD,
    0xCD, 0xCC, 0xCE, 0xDE, 0xFE, 0xFE, 0xAF, 0xFE, 0xEE, 0xDD, 0xDD, 0xCD,
    0xDD, 0xDE, 0xEE, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xDE, 0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xEF, 0xFF, 0xCE, 0xFE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFF, 0xEE, 0xDC, 0xCB,
    0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xFD, 0xDC, 0xBB, 0xA9, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xFF, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xDE, 0xEC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xDE, 0xCC, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x67, 0x89, 0xAB,
    0xCD, 0xDC, 0xBA, 0x98, 0x76, 0x65, 0x55, 0x56, 0x67, 0x89, 0xAB, 0xDD,
    0xCB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x55, 0x55, 0x67, 0x79, 0xAB, 0xCD, 0xCB, 0xA9, 0x87,
    0x65, 0x55, 0x55, 0x56, 0x77, 0x8A, 0xBC, 0xDC, 0xBA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xA9, 0x87, 0x66, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x89, 0xAB, 0xDD, 0xDD, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xDC, 0xBA, 0x99, 0x88, 0x77, 0x88, 0x89, 0xAB, 0xCD, 0xEE,
    0xEE, 0xDC, 0xBA, 0xA9, 0x98, 0x89, 0x99, 0xAA, 0xBC, 0xDE, 0xEE, 0xFE,
    0xDC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xCC, 0xDE, 0xFF, 0xFF, 0xFE, 0xDD,
    0xCB, 0xBB, 0xBB, 0xBB, 0xCD, 0xDE, 0xEF, 0xFF, 0xFF, 0xFF, 0xED, 0xDC,
    0xCC, 0xCD, 0xDD, 0xEE, 0xFF, 0xFF, 0xCF, 0xFF, 0xFE, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDE, 0xEE, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCD, 0xEE, 0xFF, 0xFF, 0xBF, 0xFE,
    0xED, 0xCC, 0xCC, 0xBB, 0xCC, 0xDD, 0xDF, 0xFF, 0xFF, 0xFE, 0xED, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xEF, 0xFF, 0xFD, 0xED, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAB, 0xBC, 0xDE, 0xFF, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0xAA, 0xBD, 0xDF, 0xFD, 0xDB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0x9B, 0xCD, 0xFF, 0xCC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xEC, 0xBB, 0x98, 0x77, 0x65, 0x55, 0x56, 0x67, 0x89, 0xBC, 0xDE,
    0xCB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xCA,
    0x98, 0x76, 0x55, 0x54, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCB, 0xA9, 0x87,
    0x65, 0x55, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xCA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xDC, 0xA9, 0x87, 0x66, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xDD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x99, 0xBC, 0xDD, 0xDD, 0xCA, 0x99, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xEE, 0xEC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x89, 0xAB, 0xCD, 0xDD,
    0xFF, 0xDC, 0xBA, 0xA9, 0x99, 0x99, 0x99, 0xAB, 0xBC, 0xDE, 0xFF, 0xFF,
    0xDD, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDE, 0xFF, 0xFF, 0xFE, 0xED,
    0xCC, 0xCB, 0xBB, 0xBC, 0xCD, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE, 0xDD,
    0xDC, 0xDD, 0xDD, 0xEE, 0xFF, 0xFF, 0xCF, 0xFF, 0xFE, 0xEE, 0xDD, 0xDD,
    0xDD, 0xDE, 0xEF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xEE, 0xEE, 0xDD, 0xDE, 0xDE, 0xEE, 0xEE, 0xFE, 0xEF, 0xAF, 0xFF,
    0xFE, 0xED, 0xDD, 0xDD, 0xDE, 0xEF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFE, 0xDC,
    0xCC, 0xCB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFE, 0xFE, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAB, 0xCC, 0xDE, 0xFF, 0xFF, 0xEE, 0xDC, 0xBA, 0xA9, 0x99, 0x99,
    0x9A, 0xBC, 0xDE, 0xFF, 0xFE, 0xEC, 0xBA, 0x99, 0x87, 0x77, 0x88, 0x9A,
    0xBC, 0xDF, 0xFF, 0xED, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x78, 0x9A, 0xBD,
    0xEF, 0xFD, 0xDC, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9B, 0xCD, 0xFF,
    0xDD, 0xBA, 0x98, 0x66, 0x54, 0x45, 0x56, 0x89, 0xAC, 0xDE, 0xED, 0xDB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBD, 0xEE, 0xED, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xDE, 0xFE, 0xDC, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBD, 0xEE, 0xED, 0xCB, 0x98, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAC, 0xDE, 0xEE, 0xED, 0xBA, 0x98, 0x76, 0x66, 0x67, 0x78,
    0x9B, 0xCD, 0xFE, 0xFF, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDF, 0xFF, 0xFE, 0xDC, 0xBA, 0x99, 0x98, 0x99, 0x9A, 0xBC, 0xDF, 0xFF,
    0xFF, 0xFE, 0xDC, 0xBB, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xFF, 0xFF,
    0xFE, 0xDD, 0xCC, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xEE, 0xDD, 0xDC, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE,
    0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEE,
    0xEE, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xCC, 0xBB, 0xBA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDE, 0xBC, 0xDC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDE, 0xFE, 0xCC, 0xCB, 0xBA,
    0xAA, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xDE, 0xEB, 0xCB, 0xAA, 0x99, 0x98,
    0x88, 0x99, 0x9A, 0xAB, 0xCD, 0xDD, 0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x9A, 0xAB, 0xCD, 0xDB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xAB, 0xCC, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBC, 0xCA, 0xAA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77, 0x89, 0xAB, 0xCC,
    0xAA, 0x99, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xBA, 0xA9,
    0x88, 0x76, 0x65, 0x44, 0x55, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0x98, 0x87,
    0x66, 0x54, 0x45, 0x56, 0x77, 0x89, 0xAB, 0xBB, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xBB, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x67, 0x77,
    0x89, 0xAA, 0xBB, 0xBB, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xCC, 0xCB, 0xAA, 0x98, 0x88, 0x87, 0x88, 0x89, 0x9A, 0xBB, 0xCC,
    0xCD, 0xCB, 0xAA, 0x99, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCC, 0xCD, 0xDD,
    0xCB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDD, 0xDE, 0xDC, 0xCB,
    0xBB, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xDE, 0xFE, 0xED, 0xCC, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xED, 0xAE, 0xDD, 0xDC, 0xCC, 0xBB, 0xBB,
    0xBB, 0xCC, 0xCD, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xAB, 0xCB,
    0xBA, 0xAA, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xDD, 0xBB, 0xBA, 0xA9,
    0x99, 0x98, 0x89, 0x99, 0xAA, 0xBB, 0xCD, 0xCA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xBB, 0xCC, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xA9, 0x99, 0x87, 0x77, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x66, 0x55, 0x56, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x65, 0x55, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x65, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0xAA, 0xBB,
    0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xBB, 0xCB,
    0xAA, 0xA9, 0x99, 0x88, 0x89, 0x99, 0xAA, 0xBB, 0xCB, 0xCD, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xCD, 0xDC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDC, 0xAC, 0xCC, 0xBB, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xCC, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xAB, 0xCB,
    0xBA, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDC, 0xBB, 0xBA, 0xA9,
    0x99, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCC, 0xCA, 0xBA, 0x99, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBB, 0xAA, 0xA9, 0x88, 0x87, 0x77, 0x77,
    0x78, 0x89, 0x9A, 0xAB, 0xB9, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAA, 0xA9, 0x99, 0x87, 0x76, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0x99, 0x88, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x98,
    0x87, 0x76, 0x66, 0x65, 0x66, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x88, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x98, 0x77, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x99, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x89,
    0xAB, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0x9A, 0xBA,
    0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xBB, 0xBB, 0xCB,
    0xAA, 0x99, 0x98, 0x88, 0x88, 0x99, 0x9A, 0xBB, 0xCB, 0xCC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xCC, 0xDC, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDC, 0xBC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xAB, 0xCC,
    0xBB, 0xAA, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0xCD, 0xDC, 0xBC, 0xBB, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xCA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xBB, 0xCC, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBB, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x56, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x66, 0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x65, 0x55, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x56, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x87, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x99, 0xAA, 0xBB,
    0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBB, 0xCB,
    0xAA, 0xA9, 0x99, 0x88, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xCD, 0xCC, 0xBA,
    0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xBB, 0xCD, 0xCC, 0xDC, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDC, 0xAD, 0xCC, 0xBB, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xCC, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCC, 0xDD, 0xAC, 0xDC,
    0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xEE, 0xCC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDE, 0xEB, 0xCB, 0xAA, 0x99, 0x98,
    0x88, 0x89, 0x9A, 0xAB, 0xBC, 0xDD, 0xBB, 0xAA, 0x99, 0x88, 0x87, 0x78,
    0x88, 0x99, 0xAB, 0xCD, 0xCB, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xCC, 0xAB, 0xA9, 0x87, 0x77, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBC, 0xCA, 0xA9, 0x98, 0x77, 0x66, 0x56, 0x66, 0x77, 0x89, 0x9A, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xBA, 0xA9,
    0x87, 0x76, 0x55, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0x98, 0x77,
    0x65, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xBA, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x89, 0xAB, 0xBB, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xBB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xBC, 0xBC, 0xCB, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x89, 0x9A, 0xAB, 0xCC,
    0xCC, 0xCB, 0xA9, 0x99, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCC, 0xCD, 0xDC,
    0xBB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDD, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xDE, 0xEE, 0xDD, 0xCC, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xED, 0xBE, 0xDD, 0xCC, 0xCB, 0xBB, 0xBB,
    0xBB, 0xBC, 0xCC, 0xDE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF,
    0xFF, 0xFE, 0xED, 0xDE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xED,
    0xCC, 0xCC, 0xCC, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0xCB, 0xBA,
    0xAA, 0xBB, 0xCD, 0xEF, 0xFF, 0xFF, 0xFF, 0xDD, 0xBB, 0xA9, 0x99, 0x99,
    0xAA, 0xBD, 0xEF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x88, 0x77, 0x88, 0x9A,
    0xCD, 0xFF, 0xFF, 0xFE, 0xDB, 0xA9, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xCD,
    0xFF, 0xFF, 0xDC, 0xB9, 0x87, 0x65, 0x55, 0x56, 0x78, 0xAB, 0xDF, 0xFF,
    0xFD, 0xCA, 0x98, 0x65, 0x54, 0x45, 0x56, 0x89, 0xBC, 0xEF, 0xFE, 0xDC,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xCD, 0xFF, 0xFE, 0xCA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAC, 0xDF, 0xFF, 0xEC, 0xB9, 0x87, 0x55,
    0x44, 0x55, 0x67, 0x9A, 0xCD, 0xFF, 0xFF, 0xDB, 0xA8, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAC, 0xDF, 0xFF, 0xFD, 0xCB, 0x98, 0x76, 0x66, 0x67, 0x89,
    0xAB, 0xCF, 0xFF, 0xFF, 0xFD, 0xCA, 0x98, 0x87, 0x77, 0x89, 0x9A, 0xCD,
    0xFF, 0xFF, 0xFF, 0xEC, 0xBB, 0xA9, 0x99, 0x99, 0xAA, 0xBC, 0xDF, 0xFF,
    0xFF, 0xFF, 0xDD, 0xCB, 0xBA, 0xAA, 0xAB, 0xCC, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFE, 0xDC, 0xCC, 0xCC, 0xCD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xDD, 0xDC, 0xCC, 0xCC, 0xCD, 0xDE, 0xEE, 0xDE, 0xAF, 0xFE,
    0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFF, 0xEF, 0xDD, 0xCB,
    0xBB, 0xAA, 0xAB, 0xBB, 0xCD, 0xEE, 0xFF, 0xEE, 0xED, 0xCB, 0xAA, 0x99,
    0x99, 0x9A, 0xAB, 0xCD, 0xEE, 0xFF, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x99, 0xAB, 0xCD, 0xEF, 0xED, 0xDC, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAB, 0xCE, 0xEE, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xDE, 0xEC, 0xCB, 0x98, 0x76, 0x65, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xDD,
    0xCC, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9B, 0xCD, 0xDC, 0xCA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xCC, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xCD, 0xDC, 0xCB, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xDE, 0xDC, 0xBA, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9B, 0xCD, 0xDD, 0xDB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDD, 0xDD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xDE, 0xED, 0xED, 0xCB, 0xA9, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xEE,
    0xDE, 0xEC, 0xCB, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xEF, 0xEE, 0xFE,
    0xED, 0xCB, 0xBB, 0xAA, 0xAB, 0xBB, 0xCD, 0xEF, 0xFF, 0xFF, 0xFF, 0xED,
    0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xEF, 0xFF, 0xFE, 0xFF, 0xFF, 0xEE, 0xED,
    0xDD, 0xDD, 0xDE, 0xEE, 0xFF, 0xFF, 0xAF, 0xEE, 0xEE, 0xED, 0xDD, 0xDD,
    0xDD, 0xED, 0xEF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xCC, 0xCC, 0xCC, 0xBC, 0xCC, 0xDD, 0xDD, 0xEE, 0xBE, 0xFE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBC, 0xCD, 0xEE, 0xFF, 0xFE, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFF, 0xED, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAB, 0xBC, 0xDE, 0xFE, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0xAB, 0xCC, 0xDE, 0xDC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x89,
    0xAB, 0xCD, 0xED, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDC, 0xBA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x77, 0x8A, 0xBC, 0xDD,
    0xBC, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCC, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xCC, 0xB9, 0x87, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xDC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDD, 0xDD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xDD, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xDD,
    0xDE, 0xDC, 0xBB, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDE, 0xED, 0xEE,
    0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xCC, 0xDE, 0xFE, 0xEF, 0xFE, 0xDD,
    0xCC, 0xCB, 0xBB, 0xBC, 0xCC, 0xDE, 0xEF, 0xEE, 0xFF, 0xEE, 0xED, 0xDC,
    0xCC, 0xDD, 0xDD, 0xDE, 0xFF, 0xFF, 0xBE, 0xEE, 0xED, 0xDD, 0xDD, 0xCD,
    0xCD, 0xDD, 0xEE, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xDD, 0xCC, 0xCC, 0xDC, 0xDD, 0xDE, 0xEF, 0xEF, 0xAE, 0xFE,
    0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xDE, 0xEF, 0xFF, 0xFE, 0xEE, 0xDD, 0xDB,
    0xBB, 0xBA, 0xAB, 0xBC, 0xCD, 0xEE, 0xFF, 0xED, 0xED, 0xCB, 0xAA, 0x99,
    0x99, 0x9A, 0xBB, 0xCD, 0xEF, 0xFE, 0xDD, 0xCB, 0xAA, 0x98, 0x88, 0x88,
    0x99, 0xAB, 0xCD, 0xEF, 0xED, 0xDB, 0xB9, 0x98, 0x77, 0x77, 0x78, 0x89,
    0xAB, 0xCD, 0xEE, 0xCC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x77, 0x89, 0xAC,
    0xDE, 0xDC, 0xCB, 0x98, 0x76, 0x65, 0x55, 0x56, 0x77, 0x9A, 0xBC, 0xED,
    0xCC, 0xB9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9B, 0xCD, 0xDC, 0xCA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xBC, 0xDD, 0xCC, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xCB, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xDC, 0xBA, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xCD, 0xDD, 0xDC, 0xB9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDD, 0xDE, 0xDB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xDD, 0xEE, 0xED, 0xCB, 0xA9, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xEE,
    0xFF, 0xED, 0xCB, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xCD, 0xDE, 0xEE, 0xFF,
    0xDD, 0xCC, 0xBB, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xEE, 0xFF, 0xFE, 0xED,
    0xDC, 0xCB, 0xCC, 0xCC, 0xCD, 0xEE, 0xFF, 0xEE, 0xFF, 0xFF, 0xFE, 0xED,
    0xDD, 0xDD, 0xDE, 0xEE, 0xEF, 0xFF, 0xAE, 0xEE, 0xEE, 0xED, 0xED, 0xDD,
    0xDD, 0xDE, 0xEE, 0xFE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF,
    0xFF, 0xFF, 0xED, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD,
    0xCC, 0xCC, 0xCC, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xCB, 0xBA,
    0xAA, 0xBB, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBB, 0xA9, 0x99, 0x99,
    0xAB, 0xBD, 0xFF, 0xFF, 0xFF, 0xFD, 0xCA, 0xA9, 0x87, 0x77, 0x88, 0x9A,
    0xBD, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xCD,
    0xFF, 0xFF, 0xFC, 0xB9, 0x87, 0x65, 0x55, 0x56, 0x78, 0xAB, 0xDF, 0xFF,
    0xFD, 0xCA, 0x97, 0x65, 0x54, 0x45, 0x56, 0x89, 0xAC, 0xFF, 0xFF, 0xDC,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xCF, 0xFF, 0xFD, 0xCA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAC, 0xDF, 0xFF, 0xFC, 0xB9, 0x86, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xCD, 0xFF, 0xFF, 0xDB, 0xA8, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAC, 0xEF, 0xFF, 0xFF, 0xCA, 0x98, 0x76, 0x66, 0x67, 0x89,
    0xAB, 0xCF, 0xFF, 0xFF, 0xFD, 0xBA, 0x98, 0x87, 0x77, 0x89, 0x9B, 0xCD,
    0xFF, 0xFF, 0xFF, 0xFC, 0xBA, 0xA9, 0x99, 0x99, 0xAB, 0xBC, 0xFF, 0xFF,
    0xFF, 0xFF, 0xED, 0xCB, 0xBA, 0xAA, 0xAB, 0xCD, 0xEF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xDC, 0xCC, 0xCC, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xCC, 0xCC, 0xBC, 0xBC, 0xCC, 0xDD, 0xDE, 0xEE, 0xAE, 0xEE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xFF, 0xFE, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDE, 0xEF, 0xED, 0xDC, 0xBB, 0xAA, 0x99,
    0x99, 0x9A, 0xAB, 0xBC, 0xDE, 0xFE, 0xCD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x99, 0xAB, 0xCD, 0xDF, 0xEC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x89,
    0xAB, 0xCD, 0xEE, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDB, 0xBA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBD, 0xDB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBC, 0xDC, 0xBA, 0x98, 0x76, 0x65,
    0x54, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x78, 0x9A, 0xBC, 0xCC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xAC, 0xDD, 0xDD, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xBC, 0xED,
    0xEE, 0xDC, 0xCB, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDE, 0xEE, 0xFE,
    0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDD, 0xEE, 0xEF, 0xFE, 0xDD,
    0xCC, 0xCB, 0xBB, 0xBC, 0xCD, 0xDD, 0xEF, 0xEE, 0xFF, 0xFE, 0xED, 0xDD,
    0xCC, 0xCC, 0xDD, 0xEE, 0xEF, 0xFE, 0x9E, 0xED, 0xDD, 0xDD, 0xDC, 0xCC,
    0xDD, 0xDD, 0xDE, 0xEF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xCD, 0x9C, 0xDC,
    0xBB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xED, 0xBC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDD, 0xDB, 0xBB, 0xAA, 0x99, 0x98,
    0x88, 0x89, 0x99, 0xAB, 0xBC, 0xDC, 0xBB, 0xAA, 0x99, 0x88, 0x87, 0x78,
    0x88, 0x99, 0xAB, 0xBC, 0xCA, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xCC, 0xAB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x67, 0x78, 0x9A,
    0xAC, 0xCA, 0xA9, 0x98, 0x76, 0x66, 0x66, 0x66, 0x77, 0x89, 0x9A, 0xBB,
    0xAA, 0x98, 0x77, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xBA, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xBA, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0x99, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x89, 0xAB, 0xBA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xBB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xBC, 0xBB, 0xBB, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x88, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xAA, 0x99, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCC, 0xCC, 0xCC,
    0xBB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBD, 0xDC, 0xCD, 0xCC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xCC, 0xEE, 0xDC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xED, 0x9D, 0xCC, 0xCB, 0xBB, 0xBB, 0xBB,
    0xBB, 0xBC, 0xCC, 0xDD, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xBC, 0x9B, 0xCB,
    0xBA, 0xAA, 0xA9, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xDC, 0xBB, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xBA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xBB, 0xCB, 0xAA, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBC, 0xBA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBB, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x99,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x65, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAA, 0xAA, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x67, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x87, 0x77, 0x78, 0x88, 0x99, 0xAA, 0xBA,
    0xAB, 0xBA, 0x99, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xBB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xBA,
    0xAA, 0xA9, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xBC, 0xDC, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBC, 0xCC, 0xDC, 0x9C, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBB, 0xAA, 0xAA, 0xA9, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0x9B, 0xCC,
    0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDC, 0xBC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCD, 0xCA, 0xBB, 0xAA, 0x99, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xBC, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x99, 0xAA, 0xCC, 0xBA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x99, 0xAB, 0xBB, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77, 0x78, 0x9A,
    0xAC, 0xBA, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xBB,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xB9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xAA, 0xA9, 0x87, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAB, 0xAA, 0xBA, 0x98, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBA, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0xBB, 0xBB, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x88, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x89, 0x99, 0xAB, 0xBC, 0xBB, 0xCC,
    0xBB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCB, 0xCD, 0xCC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xCC, 0xDC, 0xCC, 0xCB, 0xBB,
    0xBB, 0xAB, 0xBB, 0xCC, 0xCD, 0xDC, 0x9C, 0xCB, 0xBB, 0xBA, 0xAA, 0xAA,
    0xAA, 0xBB, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDE, 0xEE, 0xEF, 0x9E, 0xFE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xCC, 0xDD, 0xEF, 0xFF, 0xFF, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAB, 0xBB, 0xCD, 0xEE, 0xFF, 0xFD, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x9A, 0xAB, 0xCD, 0xEF, 0xFF, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x99, 0xAB, 0xCD, 0xEF, 0xEC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x78, 0x89,
    0xAB, 0xCD, 0xEE, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x78, 0x89, 0xAB,
    0xDE, 0xEC, 0xCA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xCB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9B, 0xCD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xCC, 0xA9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xCB, 0x98, 0x76, 0x65,
    0x44, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x78, 0x9B, 0xBD, 0xDD, 0xDB, 0xB9, 0x88, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xDD, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xCD, 0xDD, 0xED, 0xCB, 0xA9, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xED,
    0xEE, 0xED, 0xCB, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xEE, 0xFE,
    0xDD, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFE, 0xEF, 0xFE, 0xDD,
    0xDC, 0xCB, 0xBB, 0xCC, 0xCD, 0xEE, 0xFF, 0xFE, 0xFF, 0xFF, 0xEE, 0xDD,
    0xDC, 0xDD, 0xDD, 0xEE, 0xFF, 0xFF, 0xAE, 0xFE, 0xEE, 0xED, 0xDD, 0xDD,
    0xDD, 0xDE, 0xEE, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xED, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xCC,
    0xCC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBB, 0xAA, 0xAB,
    0xBC, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0xBA, 0x99, 0x89, 0x9A, 0xBB,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFD, 0xBA, 0x98, 0x77, 0x77, 0x89, 0xBC, 0xEF,
    0xFF, 0xFF, 0xFF, 0xCB, 0x98, 0x65, 0x55, 0x67, 0x8A, 0xBC, 0xFF, 0xFF,
    0xFF, 0xDC, 0xA9, 0x75, 0x44, 0x44, 0x67, 0x9B, 0xCF, 0xFF, 0xFF, 0xFE,
    0xCA, 0x87, 0x54, 0x33, 0x45, 0x79, 0xAC, 0xDF, 0xFF, 0xFF, 0xDC, 0xA9,
    0x75, 0x43, 0x34, 0x57, 0x8A, 0xCE, 0xFF, 0xFF, 0xFF, 0xCB, 0x97, 0x64,
    0x44, 0x45, 0x79, 0xAC, 0xDF, 0xFF, 0xFF, 0xFD, 0xBA, 0x87, 0x65, 0x55,
    0x68, 0x9B, 0xCD, 0xFF, 0xFF, 0xFF, 0xDC, 0xB9, 0x87, 0x77, 0x78, 0x9A,
    0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0x98, 0x89, 0x9A, 0xBC, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFE, 0xDC, 0xBB, 0xAA, 0xAB, 0xBC, 0xDF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xDD, 0xCC, 0xCC, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFE, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xCD, 0x9E, 0xFE,
    0xDD, 0xDD, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xFE, 0xFD, 0xDE, 0xED, 0xDC,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xEC, 0xDD, 0xCC, 0xBA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCD, 0xED, 0xED, 0xCD, 0xCC, 0xBA, 0xA9, 0x99, 0x99,
    0x9A, 0xBB, 0xCD, 0xDF, 0xDC, 0xDC, 0xBA, 0x99, 0x88, 0x77, 0x88, 0x9A,
    0xBC, 0xCD, 0xED, 0xCD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x78, 0x9A, 0xBC,
    0xDE, 0xDC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9B, 0xBD, 0xED,
    0xCC, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x66, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xDD, 0xCC, 0xBA, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xED, 0xCD, 0xCA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9B, 0xCC, 0xED, 0xCD, 0xCB, 0xAA, 0x98, 0x87, 0x77, 0x89, 0x9A, 0xBC,
    0xDD, 0xDC, 0xDC, 0xCC, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xED,
    0xDE, 0xDD, 0xCC, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xEE, 0xDC, 0xFE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEE, 0xFE, 0xDF, 0xEE, 0xDD,
    0xDD, 0xCC, 0xCC, 0xCC, 0xDD, 0xEE, 0xEF, 0xED, 0xFF, 0xEE, 0xED, 0xDD,
    0xDD, 0xDE, 0xEF, 0xEF, 0xFF, 0xEE, 0x9D, 0xDD, 0xCD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDE, 0xEE, 0xFE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xCC, 0xCB, 0xBB, 0xBC, 0xCC, 0xCD, 0xDD, 0xDE, 0xAE, 0xEE,
    0xDC, 0xCC, 0xBB, 0xBB, 0xBC, 0xCD, 0xDD, 0xEF, 0xFE, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xEF, 0xED, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x9A, 0xAB, 0xBC, 0xDE, 0xEE, 0xCC, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x99, 0xAA, 0xBC, 0xDE, 0xDC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x78, 0x89,
    0xAB, 0xCC, 0xDD, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDB, 0xBA, 0x98, 0x77, 0x65, 0x55, 0x56, 0x77, 0x9A, 0xBC, 0xDD,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xDB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xCC, 0xBA, 0x88, 0x76, 0x55, 0x55,
    0x67, 0x78, 0x9A, 0xBD, 0xCC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xCD, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xCD, 0xDC, 0xDC, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xDD,
    0xDD, 0xDC, 0xBB, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xDD, 0xED,
    0xDC, 0xBB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFE, 0xDF, 0xEE, 0xDC,
    0xCC, 0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xFF, 0xFE, 0xFE, 0xFE, 0xDD, 0xDD,
    0xCC, 0xCC, 0xDD, 0xDE, 0xFF, 0xFE, 0xAE, 0xED, 0xDD, 0xDD, 0xCC, 0xCC,
    0xCD, 0xDD, 0xEE, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xDE, 0xED, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDE, 0x9F, 0xFF,
    0xED, 0xDD, 0xDD, 0xCC, 0xCD, 0xDD, 0xEE, 0xEF, 0xFE, 0xEF, 0xED, 0xDC,
    0xBB, 0xBB, 0xBB, 0xCC, 0xCE, 0xEE, 0xFF, 0xED, 0xED, 0xDC, 0xBA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCD, 0xEE, 0xFD, 0xDE, 0xDC, 0xBA, 0x99, 0x98, 0x89,
    0x9A, 0xAB, 0xCD, 0xEF, 0xDD, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x78, 0x9A,
    0xBB, 0xCD, 0xED, 0xCD, 0xCB, 0xA8, 0x87, 0x66, 0x66, 0x78, 0x9A, 0xBC,
    0xDE, 0xDC, 0xDB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xED,
    0xCD, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x66, 0x79, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xDD, 0xCC, 0xBA, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x76, 0x65,
    0x45, 0x56, 0x67, 0x9A, 0xBC, 0xDD, 0xDD, 0xCA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDD, 0xDC, 0xBA, 0x98, 0x76, 0x66, 0x67, 0x88,
    0x9A, 0xBD, 0xDD, 0xDD, 0xCB, 0xAA, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xCE, 0xDE, 0xED, 0xCB, 0xAA, 0x99, 0x88, 0x89, 0x9A, 0xBC, 0xCD, 0xED,
    0xEF, 0xED, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBC, 0xCD, 0xEE, 0xDE, 0xFE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xFE, 0xDF, 0xFE, 0xDD,
    0xDC, 0xCC, 0xCC, 0xCC, 0xDE, 0xEE, 0xEF, 0xEE, 0xFF, 0xEF, 0xEE, 0xDE,
    0xDD, 0xDD, 0xDE, 0xEF, 0xFF, 0xFF, 0xAE, 0xDD, 0xDD, 0xED, 0xDD, 0xDD,
    0xDD, 0xDE, 0xEE, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xCC,
    0xCC, 0xCD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xCB, 0xAA, 0xAB,
    0xBC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0x99, 0x89, 0x9A, 0xBC,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFD, 0xBA, 0x98, 0x77, 0x77, 0x89, 0xBC, 0xDF,
    0xFF, 0xFF, 0xFF, 0xCB, 0x98, 0x66, 0x55, 0x67, 0x8A, 0xBD, 0xFF, 0xFF,
    0xFF, 0xFC, 0xA9, 0x76, 0x44, 0x45, 0x67, 0x9B, 0xCD, 0xFF, 0xFF, 0xFF,
    0xCA, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAC, 0xFF, 0xFF, 0xFF, 0xFC, 0xA9,
    0x75, 0x43, 0x24, 0x57, 0x8A, 0xCE, 0xFF, 0xFF, 0xFF, 0xCB, 0x97, 0x65,
    0x44, 0x46, 0x79, 0xAC, 0xDF, 0xFF, 0xFF, 0xFD, 0xBA, 0x87, 0x65, 0x56,
    0x68, 0x9B, 0xCD, 0xFF, 0xFF, 0xFF, 0xDC, 0xB9, 0x87, 0x77, 0x78, 0x9A,
    0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0x99, 0x89, 0x9A, 0xBC, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBB, 0xAA, 0xAB, 0xBC, 0xDF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xDD, 0xCC, 0xCC, 0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xCD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xDD, 0x9E, 0xFE,
    0xDD, 0xDC, 0xCC, 0xBC, 0xCC, 0xDD, 0xEE, 0xEF, 0xFE, 0xDE, 0xDD, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xEF, 0xED, 0xED, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCD, 0xDE, 0xEE, 0xDD, 0xCC, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xAB, 0xCC, 0xDE, 0xDC, 0xDC, 0xBA, 0x98, 0x88, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xED, 0xCC, 0xBA, 0x99, 0x87, 0x76, 0x67, 0x78, 0x9A, 0xBC,
    0xDD, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xCC, 0xBA, 0x98, 0x76, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x34, 0x55, 0x67, 0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x34, 0x56, 0x78, 0x9B, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x56, 0x68, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB, 0xBA, 0x98, 0x77, 0x66, 0x77, 0x88,
    0x9A, 0xBC, 0xDD, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x78, 0x89, 0x9A, 0xBC,
    0xDE, 0xDD, 0xEC, 0xCB, 0xAA, 0x99, 0x88, 0x99, 0x9A, 0xBB, 0xCD, 0xED,
    0xDE, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xEF, 0xED, 0xEE,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEF, 0xEE, 0xEF, 0xFE, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xFF, 0xED, 0xFF, 0xEE, 0xED, 0xDD,
    0xCD, 0xDD, 0xDD, 0xEE, 0xFF, 0xFF, 0x8E, 0xDD, 0xDD, 0xCC, 0xCC, 0xCD,
    0xDD, 0xDD, 0xDE, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xAA, 0xAA, 0xA9, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0x9B, 0xCC,
    0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCC, 0xEC, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0xAA, 0xAA, 0xBC, 0xCD, 0xBB, 0xBB, 0xAA, 0x99, 0x98,
    0x88, 0x89, 0x9A, 0xAB, 0xBC, 0xCB, 0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x99, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xCB, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xAB, 0xBA, 0xA9, 0x98, 0x77, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xBB,
    0x9A, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xA9, 0xA9,
    0x87, 0x76, 0x55, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xBA, 0x9A, 0x98, 0x87,
    0x65, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xAA, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xAA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x89, 0xAA, 0xBA, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89, 0x9A,
    0xBB, 0xBA, 0xBB, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xA9, 0x99, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xBB, 0xCC,
    0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCC, 0xBC, 0xCC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0xDD, 0xCC, 0xDD, 0xDC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xCD, 0xEC, 0x8C, 0xBB, 0xBB, 0xBA, 0xAA, 0xAA,
    0xAA, 0xBB, 0xBC, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0x9B, 0xCB,
    0xBA, 0xAA, 0xA9, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xCB, 0xAB, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xBA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xBB, 0xCB, 0xAA, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xB9, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBA, 0x9A, 0x99, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x99,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x65, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x67, 0x78, 0x89, 0xAA, 0xA9, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x67, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x87, 0x77, 0x78, 0x88, 0x99, 0xAA, 0xBA,
    0xAB, 0xBA, 0x99, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xBB, 0xCB,
    0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xBA,
    0xAA, 0xA9, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xBB, 0xDC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBB, 0xCC, 0xDC, 0x9B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0x8B, 0xDC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0xDD, 0xDC, 0xBC, 0xCB, 0xBA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCD, 0xCB, 0xCB, 0xBA, 0x99, 0x98,
    0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xCB, 0xAB, 0xAA, 0x99, 0x88, 0x87, 0x88,
    0x88, 0x9A, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBB, 0xBA, 0xA9, 0x98, 0x76, 0x66, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xBA,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xBA, 0xA9,
    0x88, 0x76, 0x55, 0x55, 0x55, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x98, 0x87,
    0x65, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xAA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xBB, 0xAB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89, 0x9A,
    0xBC, 0xBB, 0xCB, 0xAA, 0x98, 0x88, 0x87, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xAA, 0x99, 0x98, 0x88, 0x99, 0x9A, 0xAB, 0xCC, 0xBB, 0xCC,
    0xBB, 0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xAB, 0xCC, 0xCC, 0xBD, 0xCC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xCD, 0xCC, 0xDD, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xDC, 0x8C, 0xBB, 0xBB, 0xBB, 0xAA, 0xAA,
    0xBB, 0xBB, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xCD, 0xDD, 0x8E, 0xFE,
    0xED, 0xDD, 0xCC, 0xCC, 0xCD, 0xDD, 0xEF, 0xFF, 0xFD, 0xDE, 0xED, 0xCC,
    0xCB, 0xBB, 0xBB, 0xCC, 0xCD, 0xEE, 0xEF, 0xED, 0xDD, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCD, 0xEE, 0xFD, 0xDD, 0xDC, 0xBA, 0xA9, 0x99, 0x99,
    0x9A, 0xBB, 0xCD, 0xEE, 0xEC, 0xDC, 0xBA, 0xA9, 0x88, 0x77, 0x88, 0x9A,
    0xBC, 0xCE, 0xED, 0xCD, 0xCB, 0xA9, 0x87, 0x76, 0x67, 0x78, 0x9A, 0xBC,
    0xDE, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xED,
    0xCC, 0xBA, 0x98, 0x76, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA9, 0x76, 0x54, 0x34, 0x45, 0x68, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98,
    0x65, 0x44, 0x34, 0x56, 0x79, 0xAB, 0xCD, 0xDC, 0xDB, 0xA9, 0x87, 0x65,
    0x44, 0x56, 0x78, 0x9A, 0xBC, 0xDD, 0xDD, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCE, 0xDC, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x77, 0x89,
    0xAB, 0xCC, 0xDD, 0xDD, 0xDB, 0xAA, 0x98, 0x87, 0x78, 0x89, 0x9A, 0xBC,
    0xDE, 0xDD, 0xED, 0xCB, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xCD, 0xED,
    0xDE, 0xDD, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xEF, 0xED, 0xFF,
    0xED, 0xDC, 0xCB, 0xBB, 0xBB, 0xBC, 0xDD, 0xEE, 0xFE, 0xDF, 0xFE, 0xDD,
    0xDC, 0xCC, 0xCC, 0xDD, 0xDD, 0xEE, 0xFF, 0xFD, 0xFF, 0xFE, 0xEE, 0xED,
    0xDD, 0xDD, 0xEE, 0xEE, 0xFF, 0xFF, 0x9D, 0xDD, 0xDE, 0xDD, 0xDD, 0xCD,
    0xDD, 0xEE, 0xDE, 0xEF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xFE, 0xEE, 0xDE, 0xDD, 0xDD, 0xDD, 0xED, 0xDD, 0xDD, 0x9F, 0xFF,
    0xFF, 0xFF, 0xEE, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE,
    0xDD, 0xDD, 0xCD, 0xDD, 0xDE, 0xEF, 0xFF, 0xEE, 0xFF, 0xED, 0xDC, 0xCB,
    0xBB, 0xCC, 0xCD, 0xEE, 0xFF, 0xFE, 0xEF, 0xED, 0xCC, 0xBA, 0xAA, 0xAA,
    0xBB, 0xCD, 0xEE, 0xFF, 0xFE, 0xEE, 0xDC, 0xBA, 0x98, 0x88, 0x99, 0xAB,
    0xCD, 0xDE, 0xFE, 0xEF, 0xDC, 0xBA, 0x98, 0x77, 0x77, 0x89, 0xAB, 0xCD,
    0xFF, 0xEE, 0xED, 0xCA, 0x98, 0x76, 0x55, 0x67, 0x89, 0xAC, 0xDE, 0xFF,
    0xEE, 0xCB, 0xA8, 0x76, 0x54, 0x45, 0x67, 0x8A, 0xBD, 0xDF, 0xEE, 0xED,
    0xBA, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xDE, 0xFF, 0xDE, 0xCB, 0xA8,
    0x75, 0x43, 0x24, 0x57, 0x8A, 0xBD, 0xEF, 0xED, 0xED, 0xBA, 0x97, 0x65,
    0x44, 0x46, 0x78, 0xAB, 0xDD, 0xFE, 0xDF, 0xDC, 0xA9, 0x87, 0x65, 0x56,
    0x78, 0x9A, 0xCD, 0xEF, 0xEE, 0xED, 0xDB, 0xA9, 0x87, 0x77, 0x78, 0x9A,
    0xBC, 0xDF, 0xFE, 0xDF, 0xED, 0xCB, 0xA9, 0x98, 0x88, 0x9A, 0xBB, 0xDD,
    0xFF, 0xFD, 0xFE, 0xDD, 0xCB, 0xAA, 0xAA, 0xAA, 0xBC, 0xDD, 0xFE, 0xFE,
    0xDF, 0xEE, 0xDD, 0xCC, 0xCB, 0xBB, 0xBC, 0xCD, 0xEF, 0xFF, 0xFD, 0xFE,
    0xFE, 0xDD, 0xDC, 0xCC, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xDF, 0xFE, 0xFF,
    0xEE, 0xED, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xED, 0xFE, 0xEF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0x9E, 0xFE,
    0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xEE, 0xEE, 0xDE, 0xDD, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBB, 0xCD, 0xDD, 0xEF, 0xED, 0xDD, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xCC, 0xDE, 0xED, 0xCD, 0xCB, 0xBA, 0x99, 0x98, 0x89,
    0x9A, 0xAB, 0xCC, 0xDE, 0xDC, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xED, 0xCC, 0xBA, 0x98, 0x87, 0x66, 0x66, 0x78, 0x99, 0xAB,
    0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xCC, 0xBA, 0x97, 0x66, 0x54, 0x45, 0x66, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x89, 0xBC, 0xDD, 0xCC, 0xBA, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x86, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xDC, 0xAA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9A, 0xBD, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xDD, 0xDC, 0xCB, 0xAA, 0x99, 0x88, 0x89, 0x9A, 0xBC, 0xCD, 0xEE,
    0xDD, 0xDC, 0xCB, 0xAA, 0xAA, 0xAA, 0xAA, 0xBC, 0xCD, 0xEF, 0xED, 0xEE,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEE, 0xFE, 0xDE, 0xEE, 0xDD,
    0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xEE, 0xFF, 0xED, 0xFF, 0xEE, 0xEE, 0xDD,
    0xDD, 0xDD, 0xDE, 0xEE, 0xFF, 0xFF, 0x9D, 0xED, 0xDD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDE, 0xEE, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xCC, 0xCB, 0xBB, 0xBB, 0xBC, 0xCC, 0xCD, 0xDD, 0xAE, 0xEE,
    0xDC, 0xCC, 0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xDE, 0xED, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDE, 0xDD, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xCD, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0xAA, 0xBC, 0xDD, 0xDC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAA, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xCB, 0xBA, 0x98, 0x77, 0x65, 0x55, 0x56, 0x78, 0x89, 0xAB, 0xDC,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBC, 0xAA, 0x88, 0x76, 0x65, 0x55,
    0x67, 0x78, 0x9A, 0xBC, 0xCC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xCD, 0xDC, 0xCC, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCC, 0xDD,
    0xCD, 0xCC, 0xBA, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xDD, 0xED,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xEE, 0xDE, 0xDD, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xEF, 0xED, 0xFE, 0xED, 0xDD, 0xCC,
    0xCC, 0xCC, 0xDD, 0xDE, 0xEF, 0xFE, 0xAD, 0xDD, 0xDD, 0xCC, 0xCC, 0xCC,
    0xCD, 0xDD, 0xDE, 0xEE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0x9E, 0xFE,
    0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDE, 0xEE, 0xED, 0xDE, 0xED, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xDD, 0xED, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xED, 0xDD, 0xCC, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xAB, 0xCD, 0xDE, 0xDC, 0xDC, 0xBA, 0x99, 0x88, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xED, 0xCC, 0xBA, 0xA9, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xCD, 0xCC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xCC, 0xBA, 0x98, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xDC, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xCC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9A, 0xBC, 0xDC, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDD, 0xDC, 0xDC, 0xCB, 0xAA, 0x99, 0x88, 0x99, 0x9A, 0xBB, 0xCD, 0xED,
    0xDE, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDE, 0xDD, 0xED,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xED, 0xDF, 0xED, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xEF, 0xDD, 0xEE, 0xEE, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDE, 0xEE, 0xEF, 0xFE, 0x9D, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC,
    0xCD, 0xDD, 0xDD, 0xDE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFF, 0xFE, 0xFD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0x8F, 0xFF,
    0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xEE, 0xFE, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xEE, 0xDD,
    0xDD, 0xDD, 0xFE, 0xFF, 0xEF, 0xFF, 0xFF, 0xFE, 0xFD, 0xCC, 0xBB, 0xBC,
    0xCC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xCB, 0xBA, 0xAA, 0xAB, 0xCD,
    0xDE, 0xFF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x88, 0x88, 0x9A, 0xCD, 0xEF,
    0xFF, 0xFF, 0xFF, 0xEC, 0xA9, 0x86, 0x66, 0x78, 0x9B, 0xCE, 0xFF, 0xFF,
    0xFF, 0xED, 0xCA, 0x86, 0x54, 0x45, 0x78, 0xAC, 0xDE, 0xFF, 0xFF, 0xFF,
    0xCB, 0xA8, 0x64, 0x22, 0x46, 0x8A, 0xBD, 0xFF, 0xFF, 0xEF, 0xFE, 0xBA,
    0x86, 0x42, 0x24, 0x68, 0xAC, 0xDE, 0xFF, 0xFF, 0xFE, 0xDC, 0xA8, 0x75,
    0x44, 0x56, 0x8A, 0xBD, 0xFF, 0xFF, 0xFF, 0xED, 0xCB, 0x98, 0x76, 0x66,
    0x79, 0xAC, 0xDF, 0xFF, 0xFF, 0xFF, 0xED, 0xCA, 0x98, 0x88, 0x89, 0xAB,
    0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xBB, 0xAA, 0xAA, 0xAB, 0xCD, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xCC, 0xBB, 0xCC, 0xDD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFE, 0xED, 0xDD, 0xDD, 0xDE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9E, 0xFE, 0xFF, 0xEF, 0xFF, 0xFE,
    0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDD, 0xCC, 0xCB, 0xBB, 0xBB, 0xCC, 0xCC, 0xCD, 0xDD, 0x9D, 0xFE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEE, 0xFE, 0xDE, 0xDD, 0xCC,
    0xBB, 0xAA, 0xAB, 0xBB, 0xBC, 0xDD, 0xEE, 0xED, 0xDD, 0xCB, 0xAA, 0xA9,
    0x99, 0x9A, 0xAB, 0xCC, 0xDD, 0xED, 0xCD, 0xCB, 0xAA, 0x98, 0x88, 0x88,
    0x99, 0xAB, 0xBC, 0xDE, 0xDC, 0xCB, 0xBA, 0x98, 0x87, 0x77, 0x78, 0x89,
    0xAB, 0xCD, 0xED, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x78, 0x89, 0xAB,
    0xCD, 0xCC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xBB, 0xA9, 0x87, 0x66, 0x54, 0x55, 0x66, 0x78, 0x9A, 0xCD, 0xCB, 0xBA,
    0x98, 0x76, 0x54, 0x44, 0x45, 0x67, 0x89, 0xAB, 0xCC, 0xBC, 0xA9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xCA, 0x98, 0x76, 0x65,
    0x54, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xCB, 0xA9, 0x88, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDC, 0xCC, 0xCA, 0xA9, 0x88, 0x77, 0x77, 0x88, 0x9A, 0xBB,
    0xCD, 0xDC, 0xDC, 0xBA, 0xA9, 0x98, 0x88, 0x89, 0x9A, 0xAB, 0xCD, 0xDD,
    0xDE, 0xDC, 0xBB, 0xAA, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xDE, 0xDD, 0xED,
    0xDC, 0xCB, 0xBA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDE, 0xFE, 0xDE, 0xED, 0xDC,
    0xCC, 0xCB, 0xBB, 0xCC, 0xDD, 0xDE, 0xEF, 0xED, 0xEF, 0xEE, 0xDD, 0xDD,
    0xDC, 0xDD, 0xDD, 0xEE, 0xFF, 0xFE, 0x8D, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC,
    0xCC, 0xCD, 0xDE, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0x9C, 0xDC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDC, 0xBC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCD, 0xCB, 0xCB, 0xAA, 0x99, 0x98,
    0x88, 0x99, 0x99, 0xAB, 0xBC, 0xDC, 0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x99, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xAB, 0xCB, 0xAB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBB, 0xBA, 0xA9, 0x98, 0x76, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xBA, 0xA9,
    0x88, 0x76, 0x55, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0x98, 0x87,
    0x65, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xBA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0x99, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xBA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xAB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xBB, 0xBB, 0xA9, 0x98, 0x88, 0x87, 0x88, 0x89, 0x9A, 0xBB, 0xCB,
    0xBC, 0xBB, 0xAA, 0x99, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCD, 0xCB, 0xDC,
    0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xDC, 0xBD, 0xCC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xBB, 0xCC, 0xDE, 0xCC, 0xED, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xED, 0x8C, 0xCC, 0xBB, 0xBB, 0xBB, 0xBB,
    0xBB, 0xBC, 0xCC, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0x9B, 0xCB,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDB, 0xBB, 0xBA, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBA, 0xBA, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xBB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x78,
    0x88, 0x89, 0xAA, 0xBB, 0xBA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAA, 0xBA, 0x9A, 0x99, 0x87, 0x77, 0x66, 0x66, 0x77, 0x88, 0x99,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAA, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAA, 0xA9, 0xA9, 0x98, 0x87, 0x76, 0x66, 0x67, 0x77,
    0x89, 0x9A, 0xBA, 0xAA, 0xA9, 0x88, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0xAA, 0xBA, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xBB,
    0xAB, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x89, 0x99, 0xAA, 0xBC, 0xBA, 0xCB,
    0xAA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xBA,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xBB, 0xCC, 0xCB, 0xBB, 0xBA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDC, 0x9B, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0x9C, 0xDC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDC, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCD, 0xBB, 0xCB, 0xAA, 0x99, 0x98,
    0x88, 0x89, 0x99, 0xAB, 0xBC, 0xCB, 0xAB, 0xAA, 0x99, 0x88, 0x88, 0x78,
    0x88, 0x99, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBB, 0xBA, 0xA9, 0x98, 0x76, 0x66, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xAA, 0xA9,
    0x87, 0x76, 0x55, 0x55, 0x55, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x98, 0x87,
    0x65, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xAA, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x99, 0x87, 0x76, 0x65, 0x56,
    0x67, 0x78, 0x99, 0xAB, 0xAA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x89, 0xAA, 0xBB, 0xAB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89, 0x9A,
    0xBC, 0xBA, 0xBB, 0xA9, 0x98, 0x88, 0x87, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xAA, 0x99, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xBB, 0xCC,
    0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDB, 0xBD, 0xCC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xCC, 0xDD, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xCD, 0xDC, 0x8C, 0xCB, 0xBB, 0xBA, 0xAA, 0xAA,
    0xBB, 0xBB, 0xBC, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDC, 0xCC, 0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCC, 0xCD, 0x8D, 0xEE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xCC, 0xCC, 0xDD, 0xEE, 0xFD, 0xDD, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAB, 0xBB, 0xBC, 0xDD, 0xEF, 0xDD, 0xDC, 0xCB, 0xAA, 0xA9,
    0x99, 0x9A, 0xAB, 0xBC, 0xDD, 0xED, 0xCC, 0xCB, 0xAA, 0x98, 0x88, 0x88,
    0x99, 0xAB, 0xBC, 0xDD, 0xDC, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x78, 0x89,
    0xAB, 0xCC, 0xDC, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xCB, 0xBB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xBB, 0xA9, 0x87, 0x66, 0x54, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x54, 0x44, 0x45, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x65,
    0x54, 0x56, 0x67, 0x89, 0xAB, 0xCC, 0xBC, 0xBA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x88, 0x9B, 0xBD, 0xCC, 0xCB, 0xA9, 0x88, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xCD, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x88, 0x9A, 0xAB,
    0xCD, 0xCC, 0xDC, 0xBB, 0xA9, 0x98, 0x88, 0x89, 0x99, 0xAB, 0xCD, 0xDD,
    0xDD, 0xCC, 0xBA, 0xAA, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDE, 0xDD, 0xED,
    0xDC, 0xCB, 0xBA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDE, 0xEE, 0xDE, 0xDD, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xED, 0xFF, 0xDE, 0xDD, 0xDC,
    0xCC, 0xCD, 0xDD, 0xEE, 0xEF, 0xFE, 0x9D, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC,
    0xCD, 0xDD, 0xDE, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xFF, 0xFF, 0xFE, 0xEF, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0x9F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xEE, 0xDE, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD,
    0xDD, 0xDD, 0xDD, 0xDD, 0xEE, 0xFF, 0xFF, 0xEF, 0xFF, 0xFD, 0xDC, 0xCC,
    0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFE, 0xFF, 0xFE, 0xDC, 0xBA, 0xAA, 0xAA,
    0xAB, 0xCD, 0xEF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0x98, 0x88, 0x89, 0xAB,
    0xCD, 0xEF, 0xFF, 0xEF, 0xDC, 0xBA, 0x98, 0x76, 0x77, 0x89, 0xAB, 0xCD,
    0xFF, 0xEE, 0xED, 0xCA, 0x98, 0x66, 0x55, 0x66, 0x89, 0xAB, 0xDE, 0xFF,
    0xEE, 0xDB, 0xA8, 0x76, 0x44, 0x45, 0x67, 0x8A, 0xCD, 0xFF, 0xFE, 0xFD,
    0xBA, 0x86, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xDE, 0xFF, 0xDE, 0xDB, 0xA8,
    0x75, 0x43, 0x34, 0x56, 0x8A, 0xBD, 0xEF, 0xFE, 0xFD, 0xBA, 0x87, 0x65,
    0x44, 0x45, 0x78, 0xAB, 0xDE, 0xFF, 0xEE, 0xDC, 0xA9, 0x87, 0x65, 0x55,
    0x68, 0x9A, 0xCD, 0xFF, 0xFE, 0xFD, 0xCB, 0xA9, 0x87, 0x76, 0x77, 0x9A,
    0xBC, 0xEF, 0xFF, 0xEF, 0xFD, 0xCB, 0xA9, 0x88, 0x88, 0x9A, 0xBC, 0xDF,
    0xFF, 0xFD, 0xFE, 0xDC, 0xCB, 0xAA, 0x9A, 0xAA, 0xBC, 0xDF, 0xFF, 0xFF,
    0xDF, 0xFE, 0xDD, 0xCC, 0xBB, 0xBB, 0xCD, 0xDD, 0xFF, 0xFF, 0xFD, 0xFF,
    0xFE, 0xED, 0xDC, 0xDC, 0xDD, 0xEE, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xEE,
    0xEF, 0xED, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xDD, 0xCD, 0xDE, 0xDD, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xDE, 0xDD, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0x9E, 0xFE,
    0xED, 0xDD, 0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xEF, 0xFD, 0xEE, 0xED, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xED, 0xED, 0xCC, 0xBA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFD, 0xDE, 0xCC, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xAB, 0xCD, 0xDE, 0xDD, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A,
    0xAB, 0xCD, 0xED, 0xCD, 0xCB, 0xA8, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xDD, 0xDC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xCC, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDD, 0xCD, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAC, 0xCE, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x66, 0x67, 0x89,
    0xAB, 0xCD, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xEC, 0xDD, 0xCB, 0xAA, 0x99, 0x89, 0x99, 0xAA, 0xBC, 0xDE, 0xEE,
    0xDD, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xEF, 0xEC, 0xED,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xFE, 0xDF, 0xEE, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCD, 0xED, 0xFE, 0xFF, 0xFC, 0xFF, 0xFE, 0xED, 0xDD,
    0xDD, 0xDD, 0xEE, 0xFE, 0xFF, 0xFF, 0x9D, 0xED, 0xDD, 0xDD, 0xDD, 0xDD,
    0xED, 0xDE, 0xEF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xDC, 0xCC, 0xBB, 0xBB, 0xBC, 0xCC, 0xCD, 0xDD, 0xAE, 0xEE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEE, 0xEE, 0xDE, 0xDD, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDE, 0xDD, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x9A, 0xAA, 0xBC, 0xCD, 0xED, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0xAA, 0xBC, 0xCD, 0xDC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x78, 0x89,
    0xAA, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDC, 0xCA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xDC,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x54, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x65,
    0x54, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBC, 0xAA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x78, 0x9A, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xCD, 0xDC, 0xDC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xED,
    0xCD, 0xCC, 0xBA, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xED, 0xED,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDE, 0xFE, 0xDE, 0xDD, 0xCC,
    0xCC, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xFF, 0xED, 0xFE, 0xED, 0xDD, 0xCC,
    0xCC, 0xCD, 0xDD, 0xEE, 0xEF, 0xFF, 0xAD, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC,
    0xCD, 0xDD, 0xEE, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0x9E, 0xFF,
    0xEE, 0xDD, 0xCC, 0xCC, 0xCC, 0xCD, 0xDE, 0xEF, 0xFD, 0xEF, 0xED, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xDD, 0xED, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAB, 0xCC, 0xDD, 0xED, 0xDE, 0xDC, 0xBA, 0xA9, 0x98, 0x89,
    0x9A, 0xAB, 0xCC, 0xDE, 0xDD, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xED, 0xCD, 0xCB, 0xA8, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBB,
    0xCD, 0xDC, 0xDB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xCC, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9A, 0xBC, 0xDD, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x78, 0x89, 0x9A, 0xBC,
    0xCD, 0xDD, 0xDC, 0xCB, 0xAA, 0x99, 0x98, 0x99, 0x9A, 0xBB, 0xCD, 0xDD,
    0xDE, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDD, 0xDD, 0xED,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xED, 0xDE, 0xED, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDE, 0xEF, 0xDD, 0xFE, 0xEE, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDE, 0xEE, 0xEF, 0xFE, 0x9D, 0xDD, 0xDD, 0xDD, 0xDD, 0xCC,
    0xDD, 0xDD, 0xDE, 0xDE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFE, 0xEE, 0xDD, 0xDD, 0xDC, 0xCC, 0xDD, 0xCD, 0x8F, 0xFF,
    0xFF, 0xFF, 0xFE, 0xDE, 0xEE, 0xDF, 0xEF, 0xFF, 0xFE, 0xEF, 0xFF, 0xFF,
    0xDD, 0xDC, 0xCC, 0xDD, 0xDE, 0xEE, 0xFF, 0xDF, 0xFF, 0xEE, 0xDC, 0xCB,
    0xBB, 0xBC, 0xCD, 0xDD, 0xFF, 0xFE, 0xFF, 0xFD, 0xDC, 0xBA, 0xAA, 0xAA,
    0xAB, 0xCD, 0xEE, 0xFF, 0xEE, 0xEE, 0xCC, 0xBA, 0x98, 0x88, 0x89, 0xAB,
    0xCC, 0xEF, 0xFF, 0xFF, 0xDC, 0xBA, 0x88, 0x77, 0x77, 0x89, 0xAB, 0xCD,
    0xEF, 0xFE, 0xED, 0xCA, 0x97, 0x65, 0x55, 0x67, 0x89, 0xAC, 0xDE, 0xFE,
    0xEE, 0xDB, 0xA8, 0x75, 0x44, 0x45, 0x67, 0x8A, 0xBD, 0xEE, 0xED, 0xFC,
    0xBA, 0x87, 0x54, 0x33, 0x45, 0x78, 0x9B, 0xDE, 0xFF, 0xDD, 0xCB, 0xA8,
    0x75, 0x43, 0x34, 0x57, 0x8A, 0xBC, 0xEF, 0xFD, 0xDC, 0xBA, 0x87, 0x65,
    0x44, 0x45, 0x78, 0xAB, 0xDE, 0xFF, 0xDE, 0xDC, 0xA9, 0x87, 0x65, 0x55,
    0x68, 0x9A, 0xCD, 0xEF, 0xFD, 0xED, 0xCB, 0xA9, 0x87, 0x77, 0x78, 0x9A,
    0xBC, 0xEF, 0xFF, 0xDE, 0xEC, 0xCB, 0xA9, 0x88, 0x88, 0x9A, 0xBC, 0xDD,
    0xFF, 0xFF, 0xFF, 0xDC, 0xBB, 0xAA, 0xAA, 0xAA, 0xBC, 0xDD, 0xEF, 0xFF,
    0xEF, 0xFE, 0xDD, 0xCC, 0xBB, 0xBB, 0xCC, 0xDD, 0xFF, 0xFF, 0xFE, 0xFE,
    0xEE, 0xDD, 0xDC, 0xCC, 0xCD, 0xDF, 0xEF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF,
    0xEE, 0xED, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xDD, 0xDE, 0xED, 0xDE, 0xFF,
    0xEF, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xDD, 0xDC, 0xCC, 0xCC, 0xCB, 0xCC, 0xCC, 0xCC, 0xCD, 0x8E, 0xFE,
    0xED, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xEE, 0xEF, 0xFD, 0xDE, 0xED, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xED, 0xED, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFD, 0xDD, 0xCC, 0xBA, 0x99, 0x99, 0x99,
    0x9A, 0xAB, 0xCD, 0xEE, 0xDC, 0xDC, 0xBA, 0x98, 0x88, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xED, 0xCC, 0xCA, 0x98, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBB,
    0xDD, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xCC, 0xBA, 0x98, 0x66, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x34, 0x56, 0x79, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x56, 0x68, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9A, 0xBC, 0xED, 0xCD, 0xCB, 0xAA, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xDC, 0xDC, 0xCB, 0xAA, 0x99, 0x88, 0x99, 0x9A, 0xBC, 0xCD, 0xEE,
    0xDE, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBC, 0xCD, 0xDF, 0xED, 0xED,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEE, 0xFE, 0xDE, 0xED, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xEF, 0xFF, 0xED, 0xFE, 0xEE, 0xED, 0xDD,
    0xCD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0x7C, 0xCC, 0xCC, 0xCC, 0xDC, 0xCD,
    0xDD, 0xDE, 0xEE, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0x8C, 0xDD,
    0xCB, 0xBB, 0xBA, 0xAA, 0xAB, 0xBB, 0xBC, 0xCD, 0xDC, 0xCC, 0xCB, 0xBA,
    0xAA, 0x99, 0x9A, 0xAA, 0xAB, 0xBC, 0xDD, 0xCB, 0xCB, 0xBA, 0xA9, 0x99,
    0x89, 0x99, 0x9A, 0xAB, 0xBC, 0xDC, 0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xAB, 0xCC, 0xBB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xAB, 0xCB, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x89, 0x9A,
    0xBC, 0xBA, 0xAA, 0x98, 0x77, 0x66, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xCB,
    0xAA, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xAB, 0xBA, 0xA9,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0x9A, 0xBB, 0xAA, 0x99, 0x87,
    0x66, 0x54, 0x45, 0x56, 0x78, 0x99, 0xAB, 0xBA, 0xAA, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x89, 0xAA, 0xBB, 0xAA, 0xA9, 0x88, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x9A, 0xAB, 0xBA, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x89, 0xAB, 0xCB, 0xBB, 0xAA, 0x99, 0x87, 0x77, 0x77, 0x78, 0x89, 0x9A,
    0xBC, 0xBB, 0xCB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xBB, 0xCC,
    0xBC, 0xBB, 0xAA, 0x99, 0x99, 0x89, 0x99, 0xAA, 0xBB, 0xCD, 0xCB, 0xCC,
    0xCB, 0xAA, 0xA9, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xDC, 0xBD, 0xDC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xBB, 0xCC, 0xDE, 0xCC, 0xDD, 0xDC, 0xCC, 0xBB,
    0xBB, 0xBB, 0xCC, 0xCD, 0xDD, 0xED, 0x8C, 0xCB, 0xBB, 0xBB, 0xBB, 0xBB,
    0xBB, 0xBC, 0xCC, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0xA9, 0x99, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0x9B, 0xCC,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xCB, 0xBC, 0xBA, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBA, 0xBB, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xBB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x78,
    0x88, 0x99, 0xAA, 0xBB, 0xBA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAA, 0xBA, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x99,
    0xAB, 0xA9, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAA, 0xA9, 0xA9, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0xAA, 0xBA, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xBB,
    0xAB, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x89, 0x99, 0xAA, 0xBC, 0xBB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xCB, 0xBC, 0xCB, 0xBA,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xCB, 0xDC, 0xCB, 0xBB, 0xBA,
    0xAA, 0xAB, 0xBB, 0xBC, 0xCD, 0xDC, 0x9B, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xBB, 0xBC, 0xCC, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0x8C, 0xDC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xBB, 0xBB, 0xCC, 0xCD, 0xDC, 0xBD, 0xCB, 0xBA,
    0xAA, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xCB, 0xCB, 0xBA, 0xA9, 0x99,
    0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDB, 0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xAB, 0xBC, 0xBB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x88,
    0x9A, 0xBB, 0xCB, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x89, 0x9A,
    0xBB, 0xBA, 0xBA, 0x98, 0x77, 0x66, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xBB,
    0xAA, 0x99, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xBB, 0xBA, 0xA9,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAA, 0xBB, 0xAA, 0x99, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x99, 0xAB, 0xBA, 0xAA, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x89, 0x9A, 0xBB, 0xAB, 0xA9, 0x88, 0x76, 0x65, 0x56,
    0x67, 0x78, 0x9A, 0xAB, 0xBA, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x89, 0xAB, 0xBB, 0xBB, 0xBA, 0x98, 0x88, 0x77, 0x77, 0x78, 0x89, 0x9A,
    0xBC, 0xBB, 0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xAA, 0x99, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xCB, 0xDC,
    0xBB, 0xAA, 0xAA, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xDC, 0xCD, 0xCC, 0xCB,
    0xBB, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDD, 0xCC, 0xDD, 0xCC, 0xCC, 0xBB,
    0xBB, 0xBB, 0xCC, 0xCC, 0xDE, 0xED, 0x8C, 0xCB, 0xBB, 0xBB, 0xBB, 0xBB,
    0xBB, 0xBB, 0xCC, 0xCD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xEE, 0xED, 0xDC, 0xCC, 0xBC, 0xCC, 0xCC, 0xDC, 0xCD, 0x7E, 0xFF,
    0xEE, 0xDD, 0xCC, 0xCC, 0xCD, 0xDE, 0xEE, 0xEF, 0xFD, 0xEF, 0xED, 0xDC,
    0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xEE, 0xFF, 0xED, 0xEE, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCD, 0xDF, 0xFE, 0xDE, 0xDC, 0xBA, 0xA9, 0x99, 0x99,
    0x9A, 0xAB, 0xCD, 0xEF, 0xED, 0xEC, 0xBA, 0x99, 0x88, 0x77, 0x88, 0x9A,
    0xBB, 0xDD, 0xED, 0xDD, 0xCB, 0x99, 0x87, 0x76, 0x67, 0x78, 0x9A, 0xBC,
    0xCE, 0xDD, 0xDB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xCD, 0xED,
    0xCC, 0xBA, 0x98, 0x76, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA9, 0x76, 0x54, 0x34, 0x45, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x34, 0x56, 0x79, 0xAB, 0xCD, 0xEC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x56, 0x78, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x89, 0xAB, 0xCE, 0xDD, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x77, 0x89,
    0xAB, 0xCD, 0xED, 0xDD, 0xCB, 0xAA, 0x98, 0x87, 0x78, 0x89, 0x9A, 0xBC,
    0xDF, 0xED, 0xED, 0xCB, 0xAA, 0x99, 0x89, 0x99, 0xAA, 0xBC, 0xDE, 0xEF,
    0xDE, 0xDD, 0xCC, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFE, 0xFD, 0xFE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xFF, 0xFF, 0xDF, 0xEF, 0xED,
    0xDD, 0xCC, 0xCC, 0xCD, 0xEE, 0xFE, 0xFF, 0xFD, 0xEF, 0xEE, 0xFE, 0xDD,
    0xDD, 0xED, 0xEE, 0xFF, 0xFF, 0xFF, 0x8D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xED, 0xFE, 0xEF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xED, 0xDD, 0xDD, 0xDD, 0xCC, 0x8F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xFE, 0xEF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF,
    0xFE, 0xCD, 0xDC, 0xDD, 0xDD, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xDC, 0xCC,
    0xBC, 0xBC, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFE, 0xDD, 0xBB, 0xAA, 0xAA,
    0xBB, 0xCC, 0xDF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0x98, 0x88, 0x89, 0xAB,
    0xCC, 0xDE, 0xFF, 0xFF, 0xFD, 0xBA, 0x98, 0x77, 0x77, 0x89, 0xAB, 0xDD,
    0xFF, 0xFF, 0xFE, 0xCB, 0x98, 0x65, 0x55, 0x67, 0x89, 0xAC, 0xDF, 0xFF,
    0xFF, 0xDB, 0xA8, 0x75, 0x44, 0x45, 0x67, 0x8A, 0xCD, 0xFF, 0xFF, 0xFD,
    0xBA, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xCE, 0xFF, 0xEF, 0xCB, 0xA8,
    0x75, 0x43, 0x34, 0x57, 0x8A, 0xBD, 0xFF, 0xFE, 0xFD, 0xCA, 0x97, 0x65,
    0x44, 0x45, 0x78, 0xAB, 0xDD, 0xFF, 0xEF, 0xDC, 0xA9, 0x87, 0x65, 0x55,
    0x67, 0x9A, 0xCE, 0xFF, 0xFE, 0xFF, 0xDB, 0xA9, 0x87, 0x76, 0x77, 0x9A,
    0xBC, 0xFF, 0xFF, 0xEF, 0xFC, 0xCB, 0xA9, 0x88, 0x88, 0x9A, 0xBC, 0xDF,
    0xFF, 0xFE, 0xFE, 0xDC, 0xCB, 0xAA, 0xAA, 0xAA, 0xBC, 0xDE, 0xFF, 0xFF,
    0xDF, 0xFE, 0xDC, 0xDC, 0xBB, 0xBB, 0xCC, 0xDF, 0xFF, 0xFF, 0xFD, 0xFF,
    0xFE, 0xED, 0xDD, 0xDC, 0xDE, 0xFE, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF,
    0xEF, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0xDC, 0xDC, 0xDE, 0xFE, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xDE, 0xEE, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x8F, 0xFF,
    0xEE, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xFE, 0xED, 0xFF, 0xFE, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEF, 0xDD, 0xEE, 0xDC, 0xCB, 0xBB,
    0xAB, 0xBB, 0xBC, 0xCD, 0xDE, 0xED, 0xDE, 0xDD, 0xCB, 0xAA, 0x99, 0x99,
    0xAA, 0xBC, 0xCD, 0xEE, 0xDD, 0xDD, 0xCB, 0xA9, 0x88, 0x88, 0x89, 0x9A,
    0xBC, 0xDD, 0xED, 0xCD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xDD, 0xDC, 0xBA, 0x87, 0x66, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xDD,
    0xCD, 0xCA, 0x98, 0x76, 0x54, 0x45, 0x67, 0x8A, 0xAC, 0xDE, 0xDC, 0xDB,
    0xA9, 0x87, 0x54, 0x33, 0x45, 0x78, 0x9A, 0xCD, 0xDD, 0xCD, 0xCA, 0x98,
    0x75, 0x43, 0x34, 0x56, 0x89, 0xAC, 0xCE, 0xDC, 0xDC, 0xBA, 0x87, 0x65,
    0x44, 0x55, 0x78, 0x9A, 0xCD, 0xED, 0xCD, 0xCB, 0xA9, 0x87, 0x65, 0x55,
    0x67, 0x8A, 0xBC, 0xDE, 0xDC, 0xDC, 0xBA, 0x98, 0x87, 0x76, 0x77, 0x89,
    0xAB, 0xCD, 0xEE, 0xCD, 0xDC, 0xBA, 0x99, 0x88, 0x88, 0x89, 0xAB, 0xCD,
    0xDF, 0xDC, 0xED, 0xCB, 0xBA, 0xA9, 0x99, 0x9A, 0xAB, 0xBC, 0xEF, 0xFE,
    0xCE, 0xDD, 0xCC, 0xBB, 0xAA, 0xBB, 0xBB, 0xCC, 0xDE, 0xFF, 0xED, 0xED,
    0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xFF, 0xFF, 0xDE, 0xEE, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xFF, 0xFF, 0xFD, 0xEE, 0xEE, 0xEE, 0xEE,
    0xDE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0x8D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xED, 0xEE, 0xEF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xED, 0xDC, 0xCC, 0xBB, 0xBB, 0xBB, 0xBC, 0xCC, 0xCC, 0xAE, 0xFE,
    0xED, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xED, 0xEE, 0xDD, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDE, 0xDD, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xDC, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xCD, 0xCC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xBC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xCC,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x88, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xDB, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDC, 0xCB, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xED,
    0xCD, 0xCB, 0xBA, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xEC, 0xDD,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDE, 0xFE, 0xCE, 0xDD, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFC, 0xEE, 0xDD, 0xDC, 0xCC,
    0xCC, 0xCC, 0xDD, 0xEE, 0xFF, 0xFF, 0x9D, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC,
    0xDD, 0xDE, 0xEE, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xFF, 0xED, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x8F, 0xFF,
    0xEE, 0xDD, 0xDC, 0xCC, 0xCC, 0xDD, 0xDD, 0xEE, 0xED, 0xFF, 0xFD, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEE, 0xDF, 0xFE, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFD, 0xEF, 0xDC, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xAB, 0xCC, 0xDE, 0xDE, 0xEC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A,
    0xAB, 0xCD, 0xED, 0xDD, 0xCB, 0xA8, 0x77, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xDD, 0xDD, 0xDB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBD, 0xDD,
    0xDD, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xED, 0xCD, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xDE, 0xEC, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0xAB, 0xCD, 0xEE, 0xDD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xEF, 0xED, 0xDD, 0xCB, 0xAA, 0x99, 0x98, 0x99, 0x9A, 0xBC, 0xDE, 0xFE,
    0xDD, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xFD, 0xFE,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDE, 0xFF, 0xFF, 0xDE, 0xDD, 0xDD,
    0xDC, 0xCC, 0xCC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFD, 0xFE, 0xED, 0xDD, 0xED,
    0xDD, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0xDC, 0xDD, 0xCD, 0xDD, 0xDE,
    0xDE, 0xEF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDD, 0xDC, 0xDD, 0xCC, 0xCC, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF,
    0xFD, 0xDD, 0xDD, 0xDD, 0xDF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xDD, 0xCB,
    0xBB, 0xBC, 0xCC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDC, 0xBA, 0xAA, 0xAA,
    0xBB, 0xCC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFB, 0xBA, 0x98, 0x88, 0x89, 0xAB,
    0xCC, 0xDF, 0xFF, 0xFF, 0xDC, 0xBA, 0x97, 0x77, 0x77, 0x89, 0xAB, 0xCD,
    0xFF, 0xFF, 0xFD, 0xCB, 0x98, 0x65, 0x55, 0x67, 0x89, 0xBC, 0xDF, 0xFF,
    0xFF, 0xDC, 0xA8, 0x75, 0x44, 0x45, 0x67, 0x8A, 0xBD, 0xFF, 0xFF, 0xFD,
    0xBA, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xDF, 0xFF, 0xFF, 0xDC, 0x98,
    0x75, 0x43, 0x34, 0x56, 0x8A, 0xCD, 0xFF, 0xFF, 0xFD, 0xCA, 0x97, 0x65,
    0x44, 0x45, 0x78, 0xAC, 0xDF, 0xFF, 0xEF, 0xDC, 0xA9, 0x87, 0x65, 0x55,
    0x68, 0x9A, 0xCE, 0xFF, 0xFF, 0xFE, 0xCB, 0xA9, 0x87, 0x77, 0x78, 0x9A,
    0xBC, 0xDF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x98, 0x88, 0x9A, 0xBC, 0xDF,
    0xFF, 0xFD, 0xFF, 0xDD, 0xBB, 0xAA, 0xAA, 0xAA, 0xBC, 0xDE, 0xFF, 0xFF,
    0xDF, 0xFD, 0xDD, 0xCB, 0xBB, 0xBB, 0xCD, 0xDF, 0xFF, 0xFF, 0xFD, 0xFF,
    0xDF, 0xDD, 0xDC, 0xDC, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFE,
    0xEF, 0xEF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFE, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0xCD, 0xDD, 0xED, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xFF, 0xEF, 0xEE, 0xDD, 0xDD, 0xDD, 0xDD, 0xDC, 0xDD, 0x7F, 0xFF,
    0xFF, 0xFE, 0xED, 0xEE, 0xDE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xDC, 0xCC, 0xCD, 0xDD, 0xEE, 0xEF, 0xFF, 0xEF, 0xFF, 0xFD, 0xDC, 0xCB,
    0xBB, 0xBC, 0xCD, 0xCF, 0xFF, 0xFE, 0xFF, 0xFD, 0xDB, 0xBA, 0xAA, 0xAA,
    0xAB, 0xCC, 0xDE, 0xFF, 0xFF, 0xFD, 0xDC, 0xAA, 0x99, 0x89, 0x99, 0xAB,
    0xBC, 0xDF, 0xFF, 0xFD, 0xDC, 0xBA, 0x98, 0x77, 0x78, 0x89, 0xAB, 0xCD,
    0xFF, 0xEF, 0xED, 0xCA, 0x98, 0x76, 0x56, 0x67, 0x89, 0xBC, 0xDE, 0xFE,
    0xDE, 0xCB, 0xA9, 0x76, 0x54, 0x45, 0x68, 0x9A, 0xBC, 0xEF, 0xEE, 0xED,
    0xBA, 0x87, 0x64, 0x23, 0x46, 0x78, 0xAB, 0xDD, 0xFE, 0xFE, 0xDB, 0xA9,
    0x76, 0x43, 0x24, 0x57, 0x8A, 0xBD, 0xDE, 0xED, 0xFD, 0xBA, 0x98, 0x65,
    0x44, 0x56, 0x79, 0xAB, 0xCD, 0xFF, 0xDD, 0xDC, 0xB9, 0x87, 0x66, 0x56,
    0x78, 0x9A, 0xBD, 0xEF, 0xFD, 0xFD, 0xCB, 0xA9, 0x88, 0x77, 0x78, 0x9A,
    0xBC, 0xDE, 0xFF, 0xDE, 0xDC, 0xBB, 0xA9, 0x98, 0x89, 0x9A, 0xAC, 0xDE,
    0xFF, 0xFE, 0xFE, 0xDD, 0xCB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xEF, 0xFF,
    0xDF, 0xED, 0xDC, 0xCC, 0xBB, 0xBB, 0xBC, 0xDD, 0xFF, 0xFF, 0xFD, 0xFF,
    0xEF, 0xDD, 0xDC, 0xCC, 0xDD, 0xDD, 0xEF, 0xFF, 0xFF, 0xDF, 0xFF, 0xEE,
    0xEE, 0xDD, 0xDE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xED,
    0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0xCC, 0xCC, 0xDD, 0xDC, 0xCE,
    0xEF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xCC, 0xBB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBA, 0xBB, 0xBB, 0x8D, 0xED,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xEC, 0xCD, 0xCC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xCC, 0xDC, 0xBA, 0xA9, 0x99,
    0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xDC, 0xBC, 0xBA, 0xA9, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xAB, 0xCD, 0xBB, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x89,
    0x9A, 0xBC, 0xCC, 0xBB, 0xA9, 0x88, 0x77, 0x66, 0x67, 0x78, 0x89, 0x9A,
    0xBC, 0xBB, 0xBA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xCB,
    0xAB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xBA, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCB, 0xAB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xBA, 0xBA, 0x98, 0x77, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCB, 0xAB, 0xA9, 0x88, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0xA9, 0x87, 0x77, 0x66, 0x66, 0x78,
    0x89, 0xAB, 0xCC, 0xBB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xBC, 0xCB, 0xCB, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x89, 0xAA, 0xBC, 0xDC,
    0xBC, 0xCB, 0xBA, 0xA9, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xDD, 0xDB, 0xCC,
    0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBC, 0xCD, 0xED, 0xCD, 0xCC, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xEF, 0xEC, 0xDD, 0xDD, 0xCC, 0xCC,
    0xCB, 0xCC, 0xCD, 0xDE, 0xEE, 0xFE, 0x8C, 0xCC, 0xCB, 0xBB, 0xBB, 0xBB,
    0xCC, 0xCC, 0xDE, 0xDE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0x9B, 0xCC,
    0xBB, 0xAA, 0xAA, 0xA9, 0xAA, 0xAA, 0xBB, 0xCC, 0xCB, 0xBC, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xBC, 0xBB, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xAB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x78,
    0x88, 0x99, 0x9A, 0xBB, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAA, 0xBA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x99,
    0xAB, 0xA9, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAA, 0xA9, 0xA9, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xBA, 0xBA, 0x99, 0x98, 0x88, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xBB,
    0xAB, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBA, 0xBB,
    0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xCC, 0xBC, 0xCB, 0xBA,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xCB, 0xCC, 0xCB, 0xBB, 0xBA,
    0xAA, 0xAB, 0xBB, 0xBC, 0xCD, 0xDC, 0x9B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xBB, 0xBC, 0xCD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xCC, 0xBB, 0xBB, 0xAA, 0xAA, 0xAB, 0xAB, 0xBB, 0xBC, 0x8D, 0xED,
    0xCC, 0xCB, 0xBA, 0xBA, 0xBB, 0xBB, 0xCC, 0xCD, 0xDC, 0xCD, 0xCC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xCC, 0xCB, 0xBA, 0xA9, 0x99,
    0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDC, 0xBC, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xAB, 0xBC, 0xBB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x89,
    0x9A, 0xAB, 0xCB, 0xBB, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x77, 0x89, 0x9A,
    0xBC, 0xBA, 0xBA, 0x98, 0x76, 0x65, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xCB,
    0xAB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xBA, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xBB, 0xAA, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xAB, 0xBA, 0xBA, 0x98, 0x77, 0x65,
    0x55, 0x56, 0x67, 0x89, 0xAB, 0xBB, 0xAB, 0xA9, 0x88, 0x76, 0x65, 0x55,
    0x67, 0x78, 0x9A, 0xBC, 0xBA, 0xBA, 0x99, 0x87, 0x77, 0x66, 0x66, 0x78,
    0x89, 0xAB, 0xCB, 0xBB, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x78, 0x89, 0xAA,
    0xBC, 0xCB, 0xCB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xBC, 0xDC,
    0xBC, 0xCB, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xCD, 0xCB, 0xCC,
    0xBB, 0xAA, 0xAA, 0xA9, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xBD, 0xCC, 0xCC,
    0xBB, 0xBA, 0xAB, 0xBB, 0xBC, 0xCD, 0xDE, 0xDC, 0xED, 0xCC, 0xCB, 0xBB,
    0xBB, 0xCC, 0xCC, 0xCD, 0xDE, 0xEE, 0x8C, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
    0xBB, 0xCC, 0xCD, 0xDD, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xFF, 0xEF, 0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x7F, 0xFF,
    0xFF, 0xFF, 0xDD, 0xDC, 0xDE, 0xDE, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFE,
    0xDD, 0xCC, 0xBC, 0xCC, 0xDE, 0xEE, 0xFF, 0xEF, 0xFE, 0xED, 0xCB, 0xBB,
    0xAB, 0xBB, 0xBC, 0xDD, 0xEF, 0xFE, 0xEF, 0xED, 0xCB, 0xAA, 0x99, 0x9A,
    0xAB, 0xBC, 0xDE, 0xEF, 0xED, 0xED, 0xCB, 0xA9, 0x98, 0x88, 0x89, 0x9A,
    0xBC, 0xDE, 0xFD, 0xEE, 0xDB, 0xA9, 0x87, 0x77, 0x77, 0x89, 0xAB, 0xCD,
    0xEF, 0xED, 0xEC, 0xBA, 0x87, 0x66, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xEE,
    0xDE, 0xCB, 0x98, 0x76, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xDF, 0xED, 0xDC,
    0xB9, 0x86, 0x54, 0x33, 0x45, 0x78, 0x9B, 0xCD, 0xED, 0xDD, 0xCB, 0x98,
    0x75, 0x43, 0x34, 0x57, 0x89, 0xBC, 0xDE, 0xFD, 0xDD, 0xBA, 0x87, 0x65,
    0x44, 0x46, 0x78, 0x9B, 0xCD, 0xEF, 0xEE, 0xCB, 0xA9, 0x87, 0x65, 0x56,
    0x67, 0x8A, 0xBC, 0xDF, 0xFE, 0xDD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x89,
    0xAC, 0xCE, 0xEF, 0xDE, 0xDC, 0xBA, 0xA9, 0x88, 0x88, 0x89, 0xAB, 0xCD,
    0xEF, 0xFD, 0xED, 0xDC, 0xBB, 0xA9, 0xA9, 0x9A, 0xBB, 0xCD, 0xEF, 0xFF,
    0xEF, 0xED, 0xCC, 0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xED, 0xFF,
    0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xDE, 0xEF, 0xFF, 0xFF, 0xDF, 0xFF, 0xDD,
    0xDD, 0xDD, 0xDE, 0xDE, 0xEF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFE, 0xEE,
    0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xDE, 0xDC, 0xED, 0xDD, 0xDE,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDC, 0xCC, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xCB,
    0xCE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBB, 0xAA, 0xAB, 0xBC,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBA, 0x98, 0x89, 0xAB, 0xCD, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xBA, 0x87, 0x66, 0x78, 0xAB, 0xCD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDB, 0x97, 0x54, 0x45, 0x79, 0xAC, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFC, 0xA8, 0x64, 0x22, 0x46, 0x8A, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCA,
    0x96, 0x42, 0x24, 0x68, 0xAC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xA9, 0x75,
    0x43, 0x57, 0x9A, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0xA8, 0x76, 0x67,
    0x89, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x88, 0x9A, 0xBC,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xCB, 0xAA, 0xAB, 0xBD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCC, 0xBB, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xDC, 0xDD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xDF, 0xDD, 0xDD, 0xCC, 0xDB, 0xCC, 0xCC, 0xCC, 0x8F, 0xFF,
    0xFE, 0xFD, 0xDD, 0xCC, 0xCC, 0xDD, 0xDD, 0xDE, 0xFD, 0xFF, 0xFF, 0xDD,
    0xCC, 0xBB, 0xBB, 0xBC, 0xDD, 0xDD, 0xFF, 0xDF, 0xFD, 0xDD, 0xCB, 0xBA,
    0xAA, 0xAA, 0xAC, 0xCC, 0xFF, 0xFD, 0xFF, 0xDD, 0xCA, 0xA9, 0x99, 0x99,
    0x9A, 0xAB, 0xCD, 0xEF, 0xDF, 0xDD, 0xCB, 0xA9, 0x88, 0x88, 0x88, 0x99,
    0xAC, 0xCD, 0xFD, 0xDE, 0xCB, 0xA9, 0x87, 0x76, 0x77, 0x78, 0x9A, 0xBC,
    0xDF, 0xED, 0xEC, 0xA9, 0x87, 0x66, 0x55, 0x67, 0x78, 0x9B, 0xBE, 0xFF,
    0xDD, 0xCA, 0x98, 0x76, 0x54, 0x45, 0x67, 0x89, 0xAC, 0xDF, 0xFD, 0xCB,
    0xA9, 0x86, 0x54, 0x34, 0x45, 0x78, 0x9A, 0xBD, 0xEF, 0xDC, 0xBA, 0x98,
    0x65, 0x43, 0x34, 0x56, 0x89, 0xAC, 0xDE, 0xFC, 0xDB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x78, 0x9A, 0xBD, 0xDF, 0xDD, 0xBB, 0xA8, 0x77, 0x65, 0x55,
    0x67, 0x8A, 0xAC, 0xDF, 0xFC, 0xDC, 0xBA, 0x98, 0x77, 0x76, 0x77, 0x89,
    0xAB, 0xCE, 0xEF, 0xCD, 0xCB, 0xAA, 0x98, 0x88, 0x88, 0x89, 0xAB, 0xCD,
    0xDF, 0xFD, 0xED, 0xCB, 0xBA, 0xA9, 0x99, 0x9A, 0xAA, 0xCD, 0xFF, 0xFF,
    0xDE, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDE, 0xFF, 0xFD, 0xFD,
    0xDD, 0xCC, 0xCB, 0xBB, 0xCC, 0xDD, 0xFE, 0xFF, 0xFF, 0xCE, 0xED, 0xED,
    0xDC, 0xCC, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xEF, 0xEF,
    0xEF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xDD, 0xDE, 0xEF, 0xDF, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xAF, 0xFF,
    0xED, 0xDC, 0xCC, 0xBB, 0xBC, 0xCC, 0xCD, 0xDE, 0xED, 0xFF, 0xED, 0xCC,
    0xBB, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDE, 0xEF, 0xFD, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xCD, 0xDD, 0xEE, 0xDB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xCD, 0xDD, 0xDC, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xDD, 0xDC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDC, 0xCB, 0x98, 0x76, 0x65, 0x55, 0x66, 0x77, 0x89, 0xAC, 0xCD,
    0xCC, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xCC, 0xA9, 0x87, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9B, 0xCD, 0xEC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xEE, 0xCC, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x78, 0x99, 0xAC,
    0xDE, 0xFC, 0xCC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x9A, 0xAB, 0xCE, 0xFF,
    0xDD, 0xCC, 0xBA, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCD, 0xEF, 0xFD, 0xED,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xEF, 0xFF, 0xDE, 0xED, 0xDC,
    0xCB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFD, 0xFE, 0xED, 0xDD, 0xDC,
    0xDD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xAD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xEE, 0xEF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xDD, 0xDD, 0xDD, 0xDC, 0xCC, 0x8F, 0xFF,
    0xFF, 0xFF, 0xDD, 0xDE, 0xED, 0xDD, 0xDD, 0xFF, 0xFD, 0xFF, 0xFF, 0xFD,
    0xCC, 0xCC, 0xCC, 0xCB, 0xCD, 0xDE, 0xEF, 0xDF, 0xFF, 0xEC, 0xDB, 0xBB,
    0xAA, 0xAB, 0xBB, 0xCC, 0xDF, 0xFD, 0xFF, 0xFD, 0xCB, 0xA9, 0x99, 0x99,
    0xAA, 0xBC, 0xDD, 0xEF, 0xDF, 0xED, 0xCB, 0xA9, 0x88, 0x88, 0x88, 0x9A,
    0xBC, 0xCC, 0xFD, 0xFE, 0xDB, 0xA9, 0x87, 0x76, 0x77, 0x78, 0x9A, 0xBC,
    0xDE, 0xDF, 0xFC, 0xBA, 0x87, 0x66, 0x55, 0x67, 0x78, 0x9B, 0xBD, 0xFE,
    0xEF, 0xCA, 0x98, 0x76, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCE, 0xED, 0xDC,
    0xA9, 0x86, 0x54, 0x33, 0x45, 0x68, 0x9A, 0xBC, 0xED, 0xED, 0xBA, 0x98,
    0x75, 0x43, 0x34, 0x57, 0x89, 0xAC, 0xDD, 0xED, 0xDC, 0xA9, 0x87, 0x65,
    0x44, 0x56, 0x78, 0x9A, 0xBD, 0xFF, 0xFF, 0xCB, 0xA9, 0x87, 0x65, 0x56,
    0x67, 0x89, 0xBC, 0xDF, 0xED, 0xDC, 0xBA, 0x98, 0x87, 0x76, 0x77, 0x89,
    0xAB, 0xCE, 0xFF, 0xCE, 0xCB, 0xBA, 0x99, 0x88, 0x88, 0x89, 0xAB, 0xDD,
    0xFF, 0xFF, 0xFD, 0xCB, 0xBA, 0xA9, 0x99, 0x9A, 0xAB, 0xCD, 0xDF, 0xFF,
    0xDF, 0xEE, 0xCC, 0xBA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDF, 0xFF, 0xFE, 0xFD,
    0xDD, 0xCC, 0xBB, 0xCC, 0xCC, 0xCD, 0xFF, 0xFF, 0xFF, 0xDD, 0xDE, 0xDD,
    0xDC, 0xCD, 0xCC, 0xDD, 0xEF, 0xFF, 0xFF, 0xFC, 0xFF, 0xED, 0xDD, 0xDD,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0xCD, 0xCD, 0xDD, 0xEE, 0xDE,
    0xFE, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDF, 0x8F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xCF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0xBB, 0xBC, 0xCD,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCA, 0x99, 0x99, 0xAB, 0xCF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xCA, 0x97, 0x77, 0x89, 0xBC, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDC, 0x97, 0x54, 0x46, 0x8A, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFD, 0xB9, 0x74, 0x12, 0x57, 0x9B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB,
    0x97, 0x42, 0x24, 0x79, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xB9, 0x86,
    0x44, 0x57, 0x9B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xA9, 0x87, 0x77,
    0x8A, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xAA, 0x99, 0x9A, 0xCF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xCC, 0xBB, 0xBB, 0xCF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFD, 0xDC, 0xDD, 0xCD, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
    0xCC, 0xCF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xBB, 0xBC,
    0xCF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCC, 0xBA, 0xA9, 0xAA, 0xBC,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xA9, 0x88, 0x88, 0x9A, 0xBD, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFB, 0xB9, 0x87, 0x66, 0x78, 0x9A, 0xCD, 0xFF, 0xFF,
    0xFF, 0xFD, 0xCA, 0x87, 0x54, 0x45, 0x78, 0xAB, 0xDF, 0xFF, 0xFF, 0xFF,
    0xDB, 0xA8, 0x64, 0x22, 0x46, 0x8A, 0xBD, 0xFF, 0xFF, 0xFF, 0xFC, 0xBA,
    0x86, 0x42, 0x24, 0x68, 0xAB, 0xCD, 0xFF, 0xFF, 0xFF, 0xDB, 0xA8, 0x75,
    0x44, 0x56, 0x8A, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xCA, 0x98, 0x76, 0x66,
    0x79, 0xAC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBA, 0x98, 0x88, 0x89, 0xAB,
    0xCF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFC, 0xBA, 0xAA, 0x9A, 0xAC, 0xCC, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xCB, 0xBB, 0xCC, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDD, 0xDF, 0xDC, 0xCC, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xCF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7D, 0xDC, 0xDC, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xCB, 0xCC, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xA9, 0x9A, 0xBC, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0x98, 0x77, 0x89, 0xBF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFC, 0xA8, 0x54, 0x46, 0x8A, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xCA, 0x74, 0x12, 0x47, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
    0xA7, 0x42, 0x24, 0x7A, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCA, 0x86,
    0x44, 0x58, 0xAC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBA, 0x87, 0x78,
    0x9B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBA, 0x99, 0xAB, 0xCF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xCC, 0xCC, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xCC, 0xCB, 0xBA, 0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xAB, 0xBC, 0x9C, 0xCC,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDC, 0xCC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBB, 0xBB, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xBB, 0xCB, 0xBB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0xAA, 0xBB, 0xBA, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAB, 0xBB, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x99,
    0xAB, 0xBA, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x56, 0x66, 0x77, 0x89, 0xAB, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAB, 0xBA, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBB, 0xAA, 0xA9, 0x88, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xBB, 0xBA, 0xBA, 0x99, 0x88, 0x87, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xCC,
    0xBB, 0xBA, 0x99, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xBC, 0xCB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xCC, 0xBC, 0xCB, 0xBA,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDC, 0xDC, 0xCB, 0xBB, 0xBB,
    0xBA, 0xBB, 0xBB, 0xCC, 0xDD, 0xEE, 0x9C, 0xCB, 0xBB, 0xBA, 0xAA, 0xAA,
    0xBB, 0xBB, 0xCC, 0xDD, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFF, 0xED, 0xEE, 0xED, 0xDD, 0xDC, 0xCD, 0xDC, 0x7F, 0xFF,
    0xFF, 0xFE, 0xED, 0xDD, 0xDD, 0xFD, 0xFF, 0xEE, 0xFD, 0xFF, 0xFF, 0xDE,
    0xDD, 0xCC, 0xCC, 0xDD, 0xDD, 0xFF, 0xFF, 0xEF, 0xFF, 0xDD, 0xDC, 0xCC,
    0xBB, 0xCC, 0xBD, 0xDD, 0xEF, 0xFE, 0xFF, 0xFD, 0xDC, 0xBB, 0xAA, 0xAA,
    0xBB, 0xCD, 0xDE, 0xEF, 0xDF, 0xFE, 0xDC, 0xBA, 0x99, 0x99, 0x99, 0xAB,
    0xCC, 0xDE, 0xFD, 0xFD, 0xEC, 0xCA, 0x98, 0x87, 0x78, 0x89, 0xAB, 0xCD,
    0xFF, 0xDE, 0xFD, 0xCA, 0x98, 0x76, 0x66, 0x78, 0x9A, 0xBC, 0xDD, 0xFE,
    0xDD, 0xCB, 0xA9, 0x86, 0x54, 0x45, 0x78, 0x9A, 0xCE, 0xDF, 0xEE, 0xDC,
    0xBA, 0x97, 0x64, 0x23, 0x46, 0x79, 0xAB, 0xDD, 0xFD, 0xEE, 0xDB, 0xA9,
    0x76, 0x42, 0x24, 0x67, 0x9A, 0xBC, 0xDE, 0xEF, 0xEE, 0xCA, 0x98, 0x75,
    0x44, 0x56, 0x89, 0xAB, 0xDE, 0xFE, 0xEE, 0xDC, 0xBA, 0x88, 0x76, 0x66,
    0x78, 0x9B, 0xCD, 0xEF, 0xDD, 0xFD, 0xCB, 0xA9, 0x98, 0x77, 0x88, 0x9A,
    0xBC, 0xDF, 0xFF, 0xDF, 0xDD, 0xCB, 0xA9, 0x99, 0x99, 0x9A, 0xBC, 0xDE,
    0xFF, 0xFD, 0xEE, 0xDD, 0xCB, 0xAA, 0xAA, 0xAB, 0xCC, 0xDE, 0xFF, 0xFF,
    0xDF, 0xFD, 0xDC, 0xCC, 0xBC, 0xCB, 0xCC, 0xCE, 0xFF, 0xFF, 0xFD, 0xEF,
    0xFE, 0xDD, 0xDC, 0xCD, 0xCD, 0xDD, 0xFF, 0xFF, 0xFF, 0xCF, 0xEE, 0xDD,
    0xEE, 0xDE, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xDF, 0xFF,
    0xFE, 0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0x7C, 0xCD, 0xCC, 0xDD, 0xEE, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xCF, 0xDF, 0xDC, 0xCB, 0xCD, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD,
    0xCC, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xCC, 0xBC,
    0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBB, 0xAA, 0xBB, 0xBC,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xA9, 0x98, 0x89, 0xAB, 0xCD, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xBA, 0x87, 0x66, 0x78, 0xAB, 0xCF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xCB, 0x97, 0x54, 0x45, 0x79, 0xBC, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFC, 0xB9, 0x64, 0x22, 0x46, 0x9A, 0xCF, 0xFF, 0xFF, 0xFF, 0xFD, 0xBA,
    0x86, 0x42, 0x23, 0x68, 0xAC, 0xDF, 0xFF, 0xFF, 0xFF, 0xDC, 0xA9, 0x75,
    0x44, 0x57, 0x9B, 0xCF, 0xDF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA8, 0x76, 0x67,
    0x8A, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xA9, 0x88, 0x9A, 0xBC,
    0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xCB, 0xBB, 0xAB, 0xBC, 0xCF, 0xFF,
    0xFF, 0xFD, 0xFF, 0xFD, 0xDF, 0xCC, 0xCC, 0xCD, 0xDD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7D, 0xDD, 0xDF, 0xFD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFD, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCD, 0xDD,
    0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDC, 0xBB, 0xBB, 0xCF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xCB, 0xA9, 0xAA, 0xBC, 0xDD, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0x97, 0x77, 0x89, 0xAC, 0xDF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFC, 0xA8, 0x64, 0x46, 0x8A, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xB9, 0x74, 0x12, 0x47, 0x9B, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB,
    0x97, 0x42, 0x24, 0x79, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xBA, 0x86,
    0x44, 0x58, 0x9C, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDB, 0xA9, 0x87, 0x78,
    0x9A, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBC, 0xBA, 0x99, 0xAB, 0xBD,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xCC, 0xBB, 0xBC, 0xCE, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xDC, 0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xED, 0xCC, 0xED, 0xBB, 0xCB, 0xBB, 0xCC, 0xBC, 0xCC, 0x6D, 0xFF,
    0xED, 0xDC, 0xCC, 0xBD, 0xCC, 0xDC, 0xEE, 0xFF, 0xFC, 0xED, 0xDF, 0xCD,
    0xCC, 0xCB, 0xCC, 0xCD, 0xCD, 0xDE, 0xFF, 0xCF, 0xED, 0xEC, 0xCB, 0xBA,
    0xBB, 0xBB, 0xCC, 0xCC, 0xDD, 0xFC, 0xDD, 0xDC, 0xBA, 0xBA, 0xA9, 0x9A,
    0xAA, 0xBB, 0xCD, 0xEF, 0xDC, 0xDC, 0xCB, 0xA9, 0x98, 0x88, 0x99, 0x9B,
    0xBC, 0xCD, 0xFD, 0xBC, 0xCB, 0xAA, 0x98, 0x77, 0x77, 0x89, 0xAA, 0xBD,
    0xCD, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x56, 0x67, 0x89, 0xAB, 0xCC, 0xDC,
    0xBC, 0xBB, 0xA8, 0x76, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xCE, 0xDC, 0xDB,
    0xB9, 0x87, 0x64, 0x23, 0x46, 0x78, 0xAB, 0xBC, 0xEC, 0xCC, 0xBA, 0x98,
    0x76, 0x43, 0x34, 0x57, 0x89, 0xBB, 0xCD, 0xDB, 0xCB, 0xBA, 0x97, 0x65,
    0x44, 0x56, 0x78, 0x9B, 0xBD, 0xDD, 0xCD, 0xCB, 0xA9, 0x87, 0x66, 0x56,
    0x78, 0x9A, 0xBB, 0xDF, 0xEB, 0xDC, 0xBA, 0xA9, 0x87, 0x77, 0x78, 0x8A,
    0xBB, 0xCD, 0xFD, 0xCC, 0xDB, 0xBB, 0x99, 0x98, 0x88, 0x9A, 0xAA, 0xBC,
    0xDF, 0xDC, 0xDD, 0xBC, 0xBB, 0xAA, 0x99, 0xAA, 0xAB, 0xBC, 0xCE, 0xFE,
    0xDF, 0xFD, 0xCC, 0xBB, 0xAA, 0xBB, 0xBB, 0xCC, 0xDC, 0xFF, 0xEC, 0xFF,
    0xDC, 0xDC, 0xCC, 0xBB, 0xBC, 0xCD, 0xED, 0xED, 0xFE, 0xDE, 0xEE, 0xED,
    0xCD, 0xCC, 0xCC, 0xDD, 0xDD, 0xEF, 0xEF, 0xEC, 0xEF, 0xFE, 0xED, 0xED,
    0xDE, 0xED, 0xEE, 0xFE, 0xFF, 0xFF, 0x6C, 0xCC, 0xDD, 0xDD, 0xDD, 0xBC,
    0xCC, 0xED, 0xDD, 0xEF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xDD, 0xDD, 0xDE, 0xEF, 0xFF, 0xCF, 0xFF,
    0xFF, 0xDD, 0xDC, 0xCC, 0xCD, 0xDE, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC,
    0xCB, 0xBA, 0xAA, 0xBB, 0xCC, 0xDF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0xA9,
    0x99, 0x9A, 0xAA, 0xBC, 0xEF, 0xFF, 0xFD, 0xDC, 0xBA, 0x98, 0x88, 0x88,
    0x99, 0xAA, 0xBC, 0xDF, 0xFF, 0xDD, 0xBA, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAB, 0xBC, 0xFF, 0xFD, 0xCA, 0x98, 0x76, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xED, 0xDB, 0xA8, 0x76, 0x65, 0x55, 0x56, 0x78, 0x89, 0xBC, 0xDF,
    0xDC, 0xB9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9B, 0xCD, 0xED, 0xCA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAC, 0xEF, 0xDC, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xCD, 0xFD, 0xDA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xDF, 0xDC, 0xB9, 0x87, 0x76, 0x55, 0x55,
    0x66, 0x78, 0xAB, 0xDF, 0xFD, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBE, 0xEF, 0xDE, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x9A, 0xBC,
    0xDF, 0xFE, 0xDC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x9A, 0xBC, 0xFE, 0xFF,
    0xFE, 0xDC, 0xBA, 0xA9, 0x99, 0x99, 0xAA, 0xBC, 0xDF, 0xFF, 0xFF, 0xFD,
    0xDC, 0xBB, 0xBB, 0xAA, 0xBB, 0xBC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE,
    0xDC, 0xCC, 0xCD, 0xCE, 0xEF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xDF, 0xDD,
    0xED, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xFE, 0xFF, 0xFD, 0xEC, 0xDD, 0xCC, 0xCC, 0xCC, 0xDD, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFD, 0xDD, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD,
    0xED, 0xCC, 0xCD, 0xFF, 0xED, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xDD, 0xCC,
    0xCC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFD, 0xCC, 0xCB, 0xBB,
    0xBD, 0xFD, 0xEF, 0xFF, 0xDF, 0xEE, 0xFD, 0xCB, 0xBA, 0xA9, 0xAB, 0xBC,
    0xDD, 0xDF, 0xFF, 0xFF, 0xDC, 0xCB, 0xA9, 0x88, 0x88, 0x9A, 0xBC, 0xDF,
    0xFF, 0xFF, 0xFE, 0xDC, 0xA9, 0x87, 0x66, 0x78, 0x9B, 0xCC, 0xDD, 0xFE,
    0xED, 0xDC, 0xBA, 0x97, 0x54, 0x45, 0x79, 0xAB, 0xDD, 0xFF, 0xFD, 0xDD,
    0xCB, 0xA8, 0x64, 0x22, 0x46, 0x8A, 0xBC, 0xDF, 0xFE, 0xDD, 0xDC, 0xBA,
    0x86, 0x42, 0x24, 0x68, 0xAB, 0xCD, 0xFF, 0xED, 0xDD, 0xCB, 0xA9, 0x75,
    0x44, 0x57, 0x8A, 0xBD, 0xDF, 0xFF, 0xDF, 0xDD, 0xCB, 0x98, 0x76, 0x67,
    0x89, 0xBC, 0xCD, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0x98, 0x88, 0x89, 0xAB,
    0xCD, 0xDE, 0xFE, 0xDF, 0xFD, 0xED, 0xBB, 0xA9, 0xAA, 0xBC, 0xCD, 0xDF,
    0xFF, 0xEF, 0xFF, 0xFF, 0xDC, 0xCA, 0xBB, 0xBC, 0xCD, 0xDF, 0xFF, 0xFF,
    0xDF, 0xFF, 0xDC, 0xDD, 0xCC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFF, 0xFD, 0xFF,
    0xFF, 0xEF, 0xDD, 0xDC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
    0xDF, 0xDD, 0xFD, 0xFD, 0xFF, 0xFF, 0xFF, 0xFD, 0xED, 0xFF, 0xFE, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6C, 0xDD, 0xDC, 0xCC, 0xFD, 0xFD,
    0xDD, 0xDF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xDF, 0xFD, 0xCD, 0xDC, 0xFD, 0xDD, 0xDD, 0x8F, 0xFF,
    0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xCD, 0xFF, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCC,
    0xCC, 0xCD, 0xDE, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xCB, 0xBB, 0xCB,
    0xCC, 0xCF, 0xFD, 0xFF, 0xFF, 0xFD, 0xFD, 0xCB, 0xAA, 0xA9, 0xAA, 0xBC,
    0xCD, 0xFF, 0xFF, 0xFF, 0xDF, 0xBB, 0xA9, 0x88, 0x88, 0x9A, 0xBC, 0xDF,
    0xFF, 0xFF, 0xFF, 0xDC, 0xA9, 0x87, 0x66, 0x78, 0x9A, 0xCC, 0xFF, 0xFD,
    0xFF, 0xDC, 0xBA, 0x87, 0x54, 0x45, 0x79, 0xAB, 0xDC, 0xDF, 0xFF, 0xFD,
    0xCA, 0x98, 0x64, 0x22, 0x46, 0x8A, 0xBD, 0xFF, 0xFF, 0xDF, 0xDC, 0xB9,
    0x86, 0x42, 0x24, 0x68, 0x9C, 0xCF, 0xDF, 0xFF, 0xFF, 0xCB, 0xA9, 0x75,
    0x44, 0x56, 0x8A, 0xBD, 0xFF, 0xFF, 0xFF, 0xDD, 0xBB, 0x98, 0x76, 0x66,
    0x79, 0xAB, 0xDF, 0xFF, 0xFF, 0xFF, 0xCC, 0xBA, 0x99, 0x88, 0x89, 0xAB,
    0xDD, 0xFF, 0xFF, 0xEF, 0xFF, 0xCC, 0xBA, 0xAA, 0xAA, 0xAB, 0xCD, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBB, 0xBB, 0xBC, 0xCD, 0xFF, 0xFF, 0xFF,
    0xDF, 0xFF, 0xDD, 0xDC, 0xDD, 0xCD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFD, 0xFF, 0xDD, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF,
    0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7D, 0xDD, 0xDF, 0xFD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xBC, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0xA9, 0x9A, 0xBF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x98, 0x77, 0x89, 0xAF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFB, 0xA8, 0x64, 0x46, 0x8A, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xB9, 0x74, 0x12, 0x47, 0x9A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
    0x97, 0x42, 0x24, 0x79, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0x86,
    0x44, 0x57, 0x9B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0x87, 0x78,
    0x9B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x99, 0xAA, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFB, 0xBB, 0xEF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCD, 0xCC, 0xCF, 0xBB, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE,
    0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBC, 0xBC,
    0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBA, 0x99, 0xAA, 0xBC,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0x98, 0x88, 0xAA, 0xBF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xCD, 0xB9, 0x87, 0x66, 0x78, 0x9A, 0xCF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xCA, 0x87, 0x54, 0x45, 0x79, 0xAB, 0xDF, 0xFF, 0xFF, 0xFD,
    0xFB, 0xA8, 0x64, 0x22, 0x46, 0x8A, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9,
    0x86, 0x42, 0x24, 0x68, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xA8, 0x75,
    0x44, 0x56, 0x9B, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF, 0xCA, 0x98, 0x76, 0x66,
    0x89, 0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0x98, 0x88, 0x89, 0xBB,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFB, 0xCB, 0xAA, 0xAA, 0xBC, 0xDF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xCC, 0xAB, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFC, 0xCD, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6C, 0xBC, 0xCF, 0xFF, 0xCD, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xDC, 0xDB, 0xBA, 0xAA, 0xA9, 0xAA, 0xA9, 0xAB, 0xBB, 0xCC, 0xAF, 0xFD,
    0xBB, 0xBA, 0xA9, 0xAA, 0x9A, 0xAB, 0xBB, 0xCD, 0xDC, 0xCB, 0xBB, 0xAA,
    0x99, 0x99, 0x89, 0x9A, 0xAA, 0xBB, 0xCC, 0xCC, 0xBB, 0xAA, 0x99, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xAB, 0xCB, 0xBB, 0xB9, 0x88, 0x87, 0x77, 0x77,
    0x88, 0x89, 0xAA, 0xBB, 0xCA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAB, 0xCA, 0xAA, 0x98, 0x87, 0x66, 0x66, 0x66, 0x67, 0x78, 0x9A,
    0xAB, 0xBB, 0xAA, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x9A, 0xBB,
    0xAA, 0x98, 0x77, 0x66, 0x55, 0x56, 0x66, 0x77, 0x89, 0x9B, 0xAA, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x66, 0x78, 0x99, 0xAB, 0xAA, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9C, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x9A, 0xBB, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0x9A, 0xBA, 0xA9, 0x98, 0x87, 0x76, 0x66, 0x67, 0x77,
    0x88, 0x9B, 0xBC, 0xAA, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xCA, 0xAA, 0x99, 0x88, 0x87, 0x77, 0x77, 0x89, 0x99, 0xAB, 0xDD,
    0xCB, 0xCB, 0xA9, 0x89, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xCB, 0xDC,
    0xBA, 0xA9, 0x99, 0x98, 0x99, 0x9A, 0xBA, 0xBC, 0xDC, 0xEC, 0xCC, 0xAB,
    0xBA, 0x9A, 0x9A, 0xAA, 0xAB, 0xBC, 0xEF, 0xEC, 0xEC, 0xCB, 0xBB, 0xBB,
    0xBA, 0xBB, 0xBB, 0xCC, 0xDC, 0xEE, 0xAC, 0xBC, 0xCB, 0xBA, 0xCA, 0xBA,
    0xBC, 0xBB, 0xDD, 0xDD, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xBF, 0xDF, 0xCC, 0xED, 0xBA, 0xBC, 0xCB, 0xBB, 0xBB, 0xCF, 0x6F, 0xFF,
    0xDC, 0xFF, 0xEF, 0xED, 0xFD, 0xFF, 0xFF, 0xFF, 0xFD, 0xDF, 0xFF, 0xFD,
    0xFF, 0xDC, 0xDF, 0xFD, 0xFD, 0xFD, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xDC,
    0xBB, 0xCB, 0xFC, 0xFF, 0xFF, 0xFC, 0xCF, 0xFC, 0xFF, 0xCB, 0xBB, 0xAB,
    0xCC, 0xBF, 0xFD, 0xFF, 0xFF, 0xFF, 0xCB, 0xBB, 0xA9, 0xA9, 0xAC, 0xBE,
    0xEE, 0xFE, 0xED, 0xCF, 0xFF, 0xDA, 0xA9, 0x88, 0x88, 0xAA, 0xCD, 0xCD,
    0xFF, 0xDC, 0xFF, 0xFB, 0xA9, 0x86, 0x66, 0x78, 0xAB, 0xCC, 0xFD, 0xFC,
    0xCF, 0xDD, 0xDA, 0x86, 0x54, 0x46, 0x79, 0xAD, 0xCF, 0xFF, 0xCC, 0xFF,
    0xCB, 0xA9, 0x64, 0x22, 0x47, 0x8A, 0xCB, 0xFF, 0xFF, 0xCF, 0xFD, 0xB9,
    0x86, 0x42, 0x24, 0x68, 0x9B, 0xCE, 0xFD, 0xCC, 0xFD, 0xBB, 0xA9, 0x76,
    0x44, 0x57, 0x8A, 0xBC, 0xEE, 0xDE, 0xED, 0xFF, 0xDB, 0xA8, 0x76, 0x66,
    0x78, 0xAC, 0xCD, 0xDF, 0xFD, 0xFF, 0xFB, 0xCB, 0xA9, 0x88, 0x89, 0x9B,
    0xCF, 0xCF, 0xFF, 0xDF, 0xFC, 0xDF, 0xCA, 0xA9, 0xAA, 0xAA, 0xCF, 0xDD,
    0xFF, 0xFC, 0xFF, 0xFD, 0xCC, 0xCC, 0xBB, 0xAB, 0xCC, 0xCF, 0xFF, 0xFC,
    0xCF, 0xDD, 0xFC, 0xFF, 0xCB, 0xCD, 0xFF, 0xDF, 0xFF, 0xFF, 0xFC, 0xFF,
    0xDF, 0xDF, 0xCF, 0xFC, 0xCF, 0xFF, 0xFF, 0xDF, 0xFD, 0xCF, 0xFF, 0xCF,
    0xFF, 0xFC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xFF, 0xFF, 0xFF, 0xCF,
    0xFD, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x6D, 0xCC, 0xCD, 0xBD, 0xDC, 0xFD,
    0xCD, 0xCF, 0xFF, 0xFF, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
    0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xCB, 0xCC,
    0xCC, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBC, 0xBA, 0xA9, 0xAA, 0xCF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xA9, 0x88, 0x88, 0x9A, 0xBF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFB, 0xB9, 0x86, 0x66, 0x78, 0x9A, 0xCF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xB9, 0x87, 0x54, 0x45, 0x78, 0xAC, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFB, 0xA8, 0x64, 0x22, 0x46, 0x8A, 0xBC, 0xFF, 0xFF, 0xFF, 0xFC, 0xCA,
    0x86, 0x42, 0x24, 0x68, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xA8, 0x75,
    0x44, 0x56, 0x8A, 0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0x98, 0x76, 0x66,
    0x89, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0x98, 0x88, 0x89, 0xAC,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xCB, 0xAA, 0xA9, 0xBB, 0xCF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBC, 0xBB, 0xCF, 0xEF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x9F, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0x9C, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0x47, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x94, 0x12, 0x58, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF8, 0x52, 0x14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
    0x54, 0x78, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0x87,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x99, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x98, 0x98, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xF9, 0x74, 0x57, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFA, 0x85, 0x12, 0x59, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF9, 0x52, 0x14, 0x89, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x97,
    0x54, 0x67, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x89,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF,
    0xFF, 0xFF, 0xF6, 0xF6, 0x6F, 0x68, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6,
    0x66, 0xF6, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF6, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x66, 0xF6, 0x6F,
    0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF, 0x6F, 0x66, 0x66, 0xFF, 0x6F, 0xF6,
    0xFF, 0xFF, 0x6F, 0xCF, 0xFF, 0x6F, 0xFF, 0xF6, 0x6F, 0x6F, 0xFF, 0x6F,
    0xFF, 0xF6, 0x56, 0xF6, 0xF6, 0x56, 0xFF, 0xFF, 0x66, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x65, 0x56, 0x6F, 0xFF, 0xF6, 0xFF, 0x6F, 0xFF, 0xFF,
    0xF6, 0x66, 0xF6, 0xFF, 0x66, 0x6F, 0xFF, 0x6F, 0xFF, 0x6F, 0xF6, 0xFF,
    0x66, 0x6F, 0x56, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x6F,
    0x46, 0xF5, 0x6F, 0x6F, 0xFF, 0xF5, 0x6B, 0xAF, 0xFF, 0x5F, 0xFF, 0xFF,
    0x6F, 0x6F, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xF6, 0x66, 0xF5, 0xFF,
    0x5F, 0xFF, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xF5, 0x55, 0xF6, 0xF6, 0xFF,
    0xFF, 0x6F, 0xFF, 0xFF, 0x6F, 0xF6, 0xFF, 0xF6, 0xF6, 0xFF, 0xFF, 0xFF,
    0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xF6, 0x6F, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xF6, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0x6F,
    0xF6, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0x6F, 0x6F,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0x9F, 0x4F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xF9,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x98, 0x98, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xF8, 0x67, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xF8, 0x97, 0x54, 0x47, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x8F, 0x74, 0x12, 0x57, 0x8F, 0xF9, 0xFF, 0xFF, 0x9F, 0xFF, 0x9F,
    0x98, 0x52, 0x24, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
    0x54, 0x58, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xF8,
    0x9F, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0x89, 0xFF,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xF9, 0x99, 0xFF, 0x9F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xBA, 0xFF, 0xFF, 0xBF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0x77, 0x9A, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xF8, 0x54, 0x45, 0x9A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFA, 0x84, 0x22, 0x47, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xA8, 0x42, 0x14, 0x7A, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x96,
    0x44, 0x59, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x97, 0x78,
    0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFA, 0xBF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xBF, 0xFB, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0x5F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x7F, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x76, 0xF7, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0x6F, 0x67, 0x6F, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xF7, 0x55, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xF7, 0x55, 0x44, 0x46, 0x7F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF7, 0xF5, 0x54, 0x44, 0x57, 0x66, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6,
    0x75, 0x44, 0x34, 0x46, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x55,
    0x45, 0x45, 0x56, 0xFF, 0xFF, 0xFF, 0xFD, 0xCF, 0x6F, 0x7F, 0x75, 0x57,
    0x56, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x76, 0x66, 0x7F,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x7F, 0xF7, 0x7F, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0x7F, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0x5F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA7, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFC, 0x44, 0x45, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x73, 0x22, 0x48, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF7, 0x42, 0x24, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x86,
    0x43, 0x4C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x77,
    0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xF9, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4F, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xF7, 0x7F, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x75, 0x67, 0x78, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xF9, 0x76, 0x43, 0x46, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xF6, 0x63, 0x23, 0x58, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xAF, 0x43, 0x23, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0x85,
    0x54, 0x45, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xF7, 0x55,
    0x68, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xBF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4F, 0xF8, 0xF8, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xBF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x87, 0x88, 0x9F, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x87, 0x66, 0x78, 0xAF, 0xBF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xBF, 0xA7, 0x54, 0x45, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xF7, 0x64, 0x22, 0x46, 0x89, 0xDF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF,
    0x76, 0x42, 0x24, 0x68, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x75,
    0x44, 0x57, 0xA9, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0x97, 0x76, 0x67,
    0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xBA, 0x98, 0x8A, 0xBB,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFA, 0xAF, 0xBF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x9F, 0xFF, 0xCF, 0x99, 0xFF, 0x3F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x78, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x64, 0x47, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFA, 0x84, 0x22, 0x48, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF7, 0x42, 0x14, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
    0x44, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x99, 0x88,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xEE, 0xEF, 0xFF, 0xFF, 0x3F, 0xFF,
    0xFE, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F,
    0xFF, 0xFF, 0xFF, 0xFE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x64, 0x56, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xF3, 0x12, 0x46, 0xFF, 0xFE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0x52, 0x24, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0x44, 0x6E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFE, 0xFE, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFD, 0x83, 0x47, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xF4, 0x12, 0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF7, 0x42, 0x24, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
    0x44, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x8F,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
 },
 {
  {
    0xBE, 0xDD, 0xEC, 0xDD, 0xDD, 0xDC, 0xDE, 0xEE, 0xFF, 0xFF, 0xCD, 0xFE,
    0xFD, 0xDD, 0xDC, 0xCD, 0xDD, 0xEE, 0xEF, 0xFF, 0xFF, 0xDE, 0xFD, 0xCC,
    0xCC, 0xBB, 0xBB, 0xCC, 0xCD, 0xFF, 0xFF, 0xFD, 0xED, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCD, 0xFF, 0xFF, 0xDF, 0xEC, 0xBB, 0xA9, 0x99, 0x99,
    0x99, 0xAB, 0xCD, 0xFF, 0xFD, 0xEC, 0xBB, 0xA9, 0x88, 0x77, 0x78, 0x89,
    0xAB, 0xCD, 0xFE, 0xED, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xFC, 0xDC, 0xA9, 0x87, 0x76, 0x65, 0x66, 0x67, 0x89, 0xBC, 0xDF,
    0xDC, 0xCA, 0x98, 0x76, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xDD, 0xDB,
    0xA9, 0x87, 0x65, 0x54, 0x55, 0x56, 0x79, 0xAC, 0xDD, 0xDC, 0xBA, 0x97,
    0x65, 0x54, 0x44, 0x55, 0x67, 0x8A, 0xBD, 0xDE, 0xCB, 0xA9, 0x76, 0x65,
    0x54, 0x55, 0x66, 0x79, 0xAB, 0xCD, 0xED, 0xCA, 0x98, 0x76, 0x55, 0x55,
    0x56, 0x78, 0x9A, 0xBD, 0xDE, 0xDC, 0xB9, 0x87, 0x66, 0x65, 0x66, 0x77,
    0x89, 0xAC, 0xDC, 0xEF, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDF, 0xFE, 0xCB, 0xA9, 0x88, 0x77, 0x78, 0x89, 0xAB, 0xCC, 0xED,
    0xFF, 0xED, 0xCB, 0xA9, 0x99, 0x99, 0x99, 0xAB, 0xBC, 0xDF, 0xDF, 0xFF,
    0xED, 0xCC, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFD, 0xFF, 0xFF, 0xFE,
    0xDC, 0xCB, 0xBB, 0xBC, 0xCC, 0xEE, 0xEF, 0xEF, 0xFF, 0xFF, 0xFE, 0xEE,
    0xCC, 0xDD, 0xDD, 0xDF, 0xEF, 0xFF, 0xDF, 0xFF, 0xFE, 0xFF, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDE, 0xDE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAD, 0xCB, 0xBB, 0xBC, 0xCB, 0xFC, 0xDB, 0xCD, 0xFF, 0xFF, 0xCF, 0xFF,
    0xBD, 0xCC, 0xDC, 0xDB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xCC, 0xDC,
    0xBB, 0xAB, 0xBA, 0xBC, 0xCD, 0xDD, 0xDD, 0xFB, 0xDD, 0xFB, 0xAB, 0xAA,
    0x9A, 0xAA, 0xAA, 0xBC, 0xFF, 0xFF, 0xCF, 0xFC, 0xCB, 0xBA, 0x99, 0x99,
    0x99, 0xAB, 0xBC, 0xCF, 0xFB, 0xDB, 0xBA, 0xA9, 0x98, 0x87, 0x78, 0x88,
    0xAA, 0xBC, 0xDF, 0xCF, 0xFB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x89, 0xAA,
    0xBF, 0xCF, 0xCC, 0xA9, 0x98, 0x76, 0x65, 0x56, 0x67, 0x89, 0xAB, 0xFC,
    0xCB, 0xDA, 0xA8, 0x76, 0x65, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xFB,
    0xA9, 0x87, 0x65, 0x44, 0x45, 0x56, 0x79, 0x9B, 0xCC, 0xBF, 0xBA, 0x97,
    0x75, 0x54, 0x44, 0x56, 0x68, 0x9A, 0xBE, 0xFB, 0xDB, 0xA9, 0x86, 0x65,
    0x44, 0x45, 0x67, 0x89, 0xAA, 0xCC, 0xDF, 0xBB, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xAC, 0xDC, 0xFC, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x8A, 0xAB, 0xBB, 0xFC, 0xBC, 0xB9, 0x87, 0x76, 0x77, 0x77, 0x89, 0xAB,
    0xDC, 0xBC, 0xFC, 0xBB, 0xA9, 0x98, 0x88, 0x88, 0x99, 0x9A, 0xCB, 0xCB,
    0xFF, 0xFC, 0xCA, 0xAA, 0x99, 0x99, 0xA9, 0x9B, 0xBC, 0xCD, 0xDF, 0xFF,
    0xCF, 0xBB, 0xBA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCF, 0xDD, 0xFF, 0xFF, 0xFD,
    0xCC, 0xCB, 0xBB, 0xCC, 0xBB, 0xDB, 0xFF, 0xCF, 0xFF, 0xFF, 0xDD, 0xFD,
    0xBF, 0xDC, 0xCB, 0xBF, 0xDF, 0xFC, 0xFF, 0xFF, 0xFE, 0xED, 0xFF, 0xCB,
    0xBC, 0xDC, 0xBC, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xDF, 0xDD, 0xDD, 0xDC, 0xDD, 0xDD, 0xDE, 0xFF, 0xFF, 0xDF, 0xFF,
    0xFE, 0xDD, 0xDC, 0xCC, 0xCD, 0xDE, 0xEF, 0xFF, 0xFF, 0xEF, 0xFD, 0xDC,
    0xBB, 0xBB, 0xBB, 0xBB, 0xCD, 0xDF, 0xFF, 0xFD, 0xFE, 0xDC, 0xBB, 0xAA,
    0x9A, 0xAA, 0xAB, 0xCD, 0xEF, 0xFF, 0xDF, 0xDC, 0xBA, 0xA9, 0x98, 0x88,
    0x89, 0xAA, 0xBD, 0xDF, 0xFD, 0xEC, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xEF, 0xDD, 0xCB, 0x99, 0x87, 0x76, 0x66, 0x67, 0x88, 0xAB,
    0xCD, 0xFD, 0xDB, 0xA9, 0x87, 0x66, 0x65, 0x56, 0x67, 0x89, 0xAB, 0xED,
    0xDC, 0xBA, 0x98, 0x76, 0x55, 0x55, 0x56, 0x77, 0x8A, 0xBD, 0xDD, 0xCB,
    0xA8, 0x76, 0x65, 0x55, 0x55, 0x66, 0x78, 0xAB, 0xCD, 0xDC, 0xB9, 0x87,
    0x65, 0x55, 0x44, 0x55, 0x67, 0x89, 0xBD, 0xDD, 0xCB, 0xA8, 0x76, 0x65,
    0x55, 0x55, 0x66, 0x78, 0x9B, 0xCD, 0xDC, 0xBA, 0x98, 0x76, 0x55, 0x55,
    0x56, 0x78, 0x9A, 0xBC, 0xDE, 0xDB, 0xA9, 0x87, 0x66, 0x65, 0x66, 0x67,
    0x89, 0xAB, 0xDD, 0xED, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x77, 0x89, 0x9B,
    0xCC, 0xDE, 0xEC, 0xCB, 0xA9, 0x88, 0x77, 0x78, 0x89, 0x9A, 0xBC, 0xED,
    0xFF, 0xDD, 0xBA, 0xA9, 0x98, 0x88, 0x89, 0xAA, 0xBC, 0xDD, 0xDF, 0xFF,
    0xFD, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xED, 0xFF, 0xFE, 0xFD,
    0xCB, 0xBB, 0xBB, 0xBC, 0xBC, 0xDD, 0xEF, 0xEF, 0xFF, 0xFF, 0xFE, 0xDC,
    0xCC, 0xCC, 0xCC, 0xDE, 0xDF, 0xFE, 0xDF, 0xFF, 0xFF, 0xFE, 0xDD, 0xDC,
    0xCD, 0xDD, 0xDE, 0xDE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xEE, 0xEE, 0xEE, 0xDE, 0xEE, 0xEE, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xED, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0x4D, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xE3, 0xEE, 0xE4, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x5E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x3E, 0x4E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0x44, 0x44, 0x4D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0x44, 0x4D, 0xDD, 0xD4, 0x4D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD4, 0xD3,
    0x3D, 0x4D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xE4, 0xE4, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x4E, 0xEE, 0x44, 0xEE,
    0xE4, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE4, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0xED, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x4E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xED, 0xED, 0xED, 0xEE, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xAD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDC, 0xFD, 0xFF, 0xFF, 0xFF, 0xDD, 0xFF,
    0xDF, 0xDD, 0xCC, 0xCC, 0xCC, 0xDF, 0xFF, 0xFF, 0xFF, 0xEF, 0xDD, 0xDC,
    0xCC, 0xBB, 0xBB, 0xBC, 0xCC, 0xDF, 0xFF, 0xFE, 0xFD, 0xEC, 0xBB, 0xAA,
    0x9A, 0xAA, 0xAB, 0xCD, 0xDF, 0xFF, 0xCD, 0xCD, 0xBA, 0xA9, 0x98, 0x88,
    0x99, 0x9A, 0xCD, 0xDF, 0xFD, 0xDC, 0xBA, 0xA9, 0x88, 0x77, 0x78, 0x89,
    0x9A, 0xBD, 0xFF, 0xCC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x77, 0x89, 0x9A,
    0xDF, 0xFC, 0xDB, 0xB9, 0x87, 0x66, 0x65, 0x66, 0x67, 0x89, 0xAC, 0xDD,
    0xDD, 0xBA, 0x98, 0x76, 0x55, 0x55, 0x56, 0x78, 0x8A, 0xCD, 0xED, 0xCB,
    0xA8, 0x76, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9B, 0xDE, 0xDC, 0xBA, 0x87,
    0x65, 0x55, 0x45, 0x55, 0x67, 0x8A, 0xBD, 0xCD, 0xCB, 0xA8, 0x76, 0x55,
    0x54, 0x55, 0x56, 0x78, 0xAB, 0xCD, 0xED, 0xBA, 0x98, 0x76, 0x55, 0x55,
    0x56, 0x78, 0x9A, 0xBC, 0xCD, 0xFB, 0xA9, 0x87, 0x66, 0x65, 0x66, 0x67,
    0x89, 0xAB, 0xCD, 0xFF, 0xDB, 0xA8, 0x87, 0x76, 0x66, 0x77, 0x89, 0xAB,
    0xCC, 0xDF, 0xFD, 0xCA, 0x98, 0x88, 0x77, 0x77, 0x89, 0x9A, 0xBC, 0xED,
    0xFF, 0xFD, 0xCB, 0xA9, 0x98, 0x88, 0x99, 0xAA, 0xBC, 0xDD, 0xDF, 0xFF,
    0xDC, 0xCB, 0xAA, 0xAA, 0x9A, 0xAB, 0xBC, 0xCE, 0xED, 0xFF, 0xFF, 0xFD,
    0xCC, 0xBB, 0xBC, 0xBB, 0xCC, 0xDD, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xDC,
    0xCC, 0xCD, 0xDC, 0xDF, 0xFF, 0xEF, 0xDF, 0xFF, 0xFE, 0xFC, 0xEC, 0xCD,
    0xCC, 0xDD, 0xCD, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xCB, 0xBB, 0xBB, 0xBA, 0xAB, 0xBB, 0xCC, 0xCC, 0xEF, 0xBC, 0xDD,
    0xCC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCC, 0xEE, 0xFE, 0xCC, 0xCC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xCC, 0xDE, 0xEC, 0xCC, 0xBA, 0xAA, 0x99,
    0x98, 0x99, 0x9A, 0xAB, 0xBC, 0xDD, 0xBC, 0xBA, 0xA9, 0x98, 0x88, 0x88,
    0x88, 0x99, 0xAB, 0xBC, 0xDB, 0xBB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x78,
    0x99, 0xAB, 0xCC, 0xBB, 0xAA, 0x98, 0x77, 0x76, 0x66, 0x77, 0x78, 0x9A,
    0xAC, 0xCB, 0xBA, 0x98, 0x87, 0x66, 0x66, 0x66, 0x67, 0x78, 0x9A, 0xBB,
    0xBB, 0xA9, 0x87, 0x76, 0x65, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xBB, 0xBA,
    0x98, 0x76, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xAB, 0xBB, 0x99, 0x87,
    0x66, 0x55, 0x55, 0x56, 0x67, 0x89, 0xAA, 0xAB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x66, 0x78, 0x9A, 0xBB, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x66, 0x77, 0x89, 0xAB, 0xBB, 0xBA, 0x98, 0x87, 0x66, 0x66, 0x66, 0x67,
    0x88, 0x9A, 0xBB, 0xCC, 0xAA, 0x98, 0x77, 0x76, 0x66, 0x77, 0x78, 0x99,
    0xAB, 0xBC, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x88, 0x99, 0xAB, 0xBB,
    0xCC, 0xCB, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBD, 0xDD,
    0xBB, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xEE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xCF, 0xFE, 0xDD, 0xCC, 0xBB,
    0xBA, 0xBB, 0xBB, 0xBC, 0xCD, 0xDC, 0xCE, 0xDD, 0xDC, 0xCB, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDD, 0xBC, 0xDC,
    0xCC, 0xBB, 0xBA, 0xAA, 0xAA, 0xAB, 0xCB, 0xCD, 0xEE, 0xBD, 0xCC, 0xBB,
    0xAA, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xCD, 0xDB, 0xCC, 0xAA, 0xA9, 0x99,
    0x88, 0x89, 0x99, 0x9A, 0xBC, 0xDC, 0xBC, 0xBA, 0x99, 0x98, 0x88, 0x77,
    0x88, 0x89, 0x9A, 0xBC, 0xCB, 0xBA, 0xA9, 0x88, 0x87, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0xAB, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xBA, 0xAA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x9A, 0xBA,
    0xAA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x66, 0x67, 0x89, 0xAA, 0xAA, 0xA9,
    0x88, 0x76, 0x66, 0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xAA, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x67, 0x88, 0x9A, 0xAA, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xBA, 0x98, 0x87, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0xAB, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67,
    0x88, 0x9A, 0xAA, 0xBA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x78, 0x99,
    0xAB, 0xAB, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x78, 0x89, 0xAB, 0xBB,
    0xCC, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xBC, 0xBC, 0xCB,
    0xBA, 0x99, 0x99, 0x88, 0x89, 0x99, 0xAA, 0xBB, 0xCB, 0xDD, 0xDC, 0xBA,
    0xA9, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0xCD, 0xBE, 0xEE, 0xCC, 0xCB, 0xBA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDB, 0xCD, 0xEC, 0xBB, 0xBB, 0xBA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xBC, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xAA, 0xAA, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xBB, 0xCB,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDC, 0xBC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xCA, 0xBB, 0xAA, 0x99, 0x98,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB, 0xAB, 0xAA, 0x99, 0x88, 0x87, 0x77,
    0x88, 0x88, 0x9A, 0xAB, 0xBA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x77, 0x77, 0x89,
    0x9A, 0xAA, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x66, 0x67, 0x78, 0x89, 0xAA,
    0x9A, 0x98, 0x87, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0x99, 0xA9,
    0x88, 0x76, 0x66, 0x66, 0x66, 0x66, 0x77, 0x89, 0xA9, 0x9A, 0x98, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x67, 0x78, 0x9A, 0x99, 0xA9, 0x87, 0x76, 0x66,
    0x65, 0x66, 0x66, 0x77, 0x89, 0xA9, 0xAA, 0x98, 0x87, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0x9A, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x78, 0x99, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0x9A, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78, 0x89, 0x9A, 0xAA,
    0xBB, 0xAA, 0x99, 0x88, 0x87, 0x78, 0x88, 0x89, 0x9A, 0xAB, 0xAB, 0xCB,
    0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBA, 0xCD, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xBD, 0xDC, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCB, 0xCC, 0xCB, 0xBA, 0xAA, 0x99, 0x99,
    0x99, 0xAA, 0xAA, 0xBB, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDD, 0xCC, 0xCB,
    0xBC, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xAC, 0xCD, 0xDE, 0xBD, 0xCB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xCA, 0xBC, 0xBA, 0x99, 0x98,
    0x88, 0x89, 0x89, 0x9A, 0xBB, 0xCC, 0xAB, 0xAA, 0x99, 0x88, 0x87, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xCC, 0xAA, 0xA9, 0x88, 0x87, 0x76, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xBA, 0xB9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77, 0x78, 0x99, 0xAA,
    0xAA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xAA, 0xA9,
    0x87, 0x76, 0x66, 0x65, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xAA, 0x98, 0x87,
    0x66, 0x65, 0x55, 0x66, 0x67, 0x88, 0x9A, 0xAA, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0xAA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67,
    0x78, 0x9A, 0xBA, 0xAB, 0xA9, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x99,
    0xAA, 0xBB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78, 0x89, 0xAB, 0xBA,
    0xBB, 0xAA, 0x99, 0x88, 0x87, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBD, 0xBB,
    0xBA, 0xA9, 0x98, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xBB, 0xDD, 0xCB, 0xAB,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xBC, 0xBD, 0xDC, 0xBB, 0xBB, 0xAA,
    0xA9, 0xAA, 0xAA, 0xBB, 0xDC, 0xDC, 0xBE, 0xDC, 0xBB, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0x9C, 0xBB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xCB, 0xEC,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0xDD, 0xEE, 0xBD, 0xCB, 0xBA,
    0xAA, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCE, 0xDB, 0xCB, 0xBA, 0xA9, 0x99,
    0x88, 0x89, 0x99, 0xAA, 0xBC, 0xDC, 0xBC, 0xBA, 0xA9, 0x98, 0x88, 0x88,
    0x88, 0x99, 0xAA, 0xBC, 0xCB, 0xBB, 0xA9, 0x88, 0x87, 0x77, 0x77, 0x78,
    0x89, 0xAB, 0xBC, 0xAB, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x77, 0x78, 0x99,
    0xAB, 0xBA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x67, 0x78, 0x9A, 0xBB,
    0xAA, 0x99, 0x87, 0x76, 0x66, 0x55, 0x66, 0x67, 0x89, 0x9A, 0xAA, 0xA9,
    0x88, 0x76, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAA, 0xAA, 0x98, 0x87,
    0x66, 0x55, 0x55, 0x56, 0x67, 0x88, 0x9A, 0xAA, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x66, 0x78, 0x99, 0xAA, 0xAB, 0x99, 0x87, 0x76, 0x66, 0x56,
    0x66, 0x77, 0x89, 0x9A, 0xAB, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xAA, 0xBB, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x77, 0x78, 0x99,
    0xAB, 0xBB, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88, 0x99, 0xAA, 0xBB,
    0xCC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBC, 0xDC,
    0xBA, 0xA9, 0x99, 0x88, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xCD, 0xDC, 0xBB,
    0xAA, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0xCD, 0xBD, 0xED, 0xCC, 0xBB, 0xBB,
    0xAA, 0xAA, 0xAB, 0xBC, 0xCC, 0xDC, 0xBD, 0xDC, 0xCB, 0xBB, 0xAA, 0xAA,
    0xAA, 0xBB, 0xBB, 0xBC, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xED, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xFF, 0xFF, 0xEF, 0xBF, 0xFF,
    0xFD, 0xDD, 0xDD, 0xDD, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xED, 0xDC,
    0xCC, 0xCC, 0xCC, 0xDD, 0xFF, 0xFF, 0xFF, 0xFD, 0xFE, 0xDC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xCC, 0xEF, 0xFF, 0xFF, 0xDE, 0xDC, 0xBB, 0xAA, 0x99, 0x99,
    0xAA, 0xBC, 0xDF, 0xFF, 0xED, 0xEC, 0xCB, 0xA9, 0x98, 0x88, 0x88, 0x9A,
    0xBD, 0xEF, 0xFF, 0xDD, 0xCB, 0xA9, 0x88, 0x76, 0x67, 0x78, 0x9A, 0xCD,
    0xEF, 0xFD, 0xDC, 0xBA, 0x98, 0x76, 0x55, 0x56, 0x78, 0x9B, 0xCD, 0xEE,
    0xDE, 0xCB, 0x98, 0x76, 0x54, 0x44, 0x56, 0x79, 0xAC, 0xDE, 0xED, 0xDC,
    0xB9, 0x87, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xCD, 0xED, 0xDE, 0xCB, 0x98,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xDE, 0xDE, 0xFC, 0xB9, 0x87, 0x55,
    0x44, 0x45, 0x67, 0x9A, 0xBC, 0xED, 0xEE, 0xDB, 0xA8, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAB, 0xCE, 0xEF, 0xFD, 0xCA, 0x98, 0x76, 0x66, 0x67, 0x78,
    0x9B, 0xBD, 0xED, 0xFF, 0xFD, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xDF, 0xFE, 0xDC, 0xBA, 0x99, 0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xED,
    0xFF, 0xFF, 0xEC, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xFE, 0xEF, 0xFF,
    0xFF, 0xEC, 0xDC, 0xBB, 0xBB, 0xCC, 0xCC, 0xDE, 0xFD, 0xFF, 0xFF, 0xFF,
    0xFE, 0xED, 0xDC, 0xCD, 0xDD, 0xDE, 0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xEE, 0xFE, 0xDE, 0xEE, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xEE, 0xDD, 0xDE,
    0xFE, 0xDD, 0xDE, 0xEE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0xBF, 0xDD, 0xDC, 0xCC, 0xBC, 0xCD, 0xDD, 0xDF, 0xFF, 0xFF, 0xCD, 0xDF,
    0xDC, 0xCB, 0xCB, 0xCB, 0xCC, 0xCD, 0xFF, 0xFF, 0xFF, 0xDE, 0xDC, 0xCC,
    0xBB, 0xBA, 0xAB, 0xBB, 0xCD, 0xFF, 0xFF, 0xFC, 0xDD, 0xBB, 0xAA, 0x99,
    0x99, 0x9A, 0xAB, 0xCD, 0xDF, 0xFF, 0xDC, 0xBB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0xAB, 0xBC, 0xDF, 0xFC, 0xCC, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x89,
    0xAB, 0xBD, 0xFF, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xDD, 0xFC, 0xCA, 0x99, 0x87, 0x66, 0x55, 0x56, 0x67, 0x89, 0xAB, 0xFF,
    0xCC, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBE, 0xEC, 0xBA,
    0x98, 0x76, 0x55, 0x54, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xDD, 0xCB, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x78, 0xAB, 0xCC, 0xCC, 0xBA, 0x97, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xDF, 0xDB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCD, 0xDD, 0xDB, 0xA8, 0x87, 0x77, 0x67, 0x77, 0x89, 0xAA,
    0xBD, 0xFF, 0xDD, 0xCA, 0xA9, 0x88, 0x77, 0x88, 0x89, 0x9A, 0xBC, 0xDC,
    0xFF, 0xFD, 0xCB, 0xAA, 0x99, 0x89, 0x99, 0xAA, 0xBC, 0xCF, 0xCF, 0xFF,
    0xFD, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDC, 0xFF, 0xFF, 0xFF, 0xFD,
    0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFE, 0xDC,
    0xCC, 0xCC, 0xDD, 0xCC, 0xFE, 0xDF, 0xDF, 0xFF, 0xFF, 0xDD, 0xCC, 0xCD,
    0xCC, 0xCF, 0xDD, 0xDD, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0xBF, 0xDD, 0xED, 0xED, 0xDD, 0xDE, 0xEE, 0xFF, 0xFF, 0xFF, 0xCE, 0xFF,
    0xFF, 0xFE, 0xDE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFE, 0xDD,
    0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xFF, 0xFF, 0xFE, 0xFE, 0xED, 0xCC, 0xBB,
    0xBB, 0xBB, 0xCD, 0xEF, 0xFF, 0xFF, 0xDE, 0xDD, 0xBB, 0xAA, 0x99, 0x99,
    0xAB, 0xCD, 0xED, 0xFF, 0xFE, 0xFD, 0xCB, 0xA9, 0x98, 0x88, 0x88, 0x9A,
    0xBD, 0xEF, 0xFF, 0xDF, 0xDC, 0xB9, 0x87, 0x76, 0x67, 0x78, 0x9A, 0xCE,
    0xFF, 0xFE, 0xDD, 0xBA, 0x97, 0x76, 0x55, 0x56, 0x78, 0x9B, 0xCE, 0xFF,
    0xED, 0xDB, 0xA8, 0x76, 0x54, 0x44, 0x56, 0x79, 0xAC, 0xEF, 0xEE, 0xEC,
    0xB9, 0x86, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xCD, 0xFE, 0xEE, 0xCB, 0x98,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAC, 0xEF, 0xFD, 0xEC, 0xB9, 0x87, 0x55,
    0x44, 0x45, 0x67, 0x9A, 0xCD, 0xFD, 0xEF, 0xDB, 0xA8, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAC, 0xDF, 0xEE, 0xFD, 0xCB, 0x98, 0x76, 0x66, 0x67, 0x78,
    0xAB, 0xCD, 0xEE, 0xFF, 0xFD, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDF, 0xEF, 0xFF, 0xED, 0xBA, 0xA9, 0x99, 0x99, 0xAA, 0xBC, 0xDD, 0xEE,
    0xFF, 0xFF, 0xDC, 0xCB, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xEE, 0xEF, 0xFF,
    0xFF, 0xED, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xEF, 0xFE, 0xFF, 0xFF, 0xFF,
    0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xEE, 0xFE, 0xEF, 0xFF, 0xFF, 0xFF, 0xBF, 0xEF, 0xFF, 0xEE, 0xED, 0xEE,
    0xED, 0xFE, 0xFE, 0xEE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xCB, 0xBB, 0xBB, 0xBB, 0xAB, 0xBB, 0xCC, 0xCD, 0xDE, 0xBC, 0xDD,
    0xCC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDF, 0xFD, 0xBC, 0xCB, 0xBA,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xEE, 0xEB, 0xCB, 0xBA, 0xA9, 0x99,
    0x99, 0x99, 0xAA, 0xAB, 0xCD, 0xDD, 0xBC, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xAB, 0xCD, 0xCB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xCC, 0xBB, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBC, 0xCB, 0xBA, 0x98, 0x77, 0x66, 0x65, 0x66, 0x77, 0x89, 0xAB, 0xBB,
    0xBB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xBA, 0xBA,
    0x98, 0x76, 0x65, 0x54, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xBB, 0xA9, 0x87,
    0x66, 0x54, 0x45, 0x56, 0x77, 0x89, 0xAB, 0xBB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x89, 0xAB, 0xBB, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xCC, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0xBC, 0xCB, 0xBA, 0x99, 0x88, 0x87, 0x78, 0x88, 0x9A, 0xAB, 0xCB,
    0xCD, 0xCB, 0xBA, 0x99, 0x98, 0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xCD, 0xDD,
    0xCB, 0xBA, 0xAA, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDC, 0xDE, 0xDD, 0xCB,
    0xBB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xCE, 0xEE, 0xDD, 0xCC, 0xCB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEC, 0xBD, 0xDD, 0xCC, 0xCC, 0xBB, 0xBB,
    0xBB, 0xBB, 0xCC, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCC, 0xBB, 0xCC,
    0xBB, 0xAA, 0xAA, 0x99, 0xA9, 0xAA, 0xBB, 0xBD, 0xDC, 0xAB, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xCA, 0xBA, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xBB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x88, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xB9, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBB, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAA, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x66, 0x55, 0x56, 0x67, 0x78, 0x89, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x65, 0x55, 0x66, 0x77, 0x88, 0x9A, 0x99, 0xA9, 0x88, 0x76, 0x66,
    0x65, 0x66, 0x67, 0x78, 0x89, 0xA9, 0x99, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0x9A, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x99, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x89,
    0xAA, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0x9A, 0xAA,
    0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBB, 0xCB,
    0xAA, 0xA9, 0x98, 0x88, 0x89, 0x99, 0x9A, 0xAB, 0xBB, 0xCC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xBD, 0xDD, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDB, 0xBD, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xAA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xBB, 0xCB,
    0xBA, 0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xAB, 0xCC, 0xDC, 0xAB, 0xAA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCA, 0xBA, 0x99, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x88, 0x88, 0x77, 0x77,
    0x78, 0x89, 0x9A, 0xAB, 0xB9, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAA, 0xA9, 0x99, 0x87, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x89, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x66, 0x66, 0x66, 0x66, 0x78, 0x89, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x67, 0x88, 0x9A, 0x99, 0x99, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x78, 0x89, 0xA9, 0x9A, 0x98, 0x77, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0xAA, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x78, 0x89, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x67, 0x77, 0x78, 0x89,
    0x9A, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78, 0x89, 0x9A, 0xAA,
    0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xAB, 0xBB,
    0xAA, 0x99, 0x98, 0x88, 0x88, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xCB, 0xBA,
    0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBB, 0xBD, 0xDC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCB, 0xCD, 0xCB, 0xBB, 0xAA, 0xAA, 0x99,
    0xAA, 0xAA, 0xAB, 0xBB, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xAA, 0xA9, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0xCD, 0xAB, 0xCC,
    0xBB, 0xBB, 0xAA, 0xAA, 0xBA, 0xBC, 0xCD, 0xED, 0xEC, 0xBC, 0xBB, 0xBA,
    0xA9, 0xA9, 0xA9, 0xAA, 0xAB, 0xBC, 0xDE, 0xDB, 0xBB, 0xBA, 0x99, 0x99,
    0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDC, 0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x99, 0xAB, 0xCC, 0xBA, 0xBA, 0x99, 0x88, 0x87, 0x77, 0x77, 0x78,
    0x89, 0xAB, 0xCC, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x78, 0x9A,
    0xBB, 0xBA, 0xAA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67, 0x89, 0x9A, 0xBA,
    0xAA, 0x99, 0x87, 0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xAA, 0xAA,
    0x98, 0x76, 0x65, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xBA, 0xAA, 0x99, 0x87,
    0x66, 0x55, 0x55, 0x56, 0x67, 0x89, 0xAA, 0xBA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0xAB, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x89, 0xAA, 0xAB, 0xBA, 0x98, 0x87, 0x66, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xAA, 0xBB, 0xA9, 0x98, 0x87, 0x77, 0x67, 0x77, 0x88, 0x9A,
    0xAB, 0xAC, 0xCB, 0xAA, 0x98, 0x87, 0x77, 0x78, 0x89, 0x99, 0xAA, 0xBA,
    0xCC, 0xCB, 0xA9, 0x99, 0x88, 0x88, 0x89, 0x99, 0xAA, 0xBB, 0xAC, 0xCC,
    0xBB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBB, 0xCB, 0xCE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xBE, 0xED, 0xDC, 0xCC, 0xBB,
    0xBB, 0xBB, 0xAA, 0xBC, 0xCC, 0xDB, 0xAD, 0xDD, 0xBB, 0xBB, 0xBB, 0xBA,
    0xAA, 0xBB, 0xBB, 0xBC, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xCD, 0xAB, 0xCC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDE, 0xFD, 0xBC, 0xBB, 0xAA,
    0xAA, 0x9A, 0xAA, 0xAA, 0xBB, 0xCD, 0xDE, 0xDB, 0xBB, 0xAA, 0x99, 0x99,
    0x89, 0x99, 0x9A, 0xAB, 0xCD, 0xDC, 0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xBB, 0xCC, 0xCA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBB, 0xCC, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBC, 0xCA, 0xAA, 0x98, 0x77, 0x66, 0x65, 0x66, 0x67, 0x89, 0xAA, 0xCB,
    0xAA, 0x99, 0x87, 0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xBA, 0xAA,
    0x98, 0x76, 0x65, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0xA9, 0x87,
    0x66, 0x55, 0x45, 0x56, 0x67, 0x89, 0xAB, 0xBB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x89, 0xAB, 0xBB, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBB, 0xBC, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0xBC, 0xCB, 0xBA, 0x99, 0x88, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xBB,
    0xCD, 0xCB, 0xAA, 0x99, 0x98, 0x88, 0x89, 0x99, 0xAA, 0xBB, 0xBD, 0xED,
    0xCB, 0xBA, 0xA9, 0x99, 0x99, 0xAA, 0xAA, 0xBC, 0xCB, 0xDE, 0xED, 0xCC,
    0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xCD, 0xBD, 0xFE, 0xED, 0xCC, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDB, 0xAD, 0xDD, 0xCC, 0xCC, 0xBB, 0xBB,
    0xAB, 0xBB, 0xBB, 0xBC, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0xAF, 0xDF, 0xDF, 0xFD, 0xDD, 0xCD, 0xDF, 0xFD, 0xFF, 0xDD, 0x9F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF, 0xCD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDF, 0xCC, 0xCD, 0xFD, 0xFF, 0xFF,
    0xFF, 0xFD, 0xFF, 0xFF, 0xFD, 0xBA, 0x88, 0xAC, 0xDF, 0xFD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xCA, 0x74, 0x46, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xDF, 0xFC, 0x85, 0x22, 0x47, 0xDF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF,
    0xD8, 0x42, 0x13, 0x7B, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xA6,
    0x43, 0x58, 0xCF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xA8, 0x78,
    0xAB, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xDB, 0xBC, 0xDF,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xDD, 0xFD, 0xDF, 0xDF,
    0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFD,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDF,
    0xDD, 0xFD, 0xFF, 0xDD, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFD, 0xDD, 0xCD, 0xDE, 0xDD, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF,
    0xFF, 0xED, 0xDC, 0xCC, 0xCD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xDD,
    0xBB, 0xBA, 0xBB, 0xBD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFD, 0xCC, 0xBA, 0xAA,
    0x99, 0xAA, 0xBB, 0xCE, 0xFF, 0xFF, 0xFF, 0xEC, 0xBA, 0x99, 0x88, 0x89,
    0x9A, 0xAB, 0xCE, 0xFF, 0xFE, 0xFC, 0xCA, 0x98, 0x87, 0x77, 0x78, 0x99,
    0xAB, 0xDD, 0xFF, 0xDD, 0xBB, 0x98, 0x77, 0x66, 0x66, 0x77, 0x99, 0xBC,
    0xDF, 0xED, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xFF,
    0xFC, 0xB9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0xAB, 0xCF, 0xFC, 0xDB,
    0xA8, 0x76, 0x55, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xED, 0xDC, 0xCA, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9B, 0xCE, 0xFE, 0xDB, 0xA9, 0x76, 0x55,
    0x44, 0x55, 0x67, 0x89, 0xBC, 0xDD, 0xDC, 0xCA, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0xAB, 0xCF, 0xED, 0xFD, 0xBA, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBE, 0xEF, 0xDF, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x9A, 0xBC,
    0xCF, 0xFE, 0xFF, 0xDC, 0xA9, 0x98, 0x88, 0x88, 0x9A, 0xBC, 0xDF, 0xEF,
    0xFF, 0xFE, 0xCB, 0xBA, 0x99, 0x9A, 0xAA, 0xBC, 0xCD, 0xFF, 0xFF, 0xFF,
    0xFD, 0xCD, 0xCB, 0xBB, 0xBB, 0xBC, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xED, 0xDC, 0xDC, 0xDD, 0xCF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xDF, 0xEF,
    0xDD, 0xEE, 0xFF, 0xDE, 0xFF, 0xFF, 0xBF, 0xFF, 0xFD, 0xFF, 0xFE, 0xED,
    0xFE, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xEE, 0xED, 0xDD, 0xCC, 0xCC, 0xDD, 0xEE, 0xEF, 0xFF, 0xDE, 0xFF,
    0xED, 0xCC, 0xCC, 0xBC, 0xCC, 0xDD, 0xEE, 0xFF, 0xFF, 0xEF, 0xED, 0xCC,
    0xBB, 0xAA, 0xAA, 0xBB, 0xCD, 0xDE, 0xFF, 0xFE, 0xFD, 0xCB, 0xAA, 0xA9,
    0x99, 0x99, 0xAB, 0xBC, 0xEF, 0xFF, 0xDD, 0xCB, 0xAA, 0x98, 0x88, 0x88,
    0x89, 0xAA, 0xBC, 0xEF, 0xFD, 0xDB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0x9B, 0xCD, 0xEE, 0xDD, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x67, 0x89, 0xAB,
    0xCE, 0xEC, 0xCB, 0x98, 0x77, 0x66, 0x55, 0x56, 0x67, 0x89, 0xBC, 0xDE,
    0xCC, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x54, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x77, 0x9A, 0xBD, 0xDC, 0xCA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xDC, 0xB9, 0x87, 0x66, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xCD, 0xDD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xED, 0xED, 0xCB, 0x99, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDE, 0xEC, 0xBA, 0x99, 0x88, 0x87, 0x88, 0x89, 0xAB, 0xCD, 0xEF,
    0xFF, 0xDD, 0xBB, 0xA9, 0x99, 0x99, 0x99, 0xAB, 0xCC, 0xEF, 0xFF, 0xFF,
    0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCD, 0xEF, 0xFF, 0xFF, 0xFF, 0xED,
    0xCC, 0xBB, 0xBB, 0xBC, 0xDC, 0xDE, 0xFF, 0xEF, 0xFF, 0xFF, 0xEE, 0xED,
    0xDC, 0xDD, 0xED, 0xEF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFE, 0xED, 0xDD, 0xDD,
    0xDD, 0xDD, 0xEF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xCD, 0xDC, 0xCC, 0xCD, 0xDE, 0xDD, 0xFF, 0xFF, 0xFF, 0xDD, 0xFE,
    0xDC, 0xCC, 0xCB, 0xCC, 0xCD, 0xDD, 0xFF, 0xFF, 0xFF, 0xDF, 0xDD, 0xCB,
    0xBB, 0xBA, 0xBB, 0xBC, 0xCD, 0xEF, 0xEF, 0xFD, 0xFC, 0xCB, 0xA9, 0xA9,
    0x99, 0x9A, 0xAB, 0xCD, 0xDF, 0xFE, 0xCE, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x99, 0xAB, 0xCD, 0xEF, 0xFC, 0xCB, 0xAA, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAB, 0xCE, 0xFE, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAC,
    0xDE, 0xEC, 0xCA, 0x98, 0x77, 0x65, 0x55, 0x56, 0x77, 0x9A, 0xBC, 0xDD,
    0xCC, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xEC, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xCC, 0xB9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xCB, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xDC, 0xBA, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xCD, 0xDD, 0xDC, 0xB9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x99, 0xBB, 0xDF, 0xDE, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xED, 0xBB, 0xA9, 0x98, 0x88, 0x88, 0x89, 0xAA, 0xBD, 0xDD,
    0xFF, 0xED, 0xCB, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDE, 0xEF, 0xFF,
    0xFD, 0xCC, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xEE, 0xFF, 0xFF, 0xED,
    0xDC, 0xCB, 0xBC, 0xCB, 0xCD, 0xCD, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xDD,
    0xEC, 0xDC, 0xCC, 0xEF, 0xEF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFD, 0xED, 0xDD,
    0xDC, 0xDD, 0xDD, 0xDF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xBF, 0xEE, 0xED, 0xEF, 0xED, 0xEE, 0xFE, 0xEF, 0xFE, 0xFF, 0xAE, 0xFF,
    0xFE, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDD,
    0xDD, 0xDD, 0xDD, 0xEE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xED, 0xCC, 0xCB,
    0xBB, 0xCC, 0xDE, 0xEF, 0xFF, 0xFF, 0xFF, 0xDD, 0xCB, 0xAA, 0xAA, 0xAA,
    0xBB, 0xCD, 0xEF, 0xFF, 0xFE, 0xFE, 0xCB, 0xA9, 0x98, 0x88, 0x89, 0xAB,
    0xCD, 0xFF, 0xFF, 0xEE, 0xDC, 0xA9, 0x88, 0x77, 0x77, 0x89, 0xAB, 0xDE,
    0xFF, 0xFF, 0xFD, 0xBA, 0x97, 0x76, 0x55, 0x66, 0x89, 0xAC, 0xDF, 0xFE,
    0xEE, 0xDB, 0xA8, 0x76, 0x54, 0x45, 0x67, 0x8A, 0xBD, 0xFF, 0xEE, 0xED,
    0xBA, 0x87, 0x54, 0x33, 0x45, 0x68, 0x9B, 0xDF, 0xFE, 0xFF, 0xDB, 0xA8,
    0x75, 0x43, 0x34, 0x56, 0x89, 0xBC, 0xEF, 0xEE, 0xFD, 0xCA, 0x87, 0x65,
    0x44, 0x45, 0x68, 0x9B, 0xCE, 0xFF, 0xFF, 0xEC, 0xB9, 0x86, 0x65, 0x55,
    0x67, 0x8A, 0xBD, 0xEF, 0xFF, 0xFF, 0xDC, 0xA9, 0x87, 0x66, 0x77, 0x89,
    0xAB, 0xCF, 0xFF, 0xFF, 0xFE, 0xCB, 0xA9, 0x88, 0x88, 0x89, 0xAB, 0xCD,
    0xEF, 0xFF, 0xFF, 0xFE, 0xCB, 0xAA, 0x99, 0x9A, 0xAA, 0xBC, 0xDE, 0xFF,
    0xFF, 0xFF, 0xFE, 0xDC, 0xBB, 0xBB, 0xBB, 0xCC, 0xDE, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xED, 0xDD, 0xCD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xEF, 0xEF, 0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xEF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAE, 0xDD, 0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0xFE, 0xEE, 0xFF, 0xBD, 0xFF,
    0xEE, 0xED, 0xED, 0xEE, 0xEF, 0xFE, 0xFF, 0xFF, 0xFE, 0xEE, 0xED, 0xDD,
    0xCC, 0xCC, 0xDD, 0xDE, 0xEE, 0xFF, 0xFF, 0xEE, 0xEE, 0xDC, 0xCB, 0xBB,
    0xBB, 0xBC, 0xDD, 0xEE, 0xFF, 0xFE, 0xDE, 0xDC, 0xBB, 0xAA, 0x99, 0xAA,
    0xBB, 0xCD, 0xEF, 0xFF, 0xED, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x89, 0xAB,
    0xCD, 0xEF, 0xFE, 0xDD, 0xDB, 0xA9, 0x87, 0x77, 0x77, 0x89, 0xAB, 0xCE,
    0xFF, 0xED, 0xDC, 0xBA, 0x97, 0x76, 0x55, 0x67, 0x89, 0xAC, 0xDE, 0xFE,
    0xDD, 0xCB, 0xA8, 0x76, 0x54, 0x45, 0x67, 0x8A, 0xBC, 0xEF, 0xDD, 0xDC,
    0xB9, 0x87, 0x54, 0x33, 0x45, 0x68, 0x9B, 0xCD, 0xEE, 0xDE, 0xCB, 0xA8,
    0x75, 0x43, 0x34, 0x56, 0x89, 0xBC, 0xDF, 0xDD, 0xED, 0xBA, 0x97, 0x65,
    0x44, 0x45, 0x78, 0x9A, 0xCD, 0xEE, 0xDE, 0xDC, 0xB9, 0x87, 0x65, 0x55,
    0x67, 0x89, 0xBC, 0xDE, 0xDD, 0xEE, 0xDB, 0xA9, 0x87, 0x66, 0x77, 0x89,
    0xAB, 0xCD, 0xFD, 0xDE, 0xED, 0xCB, 0xA9, 0x88, 0x88, 0x89, 0x9A, 0xBC,
    0xDF, 0xDD, 0xFE, 0xED, 0xCB, 0xAA, 0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xFE,
    0xDF, 0xFF, 0xED, 0xCC, 0xBB, 0xAB, 0xBB, 0xBC, 0xDE, 0xEF, 0xDD, 0xFF,
    0xFF, 0xEE, 0xDC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xFE, 0xDF, 0xFF, 0xFF,
    0xEE, 0xED, 0xDD, 0xDD, 0xDD, 0xDE, 0xFE, 0xED, 0xFF, 0xFF, 0xFF, 0xEF,
    0xEE, 0xEE, 0xFE, 0xFF, 0xFF, 0xFE, 0x9D, 0xEE, 0xDD, 0xDE, 0xDD, 0xDD,
    0xDD, 0xDD, 0xFE, 0xED, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xBB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDC, 0xAB, 0xBA, 0xA9,
    0x99, 0x88, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xCA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBB, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77,
    0x88, 0x89, 0x99, 0xAB, 0xBA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xAA, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAA, 0xA9, 0x99, 0x87, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x98,
    0x87, 0x76, 0x66, 0x55, 0x66, 0x67, 0x78, 0x89, 0xA9, 0x99, 0x98, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x77, 0x88, 0x9A, 0x99, 0x99, 0x87, 0x76, 0x66,
    0x65, 0x66, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x67, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x89,
    0xAA, 0xAA, 0xA9, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0x9A, 0xBA,
    0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xAB, 0xCB,
    0xA9, 0x99, 0x98, 0x88, 0x89, 0x99, 0xAA, 0xAB, 0xCB, 0xBC, 0xBA, 0xAA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBC, 0xCC, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDC, 0xAC, 0xBB, 0xBA, 0xAA, 0x99, 0x99,
    0xAA, 0xAA, 0xAB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xAB, 0xCB,
    0xBA, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0xCC, 0xAB, 0xBA, 0xA9,
    0x99, 0x88, 0x89, 0x99, 0x9A, 0xAB, 0xBC, 0xBA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x99, 0xAB, 0xBB, 0xAA, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x78, 0x89, 0x99, 0xAB, 0xA9, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0x9A, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x89, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x98,
    0x87, 0x76, 0x66, 0x56, 0x66, 0x67, 0x78, 0x89, 0xA9, 0x99, 0x88, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x77, 0x88, 0x9A, 0x99, 0x98, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x78, 0x89, 0xA9, 0x99, 0x98, 0x77, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x99, 0xAA, 0x9A, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x89,
    0xAA, 0xAA, 0xAA, 0x98, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0x9A, 0xBA,
    0xAB, 0xA9, 0x99, 0x88, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xAB, 0xBB,
    0xAA, 0x99, 0x98, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCB, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xAB, 0xBC, 0xBC, 0xDC, 0xBB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDC, 0xAC, 0xBB, 0xBA, 0xAA, 0xA9, 0x99,
    0xAA, 0xAA, 0xAB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xBD, 0xAB, 0xCB,
    0xBA, 0xAA, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xBC, 0xDC, 0xBC, 0xBA, 0xA9,
    0x99, 0x89, 0x88, 0x99, 0x9A, 0xAB, 0xCD, 0xBA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xBB, 0xBC, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77,
    0x78, 0x89, 0x9A, 0xBC, 0xB9, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0x9A, 0x99, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xA9, 0x99, 0x87, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x98,
    0x87, 0x76, 0x66, 0x65, 0x66, 0x66, 0x78, 0x89, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x67, 0x88, 0x9A, 0x99, 0x99, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x78, 0x89, 0xAA, 0x9A, 0x98, 0x87, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x99, 0xAA, 0x9A, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x89,
    0xAA, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0x9A, 0xBA,
    0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0x9A, 0xBB, 0xBB, 0xCB,
    0xAA, 0x99, 0x98, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xCB, 0xCC, 0xCB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBC, 0xDC, 0xBC, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDC, 0xAD, 0xCB, 0xBA, 0xAA, 0xAA, 0x9A,
    0xAA, 0xAA, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xCC, 0xCC, 0xBC, 0xCB, 0xCB, 0xCC, 0xCC, 0xCD, 0xDD, 0x9C, 0xED,
    0xCD, 0xCC, 0xCB, 0xCC, 0xCC, 0xCD, 0xEE, 0xEF, 0xFD, 0xCD, 0xCC, 0xCB,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xDC, 0xCC, 0xBA, 0xAA, 0x99,
    0x9A, 0xAA, 0xBB, 0xBC, 0xDE, 0xFD, 0xCD, 0xBB, 0xA9, 0x98, 0x88, 0x89,
    0x9A, 0xAB, 0xCC, 0xEE, 0xDC, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xED, 0xBC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x78, 0x89, 0xBB,
    0xCE, 0xDC, 0xCB, 0xA8, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xBC, 0xBA, 0x87, 0x66, 0x55, 0x45, 0x66, 0x78, 0x9A, 0xCD, 0xCC, 0xCB,
    0xA8, 0x76, 0x55, 0x44, 0x45, 0x67, 0x89, 0xAC, 0xCC, 0xCC, 0xBA, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBD, 0xCC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x89, 0xAB, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xCD, 0xCC, 0xAA, 0x98, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDC, 0xDD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xED, 0xCB, 0xAA, 0x99, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xDC,
    0xDE, 0xDD, 0xCB, 0xBA, 0xA9, 0x99, 0x99, 0xAA, 0xBC, 0xDD, 0xDD, 0xEE,
    0xDD, 0xCC, 0xBB, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDD, 0xDF, 0xFE, 0xEE,
    0xDC, 0xCC, 0xCB, 0xCC, 0xCC, 0xCD, 0xDE, 0xDE, 0xFF, 0xFF, 0xEE, 0xDD,
    0xDC, 0xCD, 0xDD, 0xDD, 0xED, 0xED, 0xAE, 0xDD, 0xDD, 0xCD, 0xCC, 0xCC,
    0xCC, 0xCD, 0xDD, 0xDD, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEF, 0xEF, 0xFF, 0xBF, 0xFF,
    0xFF, 0xDD, 0xDD, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD,
    0xCC, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xFF, 0xFF, 0xFE, 0xDC, 0xCB, 0xAA,
    0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xFF, 0xEF, 0xDC, 0xBB, 0xA9, 0x99, 0x99,
    0x9A, 0xBC, 0xDE, 0xFF, 0xFE, 0xED, 0xBA, 0x99, 0x88, 0x77, 0x78, 0x9A,
    0xBC, 0xDF, 0xFF, 0xED, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x78, 0x9A, 0xBC,
    0xEF, 0xFD, 0xDC, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x78, 0x9A, 0xCE, 0xFF,
    0xED, 0xBA, 0x97, 0x65, 0x55, 0x45, 0x56, 0x79, 0xAB, 0xDE, 0xFD, 0xCB,
    0xA9, 0x76, 0x55, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xEF, 0xDD, 0xBA, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xDE, 0xEE, 0xDC, 0xA9, 0x76, 0x55,
    0x44, 0x55, 0x67, 0x9A, 0xBD, 0xEF, 0xEE, 0xCA, 0x98, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAC, 0xDF, 0xFE, 0xED, 0xBA, 0x98, 0x76, 0x66, 0x67, 0x78,
    0x9B, 0xCD, 0xEE, 0xFF, 0xDC, 0xBA, 0x98, 0x77, 0x77, 0x88, 0x9A, 0xBC,
    0xEF, 0xFF, 0xFE, 0xDC, 0xBA, 0x99, 0x88, 0x89, 0xAA, 0xBC, 0xDE, 0xFF,
    0xFF, 0xFF, 0xDC, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDC, 0xCB, 0xBB, 0xBB, 0xCC, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xED, 0xDD, 0xCD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAF, 0xFA, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0x9F, 0xAA, 0xBA, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0x98, 0x89, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x76, 0x78, 0x78, 0x8F, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xF7, 0x64, 0x56, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xA9, 0x74, 0x22, 0x57, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x97, 0x52, 0x14, 0x69, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x86,
    0x44, 0x57, 0x8A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x99, 0x76, 0x77,
    0x89, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x89, 0x99, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xAF, 0xFA, 0xFF, 0xFF,
    0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF,
    0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA,
    0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xAF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x79, 0xFA, 0xCF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xAF, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xDD, 0xCC, 0xCB, 0xBB, 0xCC, 0xCC, 0xDD, 0xEE, 0xEE, 0xCD, 0xEE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xFF, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xFD, 0xDC, 0xBB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xFE, 0xCC, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xDE, 0xEC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x67, 0x88, 0xAB,
    0xCD, 0xDC, 0xCA, 0x98, 0x77, 0x65, 0x55, 0x56, 0x67, 0x89, 0xAB, 0xDD,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x55, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xBB, 0xA9, 0x87,
    0x65, 0x55, 0x45, 0x56, 0x77, 0x9A, 0xBC, 0xDC, 0xBA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xCC, 0xA9, 0x87, 0x66, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x99, 0xAC, 0xDD, 0xDD, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xDC, 0xBA, 0x99, 0x88, 0x78, 0x88, 0x89, 0xAA, 0xBC, 0xDD,
    0xEE, 0xDC, 0xBA, 0xA9, 0x99, 0x99, 0x99, 0xAB, 0xBC, 0xDE, 0xDE, 0xFE,
    0xDC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xCC, 0xDD, 0xED, 0xFF, 0xFE, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xEF, 0xEF, 0xFF, 0xFF, 0xED, 0xDD,
    0xCC, 0xCC, 0xDD, 0xEE, 0xEF, 0xFE, 0xCF, 0xFF, 0xEE, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDD, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDE, 0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xEF, 0xFF, 0xBF, 0xEF,
    0xED, 0xDC, 0xCC, 0xCC, 0xCD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFE, 0xDD, 0xCB,
    0xBB, 0xBA, 0xBB, 0xBC, 0xCD, 0xEF, 0xFF, 0xFD, 0xED, 0xCB, 0xBA, 0xA9,
    0x99, 0x9A, 0xBB, 0xCD, 0xEF, 0xFF, 0xDD, 0xCC, 0xBA, 0x99, 0x88, 0x88,
    0x89, 0xAB, 0xCD, 0xEF, 0xED, 0xCC, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x89,
    0xAB, 0xDE, 0xFF, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x67, 0x89, 0xAC,
    0xDE, 0xED, 0xCB, 0xA9, 0x77, 0x66, 0x55, 0x56, 0x67, 0x8A, 0xBC, 0xDE,
    0xDC, 0xBA, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCE, 0xED, 0xCB,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xDC, 0xB9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xEC, 0xCB, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xDF, 0xDD, 0xBA, 0x97, 0x66, 0x55, 0x55,
    0x66, 0x78, 0xAB, 0xCD, 0xDD, 0xDB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x9A, 0xBD, 0xDF, 0xDE, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x9A, 0xAC,
    0xDF, 0xDF, 0xFD, 0xCB, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xBB, 0xCD, 0xEE,
    0xFF, 0xFC, 0xCB, 0xAA, 0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xEF, 0xFF, 0xFE,
    0xEC, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCD, 0xEF, 0xED, 0xEF, 0xFF, 0xED,
    0xDD, 0xCB, 0xCB, 0xCC, 0xDD, 0xDE, 0xFF, 0xEF, 0xFF, 0xFF, 0xEE, 0xED,
    0xDD, 0xDE, 0xEE, 0xEE, 0xFF, 0xFE, 0xAE, 0xFF, 0xEE, 0xEE, 0xEE, 0xED,
    0xFD, 0xED, 0xFE, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xFE, 0xFF, 0xEE, 0xEF, 0xEF, 0xDF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF,
    0xFF, 0xFE, 0xEE, 0xDD, 0xDF, 0xEF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFD,
    0xDD, 0xCB, 0xBC, 0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xCB, 0xBA,
    0xAA, 0xBB, 0xBC, 0xDF, 0xFF, 0xFF, 0xEF, 0xDD, 0xCB, 0xA9, 0x99, 0x99,
    0x9A, 0xBC, 0xDF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x88, 0x77, 0x88, 0x9A,
    0xBC, 0xDF, 0xFF, 0xFE, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x78, 0x9A, 0xBD,
    0xFF, 0xFE, 0xDC, 0xB9, 0x87, 0x66, 0x55, 0x56, 0x78, 0x9B, 0xDE, 0xFF,
    0xEE, 0xCA, 0x98, 0x65, 0x54, 0x45, 0x56, 0x79, 0xAC, 0xEF, 0xFF, 0xDC,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x8A, 0xCD, 0xFF, 0xED, 0xCA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAC, 0xDF, 0xFE, 0xEC, 0xA9, 0x86, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xCD, 0xFF, 0xEE, 0xCB, 0x98, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAC, 0xDF, 0xFF, 0xFD, 0xCA, 0x98, 0x76, 0x66, 0x67, 0x89,
    0xAB, 0xCE, 0xEF, 0xFF, 0xEC, 0xBA, 0x98, 0x87, 0x77, 0x89, 0x9B, 0xCD,
    0xEF, 0xFF, 0xFF, 0xEC, 0xBA, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xDF, 0xFF,
    0xFF, 0xFE, 0xDC, 0xBB, 0xAA, 0xAA, 0xAB, 0xCC, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDD, 0xCB, 0xCB, 0xCC, 0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFE, 0xDD, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBB, 0xAA, 0xAA, 0x99, 0xAA, 0xAA, 0xAB, 0xCC, 0xCD, 0xBB, 0xCC,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDD, 0xEE, 0xBC, 0xBB, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xDA, 0xBA, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xBC, 0xCC, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBC, 0xCA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAB, 0xBB, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x67, 0x78, 0x99,
    0xAB, 0xBA, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xBB,
    0x9A, 0x98, 0x77, 0x66, 0x65, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xB9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAB, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xAA, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x9A, 0xAA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x89, 0xAA, 0xAA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBB, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xBB, 0xBA, 0xA9, 0x88, 0x87, 0x77, 0x77, 0x88, 0x99, 0xAA, 0xBB,
    0xBC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBC, 0xCC,
    0xBB, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xDD, 0xCC, 0xBB,
    0xAA, 0xAA, 0xA9, 0xAA, 0xAB, 0xBB, 0xCD, 0xCD, 0xDD, 0xDC, 0xCB, 0xBB,
    0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xEC, 0xAE, 0xDD, 0xCC, 0xBB, 0xAA, 0xAA,
    0xAB, 0xBB, 0xBC, 0xCD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0xCB, 0x9B, 0xCB,
    0xBA, 0xAA, 0xAA, 0xA9, 0xAA, 0xAA, 0xBB, 0xCD, 0xDC, 0xBC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xCA, 0xBB, 0xAA, 0x99, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xBC, 0xCC, 0xAB, 0xA9, 0x98, 0x88, 0x87, 0x77,
    0x88, 0x89, 0x9A, 0xBC, 0xBA, 0xAA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBB, 0xAA, 0x99, 0x88, 0x77, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xB9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xBB,
    0x9A, 0x98, 0x87, 0x66, 0x65, 0x56, 0x66, 0x77, 0x89, 0xAB, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x87, 0x76, 0x65,
    0x55, 0x66, 0x67, 0x78, 0x9A, 0xBA, 0xAA, 0x98, 0x87, 0x66, 0x66, 0x66,
    0x67, 0x78, 0x89, 0xAA, 0xAA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x67, 0x77,
    0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x78, 0x88, 0x99, 0xAA, 0xBB,
    0xBB, 0xBA, 0x99, 0x98, 0x88, 0x88, 0x89, 0x99, 0xAA, 0xBC, 0xBB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xCD, 0xCC, 0xBB,
    0xAA, 0xA9, 0x99, 0xAA, 0xAB, 0xBB, 0xDD, 0xBC, 0xDC, 0xCC, 0xCB, 0xBA,
    0xAA, 0xBA, 0xBB, 0xBC, 0xCC, 0xDC, 0x9C, 0xCC, 0xBB, 0xBA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xAB, 0xCB,
    0xBA, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDC, 0xAB, 0xBA, 0xA9,
    0x99, 0x98, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x78, 0x89, 0x9A, 0xAB, 0xB9, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x98,
    0x87, 0x76, 0x66, 0x55, 0x66, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x88, 0x77,
    0x66, 0x65, 0x55, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x98, 0x77, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x67, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x99, 0xAA, 0xBA,
    0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0x9A, 0xBB, 0xAB, 0xBB,
    0xAA, 0x99, 0x99, 0x88, 0x89, 0x99, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xBC, 0xBC, 0xDC, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xCB, 0xAC, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCC, 0x9C, 0xDC,
    0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xEC, 0xBC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCE, 0xCB, 0xCB, 0xBA, 0x99, 0x98,
    0x88, 0x89, 0x99, 0xAB, 0xBC, 0xDC, 0xBB, 0xBA, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0xAA, 0xBC, 0xCB, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x99, 0xAB, 0xCB, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x67, 0x78, 0x99,
    0xBC, 0xBA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x89, 0x9A, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xBA, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xBA, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0x98, 0x87, 0x76, 0x65, 0x66,
    0x66, 0x78, 0x89, 0xAB, 0xBB, 0xAA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xCB, 0xBB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xBB, 0xBA, 0xA9, 0x98, 0x87, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xCC,
    0xBC, 0xBB, 0x99, 0x98, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCD, 0xCC, 0xDC,
    0xBB, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDC, 0xDD, 0xDC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBC, 0xCC, 0xCD, 0xDD, 0xDE, 0xCD, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCD, 0xDD, 0xED, 0x9D, 0xCC, 0xCC, 0xBB, 0xBB, 0xBB,
    0xBB, 0xBC, 0xCC, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAE, 0xDE, 0xDD, 0xED, 0xDC, 0xCC, 0xDC, 0xDD, 0xDD, 0xDD, 0x9E, 0xFF,
    0xFF, 0xFD, 0xEE, 0xEE, 0xEE, 0xDE, 0xEE, 0xEF, 0xFD, 0xEF, 0xEE, 0xED,
    0xDD, 0xDD, 0xDD, 0xDE, 0xEF, 0xEE, 0xEF, 0xDE, 0xEF, 0xDD, 0xDC, 0xCC,
    0xCC, 0xCC, 0xDD, 0xEE, 0xEF, 0xFD, 0xDF, 0xED, 0xCC, 0xBB, 0xBB, 0xBB,
    0xBC, 0xCD, 0xDD, 0xFF, 0xDE, 0xEE, 0xDC, 0xBA, 0x99, 0x99, 0x9A, 0xBC,
    0xCE, 0xFE, 0xFD, 0xDF, 0xDC, 0xBA, 0x98, 0x87, 0x88, 0x9A, 0xBC, 0xDE,
    0xFE, 0xDD, 0xEE, 0xCB, 0xA8, 0x76, 0x66, 0x67, 0x9A, 0xBC, 0xEE, 0xFD,
    0xDE, 0xDC, 0xA9, 0x86, 0x54, 0x45, 0x68, 0x9B, 0xCD, 0xEF, 0xED, 0xED,
    0xCB, 0x97, 0x64, 0x32, 0x46, 0x79, 0xBC, 0xDE, 0xFE, 0xDE, 0xEC, 0xB9,
    0x86, 0x42, 0x24, 0x57, 0x9A, 0xCD, 0xEF, 0xDD, 0xED, 0xCB, 0x98, 0x75,
    0x44, 0x56, 0x79, 0xAC, 0xDE, 0xEE, 0xDF, 0xED, 0xCA, 0x98, 0x76, 0x66,
    0x78, 0x9B, 0xCD, 0xFF, 0xED, 0xEF, 0xDC, 0xBA, 0x98, 0x77, 0x78, 0x9A,
    0xBC, 0xDE, 0xFE, 0xDF, 0xED, 0xDC, 0xBA, 0x99, 0x99, 0x9A, 0xBC, 0xDD,
    0xEF, 0xEE, 0xFF, 0xED, 0xCC, 0xBB, 0xAA, 0xBB, 0xBC, 0xDD, 0xEF, 0xFE,
    0xDF, 0xFE, 0xEE, 0xDC, 0xCC, 0xCC, 0xCC, 0xDE, 0xEF, 0xFF, 0xEE, 0xFE,
    0xFE, 0xEE, 0xEE, 0xDD, 0xDD, 0xED, 0xEE, 0xEE, 0xFE, 0xEE, 0xEF, 0xFF,
    0xEE, 0xEE, 0xDE, 0xEE, 0xFE, 0xFF, 0xFF, 0xEE, 0xFF, 0xFF, 0xFE, 0xEF,
    0xEF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xAE, 0xDD, 0xDD, 0xEE, 0xDD, 0xDD,
    0xEE, 0xDE, 0xEE, 0xFE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEF, 0xFE, 0xEF, 0xFF, 0xEF, 0xAF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xEE, 0xDE, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xEC, 0xCC,
    0xCC, 0xCC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEC, 0xBA, 0xAA, 0xAA,
    0xBC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0xBA, 0x98, 0x88, 0x89, 0xAB,
    0xDE, 0xFF, 0xFF, 0xFF, 0xFD, 0xBA, 0x98, 0x77, 0x77, 0x89, 0xAC, 0xDF,
    0xFF, 0xFF, 0xFE, 0xCB, 0x98, 0x66, 0x55, 0x66, 0x89, 0xBC, 0xDF, 0xFF,
    0xFF, 0xDC, 0xA8, 0x76, 0x44, 0x45, 0x67, 0x8A, 0xCD, 0xFF, 0xFF, 0xFD,
    0xCA, 0x86, 0x54, 0x33, 0x45, 0x68, 0xAC, 0xDF, 0xFF, 0xFF, 0xDC, 0xA8,
    0x75, 0x43, 0x34, 0x56, 0x8A, 0xBD, 0xEF, 0xFE, 0xFE, 0xCA, 0x87, 0x65,
    0x44, 0x45, 0x78, 0xAC, 0xDF, 0xFF, 0xFF, 0xED, 0xB9, 0x86, 0x65, 0x55,
    0x67, 0x9B, 0xCE, 0xFF, 0xFF, 0xFF, 0xDB, 0xA9, 0x87, 0x66, 0x77, 0x8A,
    0xBD, 0xEF, 0xFF, 0xFF, 0xFF, 0xDB, 0xA9, 0x98, 0x88, 0x9A, 0xBC, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFE, 0xDC, 0xBA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFE, 0xDD, 0xCC, 0xBC, 0xCD, 0xDE, 0xEF, 0xFF, 0xFE, 0xFF,
    0xFF, 0xFF, 0xED, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDE, 0xDD, 0xDD, 0xCC, 0xDD, 0xDD, 0xEE, 0xDE, 0xEF, 0xAE, 0xFE,
    0xEE, 0xDD, 0xCC, 0xCC, 0xDD, 0xEE, 0xFF, 0xFF, 0xFF, 0xDF, 0xDE, 0xDC,
    0xCC, 0xBB, 0xBB, 0xCC, 0xDD, 0xFE, 0xEF, 0xEE, 0xFD, 0xDC, 0xBA, 0xAA,
    0x9A, 0xAA, 0xBC, 0xDD, 0xEF, 0xFF, 0xDD, 0xDC, 0xBA, 0xA9, 0x88, 0x88,
    0x99, 0xAB, 0xCD, 0xFF, 0xFC, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x78, 0x89,
    0xAC, 0xDD, 0xFE, 0xDD, 0xCA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xBC,
    0xDE, 0xFC, 0xDB, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xEF,
    0xDD, 0xBA, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0xAB, 0xDE, 0xEC, 0xCB,
    0xA8, 0x76, 0x55, 0x44, 0x45, 0x67, 0x89, 0xBD, 0xEF, 0xCC, 0xBA, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9B, 0xCD, 0xDD, 0xDB, 0xA8, 0x76, 0x55,
    0x44, 0x55, 0x67, 0x89, 0xBC, 0xEE, 0xDD, 0xCA, 0x98, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAB, 0xCE, 0xED, 0xDC, 0xB9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xFE, 0xED, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xED, 0xEE, 0xCB, 0xAA, 0x98, 0x88, 0x89, 0x9A, 0xBC, 0xDD, 0xEE,
    0xEF, 0xED, 0xCC, 0xBA, 0xA9, 0x99, 0xAA, 0xBB, 0xCD, 0xEF, 0xED, 0xFE,
    0xED, 0xDC, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xEF, 0xFE, 0xFF, 0xFF, 0xED,
    0xDD, 0xDC, 0xCD, 0xCD, 0xDD, 0xEE, 0xFF, 0xEE, 0xFF, 0xFF, 0xFE, 0xEE,
    0xDE, 0xDD, 0xEE, 0xEF, 0xFF, 0xFF, 0x9F, 0xEE, 0xED, 0xFE, 0xEF, 0xEE,
    0xDF, 0xEE, 0xEE, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xDC, 0xCC, 0xCB, 0xCC, 0xCC, 0xDD, 0xEE, 0xEE, 0xBE, 0xFE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFF, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFF, 0xFD, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x9A, 0xAB, 0xBC, 0xDE, 0xEE, 0xCD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0xAA, 0xBC, 0xDE, 0xEC, 0xCB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x89,
    0xAB, 0xCD, 0xEE, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x67, 0x89, 0xAB,
    0xCD, 0xEC, 0xCA, 0x98, 0x87, 0x66, 0x55, 0x56, 0x67, 0x89, 0xBC, 0xDD,
    0xCB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xCC, 0xDC, 0xBA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xBA, 0x87, 0x66, 0x55, 0x55,
    0x67, 0x78, 0x9A, 0xCD, 0xDD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xDD, 0xCA, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xCD, 0xDD, 0xEC, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xDD,
    0xDE, 0xDC, 0xBB, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xEE, 0xEE,
    0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xEE, 0xEF, 0xFE, 0xDD,
    0xCC, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xEE, 0xFF, 0xFF, 0xED, 0xDD,
    0xDC, 0xCD, 0xDD, 0xDE, 0xEF, 0xFE, 0xBE, 0xFE, 0xEE, 0xED, 0xDD, 0xDD,
    0xDD, 0xDD, 0xEE, 0xEE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xDD, 0xDD, 0x9D, 0xFF,
    0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xEE, 0xEF, 0xFD, 0xEE, 0xDD, 0xCC,
    0xBB, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xEF, 0xDE, 0xED, 0xCB, 0xBA, 0xA9,
    0x99, 0x9A, 0xAB, 0xCD, 0xDE, 0xFE, 0xDD, 0xCB, 0xAA, 0x99, 0x88, 0x88,
    0x99, 0xAB, 0xCD, 0xEF, 0xDC, 0xCB, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x89,
    0xAB, 0xCD, 0xFD, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x67, 0x89, 0xAB,
    0xCE, 0xEC, 0xDB, 0xA9, 0x87, 0x65, 0x55, 0x56, 0x77, 0x8A, 0xBD, 0xED,
    0xCC, 0xB9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9B, 0xCD, 0xDC, 0xCB,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xBB, 0xDD, 0xCC, 0xB9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xCD, 0xDC, 0xDB, 0x98, 0x76, 0x55,
    0x45, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xCC, 0xBA, 0x97, 0x76, 0x55, 0x55,
    0x67, 0x88, 0xAA, 0xCD, 0xDC, 0xDB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xCC, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x88, 0x9A, 0xAB,
    0xCD, 0xDE, 0xED, 0xCB, 0xA9, 0x98, 0x88, 0x89, 0x9A, 0xAB, 0xCC, 0xDD,
    0xEE, 0xDC, 0xCB, 0xAA, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xEE, 0xDE, 0xFD,
    0xDD, 0xCB, 0xBA, 0xBA, 0xAB, 0xBB, 0xCC, 0xDD, 0xFD, 0xFF, 0xFE, 0xDD,
    0xDC, 0xCC, 0xCC, 0xCC, 0xDC, 0xDD, 0xFE, 0xEF, 0xFF, 0xEF, 0xEE, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDF, 0xFF, 0xEF, 0xAD, 0xDD, 0xDD, 0xDE, 0xDC, 0xDD,
    0xDD, 0xDC, 0xDD, 0xDE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFD, 0xDD, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xCC,
    0xBC, 0xCC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0xAA, 0xAA,
    0xBC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0x98, 0x88, 0x89, 0xAC,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBA, 0x88, 0x76, 0x77, 0x89, 0xAC, 0xDF,
    0xFF, 0xFF, 0xFD, 0xCA, 0x98, 0x66, 0x55, 0x67, 0x89, 0xBC, 0xFF, 0xFF,
    0xFF, 0xFC, 0xA8, 0x76, 0x44, 0x45, 0x67, 0x8A, 0xCF, 0xFF, 0xFF, 0xFD,
    0xBA, 0x87, 0x54, 0x33, 0x45, 0x68, 0xAB, 0xDF, 0xFF, 0xFF, 0xDC, 0xA8,
    0x75, 0x43, 0x34, 0x56, 0x8A, 0xBD, 0xFF, 0xFF, 0xFF, 0xCA, 0x87, 0x65,
    0x44, 0x45, 0x78, 0xAB, 0xDF, 0xFF, 0xFF, 0xFC, 0xB9, 0x86, 0x65, 0x55,
    0x67, 0x9A, 0xCD, 0xFF, 0xFF, 0xFF, 0xDC, 0xA9, 0x87, 0x66, 0x77, 0x8A,
    0xBC, 0xDF, 0xFF, 0xFF, 0xFF, 0xDC, 0xA9, 0x88, 0x88, 0x99, 0xBC, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xCC, 0xBA, 0xAA, 0xAA, 0xBC, 0xCF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xEC, 0xCC, 0xBC, 0xCC, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFD, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xDD, 0xCD, 0xCC, 0xCC, 0xDD, 0xDE, 0xDE, 0xEE, 0x9E, 0xFF,
    0xED, 0xDD, 0xDC, 0xCC, 0xCD, 0xDE, 0xFE, 0xFF, 0xFF, 0xDF, 0xED, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xDD, 0xEF, 0xFF, 0xFE, 0xEE, 0xDC, 0xBA, 0xAA,
    0x9A, 0xAA, 0xBB, 0xCD, 0xDF, 0xFE, 0xDD, 0xDC, 0xBA, 0xA9, 0x98, 0x89,
    0x9A, 0xAB, 0xCD, 0xEF, 0xED, 0xDC, 0xBA, 0x99, 0x88, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xEE, 0xCC, 0xCB, 0xA8, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xDE, 0xEC, 0xDB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBD, 0xED,
    0xCC, 0xBA, 0x98, 0x76, 0x54, 0x55, 0x66, 0x79, 0xAB, 0xCE, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x34, 0x45, 0x67, 0x8A, 0xBC, 0xED, 0xDC, 0xBA, 0x87,
    0x65, 0x54, 0x34, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xDB, 0xA9, 0x87, 0x65,
    0x44, 0x56, 0x67, 0x9A, 0xBC, 0xDD, 0xCD, 0xCA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x89, 0xAB, 0xCD, 0xDD, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9A, 0xBC, 0xED, 0xDE, 0xDC, 0xA9, 0x98, 0x77, 0x77, 0x89, 0x9A, 0xBC,
    0xDD, 0xDD, 0xFD, 0xCB, 0xAA, 0x99, 0x88, 0x99, 0x9A, 0xBC, 0xCD, 0xFE,
    0xEF, 0xED, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBC, 0xCD, 0xEF, 0xED, 0xFF,
    0xED, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEE, 0xFE, 0xEF, 0xFF, 0xED,
    0xDD, 0xCC, 0xCC, 0xCC, 0xDD, 0xDF, 0xFF, 0xED, 0xFF, 0xFF, 0xEE, 0xED,
    0xDD, 0xDD, 0xEE, 0xEF, 0xFF, 0xFE, 0x9E, 0xDD, 0xED, 0xDD, 0xDD, 0xDD,
    0xED, 0xDD, 0xDE, 0xEE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0x9B, 0xDC,
    0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xED, 0xBC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xCD, 0xCB, 0xBB, 0xAA, 0x99, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xBC, 0xDC, 0xAB, 0xAA, 0x99, 0x88, 0x77, 0x77,
    0x88, 0x89, 0xAA, 0xCC, 0xCA, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAB, 0xCB, 0xAA, 0x99, 0x87, 0x77, 0x66, 0x66, 0x67, 0x78, 0x9A,
    0xAB, 0xBA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xBA, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0xAA, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xAA, 0xA9, 0x87, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0xAA, 0x98, 0x87, 0x66, 0x66, 0x66,
    0x67, 0x78, 0x89, 0xAB, 0xBA, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBB, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xBB, 0xBB, 0xA9, 0x88, 0x87, 0x77, 0x78, 0x88, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xA9, 0x98, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBC, 0xCC, 0xDC,
    0xBB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDC, 0xCD, 0xDC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xCC, 0xDD, 0xCC, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEC, 0x8D, 0xCC, 0xCB, 0xBB, 0xBA, 0xAA,
    0xBB, 0xBB, 0xBC, 0xCD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xBC, 0x9B, 0xCC,
    0xBB, 0xAA, 0xAA, 0x99, 0xAA, 0xAA, 0xBB, 0xCD, 0xDC, 0xAB, 0xBA, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xBB, 0xCC, 0xCA, 0xBA, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xBB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xA9, 0x98, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBB, 0x9A, 0x99, 0x87, 0x77, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x65, 0x56, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x66, 0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x87, 0x66, 0x66, 0x66,
    0x67, 0x78, 0x89, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x67, 0x77,
    0x89, 0x9A, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x87, 0x77, 0x78, 0x88, 0x99, 0xAA, 0xBB,
    0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x99, 0xAA, 0xBB, 0xBB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xBA,
    0xAA, 0xA9, 0x9A, 0xAA, 0xAB, 0xBB, 0xCC, 0xBC, 0xDC, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xCC, 0xDC, 0x9C, 0xCB, 0xBB, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0xAA, 0x99, 0x9A, 0xAA, 0xAB, 0xBB, 0xCC, 0x8B, 0xCC,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDC, 0xBC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xCD, 0xCB, 0xBB, 0xAA, 0x99, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xBC, 0xCC, 0xAB, 0xAA, 0x99, 0x88, 0x87, 0x77,
    0x88, 0x89, 0x9A, 0xBC, 0xBA, 0xAA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAB, 0xBB, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x67, 0x78, 0x9A,
    0xAB, 0xBA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xAA, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xA9, 0xA9, 0x87, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0xAA, 0x98, 0x87, 0x66, 0x66, 0x66,
    0x67, 0x78, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x67, 0x77,
    0x89, 0xAA, 0xBA, 0xAB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x78, 0x89, 0x9A,
    0xAB, 0xBB, 0xBA, 0xA9, 0x88, 0x87, 0x77, 0x88, 0x89, 0x9A, 0xAB, 0xBB,
    0xBC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBC, 0xBB, 0xCC,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCB, 0xCD, 0xCC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xCD, 0xDD, 0xCC, 0xCB, 0xBB,
    0xBA, 0xBB, 0xBB, 0xBC, 0xCD, 0xDC, 0x9C, 0xCB, 0xBB, 0xBA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDC, 0xCC, 0xCC, 0xBB, 0xBB, 0xCC, 0xCC, 0xDD, 0xDD, 0x8D, 0xEE,
    0xDD, 0xCC, 0xCC, 0xCB, 0xCC, 0xDD, 0xEF, 0xEE, 0xFE, 0xDE, 0xDC, 0xCC,
    0xBB, 0xAB, 0xBB, 0xBB, 0xCC, 0xDD, 0xFF, 0xED, 0xDD, 0xCB, 0xBA, 0xA9,
    0x99, 0xAA, 0xAB, 0xBC, 0xDD, 0xFD, 0xCD, 0xCB, 0xAA, 0x99, 0x88, 0x88,
    0x99, 0xAA, 0xBC, 0xDE, 0xDC, 0xCB, 0xAA, 0x98, 0x87, 0x77, 0x78, 0x89,
    0xAA, 0xCD, 0xDD, 0xCC, 0xBA, 0x98, 0x87, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCE, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x8A, 0xBC, 0xDD,
    0xCC, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x9B, 0xBC, 0xDB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x45, 0x67, 0x89, 0xAC, 0xCC, 0xCB, 0xB9, 0x87,
    0x65, 0x54, 0x34, 0x56, 0x78, 0x9A, 0xCC, 0xCC, 0xCA, 0x98, 0x76, 0x55,
    0x54, 0x56, 0x67, 0x89, 0xAB, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x89, 0x9A, 0xCC, 0xCC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDC, 0xCC, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x88, 0x9A, 0xBB,
    0xCD, 0xDD, 0xEC, 0xCB, 0xA9, 0x98, 0x88, 0x89, 0x9A, 0xAB, 0xCC, 0xDD,
    0xDD, 0xEC, 0xBB, 0xAA, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDD, 0xDD, 0xFE,
    0xDC, 0xCB, 0xBB, 0xAA, 0xAB, 0xBB, 0xBC, 0xDD, 0xED, 0xEF, 0xEE, 0xDD,
    0xCC, 0xCB, 0xBB, 0xCC, 0xCC, 0xDD, 0xDE, 0xEE, 0xFF, 0xEE, 0xDE, 0xDD,
    0xCD, 0xDC, 0xDD, 0xED, 0xEF, 0xEE, 0x9E, 0xEE, 0xDD, 0xDD, 0xDC, 0xCC,
    0xCC, 0xCD, 0xDD, 0xDE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xED, 0xDD, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDC, 0xCB,
    0xBB, 0xCC, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xDC, 0xBA, 0xAA, 0xAA,
    0xBB, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0x98, 0x88, 0x89, 0xAB,
    0xCD, 0xFF, 0xFF, 0xFF, 0xEC, 0xBA, 0x98, 0x76, 0x67, 0x89, 0xAB, 0xDD,
    0xFF, 0xFF, 0xED, 0xCA, 0x98, 0x66, 0x55, 0x66, 0x89, 0xBC, 0xDF, 0xFF,
    0xFF, 0xDB, 0xA8, 0x76, 0x54, 0x44, 0x67, 0x8A, 0xBC, 0xFF, 0xFF, 0xFD,
    0xBA, 0x87, 0x54, 0x33, 0x45, 0x68, 0xAB, 0xEF, 0xFF, 0xFF, 0xDB, 0xA8,
    0x65, 0x43, 0x34, 0x56, 0x8A, 0xBD, 0xEF, 0xFE, 0xFD, 0xCA, 0x87, 0x64,
    0x44, 0x56, 0x78, 0xAB, 0xDE, 0xFF, 0xEF, 0xDC, 0xB9, 0x86, 0x65, 0x56,
    0x67, 0x9A, 0xCD, 0xFF, 0xFE, 0xFF, 0xDC, 0xA9, 0x87, 0x66, 0x77, 0x8A,
    0xBC, 0xDF, 0xFF, 0xEF, 0xFD, 0xCB, 0xA9, 0x88, 0x88, 0x9A, 0xBB, 0xDE,
    0xFF, 0xFF, 0xFF, 0xED, 0xCB, 0xAA, 0xA9, 0xAA, 0xBB, 0xCD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDD, 0xDC, 0xCB, 0xBB, 0xBC, 0xCE, 0xFF, 0xFF, 0xFD, 0xFF,
    0xFF, 0xFF, 0xDD, 0xDD, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xDD, 0xDD, 0xDF, 0xEE, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xED, 0xED, 0xDD, 0xCC, 0xCD, 0xDD, 0xDD, 0xED, 0xDE, 0x9E, 0xFF,
    0xFE, 0xDD, 0xDC, 0xCC, 0xDD, 0xDE, 0xEE, 0xFE, 0xFE, 0xFE, 0xED, 0xDD,
    0xCC, 0xBB, 0xBB, 0xCC, 0xDD, 0xEE, 0xEF, 0xED, 0xFE, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBC, 0xCD, 0xEF, 0xFF, 0xDE, 0xDC, 0xBA, 0xA9, 0x99, 0x99,
    0x9A, 0xBC, 0xCD, 0xEF, 0xEC, 0xDC, 0xBB, 0xA9, 0x88, 0x77, 0x88, 0x9A,
    0xBC, 0xCE, 0xEE, 0xDD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x78, 0x9A, 0xBC,
    0xEF, 0xDD, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xCD, 0xEE,
    0xDC, 0xBA, 0x98, 0x66, 0x54, 0x45, 0x56, 0x89, 0xAC, 0xCD, 0xDC, 0xCB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xED, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAB, 0xDD, 0xDD, 0xDB, 0xA9, 0x86, 0x55,
    0x44, 0x55, 0x67, 0x9A, 0xBD, 0xDD, 0xDE, 0xCB, 0x98, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAB, 0xDE, 0xED, 0xDC, 0xBA, 0x98, 0x76, 0x66, 0x67, 0x89,
    0xAB, 0xCD, 0xEE, 0xDE, 0xDC, 0xAA, 0x98, 0x87, 0x78, 0x89, 0x9A, 0xBC,
    0xDE, 0xED, 0xED, 0xDB, 0xBA, 0x99, 0x99, 0x99, 0x9A, 0xBC, 0xDD, 0xEF,
    0xEE, 0xED, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xEF, 0xFD, 0xEF,
    0xDD, 0xDC, 0xCB, 0xBB, 0xBB, 0xCC, 0xDE, 0xEE, 0xFF, 0xDF, 0xFF, 0xED,
    0xDD, 0xCC, 0xDD, 0xCD, 0xDE, 0xEF, 0xFF, 0xFD, 0xFF, 0xFF, 0xEE, 0xEE,
    0xDF, 0xDE, 0xEE, 0xEF, 0xFF, 0xFF, 0x9D, 0xED, 0xDE, 0xDE, 0xDE, 0xED,
    0xEE, 0xEE, 0xFF, 0xEF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xDE, 0xED, 0xDC, 0xCC, 0xBC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDD, 0xAE, 0xFE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xCC, 0xCC, 0xDE, 0xEF, 0xFE, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xEF, 0xED, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAB, 0xBC, 0xDE, 0xEE, 0xCD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0xAA, 0xBC, 0xDE, 0xEC, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x89,
    0xAA, 0xCC, 0xED, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDC, 0xBA, 0x98, 0x87, 0x65, 0x55, 0x56, 0x77, 0x89, 0xBC, 0xDD,
    0xCB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xDB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCC, 0xBA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xCC, 0xBA, 0x87, 0x76, 0x55, 0x55,
    0x67, 0x78, 0x9A, 0xBD, 0xDC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xDD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x88, 0x99, 0xAB,
    0xCD, 0xDD, 0xDC, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xDE,
    0xDE, 0xDC, 0xBB, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xEE, 0xEE,
    0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFE, 0xDF, 0xED, 0xDD,
    0xCC, 0xCB, 0xBB, 0xBC, 0xCC, 0xDE, 0xEF, 0xED, 0xFF, 0xEE, 0xED, 0xDD,
    0xCD, 0xCD, 0xDD, 0xEE, 0xFF, 0xFF, 0xAE, 0xEE, 0xDD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDE, 0xEE, 0xEF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xED, 0xDD, 0xDC, 0xDC, 0xDC, 0xCC, 0xCD, 0xDD, 0xDD, 0x8E, 0xFE,
    0xEE, 0xDD, 0xDC, 0xCC, 0xCD, 0xDD, 0xEE, 0xEE, 0xFE, 0xEF, 0xEE, 0xDC,
    0xCC, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xEF, 0xDE, 0xFE, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAB, 0xBC, 0xCD, 0xDD, 0xED, 0xDE, 0xDC, 0xBB, 0xA9, 0x99, 0x99,
    0x9A, 0xBB, 0xCD, 0xDF, 0xDD, 0xEC, 0xBA, 0x99, 0x88, 0x77, 0x88, 0x9A,
    0xBB, 0xDD, 0xFD, 0xDD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x78, 0x9A, 0xBC,
    0xDD, 0xEC, 0xDC, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xEC,
    0xCC, 0xBA, 0x98, 0x75, 0x54, 0x45, 0x56, 0x89, 0xAB, 0xCE, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAB, 0xCD, 0xDC, 0xDC, 0xA9, 0x86, 0x55,
    0x44, 0x55, 0x78, 0x9A, 0xBC, 0xDD, 0xDD, 0xCA, 0x98, 0x76, 0x55, 0x56,
    0x67, 0x89, 0xAC, 0xDD, 0xDD, 0xDC, 0xBA, 0x98, 0x76, 0x66, 0x77, 0x89,
    0xAB, 0xBD, 0xED, 0xCD, 0xDC, 0xB9, 0x98, 0x87, 0x78, 0x89, 0x9A, 0xBC,
    0xDE, 0xED, 0xDE, 0xCB, 0xBA, 0x99, 0x98, 0x99, 0xAB, 0xBB, 0xCD, 0xEE,
    0xDE, 0xED, 0xDC, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xEE, 0xDD, 0xEE,
    0xDC, 0xDC, 0xBC, 0xBC, 0xBB, 0xCC, 0xCD, 0xDD, 0xFD, 0xDF, 0xEE, 0xDE,
    0xDC, 0xCD, 0xCD, 0xDD, 0xDD, 0xDE, 0xEE, 0xED, 0xEF, 0xEF, 0xFF, 0xEE,
    0xED, 0xDE, 0xED, 0xDD, 0xFF, 0xFD, 0x9D, 0xDD, 0xDE, 0xCD, 0xDC, 0xDD,
    0xDD, 0xED, 0xDE, 0xEF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFD, 0xDF, 0xDD, 0x8F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDC,
    0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCC, 0xBB, 0xBB,
    0xCC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xBB, 0xA9, 0x99, 0x9A, 0xBC,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0x98, 0x87, 0x78, 0x8A, 0xBC, 0xFF,
    0xFF, 0xFF, 0xFF, 0xCB, 0xA8, 0x76, 0x55, 0x67, 0x9A, 0xCD, 0xFF, 0xFF,
    0xFF, 0xFD, 0xB9, 0x76, 0x54, 0x45, 0x68, 0x9B, 0xCF, 0xFF, 0xFF, 0xFF,
    0xCB, 0x97, 0x54, 0x23, 0x45, 0x79, 0xBC, 0xFF, 0xFF, 0xFF, 0xFC, 0xA9,
    0x75, 0x43, 0x24, 0x57, 0x9B, 0xCF, 0xFF, 0xFF, 0xFF, 0xDB, 0x98, 0x65,
    0x44, 0x56, 0x79, 0xBC, 0xFF, 0xFF, 0xFF, 0xFD, 0xCA, 0x87, 0x65, 0x56,
    0x78, 0xAB, 0xCF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0x88, 0x77, 0x78, 0x9A,
    0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBA, 0x99, 0x99, 0xAA, 0xCD, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBB, 0xBA, 0xBB, 0xCD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xDD, 0xFC, 0xCC, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xDD, 0x9E, 0xEF,
    0xDD, 0xCC, 0xCB, 0xCC, 0xCC, 0xCD, 0xDE, 0xFF, 0xFE, 0xDE, 0xED, 0xCC,
    0xCB, 0xBA, 0xBA, 0xBB, 0xCD, 0xCD, 0xEE, 0xEE, 0xED, 0xCC, 0xBA, 0xA9,
    0x99, 0x9A, 0xBB, 0xBD, 0xDD, 0xFE, 0xDE, 0xCB, 0xBA, 0x99, 0x88, 0x88,
    0x99, 0xAB, 0xBC, 0xDE, 0xDC, 0xCC, 0xBA, 0x98, 0x87, 0x77, 0x78, 0x89,
    0xAB, 0xCD, 0xEE, 0xCD, 0xBA, 0x98, 0x87, 0x66, 0x66, 0x78, 0x89, 0xBB,
    0xCE, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xCC, 0xBA, 0x87, 0x66, 0x54, 0x45, 0x56, 0x78, 0x9B, 0xCD, 0xCB, 0xCB,
    0x98, 0x76, 0x55, 0x44, 0x45, 0x67, 0x89, 0xBC, 0xCD, 0xCC, 0xB9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xCB, 0xA8, 0x76, 0x65,
    0x44, 0x56, 0x67, 0x89, 0xAC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCC, 0xA9, 0x88, 0x76, 0x66, 0x67, 0x88,
    0x9A, 0xBC, 0xDD, 0xCD, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x88, 0x9A, 0xBC,
    0xDD, 0xDC, 0xEC, 0xBB, 0xA9, 0x98, 0x88, 0x99, 0x99, 0xBB, 0xCD, 0xDD,
    0xCE, 0xDC, 0xCB, 0xAA, 0xA9, 0x99, 0xAA, 0xBB, 0xBD, 0xDF, 0xDD, 0xEE,
    0xDD, 0xCB, 0xBB, 0xBA, 0xAB, 0xBC, 0xCD, 0xDE, 0xFE, 0xDE, 0xEE, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xEF, 0xED, 0xFF, 0xEE, 0xDD, 0xDD,
    0xDC, 0xDE, 0xDD, 0xEE, 0xEF, 0xFD, 0x8D, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC,
    0xDC, 0xDD, 0xDE, 0xDE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0x8C, 0xDC,
    0xCB, 0xBB, 0xBA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDC, 0xBC, 0xCB, 0xBA,
    0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDC, 0xCB, 0xCB, 0xBA, 0xA9, 0x98,
    0x88, 0x99, 0x99, 0xAB, 0xBC, 0xDC, 0xBC, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x99, 0xAB, 0xCC, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xCB, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBC, 0xBA, 0xA9, 0x98, 0x77, 0x66, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xBB,
    0xAA, 0x99, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xBA, 0xA9,
    0x87, 0x76, 0x55, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0x98, 0x77,
    0x65, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xBA, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0xA9, 0x87, 0x66, 0x65, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xBA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x89, 0xAB, 0xBB, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xBB, 0xBB, 0xA9, 0x98, 0x88, 0x77, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xA9, 0x99, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCD, 0xCC, 0xCC,
    0xBA, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xEC, 0xCD, 0xDC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCC, 0xDE, 0xCC, 0xED, 0xCC, 0xCC, 0xCB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xDD, 0x8C, 0xCB, 0xCB, 0xBB, 0xBB, 0xBB,
    0xBB, 0xCB, 0xCC, 0xCC, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0x9B, 0xCB,
    0xBA, 0xAA, 0xA9, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xDC, 0xAB, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xBA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0xAA, 0xBB, 0xA9, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBA, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x99,
    0xAA, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x65, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x67, 0x78, 0x89, 0xAA, 0xA9, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x67, 0x77,
    0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x87, 0x77, 0x78, 0x88, 0x99, 0xAA, 0xBA,
    0xAB, 0xBA, 0x99, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xBB, 0xBB,
    0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xBA,
    0xAA, 0xA9, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xBB, 0xCC, 0xCB, 0xBB, 0xBA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDC, 0x9B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0x8B, 0xDC,
    0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCC, 0xDB, 0xBC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCD, 0xBB, 0xBB, 0xAA, 0x99, 0x98,
    0x88, 0x99, 0x9A, 0xAB, 0xBB, 0xDB, 0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x99, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBB, 0xBA, 0xA9, 0x98, 0x77, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xBA,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xAA, 0xA9,
    0x88, 0x76, 0x55, 0x55, 0x55, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x98, 0x87,
    0x65, 0x54, 0x55, 0x56, 0x78, 0x89, 0xAB, 0xAA, 0xAA, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAB, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x67, 0x78, 0x99, 0xAB, 0xAA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x89, 0xAA, 0xBA, 0xAB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89, 0x9A,
    0xBB, 0xBA, 0xBB, 0xAA, 0x98, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xAA, 0x99, 0x98, 0x88, 0x99, 0x9A, 0xAB, 0xCC, 0xBB, 0xCC,
    0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xCB, 0xBC, 0xCC, 0xBB,
    0xAB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xBC, 0xDC, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDC, 0x8B, 0xBB, 0xBB, 0xAA, 0xAA, 0xAA,
    0xAA, 0xBB, 0xBC, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xBE, 0xDD, 0xCC, 0xCC, 0xCC, 0xBC, 0xCC, 0xCC, 0xCC, 0xDC, 0x8E, 0xEE,
    0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEF, 0xFD, 0xEE, 0xED, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEE, 0xDD, 0xED, 0xCC, 0xBA, 0xAA,
    0xA9, 0xAA, 0xAB, 0xCC, 0xDE, 0xFD, 0xCD, 0xDC, 0xBA, 0x99, 0x98, 0x89,
    0x9A, 0xAB, 0xCC, 0xDE, 0xDC, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x78, 0x99,
    0xAB, 0xCD, 0xED, 0xCD, 0xBB, 0x99, 0x87, 0x66, 0x66, 0x78, 0x8A, 0xBB,
    0xCD, 0xDD, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xBC, 0xBA, 0x97, 0x66, 0x54, 0x45, 0x66, 0x89, 0xAB, 0xCD, 0xCC, 0xCB,
    0x98, 0x76, 0x54, 0x44, 0x45, 0x67, 0x89, 0xBC, 0xDD, 0xBC, 0xBA, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x78, 0x9A, 0xCD, 0xCC, 0xCB, 0xA9, 0x86, 0x65,
    0x44, 0x56, 0x67, 0x9A, 0xAC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCC, 0xA9, 0x98, 0x76, 0x66, 0x67, 0x88,
    0x9A, 0xBC, 0xDD, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDD, 0xDC, 0xDD, 0xCB, 0xA9, 0x99, 0x88, 0x99, 0x9A, 0xAB, 0xCD, 0xDD,
    0xCD, 0xDD, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBC, 0xCD, 0xEF, 0xDD, 0xEE,
    0xDC, 0xCB, 0xBB, 0xBA, 0xBB, 0xBC, 0xCC, 0xDE, 0xEE, 0xEE, 0xFE, 0xDD,
    0xCC, 0xBC, 0xCC, 0xCC, 0xDD, 0xDE, 0xFF, 0xED, 0xFE, 0xEE, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDD, 0xEE, 0xEF, 0xFD, 0x9D, 0xED, 0xCC, 0xDC, 0xCC, 0xDC,
    0xDD, 0xDD, 0xEE, 0xED, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xEE, 0xFE, 0x9F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xDC,
    0xDC, 0xDD, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDC, 0xBB, 0xBB,
    0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDB, 0xAA, 0x9A, 0xAB, 0xCC,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x88, 0x88, 0x9A, 0xBD, 0xEF,
    0xFF, 0xFF, 0xFF, 0xDC, 0xA9, 0x87, 0x66, 0x78, 0x9B, 0xCD, 0xFF, 0xFF,
    0xFF, 0xFD, 0xBA, 0x86, 0x54, 0x45, 0x78, 0xAC, 0xDE, 0xFF, 0xFF, 0xFF,
    0xDB, 0x98, 0x64, 0x22, 0x46, 0x89, 0xBC, 0xFF, 0xFF, 0xFF, 0xFD, 0xBA,
    0x86, 0x42, 0x24, 0x68, 0x9B, 0xDE, 0xFF, 0xFD, 0xFF, 0xCC, 0xA8, 0x75,
    0x44, 0x56, 0x8A, 0xBD, 0xFF, 0xFF, 0xFF, 0xED, 0xCB, 0x98, 0x76, 0x66,
    0x79, 0xAC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFC, 0xCA, 0x98, 0x88, 0x89, 0xAB,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBB, 0xAA, 0x9A, 0xAB, 0xCD, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFE, 0xDD, 0xCB, 0xBB, 0xBC, 0xCD, 0xEF, 0xFF, 0xFF,
    0xEF, 0xFE, 0xFE, 0xDD, 0xDC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF,
    0xFF, 0xFF, 0xEF, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF,
    0xEF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xDD, 0xDD, 0xDE, 0xDE, 0xDE,
    0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xCC, 0xDD, 0x9E, 0xEE,
    0xEE, 0xED, 0xDC, 0xCD, 0xCD, 0xDD, 0xDD, 0xEF, 0xED, 0xEE, 0xDD, 0xCC,
    0xCC, 0xBB, 0xCB, 0xCC, 0xDD, 0xDE, 0xEF, 0xDD, 0xEE, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAB, 0xBC, 0xCC, 0xDE, 0xEE, 0xDE, 0xDC, 0xBA, 0xA9, 0x99, 0x99,
    0xAA, 0xBC, 0xCC, 0xDE, 0xDC, 0xDC, 0xBA, 0x99, 0x88, 0x78, 0x88, 0x9A,
    0xBC, 0xCD, 0xDD, 0xCD, 0xCB, 0xA9, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xDE, 0xDC, 0xDB, 0xA9, 0x87, 0x65, 0x55, 0x56, 0x78, 0xAB, 0xCD, 0xED,
    0xCD, 0xBA, 0x98, 0x65, 0x54, 0x45, 0x57, 0x89, 0xBB, 0xCD, 0xDC, 0xDB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x68, 0x9A, 0xBC, 0xDD, 0xDD, 0xBA, 0x98,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAB, 0xCD, 0xDC, 0xDB, 0xA9, 0x87, 0x55,
    0x44, 0x55, 0x68, 0x9A, 0xCC, 0xED, 0xCC, 0xCB, 0xA8, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAB, 0xDD, 0xDC, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x89,
    0xAB, 0xCD, 0xED, 0xCD, 0xCC, 0xBA, 0x98, 0x88, 0x78, 0x89, 0x9A, 0xCC,
    0xDE, 0xEC, 0xDC, 0xCB, 0xBA, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xDD, 0xEE,
    0xDD, 0xDD, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDE, 0xEE, 0xED, 0xED,
    0xDD, 0xDC, 0xCB, 0xBB, 0xBB, 0xBD, 0xCD, 0xFE, 0xEE, 0xCE, 0xEE, 0xDD,
    0xDD, 0xDC, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEC, 0xFE, 0xEE, 0xFE, 0xFD,
    0xDD, 0xDD, 0xEE, 0xEF, 0xEF, 0xFE, 0x8D, 0xDC, 0xDD, 0xDD, 0xCD, 0xDD,
    0xDD, 0xDD, 0xDE, 0xFE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xCC, 0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDD, 0xAD, 0xEE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xDE, 0xFD, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xEE, 0xDD, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xCD, 0xDD, 0xCD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0xAA, 0xBC, 0xDD, 0xCC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xDC, 0xCC, 0xAA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xCB, 0xBA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x78, 0x89, 0xAC, 0xCC,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xDC, 0xBB, 0xB9, 0x88, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDC, 0xDC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCC, 0xED,
    0xCD, 0xCC, 0xBA, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDE, 0xDD, 0xDD,
    0xDC, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFE, 0xDE, 0xDD, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xED, 0xEE, 0xED, 0xDD, 0xCC,
    0xCC, 0xCC, 0xDD, 0xDE, 0xEF, 0xFF, 0xAD, 0xDD, 0xCD, 0xCC, 0xCC, 0xCC,
    0xCD, 0xDD, 0xDE, 0xEE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xDD, 0xDC, 0xCC, 0xCC, 0xCB, 0xCC, 0xCC, 0xCC, 0xDC, 0x9D, 0xFE,
    0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xDE, 0xED, 0xDE, 0xED, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xDD, 0xEC, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xDC, 0xCD, 0xDC, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xAB, 0xBC, 0xDE, 0xCC, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A,
    0xAB, 0xCC, 0xDC, 0xCC, 0xBA, 0xA8, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBB,
    0xCD, 0xCC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xCC, 0xBA, 0x98, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAB, 0xCD, 0xCC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x68, 0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xCB, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0xAA, 0xBC, 0xDC, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x89, 0x9A, 0xBC,
    0xDE, 0xDC, 0xDC, 0xBB, 0xAA, 0x99, 0x98, 0x99, 0x9A, 0xBB, 0xCD, 0xED,
    0xCD, 0xDC, 0xCB, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xEE, 0xDC, 0xED,
    0xCC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xED, 0xDE, 0xDD, 0xDC,
    0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xEF, 0xDD, 0xEE, 0xED, 0xDD, 0xDD,
    0xDC, 0xDD, 0xDD, 0xEE, 0xEF, 0xFE, 0x9D, 0xDC, 0xDC, 0xCC, 0xCC, 0xCC,
    0xCC, 0xDD, 0xDD, 0xDE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFE, 0xEE, 0xDD, 0xDD, 0xDD, 0xDC, 0xDD, 0xDD, 0x8F, 0xFF,
    0xFF, 0xFF, 0xEE, 0xED, 0xDF, 0xDE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xED,
    0xDC, 0xDD, 0xDC, 0xDD, 0xDE, 0xFF, 0xFF, 0xEE, 0xFF, 0xDD, 0xDC, 0xCB,
    0xBB, 0xBB, 0xCC, 0xDE, 0xFF, 0xFE, 0xFF, 0xED, 0xDC, 0xBA, 0xAA, 0xAA,
    0xAB, 0xCD, 0xDE, 0xFF, 0xED, 0xFE, 0xDC, 0xBA, 0x98, 0x88, 0x89, 0xAB,
    0xCD, 0xEF, 0xFF, 0xDF, 0xDC, 0xBA, 0x98, 0x76, 0x77, 0x89, 0xAB, 0xCD,
    0xFF, 0xFE, 0xED, 0xCA, 0x98, 0x66, 0x55, 0x67, 0x89, 0xBC, 0xDE, 0xFE,
    0xED, 0xDB, 0xA8, 0x76, 0x44, 0x44, 0x67, 0x8A, 0xBD, 0xDF, 0xFD, 0xFC,
    0xBA, 0x86, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xCE, 0xFE, 0xEE, 0xCB, 0xA8,
    0x75, 0x43, 0x34, 0x57, 0x89, 0xBC, 0xFF, 0xFE, 0xED, 0xBA, 0x87, 0x65,
    0x44, 0x45, 0x78, 0xAB, 0xDE, 0xFF, 0xDF, 0xDC, 0xA9, 0x87, 0x65, 0x56,
    0x68, 0x9A, 0xCD, 0xEF, 0xFE, 0xEE, 0xCB, 0xA9, 0x87, 0x76, 0x78, 0x8A,
    0xBC, 0xDF, 0xFF, 0xDE, 0xED, 0xCB, 0xA9, 0x98, 0x88, 0x9A, 0xBC, 0xDE,
    0xFF, 0xFE, 0xEE, 0xDD, 0xCB, 0xAA, 0x99, 0xAA, 0xBC, 0xCE, 0xFF, 0xFF,
    0xEF, 0xFF, 0xDD, 0xCC, 0xBB, 0xBB, 0xCC, 0xDE, 0xEF, 0xFF, 0xFE, 0xFE,
    0xEF, 0xDD, 0xDC, 0xCD, 0xCD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF,
    0xEE, 0xED, 0xDE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9E, 0xDF, 0xFF, 0xFF, 0xFD, 0xFE,
    0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0x9E, 0xFF,
    0xEE, 0xDE, 0xDC, 0xCC, 0xCD, 0xDD, 0xEE, 0xEF, 0xFE, 0xFF, 0xED, 0xDC,
    0xCB, 0xBB, 0xBB, 0xCC, 0xCD, 0xEE, 0xFF, 0xDD, 0xFE, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCD, 0xDD, 0xEE, 0xDE, 0xDC, 0xBA, 0xA9, 0x99, 0x99,
    0x9A, 0xAB, 0xDE, 0xDE, 0xDD, 0xEC, 0xCA, 0x99, 0x88, 0x77, 0x88, 0x9A,
    0xBB, 0xCD, 0xED, 0xCD, 0xCB, 0xA9, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xDD, 0xDC, 0xDB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xED,
    0xCC, 0xCA, 0x98, 0x65, 0x54, 0x45, 0x66, 0x89, 0xAB, 0xDD, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBD, 0xDC, 0xCC, 0xBA, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xEC, 0xCB, 0xA9, 0x86, 0x65,
    0x44, 0x55, 0x68, 0x9A, 0xBD, 0xDD, 0xCD, 0xCB, 0x98, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAC, 0xDE, 0xDC, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x89,
    0xAB, 0xCD, 0xFD, 0xCE, 0xCB, 0xBA, 0x98, 0x87, 0x77, 0x89, 0x9A, 0xBC,
    0xEE, 0xDC, 0xDD, 0xCB, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xFE,
    0xDE, 0xDD, 0xCC, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xED, 0xEE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBB, 0xCD, 0xDE, 0xEF, 0xFF, 0xDE, 0xEE, 0xDE,
    0xDD, 0xCC, 0xCD, 0xDE, 0xEE, 0xEF, 0xFF, 0xED, 0xFF, 0xFE, 0xEE, 0xDD,
    0xDD, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0x8D, 0xCD, 0xCD, 0xDD, 0xDC, 0xCD,
    0xED, 0xEE, 0xEE, 0xFF, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0x8B, 0xCC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDC, 0xBC, 0xCB, 0xAA,
    0xAA, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCD, 0xBB, 0xBB, 0xAA, 0x99, 0x98,
    0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xCB, 0xBB, 0xAA, 0x99, 0x88, 0x87, 0x88,
    0x89, 0x99, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xCB, 0xAB, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBB, 0xBA, 0xAA, 0x98, 0x76, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xBA, 0xA9,
    0x88, 0x76, 0x55, 0x55, 0x55, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x98, 0x87,
    0x65, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xBA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xBA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xAB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xBA, 0xCB, 0xAA, 0x98, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xAA, 0x99, 0x98, 0x88, 0x89, 0x9A, 0xAB, 0xCC, 0xCB, 0xCC,
    0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDC, 0xBC, 0xCC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xCC, 0xDD, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xED, 0x8C, 0xBB, 0xBB, 0xBB, 0xAB, 0xAB,
    0xBB, 0xBC, 0xCC, 0xCD, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0x8B, 0xCC,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xCB, 0xBB, 0xBA, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBA, 0xBA, 0xA9, 0x99, 0x88,
    0x88, 0x89, 0x99, 0xAA, 0xBB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x88,
    0x88, 0x99, 0xAA, 0xBB, 0xAA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAA, 0xBA, 0x9A, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x99,
    0xAB, 0xA9, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x89, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x88, 0x9A, 0xAA, 0x9A, 0x98, 0x87,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x99, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAB, 0xA9, 0xA9, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBA, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0xAA, 0xBA, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xBB,
    0xAB, 0xBA, 0xA9, 0x99, 0x88, 0x88, 0x89, 0x99, 0xAA, 0xBC, 0xBA, 0xCB,
    0xBA, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xBB, 0xDC, 0xCB, 0xBB, 0xBA,
    0xAA, 0xBB, 0xBB, 0xBC, 0xCD, 0xDC, 0x9B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0x8B, 0xCC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDB, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0xCD, 0xBB, 0xCB, 0xAA, 0x99, 0x98,
    0x88, 0x99, 0x99, 0xAB, 0xBC, 0xCB, 0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x9A, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xAB, 0xBB, 0xAB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBB, 0xBA, 0xAA, 0x98, 0x76, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xBB,
    0xAA, 0xA8, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xAA, 0xA9,
    0x88, 0x76, 0x55, 0x55, 0x55, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x98, 0x87,
    0x65, 0x55, 0x55, 0x56, 0x78, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xAA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xAB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBB, 0xBA, 0xBB, 0xA9, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xBB, 0xCB,
    0xBC, 0xBB, 0xAA, 0x99, 0x98, 0x88, 0x99, 0x9A, 0xAB, 0xCD, 0xBB, 0xCC,
    0xBB, 0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xAB, 0xBC, 0xDC, 0xBC, 0xCC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xCB, 0xDD, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xCC, 0xCC, 0xDD, 0xDC, 0x8B, 0xBB, 0xBB, 0xBB, 0xAA, 0xAA,
    0xAB, 0xBB, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xEC, 0xCC, 0xCB, 0xCB, 0xBB, 0xCC, 0xCC, 0xCC, 0xCD, 0x8D, 0xED,
    0xED, 0xDC, 0xCB, 0xBB, 0xBC, 0xCD, 0xCD, 0xEF, 0xFD, 0xDE, 0xED, 0xCB,
    0xBB, 0xAA, 0xAA, 0xBB, 0xCC, 0xCE, 0xEE, 0xDD, 0xDD, 0xCB, 0xBA, 0x99,
    0x99, 0x9A, 0xAA, 0xBC, 0xDE, 0xED, 0xDD, 0xCB, 0xBA, 0x99, 0x88, 0x88,
    0x99, 0xAA, 0xBC, 0xDD, 0xDC, 0xDB, 0xAA, 0x98, 0x87, 0x77, 0x78, 0x89,
    0xAB, 0xBC, 0xDC, 0xCD, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x78, 0x89, 0xAB,
    0xCD, 0xCB, 0xCA, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x99, 0xBC, 0xDC,
    0xBB, 0xA9, 0x87, 0x66, 0x54, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x54, 0x44, 0x55, 0x67, 0x89, 0xAC, 0xCC, 0xCC, 0xA9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBC, 0xDB, 0xCB, 0x98, 0x76, 0x65,
    0x54, 0x55, 0x67, 0x89, 0xAC, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x88, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDC, 0xCC, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x88, 0x9A, 0xBC,
    0xDD, 0xDC, 0xDC, 0xBA, 0xA9, 0x98, 0x88, 0x89, 0x9A, 0xAB, 0xCD, 0xDD,
    0xCD, 0xDC, 0xBB, 0xAA, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xDE, 0xEC, 0xED,
    0xDC, 0xCB, 0xBA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xED, 0xDE, 0xED, 0xDC,
    0xCC, 0xBC, 0xBC, 0xCC, 0xDD, 0xDE, 0xFF, 0xED, 0xFF, 0xDD, 0xDD, 0xDD,
    0xCD, 0xDD, 0xDD, 0xEE, 0xEF, 0xFE, 0x9D, 0xDD, 0xDD, 0xDD, 0xCC, 0xCC,
    0xCC, 0xDD, 0xEE, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFE, 0xED, 0xDE, 0xDD, 0xDD, 0xDD, 0xDD, 0xCC, 0xDD, 0x9F, 0xFF,
    0xFF, 0xEE, 0xDE, 0xDD, 0xDD, 0xDE, 0xEE, 0xEF, 0xFD, 0xEF, 0xEF, 0xEE,
    0xDD, 0xCC, 0xCC, 0xCD, 0xCD, 0xEE, 0xFF, 0xDF, 0xFF, 0xED, 0xCC, 0xCB,
    0xBB, 0xBB, 0xCC, 0xDD, 0xDE, 0xFE, 0xDE, 0xDD, 0xCC, 0xAA, 0xAA, 0xAA,
    0xAB, 0xBC, 0xDD, 0xFF, 0xEE, 0xFD, 0xCB, 0xBA, 0x98, 0x88, 0x89, 0xAA,
    0xBC, 0xDF, 0xFF, 0xEE, 0xDC, 0xB9, 0x87, 0x77, 0x77, 0x89, 0xAB, 0xCD,
    0xEF, 0xEE, 0xEC, 0xBA, 0x97, 0x66, 0x55, 0x67, 0x89, 0xAB, 0xCE, 0xFE,
    0xDE, 0xCB, 0xA8, 0x76, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xDE, 0xED, 0xEC,
    0xB9, 0x87, 0x54, 0x33, 0x45, 0x78, 0x9B, 0xCE, 0xEE, 0xDD, 0xCB, 0x98,
    0x75, 0x43, 0x34, 0x56, 0x8A, 0xBC, 0xDF, 0xED, 0xEC, 0xCA, 0x87, 0x65,
    0x44, 0x45, 0x78, 0xAB, 0xDE, 0xEE, 0xDD, 0xDB, 0xA9, 0x87, 0x65, 0x55,
    0x67, 0x9A, 0xCD, 0xFF, 0xED, 0xDE, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x8A,
    0xBC, 0xEF, 0xFF, 0xDF, 0xDC, 0xBA, 0xA9, 0x88, 0x88, 0x9A, 0xBB, 0xCE,
    0xEF, 0xFD, 0xED, 0xDC, 0xCB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xEF, 0xFF,
    0xDF, 0xED, 0xDC, 0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEF, 0xFF, 0xFD, 0xEE,
    0xDD, 0xDD, 0xCC, 0xCD, 0xCD, 0xDD, 0xFF, 0xFF, 0xFF, 0xDF, 0xEF, 0xEF,
    0xDD, 0xEE, 0xDE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFE, 0xFE,
    0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0xDD, 0xDE, 0xDE, 0xED, 0xDD,
    0xEE, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0x9D, 0xFE,
    0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDE, 0xEF, 0xED, 0xDE, 0xDD, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xDD, 0xEF, 0xDD, 0xDD, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xDD, 0xED, 0xCD, 0xDB, 0xBA, 0x99, 0x98, 0x89,
    0x9A, 0xAB, 0xCC, 0xEE, 0xDC, 0xDC, 0xBA, 0x98, 0x88, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xDD, 0xCC, 0xBA, 0x98, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xAB,
    0xDD, 0xDC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBD, 0xDD,
    0xCC, 0xBA, 0x98, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCE, 0xDB, 0xCB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xDC, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCE, 0xDC, 0xCC, 0xAA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9B, 0xBD, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xEE, 0xDC, 0xDD, 0xCB, 0xAA, 0x99, 0x98, 0x99, 0xAA, 0xBC, 0xDE, 0xEE,
    0xCD, 0xDC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xFF, 0xEC, 0xDD,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xFE, 0xCF, 0xEE, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCD, 0xDE, 0xEF, 0xFF, 0xED, 0xEE, 0xED, 0xDD, 0xDD,
    0xDD, 0xDD, 0xEE, 0xFE, 0xFF, 0xFE, 0x8C, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xEE, 0xEE, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xDE, 0xDD, 0xCC, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xCC, 0xCC, 0x9E, 0xEE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xBC, 0xCC, 0xDD, 0xDE, 0xED, 0xDE, 0xDC, 0xCB,
    0xBB, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDE, 0xDD, 0xDD, 0xCB, 0xAA, 0xA9,
    0x99, 0x9A, 0xAA, 0xBC, 0xCD, 0xED, 0xCD, 0xCB, 0xAA, 0x98, 0x88, 0x88,
    0x99, 0xAA, 0xBC, 0xDD, 0xDC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x78, 0x89,
    0xAB, 0xBC, 0xDC, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x78, 0x89, 0xAB,
    0xCC, 0xCC, 0xCB, 0x99, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xCB, 0xA9, 0x87, 0x65, 0x54, 0x55, 0x67, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x54, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x87, 0x65,
    0x54, 0x55, 0x67, 0x89, 0xAC, 0xDC, 0xBC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0x9B, 0xCD, 0xCB, 0xCB, 0xA9, 0x88, 0x77, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xCD, 0xDC, 0xCC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xDD,
    0xCD, 0xCC, 0xBB, 0xAA, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDE, 0xEC, 0xDD,
    0xCC, 0xBB, 0xBA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xEE, 0xDE, 0xDD, 0xCC,
    0xCB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xEF, 0xED, 0xEE, 0xDD, 0xDD, 0xCC,
    0xCC, 0xCD, 0xDD, 0xEE, 0xEF, 0xFE, 0xAD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC,
    0xCD, 0xDD, 0xDE, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x9D, 0xFF,
    0xED, 0xDD, 0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xEE, 0xFD, 0xDE, 0xED, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEF, 0xDD, 0xDD, 0xCC, 0xBA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xEC, 0xDD, 0xDC, 0xBA, 0x99, 0x99, 0x99,
    0x9A, 0xAB, 0xCD, 0xDE, 0xDC, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A,
    0xAB, 0xCD, 0xED, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x78, 0x9A, 0xAC,
    0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xCC, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9A, 0xCC, 0xDD, 0xCD, 0xCB, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDD, 0xDC, 0xDD, 0xCB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xED,
    0xCD, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xEE, 0xDC, 0xED,
    0xDC, 0xCC, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFD, 0xCE, 0xED, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xFF, 0xED, 0xEE, 0xEE, 0xDE, 0xDD,
    0xDD, 0xDE, 0xDE, 0xEE, 0xFF, 0xFE, 0x9D, 0xDC, 0xCD, 0xDD, 0xCC, 0xCD,
    0xDD, 0xDD, 0xDE, 0xEE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xFF, 0xEE, 0xDD, 0xCD, 0xCC, 0xDC, 0xCC, 0xDD, 0xCD, 0x8F, 0xFF,
    0xFF, 0xFE, 0xED, 0xEE, 0xDD, 0xDE, 0xEE, 0xFF, 0xFD, 0xEF, 0xFF, 0xEE,
    0xDD, 0xCC, 0xCD, 0xDD, 0xDE, 0xEE, 0xEF, 0xDE, 0xFE, 0xED, 0xDC, 0xCB,
    0xBB, 0xBC, 0xCC, 0xDE, 0xEF, 0xFE, 0xEE, 0xEE, 0xCC, 0xBA, 0xAA, 0xAA,
    0xAB, 0xCC, 0xCE, 0xEF, 0xED, 0xED, 0xDC, 0xBA, 0x98, 0x88, 0x89, 0xAA,
    0xCD, 0xDE, 0xFE, 0xDE, 0xDC, 0xBA, 0x88, 0x77, 0x77, 0x89, 0xAB, 0xCD,
    0xEF, 0xEE, 0xED, 0xCB, 0x98, 0x65, 0x55, 0x67, 0x89, 0xAC, 0xDE, 0xFE,
    0xEE, 0xDB, 0xA9, 0x75, 0x44, 0x45, 0x67, 0x8A, 0xBD, 0xEF, 0xED, 0xEC,
    0xCA, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xCE, 0xFE, 0xDD, 0xCB, 0xA8,
    0x75, 0x43, 0x34, 0x57, 0x8A, 0xBD, 0xEF, 0xED, 0xDC, 0xBA, 0x97, 0x65,
    0x44, 0x45, 0x78, 0xAB, 0xDE, 0xEE, 0xDE, 0xCB, 0xA9, 0x87, 0x65, 0x55,
    0x68, 0x9A, 0xCD, 0xEF, 0xFD, 0xED, 0xCB, 0xA9, 0x87, 0x76, 0x78, 0x9A,
    0xBC, 0xEE, 0xFF, 0xDF, 0xDC, 0xBA, 0xA9, 0x88, 0x88, 0x9A, 0xBC, 0xDE,
    0xEF, 0xED, 0xFE, 0xDD, 0xCB, 0xBA, 0xAA, 0xAA, 0xBC, 0xDE, 0xDE, 0xFE,
    0xDF, 0xED, 0xDC, 0xCC, 0xBB, 0xBB, 0xCC, 0xDE, 0xEE, 0xFF, 0xED, 0xEF,
    0xED, 0xDD, 0xCD, 0xDD, 0xDD, 0xEE, 0xFF, 0xFE, 0xFE, 0xDF, 0xFE, 0xDE,
    0xEE, 0xEE, 0xDE, 0xEE, 0xFF, 0xEF, 0xFE, 0xFE, 0xFF, 0xEE, 0xEE, 0xEF,
    0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9D, 0xDD, 0xDD, 0xDD, 0xDD, 0xEE,
    0xEE, 0xFE, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDC, 0xCC, 0xBB, 0xBB, 0xCC, 0xCC, 0xBC, 0xBC, 0xCD, 0x8D, 0xEE,
    0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xED, 0xDE, 0xED, 0xDC,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCC, 0xCD, 0xDF, 0xDC, 0xDC, 0xCC, 0xBA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xED, 0xCD, 0xCC, 0xBA, 0x99, 0x99, 0x99,
    0x9A, 0xAB, 0xCC, 0xDE, 0xDC, 0xDC, 0xBA, 0x99, 0x88, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xED, 0xCD, 0xCB, 0x98, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xCD, 0xCC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBD, 0xDC,
    0xCD, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xED, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDD, 0xCD, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAC, 0xCE, 0xCC, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x89,
    0x9A, 0xBC, 0xED, 0xCC, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x89, 0x9A, 0xBC,
    0xDF, 0xDC, 0xDC, 0xCB, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xDD, 0xED,
    0xCE, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDF, 0xDC, 0xED,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEE, 0xEE, 0xDE, 0xED, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xDF, 0xEF, 0xED, 0xFF, 0xEE, 0xED, 0xDC,
    0xDD, 0xDD, 0xEE, 0xEE, 0xFF, 0xFE, 0x7C, 0xCD, 0xCC, 0xCC, 0xCC, 0xCD,
    0xDD, 0xDD, 0xED, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0x8B, 0xDC,
    0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCC, 0xDC, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xCD, 0xBB, 0xCB, 0xAA, 0x99, 0x98,
    0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xCB, 0xAB, 0xAA, 0x98, 0x88, 0x88, 0x88,
    0x88, 0x99, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xCB, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBB, 0xBA, 0xA9, 0x98, 0x76, 0x66, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xA9, 0xA9,
    0x88, 0x76, 0x55, 0x55, 0x55, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0x98, 0x87,
    0x66, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xBA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBB, 0xAB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBB, 0xBA, 0xBB, 0xA9, 0x98, 0x88, 0x87, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xAB, 0xBB, 0xAA, 0x99, 0x98, 0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xCB, 0xCB,
    0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDC, 0xBC, 0xCC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xCB, 0xDD, 0xCC, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xED, 0x8B, 0xBB, 0xBB, 0xBB, 0xBA, 0xAA,
    0xBB, 0xBB, 0xCC, 0xCD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0x8B, 0xCC,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xCB, 0xBB, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xBA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xAB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x78,
    0x88, 0x99, 0xAA, 0xBB, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAA, 0xBA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x99,
    0xAB, 0xA9, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xA9, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAA, 0xA9, 0xA9, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBA, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0xAA, 0xBA, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xBB,
    0xAB, 0xBA, 0xA9, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBA, 0xBB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xCB, 0xBC, 0xBB, 0xBA,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xCB, 0xCC, 0xCB, 0xBB, 0xBA,
    0xAA, 0xAB, 0xBB, 0xBC, 0xCC, 0xDC, 0x8B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xCC, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0x8C, 0xDC,
    0xBB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDC, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0xCC, 0xBB, 0xBB, 0xAA, 0x99, 0x98,
    0x88, 0x89, 0x9A, 0xAB, 0xBB, 0xCB, 0xBB, 0xAA, 0x99, 0x88, 0x87, 0x88,
    0x89, 0x99, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xAB, 0xBB, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77, 0x89, 0x9A,
    0xBB, 0xBA, 0xA9, 0x98, 0x76, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xBB,
    0xAA, 0x98, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xAA, 0xA9,
    0x88, 0x76, 0x55, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0xAA, 0x98, 0x87,
    0x65, 0x55, 0x55, 0x56, 0x78, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x56,
    0x66, 0x78, 0x89, 0xAB, 0xAA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBB, 0xBA, 0xBB, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xAA, 0x99, 0x98, 0x88, 0x89, 0x9A, 0xAB, 0xCC, 0xBB, 0xCC,
    0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDB, 0xBD, 0xCC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0xCD, 0xCB, 0xDC, 0xCC, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xDC, 0x8C, 0xBB, 0xBB, 0xBA, 0xAA, 0xAA,
    0xBB, 0xBB, 0xBC, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDD, 0xCD, 0xCB, 0xCB, 0xBB, 0xCB, 0xCB, 0xCC, 0xCC, 0x7D, 0xFF,
    0xDD, 0xCC, 0xCB, 0xBB, 0xCC, 0xCD, 0xDD, 0xDE, 0xED, 0xDD, 0xDC, 0xCC,
    0xBB, 0xAB, 0xAB, 0xBB, 0xCC, 0xDD, 0xEE, 0xDD, 0xDD, 0xCB, 0xBA, 0xA9,
    0x99, 0xAA, 0xAB, 0xBC, 0xCD, 0xEC, 0xCD, 0xCB, 0xAA, 0x99, 0x88, 0x89,
    0x99, 0xAA, 0xBC, 0xDD, 0xDC, 0xDB, 0xBA, 0x98, 0x87, 0x77, 0x78, 0x99,
    0xAB, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x78, 0x89, 0xAB,
    0xCD, 0xCC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xBC, 0xB9, 0x87, 0x65, 0x54, 0x55, 0x67, 0x79, 0x9B, 0xBC, 0xCC, 0xBA,
    0x98, 0x76, 0x54, 0x44, 0x45, 0x67, 0x89, 0xAC, 0xCD, 0xCC, 0xA9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9B, 0xBD, 0xDB, 0xCA, 0xA8, 0x87, 0x65,
    0x54, 0x55, 0x67, 0x89, 0xBB, 0xCD, 0xBB, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAA, 0xCD, 0xDC, 0xCB, 0xA9, 0x88, 0x77, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBB, 0xA9, 0x98, 0x77, 0x77, 0x88, 0x9A, 0xBB,
    0xDE, 0xDC, 0xDC, 0xBA, 0xA9, 0x98, 0x88, 0x89, 0x9A, 0xBB, 0xDD, 0xED,
    0xDD, 0xDC, 0xBB, 0xAA, 0xA9, 0x99, 0xAA, 0xBC, 0xCD, 0xEF, 0xDC, 0xED,
    0xDC, 0xBB, 0xBB, 0xAA, 0xBB, 0xBC, 0xCC, 0xEE, 0xEE, 0xDE, 0xED, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xEE, 0xEF, 0xFD, 0xFE, 0xDD, 0xDD, 0xDC,
    0xDD, 0xDD, 0xDE, 0xED, 0xFF, 0xFE, 0x8D, 0xCD, 0xCD, 0xCC, 0xCC, 0xCC,
    0xCD, 0xDD, 0xEE, 0xEF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xED, 0xDD, 0xDD, 0xDC, 0x8F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xEE, 0xED, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xDC,
    0xCC, 0xCC, 0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0xCB, 0xBB, 0xAB,
    0xBC, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xBB, 0xA9, 0x99, 0x9A, 0xAB,
    0xCD, 0xFF, 0xFF, 0xEF, 0xFD, 0xCA, 0x98, 0x77, 0x77, 0x89, 0xAC, 0xDF,
    0xFF, 0xFF, 0xFE, 0xDB, 0xA8, 0x76, 0x56, 0x67, 0x8A, 0xBD, 0xDF, 0xFF,
    0xFF, 0xFC, 0xB9, 0x76, 0x54, 0x45, 0x68, 0x9B, 0xCD, 0xFF, 0xFF, 0xFD,
    0xCB, 0x97, 0x54, 0x23, 0x46, 0x79, 0xAC, 0xEF, 0xFF, 0xFF, 0xEC, 0xA9,
    0x76, 0x43, 0x24, 0x57, 0x9B, 0xCD, 0xFF, 0xFF, 0xFD, 0xCB, 0x98, 0x65,
    0x44, 0x46, 0x79, 0xBC, 0xEF, 0xFF, 0xEF, 0xDD, 0xBA, 0x87, 0x66, 0x56,
    0x78, 0xAB, 0xDF, 0xFF, 0xFF, 0xFE, 0xDC, 0xA9, 0x88, 0x77, 0x78, 0x9A,
    0xCD, 0xFF, 0xFF, 0xDF, 0xFD, 0xCB, 0xAA, 0x99, 0x99, 0xAB, 0xBD, 0xDF,
    0xFF, 0xFD, 0xFF, 0xDD, 0xCB, 0xBB, 0xAA, 0xBB, 0xCC, 0xFE, 0xFF, 0xFF,
    0xEF, 0xFD, 0xED, 0xDC, 0xCC, 0xCC, 0xCD, 0xEF, 0xFF, 0xFF, 0xFD, 0xFF,
    0xEF, 0xDD, 0xDD, 0xDE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
    0xEF, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0xCD, 0xDD, 0xDD, 0xFD, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xDE, 0xEE, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x9E, 0xFF,
    0xEE, 0xED, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xFD, 0xEF, 0xED, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEF, 0xDD, 0xED, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xFE, 0xDE, 0xDC, 0xBA, 0x99, 0x99, 0x99,
    0x9A, 0xAB, 0xCC, 0xDE, 0xDD, 0xDC, 0xBA, 0x98, 0x88, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xED, 0xDD, 0xCA, 0x98, 0x77, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xDD, 0xDC, 0xDB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xCD, 0xED,
    0xCC, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xED, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xED, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAC, 0xDE, 0xEC, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x78,
    0x9B, 0xCD, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xEF, 0xEC, 0xDC, 0xCB, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xFE,
    0xCE, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xEC, 0xED,
    0xDC, 0xCC, 0xBB, 0xBB, 0xBB, 0xCD, 0xDE, 0xEF, 0xFF, 0xCF, 0xED, 0xDD,
    0xDC, 0xCC, 0xCC, 0xCD, 0xDE, 0xEF, 0xFF, 0xFC, 0xFE, 0xFE, 0xDD, 0xDD,
    0xDE, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0x8D, 0xDD, 0xCD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xEE, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xDE, 0xED, 0xDC, 0xCC, 0xBB, 0xBB, 0xBB, 0xBC, 0xCC, 0xCC, 0x9E, 0xFE,
    0xED, 0xCC, 0xCB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xED, 0xEE, 0xDD, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xDD, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xDD, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBB, 0xCD, 0xCC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xCC,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xCB, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDC, 0xCB, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xEE,
    0xCD, 0xCB, 0xBA, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xEC, 0xDD,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFF, 0xCE, 0xDD, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFD, 0xEE, 0xDD, 0xCD, 0xCC,
    0xCC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFF, 0xAD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC,
    0xDD, 0xDE, 0xEF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xED, 0xEE, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x9F, 0xFF,
    0xFE, 0xED, 0xDC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xED, 0xEF, 0xEE, 0xDC,
    0xCC, 0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEE, 0xDE, 0xEE, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xDD, 0xED, 0xDE, 0xDC, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xAB, 0xCC, 0xDE, 0xDD, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xDD, 0xDD, 0xCB, 0xA8, 0x77, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xDD, 0xCC, 0xDB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xCC, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAC, 0xCD, 0xDC, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9B, 0xCD, 0xDD, 0xCD, 0xCB, 0xAA, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDF, 0xDD, 0xDC, 0xCB, 0xAA, 0x99, 0x89, 0x99, 0xAA, 0xBC, 0xDD, 0xED,
    0xCD, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xEF, 0xED, 0xED,
    0xDC, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEE, 0xFE, 0xCD, 0xED, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFD, 0xFE, 0xEE, 0xED, 0xDD,
    0xDD, 0xEE, 0xDE, 0xFE, 0xFF, 0xFE, 0x9C, 0xCD, 0xCC, 0xCC, 0xCC, 0xDD,
    0xDD, 0xDE, 0xEF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xFF, 0xFF, 0xFF, 0xEE, 0xDD, 0xDD, 0xDD, 0xCC, 0xCD, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xEE, 0xFE, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF,
    0xEF, 0xDC, 0xDD, 0xDD, 0xFF, 0xEF, 0xFF, 0xDF, 0xFF, 0xFE, 0xDD, 0xCC,
    0xBB, 0xBC, 0xCD, 0xDD, 0xDF, 0xFE, 0xFF, 0xFF, 0xDC, 0xBA, 0xAA, 0xAA,
    0xAB, 0xCC, 0xDF, 0xFF, 0xEF, 0xFF, 0xDC, 0xBA, 0x98, 0x88, 0x99, 0xAB,
    0xCD, 0xDF, 0xFE, 0xFF, 0xFC, 0xBA, 0x98, 0x77, 0x77, 0x89, 0xAB, 0xCD,
    0xFF, 0xFF, 0xFD, 0xCB, 0x97, 0x65, 0x55, 0x67, 0x89, 0xBB, 0xDF, 0xFF,
    0xFF, 0xDC, 0xA8, 0x75, 0x44, 0x45, 0x67, 0x9A, 0xCD, 0xFF, 0xFF, 0xFD,
    0xBA, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xDF, 0xFF, 0xFE, 0xDB, 0xA8,
    0x75, 0x43, 0x34, 0x57, 0x8A, 0xBD, 0xFF, 0xFF, 0xED, 0xBA, 0x87, 0x65,
    0x44, 0x45, 0x78, 0xAB, 0xDF, 0xFF, 0xFF, 0xDC, 0xA9, 0x87, 0x65, 0x55,
    0x67, 0x9B, 0xCF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x87, 0x76, 0x78, 0x9A,
    0xBC, 0xDF, 0xFF, 0xEF, 0xEC, 0xCB, 0xA9, 0x98, 0x88, 0x9A, 0xBC, 0xDF,
    0xFF, 0xFE, 0xFF, 0xCD, 0xCB, 0xAA, 0xAA, 0xAB, 0xBC, 0xDF, 0xFF, 0xFF,
    0xEF, 0xFF, 0xDD, 0xCB, 0xBB, 0xBB, 0xDC, 0xEE, 0xFF, 0xFF, 0xFD, 0xFE,
    0xEF, 0xDD, 0xDC, 0xDD, 0xDD, 0xEE, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xDC, 0xDD, 0xDE, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xDE, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xDC, 0xCC, 0xCD, 0x8F, 0xFF,
    0xEE, 0xDC, 0xDC, 0xBC, 0xCD, 0xDE, 0xDD, 0xEF, 0xED, 0xEE, 0xEE, 0xDC,
    0xBB, 0xBB, 0xBB, 0xBB, 0xCD, 0xED, 0xEE, 0xED, 0xFE, 0xDC, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xCC, 0xDD, 0xED, 0xDE, 0xCC, 0xBA, 0x99, 0x88, 0x89,
    0x99, 0xAB, 0xBC, 0xDE, 0xDD, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x99,
    0xAB, 0xCE, 0xDD, 0xDD, 0xCA, 0x98, 0x77, 0x66, 0x67, 0x78, 0x99, 0xAB,
    0xCE, 0xDD, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9B, 0xBD, 0xDD,
    0xCC, 0xBA, 0x87, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCE, 0xDC, 0xCB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xCD, 0xCC, 0xBA, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9B, 0xCD, 0xEC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x8A, 0xBC, 0xDD, 0xCD, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x78,
    0x9A, 0xBD, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xDC, 0xDC, 0xCB, 0xAA, 0x99, 0x88, 0x99, 0x9A, 0xBC, 0xDD, 0xEE,
    0xCE, 0xDC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xBC, 0xCD, 0xEF, 0xED, 0xEE,
    0xDC, 0xCC, 0xBB, 0xBB, 0xBB, 0xBC, 0xDD, 0xEE, 0xFE, 0xDE, 0xEE, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCD, 0xDF, 0xEE, 0xFF, 0xEC, 0xEF, 0xEE, 0xDD, 0xDD,
    0xDD, 0xDD, 0xEF, 0xFF, 0xFF, 0xFE, 0x8D, 0xDD, 0xDC, 0xDC, 0xDD, 0xDD,
    0xDD, 0xDE, 0xEF, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xAA, 0xAA, 0xAA, 0x9A, 0xAA, 0xAA, 0xAB, 0xBB, 0x8B, 0xDC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDB, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xCD, 0xBB, 0xCB, 0xAA, 0x99, 0x88,
    0x88, 0x99, 0x99, 0xAA, 0xBC, 0xCB, 0xAB, 0xAA, 0x99, 0x88, 0x87, 0x88,
    0x88, 0x99, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xCB, 0xAB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBB, 0xAA, 0xA9, 0x98, 0x76, 0x66, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xBA,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xAA, 0xA9,
    0x88, 0x76, 0x55, 0x55, 0x55, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x98, 0x87,
    0x66, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x56,
    0x66, 0x78, 0x89, 0xAB, 0xBA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xBB, 0xBA, 0xBA, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x89, 0x9A, 0xAB, 0xCB,
    0xAC, 0xBA, 0xA9, 0x99, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCC, 0xCB, 0xCB,
    0xBA, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDC, 0xBC, 0xCB, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xDB, 0xDC, 0xCC, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCD, 0xDD, 0xEC, 0x8B, 0xBB, 0xBB, 0xBB, 0xAA, 0xAA,
    0xBB, 0xBB, 0xCC, 0xCD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0x9B, 0xCC,
    0xBB, 0xAA, 0xAA, 0x99, 0xAA, 0xAA, 0xBB, 0xBC, 0xCB, 0xBC, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xBA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x99, 0x9A, 0xBB, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAA, 0xBA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x99,
    0xAB, 0xA9, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x65, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xA9, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBA, 0x9A, 0xA9, 0x88, 0x87, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x88, 0x77, 0x78, 0x88, 0x99, 0xAA, 0xBB,
    0xAB, 0xAA, 0x99, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBA, 0xBB,
    0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xCB, 0xBC, 0xBB, 0xBA,
    0xAA, 0xA9, 0x9A, 0xAA, 0xAB, 0xBB, 0xCD, 0xCB, 0xDC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDC, 0x9B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xCC, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0x8C, 0xDD,
    0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCC, 0xDC, 0xCD, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xCD, 0xCB, 0xCB, 0xAA, 0x99, 0x98,
    0x88, 0x89, 0x99, 0xAA, 0xBC, 0xCB, 0xBC, 0xAA, 0x98, 0x88, 0x77, 0x78,
    0x88, 0x99, 0xAB, 0xBC, 0xBB, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xCB, 0xAB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xAB, 0xBA, 0xA9, 0x88, 0x76, 0x66, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xBB,
    0xAA, 0x98, 0x77, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xBA, 0xA9,
    0x87, 0x76, 0x55, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0xAA, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xBA, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x56,
    0x66, 0x78, 0x89, 0xAB, 0xBA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xBC, 0xBB, 0xBB, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x89, 0x9A, 0xAB, 0xCC,
    0xBC, 0xBB, 0xA9, 0x99, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCC, 0xCB, 0xCC,
    0xBB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDC, 0xBD, 0xCC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0xDD, 0xCC, 0xDC, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xED, 0x8B, 0xBB, 0xBB, 0xBA, 0xAA, 0xBB,
    0xBB, 0xBC, 0xCC, 0xCD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xED, 0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x7E, 0xFF,
    0xFE, 0xDD, 0xDC, 0xCD, 0xDD, 0xCE, 0xEE, 0xFF, 0xFD, 0xDF, 0xDD, 0xDC,
    0xDC, 0xCC, 0xBC, 0xCC, 0xCD, 0xDD, 0xFE, 0xDD, 0xEE, 0xDC, 0xBB, 0xBB,
    0xAA, 0xBB, 0xBB, 0xDD, 0xDE, 0xED, 0xDE, 0xDD, 0xBA, 0xA9, 0x99, 0x99,
    0xAA, 0xBB, 0xCD, 0xDD, 0xDD, 0xDC, 0xBB, 0xA9, 0x88, 0x88, 0x89, 0x9A,
    0xBC, 0xDE, 0xED, 0xCD, 0xCB, 0xA9, 0x87, 0x76, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xDD, 0xDC, 0xBA, 0x87, 0x65, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xDC,
    0xDD, 0xBA, 0x98, 0x76, 0x54, 0x45, 0x67, 0x89, 0xBC, 0xCE, 0xDC, 0xDB,
    0xA9, 0x86, 0x54, 0x33, 0x45, 0x78, 0x9A, 0xCD, 0xDD, 0xCD, 0xCA, 0x98,
    0x75, 0x43, 0x34, 0x57, 0x89, 0xAC, 0xCE, 0xCC, 0xDB, 0xB9, 0x87, 0x65,
    0x44, 0x56, 0x78, 0x9A, 0xBD, 0xFD, 0xCD, 0xCB, 0xA9, 0x87, 0x65, 0x56,
    0x67, 0x89, 0xBC, 0xDD, 0xDC, 0xDD, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x89,
    0xAB, 0xCD, 0xED, 0xCD, 0xCB, 0xBA, 0x99, 0x88, 0x88, 0x89, 0xAB, 0xCD,
    0xDF, 0xEC, 0xED, 0xDB, 0xBA, 0xA9, 0x99, 0x9A, 0xAB, 0xBC, 0xDE, 0xDE,
    0xCF, 0xDD, 0xCB, 0xBB, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xDF, 0xED, 0xFE,
    0xDD, 0xCC, 0xCB, 0xCB, 0xCC, 0xCD, 0xDE, 0xEE, 0xFD, 0xDF, 0xEF, 0xFD,
    0xDD, 0xDD, 0xDC, 0xED, 0xED, 0xEE, 0xFF, 0xFD, 0xFF, 0xFD, 0xEE, 0xED,
    0xDD, 0xDF, 0xEE, 0xFE, 0xFF, 0xFF, 0x8D, 0xDD, 0xDC, 0xCD, 0xDD, 0xCD,
    0xCD, 0xDD, 0xED, 0xEE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFE, 0xCF, 0xCD, 0xCC, 0xCC, 0x8F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD,
    0xFF, 0xCD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDB, 0xCC, 0xBB,
    0xCC, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xBA, 0xAA, 0xAB, 0xBC,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0xA9, 0x88, 0x88, 0x9A, 0xBD, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xA9, 0x87, 0x66, 0x78, 0x9B, 0xCD, 0xFF, 0xFF,
    0xFF, 0xDC, 0xBA, 0x86, 0x54, 0x45, 0x78, 0xAC, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFB, 0xA8, 0x64, 0x22, 0x46, 0x89, 0xBD, 0xFF, 0xFF, 0xDF, 0xDC, 0xB9,
    0x86, 0x42, 0x24, 0x68, 0x9B, 0xDD, 0xFF, 0xFF, 0xFF, 0xCC, 0xA8, 0x75,
    0x44, 0x56, 0x8A, 0xBF, 0xFF, 0xFF, 0xFF, 0xCF, 0xCA, 0x98, 0x76, 0x66,
    0x79, 0xAD, 0xFF, 0xFF, 0xFF, 0xFD, 0xFD, 0xBA, 0x98, 0x88, 0x89, 0xAB,
    0xDC, 0xFF, 0xFF, 0xDF, 0xFF, 0xDC, 0xCA, 0xAA, 0xAA, 0xAB, 0xCF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDB, 0xCC, 0xBB, 0xCC, 0xFD, 0xDF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xCF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xFF, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFD, 0xDD, 0xDC, 0xCC, 0xCB, 0xCC, 0xCC, 0xCC, 0xCC, 0x8F, 0xFF,
    0xEE, 0xDD, 0xDC, 0xCC, 0xCD, 0xDC, 0xED, 0xDF, 0xFC, 0xFF, 0xEE, 0xDC,
    0xCC, 0xCB, 0xBB, 0xBC, 0xCC, 0xDE, 0xEF, 0xDF, 0xFD, 0xCC, 0xBB, 0xAB,
    0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xED, 0xDD, 0xDC, 0xBB, 0xAA, 0x99, 0x99,
    0x9A, 0xBC, 0xCD, 0xDD, 0xDD, 0xFD, 0xCB, 0xA9, 0x88, 0x88, 0x89, 0x9A,
    0xBB, 0xCD, 0xDD, 0xDC, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xDD, 0xDC, 0xA9, 0x87, 0x66, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xED,
    0xCC, 0xCA, 0x98, 0x76, 0x54, 0x45, 0x67, 0x89, 0xAC, 0xDE, 0xDC, 0xCB,
    0xA9, 0x87, 0x54, 0x33, 0x45, 0x78, 0x9A, 0xBC, 0xDD, 0xDC, 0xBA, 0x98,
    0x75, 0x43, 0x34, 0x56, 0x89, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x56, 0x78, 0x9A, 0xBD, 0xDD, 0xDD, 0xCB, 0xA9, 0x87, 0x65, 0x55,
    0x67, 0x89, 0xBC, 0xDE, 0xDC, 0xCC, 0xBA, 0x98, 0x87, 0x76, 0x77, 0x89,
    0xAB, 0xCD, 0xEE, 0xCD, 0xCB, 0xBA, 0x99, 0x88, 0x88, 0x89, 0xAB, 0xCD,
    0xDE, 0xFC, 0xED, 0xBB, 0xBA, 0xA9, 0x99, 0x9A, 0xAB, 0xBD, 0xDF, 0xFE,
    0xCD, 0xED, 0xCB, 0xBB, 0xBA, 0xAA, 0xBB, 0xCC, 0xED, 0xFF, 0xEC, 0xEE,
    0xDC, 0xCC, 0xCC, 0xBC, 0xCC, 0xDD, 0xDF, 0xEF, 0xFF, 0xCD, 0xED, 0xDD,
    0xCD, 0xCD, 0xDC, 0xDD, 0xDF, 0xEF, 0xFF, 0xFC, 0xFF, 0xFD, 0xEE, 0xED,
    0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0x8D, 0xDC, 0xCD, 0xCD, 0xDD, 0xED,
    0xEE, 0xFE, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xAF, 0xFF,
    0xFD, 0xDC, 0xCB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEF, 0xFE, 0xFF, 0xED, 0xCB,
    0xBB, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xEF, 0xEE, 0xED, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xCD, 0xFE, 0xED, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xDD, 0xDD, 0xDB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDC, 0xCA, 0x98, 0x76, 0x65, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xDD,
    0xCB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xCB, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x9B, 0xCD, 0xEC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDE, 0xCC, 0xBA, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xDF, 0xED, 0xDC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x9A, 0xAB, 0xCD, 0xFF,
    0xDD, 0xCC, 0xBA, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCD, 0xFF, 0xFD, 0xED,
    0xCC, 0xBB, 0xBA, 0xAA, 0xAB, 0xBC, 0xCD, 0xEF, 0xFF, 0xDF, 0xED, 0xDC,
    0xCC, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xFF, 0xFD, 0xFF, 0xED, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xAD, 0xDD, 0xDD, 0xDD, 0xDC, 0xDD,
    0xDE, 0xEF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xFF, 0xED, 0xDC, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0x9F, 0xFF,
    0xFE, 0xDD, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xFD, 0xFE, 0xEE, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xDE, 0xEE, 0xDE, 0xFF, 0xDC, 0xBB, 0xAA,
    0x99, 0xAA, 0xAB, 0xCC, 0xCE, 0xDD, 0xED, 0xEC, 0xBA, 0x99, 0x88, 0x88,
    0x9A, 0xAB, 0xBC, 0xEE, 0xCD, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x78, 0x89,
    0xAB, 0xCC, 0xED, 0xDD, 0xCA, 0x98, 0x77, 0x66, 0x66, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xDB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xDC, 0xBA, 0x97, 0x65, 0x54, 0x55, 0x66, 0x78, 0xAB, 0xBD, 0xCC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x55, 0x67, 0x89, 0xAC, 0xDE, 0xCC, 0xA9, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x78, 0x9B, 0xCD, 0xDC, 0xCB, 0xA8, 0x76, 0x65,
    0x54, 0x55, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xDC, 0xA9, 0x88, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBD, 0xDD, 0xDD, 0xCB, 0xA9, 0x88, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDF, 0xDD, 0xDC, 0xCB, 0xA9, 0x98, 0x88, 0x89, 0x9A, 0xBC, 0xCE, 0xFE,
    0xDD, 0xDC, 0xBB, 0xBA, 0xA9, 0xAA, 0xAA, 0xBC, 0xDE, 0xDF, 0xFD, 0xFD,
    0xCC, 0xCB, 0xBB, 0xBA, 0xBB, 0xBC, 0xDD, 0xEF, 0xFF, 0xDF, 0xDD, 0xDC,
    0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xEE, 0xFF, 0xFD, 0xEE, 0xDE, 0xDD, 0xDD,
    0xDD, 0xDD, 0xEF, 0xEF, 0xFF, 0xFF, 0x9C, 0xCC, 0xCC, 0xCD, 0xDC, 0xED,
    0xEE, 0xEF, 0xFF, 0xFE, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xDD, 0xED, 0xDD, 0xCC, 0xDD, 0x8F, 0xFF,
    0xFF, 0xFE, 0xFE, 0xDD, 0xDD, 0xDF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF,
    0xFE, 0xDD, 0xDD, 0xDC, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE, 0xDD, 0xCC,
    0xBB, 0xBB, 0xCD, 0xDF, 0xFF, 0xFD, 0xFF, 0xDE, 0xDC, 0xBB, 0xAA, 0xAA,
    0xAA, 0xCC, 0xCF, 0xFF, 0xDF, 0xFF, 0xCC, 0xBA, 0x98, 0x88, 0x99, 0xAB,
    0xCD, 0xFD, 0xFF, 0xED, 0xED, 0xBA, 0x87, 0x77, 0x77, 0x89, 0xAB, 0xCD,
    0xFF, 0xDD, 0xED, 0xCB, 0x97, 0x65, 0x55, 0x67, 0x89, 0xBC, 0xFF, 0xEF,
    0xEF, 0xDB, 0xA8, 0x75, 0x44, 0x45, 0x67, 0x9A, 0xCD, 0xEF, 0xED, 0xEC,
    0xCA, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xDF, 0xFE, 0xDE, 0xCB, 0xA8,
    0x75, 0x43, 0x34, 0x57, 0x89, 0xCD, 0xEF, 0xFD, 0xEC, 0xCA, 0x97, 0x65,
    0x44, 0x45, 0x79, 0xAB, 0xDE, 0xDF, 0xFE, 0xDC, 0xA9, 0x87, 0x65, 0x55,
    0x67, 0x9A, 0xCD, 0xFF, 0xFE, 0xDE, 0xCB, 0xA9, 0x87, 0x77, 0x78, 0x9A,
    0xBC, 0xEF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x98, 0x88, 0x9A, 0xBC, 0xDE,
    0xFF, 0xFF, 0xDF, 0xCC, 0xBB, 0xAA, 0xA9, 0xAB, 0xBC, 0xDD, 0xFE, 0xFF,
    0xDF, 0xEE, 0xEC, 0xCC, 0xBB, 0xBC, 0xBD, 0xED, 0xFF, 0xFF, 0xFF, 0xEF,
    0xFD, 0xDD, 0xCC, 0xDC, 0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xCF, 0xDE, 0xEF,
    0xDE, 0xFD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFD, 0xFF, 0xEE,
    0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0xCB, 0xCD, 0xDE, 0xFF, 0xEE,
    0xDF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xED, 0xDB, 0xCC, 0xBA, 0xAB, 0xBB, 0xBB, 0xBB, 0xBB, 0x7F, 0xFD,
    0xCD, 0xCB, 0xBA, 0xBB, 0xBB, 0xBF, 0xDC, 0xDC, 0xFD, 0xDD, 0xDC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xED, 0xCF, 0xEC, 0xDC, 0xBA, 0xAA, 0x99,
    0x98, 0x99, 0xAA, 0xBB, 0xCD, 0xDF, 0xDC, 0xBA, 0xA9, 0x88, 0x88, 0x88,
    0x99, 0x9A, 0xBC, 0xCE, 0xDC, 0xDB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x89,
    0x9A, 0xCD, 0xCF, 0xCC, 0xB9, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAA,
    0xCC, 0xDC, 0xCA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x77, 0x89, 0xAC, 0xCC,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDB, 0xCA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAA, 0xCC, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xDB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xBB, 0xA9, 0x88, 0x76, 0x65, 0x55,
    0x67, 0x78, 0x9A, 0xBD, 0xCB, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x89, 0xAC, 0xCF, 0xCC, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xCC, 0xDB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCC, 0xDD,
    0xDF, 0xCB, 0xAA, 0xA9, 0x98, 0x99, 0x9A, 0xAB, 0xBD, 0xDF, 0xFC, 0xEE,
    0xDB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBD, 0xDE, 0xFF, 0xCF, 0xDD, 0xDD,
    0xBC, 0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xFF, 0xDD, 0xDD, 0xED, 0xCD, 0xCD,
    0xDC, 0xCC, 0xCE, 0xDF, 0xFF, 0xFF, 0x8D, 0xBB, 0xED, 0xCC, 0xCB, 0xCD,
    0xCF, 0xDD, 0xDF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xCB, 0xBA, 0xAA, 0x99, 0x99, 0x9A, 0xAA, 0xAA, 0xBB, 0x7C, 0xDC,
    0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0xDC, 0xCC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xCB, 0xBA, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xBC, 0xDC, 0xBB, 0xAA, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x99, 0xAA, 0xBB, 0xBA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xBB, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xAB, 0xB9, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAB,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xB9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xB9, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAB, 0xBA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBB, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAC, 0xBA, 0xBA, 0xA9, 0x88, 0x87, 0x77, 0x78, 0x88, 0x9A, 0xAB, 0xCC,
    0xBB, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x89, 0x99, 0xAB, 0xCD, 0xCB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xBB, 0xCC, 0xDE, 0xBC, 0xCC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xCE, 0xDB, 0xDE, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xED, 0x9C, 0xCB, 0xBB, 0xAB, 0xAA, 0xBA,
    0xBB, 0xBB, 0xCD, 0xDD, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xBB, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0x9C, 0xCC,
    0xBB, 0xAA, 0x99, 0x99, 0x9A, 0xAA, 0xAB, 0xBC, 0xDC, 0xBC, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xBB, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xAB, 0xBB, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xAB, 0xBA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xA9, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x65, 0x66, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x65, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBB, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xBA, 0xBA, 0x99, 0x88, 0x87, 0x77, 0x77, 0x88, 0x99, 0xAB, 0xBB,
    0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBB, 0xBB,
    0xAA, 0x99, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xDC, 0xBC, 0xBB, 0xAA,
    0xAA, 0x99, 0x99, 0xAA, 0xAA, 0xBC, 0xCD, 0xDB, 0xCD, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDD, 0x9C, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xBB, 0xCC, 0xDD, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCC, 0xCB, 0xBA, 0xAA, 0xAA, 0x9A, 0xAA, 0xAA, 0xBB, 0xBB, 0x8C, 0xCD,
    0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCC, 0xDC, 0xCC, 0xBA, 0xBA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xAB, 0xCC, 0xCC, 0xCB, 0xA9, 0x99, 0x88,
    0x88, 0x89, 0x99, 0x9A, 0xBB, 0xCB, 0xBB, 0xAA, 0x98, 0x88, 0x77, 0x78,
    0x88, 0x99, 0xAA, 0xBC, 0xBB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xBB, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xA9, 0x88, 0x76, 0x66, 0x56, 0x66, 0x77, 0x89, 0x9A, 0xBB,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xAA, 0xA9,
    0x87, 0x76, 0x55, 0x55, 0x56, 0x67, 0x79, 0x9A, 0xBB, 0xAA, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x99, 0xAB, 0xBA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBC, 0xAB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xBC, 0xBA, 0xBA, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x88, 0x9A, 0xBB, 0xCB,
    0xAB, 0xBA, 0xA9, 0x99, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCC, 0xCB, 0xDB,
    0xAA, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xDC, 0xBC, 0xBB, 0xBA,
    0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xDB, 0xCC, 0xCC, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xCE, 0xDD, 0x7B, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xBB, 0xCB, 0xCC, 0xCC, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDC, 0xFE, 0xCD, 0xCC, 0xDD, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFD, 0xFF, 0xDF, 0xFF, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xDC,
    0xBD, 0xDF, 0xFD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xDC, 0xCC, 0xBB,
    0xCC, 0xFF, 0xDF, 0xFF, 0xFD, 0xFF, 0xFD, 0xCB, 0xAA, 0xAA, 0xAC, 0xBB,
    0xBE, 0xDF, 0xFF, 0xEF, 0xDF, 0xDC, 0xA9, 0x98, 0x89, 0xAA, 0xCB, 0xFF,
    0xFF, 0xFF, 0xFF, 0xCC, 0xA9, 0x86, 0x66, 0x78, 0xAB, 0xCD, 0xFF, 0xFD,
    0xFF, 0xFD, 0xBA, 0x86, 0x54, 0x45, 0x79, 0xAC, 0xCF, 0xDF, 0xFF, 0xFF,
    0xCC, 0xA8, 0x64, 0x22, 0x46, 0x8A, 0xBE, 0xDF, 0xFF, 0xFF, 0xFD, 0xCA,
    0x86, 0x42, 0x24, 0x68, 0xAB, 0xCF, 0xFF, 0xFF, 0xFF, 0xDC, 0xA9, 0x75,
    0x44, 0x56, 0x8A, 0xCD, 0xDF, 0xFE, 0xFF, 0xFD, 0xDB, 0x98, 0x76, 0x66,
    0x89, 0xBC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBA, 0x99, 0x88, 0x89, 0xBB,
    0xDD, 0xFF, 0xFF, 0xFF, 0xFD, 0xCC, 0xBA, 0xA9, 0x9A, 0xBC, 0xDD, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xBC, 0xBB, 0xCC, 0xCC, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDC, 0xFD, 0xDD, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDC, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xCD, 0xDF, 0xFD, 0xEE, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xDF, 0xFF, 0xFD, 0xFF, 0xFC, 0xFF, 0xFC, 0xFF, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD,
    0xFF, 0xDF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFC, 0xCC, 0xCF,
    0xDD, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xCF, 0xDD, 0xBB, 0xBA, 0xAC, 0xCB,
    0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x99, 0x89, 0xAA, 0xAF, 0xFF,
    0xFF, 0xFF, 0xCF, 0xFC, 0xBA, 0x87, 0x66, 0x79, 0xAB, 0xDD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xCB, 0x97, 0x54, 0x45, 0x79, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xB9, 0x64, 0x22, 0x46, 0x8A, 0xDD, 0xDD, 0xFF, 0xFF, 0xFD, 0xDC,
    0x96, 0x42, 0x23, 0x69, 0xBB, 0xCF, 0xFF, 0xFF, 0xFF, 0xFC, 0xB9, 0x75,
    0x44, 0x57, 0x9B, 0xBF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xA9, 0x76, 0x66,
    0x89, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0xA9, 0x88, 0x99, 0xAD,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xAA, 0xAB, 0xCC, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xDB, 0xBB, 0xBF, 0xCF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xDD, 0xFD, 0xFD, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDC, 0xDC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xDF, 0xFD, 0xFF, 0xFA, 0xBD,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x89, 0x99, 0x98, 0x88, 0x88, 0x88, 0x88, 0x98, 0x98, 0x9A, 0x6A, 0xCB,
    0x9A, 0xA9, 0x99, 0x99, 0xAA, 0x9A, 0xAB, 0xAA, 0xDA, 0x9A, 0xA9, 0x89,
    0x99, 0x89, 0x99, 0x89, 0x8A, 0x99, 0xAA, 0x9A, 0xAA, 0x99, 0x88, 0x88,
    0x88, 0x88, 0x89, 0xA9, 0xAA, 0xAA, 0x89, 0xA9, 0x98, 0x88, 0x88, 0x88,
    0x88, 0x89, 0x9A, 0xB9, 0xA9, 0xA9, 0x98, 0x78, 0x77, 0x77, 0x77, 0x88,
    0x89, 0x9A, 0xA9, 0x89, 0x98, 0x87, 0x76, 0x76, 0x77, 0x77, 0x88, 0x99,
    0x9A, 0xA8, 0x98, 0x88, 0x76, 0x66, 0x66, 0x77, 0x77, 0x88, 0x89, 0x98,
    0x89, 0x98, 0x87, 0x76, 0x66, 0x66, 0x67, 0x78, 0x88, 0x9B, 0xA8, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x66, 0x77, 0x88, 0x98, 0xA8, 0x89, 0x88, 0x87,
    0x76, 0x65, 0x56, 0x67, 0x77, 0x88, 0x99, 0x98, 0x99, 0x78, 0x77, 0x66,
    0x65, 0x66, 0x67, 0x78, 0x8A, 0x99, 0x89, 0x98, 0x78, 0x77, 0x66, 0x66,
    0x67, 0x77, 0x88, 0xAB, 0x98, 0x99, 0x89, 0x87, 0x77, 0x76, 0x67, 0x77,
    0x88, 0x89, 0xA9, 0x9A, 0x9A, 0x98, 0x77, 0x77, 0x77, 0x77, 0x78, 0x89,
    0x9B, 0x98, 0xA9, 0x99, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x9A, 0xA9,
    0x8A, 0x99, 0x99, 0x89, 0x88, 0x88, 0x88, 0x99, 0x8A, 0xAA, 0xA9, 0xAB,
    0xAA, 0x98, 0x88, 0x89, 0x88, 0x89, 0x9A, 0xBA, 0xA9, 0xAC, 0xBA, 0xB9,
    0xAA, 0x99, 0x99, 0x9A, 0x99, 0xAA, 0xAD, 0xA9, 0xBA, 0xAB, 0xAB, 0xA9,
    0x9A, 0x9A, 0xBA, 0xAA, 0x9C, 0xBB, 0x8B, 0xA9, 0xA8, 0x99, 0x98, 0x88,
    0x99, 0x9A, 0xAA, 0xAB, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFE, 0xDD, 0xCC, 0xCC, 0xDC, 0xDD, 0xED, 0xEF, 0xDF, 0xFF,
    0xED, 0xDC, 0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xFF, 0xFF, 0xFF, 0xFE, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xFF, 0xFD, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xDD, 0xFF, 0xFD, 0xCB, 0xA9, 0x98, 0x87, 0x88,
    0x89, 0x9A, 0xBC, 0xFF, 0xFE, 0xDC, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xDF, 0xDC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x67, 0x89, 0xAB,
    0xCD, 0xEE, 0xBB, 0x98, 0x76, 0x65, 0x55, 0x56, 0x67, 0x89, 0xAB, 0xDF,
    0xCB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x45, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xCB, 0xA9, 0x87,
    0x65, 0x55, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xDC, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xCC, 0xA9, 0x87, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9B, 0xCD, 0xEC, 0xCA, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDF, 0xDC, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xDF, 0xFF, 0xDC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xFF,
    0xFE, 0xCB, 0xBA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xCD, 0xFF, 0xFF, 0xFD,
    0xDC, 0xCB, 0xAA, 0xAA, 0xAA, 0xBC, 0xCD, 0xFF, 0xFF, 0xFF, 0xEF, 0xDD,
    0xCB, 0xBB, 0xBB, 0xCC, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDD,
    0xDD, 0xDE, 0xDE, 0xFF, 0xFF, 0xFF, 0xCF, 0xFE, 0xFE, 0xFE, 0xEF, 0xDD,
    0xDF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xAA, 0x99, 0xA9, 0x89, 0x89, 0x99, 0x98, 0x99, 0xBB, 0x6B, 0xAB,
    0xBA, 0xAA, 0x99, 0x99, 0x99, 0xBA, 0xAB, 0xBE, 0xFB, 0x9B, 0xAA, 0x99,
    0x99, 0x99, 0x99, 0xA9, 0xAC, 0x9B, 0xBA, 0xC9, 0xB9, 0xA9, 0x99, 0x88,
    0x89, 0x88, 0x89, 0xAA, 0xAA, 0xBA, 0x99, 0x99, 0x88, 0x88, 0x77, 0x87,
    0x88, 0x89, 0xAA, 0xAA, 0xA9, 0x9A, 0x88, 0x87, 0x77, 0x77, 0x78, 0x88,
    0x99, 0xAA, 0xA9, 0x9A, 0x99, 0x87, 0x76, 0x66, 0x67, 0x77, 0x88, 0x99,
    0xBB, 0xA9, 0x99, 0x88, 0x77, 0x66, 0x66, 0x66, 0x78, 0x88, 0x99, 0xB9,
    0x9A, 0x98, 0x87, 0x66, 0x55, 0x56, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x77, 0x78, 0x8A, 0xA9, 0x99, 0x99, 0x87,
    0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xA8, 0x99, 0x98, 0x76, 0x66,
    0x55, 0x56, 0x67, 0x78, 0x99, 0xA9, 0x99, 0x98, 0x98, 0x77, 0x66, 0x66,
    0x67, 0x78, 0x98, 0x9B, 0xA9, 0x99, 0x98, 0x87, 0x77, 0x66, 0x77, 0x77,
    0x89, 0x99, 0xCA, 0x9A, 0xA9, 0x88, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0x99, 0xBA, 0x99, 0x88, 0x88, 0x87, 0x88, 0x88, 0x89, 0x9B, 0xB9,
    0xAB, 0xA9, 0xAA, 0x88, 0x88, 0x88, 0x88, 0x9A, 0xBA, 0xAB, 0xA9, 0xEA,
    0xAA, 0x9A, 0xA9, 0x9A, 0x89, 0x99, 0x9A, 0xAC, 0xAB, 0xAC, 0xDA, 0xBA,
    0xAA, 0x9A, 0x99, 0xAA, 0xAB, 0xBA, 0xCC, 0xAA, 0xFB, 0xDB, 0xBA, 0xAA,
    0xAA, 0xBA, 0xBB, 0xBB, 0xFC, 0xFB, 0x7A, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x9A, 0xAA, 0xAB, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xA9, 0xAA, 0xBB, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x98, 0x77, 0x89, 0xAF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xA8, 0x54, 0x46, 0x8A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDA, 0x74, 0x12, 0x47, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xA7, 0x42, 0x24, 0x79, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0x86,
    0x44, 0x57, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0x87, 0x77,
    0x9B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xBA, 0x9A, 0xAB, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x8A, 0x98, 0x88, 0x87, 0x77, 0xF7, 0x6F, 0x88, 0x8F, 0xAA, 0x59, 0xFA,
    0xAF, 0xAF, 0x8A, 0x87, 0x8A, 0xA8, 0xFA, 0xA9, 0xF9, 0x9A, 0xAF, 0x98,
    0x9A, 0x79, 0x89, 0x78, 0x9A, 0xFA, 0xFF, 0xAC, 0x88, 0x8F, 0x87, 0x88,
    0xA8, 0x89, 0x9A, 0x87, 0xAF, 0xFA, 0x7A, 0xA9, 0x87, 0x78, 0x77, 0x98,
    0x78, 0x89, 0xAA, 0xFA, 0xA8, 0x98, 0x99, 0x87, 0x78, 0x87, 0x77, 0x87,
    0x87, 0xFA, 0xE8, 0x8B, 0x97, 0x76, 0x88, 0x77, 0x67, 0x77, 0x78, 0x78,
    0x8A, 0x87, 0xA9, 0x8F, 0x77, 0x77, 0x67, 0x97, 0x88, 0x78, 0x99, 0xA8,
    0x79, 0x89, 0x77, 0x76, 0x66, 0x76, 0x77, 0x77, 0x8F, 0x89, 0x98, 0xF9,
    0x88, 0x97, 0x66, 0x57, 0x67, 0x78, 0x77, 0xA9, 0x88, 0x78, 0x87, 0x87,
    0x66, 0x66, 0x66, 0x67, 0x68, 0x97, 0xF9, 0x88, 0xA8, 0x78, 0x87, 0x76,
    0x66, 0x77, 0x68, 0x77, 0x88, 0x89, 0x99, 0xA8, 0x78, 0x77, 0x77, 0x76,
    0x67, 0x76, 0x77, 0x89, 0xA9, 0x8A, 0x87, 0x87, 0x77, 0x68, 0x76, 0x76,
    0x88, 0x9A, 0x9A, 0xAA, 0xA7, 0x97, 0x87, 0x87, 0x87, 0x77, 0x99, 0x77,
    0x9A, 0x87, 0x9A, 0x99, 0x79, 0x79, 0x76, 0x87, 0x98, 0x99, 0xA8, 0x88,
    0x98, 0x9A, 0xA9, 0x99, 0x97, 0x98, 0x8A, 0x98, 0x9A, 0xFF, 0xA8, 0xFA,
    0x7F, 0x8A, 0x8F, 0x98, 0x8A, 0xA8, 0xFF, 0xF9, 0xA8, 0xAF, 0x99, 0x99,
    0x88, 0x99, 0xAA, 0x98, 0x9A, 0xAA, 0xAF, 0xAA, 0xFA, 0xF9, 0x9A, 0xFA,
    0xF9, 0x8A, 0xA8, 0x98, 0xAF, 0xA9, 0x9F, 0xFA, 0x89, 0x87, 0x78, 0x98,
    0x87, 0x8A, 0x87, 0x99, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xBF, 0xFF, 0xFF, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xBF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0x88, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xF8, 0x65, 0x57, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x84, 0x12, 0x58, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF8, 0x52, 0x14, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x96,
    0x54, 0x68, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xA8, 0x89,
    0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFB, 0xFF, 0xFF, 0xFF, 0xBF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xEF, 0xFE, 0xEF, 0xFF, 0xFE, 0xEE, 0xE5, 0xFF, 0xFF, 0xFF, 0xFE,
    0xEE, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEE,
    0xEE, 0xEE, 0x4E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0x5F, 0xFF,
    0xFF, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEE, 0x5E,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE5, 0xE5,
    0xEE, 0xEE, 0xEE, 0xEF, 0xFF, 0x55, 0xF5, 0x5F, 0xF5, 0xFF, 0x5F, 0x5F,
    0xFF, 0xFF, 0xF4, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0xF5, 0xFF, 0xF5, 0xFF, 0x5F, 0x4F, 0xFE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xE3, 0xE5, 0xEE, 0x5E, 0xEE, 0xEE, 0xEE, 0xE5, 0x4E,
    0xEE, 0x5E, 0x5E, 0xE5, 0x5E, 0x5E, 0x55, 0xEE, 0xEE, 0x54, 0xEE, 0xE5,
    0x5E, 0xE5, 0xE6, 0x5E, 0xEE, 0xEE, 0xEE, 0xEF, 0xF5, 0xFF, 0xF5, 0xFF,
    0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xF5, 0xFF, 0x5F, 0xFF,
    0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0xFF, 0x5F, 0xF5, 0x5F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0x5F,
    0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF,
    0xFF, 0xFF, 0xFE, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x78, 0xF6, 0x66, 0x68, 0x76, 0x67, 0x67, 0x98, 0x78, 0x7F, 0x68, 0x98,
    0x9F, 0xF8, 0xF7, 0xFE, 0x8F, 0xFF, 0x9F, 0xFF, 0x9F, 0x88, 0x7F, 0x88,
    0x9F, 0x79, 0x9F, 0xFF, 0x8F, 0x9F, 0xF9, 0x96, 0x99, 0x97, 0x78, 0x67,
    0xF7, 0x98, 0xFF, 0x79, 0x99, 0xF8, 0x77, 0xF8, 0x89, 0x97, 0x78, 0x89,
    0xF7, 0x8F, 0xFF, 0xFF, 0x78, 0x99, 0x79, 0x97, 0x97, 0x77, 0x99, 0x7F,
    0x79, 0x99, 0x98, 0x77, 0x9F, 0x67, 0x67, 0x67, 0x78, 0x98, 0x9F, 0x99,
    0x89, 0xF6, 0x9F, 0x79, 0x78, 0x76, 0x66, 0xF8, 0x78, 0x89, 0x78, 0xF8,
    0x87, 0x88, 0x99, 0x87, 0x77, 0x69, 0x79, 0x78, 0xF7, 0x9F, 0x77, 0xF9,
    0x99, 0x76, 0x77, 0x77, 0x68, 0x87, 0x78, 0x9F, 0x97, 0x88, 0x78, 0x89,
    0x97, 0x76, 0x77, 0x77, 0x89, 0x8F, 0x8F, 0x67, 0x89, 0x98, 0x89, 0x78,
    0x77, 0x87, 0x78, 0x79, 0x78, 0x96, 0x68, 0x9F, 0xA8, 0x97, 0x78, 0x78,
    0x8F, 0x89, 0x79, 0x8F, 0x67, 0xFF, 0x8F, 0x99, 0x77, 0x66, 0x66, 0x76,
    0x86, 0xF8, 0xF6, 0x99, 0x9F, 0x7F, 0x89, 0x97, 0x79, 0x88, 0x6F, 0x88,
    0x89, 0x68, 0xFF, 0xFF, 0xF9, 0x98, 0x89, 0xF8, 0xFF, 0x98, 0x9F, 0xF7,
    0x78, 0x79, 0xF9, 0x77, 0x89, 0xF8, 0x97, 0x89, 0xF9, 0x98, 0x77, 0x9F,
    0x9F, 0x89, 0x9F, 0x99, 0x98, 0x9F, 0x99, 0x9F, 0x98, 0x89, 0x98, 0xFF,
    0x9F, 0xF8, 0xF9, 0x88, 0x9F, 0x7F, 0xF9, 0x67, 0xFF, 0x99, 0x98, 0xF9,
    0xFF, 0x89, 0x9F, 0xFF, 0x9F, 0xF9, 0x59, 0x77, 0x98, 0x68, 0x96, 0x77,
    0x68, 0x89, 0xF7, 0x6F, 0x60, 0x00, 0x00, 0x00,
  },
  {
    0x68, 0x89, 0x78, 0x77, 0x67, 0x88, 0x88, 0xFF, 0x79, 0x99, 0x69, 0xF9,
    0xF9, 0x88, 0x87, 0x79, 0x8F, 0xF9, 0xF8, 0xF9, 0xF7, 0x8F, 0x98, 0x78,
    0x79, 0xF9, 0xF8, 0x88, 0x79, 0x7F, 0xF9, 0x97, 0xFF, 0x8F, 0x98, 0x78,
    0x77, 0x67, 0xF8, 0xF9, 0xFF, 0xF9, 0x78, 0xF8, 0x88, 0x87, 0x88, 0x77,
    0x98, 0xF7, 0x98, 0xFF, 0x98, 0x9F, 0xF8, 0x98, 0x87, 0x76, 0x79, 0x97,
    0x78, 0x89, 0x8C, 0x77, 0x88, 0x78, 0x77, 0x77, 0x88, 0x77, 0x78, 0x79,
    0x9F, 0x88, 0x79, 0x77, 0x77, 0x77, 0x67, 0x77, 0x77, 0x8F, 0x99, 0x97,
    0x87, 0x77, 0x78, 0x87, 0x78, 0x76, 0x77, 0x78, 0x9F, 0x99, 0xF7, 0x77,
    0x98, 0x76, 0x76, 0x77, 0x68, 0x7F, 0x78, 0xFF, 0xF9, 0x78, 0x88, 0x87,
    0x88, 0x76, 0x67, 0x88, 0x79, 0x78, 0xF9, 0x87, 0x89, 0x97, 0x77, 0x68,
    0x67, 0x77, 0x77, 0x77, 0x8E, 0x78, 0x78, 0x8A, 0x88, 0x77, 0x87, 0x77,
    0x67, 0x88, 0x88, 0x8F, 0x87, 0x89, 0x88, 0x77, 0x76, 0x77, 0x79, 0x77,
    0x77, 0x8F, 0x88, 0x79, 0xF8, 0x77, 0x78, 0x77, 0x88, 0x77, 0x78, 0x98,
    0x89, 0x89, 0xFF, 0xF8, 0x88, 0x99, 0x77, 0x98, 0x78, 0x87, 0x99, 0x99,
    0x98, 0xF8, 0x98, 0xFF, 0xFF, 0x79, 0x88, 0x77, 0x79, 0x8F, 0x88, 0xF8,
    0x88, 0xFF, 0x88, 0x78, 0x99, 0x9F, 0x88, 0xF9, 0xF8, 0x88, 0x99, 0xB9,
    0xF7, 0x88, 0x99, 0xF9, 0x99, 0x9F, 0xFF, 0x99, 0xFF, 0x8F, 0x98, 0x8F,
    0x89, 0x99, 0xF8, 0x99, 0x8F, 0xF9, 0x5F, 0x89, 0x77, 0x87, 0x99, 0x78,
    0x88, 0x77, 0xF8, 0x8F, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x5E, 0xDE, 0xE5, 0xDE, 0xEE, 0xED, 0xDD, 0xDE, 0xEE, 0xEE, 0x4E, 0xED,
    0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xED,
    0xDD, 0x4D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0x5E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xDD,
    0x5D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD5, 0x45, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xE5, 0xEE, 0xEE, 0xE5, 0xEE, 0xEE,
    0x5E, 0xEE, 0xEE, 0xEE, 0xE5, 0xE5, 0xEE, 0xE5, 0x54, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0x45, 0xEE, 0xEE, 0x55, 0xEE, 0xEE, 0xE5, 0xED, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0x5D, 0xDD, 0xDD, 0xDD, 0x55, 0xDD, 0xDD,
    0x55, 0x5D, 0x4D, 0xDD, 0xDD, 0x45, 0xDD, 0x5D, 0xDD, 0xDD, 0xDD, 0xDD,
    0x54, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE, 0x5E, 0xEE, 0x5E, 0xEE,
    0xEE, 0x5E, 0xEE, 0xEE, 0xE5, 0xEE, 0xEE, 0xEE, 0x4E, 0xEE, 0x4E, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x5E, 0xEE, 0xE4, 0xE5, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE5, 0xEE, 0xEE, 0xEE, 0x5E, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE5, 0x5E, 0xEE, 0xEE, 0xEE, 0xEE, 0xED,
    0xEE, 0xED, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE5, 0xED, 0xED,
    0xEE, 0xEE, 0xEE, 0x5E, 0xEE, 0xEE, 0xED, 0xED, 0xEE, 0xE5, 0xEE, 0xEE,
    0xED, 0xED, 0xED, 0xEE, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xF9, 0xF8, 0xF9, 0x4F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xF8, 0x64, 0x68, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x85, 0x12, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x52, 0x14, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
    0x54, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xF7, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x7F, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6,
    0xF6, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF7, 0xF6, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0x66, 0xF6,
    0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x67, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFD, 0xBF, 0xF7, 0xF7, 0x6F, 0x66, 0x6F, 0x66, 0xF6, 0xFF,
    0xFF, 0xF6, 0xF6, 0xFF, 0x75, 0x76, 0xF5, 0x66, 0x66, 0x66, 0xFF, 0xFF,
    0xF6, 0xFF, 0xFF, 0xF5, 0x57, 0x66, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xF6,
    0xFF, 0x56, 0x56, 0x75, 0x77, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xF7, 0xF6,
    0xF6, 0xF6, 0x44, 0xF5, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x66,
    0x56, 0x75, 0x56, 0xF6, 0xFF, 0xFD, 0xC6, 0xAF, 0xF6, 0x6F, 0xFF, 0x55,
    0x57, 0x5F, 0x7F, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0x65, 0x6F, 0xFF, 0x68,
    0x7F, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xF6, 0x5F, 0x65, 0x6F, 0x6F, 0xFF,
    0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xF6, 0x6F, 0xFF, 0xFF, 0xFF,
    0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF,
    0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x7F, 0x7F, 0xFF, 0xFF, 0x7F,
    0xFF, 0x7F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFD, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x61, 0x15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
 },
 {
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0xEE, 0xEE, 0xEE, 0xDE, 0xEE, 0xEE, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xED,
    0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xED,
    0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE,
    0x5E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x5E, 0xED,
    0xD5, 0x55, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xE5, 0xE5, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE5, 0xEE, 0xE5, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0x5E, 0x5E, 0xEE, 0x55, 0x54, 0xEE, 0xEE, 0xEE, 0xEE, 0xED,
    0xDD, 0xDD, 0xD5, 0x5D, 0x44, 0x5D, 0xDD, 0xDD, 0xDD, 0xDD, 0x5D, 0xD5,
    0xD5, 0x5D, 0xDD, 0xD3, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0x5D,
    0xD4, 0x35, 0x5D, 0xDD, 0xDD, 0xDD, 0xDD, 0xD5, 0x5E, 0xE4, 0x54, 0x53,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE5, 0xEE, 0xEE, 0x5E, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xE5, 0xEE, 0x5E, 0xEE, 0xE5, 0x5E, 0xEE, 0x5E,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0x5E, 0xEE, 0xE4, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xE5, 0xEE, 0xEE, 0xED, 0xEE, 0xED, 0xDD, 0xED, 0xED, 0xED, 0xED, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0xEE, 0xEE, 0xED,
    0xEE, 0xED, 0xED, 0xEE, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDC, 0xCD, 0xCC, 0xCC, 0xDC, 0xDD, 0xFF, 0xFF, 0xFF, 0xDD, 0xEF,
    0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xDF, 0xEF, 0xFF, 0xFF, 0xDF, 0xFD, 0xDC,
    0xBB, 0xBB, 0xAA, 0xBB, 0xCD, 0xDF, 0xFF, 0xFD, 0xED, 0xCC, 0xBB, 0xA9,
    0x99, 0x99, 0xAA, 0xBC, 0xDF, 0xFF, 0xCD, 0xCC, 0xBA, 0x99, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xDF, 0xEC, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xEE, 0xDD, 0xBA, 0xA8, 0x87, 0x76, 0x66, 0x67, 0x88, 0x9A,
    0xCD, 0xDD, 0xDB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x67, 0x89, 0xAB, 0xCD,
    0xCC, 0xA9, 0x87, 0x76, 0x55, 0x55, 0x56, 0x77, 0x89, 0xBD, 0xDC, 0xCB,
    0x98, 0x76, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBD, 0xCC, 0xA9, 0x87,
    0x65, 0x55, 0x55, 0x56, 0x67, 0x89, 0xAD, 0xCD, 0xCA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x66, 0x78, 0x9A, 0xCC, 0xDC, 0xB9, 0x87, 0x66, 0x55, 0x55,
    0x56, 0x77, 0x8A, 0xBC, 0xDD, 0xDB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x67,
    0x89, 0xAB, 0xCD, 0xEC, 0xCA, 0x98, 0x87, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBC, 0xDE, 0xDC, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x89, 0x9A, 0xBC, 0xDC,
    0xFE, 0xEC, 0xBA, 0x99, 0x88, 0x88, 0x89, 0x9A, 0xBC, 0xCD, 0xDF, 0xFE,
    0xDC, 0xBB, 0xA9, 0x99, 0x9A, 0xAA, 0xBC, 0xCD, 0xEE, 0xFF, 0xFF, 0xDC,
    0xCB, 0xBA, 0xAB, 0xBB, 0xCC, 0xDD, 0xDE, 0xDF, 0xFF, 0xFF, 0xED, 0xCC,
    0xCC, 0xCC, 0xCC, 0xDD, 0xEF, 0xED, 0xDF, 0xFF, 0xDF, 0xDD, 0xDD, 0xDC,
    0xCC, 0xCD, 0xED, 0xCE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xEE, 0xEE, 0xEE, 0xDE, 0xEE, 0xEE, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xED, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x4E,
    0xEE, 0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xD4, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0x4E, 0x4E, 0x4E, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x4E, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xE4, 0xE3, 0x4D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDD, 0x4D, 0x4D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0x44, 0x4D, 0x4D, 0xDD, 0xDD, 0xDD, 0xDD, 0x4E, 0xE4, 0xEE, 0x3E, 0x4E,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE3, 0xEE, 0xE5, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE4, 0xEE, 0xEE, 0xEE, 0x4E, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x4E, 0x3E, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE4, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0x4E, 0xEE, 0x4E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0xED, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x9C, 0xBB, 0xAA, 0xAA, 0xAA, 0x9A, 0xAA, 0xAB, 0xBC, 0xCD, 0xBB, 0xCC,
    0xBB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDC, 0xBC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xAB, 0xCD, 0xDB, 0xCB, 0xAA, 0x99, 0x99,
    0x88, 0x88, 0x89, 0x9A, 0xBB, 0xCC, 0xAB, 0xAA, 0xA9, 0x98, 0x88, 0x88,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0xAA, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xBA, 0xAA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0xAA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA, 0xA9,
    0x88, 0x76, 0x66, 0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xAA, 0x98, 0x87,
    0x66, 0x65, 0x55, 0x56, 0x67, 0x88, 0x9A, 0xAA, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x66, 0x78, 0x99, 0xAA, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x56,
    0x66, 0x77, 0x89, 0x9A, 0xAA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x99, 0xAA, 0xAB, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xAB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0xAA, 0xBA,
    0xBB, 0xBA, 0x99, 0x98, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBC, 0xCC,
    0xBA, 0x99, 0x98, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xBB, 0xDD, 0xCC, 0xBA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBD, 0xDD, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCB, 0xBC, 0xCB, 0xBA, 0xAA, 0xA9, 0x9A,
    0xAA, 0xAA, 0xBA, 0xBC, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0x9A, 0xBB, 0xCC, 0xBB, 0xCC,
    0xCA, 0xAA, 0xAA, 0x9A, 0xA9, 0xAA, 0xBB, 0xBD, 0xDC, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x98, 0x99, 0xA9, 0xAB, 0xBB, 0xCB, 0xBA, 0xAA, 0x99, 0x88,
    0x88, 0x88, 0x89, 0x99, 0xAB, 0xBB, 0xAA, 0xA9, 0x98, 0x88, 0x88, 0x77,
    0x88, 0x88, 0x9A, 0xAB, 0xAA, 0xAA, 0x98, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x88, 0x99, 0xBA, 0x9A, 0x99, 0x88, 0x77, 0x76, 0x66, 0x77, 0x77, 0x89,
    0x9A, 0xA9, 0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77, 0x78, 0x89, 0xAA,
    0x99, 0x98, 0x87, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0x99, 0x99,
    0x88, 0x76, 0x66, 0x66, 0x66, 0x67, 0x77, 0x89, 0x99, 0x99, 0x98, 0x77,
    0x66, 0x66, 0x56, 0x66, 0x67, 0x78, 0x99, 0x99, 0xA9, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x66, 0x77, 0x89, 0xA9, 0x99, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x99, 0x99, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x78, 0x89, 0xA9, 0xAA, 0x99, 0x88, 0x77, 0x76, 0x67, 0x77, 0x78, 0x89,
    0x9A, 0x9A, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78, 0x88, 0x9A, 0xB9,
    0xAB, 0xAA, 0x99, 0x88, 0x87, 0x77, 0x88, 0x89, 0x99, 0xAB, 0xAB, 0xCA,
    0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x99, 0xAB, 0xBB, 0xBB, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xBC, 0xCC, 0xCB, 0xAA, 0x9A,
    0x99, 0x9A, 0x9A, 0xAB, 0xBC, 0xCC, 0xBC, 0xCA, 0xAA, 0xA9, 0x99, 0x99,
    0x99, 0x9A, 0xAA, 0xAB, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xBB, 0xCC,
    0xBB, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0xCC, 0xBC, 0xBA, 0xAA,
    0x99, 0x99, 0x89, 0x99, 0x99, 0xAA, 0xBC, 0xBA, 0xBA, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xAA, 0xA9, 0x98, 0x88, 0x87, 0x77,
    0x88, 0x88, 0x99, 0xAA, 0xAA, 0xA9, 0x98, 0x88, 0x77, 0x77, 0x77, 0x77,
    0x88, 0x99, 0xAA, 0x9A, 0x99, 0x88, 0x77, 0x77, 0x67, 0x77, 0x77, 0x89,
    0x9A, 0x99, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x66, 0x77, 0x78, 0x89, 0xA9,
    0x99, 0x98, 0x87, 0x76, 0x66, 0x66, 0x66, 0x77, 0x78, 0x99, 0x99, 0x98,
    0x87, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x89, 0x99, 0x99, 0x88, 0x77,
    0x76, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0x99, 0x99, 0x87, 0x77, 0x66,
    0x66, 0x66, 0x67, 0x77, 0x89, 0x99, 0x99, 0x98, 0x77, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x99, 0x99, 0x99, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x78, 0x89, 0xA9, 0x9A, 0x98, 0x87, 0x77, 0x77, 0x67, 0x77, 0x78, 0x89,
    0x9A, 0x9A, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78, 0x88, 0x99, 0xA9,
    0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77, 0x88, 0x88, 0x99, 0xAB, 0xAA, 0xBA,
    0xA9, 0x98, 0x88, 0x88, 0x88, 0x89, 0x99, 0xAA, 0xBA, 0xBB, 0xBA, 0xA9,
    0x99, 0x99, 0x89, 0x99, 0x99, 0xAA, 0xBB, 0xBC, 0xCB, 0xBB, 0xAA, 0xA9,
    0x99, 0x99, 0xAA, 0xAA, 0xBC, 0xCB, 0xBC, 0xBB, 0xAA, 0x99, 0x99, 0x99,
    0x99, 0x9A, 0xAA, 0xBB, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9C, 0xBA, 0xAA, 0x9A, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xCB, 0xAB, 0xCC,
    0xBA, 0xAA, 0xA9, 0x99, 0xA9, 0xAA, 0xAA, 0xBC, 0xCC, 0xAC, 0xBA, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xBB, 0xCB, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCC, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77,
    0x78, 0x88, 0x99, 0xAA, 0xAA, 0xBA, 0x98, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xAA, 0x9A, 0x99, 0x88, 0x77, 0x76, 0x67, 0x77, 0x77, 0x88,
    0x9A, 0x99, 0x99, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x89, 0xA9,
    0x99, 0x98, 0x77, 0x76, 0x66, 0x66, 0x66, 0x67, 0x88, 0x89, 0x99, 0x98,
    0x87, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0xA9, 0x99, 0x98, 0x87,
    0x66, 0x66, 0x66, 0x66, 0x67, 0x78, 0x89, 0x99, 0x99, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x77, 0x89, 0x99, 0x9A, 0x88, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0x99, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x78, 0x89, 0xA9, 0xAA, 0x99, 0x87, 0x77, 0x77, 0x67, 0x77, 0x77, 0x89,
    0x9A, 0xAA, 0xBA, 0x98, 0x88, 0x77, 0x77, 0x77, 0x78, 0x89, 0x99, 0xAA,
    0xAB, 0xAA, 0x98, 0x88, 0x87, 0x77, 0x88, 0x89, 0x9A, 0xAB, 0xAA, 0xBA,
    0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAA, 0xBB, 0xCC, 0xBA, 0xA9,
    0xA9, 0x99, 0x98, 0x99, 0x99, 0xAB, 0xAB, 0xAC, 0xCC, 0xBA, 0xAA, 0xA9,
    0x99, 0x9A, 0x9A, 0xBB, 0xBC, 0xCB, 0xBC, 0xBB, 0xAA, 0xA9, 0x99, 0x99,
    0x9A, 0x9A, 0xAA, 0xBB, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xAA, 0xAA, 0xA9, 0xAA, 0xAA, 0xBB, 0xBC, 0xDD, 0xCB, 0xDC,
    0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDD, 0xCC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xCD, 0xDB, 0xBB, 0xAA, 0x99, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xBC, 0xCC, 0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x89, 0x9A, 0xAB, 0xBA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xAA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0xA9,
    0x88, 0x76, 0x66, 0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xAA, 0x98, 0x87,
    0x66, 0x65, 0x55, 0x66, 0x67, 0x88, 0x9A, 0xA9, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0xAA, 0xB9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67,
    0x78, 0x99, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x77, 0x78, 0x89,
    0x9A, 0xAA, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x78, 0x89, 0x9A, 0xBA,
    0xBC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xAC, 0xCB,
    0xBA, 0x99, 0x98, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBB, 0xDC, 0xCB, 0xBA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCD, 0xDD, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDB, 0xBD, 0xCC, 0xBB, 0xAA, 0xAA, 0xAA,
    0x9A, 0xAA, 0xBB, 0xBC, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDC, 0xDD, 0xCC, 0xCC, 0xCD, 0xDE, 0xED, 0xFF, 0xFF, 0xCF, 0xFF,
    0xEE, 0xDD, 0xDC, 0xCD, 0xCD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEF, 0xFF, 0xFF, 0xFE, 0xDC, 0xBB, 0xAA,
    0xA9, 0xAA, 0xAB, 0xCD, 0xEF, 0xFF, 0xDD, 0xCC, 0xBA, 0x99, 0x88, 0x88,
    0x99, 0xAB, 0xCD, 0xEF, 0xFD, 0xDC, 0xBA, 0x99, 0x88, 0x77, 0x78, 0x89,
    0xAB, 0xCE, 0xFE, 0xDD, 0xCA, 0x98, 0x87, 0x76, 0x66, 0x77, 0x89, 0xAB,
    0xDF, 0xFD, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x77, 0x9A, 0xBC, 0xEE,
    0xDC, 0xBA, 0x97, 0x76, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xED, 0xCB,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xDC, 0xB9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBC, 0xDD, 0xCB, 0xA8, 0x76, 0x55,
    0x44, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xDD, 0xBA, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xCD, 0xDE, 0xDC, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDD, 0xFD, 0xDB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x99, 0xAC,
    0xCD, 0xDF, 0xFD, 0xCB, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xEF,
    0xFF, 0xFD, 0xCB, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xCD, 0xEF, 0xDF, 0xFE,
    0xED, 0xCB, 0xBA, 0xAA, 0xAB, 0xBC, 0xCC, 0xDE, 0xFF, 0xFF, 0xFF, 0xFD,
    0xDC, 0xBC, 0xCB, 0xCC, 0xCD, 0xDE, 0xFF, 0xEF, 0xFF, 0xFF, 0xFE, 0xEE,
    0xDD, 0xDE, 0xDE, 0xEF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xEE, 0xED, 0xDD,
    0xEE, 0xDF, 0xEE, 0xFE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDC, 0xCC, 0xCC, 0xCB, 0xCC, 0xCC, 0xEF, 0xFF, 0xDF, 0xCD, 0xFF,
    0xCD, 0xCC, 0xCC, 0xCC, 0xBD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDC, 0xBB,
    0xBB, 0xAB, 0xBA, 0xBC, 0xDC, 0xDF, 0xFF, 0xFD, 0xDC, 0xCB, 0xAA, 0xA9,
    0x99, 0x9A, 0xBB, 0xBC, 0xFF, 0xFF, 0xCC, 0xDB, 0xA9, 0x99, 0x88, 0x88,
    0x89, 0xAB, 0xCC, 0xDF, 0xFC, 0xDC, 0xA9, 0x98, 0x87, 0x77, 0x78, 0x89,
    0xAB, 0xCD, 0xFF, 0xBC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCF, 0xFC, 0xBB, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xCF,
    0xCC, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xFC, 0xBB,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xCB, 0xA8, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xEC, 0xBA, 0x87, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xCD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCC, 0xDD, 0xDB, 0x99, 0x87, 0x77, 0x77, 0x77, 0x89, 0xAB,
    0xBC, 0xCF, 0xFD, 0xBB, 0xA9, 0x88, 0x88, 0x88, 0x89, 0x9B, 0xCC, 0xFC,
    0xFF, 0xDD, 0xBA, 0x9A, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xFD, 0xDF, 0xFD,
    0xFD, 0xCB, 0xAA, 0xAA, 0xAA, 0xAA, 0xBC, 0xCF, 0xFD, 0xFF, 0xFF, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBB, 0xCD, 0xDD, 0xDF, 0xDF, 0xFF, 0xFF, 0xFD, 0xFD,
    0xCC, 0xCC, 0xFC, 0xCD, 0xFE, 0xFE, 0xDF, 0xFF, 0xFD, 0xDD, 0xFC, 0xDC,
    0xDD, 0xCC, 0xCE, 0xFD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xDD, 0xDC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEF, 0xFF, 0xFF, 0xFD, 0xFE,
    0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCE, 0xFF, 0xFF, 0xFF, 0xEF, 0xDD, 0xCB,
    0xBB, 0xAA, 0xAA, 0xBB, 0xCC, 0xDF, 0xFF, 0xFD, 0xED, 0xCB, 0xAA, 0xA9,
    0x99, 0x99, 0xAA, 0xBC, 0xDF, 0xFF, 0xDD, 0xCB, 0xAA, 0x99, 0x88, 0x88,
    0x89, 0x9A, 0xBD, 0xEF, 0xFC, 0xDB, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x88,
    0x9A, 0xBD, 0xFF, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x67, 0x89, 0xAB,
    0xCD, 0xFC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x67, 0x89, 0xAB, 0xDF,
    0xCC, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xCA,
    0x98, 0x76, 0x55, 0x55, 0x55, 0x66, 0x78, 0xAB, 0xCD, 0xCC, 0xA9, 0x87,
    0x65, 0x55, 0x45, 0x56, 0x67, 0x8A, 0xBD, 0xDC, 0xCA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x79, 0xAB, 0xCD, 0xDC, 0xB9, 0x87, 0x66, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xDE, 0xDB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x77,
    0x89, 0xAC, 0xCD, 0xFD, 0xCB, 0x98, 0x87, 0x76, 0x67, 0x77, 0x89, 0xAB,
    0xCD, 0xDF, 0xFD, 0xBA, 0x99, 0x88, 0x77, 0x78, 0x89, 0xAA, 0xBC, 0xDD,
    0xFF, 0xFD, 0xBA, 0xA9, 0x99, 0x89, 0x99, 0xAA, 0xBC, 0xDD, 0xEF, 0xFF,
    0xED, 0xCB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xFF, 0xFF, 0xFF, 0xED,
    0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xEF, 0xFF, 0xFF, 0xFE, 0xDD,
    0xCC, 0xCC, 0xDD, 0xEE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFD, 0xED, 0xDD,
    0xDD, 0xDD, 0xED, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAE, 0xCD, 0xCC, 0xEC, 0xCD, 0xCC, 0xCD, 0xEF, 0xFF, 0xFF, 0xDD, 0xFD,
    0xDC, 0xDC, 0xCD, 0xCC, 0xDD, 0xED, 0xDF, 0xFF, 0xFF, 0xCF, 0xDF, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDF, 0xFF, 0xFD, 0xFD, 0xCB, 0xBB, 0xAA,
    0x99, 0xA9, 0xAB, 0xCD, 0xFF, 0xFF, 0xDE, 0xCB, 0xBA, 0x99, 0x88, 0x88,
    0x89, 0xAA, 0xCD, 0xFF, 0xFD, 0xDC, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x88,
    0x9A, 0xBD, 0xFD, 0xCC, 0xBA, 0x99, 0x87, 0x66, 0x66, 0x67, 0x88, 0xAC,
    0xCF, 0xEC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x67, 0x89, 0xAC, 0xDD,
    0xDD, 0xBA, 0x97, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xDC, 0xCB,
    0x98, 0x76, 0x55, 0x54, 0x55, 0x67, 0x79, 0xAB, 0xDD, 0xDC, 0xB9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x77, 0x9A, 0xBC, 0xDD, 0xCB, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xBD, 0xDC, 0xB9, 0x97, 0x66, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xCD, 0xCD, 0xDB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x99, 0xAC, 0xDC, 0xFE, 0xCA, 0x98, 0x87, 0x76, 0x67, 0x78, 0x99, 0xAC,
    0xCD, 0xCD, 0xED, 0xBA, 0x99, 0x88, 0x78, 0x88, 0x99, 0xAB, 0xCD, 0xDC,
    0xFF, 0xFC, 0xBA, 0xA9, 0x99, 0x89, 0x99, 0xAB, 0xBC, 0xDD, 0xCF, 0xFF,
    0xFD, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xCB, 0xCD, 0xDC, 0xFF, 0xFF, 0xDD,
    0xCC, 0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xFF, 0xDF, 0xFF, 0xFF, 0xEE, 0xDE,
    0xDC, 0xCD, 0xDF, 0xEE, 0xFF, 0xFD, 0xDF, 0xFF, 0xEE, 0xDC, 0xDD, 0xCC,
    0xCC, 0xCC, 0xCC, 0xFD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAE, 0xED, 0xDE, 0xDD, 0xDD, 0xDE, 0xDF, 0xFF, 0xFF, 0xFF, 0xCD, 0xFE,
    0xFF, 0xEE, 0xDD, 0xDD, 0xCE, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xEE, 0xDC,
    0xCB, 0xCB, 0xBB, 0xCC, 0xDE, 0xEF, 0xFF, 0xFD, 0xFE, 0xDC, 0xCB, 0xAA,
    0xAA, 0xAA, 0xBC, 0xCD, 0xEF, 0xFF, 0xDF, 0xDC, 0xBB, 0xA9, 0x99, 0x99,
    0x9A, 0xAB, 0xDF, 0xFF, 0xFD, 0xDD, 0xBA, 0xA9, 0x88, 0x77, 0x78, 0x89,
    0xAB, 0xDE, 0xFF, 0xDD, 0xDB, 0xA9, 0x87, 0x76, 0x66, 0x77, 0x89, 0xBC,
    0xFE, 0xFD, 0xDB, 0xB9, 0x87, 0x66, 0x55, 0x56, 0x77, 0x9A, 0xBD, 0xFF,
    0xDD, 0xCA, 0x98, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9B, 0xCE, 0xFD, 0xEB,
    0xA9, 0x76, 0x55, 0x44, 0x45, 0x67, 0x89, 0xBD, 0xFF, 0xDD, 0xBA, 0x97,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9B, 0xCD, 0xED, 0xDB, 0xA9, 0x76, 0x55,
    0x44, 0x55, 0x67, 0x89, 0xBC, 0xFD, 0xED, 0xCB, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0xAB, 0xDF, 0xFD, 0xEC, 0xB9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xED, 0xDF, 0xFC, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x9A, 0xAC,
    0xDE, 0xEF, 0xFF, 0xCB, 0xA9, 0x88, 0x88, 0x88, 0x9A, 0xBB, 0xCE, 0xFE,
    0xFF, 0xFE, 0xCB, 0xBA, 0x99, 0x99, 0xAA, 0xAB, 0xCD, 0xEF, 0xEF, 0xFF,
    0xED, 0xDC, 0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEE, 0xFF, 0xFF, 0xFF, 0xFE,
    0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF,
    0xDE, 0xDE, 0xEF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xDD, 0xED, 0xCD,
    0xDD, 0xCC, 0xDD, 0xDE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xAC, 0xDC,
    0xCB, 0xBB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDD, 0xFE, 0xCC, 0xCB, 0xBA,
    0xAA, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDE, 0xDB, 0xCB, 0xAA, 0xA9, 0x99,
    0x88, 0x89, 0x99, 0xAB, 0xBC, 0xED, 0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x99, 0xAB, 0xCC, 0xCB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x99, 0xAB, 0xCC, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x78, 0x99,
    0xBC, 0xBA, 0xAA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xBA, 0xA9,
    0x88, 0x76, 0x65, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0x98, 0x87,
    0x66, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xBA, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBB, 0xBB, 0xA9, 0x87, 0x66, 0x65, 0x56,
    0x66, 0x77, 0x89, 0xAB, 0xBB, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBB, 0xBB, 0xA9, 0x98, 0x77, 0x77, 0x67, 0x77, 0x88, 0x9A,
    0xBB, 0xBC, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x88, 0x99, 0xAB, 0xCB,
    0xCC, 0xCB, 0xA9, 0x98, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBC, 0xBD, 0xDC,
    0xBB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCC, 0xEE, 0xDC, 0xCB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xCD, 0xFD, 0xDC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEC, 0xBD, 0xDD, 0xCC, 0xCB, 0xBB, 0xBB,
    0xBB, 0xBB, 0xCB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x8A, 0xA9, 0x99, 0x99, 0x98, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xAA, 0xBB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xDC, 0xAB, 0xBA, 0xA9,
    0x99, 0x99, 0x88, 0x99, 0x9A, 0xAA, 0xBC, 0xC9, 0xAA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x99, 0xAB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x78, 0x88, 0x99, 0xAB, 0xB9, 0xA9, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77,
    0x88, 0x9A, 0xAA, 0x9A, 0x98, 0x87, 0x77, 0x76, 0x66, 0x77, 0x78, 0x89,
    0xAA, 0xA9, 0x99, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77, 0x78, 0x89, 0xA9,
    0x99, 0x98, 0x87, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0x99, 0x99,
    0x87, 0x76, 0x66, 0x66, 0x66, 0x67, 0x78, 0x89, 0x99, 0x89, 0x88, 0x77,
    0x66, 0x66, 0x66, 0x66, 0x77, 0x78, 0x9A, 0x99, 0x98, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x78, 0x89, 0x99, 0x99, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x99, 0x99, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x78, 0x89, 0xA9, 0x9A, 0x99, 0x87, 0x77, 0x77, 0x67, 0x77, 0x78, 0x89,
    0x9A, 0x9A, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78, 0x89, 0x9A, 0xBA,
    0xAB, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x88, 0x99, 0x99, 0xAB, 0xAB, 0xBB,
    0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x99, 0xAA, 0xBA, 0xBC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xAB, 0xAD, 0xDD, 0xBB, 0xAA, 0xA9,
    0xA9, 0x9A, 0xAA, 0xAB, 0xBB, 0xDB, 0xAC, 0xCB, 0xAA, 0xA9, 0x99, 0x99,
    0x99, 0x9A, 0xAA, 0xAB, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xAA, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xBA, 0xCB,
    0xBB, 0xAA, 0xAA, 0xA9, 0xAA, 0xAA, 0xBB, 0xCC, 0xDC, 0xAB, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xCA, 0xBA, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xAA, 0x98, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0x9A, 0x99, 0x88, 0x77, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0x9A, 0x98, 0x87, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x66, 0x55, 0x66, 0x66, 0x78, 0x89, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x65, 0x55, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x56, 0x66, 0x67, 0x78, 0x89, 0xAA, 0xAA, 0x98, 0x77, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x67, 0x77, 0x88, 0x89,
    0xAB, 0xAB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0xAA, 0xBA,
    0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xAB, 0xCB,
    0xAA, 0x99, 0x98, 0x88, 0x89, 0x99, 0x9A, 0xAB, 0xBB, 0xCC, 0xCB, 0xBA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xAB, 0xBC, 0xBD, 0xDC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDB, 0xBC, 0xCB, 0xBB, 0xAA, 0xAA, 0x9A,
    0xAA, 0xAA, 0xAA, 0xBB, 0x90, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xAA, 0xBC, 0xBD, 0xBB, 0xCC,
    0xBB, 0xBA, 0xAA, 0xA9, 0xA9, 0xAA, 0xBB, 0xCD, 0xDD, 0xBC, 0xBA, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBD, 0xCB, 0xBB, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCC, 0xAB, 0xAA, 0x99, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xAB, 0xBA, 0xAA, 0x98, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0xAA, 0x99, 0x87, 0x77, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0x9A, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA, 0x99,
    0x87, 0x76, 0x66, 0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x67, 0x88, 0x9A, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x65, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x77, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x88, 0x9A, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x76, 0x67, 0x77, 0x78, 0x99,
    0xAB, 0xAB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x99, 0xAA, 0xBB,
    0xBC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x89, 0xAA, 0xBB, 0xBC, 0xCC,
    0xAA, 0x99, 0x98, 0x88, 0x89, 0x99, 0x9A, 0xBB, 0xCB, 0xCD, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xBD, 0xDC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBB, 0xCC, 0xDB, 0xAD, 0xCB, 0xBB, 0xBA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDE, 0xBC, 0xDC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xFD, 0xBC, 0xCB, 0xBA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCE, 0xDB, 0xBB, 0xAA, 0x99, 0x98,
    0x88, 0x89, 0x99, 0xAB, 0xBC, 0xDD, 0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x99, 0xAB, 0xBC, 0xCB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x89, 0xAB, 0xCC, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x78, 0x9A,
    0xAB, 0xBA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xBB,
    0xAA, 0x99, 0x87, 0x66, 0x65, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xBA, 0xA9,
    0x88, 0x76, 0x65, 0x55, 0x55, 0x67, 0x78, 0x99, 0xBB, 0xAA, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xBA, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBB, 0xAA, 0x99, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x77, 0x89, 0xAB, 0xBB, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBB, 0xBB, 0xAA, 0x98, 0x77, 0x76, 0x67, 0x77, 0x88, 0x9A,
    0xAB, 0xBB, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x88, 0x99, 0xAB, 0xBB,
    0xCC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x89, 0x99, 0xAA, 0xBC, 0xBC, 0xCC,
    0xBB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDC, 0xDD, 0xDC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xCE, 0xFD, 0xDC, 0xCB, 0xBB,
    0xAB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDC, 0xBD, 0xDC, 0xCC, 0xBB, 0xBB, 0xAA,
    0xAB, 0xBB, 0xBC, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xBE, 0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xEF, 0xFF, 0xFF, 0xBE, 0xFF,
    0xED, 0xDD, 0xCD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xED, 0xDC,
    0xCC, 0xBC, 0xBC, 0xDD, 0xDE, 0xFF, 0xFF, 0xFD, 0xDD, 0xDC, 0xBB, 0xAA,
    0xAA, 0xBB, 0xCC, 0xDE, 0xFF, 0xFF, 0xDE, 0xDC, 0xBA, 0xA9, 0x99, 0x99,
    0x9A, 0xBC, 0xDE, 0xFF, 0xFD, 0xDC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x9A,
    0xBC, 0xDF, 0xFF, 0xDD, 0xCB, 0xA9, 0x87, 0x76, 0x67, 0x78, 0x9A, 0xBD,
    0xFF, 0xFD, 0xDC, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9B, 0xCD, 0xFE,
    0xDD, 0xBA, 0x98, 0x76, 0x54, 0x45, 0x56, 0x89, 0xAB, 0xEE, 0xFD, 0xDB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBD, 0xEE, 0xDD, 0xBA, 0x98,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xDE, 0xED, 0xEC, 0xA9, 0x87, 0x55,
    0x44, 0x45, 0x67, 0x9A, 0xBC, 0xED, 0xED, 0xCB, 0x98, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAB, 0xCE, 0xEE, 0xFD, 0xBA, 0x98, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBD, 0xEE, 0xFF, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xEF, 0xFE, 0xDC, 0xBA, 0x99, 0x88, 0x99, 0x9A, 0xBB, 0xCD, 0xFE,
    0xEF, 0xFE, 0xDC, 0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDF, 0xEF, 0xFF,
    0xFE, 0xDC, 0xCC, 0xCB, 0xBB, 0xBC, 0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xED, 0xDD, 0xCC, 0xCD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xDE, 0xED, 0xEE, 0xEF, 0xFF, 0xFF, 0xBE, 0xFF, 0xFF, 0xEE, 0xEE, 0xDE,
    0xED, 0xDD, 0xEE, 0xFE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDF, 0xFE, 0xFF, 0xBC, 0xED,
    0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xDE, 0xFF, 0xFF, 0xFF, 0xCD, 0xDC, 0xCC,
    0xBB, 0xAB, 0xAB, 0xBC, 0xCD, 0xEF, 0xFF, 0xFC, 0xDC, 0xCB, 0xAA, 0xA9,
    0x99, 0x9A, 0xAB, 0xCC, 0xFF, 0xFE, 0xCD, 0xCB, 0xAA, 0x99, 0x88, 0x88,
    0x99, 0xAB, 0xCD, 0xEF, 0xFC, 0xCB, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x89,
    0xAB, 0xCE, 0xFE, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xDE, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x56, 0x77, 0x8A, 0xBC, 0xDE,
    0xCC, 0xB9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9B, 0xCD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x45, 0x67, 0x89, 0xAC, 0xDD, 0xCC, 0xB9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xCD, 0xDD, 0xCB, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xCD, 0xCC, 0xBA, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xCC, 0xCD, 0xDB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDD, 0xDD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xDD, 0xDE, 0xED, 0xBB, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCC, 0xDD,
    0xFF, 0xEC, 0xCB, 0xAA, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xDD, 0xDF, 0xFF,
    0xFE, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xED, 0xDD, 0xFF, 0xFF, 0xEE,
    0xCC, 0xCB, 0xBB, 0xCC, 0xCC, 0xDD, 0xEE, 0xDF, 0xFF, 0xFF, 0xFE, 0xED,
    0xDC, 0xCD, 0xCD, 0xDD, 0xDE, 0xED, 0xCF, 0xFF, 0xFE, 0xEE, 0xDD, 0xDD,
    0xCD, 0xCC, 0xDD, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDE, 0xFF, 0xFF, 0xDD, 0xED,
    0xDC, 0xCC, 0xCB, 0xBB, 0xCC, 0xCD, 0xEE, 0xFF, 0xFF, 0xDE, 0xDD, 0xCB,
    0xBB, 0xAA, 0xAA, 0xBB, 0xCD, 0xDF, 0xFF, 0xFD, 0xDC, 0xBB, 0xAA, 0x99,
    0x99, 0x99, 0xAB, 0xBC, 0xDE, 0xFF, 0xCD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0xAA, 0xBC, 0xEF, 0xFC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0x9B, 0xCD, 0xEE, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x67, 0x89, 0xAB,
    0xCD, 0xEC, 0xCA, 0x98, 0x87, 0x66, 0x55, 0x56, 0x67, 0x89, 0xAC, 0xDE,
    0xCB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x54, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xDC, 0xCA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xCC, 0xBA, 0x87, 0x66, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xDD, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x99, 0xAB, 0xDD, 0xDD, 0xCA, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDE, 0xDC, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x89, 0xAA, 0xBC, 0xDD,
    0xEE, 0xDC, 0xBB, 0xA9, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xDF, 0xFF,
    0xDD, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xFD, 0xFF, 0xFF, 0xED,
    0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xDF, 0xFF, 0xFE, 0xED, 0xDD,
    0xCC, 0xCC, 0xCD, 0xDE, 0xEF, 0xFE, 0xCF, 0xFF, 0xFF, 0xDE, 0xDD, 0xDD,
    0xCD, 0xDD, 0xDE, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xBE, 0xDD, 0xCC, 0xCC, 0xCC, 0xCD, 0xDF, 0xEE, 0xFF, 0xFF, 0xCD, 0xDE,
    0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFF, 0xDD, 0xCC, 0xBB,
    0xBB, 0xBB, 0xBB, 0xBB, 0xCD, 0xDF, 0xFF, 0xFD, 0xDC, 0xCB, 0xBA, 0xA9,
    0x99, 0xAA, 0xAB, 0xCD, 0xFF, 0xFF, 0xCC, 0xBB, 0xA9, 0x98, 0x88, 0x88,
    0x99, 0xAB, 0xCF, 0xFF, 0xFC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAB, 0xCE, 0xFF, 0xCD, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xDD, 0xFC, 0xCB, 0x98, 0x87, 0x65, 0x55, 0x56, 0x77, 0x8A, 0xBD, 0xFF,
    0xCC, 0xB9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xED, 0xCB,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xCC, 0xB9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xDD, 0xCB, 0xA8, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xED, 0xBA, 0x98, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xCD, 0xFC, 0xB9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x99, 0xAB, 0xFD, 0xFF, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDF, 0xFD, 0xBB, 0xA9, 0x98, 0x88, 0x88, 0x89, 0xAB, 0xCC, 0xDD,
    0xFF, 0xDE, 0xCC, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xDD, 0xCF, 0xFF,
    0xDD, 0xCB, 0xBB, 0xBA, 0xAA, 0xBB, 0xBC, 0xCD, 0xED, 0xFF, 0xFF, 0xDD,
    0xDD, 0xCC, 0xBB, 0xCC, 0xCC, 0xCD, 0xDD, 0xDF, 0xFF, 0xFF, 0xFE, 0xED,
    0xDC, 0xCD, 0xED, 0xDE, 0xDF, 0xEE, 0xBF, 0xFF, 0xFF, 0xFE, 0xED, 0xDC,
    0xDD, 0xCC, 0xCC, 0xDD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDD, 0xDC, 0xCC, 0xDC, 0xCD, 0xDD, 0xDE, 0xFF, 0xEF, 0xBE, 0xEE,
    0xDD, 0xDC, 0xCC, 0xCD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFE, 0xDE, 0xDD, 0xCB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xDE, 0xEF, 0xFF, 0xFD, 0xDD, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAB, 0xBC, 0xCE, 0xFF, 0xFE, 0xCD, 0xDB, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xAC, 0xDD, 0xFF, 0xFD, 0xDC, 0xBA, 0x99, 0x87, 0x77, 0x78, 0x99,
    0xBC, 0xDE, 0xEE, 0xDC, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x78, 0x9A, 0xBC,
    0xDF, 0xFC, 0xDB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBD, 0xFE,
    0xCC, 0xBA, 0x98, 0x66, 0x55, 0x45, 0x56, 0x78, 0xAB, 0xCE, 0xDD, 0xCB,
    0xA8, 0x76, 0x55, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xDE, 0xDD, 0xBA, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x78, 0x9B, 0xCD, 0xDD, 0xDB, 0xA9, 0x86, 0x55,
    0x44, 0x55, 0x67, 0x89, 0xBC, 0xDE, 0xDD, 0xCB, 0x98, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDE, 0xFC, 0xBA, 0x98, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xFF, 0xDC, 0xAA, 0x98, 0x77, 0x77, 0x88, 0x99, 0xAB,
    0xCD, 0xDE, 0xFE, 0xDB, 0xBA, 0x98, 0x88, 0x89, 0x9A, 0xAB, 0xCD, 0xDE,
    0xEF, 0xEE, 0xCC, 0xBA, 0xA9, 0x99, 0x9A, 0xAB, 0xCC, 0xED, 0xEF, 0xFF,
    0xFD, 0xDC, 0xBB, 0xBB, 0xBB, 0xBB, 0xCD, 0xDE, 0xEF, 0xFF, 0xFF, 0xFE,
    0xDD, 0xCD, 0xCC, 0xCC, 0xCC, 0xDE, 0xEF, 0xEF, 0xFF, 0xFF, 0xFE, 0xED,
    0xDD, 0xDD, 0xDD, 0xEE, 0xFF, 0xFE, 0xBF, 0xEE, 0xEE, 0xFE, 0xED, 0xDD,
    0xDD, 0xDD, 0xDE, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0x9C, 0xCB, 0xBB, 0xBA, 0xBA, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xAC, 0xDD,
    0xCC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEF, 0xFE, 0xCD, 0xCB, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xEF, 0xDB, 0xCB, 0xBA, 0xA9, 0x99,
    0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xED, 0xBC, 0xBA, 0xA9, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xBB, 0xCD, 0xDB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xDC, 0xBB, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0x9A,
    0xBC, 0xCB, 0xBA, 0x98, 0x77, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xCC,
    0xBB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xBB, 0xBA,
    0x98, 0x76, 0x55, 0x54, 0x55, 0x67, 0x88, 0x9A, 0xBB, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x89, 0xAB, 0xBB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x88, 0xAA, 0xBB, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xBB, 0xBA, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCB, 0xCC, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89, 0x9A,
    0xBC, 0xBC, 0xCB, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xBB, 0xCC,
    0xCD, 0xCB, 0xAA, 0x99, 0x98, 0x89, 0x99, 0x9A, 0xBB, 0xCD, 0xCC, 0xDD,
    0xCB, 0xBA, 0xAA, 0xA9, 0x9A, 0xAA, 0xBC, 0xCC, 0xDC, 0xDE, 0xED, 0xCC,
    0xBB, 0xBA, 0xAA, 0xAB, 0xBB, 0xCC, 0xCD, 0xCD, 0xFE, 0xED, 0xDC, 0xCC,
    0xBB, 0xCB, 0xCC, 0xCD, 0xDD, 0xEC, 0xAD, 0xDD, 0xCC, 0xCC, 0xBB, 0xBB,
    0xBB, 0xCB, 0xCC, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xAA, 0xA9, 0xA9, 0x9A, 0xAA, 0xAB, 0xBB, 0xCC, 0xAB, 0xDC,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xED, 0xBB, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xCA, 0xBB, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xBB, 0xDC, 0xAB, 0xAA, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xAA, 0x98, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAB, 0xBB, 0xAA, 0x99, 0x87, 0x77, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xBA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x9A, 0xBB,
    0x9A, 0x98, 0x87, 0x66, 0x65, 0x56, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0xAA, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xAA, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xBB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x99, 0xAB, 0xBB,
    0xBC, 0xBA, 0x99, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBC, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xCD, 0xCB, 0xBB,
    0xAA, 0xA9, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xCD, 0xEC, 0xDC, 0xBB, 0xBB,
    0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDC, 0xAD, 0xCC, 0xCB, 0xBA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xAB, 0xCB,
    0xBA, 0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xDC, 0xBC, 0xBA, 0xA9,
    0x99, 0x99, 0x89, 0x99, 0x9A, 0xAB, 0xCC, 0xCA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x78, 0x89, 0x9A, 0xBB, 0xBA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x99, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x66, 0x55, 0x56, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x88, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x78, 0x89, 0xAA, 0x9A, 0x98, 0x77, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x99, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0xAA, 0xBA,
    0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0x9A, 0xBB, 0xBB, 0xCB,
    0xAA, 0x99, 0x98, 0x88, 0x89, 0x99, 0xAA, 0xAB, 0xCB, 0xBC, 0xCB, 0xBA,
    0xA9, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xBC, 0xDC, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDC, 0xAC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xAA, 0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xAB, 0xCC,
    0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xAB, 0xBA, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCD, 0xCA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xBB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBC, 0xBA, 0xBA, 0x98, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0x9A, 0x99, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x67, 0x88, 0x9A, 0xAA,
    0x9A, 0x98, 0x77, 0x66, 0x66, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x89, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x67, 0x77, 0x89, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x67, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAB, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0xAA, 0xBA,
    0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xAC, 0xBB, 0xCB,
    0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xBD, 0xCB, 0xBA,
    0xAA, 0x99, 0x99, 0x9A, 0xAA, 0xAB, 0xCD, 0xCD, 0xDC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBB, 0xCC, 0xDC, 0xAC, 0xCC, 0xBB, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0xCC, 0x9B, 0xCC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDD, 0xED, 0xBC, 0xCB, 0xBA,
    0xAA, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xDD, 0xCB, 0xCB, 0xAA, 0x99, 0x99,
    0x89, 0x99, 0x9A, 0xAB, 0xCC, 0xDC, 0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x9A, 0xAB, 0xCD, 0xCA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBB, 0xCC, 0xAB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xBC, 0xBA, 0xAA, 0x98, 0x77, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xBB,
    0xAA, 0x99, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xAB, 0xBA, 0xA9,
    0x98, 0x76, 0x55, 0x55, 0x55, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0x99, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x89, 0xAB, 0xBA, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xAB, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xBB, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xBC, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xAB, 0xBB, 0xCB, 0xAA, 0x98, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xCC, 0xCB, 0xAA, 0x99, 0x98, 0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xBC, 0xDC,
    0xCB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDC, 0xCE, 0xDC, 0xCB,
    0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xCD, 0xED, 0xDD, 0xCC, 0xCB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xEC, 0xAD, 0xCC, 0xCC, 0xBB, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xFE, 0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xBF, 0xFF,
    0xFE, 0xFD, 0xDD, 0xDD, 0xDE, 0xEE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xED,
    0xCC, 0xCB, 0xCC, 0xCC, 0xDE, 0xEF, 0xFF, 0xEE, 0xFF, 0xEC, 0xCB, 0xBA,
    0xAA, 0xAB, 0xBC, 0xDD, 0xFF, 0xFE, 0xEF, 0xED, 0xCB, 0xAA, 0x99, 0x99,
    0xAA, 0xBC, 0xDE, 0xFF, 0xEE, 0xFD, 0xCB, 0xA9, 0x88, 0x88, 0x89, 0x9A,
    0xBC, 0xDE, 0xFF, 0xDE, 0xCB, 0xA9, 0x87, 0x76, 0x77, 0x78, 0x9A, 0xBD,
    0xEF, 0xED, 0xEC, 0xB9, 0x87, 0x66, 0x55, 0x66, 0x79, 0xAB, 0xCE, 0xFE,
    0xDD, 0xCA, 0x98, 0x76, 0x54, 0x45, 0x67, 0x89, 0xAC, 0xDE, 0xED, 0xDB,
    0xA9, 0x86, 0x54, 0x43, 0x45, 0x68, 0x9A, 0xCD, 0xEE, 0xDD, 0xBA, 0x98,
    0x75, 0x43, 0x34, 0x56, 0x79, 0xAB, 0xDE, 0xED, 0xDC, 0xB9, 0x87, 0x65,
    0x44, 0x55, 0x78, 0x9A, 0xCD, 0xEE, 0xDD, 0xCB, 0xA9, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xBC, 0xDF, 0xED, 0xED, 0xBA, 0x98, 0x77, 0x66, 0x77, 0x89,
    0xAB, 0xCD, 0xFE, 0xDE, 0xEC, 0xBA, 0x99, 0x88, 0x78, 0x89, 0xAB, 0xBD,
    0xEF, 0xED, 0xFE, 0xDC, 0xBA, 0xA9, 0x99, 0x99, 0xAB, 0xBC, 0xDF, 0xFE,
    0xEF, 0xFE, 0xDC, 0xBB, 0xBA, 0xAA, 0xBB, 0xCD, 0xDE, 0xEF, 0xFD, 0xFE,
    0xEE, 0xDD, 0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xFF, 0xFF, 0xEF, 0xFF, 0xEE,
    0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEE,
    0xFE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xAE, 0xEE, 0xEE, 0xEE, 0xDD, 0xDE,
    0xEF, 0xFE, 0xEE, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xBE, 0xDC, 0xDC, 0xCC, 0xCB, 0xCB, 0xCC, 0xCC, 0xDD, 0xCD, 0xAD, 0xED,
    0xDD, 0xCC, 0xCC, 0xCC, 0xBC, 0xCD, 0xCE, 0xEF, 0xFE, 0xEE, 0xDC, 0xCB,
    0xBB, 0xBA, 0xAB, 0xBB, 0xCC, 0xDE, 0xDF, 0xDC, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x9A, 0xAB, 0xCD, 0xDE, 0xFD, 0xCD, 0xCB, 0xA9, 0x99, 0x88, 0x88,
    0x99, 0xAA, 0xBC, 0xEF, 0xDC, 0xDB, 0xAA, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAB, 0xCD, 0xDD, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xDE, 0xDC, 0xCB, 0x98, 0x77, 0x65, 0x55, 0x56, 0x77, 0x89, 0xBC, 0xDD,
    0xCC, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9B, 0xBC, 0xDB, 0xCA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xDC, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xCC, 0xBA, 0x88, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xCC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDC, 0xCD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAC,
    0xCE, 0xDC, 0xDD, 0xCA, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xED,
    0xDD, 0xDC, 0xCB, 0xAA, 0x99, 0x99, 0x9A, 0xAC, 0xCD, 0xEE, 0xDD, 0xEF,
    0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xED, 0xFD, 0xEE, 0xEE, 0xDD,
    0xDC, 0xCB, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xED, 0xFF, 0xED, 0xED, 0xDD,
    0xDC, 0xCD, 0xDD, 0xEE, 0xEF, 0xFE, 0xAD, 0xED, 0xDD, 0xDD, 0xCD, 0xDC,
    0xDD, 0xDE, 0xED, 0xED, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xDD, 0xCC, 0xCC, 0xBB, 0xBC, 0xCC, 0xCD, 0xDE, 0xEF, 0xCE, 0xFE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xDE, 0xFF, 0xFF, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCE, 0xFF, 0xED, 0xDC, 0xBB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xFE, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x88, 0x9A, 0xBC, 0xDE, 0xEC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xDE, 0xCC, 0xB9, 0x98, 0x77, 0x66, 0x66, 0x67, 0x88, 0x9B,
    0xCD, 0xDC, 0xBA, 0x98, 0x76, 0x65, 0x55, 0x56, 0x67, 0x89, 0xAB, 0xDD,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xDB, 0xBA,
    0x98, 0x76, 0x55, 0x55, 0x55, 0x67, 0x78, 0xAB, 0xCC, 0xCB, 0xA9, 0x87,
    0x65, 0x55, 0x55, 0x56, 0x77, 0x8A, 0xBC, 0xCC, 0xBA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x89, 0xAC, 0xDD, 0xDD, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xDC, 0xBA, 0x99, 0x88, 0x77, 0x88, 0x89, 0xAB, 0xBD, 0xDD,
    0xDE, 0xDC, 0xBA, 0x99, 0x98, 0x89, 0x99, 0xAB, 0xBC, 0xDE, 0xED, 0xFD,
    0xDC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xCC, 0xDE, 0xFE, 0xEF, 0xEE, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFE, 0xFF, 0xEE, 0xDD, 0xDC,
    0xCC, 0xCC, 0xDD, 0xEE, 0xEF, 0xFF, 0xCF, 0xEE, 0xED, 0xDD, 0xDD, 0xCC,
    0xCD, 0xDD, 0xDF, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xCC, 0xCC, 0xBB, 0xBB, 0xBC, 0xBC, 0xCC, 0xCC, 0xDD, 0xAC, 0xDD,
    0xDD, 0xCC, 0xCC, 0xBC, 0xBC, 0xCC, 0xDD, 0xDF, 0xFD, 0xDE, 0xEC, 0xCB,
    0xBB, 0xAA, 0xAA, 0xBB, 0xCC, 0xCD, 0xDE, 0xCC, 0xDD, 0xCB, 0xAA, 0xA9,
    0x99, 0x9A, 0xAB, 0xCC, 0xDD, 0xED, 0xCD, 0xBB, 0xAA, 0x99, 0x88, 0x88,
    0x99, 0xAA, 0xBC, 0xDD, 0xDB, 0xCB, 0xAA, 0x98, 0x87, 0x77, 0x78, 0x89,
    0xAB, 0xCC, 0xED, 0xBC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x77, 0x89, 0xAB,
    0xCD, 0xCB, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xBC, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xCA,
    0x98, 0x76, 0x55, 0x44, 0x45, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xB9, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xCA, 0xA8, 0x76, 0x65,
    0x44, 0x56, 0x67, 0x89, 0xAB, 0xCC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x78, 0x9A, 0xBD, 0xCC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDC, 0xCD, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x9A, 0xAB,
    0xCD, 0xCC, 0xDC, 0xBB, 0xA9, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xDC,
    0xCD, 0xDC, 0xBB, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCD, 0xCC, 0xED,
    0xDC, 0xCB, 0xBB, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xDD, 0xDE, 0xDD, 0xDD,
    0xCC, 0xBB, 0xBB, 0xCC, 0xCC, 0xCD, 0xDF, 0xDD, 0xFF, 0xED, 0xDD, 0xDC,
    0xCC, 0xCD, 0xDD, 0xEE, 0xEE, 0xFD, 0xAD, 0xDC, 0xDC, 0xCC, 0xCC, 0xBC,
    0xCC, 0xCC, 0xDC, 0xDE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAE, 0xED, 0xDD, 0xDD, 0xDD, 0xDC, 0xDD, 0xDD, 0xDD, 0xDD, 0x9E, 0xFF,
    0xFF, 0xED, 0xED, 0xDD, 0xEE, 0xEF, 0xFE, 0xFF, 0xFD, 0xDF, 0xEE, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDD, 0xEF, 0xFE, 0xFF, 0xED, 0xFE, 0xDD, 0xCC, 0xCB,
    0xBC, 0xCC, 0xDE, 0xEE, 0xEE, 0xFE, 0xDF, 0xDD, 0xCB, 0xBA, 0xAA, 0xAB,
    0xBC, 0xDD, 0xDF, 0xEF, 0xED, 0xED, 0xDB, 0xBA, 0x99, 0x88, 0x99, 0xAB,
    0xCD, 0xEF, 0xFD, 0xDE, 0xDC, 0xBA, 0x98, 0x77, 0x77, 0x89, 0xAB, 0xDD,
    0xFF, 0xDD, 0xED, 0xBA, 0x98, 0x76, 0x55, 0x67, 0x89, 0xBC, 0xDD, 0xFE,
    0xDE, 0xCB, 0xA9, 0x76, 0x54, 0x45, 0x67, 0x9A, 0xCD, 0xEF, 0xED, 0xED,
    0xCA, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xCE, 0xED, 0xDE, 0xDB, 0xA8,
    0x75, 0x43, 0x24, 0x57, 0x8A, 0xBC, 0xDE, 0xED, 0xED, 0xCA, 0x97, 0x65,
    0x44, 0x46, 0x78, 0xAC, 0xCD, 0xED, 0xDE, 0xDD, 0xBA, 0x87, 0x65, 0x56,
    0x68, 0x9A, 0xBD, 0xEF, 0xDD, 0xFE, 0xDC, 0xA9, 0x87, 0x77, 0x78, 0x8A,
    0xBC, 0xDE, 0xEE, 0xEF, 0xFD, 0xDB, 0xAA, 0x98, 0x88, 0x9A, 0xAB, 0xCD,
    0xFF, 0xDD, 0xFE, 0xED, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDF, 0xFE,
    0xDF, 0xFE, 0xED, 0xDC, 0xCB, 0xBB, 0xBC, 0xCC, 0xDE, 0xFF, 0xEE, 0xFF,
    0xFF, 0xFE, 0xDD, 0xCD, 0xDD, 0xDD, 0xEF, 0xEF, 0xFE, 0xFF, 0xFF, 0xFE,
    0xFE, 0xEE, 0xED, 0xEE, 0xEE, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xEF,
    0xFE, 0xEF, 0xFE, 0xFF, 0xFF, 0xFE, 0xAD, 0xDD, 0xDD, 0xDD, 0xED, 0xDE,
    0xDE, 0xEE, 0xDD, 0xEE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xDC, 0xCB, 0xBB, 0xAA, 0xAB, 0xBB, 0xBC, 0xCD, 0xCD, 0xAD, 0xED,
    0xCC, 0xBB, 0xAA, 0xBA, 0xAB, 0xBC, 0xCD, 0xDF, 0xFD, 0xDD, 0xCC, 0xBB,
    0xAA, 0xA9, 0x9A, 0xAA, 0xBB, 0xCD, 0xEE, 0xDC, 0xDB, 0xBA, 0xA9, 0x99,
    0x99, 0x99, 0x9A, 0xAB, 0xCD, 0xDD, 0xBC, 0xBA, 0xA9, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xBB, 0xCD, 0xCB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBB, 0xCC, 0xBB, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x77, 0x89, 0x9A,
    0xBC, 0xCB, 0xBA, 0x98, 0x77, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xCC,
    0xBB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xAC, 0xCA, 0xA9,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x88, 0x9A, 0xBB, 0xAB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x99, 0xAB, 0xBB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x89, 0x9A, 0xBB, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x67, 0x78, 0x9A, 0xAC, 0xBB, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x89, 0xAB, 0xCC, 0xBC, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89, 0x9A,
    0xBC, 0xCC, 0xCB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xBB, 0xCC,
    0xCD, 0xCB, 0xAA, 0x99, 0x98, 0x99, 0x99, 0xAA, 0xBC, 0xCD, 0xCC, 0xDD,
    0xCB, 0xBA, 0xAA, 0x99, 0x9A, 0xAA, 0xBB, 0xCD, 0xDD, 0xCE, 0xDD, 0xCC,
    0xBB, 0xBA, 0xAA, 0xBB, 0xBC, 0xCD, 0xEE, 0xDD, 0xFD, 0xED, 0xCC, 0xCC,
    0xBC, 0xBC, 0xCC, 0xDD, 0xEE, 0xFE, 0x9D, 0xDD, 0xCC, 0xCC, 0xBB, 0xBB,
    0xBC, 0xCC, 0xDD, 0xEE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xAA, 0xAA, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0x9B, 0xDC,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCC, 0xDC, 0xBB, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCD, 0xCA, 0xBB, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xBC, 0xDC, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x78,
    0x88, 0x89, 0xAA, 0xBC, 0xBA, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x99, 0xAB, 0xBB, 0x9A, 0x99, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x9A,
    0xAB, 0xBA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x65, 0x56, 0x66, 0x77, 0x89, 0xAB, 0xAA, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x45, 0x66, 0x77, 0x89, 0xAB, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBA, 0xAB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0xBB, 0xBA, 0xA9, 0x88, 0x87, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xBB,
    0xBB, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xBC, 0xBB, 0xCC,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xCC, 0xCC, 0xCC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xCC, 0xDD, 0xDC, 0xCB, 0xBB,
    0xAA, 0xAB, 0xBB, 0xBC, 0xCC, 0xDD, 0x9C, 0xCB, 0xBB, 0xBA, 0xAA, 0xAA,
    0xAA, 0xBB, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xAB, 0xCB,
    0xBA, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xCC, 0xAB, 0xBA, 0xA9,
    0x99, 0x88, 0x89, 0x99, 0x9A, 0xAB, 0xBC, 0xBA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77,
    0x78, 0x89, 0x9A, 0xAB, 0xB9, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAA, 0xA9, 0x99, 0x87, 0x77, 0x66, 0x66, 0x66, 0x77, 0x78, 0x99, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x98,
    0x87, 0x76, 0x66, 0x55, 0x66, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x88, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x98, 0x77, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x89, 0xAA, 0xBA,
    0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xBB, 0xBB,
    0xAA, 0x99, 0x98, 0x88, 0x89, 0x99, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xBC, 0xDC, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDC, 0xAC, 0xBB, 0xBA, 0xAA, 0xAA, 0x9A,
    0xAA, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xA9, 0xA9, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0x9B, 0xCC,
    0xBB, 0xAA, 0xA9, 0x99, 0xAA, 0xAA, 0xBB, 0xBC, 0xDC, 0xBC, 0xBA, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xBA, 0xBA, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0x9A, 0x98, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA,
    0x9A, 0x98, 0x77, 0x66, 0x66, 0x56, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x67, 0x78, 0x89, 0xAA, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x67, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xBA, 0xBA, 0x99, 0x88, 0x87, 0x77, 0x77, 0x88, 0x99, 0xAA, 0xBB,
    0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBB, 0xBB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xAA,
    0xAA, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xBB, 0xCC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBC, 0xCC, 0xDC, 0x9C, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAD, 0xCC, 0xCC, 0xCC, 0xCB, 0xBB, 0xBC, 0xBC, 0xCC, 0xDC, 0x9D, 0xED,
    0xED, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xED, 0xDF, 0xDD, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBB, 0xCD, 0xDD, 0xEE, 0xDC, 0xDD, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xEC, 0xCC, 0xCB, 0xBA, 0x99, 0x99, 0x99,
    0x9A, 0xAB, 0xCC, 0xDE, 0xCC, 0xCC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x9A,
    0xAB, 0xCD, 0xDC, 0xCC, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x88, 0x9A, 0xBB,
    0xCD, 0xCC, 0xCB, 0xA9, 0x87, 0x66, 0x56, 0x67, 0x88, 0xAA, 0xBC, 0xDC,
    0xBC, 0xBA, 0x98, 0x76, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xCB, 0xCB,
    0xA9, 0x87, 0x54, 0x33, 0x45, 0x78, 0x9A, 0xBC, 0xDC, 0xBC, 0xBA, 0x98,
    0x76, 0x43, 0x34, 0x56, 0x89, 0xAB, 0xCD, 0xCC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x56, 0x78, 0x9A, 0xBC, 0xCC, 0xCD, 0xBA, 0x99, 0x87, 0x65, 0x56,
    0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xCC, 0xBA, 0x98, 0x87, 0x76, 0x77, 0x88,
    0x9A, 0xBC, 0xDC, 0xCD, 0xCC, 0xAA, 0x98, 0x88, 0x88, 0x88, 0x9A, 0xBB,
    0xCD, 0xDC, 0xDC, 0xBB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xCD, 0xDC,
    0xCE, 0xDD, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDE, 0xDD, 0xDD,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDD, 0xED, 0xDF, 0xEE, 0xDD,
    0xDC, 0xCB, 0xCC, 0xCC, 0xCC, 0xEE, 0xEF, 0xDD, 0xEE, 0xEE, 0xED, 0xDD,
    0xCD, 0xCD, 0xDE, 0xEE, 0xEE, 0xFE, 0x9D, 0xCD, 0xCD, 0xCC, 0xCC, 0xCC,
    0xCC, 0xDD, 0xDD, 0xDE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xFF, 0xFE, 0xFF, 0xEE, 0xDE, 0xDE, 0xEF, 0xEE, 0xEE, 0xAF, 0xFF,
    0xFF, 0xFE, 0xEE, 0xED, 0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xDD, 0xCD, 0xCC, 0xDE, 0xEF, 0xFF, 0xFF, 0xEF, 0xFF, 0xEE, 0xDC, 0xBB,
    0xBB, 0xBB, 0xCD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFD, 0xCB, 0xBA, 0x99, 0x9A,
    0xAB, 0xCD, 0xFE, 0xFF, 0xFF, 0xFE, 0xCB, 0xA9, 0x98, 0x88, 0x89, 0x9B,
    0xCD, 0xEF, 0xFE, 0xFF, 0xDC, 0xB9, 0x87, 0x76, 0x77, 0x78, 0xAB, 0xCD,
    0xEF, 0xFE, 0xED, 0xBA, 0x97, 0x66, 0x55, 0x67, 0x79, 0xAB, 0xDE, 0xFF,
    0xEF, 0xCB, 0x98, 0x76, 0x54, 0x45, 0x67, 0x89, 0xBC, 0xEF, 0xFE, 0xEC,
    0xB9, 0x86, 0x54, 0x33, 0x45, 0x68, 0x9B, 0xCE, 0xFF, 0xFE, 0xCB, 0x98,
    0x75, 0x43, 0x34, 0x56, 0x89, 0xBC, 0xEF, 0xFE, 0xED, 0xB9, 0x87, 0x65,
    0x44, 0x55, 0x78, 0x9B, 0xCE, 0xFF, 0xFF, 0xDB, 0xA9, 0x87, 0x65, 0x55,
    0x67, 0x8A, 0xBD, 0xFF, 0xFF, 0xED, 0xCB, 0x98, 0x87, 0x66, 0x77, 0x89,
    0xAC, 0xEF, 0xFF, 0xFF, 0xED, 0xCB, 0x99, 0x88, 0x88, 0x89, 0xAB, 0xCE,
    0xEF, 0xFE, 0xFF, 0xDD, 0xCB, 0xA9, 0x99, 0x9A, 0xAB, 0xCD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xED, 0xCB, 0xBB, 0xBB, 0xBC, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xEE, 0xDC, 0xCC, 0xCC, 0xDD, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF,
    0xEE, 0xEE, 0xDE, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xEE, 0xFE, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xDD, 0x9E, 0xEE,
    0xDD, 0xCC, 0xCC, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFE, 0xEF, 0xDD, 0xCC,
    0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFF, 0xDD, 0xEC, 0xCB, 0xAA, 0x99,
    0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xED, 0xDD, 0xCB, 0xAA, 0x98, 0x88, 0x88,
    0x89, 0xAB, 0xBC, 0xDF, 0xEC, 0xDB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAB, 0xCD, 0xED, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCE, 0xEC, 0xCA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x77, 0x8A, 0xBC, 0xDD,
    0xCC, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xCA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xCC, 0xBA, 0x88, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9B, 0xCD, 0xDC, 0xDB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDD, 0xDD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x89, 0xBC,
    0xDE, 0xED, 0xED, 0xCA, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xDD,
    0xDE, 0xDC, 0xCB, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xFD, 0xFE,
    0xDC, 0xBB, 0xBB, 0xAA, 0xAA, 0xBC, 0xCC, 0xDE, 0xFE, 0xDF, 0xEE, 0xDD,
    0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xEE, 0xFF, 0xED, 0xFE, 0xFE, 0xED, 0xDD,
    0xCD, 0xDD, 0xDE, 0xFE, 0xFF, 0xFF, 0xAE, 0xEE, 0xED, 0xDD, 0xDD, 0xDD,
    0xDD, 0xEE, 0xFE, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xDE, 0xDD, 0xDC, 0xCC, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xEE, 0xBE, 0xEE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBB, 0xCD, 0xDE, 0xEF, 0xFE, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xEF, 0xED, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xEE, 0xDC, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xDE, 0xEC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x67, 0x89, 0xAB,
    0xCD, 0xDC, 0xBA, 0x98, 0x76, 0x65, 0x55, 0x56, 0x67, 0x89, 0xAB, 0xDD,
    0xCB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBC, 0xDB, 0xBA,
    0x98, 0x76, 0x55, 0x55, 0x55, 0x67, 0x89, 0xAB, 0xDC, 0xCB, 0xA9, 0x87,
    0x65, 0x55, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCC, 0xBA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xA9, 0x87, 0x66, 0x55, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x66, 0x66, 0x78,
    0x99, 0xAC, 0xDD, 0xDC, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDD, 0xDC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xEE,
    0xDE, 0xDC, 0xBA, 0xA9, 0x99, 0x99, 0x99, 0xAB, 0xBC, 0xDE, 0xEE, 0xED,
    0xDC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFE, 0xDF, 0xEE, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xFF, 0xFE, 0xFF, 0xEE, 0xED, 0xDC,
    0xCC, 0xCC, 0xDD, 0xEE, 0xFF, 0xFF, 0xBF, 0xEE, 0xDD, 0xDD, 0xDC, 0xDD,
    0xDD, 0xDE, 0xEF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xEE, 0xDD, 0xDD, 0xCC, 0xDD, 0xCD, 0xDE, 0xEF, 0xFE, 0xAF, 0xFF,
    0xFD, 0xDC, 0xCC, 0xCC, 0xCC, 0xED, 0xEE, 0xFF, 0xFF, 0xFF, 0xDD, 0xCC,
    0xBB, 0xAA, 0xBB, 0xBB, 0xCD, 0xEE, 0xFF, 0xFE, 0xED, 0xCB, 0xAA, 0xA9,
    0x99, 0x9A, 0xAB, 0xCD, 0xEE, 0xFE, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x99, 0xAB, 0xCD, 0xEF, 0xED, 0xDC, 0xAA, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAB, 0xCD, 0xFD, 0xDD, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCF, 0xEC, 0xCB, 0xA8, 0x77, 0x65, 0x55, 0x56, 0x77, 0x8A, 0xBC, 0xDE,
    0xCC, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xCE, 0xDC, 0xCA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xCC, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xCD, 0xDC, 0xCA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xDC, 0xBA, 0x87, 0x76, 0x55, 0x55,
    0x66, 0x78, 0x9B, 0xCD, 0xDD, 0xDC, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDE, 0xDE, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x99, 0xBB,
    0xCD, 0xED, 0xED, 0xCB, 0xA9, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xEE,
    0xEE, 0xED, 0xCB, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xCD, 0xEF, 0xED, 0xFF,
    0xDD, 0xCB, 0xBB, 0xAA, 0xAA, 0xBC, 0xCD, 0xDE, 0xFF, 0xEF, 0xFF, 0xFD,
    0xDC, 0xCB, 0xBC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFE, 0xFF, 0xFF, 0xEE, 0xDD,
    0xDD, 0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xAE, 0xEE, 0xED, 0xED, 0xDD, 0xDD,
    0xDE, 0xEE, 0xEF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFF, 0xEE, 0xFE, 0xDE, 0xEE, 0xFF, 0xDE, 0xFF, 0x9F, 0xFF,
    0xFF, 0xFF, 0xDD, 0xDE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xDC, 0xCC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0xCB, 0xBA,
    0xAA, 0xAB, 0xCD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x99, 0x99,
    0x9A, 0xBC, 0xDF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x87, 0x77, 0x88, 0x9A,
    0xBD, 0xFF, 0xFF, 0xEF, 0xDB, 0xA9, 0x87, 0x66, 0x66, 0x78, 0x9A, 0xCD,
    0xFF, 0xFF, 0xFC, 0xB9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9B, 0xCE, 0xFF,
    0xEE, 0xCA, 0x98, 0x65, 0x54, 0x45, 0x56, 0x89, 0xAC, 0xDF, 0xFE, 0xDC,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xCD, 0xFF, 0xED, 0xCA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAC, 0xDF, 0xFE, 0xDC, 0xA9, 0x86, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xCD, 0xFF, 0xEE, 0xCB, 0x98, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAC, 0xFF, 0xFF, 0xFD, 0xCA, 0x98, 0x76, 0x66, 0x67, 0x88,
    0xAB, 0xCE, 0xFF, 0xFF, 0xFC, 0xBA, 0x98, 0x87, 0x77, 0x89, 0x9B, 0xCD,
    0xFF, 0xFE, 0xFF, 0xDC, 0xBA, 0x99, 0x98, 0x99, 0xAB, 0xCD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xED, 0xCB, 0xBA, 0xAA, 0xAB, 0xCD, 0xEF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDD, 0xCC, 0xCC, 0xCC, 0xCE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFE, 0xED, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xEE, 0xDE, 0xFE,
    0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xBE, 0xEE, 0xDD, 0xDD, 0xCC, 0xCC, 0xDD, 0xDD, 0xDD, 0xED, 0x9F, 0xFF,
    0xFE, 0xDD, 0xDD, 0xCD, 0xDD, 0xEF, 0xEE, 0xFF, 0xFE, 0xEF, 0xED, 0xDC,
    0xCC, 0xBB, 0xBC, 0xCC, 0xDD, 0xEE, 0xFF, 0xEE, 0xEE, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAB, 0xBC, 0xDD, 0xEF, 0xFE, 0xDD, 0xCC, 0xCA, 0xA9, 0x99, 0x99,
    0x9A, 0xBC, 0xCD, 0xEF, 0xDE, 0xDC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x9A,
    0xBC, 0xDE, 0xFE, 0xDE, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x9A, 0xBC,
    0xDE, 0xED, 0xDC, 0xA9, 0x87, 0x66, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xEE,
    0xDD, 0xBA, 0x98, 0x76, 0x54, 0x45, 0x67, 0x89, 0xAC, 0xDF, 0xED, 0xDB,
    0xA9, 0x87, 0x54, 0x33, 0x45, 0x78, 0x9A, 0xCC, 0xFD, 0xDC, 0xCA, 0x98,
    0x75, 0x43, 0x34, 0x56, 0x89, 0xAB, 0xCE, 0xDD, 0xDC, 0xA9, 0x87, 0x65,
    0x44, 0x56, 0x78, 0x9A, 0xBD, 0xEE, 0xDD, 0xCA, 0xA9, 0x77, 0x65, 0x56,
    0x67, 0x89, 0xAC, 0xDE, 0xED, 0xED, 0xCA, 0x98, 0x77, 0x76, 0x77, 0x89,
    0xAB, 0xCD, 0xFE, 0xEE, 0xDC, 0xBA, 0x98, 0x88, 0x78, 0x89, 0x9A, 0xBC,
    0xDE, 0xED, 0xFE, 0xCC, 0xBA, 0xA9, 0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xEE,
    0xEF, 0xFD, 0xDC, 0xBB, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xEE, 0xFF,
    0xED, 0xDC, 0xCC, 0xBB, 0xBB, 0xCD, 0xDD, 0xEF, 0xFF, 0xEF, 0xFF, 0xFE,
    0xED, 0xDD, 0xDC, 0xDD, 0xDE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xEE,
    0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0x9E, 0xDE, 0xDD, 0xDE, 0xDD, 0xCD,
    0xDD, 0xFE, 0xEF, 0xFF, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0x8B, 0xCB,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDC, 0xBC, 0xBB, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xCD, 0xCA, 0xBB, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0xAA, 0xBC, 0xBA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAB, 0xCB, 0xAA, 0x99, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x99,
    0xAB, 0xB9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x65, 0x56, 0x66, 0x77, 0x89, 0xAB, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x87, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBA, 0xAB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0xA9, 0x88, 0x87, 0x77, 0x78, 0x88, 0x99, 0xAA, 0xBB,
    0xBC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xCB, 0xBD, 0xCB, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xCC, 0xDD, 0xCC, 0xBB, 0xBA,
    0xAA, 0xBB, 0xBB, 0xBB, 0xCC, 0xDC, 0x9C, 0xCC, 0xBB, 0xBA, 0xAA, 0xAA,
    0xAA, 0xBB, 0xBB, 0xCC, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xAB, 0xCB,
    0xBA, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xDC, 0xBB, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xCA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77,
    0x78, 0x89, 0x9A, 0xBB, 0xB9, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBB, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66, 0x67, 0x78, 0x89,
    0xAB, 0xA9, 0x99, 0x87, 0x77, 0x66, 0x66, 0x66, 0x67, 0x78, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x66, 0x66, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x66, 0x55, 0x56, 0x67, 0x78, 0x89, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x65, 0x56, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x66, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x77, 0x66, 0x66, 0x66,
    0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xAA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88, 0x99, 0xAA, 0xBA,
    0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBB, 0xCB,
    0xAA, 0x99, 0x99, 0x88, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xBA,
    0xAA, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xBC, 0xDC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDC, 0x9C, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xAA, 0xAA, 0x99, 0x99, 0xAA, 0xAA, 0xBC, 0xCC, 0x9C, 0xCC,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xDD, 0xED, 0xBC, 0xBA, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xCB, 0xBB, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xBC, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0xAA, 0xBC, 0xBA, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x99, 0xAB, 0xBB, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77, 0x78, 0x99,
    0xAB, 0xBA, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xAA, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBB, 0xAB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xAB, 0xBB, 0xBA, 0xA9, 0x88, 0x87, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xCB,
    0xBC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x89, 0x99, 0xAA, 0xBC, 0xBB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAB, 0xBC, 0xCC, 0xCD, 0xCB, 0xBA,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xCC, 0xED, 0xCC, 0xBB, 0xBB,
    0xBB, 0xAB, 0xBB, 0xBC, 0xDC, 0xDD, 0x9C, 0xCB, 0xBB, 0xBB, 0xAA, 0xAA,
    0xAA, 0xBB, 0xBC, 0xCD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xDC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0x9D, 0xED,
    0xCC, 0xBB, 0xBA, 0xAB, 0xBB, 0xBC, 0xDD, 0xEF, 0xFE, 0xDD, 0xCC, 0xBA,
    0xAA, 0xAA, 0x9A, 0xAA, 0xBC, 0xCD, 0xDF, 0xEC, 0xDC, 0xAA, 0x99, 0x99,
    0x89, 0x99, 0x9A, 0xBB, 0xCD, 0xDD, 0xCC, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xBB, 0xCD, 0xDB, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xDD, 0xBB, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x77, 0x89, 0x9B,
    0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x66, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xCC,
    0xBB, 0x99, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDB, 0xA9,
    0x88, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0x9B, 0xCC, 0xBB, 0xA9, 0x87,
    0x66, 0x54, 0x45, 0x56, 0x77, 0x89, 0xAC, 0xCB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0xAA, 0xCC, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBB, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCC, 0xCC, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAA,
    0xBC, 0xDC, 0xDC, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xBB, 0xDD,
    0xCD, 0xCC, 0xBA, 0x99, 0x98, 0x89, 0x99, 0xAA, 0xBC, 0xCD, 0xCD, 0xED,
    0xCB, 0xBA, 0xAA, 0x99, 0x9A, 0xAA, 0xBC, 0xCD, 0xED, 0xDF, 0xED, 0xCC,
    0xBB, 0xBB, 0xAB, 0xBB, 0xBB, 0xCD, 0xDE, 0xED, 0xEE, 0xDD, 0xDC, 0xCC,
    0xBB, 0xCC, 0xCC, 0xDD, 0xEE, 0xEE, 0x9D, 0xCD, 0xCC, 0xCC, 0xCB, 0xBC,
    0xCC, 0xCC, 0xCD, 0xDD, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFE, 0xFF, 0xFD, 0xDD, 0xDC, 0xED, 0xDD, 0xDD, 0x9F, 0xFF,
    0xFF, 0xFF, 0xFE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE,
    0xED, 0xDD, 0xCD, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xCD, 0xBB,
    0xBB, 0xBC, 0xDD, 0xEF, 0xFF, 0xFE, 0xFF, 0xFF, 0xDC, 0xBA, 0xAA, 0xAA,
    0xAB, 0xCD, 0xDE, 0xFF, 0xEF, 0xFD, 0xDC, 0xBA, 0x98, 0x88, 0x89, 0xAB,
    0xCD, 0xEF, 0xFF, 0xFF, 0xED, 0xBA, 0x88, 0x77, 0x77, 0x89, 0xAB, 0xCD,
    0xFF, 0xFF, 0xFD, 0xCA, 0x98, 0x66, 0x55, 0x67, 0x89, 0xAC, 0xDF, 0xFF,
    0xEF, 0xCB, 0xA8, 0x75, 0x44, 0x45, 0x67, 0x8A, 0xBD, 0xFF, 0xFF, 0xFC,
    0xBA, 0x87, 0x54, 0x33, 0x45, 0x68, 0xAB, 0xDF, 0xFF, 0xFF, 0xDB, 0xA8,
    0x75, 0x43, 0x34, 0x56, 0x8A, 0xBD, 0xEF, 0xFF, 0xFD, 0xBA, 0x87, 0x65,
    0x44, 0x45, 0x78, 0xAB, 0xDF, 0xFF, 0xFF, 0xEC, 0xA9, 0x87, 0x65, 0x55,
    0x68, 0x9A, 0xCD, 0xFF, 0xFF, 0xFF, 0xCC, 0xA9, 0x87, 0x76, 0x77, 0x8A,
    0xBC, 0xFF, 0xFF, 0xFF, 0xFE, 0xCB, 0xA9, 0x98, 0x88, 0x9A, 0xBC, 0xDF,
    0xFF, 0xFF, 0xFF, 0xDE, 0xCB, 0xBA, 0xA9, 0xAA, 0xBC, 0xCD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDD, 0xDC, 0xBB, 0xBB, 0xCC, 0xDE, 0xFF, 0xFF, 0xFE, 0xFF,
    0xFF, 0xFE, 0xDD, 0xCC, 0xDC, 0xDF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF,
    0xFF, 0xED, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xDD, 0xDD, 0xFE, 0xED, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDC, 0x9D, 0xEE,
    0xEE, 0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xED, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xDD, 0xED, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xEE, 0xDD, 0xCB, 0xBA, 0x99, 0x99, 0x89,
    0x9A, 0xAB, 0xCD, 0xEE, 0xDC, 0xCC, 0xBA, 0x99, 0x88, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xDD, 0xCD, 0xBA, 0x99, 0x87, 0x66, 0x66, 0x78, 0x9A, 0xBC,
    0xDD, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xCC, 0xBA, 0x97, 0x66, 0x54, 0x45, 0x66, 0x79, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xDD, 0xCC, 0xBA, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x8A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xDC, 0xBA, 0x98, 0x76, 0x66, 0x67, 0x88,
    0x9A, 0xBD, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xDC, 0xDD, 0xCB, 0xAA, 0x99, 0x98, 0x89, 0x9A, 0xBB, 0xCD, 0xEE,
    0xDE, 0xDD, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBC, 0xDD, 0xDF, 0xED, 0xED,
    0xDC, 0xCC, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xFF, 0xFE, 0xCE, 0xFF, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEF, 0xFF, 0xFD, 0xFE, 0xFF, 0xDE, 0xDD,
    0xDD, 0xDD, 0xDE, 0xEF, 0xFF, 0xFE, 0x9D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xEE, 0xEF, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xCC, 0xCC, 0xBB, 0xBC, 0xCC, 0xCC, 0xDD, 0xDD, 0xAE, 0xFE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xBC, 0xCC, 0xDE, 0xEF, 0xFE, 0xDE, 0xDD, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xEE, 0xED, 0xDD, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAB, 0xBC, 0xDE, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0xAA, 0xBC, 0xDE, 0xDC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAB, 0xCC, 0xDD, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDC, 0xCA, 0x98, 0x77, 0x66, 0x55, 0x56, 0x77, 0x89, 0xBC, 0xDD,
    0xCB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xDB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xDC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCC, 0xBA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xB9, 0x87, 0x76, 0x55, 0x55,
    0x67, 0x78, 0x9A, 0xBD, 0xCC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xCD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xCD, 0xDD, 0xDC, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xED,
    0xDE, 0xDC, 0xBB, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCD, 0xDE, 0xED, 0xED,
    0xDC, 0xBB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFE, 0xDF, 0xEE, 0xDD,
    0xCC, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xED, 0xFF, 0xEE, 0xDD, 0xDD,
    0xCC, 0xDD, 0xDD, 0xEE, 0xFF, 0xFF, 0xAE, 0xDD, 0xDD, 0xDD, 0xDD, 0xCC,
    0xDD, 0xDD, 0xEE, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDD, 0x9F, 0xFE,
    0xED, 0xDD, 0xCD, 0xDC, 0xCC, 0xDD, 0xDE, 0xEF, 0xFD, 0xEF, 0xDE, 0xCC,
    0xCB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xEF, 0xDD, 0xED, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xAB, 0xCD, 0xEF, 0xFD, 0xDD, 0xDB, 0xBA, 0x99, 0x98, 0x89,
    0x9A, 0xAB, 0xCD, 0xEE, 0xDD, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x78, 0x99,
    0xAB, 0xCD, 0xFD, 0xDD, 0xCB, 0x98, 0x77, 0x66, 0x66, 0x78, 0x9A, 0xBC,
    0xDD, 0xDC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x56, 0x78, 0x9A, 0xBD, 0xDD,
    0xCC, 0xBA, 0x97, 0x65, 0x54, 0x55, 0x56, 0x79, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA8, 0x76, 0x55, 0x44, 0x55, 0x67, 0x8A, 0xBC, 0xED, 0xCC, 0xBA, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x76, 0x55,
    0x44, 0x55, 0x67, 0x8A, 0xBC, 0xDC, 0xCD, 0xCA, 0x98, 0x76, 0x55, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xDC, 0xBA, 0x98, 0x76, 0x66, 0x67, 0x88,
    0x9A, 0xCC, 0xDD, 0xDD, 0xCC, 0xAA, 0x98, 0x77, 0x77, 0x88, 0x9A, 0xBC,
    0xDD, 0xDC, 0xED, 0xCB, 0xA9, 0x99, 0x88, 0x89, 0x9A, 0xBC, 0xCE, 0xED,
    0xDF, 0xDC, 0xCB, 0xBA, 0xA9, 0xAA, 0xAA, 0xBC, 0xDD, 0xEF, 0xED, 0xEE,
    0xDD, 0xCC, 0xCC, 0xBB, 0xBB, 0xBC, 0xDD, 0xEE, 0xEE, 0xEF, 0xFE, 0xED,
    0xDC, 0xDC, 0xCC, 0xCD, 0xDD, 0xEF, 0xFF, 0xFE, 0xFF, 0xEE, 0xFD, 0xDD,
    0xDD, 0xDD, 0xED, 0xDF, 0xFF, 0xFF, 0x9D, 0xDD, 0xCD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDE, 0xDE, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFE, 0xFE, 0xDE, 0xCD, 0xDD, 0xED, 0xDD, 0xDE, 0x8F, 0xFF,
    0xFF, 0xEF, 0xED, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xDD, 0xDC, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xCC, 0xBB,
    0xBB, 0xBB, 0xCD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFD, 0xCC, 0xBA, 0xA9, 0x9A,
    0xAB, 0xCD, 0xEF, 0xFF, 0xFF, 0xFE, 0xDC, 0xA9, 0x88, 0x88, 0x89, 0xAA,
    0xCD, 0xFF, 0xFF, 0xEF, 0xEC, 0xB9, 0x87, 0x76, 0x77, 0x88, 0xAB, 0xCE,
    0xFF, 0xFF, 0xFD, 0xBA, 0x97, 0x66, 0x55, 0x66, 0x89, 0xAC, 0xDF, 0xFF,
    0xEE, 0xDB, 0xA8, 0x76, 0x54, 0x45, 0x67, 0x8A, 0xBD, 0xFF, 0xFD, 0xDD,
    0xB9, 0x86, 0x54, 0x33, 0x45, 0x68, 0x9B, 0xCF, 0xFF, 0xEF, 0xCB, 0x98,
    0x65, 0x43, 0x34, 0x56, 0x89, 0xBC, 0xFF, 0xFD, 0xED, 0xBA, 0x87, 0x65,
    0x44, 0x55, 0x78, 0x9B, 0xDD, 0xFE, 0xEF, 0xDC, 0xA9, 0x87, 0x65, 0x55,
    0x67, 0x9A, 0xBD, 0xFF, 0xFF, 0xFD, 0xCB, 0xA8, 0x87, 0x66, 0x77, 0x89,
    0xBC, 0xDF, 0xFF, 0xFF, 0xDD, 0xBB, 0xA9, 0x88, 0x88, 0x89, 0xAB, 0xCF,
    0xFF, 0xFF, 0xFF, 0xEC, 0xCB, 0xAA, 0xA9, 0x9A, 0xBB, 0xDD, 0xFF, 0xFF,
    0xFF, 0xFD, 0xED, 0xCB, 0xBB, 0xBB, 0xCC, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xED, 0xDC, 0xCD, 0xCD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xEF, 0xEE, 0xED, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9D, 0xDE, 0xEF, 0xFE, 0xED, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xCC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0x9D, 0xED,
    0xDC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDF, 0xED, 0xDD, 0xDC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDF, 0xDC, 0xCC, 0xBB, 0xA9, 0x99,
    0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xDD, 0xCC, 0xBA, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xCD, 0xDB, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xBC, 0xCC, 0xBB, 0xAA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAA,
    0xBC, 0xCB, 0xBA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xCB,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xAA, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x67, 0x78, 0x9A, 0xBC, 0xBB, 0xBA, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x89, 0xAB, 0xCC, 0xBC, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xBC, 0xDC, 0xCB, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xCC,
    0xCD, 0xCB, 0xBA, 0x99, 0x98, 0x99, 0x9A, 0xAB, 0xBB, 0xDD, 0xCC, 0xDC,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDE, 0xCD, 0xDD, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBB, 0xBD, 0xDD, 0xEF, 0xDD, 0xED, 0xDD, 0xCC, 0xCC,
    0xBC, 0xCC, 0xCD, 0xDD, 0xEE, 0xFD, 0x8D, 0xCC, 0xCC, 0xBB, 0xBB, 0xBB,
    0xCB, 0xCC, 0xDD, 0xDE, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0xAA, 0x99, 0x99, 0x9A, 0xAA, 0xAB, 0xBB, 0x8B, 0xCC,
    0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCC, 0xDC, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCD, 0xCA, 0xBB, 0xAA, 0x99, 0x98,
    0x88, 0x89, 0x99, 0xAA, 0xBB, 0xCB, 0xAB, 0xAA, 0x99, 0x88, 0x77, 0x78,
    0x88, 0x99, 0xAA, 0xBC, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x78,
    0x99, 0xAB, 0xBB, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77, 0x78, 0x9A,
    0xAB, 0xBA, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77, 0x89, 0x9A, 0xBA,
    0x9A, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xA9, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0x9A, 0x98, 0x87, 0x76, 0x65, 0x56,
    0x66, 0x78, 0x89, 0xAB, 0xAA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBA, 0xAB, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xBB, 0xBA, 0xBA, 0xA9, 0x98, 0x88, 0x77, 0x88, 0x88, 0x9A, 0xAB, 0xCB,
    0xBB, 0xBA, 0xA9, 0x99, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xBC, 0xBB, 0xCB,
    0xBA, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCC, 0xBC, 0xCB, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xCD, 0xCB, 0xDC, 0xCC, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDC, 0x8C, 0xBB, 0xBA, 0xAB, 0xAA, 0xAA,
    0xAB, 0xBB, 0xBB, 0xCC, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBB, 0x9B, 0xCB,
    0xBB, 0xAA, 0xAA, 0x9A, 0xAA, 0xAA, 0xBB, 0xCC, 0xDC, 0xBC, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBA, 0xBA, 0xA9, 0x99, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xBB, 0xCB, 0xAA, 0xA9, 0x98, 0x88, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBA, 0x9A, 0x99, 0x87, 0x77, 0x66, 0x66, 0x77, 0x78, 0x99,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA,
    0x9A, 0x98, 0x77, 0x66, 0x65, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x87, 0x76, 0x66,
    0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAA, 0xA9, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBA, 0xAA, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0x99, 0x88, 0x87, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xBB,
    0xAB, 0xBA, 0x99, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBB, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xBA,
    0xAA, 0xA9, 0x99, 0xAA, 0xAB, 0xBB, 0xCC, 0xCB, 0xDC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDC, 0x9B, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0x8C, 0xCC,
    0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCC, 0xDC, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCD, 0xCB, 0xBB, 0xAA, 0x99, 0x88,
    0x88, 0x89, 0x99, 0xAA, 0xBC, 0xCB, 0xBB, 0xBA, 0x99, 0x88, 0x77, 0x78,
    0x88, 0x99, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xCB, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x67, 0x88, 0x9A,
    0xBC, 0xBA, 0xA9, 0x88, 0x76, 0x66, 0x56, 0x66, 0x77, 0x88, 0x9A, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xAA, 0xA9,
    0x87, 0x76, 0x55, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xBA, 0xAA, 0x98, 0x77,
    0x65, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xAA, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x99, 0x87, 0x76, 0x65, 0x66,
    0x67, 0x78, 0x99, 0xAB, 0xAA, 0xBA, 0x98, 0x87, 0x66, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xBB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x78, 0x88, 0x9A,
    0xBB, 0xBB, 0xBB, 0xA9, 0x98, 0x88, 0x77, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xA9, 0x99, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCC, 0xBB, 0xCC,
    0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCC, 0xCD, 0xCC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xCC, 0xDD, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xCE, 0xEC, 0x9C, 0xCB, 0xBB, 0xBA, 0xAA, 0xAA,
    0xAB, 0xBB, 0xBC, 0xCC, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xBF, 0xDC, 0xCC, 0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCC, 0xCD, 0x7D, 0xFD,
    0xDD, 0xCC, 0xCB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEF, 0xFD, 0xDE, 0xDC, 0xCB,
    0xBB, 0xAA, 0xAA, 0xBB, 0xCC, 0xCE, 0xEE, 0xDC, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x9A, 0xAB, 0xCC, 0xCD, 0xED, 0xCD, 0xCB, 0xA9, 0x99, 0x88, 0x88,
    0x99, 0xAB, 0xBC, 0xDE, 0xCC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x78, 0x89,
    0xAA, 0xBD, 0xDD, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x78, 0x89, 0xAB,
    0xCD, 0xCC, 0xCA, 0xA8, 0x77, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xBC, 0xA9, 0x87, 0x65, 0x54, 0x55, 0x66, 0x78, 0x9A, 0xBD, 0xCB, 0xBA,
    0x98, 0x76, 0x54, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBC, 0xCC, 0xCA, 0x98, 0x76, 0x65,
    0x54, 0x56, 0x67, 0x89, 0xAC, 0xCC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x56,
    0x67, 0x88, 0x9A, 0xBD, 0xDC, 0xCB, 0xA9, 0x88, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDC, 0xCD, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x88, 0x99, 0xAB,
    0xCD, 0xDC, 0xDC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xFD,
    0xDD, 0xDC, 0xBB, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDD, 0xED, 0xED,
    0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xEE, 0xDF, 0xEE, 0xDC,
    0xCC, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xED, 0xEE, 0xFD, 0xDD, 0xCC,
    0xCC, 0xCC, 0xDD, 0xEE, 0xFF, 0xEE, 0x8D, 0xDC, 0xDC, 0xCC, 0xCC, 0xCC,
    0xCD, 0xDD, 0xDD, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xEF, 0xFD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDC, 0xDD, 0x8F, 0xFF,
    0xFF, 0xFE, 0xFD, 0xDE, 0xFE, 0xFE, 0xEF, 0xFF, 0xFD, 0xFF, 0xFF, 0xEE,
    0xDC, 0xCD, 0xDC, 0xDD, 0xEE, 0xFF, 0xFF, 0xDF, 0xFF, 0xED, 0xDC, 0xCB,
    0xBB, 0xBC, 0xCD, 0xDE, 0xEF, 0xFE, 0xEF, 0xEE, 0xCC, 0xBA, 0xA9, 0x9A,
    0xAB, 0xCC, 0xDE, 0xFF, 0xEE, 0xFE, 0xDC, 0xBA, 0x98, 0x88, 0x89, 0x9B,
    0xCD, 0xDE, 0xFF, 0xDE, 0xDC, 0xBA, 0x97, 0x76, 0x77, 0x89, 0xAB, 0xCD,
    0xFF, 0xDD, 0xED, 0xBA, 0x97, 0x66, 0x55, 0x66, 0x89, 0xAC, 0xCD, 0xFE,
    0xDE, 0xDB, 0xA8, 0x76, 0x54, 0x45, 0x67, 0x8A, 0xBC, 0xEE, 0xED, 0xEC,
    0xB9, 0x86, 0x54, 0x33, 0x45, 0x68, 0x9B, 0xCE, 0xFE, 0xDD, 0xCB, 0xA8,
    0x75, 0x43, 0x34, 0x56, 0x8A, 0xBC, 0xEF, 0xEE, 0xEC, 0xBA, 0x87, 0x65,
    0x44, 0x46, 0x78, 0xAB, 0xCD, 0xFE, 0xED, 0xDB, 0xA9, 0x87, 0x65, 0x55,
    0x67, 0x9A, 0xBD, 0xDF, 0xFD, 0xED, 0xCB, 0xA9, 0x87, 0x66, 0x77, 0x8A,
    0xBC, 0xDE, 0xFF, 0xDE, 0xDD, 0xBA, 0xA9, 0x88, 0x88, 0x99, 0xAB, 0xDD,
    0xEF, 0xFD, 0xFE, 0xDC, 0xCB, 0xAA, 0x99, 0xAA, 0xBC, 0xCD, 0xFF, 0xFF,
    0xDF, 0xFE, 0xDD, 0xCC, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xFF, 0xED, 0xFF,
    0xEE, 0xDD, 0xDC, 0xCC, 0xCD, 0xDD, 0xEF, 0xFF, 0xFF, 0xDF, 0xFE, 0xEE,
    0xEE, 0xED, 0xEE, 0xDF, 0xFE, 0xFF, 0xFF, 0xFC, 0xFF, 0xEF, 0xEF, 0xFE,
    0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0xCC, 0xDD, 0xDD, 0xDD, 0xDD,
    0xDE, 0xFF, 0xEF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xED, 0xDD, 0xCD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0x9E, 0xFE,
    0xED, 0xDD, 0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xEF, 0xFD, 0xEF, 0xED, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xDF, 0xDD, 0xED, 0xCC, 0xBA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xED, 0xDD, 0xDC, 0xBA, 0x99, 0x98, 0x89,
    0x9A, 0xAB, 0xCD, 0xDD, 0xDD, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xED, 0xCC, 0xCA, 0x98, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xAC,
    0xDD, 0xDC, 0xCB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xCC, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xDD, 0xCC, 0xBA, 0x87,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x78,
    0x9B, 0xBC, 0xDD, 0xCC, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xDC, 0xEC, 0xCB, 0xAA, 0x99, 0x88, 0x99, 0x9A, 0xBC, 0xDD, 0xFE,
    0xCE, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBC, 0xCE, 0xEF, 0xFC, 0xED,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xFF, 0xDE, 0xED, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xFF, 0xFD, 0xFE, 0xEE, 0xED, 0xED,
    0xDD, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0x9D, 0xDD, 0xDC, 0xDC, 0xDD, 0xDD,
    0xDD, 0xEE, 0xEF, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xDC, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xCC, 0xDD, 0xAE, 0xEE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEE, 0xED, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDE, 0xDD, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xDD, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x99, 0xAA, 0xBC, 0xDD, 0xDC, 0xCB, 0xA9, 0x98, 0x77, 0x77, 0x78, 0x89,
    0xAB, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xCB, 0xCA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xAC, 0xDC,
    0xBB, 0xA9, 0x87, 0x65, 0x54, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x78, 0x9A, 0xBD, 0xCC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xCD, 0xDC, 0xDC, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xED,
    0xCD, 0xCC, 0xBA, 0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xDC, 0xED,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xEE, 0xDE, 0xDD, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xFD, 0xEE, 0xED, 0xDD, 0xCC,
    0xCC, 0xCC, 0xDD, 0xEE, 0xFF, 0xFF, 0x9D, 0xDD, 0xDD, 0xCC, 0xCC, 0xCC,
    0xCD, 0xDE, 0xEE, 0xEF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xDE, 0xEE, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDC, 0x9E, 0xFE,
    0xED, 0xDD, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xEF, 0xFD, 0xDF, 0xED, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xDE, 0xDE, 0xED, 0xCC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xCD, 0xED, 0xDE, 0xDC, 0xBA, 0x99, 0x99, 0x99,
    0x9A, 0xAB, 0xCC, 0xDE, 0xDC, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xDD, 0xCD, 0xBA, 0xA8, 0x77, 0x66, 0x67, 0x78, 0x9A, 0xBB,
    0xDD, 0xCC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xCD, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9B, 0xCC, 0xED, 0xCD, 0xCB, 0xAA, 0x98, 0x87, 0x78, 0x89, 0x9A, 0xBC,
    0xDE, 0xDD, 0xDC, 0xCB, 0xAA, 0x99, 0x88, 0x99, 0xAA, 0xBC, 0xCD, 0xED,
    0xDE, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBC, 0xDD, 0xDE, 0xEC, 0xDD,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xFE, 0xDE, 0xEE, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xEE, 0xFF, 0xFD, 0xEE, 0xEE, 0xDD, 0xDC,
    0xDD, 0xDD, 0xDD, 0xEF, 0xFF, 0xFF, 0x9D, 0xDC, 0xDC, 0xCC, 0xCC, 0xCD,
    0xDD, 0xED, 0xEE, 0xEE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xEF, 0xED, 0xDD, 0xCD, 0xDC, 0xCC, 0xCD, 0xDD, 0x8F, 0xFF,
    0xFF, 0xFF, 0xEE, 0xDD, 0xDE, 0xEF, 0xEF, 0xFF, 0xFE, 0xFF, 0xFF, 0xEE,
    0xDD, 0xCC, 0xCC, 0xDD, 0xEE, 0xEF, 0xFF, 0xDF, 0xFF, 0xED, 0xCC, 0xBB,
    0xBB, 0xBB, 0xCD, 0xDE, 0xFF, 0xFE, 0xEF, 0xFD, 0xCB, 0xAA, 0x99, 0x9A,
    0xAB, 0xBC, 0xDE, 0xFF, 0xEE, 0xFD, 0xCB, 0xA9, 0x98, 0x88, 0x89, 0x9B,
    0xCC, 0xEE, 0xFD, 0xEF, 0xDB, 0xA9, 0x87, 0x76, 0x67, 0x88, 0x9B, 0xCD,
    0xFF, 0xFD, 0xDD, 0xBA, 0x97, 0x66, 0x55, 0x66, 0x89, 0xAB, 0xDE, 0xFF,
    0xDD, 0xCB, 0x98, 0x76, 0x54, 0x45, 0x67, 0x8A, 0xBC, 0xDF, 0xFE, 0xEC,
    0xA9, 0x86, 0x54, 0x33, 0x45, 0x68, 0x9B, 0xCD, 0xFE, 0xDD, 0xCB, 0x98,
    0x65, 0x43, 0x34, 0x56, 0x89, 0xBC, 0xDF, 0xED, 0xDC, 0xBA, 0x87, 0x65,
    0x44, 0x56, 0x78, 0xAB, 0xCD, 0xEE, 0xDE, 0xCB, 0xA9, 0x76, 0x65, 0x56,
    0x67, 0x8A, 0xBD, 0xDF, 0xFD, 0xFD, 0xCB, 0x98, 0x87, 0x66, 0x77, 0x89,
    0xAC, 0xEF, 0xFF, 0xDF, 0xDD, 0xBB, 0xA9, 0x88, 0x88, 0x99, 0xAB, 0xCE,
    0xFF, 0xFD, 0xEF, 0xDD, 0xCB, 0xAA, 0x99, 0x9A, 0xBB, 0xCD, 0xEF, 0xFF,
    0xEF, 0xFE, 0xDD, 0xCC, 0xBB, 0xBB, 0xBC, 0xCD, 0xEF, 0xFF, 0xFE, 0xFF,
    0xDE, 0xDD, 0xCC, 0xCC, 0xCC, 0xDE, 0xEF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF,
    0xEE, 0xED, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFE, 0xEF, 0xFF, 0xFF, 0xFF, 0x9D, 0xDD, 0xDD, 0xEE, 0xDD, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xCC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCC, 0x8D, 0xEE,
    0xCC, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xEF, 0xED, 0xCD, 0xDC, 0xCB,
    0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDD, 0xCC, 0xDC, 0xBB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xCC, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xCD, 0xCC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x89,
    0x9A, 0xBC, 0xDC, 0xBB, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xBC, 0xCB, 0xBA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xDC,
    0xBB, 0xA9, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBC, 0xBB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x88, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xAB, 0xCC, 0xBC, 0xBA, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x99, 0xAB,
    0xCD, 0xCC, 0xCC, 0xBA, 0x99, 0x98, 0x88, 0x88, 0x99, 0xAB, 0xBC, 0xDC,
    0xCD, 0xCC, 0xBA, 0xA9, 0x99, 0x99, 0x99, 0xAA, 0xCC, 0xDD, 0xDC, 0xED,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xED, 0xCE, 0xED, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xEE, 0xDC, 0xEE, 0xED, 0xDC, 0xCC,
    0xCC, 0xCC, 0xCC, 0xDD, 0xEE, 0xFE, 0x7C, 0xCC, 0xCC, 0xCB, 0xCB, 0xBB,
    0xCC, 0xCC, 0xDE, 0xDE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xBB, 0xBA, 0xAA, 0xAA, 0x9A, 0xAA, 0xAA, 0xAB, 0xBB, 0x8C, 0xDC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xCC, 0xDC, 0xBC, 0xCB, 0xBA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCD, 0xBB, 0xBB, 0xAA, 0x99, 0x99,
    0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xCB, 0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88,
    0x88, 0x9A, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x77, 0x89, 0x9A,
    0xBB, 0xBA, 0xAA, 0x98, 0x76, 0x66, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xAA, 0xA9,
    0x98, 0x76, 0x55, 0x45, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x98, 0x87,
    0x66, 0x54, 0x45, 0x56, 0x78, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xAA, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x89, 0xAA, 0xBB, 0xAB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89, 0x9A,
    0xBC, 0xBA, 0xBB, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xBB, 0xCB,
    0xBC, 0xBA, 0xAA, 0x99, 0x98, 0x89, 0x99, 0x9A, 0xAB, 0xCC, 0xBB, 0xCB,
    0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDC, 0xBD, 0xCC, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDD, 0xCB, 0xDD, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xED, 0x8B, 0xBB, 0xBB, 0xBA, 0xAA, 0xAA,
    0xBB, 0xBB, 0xBC, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0x9B, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0x9B, 0xCB,
    0xBB, 0xAA, 0xAA, 0x9A, 0xAA, 0xAA, 0xBB, 0xBC, 0xDB, 0xBB, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0xAA, 0xBB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x78,
    0x88, 0x99, 0xAA, 0xBB, 0xAA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAA, 0xBA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x99,
    0xAB, 0xA9, 0xA9, 0x88, 0x77, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAA, 0xA9, 0xA9, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x88, 0x99, 0xAA, 0xBA,
    0xAB, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBA, 0xCB,
    0xAA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCB, 0xBC, 0xCB, 0xBA,
    0xAA, 0xAA, 0x99, 0xAA, 0xAA, 0xBB, 0xCC, 0xCB, 0xCC, 0xCB, 0xBB, 0xBA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xCC, 0xDC, 0x9B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBB, 0xAA, 0xAA, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0xBB, 0x8B, 0xCC,
    0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDB, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xBB, 0xBB, 0xAA, 0x99, 0x88,
    0x88, 0x89, 0x99, 0xAA, 0xBC, 0xCB, 0xAB, 0xAA, 0x98, 0x88, 0x87, 0x88,
    0x88, 0x99, 0xAB, 0xBC, 0xBA, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAB, 0xBA, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x9A,
    0xAB, 0xAA, 0xA9, 0x98, 0x76, 0x66, 0x56, 0x66, 0x77, 0x89, 0x9A, 0xBA,
    0x9A, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xA9, 0xA9,
    0x87, 0x76, 0x55, 0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0x9A, 0x98, 0x87,
    0x66, 0x55, 0x55, 0x56, 0x77, 0x89, 0xAB, 0xA9, 0xA9, 0x88, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x99, 0x87, 0x76, 0x66, 0x56,
    0x66, 0x78, 0x89, 0xAB, 0xAA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBA, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xBB, 0xBA, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x88, 0x9A, 0xAB, 0xCB,
    0xAC, 0xBA, 0xA9, 0x99, 0x88, 0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xBB, 0xCB,
    0xBA, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCB, 0xBC, 0xCB, 0xBB,
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xCB, 0xDD, 0xCC, 0xBB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xDC, 0xDC, 0x8B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xBB, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xCC, 0xCC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0x7D, 0xFE,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEE, 0xED, 0xDD, 0xDC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDE, 0xDC, 0xDC, 0xCB, 0xA9, 0x99,
    0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xED, 0xCD, 0xBA, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xAC, 0xCD, 0xCC, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xDD, 0xBC, 0xA9, 0x98, 0x77, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCC, 0xCB, 0xBA, 0x98, 0x77, 0x65, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xCC,
    0xBB, 0xA9, 0x87, 0x65, 0x54, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x88, 0x76, 0x65, 0x55,
    0x67, 0x78, 0x9A, 0xBC, 0xCB, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x78,
    0x99, 0xBB, 0xCC, 0xCC, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCC, 0xCC, 0xDC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xBC, 0xDD,
    0xCC, 0xCC, 0xBA, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDE, 0xDC, 0xDD,
    0xCC, 0xBB, 0xBA, 0xAA, 0xAA, 0xAB, 0xCC, 0xDE, 0xED, 0xDE, 0xDD, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xDD, 0xEF, 0xED, 0xED, 0xEE, 0xEC, 0xCC,
    0xCC, 0xCC, 0xDD, 0xDE, 0xFF, 0xFE, 0x8D, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC,
    0xCC, 0xCC, 0xDD, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFF, 0xFF, 0xED, 0xDC, 0xDD, 0xDD, 0xCD, 0xCC, 0xCC, 0x8F, 0xFF,
    0xFF, 0xEE, 0xEE, 0xED, 0xEE, 0xEF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFE,
    0xDD, 0xDD, 0xCD, 0xCD, 0xEE, 0xEF, 0xEF, 0xEE, 0xFF, 0xED, 0xDD, 0xCB,
    0xBB, 0xBC, 0xCD, 0xDD, 0xEF, 0xFD, 0xEF, 0xDE, 0xDC, 0xBA, 0xAA, 0xAA,
    0xAB, 0xCD, 0xDE, 0xFF, 0xDE, 0xFE, 0xDC, 0xA9, 0x98, 0x88, 0x99, 0xAB,
    0xCC, 0xEF, 0xFD, 0xEF, 0xDC, 0xB9, 0x87, 0x77, 0x77, 0x89, 0xAB, 0xCD,
    0xEF, 0xEE, 0xDD, 0xCA, 0x98, 0x66, 0x55, 0x67, 0x89, 0xAC, 0xDE, 0xFE,
    0xED, 0xDB, 0xA8, 0x76, 0x44, 0x45, 0x67, 0x8A, 0xBD, 0xEF, 0xDD, 0xED,
    0xBA, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xCE, 0xFE, 0xDE, 0xCB, 0xA8,
    0x75, 0x43, 0x34, 0x56, 0x89, 0xBC, 0xEF, 0xED, 0xED, 0xCA, 0x87, 0x65,
    0x44, 0x45, 0x78, 0xAB, 0xCE, 0xEE, 0xDD, 0xDC, 0xA9, 0x87, 0x65, 0x55,
    0x68, 0x9A, 0xCD, 0xDF, 0xFD, 0xFD, 0xCB, 0xA9, 0x87, 0x76, 0x77, 0x89,
    0xBC, 0xDE, 0xEF, 0xCE, 0xDC, 0xCB, 0xA9, 0x98, 0x88, 0x99, 0xBB, 0xDD,
    0xFF, 0xED, 0xEF, 0xEC, 0xCB, 0xAA, 0xA9, 0xAA, 0xBB, 0xDD, 0xEF, 0xFF,
    0xCD, 0xED, 0xDC, 0xCC, 0xBB, 0xBB, 0xBC, 0xDD, 0xFF, 0xFF, 0xFC, 0xFE,
    0xDD, 0xDD, 0xDC, 0xCD, 0xCD, 0xDD, 0xFF, 0xFF, 0xFF, 0xCE, 0xDE, 0xED,
    0xDD, 0xEE, 0xDE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFC, 0xFE, 0xFE, 0xDE, 0xEE,
    0xDE, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0x7C, 0xCC, 0xCC, 0xCD, 0xDD, 0xDE,
    0xEE, 0xDE, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x9E, 0xFE,
    0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDE, 0xEE, 0xFD, 0xDF, 0xED, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEE, 0xDD, 0xED, 0xDC, 0xBA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xED, 0xDD, 0xDC, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xAB, 0xCD, 0xDE, 0xDC, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x99,
    0xAB, 0xCD, 0xED, 0xCC, 0xCB, 0x99, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xCC, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x79, 0xAB, 0xCD, 0xCC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9A, 0xCD, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xDC, 0xDC, 0xCB, 0xAA, 0x99, 0x98, 0x99, 0x9A, 0xBC, 0xDE, 0xED,
    0xCD, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xEF, 0xDC, 0xED,
    0xDC, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xFE, 0xCE, 0xED, 0xDD,
    0xDC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xFF, 0xEC, 0xFE, 0xEE, 0xED, 0xDD,
    0xDD, 0xDD, 0xEE, 0xEE, 0xFF, 0xFF, 0x8D, 0xDD, 0xDC, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDD, 0xEE, 0xEE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCD, 0xDD, 0xCC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCC, 0xCC, 0xAE, 0xEE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xED, 0xDE, 0xDC, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDE, 0xDD, 0xDC, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xCD, 0xDD, 0xCD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xCD, 0xCC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xCB, 0xBA, 0x98, 0x76, 0x65, 0x55, 0x66, 0x78, 0x89, 0xAB, 0xCC,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x88, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xDC, 0xCC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xED,
    0xCD, 0xCB, 0xBA, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCC, 0xDE, 0xDC, 0xDD,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xDE, 0xFE, 0xCE, 0xDD, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xED, 0xEE, 0xDD, 0xDC, 0xCC,
    0xCC, 0xCC, 0xDD, 0xEE, 0xEF, 0xFE, 0xAD, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC,
    0xCC, 0xDD, 0xEE, 0xEF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCD, 0x9E, 0xFF,
    0xED, 0xDD, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDE, 0xFD, 0xEE, 0xED, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBB, 0xCD, 0xDD, 0xEE, 0xDD, 0xED, 0xCC, 0xBA, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xDD, 0xED, 0xDD, 0xCC, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xAB, 0xCD, 0xDE, 0xDD, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A,
    0xAB, 0xCD, 0xDD, 0xCD, 0xCB, 0x98, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBB,
    0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xCC, 0xBA, 0x98, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xCC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xCC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xDB, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9A, 0xCD, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xDC, 0xDC, 0xCB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xBC, 0xCD, 0xED,
    0xCE, 0xDC, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBC, 0xCD, 0xEF, 0xEC, 0xED,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEE, 0xFE, 0xCE, 0xED, 0xDD,
    0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFD, 0xEE, 0xEE, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDE, 0xEF, 0xEF, 0xFF, 0x9C, 0xCD, 0xDC, 0xDC, 0xCC, 0xCD,
    0xDD, 0xDD, 0xEE, 0xFE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xFE, 0xED, 0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x7E, 0xFF,
    0xFF, 0xFE, 0xEE, 0xDD, 0xDD, 0xDE, 0xEE, 0xEF, 0xFD, 0xDF, 0xFE, 0xFE,
    0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xEE, 0xEF, 0xDE, 0xFE, 0xEE, 0xCC, 0xBB,
    0xBB, 0xBB, 0xCC, 0xCD, 0xEF, 0xFD, 0xEF, 0xED, 0xCB, 0xBA, 0xA9, 0x9A,
    0xAB, 0xBC, 0xDD, 0xEE, 0xDE, 0xED, 0xCB, 0xA9, 0x98, 0x88, 0x89, 0xAA,
    0xCC, 0xDE, 0xED, 0xDE, 0xDB, 0xB9, 0x87, 0x76, 0x77, 0x89, 0xAB, 0xCD,
    0xEF, 0xDE, 0xDC, 0xBA, 0x97, 0x66, 0x55, 0x67, 0x89, 0xAC, 0xCE, 0xFD,
    0xDD, 0xCB, 0xA8, 0x75, 0x54, 0x45, 0x67, 0x8A, 0xBD, 0xDF, 0xED, 0xEC,
    0xB9, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xCD, 0xED, 0xDD, 0xCB, 0xA8,
    0x75, 0x43, 0x34, 0x56, 0x89, 0xBC, 0xEF, 0xED, 0xDC, 0xBA, 0x87, 0x65,
    0x44, 0x46, 0x78, 0xAB, 0xCD, 0xED, 0xDD, 0xDB, 0xA9, 0x87, 0x65, 0x55,
    0x67, 0x9A, 0xBC, 0xEF, 0xDD, 0xED, 0xCB, 0xA9, 0x87, 0x76, 0x77, 0x89,
    0xBC, 0xDE, 0xFE, 0xDF, 0xDC, 0xCB, 0xA9, 0x88, 0x88, 0x99, 0xAB, 0xCD,
    0xFF, 0xED, 0xEE, 0xDD, 0xBB, 0xAA, 0x99, 0xAA, 0xAB, 0xCD, 0xEF, 0xFF,
    0xDE, 0xED, 0xCC, 0xCB, 0xBB, 0xBB, 0xBC, 0xDD, 0xEF, 0xFF, 0xFE, 0xFF,
    0xED, 0xDD, 0xCC, 0xCC, 0xCD, 0xDE, 0xFE, 0xFF, 0xFF, 0xDF, 0xFE, 0xEE,
    0xDE, 0xDE, 0xDE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xEF, 0xEE, 0xFE,
    0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8C, 0xDD, 0xDC, 0xDE, 0xDE, 0xED,
    0xED, 0xFF, 0xEE, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xEE, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0x8E, 0xFF,
    0xED, 0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDE, 0xEF, 0xFE, 0xEF, 0xED, 0xCC,
    0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEE, 0xEE, 0xDE, 0xED, 0xCB, 0xBA, 0xAA,
    0xA9, 0xAA, 0xAB, 0xCD, 0xDE, 0xFD, 0xED, 0xDC, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xAB, 0xCC, 0xDF, 0xDC, 0xCC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A,
    0xAB, 0xCD, 0xED, 0xDC, 0xBA, 0x98, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xCE, 0xDC, 0xDB, 0xA9, 0x87, 0x66, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xCC, 0xBA, 0x98, 0x66, 0x54, 0x55, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA8, 0x76, 0x54, 0x34, 0x55, 0x67, 0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x98,
    0x65, 0x53, 0x34, 0x56, 0x78, 0x9A, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x54, 0x56, 0x67, 0x99, 0xBC, 0xDD, 0xCC, 0xCA, 0x98, 0x77, 0x65, 0x56,
    0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x88,
    0x9A, 0xBD, 0xED, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xDE, 0xEC, 0xDD, 0xCB, 0xAA, 0x99, 0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xEE,
    0xDE, 0xDC, 0xCB, 0xAA, 0xAA, 0x9A, 0xAA, 0xBB, 0xCE, 0xEF, 0xFD, 0xEE,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDE, 0xFF, 0xDE, 0xED, 0xDD,
    0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFD, 0xFF, 0xFD, 0xED, 0xDD,
    0xDD, 0xDD, 0xDE, 0xEF, 0xFF, 0xFE, 0x7C, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC,
    0xDD, 0xDD, 0xEE, 0xFE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0x8B, 0xDC,
    0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xBB, 0xCC, 0xCD, 0xEB, 0xBC, 0xBB, 0xAA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCD, 0xBB, 0xCB, 0xAA, 0x99, 0x98,
    0x88, 0x99, 0x9A, 0xAB, 0xBC, 0xCB, 0xAB, 0xAA, 0x98, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xAB, 0xBC, 0xBA, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77, 0x89, 0x9A,
    0xBB, 0xBA, 0xA9, 0x98, 0x76, 0x66, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xAB, 0xAA, 0xA9,
    0x88, 0x76, 0x55, 0x45, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x98, 0x87,
    0x66, 0x55, 0x45, 0x56, 0x78, 0x89, 0xAB, 0xAA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xBA, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xBB, 0xAB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xBC, 0xBA, 0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xAA, 0x99, 0x98, 0x88, 0x99, 0x9A, 0xAB, 0xCC, 0xBB, 0xCC,
    0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xDC, 0xBD, 0xCC, 0xBB,
    0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xDD, 0xCB, 0xDC, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xEC, 0x8B, 0xBB, 0xBB, 0xBA, 0xAA, 0xAA,
    0xAB, 0xBB, 0xBC, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAB, 0xBA, 0xAA, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0x8B, 0xCB,
    0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCB, 0xBB, 0xBA, 0xAA,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xBB, 0xCC, 0xBA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x89, 0x99, 0xAA, 0xBB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x78,
    0x88, 0x99, 0xAA, 0xBB, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAA, 0xBA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77, 0x88, 0x99,
    0xAB, 0xA9, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xBA,
    0x9A, 0x98, 0x77, 0x66, 0x55, 0x56, 0x66, 0x78, 0x89, 0xAA, 0xA9, 0xA9,
    0x87, 0x76, 0x65, 0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x77,
    0x66, 0x55, 0x55, 0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x88, 0x76, 0x66,
    0x55, 0x56, 0x67, 0x78, 0x9A, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x78, 0x89, 0xAB, 0xA9, 0xA9, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBA, 0xAA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xAA, 0xBA, 0xA9, 0x98, 0x88, 0x77, 0x78, 0x88, 0x99, 0xAB, 0xBB,
    0xAB, 0xBA, 0xA9, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBA, 0xCB,
    0xBA, 0xA9, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBC, 0xCB, 0xBC, 0xCB, 0xBA,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xCB, 0xCC, 0xCB, 0xBB, 0xBA,
    0xAA, 0xAB, 0xBB, 0xBC, 0xCC, 0xDC, 0x8B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xAB, 0xBB, 0xCC, 0xA0, 0x00, 0x00, 0x00,
  },
  {
    0xAC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0x8C, 0xDC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAB, 0xBB, 0xBC, 0xCD, 0xDC, 0xBC, 0xCB, 0xBA,
    0xA9, 0x99, 0x9A, 0xAA, 0xAB, 0xBC, 0xCD, 0xCB, 0xCB, 0xAA, 0x99, 0x98,
    0x89, 0x99, 0x9A, 0xAB, 0xBC, 0xCB, 0xBB, 0xBA, 0x99, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xAB, 0xBC, 0xBB, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x78, 0x88,
    0x9A, 0xAB, 0xCB, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x77, 0x89, 0x9A,
    0xBC, 0xBA, 0xA9, 0x98, 0x76, 0x66, 0x56, 0x66, 0x77, 0x89, 0xAA, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x99, 0xAB, 0xBA, 0xA9,
    0x88, 0x76, 0x55, 0x45, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0x98, 0x87,
    0x66, 0x54, 0x45, 0x56, 0x78, 0x89, 0xAB, 0xBA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xBA, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAA, 0xCB, 0xAB, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xBB, 0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB,
    0xBC, 0xBB, 0xAA, 0x99, 0x98, 0x88, 0x99, 0x9A, 0xAB, 0xCC, 0xCB, 0xCC,
    0xBB, 0xAA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDC, 0xBD, 0xCC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCD, 0xDD, 0xDC, 0xDD, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xED, 0x8C, 0xBB, 0xBB, 0xBB, 0xBB, 0xAB,
    0xBB, 0xBC, 0xCC, 0xCD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xCE, 0xDC, 0xCC, 0xCB, 0xBB, 0xBB, 0xBB, 0xCC, 0xBC, 0xCC, 0x7D, 0xFE,
    0xDD, 0xCC, 0xCB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEE, 0xFD, 0xDE, 0xDC, 0xCB,
    0xBB, 0xAA, 0xAA, 0xBB, 0xCC, 0xCD, 0xDE, 0xDD, 0xDD, 0xCB, 0xAA, 0x99,
    0x99, 0x9A, 0xAB, 0xCC, 0xDD, 0xFD, 0xCD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x99, 0xAB, 0xBC, 0xDD, 0xCC, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x78, 0x89,
    0xAB, 0xBD, 0xDC, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x78, 0x89, 0xAB,
    0xCD, 0xDB, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDC,
    0xCB, 0xA9, 0x87, 0x65, 0x54, 0x55, 0x67, 0x78, 0x9B, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x54, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xCB, 0x98, 0x77, 0x65,
    0x54, 0x55, 0x67, 0x89, 0xAC, 0xCC, 0xBC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0x9A, 0xBD, 0xCC, 0xCB, 0xA9, 0x88, 0x77, 0x66, 0x67, 0x78,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBB, 0xA9, 0x88, 0x77, 0x77, 0x88, 0x99, 0xBB,
    0xCD, 0xDC, 0xDC, 0xBA, 0xA9, 0x98, 0x88, 0x89, 0x99, 0xAB, 0xCD, 0xDD,
    0xDE, 0xDC, 0xBB, 0xAA, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDE, 0xFC, 0xDD,
    0xDC, 0xBB, 0xBA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDF, 0xEE, 0xDE, 0xDE, 0xDC,
    0xCC, 0xCB, 0xBC, 0xBC, 0xCD, 0xDE, 0xFF, 0xED, 0xFE, 0xED, 0xDD, 0xCC,
    0xCD, 0xCC, 0xDE, 0xDE, 0xFF, 0xFF, 0x8C, 0xCC, 0xDC, 0xCC, 0xCC, 0xCC,
    0xDD, 0xCD, 0xDE, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xFF, 0xEE, 0xED, 0xED, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0x8F, 0xFF,
    0xFF, 0xFF, 0xFE, 0xED, 0xED, 0xDD, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xEE,
    0xDD, 0xDC, 0xCD, 0xDD, 0xDD, 0xFF, 0xFF, 0xDE, 0xFF, 0xED, 0xDC, 0xCB,
    0xBB, 0xCC, 0xCC, 0xDD, 0xFF, 0xFD, 0xEF, 0xEE, 0xDC, 0xBB, 0xAA, 0xAA,
    0xBB, 0xCD, 0xDE, 0xFF, 0xEF, 0xFE, 0xDB, 0xBA, 0x98, 0x88, 0x99, 0xAB,
    0xCC, 0xDE, 0xFF, 0xEF, 0xDD, 0xB9, 0x87, 0x77, 0x77, 0x89, 0xAB, 0xCE,
    0xEF, 0xED, 0xED, 0xCA, 0x97, 0x66, 0x55, 0x67, 0x89, 0xAC, 0xDD, 0xFF,
    0xDD, 0xDB, 0xA8, 0x75, 0x44, 0x45, 0x67, 0x8A, 0xBD, 0xFF, 0xED, 0xEC,
    0xBA, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xDE, 0xFE, 0xDD, 0xCB, 0xA8,
    0x75, 0x43, 0x34, 0x57, 0x8A, 0xBD, 0xFE, 0xFD, 0xEC, 0xCA, 0x87, 0x65,
    0x44, 0x45, 0x78, 0xAC, 0xDF, 0xFF, 0xDE, 0xDC, 0xA9, 0x87, 0x65, 0x55,
    0x67, 0x9A, 0xCD, 0xFF, 0xFD, 0xFD, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x8A,
    0xBD, 0xEF, 0xFF, 0xCF, 0xDD, 0xCB, 0xA9, 0x88, 0x88, 0x9A, 0xBC, 0xDE,
    0xFF, 0xED, 0xFD, 0xED, 0xCB, 0xAA, 0xAA, 0xAA, 0xBC, 0xDE, 0xEE, 0xFF,
    0xDE, 0xFD, 0xDD, 0xCB, 0xBB, 0xBB, 0xCC, 0xEE, 0xFF, 0xFF, 0xFD, 0xFE,
    0xEE, 0xDD, 0xDD, 0xCD, 0xDD, 0xEE, 0xFE, 0xFF, 0xFF, 0xDF, 0xEE, 0xEE,
    0xDD, 0xED, 0xDD, 0xEF, 0xEF, 0xFF, 0xFF, 0xFD, 0xEE, 0xEE, 0xEF, 0xEF,
    0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0xCC, 0xCC, 0xDD, 0xDD, 0xDE,
    0xFE, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xEF, 0xED, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x8F, 0xFF,
    0xEF, 0xDD, 0xDC, 0xCC, 0xCC, 0xDD, 0xDE, 0xEE, 0xED, 0xEF, 0xED, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEE, 0xDE, 0xFE, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xFD, 0xEE, 0xDC, 0xBA, 0x99, 0x99, 0x99,
    0x9A, 0xAB, 0xCD, 0xDE, 0xDD, 0xDD, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A,
    0xAB, 0xCD, 0xED, 0xDD, 0xCA, 0x98, 0x87, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xDE, 0xDC, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xEE,
    0xCC, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCE, 0xDC, 0xCB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xED, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xEE, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAC, 0xDE, 0xEC, 0xCC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x78,
    0x9B, 0xCD, 0xEE, 0xCD, 0xCB, 0xA9, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBD,
    0xEF, 0xFC, 0xDC, 0xCB, 0xAA, 0x99, 0x98, 0x99, 0x9A, 0xBC, 0xDF, 0xFF,
    0xCE, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xFF, 0xFC, 0xED,
    0xDD, 0xCC, 0xBB, 0xBB, 0xBB, 0xCD, 0xDE, 0xEF, 0xFF, 0xCE, 0xED, 0xDD,
    0xDC, 0xCC, 0xCD, 0xDD, 0xDF, 0xFF, 0xFF, 0xFC, 0xFE, 0xEE, 0xEE, 0xEE,
    0xDD, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE,
    0xEF, 0xEF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xEE, 0xDD, 0xCC, 0xCB, 0xBB, 0xBB, 0xCC, 0xCC, 0xCC, 0xAF, 0xFE,
    0xED, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xED, 0xEF, 0xDD, 0xCB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xDE, 0xDD, 0xED, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBB, 0xCD, 0xED, 0xDD, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xCD, 0xDC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x89,
    0x9A, 0xBC, 0xDC, 0xCC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCC, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55, 0x66, 0x77, 0x89, 0xAB, 0xCC,
    0xBB, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xCB, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xCC, 0xBB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBC, 0xCB, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xBB, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x9A, 0xBD, 0xDB, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAB,
    0xCD, 0xEC, 0xCC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCD, 0xEE,
    0xCD, 0xCB, 0xBA, 0xA9, 0x99, 0x99, 0x9A, 0xAB, 0xCD, 0xEF, 0xEC, 0xDD,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xCD, 0xDF, 0xFF, 0xCE, 0xDD, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEF, 0xFF, 0xFC, 0xEE, 0xDD, 0xDD, 0xCC,
    0xCC, 0xCD, 0xDD, 0xEF, 0xFF, 0xFF, 0xAD, 0xDD, 0xCC, 0xCC, 0xCC, 0xCD,
    0xDD, 0xEE, 0xEF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xDF, 0xFE, 0xED, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x8F, 0xFF,
    0xFE, 0xDD, 0xDC, 0xCC, 0xDD, 0xDD, 0xDD, 0xEE, 0xEC, 0xEF, 0xEE, 0xDC,
    0xCB, 0xBB, 0xBB, 0xBC, 0xCC, 0xDD, 0xEF, 0xDE, 0xEE, 0xDC, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xCC, 0xDD, 0xED, 0xEE, 0xDC, 0xBA, 0x99, 0x99, 0x99,
    0x9A, 0xAB, 0xCC, 0xDE, 0xDD, 0xEC, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A,
    0xAB, 0xCD, 0xDD, 0xDD, 0xCB, 0xA8, 0x77, 0x66, 0x67, 0x78, 0x9A, 0xBC,
    0xCD, 0xDD, 0xDC, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xCC, 0xDD,
    0xCC, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xDC, 0xCB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x9A, 0xBC, 0xDD, 0xCC, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDC, 0xCB, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBC, 0xEE, 0xCC, 0xCA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xDE, 0xDD, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x78,
    0x9B, 0xCD, 0xEE, 0xCD, 0xCB, 0xAA, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBC,
    0xEF, 0xEC, 0xDD, 0xCB, 0xAA, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xDE, 0xFE,
    0xCE, 0xDC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAB, 0xBC, 0xDE, 0xEF, 0xFC, 0xED,
    0xDC, 0xCC, 0xBB, 0xBB, 0xBB, 0xCC, 0xDE, 0xEF, 0xFF, 0xCE, 0xED, 0xDD,
    0xDC, 0xCC, 0xCC, 0xDD, 0xDE, 0xFF, 0xFF, 0xFD, 0xFE, 0xEE, 0xDD, 0xDD,
    0xDD, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0x8C, 0xCC, 0xCC, 0xDC, 0xDD, 0xDD,
    0xDE, 0xEE, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xFF, 0xFF, 0xFD, 0xED, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFE, 0xDE, 0xDF, 0xDE, 0xEF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF,
    0xED, 0xDD, 0xCC, 0xCD, 0xEE, 0xEE, 0xFF, 0xDF, 0xFF, 0xFF, 0xED, 0xCC,
    0xBC, 0xBB, 0xCD, 0xDD, 0xEF, 0xFD, 0xFF, 0xFE, 0xEC, 0xBA, 0xAA, 0xAA,
    0xBB, 0xCC, 0xDF, 0xEF, 0xDF, 0xFF, 0xDC, 0xBA, 0x98, 0x88, 0x99, 0xAB,
    0xCC, 0xEF, 0xFF, 0xFF, 0xED, 0xBA, 0x87, 0x77, 0x77, 0x89, 0xAB, 0xDD,
    0xEF, 0xDF, 0xFF, 0xCA, 0x97, 0x65, 0x55, 0x67, 0x89, 0xBC, 0xDF, 0xFE,
    0xEF, 0xDC, 0xA8, 0x75, 0x44, 0x45, 0x67, 0x9A, 0xBD, 0xEF, 0xFE, 0xFD,
    0xCA, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xCF, 0xFF, 0xDF, 0xDC, 0xA8,
    0x75, 0x43, 0x34, 0x57, 0x8A, 0xCD, 0xEF, 0xED, 0xFD, 0xCA, 0x97, 0x65,
    0x44, 0x45, 0x78, 0xAB, 0xDF, 0xFF, 0xEF, 0xDC, 0xB9, 0x87, 0x65, 0x55,
    0x68, 0x9B, 0xCF, 0xFF, 0xFD, 0xEE, 0xCB, 0xA9, 0x87, 0x76, 0x78, 0x9A,
    0xCD, 0xFF, 0xFF, 0xDF, 0xED, 0xCB, 0xA9, 0x98, 0x88, 0x9A, 0xBC, 0xDF,
    0xFF, 0xFD, 0xFD, 0xDC, 0xCB, 0xAA, 0xAA, 0xAA, 0xCD, 0xDF, 0xFF, 0xFF,
    0xDF, 0xFD, 0xDD, 0xCC, 0xCB, 0xCC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFD, 0xFE,
    0xFE, 0xDD, 0xDC, 0xDD, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFE, 0xEE,
    0xEE, 0xDE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xEF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xCC, 0xCD, 0xDE, 0xEF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xFF, 0xDF, 0xDE, 0xDD, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x7F, 0xFF,
    0xEF, 0xFF, 0xFD, 0xEE, 0xFE, 0xDD, 0xEF, 0xFF, 0xFD, 0xFF, 0xFF, 0xEE,
    0xDD, 0xDD, 0xDD, 0xCD, 0xDF, 0xFF, 0xFF, 0xDF, 0xFE, 0xED, 0xDC, 0xCB,
    0xBB, 0xBC, 0xCC, 0xDD, 0xFF, 0xFD, 0xFF, 0xFD, 0xDB, 0xBA, 0xAA, 0xAA,
    0xBB, 0xCC, 0xDD, 0xFF, 0xFF, 0xFE, 0xDB, 0xAA, 0x98, 0x89, 0x99, 0xAB,
    0xCC, 0xFF, 0xFF, 0xFE, 0xDC, 0xBA, 0x98, 0x77, 0x78, 0x89, 0xAC, 0xCC,
    0xFF, 0xFD, 0xFD, 0xCA, 0x98, 0x76, 0x66, 0x67, 0x89, 0xAC, 0xCD, 0xFE,
    0xDD, 0xCB, 0xA9, 0x76, 0x54, 0x45, 0x67, 0x9A, 0xCC, 0xDF, 0xDD, 0xED,
    0xBA, 0x97, 0x64, 0x23, 0x46, 0x78, 0xAB, 0xDD, 0xFF, 0xDD, 0xCB, 0xA9,
    0x76, 0x43, 0x24, 0x57, 0x9A, 0xCD, 0xFF, 0xFE, 0xDC, 0xCA, 0x98, 0x65,
    0x44, 0x56, 0x78, 0xAC, 0xDE, 0xFD, 0xDD, 0xDC, 0xAA, 0x87, 0x66, 0x56,
    0x78, 0x9A, 0xBD, 0xFF, 0xFE, 0xDD, 0xCB, 0xA9, 0x87, 0x77, 0x78, 0x99,
    0xBC, 0xEF, 0xFF, 0xDF, 0xED, 0xCB, 0xA9, 0x98, 0x89, 0x9A, 0xBC, 0xDD,
    0xFF, 0xFD, 0xFF, 0xEC, 0xCB, 0xBA, 0xAA, 0xAA, 0xAC, 0xDE, 0xEF, 0xFF,
    0xDF, 0xFE, 0xCC, 0xDC, 0xBB, 0xBB, 0xBC, 0xDD, 0xEF, 0xFF, 0xFE, 0xFF,
    0xDE, 0xED, 0xDD, 0xCC, 0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFE, 0xFF,
    0xFF, 0xEC, 0xED, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xED, 0xFE,
    0xED, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6C, 0xCB, 0xBC, 0xCD, 0xDC, 0xCF,
    0xDF, 0xEF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xCC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0x8D, 0xDC,
    0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDC, 0xCD, 0xCB, 0xAA,
    0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xCD, 0xCB, 0xCB, 0xBA, 0x99, 0x99,
    0x89, 0x99, 0x9A, 0xAB, 0xBC, 0xDB, 0xBC, 0xAA, 0x99, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xAB, 0xCD, 0xBB, 0xBA, 0x99, 0x88, 0x77, 0x77, 0x78, 0x89,
    0x9A, 0xAB, 0xCB, 0xAB, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x77, 0x89, 0x9A,
    0xBC, 0xBA, 0xBA, 0x98, 0x76, 0x66, 0x56, 0x66, 0x78, 0x89, 0xAB, 0xBB,
    0xAA, 0x99, 0x87, 0x66, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBB, 0xBA, 0xA9,
    0x98, 0x76, 0x55, 0x44, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0x99, 0x87,
    0x66, 0x54, 0x45, 0x56, 0x78, 0x89, 0xAB, 0xBA, 0xA9, 0x98, 0x76, 0x65,
    0x55, 0x56, 0x67, 0x89, 0x9A, 0xBB, 0xAA, 0xA9, 0x87, 0x76, 0x66, 0x56,
    0x66, 0x78, 0x9A, 0xAB, 0xBA, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCC, 0xAB, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xCA, 0xCB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xBC, 0xCC,
    0xBC, 0xBB, 0xAA, 0x99, 0x99, 0x88, 0x99, 0x9A, 0xBB, 0xCD, 0xDB, 0xDC,
    0xCB, 0xAA, 0xAA, 0x99, 0x9A, 0xAA, 0xBB, 0xCD, 0xDD, 0xBD, 0xCC, 0xBB,
    0xBA, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xDB, 0xDD, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBB, 0xCC, 0xCD, 0xDE, 0xED, 0x8C, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
    0xBB, 0xBC, 0xDD, 0xDE, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xBB, 0xAA, 0x99, 0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0x9B, 0xCB,
    0xBA, 0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xBB, 0xBC, 0xDB, 0xBC, 0xBA, 0xA9,
    0x99, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xBA, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x99, 0x9A, 0xAB, 0xCB, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x78,
    0x89, 0xAA, 0xBA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77, 0x78, 0x99,
    0xAB, 0xA9, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x65, 0x56, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x99, 0x98, 0x77,
    0x66, 0x65, 0x55, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x65, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x9A, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x98, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBA, 0x9A, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xBA, 0xBA, 0x99, 0x88, 0x87, 0x77, 0x77, 0x88, 0x99, 0xAA, 0xBB,
    0xAB, 0xAA, 0x99, 0x98, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xBA, 0xBB,
    0xAA, 0xA9, 0x99, 0x99, 0x99, 0x99, 0xAA, 0xBC, 0xCC, 0xBC, 0xBB, 0xAA,
    0xAA, 0x99, 0x99, 0xAA, 0xAA, 0xBB, 0xCD, 0xCB, 0xCC, 0xCB, 0xBB, 0xAA,
    0xAA, 0xAA, 0xBB, 0xBC, 0xCD, 0xDD, 0x9B, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xBB, 0xBC, 0xCD, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xBD, 0xCB, 0xBB, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBB, 0xBB, 0x8D, 0xDC,
    0xCB, 0xBB, 0xBA, 0xAA, 0xAB, 0xBB, 0xCC, 0xCD, 0xDB, 0xCC, 0xCB, 0xAA,
    0xAA, 0x99, 0x9A, 0xAA, 0xAB, 0xBB, 0xCD, 0xBC, 0xCB, 0xAA, 0x99, 0x98,
    0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xDB, 0xBB, 0xBA, 0x98, 0x88, 0x88, 0x88,
    0x89, 0x9A, 0xAB, 0xBC, 0xBB, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x88,
    0x9A, 0xBB, 0xCB, 0xAB, 0xA9, 0x87, 0x76, 0x66, 0x67, 0x77, 0x89, 0x9A,
    0xBB, 0xBA, 0xB9, 0x98, 0x76, 0x66, 0x56, 0x66, 0x78, 0x89, 0xAB, 0xBB,
    0xAA, 0x99, 0x87, 0x65, 0x55, 0x55, 0x67, 0x78, 0x9A, 0xAB, 0xBA, 0xA9,
    0x88, 0x76, 0x55, 0x44, 0x56, 0x67, 0x89, 0x9A, 0xBB, 0xAA, 0x99, 0x87,
    0x66, 0x54, 0x45, 0x56, 0x78, 0x89, 0xAB, 0xBA, 0xAA, 0x98, 0x77, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0xAA, 0xA9, 0x88, 0x76, 0x66, 0x56,
    0x66, 0x78, 0x99, 0xBB, 0xBA, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCB, 0xAB, 0xAA, 0x98, 0x88, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBC, 0xCB, 0xBB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x89, 0x9A, 0xBC, 0xCC,
    0xBC, 0xBB, 0xAA, 0x99, 0x99, 0x88, 0x99, 0x9A, 0xAB, 0xCD, 0xCB, 0xCB,
    0xBB, 0xAA, 0xA9, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xDD, 0xBD, 0xDC, 0xBB,
    0xBB, 0xAA, 0xAA, 0xAB, 0xBB, 0xCC, 0xDE, 0xDB, 0xDD, 0xCC, 0xCB, 0xBB,
    0xBB, 0xBC, 0xCC, 0xCD, 0xDD, 0xED, 0x8B, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
    0xBB, 0xBC, 0xCD, 0xDD, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xEE, 0xFF, 0xDF, 0xDD, 0xCC, 0xCC, 0xDD, 0xCC, 0xCC, 0xCC, 0x7F, 0xFF,
    0xFF, 0xFD, 0xDE, 0xDD, 0xDE, 0xDE, 0xEF, 0xFF, 0xFE, 0xFF, 0xFF, 0xED,
    0xCD, 0xCC, 0xCC, 0xDC, 0xDD, 0xEE, 0xFF, 0xDF, 0xFF, 0xDE, 0xCC, 0xBB,
    0xBB, 0xBB, 0xBC, 0xDD, 0xFE, 0xFE, 0xFF, 0xED, 0xCB, 0xAA, 0x99, 0xAA,
    0xAA, 0xBC, 0xCE, 0xEF, 0xEE, 0xED, 0xCB, 0xA9, 0x88, 0x88, 0x89, 0xAB,
    0xCC, 0xDE, 0xFF, 0xDF, 0xDB, 0xA9, 0x87, 0x77, 0x77, 0x89, 0xAB, 0xCD,
    0xDE, 0xED, 0xFC, 0xBA, 0x97, 0x66, 0x55, 0x67, 0x89, 0xAB, 0xCE, 0xED,
    0xDE, 0xCB, 0xA8, 0x75, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xDE, 0xED, 0xEC,
    0xB9, 0x87, 0x54, 0x33, 0x45, 0x78, 0xAB, 0xCE, 0xFF, 0xDE, 0xCB, 0x98,
    0x75, 0x43, 0x34, 0x57, 0x89, 0xBC, 0xDE, 0xFD, 0xDC, 0xBA, 0x97, 0x65,
    0x44, 0x46, 0x78, 0xAB, 0xCD, 0xFE, 0xDE, 0xCB, 0xA9, 0x87, 0x65, 0x56,
    0x67, 0x9A, 0xBC, 0xDF, 0xDD, 0xED, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x89,
    0xAC, 0xDF, 0xFF, 0xEF, 0xDC, 0xBB, 0xA9, 0x88, 0x88, 0x99, 0xAB, 0xCD,
    0xFF, 0xFF, 0xFD, 0xDC, 0xBB, 0xAA, 0x99, 0x9A, 0xAB, 0xCE, 0xDF, 0xFF,
    0xDF, 0xFD, 0xDC, 0xBB, 0xBB, 0xBB, 0xBC, 0xCD, 0xEF, 0xFF, 0xFD, 0xFF,
    0xDE, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xEE, 0xFF, 0xFF, 0xDF, 0xEF, 0xEE,
    0xED, 0xDD, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFD, 0xFE, 0xEF, 0xFE, 0xEE,
    0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0xCC, 0xDD, 0xDD, 0xED, 0xDE,
    0xEE, 0xEF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xCC, 0xCB, 0xBB, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDD, 0xFD, 0xDF, 0xFF, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC,
    0xCC, 0xCD, 0xFF, 0xFD, 0xFF, 0xFD, 0xFF, 0xFF, 0xFC, 0xDB, 0xBA, 0xBB,
    0xCB, 0xDD, 0xFD, 0xFF, 0xFF, 0xFF, 0xFD, 0xCB, 0xA9, 0x99, 0x9A, 0xBC,
    0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0x98, 0x77, 0x78, 0x9A, 0xBC, 0xDD,
    0xFD, 0xFF, 0xFF, 0xDD, 0xA8, 0x76, 0x55, 0x68, 0x9A, 0xBC, 0xFF, 0xFF,
    0xFF, 0xFC, 0xC9, 0x76, 0x54, 0x45, 0x68, 0xAB, 0xCC, 0xFF, 0xFF, 0xFD,
    0xCA, 0x97, 0x54, 0x23, 0x45, 0x79, 0xBC, 0xFF, 0xFF, 0xFF, 0xDC, 0xB9,
    0x76, 0x43, 0x24, 0x57, 0x9A, 0xCF, 0xFF, 0xFF, 0xFD, 0xDB, 0xA8, 0x65,
    0x44, 0x56, 0x79, 0xBD, 0xFF, 0xFF, 0xFF, 0xDC, 0xBA, 0x87, 0x65, 0x56,
    0x78, 0xAC, 0xDF, 0xFF, 0xFD, 0xFC, 0xFD, 0xBA, 0x88, 0x77, 0x78, 0x9A,
    0xCD, 0xFF, 0xFF, 0xDF, 0xFF, 0xDC, 0xBA, 0x99, 0x99, 0xAB, 0xCD, 0xFF,
    0xFF, 0xFD, 0xFF, 0xFD, 0xDC, 0xBB, 0xBA, 0xBB, 0xDD, 0xFF, 0xFF, 0xFF,
    0xDF, 0xFD, 0xFF, 0xDD, 0xDC, 0xCB, 0xDC, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF,
    0xDF, 0xDD, 0xFD, 0xFD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFD,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0xCB, 0xDD, 0xCF, 0xFF, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xEF, 0xEF, 0xFD, 0xDC, 0xDC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x9F, 0xFF,
    0xFE, 0xDD, 0xDC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDF, 0xFD, 0xFF, 0xFF, 0xCC,
    0xCB, 0xBB, 0xBB, 0xBB, 0xBC, 0xDC, 0xEF, 0xEF, 0xFD, 0xDC, 0xBA, 0xAA,
    0x99, 0xAA, 0xAB, 0xCC, 0xDE, 0xFD, 0xFE, 0xDC, 0xBA, 0x99, 0x88, 0x89,
    0x9A, 0xAA, 0xCC, 0xDD, 0xED, 0xDC, 0xBA, 0x98, 0x87, 0x77, 0x78, 0x89,
    0xAB, 0xCD, 0xEE, 0xDD, 0xBA, 0x98, 0x77, 0x66, 0x66, 0x78, 0x89, 0xAC,
    0xCD, 0xDD, 0xCB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xED,
    0xDC, 0xBA, 0x87, 0x65, 0x54, 0x45, 0x66, 0x79, 0xAB, 0xCD, 0xEC, 0xCB,
    0xA8, 0x76, 0x54, 0x44, 0x55, 0x67, 0x89, 0xBD, 0xEE, 0xCC, 0xBA, 0x87,
    0x65, 0x54, 0x44, 0x56, 0x78, 0xAB, 0xDE, 0xEC, 0xCB, 0x98, 0x76, 0x65,
    0x54, 0x55, 0x67, 0x8A, 0xBC, 0xFE, 0xCC, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAB, 0xDF, 0xFC, 0xCB, 0xA9, 0x88, 0x76, 0x66, 0x67, 0x78,
    0x9A, 0xBE, 0xFF, 0xCC, 0xCB, 0xA9, 0x88, 0x77, 0x77, 0x78, 0x9A, 0xBC,
    0xFF, 0xFC, 0xDD, 0xBB, 0xAA, 0x99, 0x88, 0x89, 0x9A, 0xBC, 0xDF, 0xFF,
    0xDD, 0xDC, 0xBB, 0xBA, 0xA9, 0x9A, 0xAA, 0xBC, 0xDE, 0xFF, 0xFC, 0xED,
    0xCC, 0xCC, 0xBB, 0xBB, 0xBC, 0xCC, 0xDE, 0xFF, 0xFF, 0xDD, 0xDD, 0xED,
    0xDC, 0xDC, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFE, 0xDE, 0xDD,
    0xDD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0x9C, 0xDD, 0xDD, 0xDF, 0xDE, 0xEE,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFE, 0xDC, 0xCC, 0xCC, 0xCC, 0xCD, 0xDD, 0xDE, 0xBF, 0xFF,
    0xFE, 0xDC, 0xCC, 0xBB, 0xBC, 0xCC, 0xDD, 0xEF, 0xFF, 0xFF, 0xFD, 0xCC,
    0xBB, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xEF, 0xEF, 0xFD, 0xCB, 0xAA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xDD, 0xFE, 0xFE, 0xCB, 0xA9, 0x98, 0x88, 0x88,
    0x89, 0x9A, 0xBC, 0xDF, 0xDD, 0xDC, 0xA9, 0x88, 0x77, 0x77, 0x77, 0x89,
    0x9A, 0xBC, 0xDD, 0xDC, 0xBA, 0x98, 0x76, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xDC, 0xCB, 0x98, 0x76, 0x65, 0x55, 0x56, 0x77, 0x89, 0xAC, 0xDD,
    0xCC, 0xA9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xBD, 0xDC, 0xBA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xCB, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xBD, 0xDC, 0xBA, 0x98, 0x76, 0x65,
    0x55, 0x55, 0x67, 0x89, 0xAC, 0xDE, 0xCC, 0xA9, 0x87, 0x76, 0x65, 0x55,
    0x66, 0x78, 0x9B, 0xCD, 0xEC, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xEF, 0xCC, 0xBA, 0x99, 0x87, 0x77, 0x77, 0x78, 0x89, 0xAC,
    0xDF, 0xFD, 0xDC, 0xBA, 0x99, 0x88, 0x88, 0x88, 0x99, 0xAB, 0xCE, 0xFF,
    0xDD, 0xDC, 0xBA, 0xA9, 0x99, 0x99, 0x9A, 0xBB, 0xCD, 0xFF, 0xFD, 0xED,
    0xCC, 0xBB, 0xAA, 0xAA, 0xAB, 0xBC, 0xDD, 0xFF, 0xFF, 0xDF, 0xED, 0xDC,
    0xCC, 0xBB, 0xBC, 0xCC, 0xDE, 0xFF, 0xFF, 0xFE, 0xFF, 0xEE, 0xDD, 0xDC,
    0xDD, 0xDD, 0xEF, 0xFF, 0xFF, 0xFF, 0xBE, 0xED, 0xDD, 0xDD, 0xDD, 0xDD,
    0xEF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFE, 0xDD, 0xFD, 0xEC, 0xDC, 0xCD, 0xCE, 0x9F, 0xFF,
    0xFF, 0xFD, 0xDD, 0xCC, 0xDC, 0xDD, 0xDE, 0xEF, 0xFD, 0xFF, 0xFF, 0xED,
    0xDC, 0xCB, 0xBB, 0xCC, 0xCC, 0xDD, 0xEF, 0xDF, 0xFE, 0xDD, 0xCB, 0xAA,
    0xAA, 0xAA, 0xBC, 0xCD, 0xDD, 0xFD, 0xFF, 0xDC, 0xBA, 0x99, 0x98, 0x99,
    0x9A, 0xAB, 0xCC, 0xDD, 0xDF, 0xED, 0xBA, 0x98, 0x87, 0x77, 0x88, 0x9A,
    0xAB, 0xCD, 0xFD, 0xED, 0xCB, 0x98, 0x77, 0x66, 0x67, 0x78, 0x9A, 0xAC,
    0xDD, 0xDD, 0xEB, 0xA9, 0x87, 0x65, 0x55, 0x66, 0x78, 0x9A, 0xBC, 0xDD,
    0xDD, 0xBA, 0x97, 0x65, 0x54, 0x45, 0x67, 0x89, 0xAB, 0xDE, 0xDD, 0xCB,
    0xA9, 0x76, 0x54, 0x44, 0x45, 0x67, 0x8A, 0xBC, 0xFD, 0xDD, 0xBA, 0x97,
    0x65, 0x44, 0x44, 0x56, 0x78, 0xAB, 0xCD, 0xDD, 0xDC, 0xA9, 0x87, 0x65,
    0x44, 0x55, 0x67, 0x9A, 0xBD, 0xEE, 0xDD, 0xBA, 0x98, 0x76, 0x65, 0x55,
    0x67, 0x89, 0xAC, 0xDD, 0xED, 0xDC, 0xBA, 0x98, 0x77, 0x66, 0x67, 0x78,
    0x9B, 0xCF, 0xFE, 0xDD, 0xDB, 0xAA, 0x98, 0x87, 0x77, 0x88, 0x9A, 0xBD,
    0xDF, 0xFD, 0xDD, 0xBB, 0xA9, 0x99, 0x89, 0x89, 0xAA, 0xBD, 0xEE, 0xFF,
    0xDE, 0xDC, 0xBB, 0xAA, 0xAA, 0xAA, 0xAB, 0xBD, 0xDF, 0xFF, 0xFD, 0xDD,
    0xDC, 0xCB, 0xBB, 0xBB, 0xBC, 0xCD, 0xDF, 0xFF, 0xFF, 0xDE, 0xDD, 0xDC,
    0xCC, 0xCC, 0xCC, 0xDD, 0xFE, 0xFF, 0xFF, 0xFC, 0xFF, 0xDF, 0xFE, 0xDE,
    0xDD, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9C, 0xCC, 0xDC, 0xDC, 0xDD, 0xDD,
    0xDD, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBB, 0xBB, 0xCB, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFD, 0xFF,
    0xCD, 0xDC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBB, 0xCC,
    0xCC, 0xCD, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xCB, 0xAA, 0xA9, 0xAB, 0xBD,
    0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xA9, 0x88, 0x88, 0x9A, 0xBC, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFC, 0xB9, 0x76, 0x66, 0x78, 0x9B, 0xCD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xCA, 0x86, 0x54, 0x45, 0x79, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFB, 0xA8, 0x64, 0x22, 0x46, 0x8A, 0xCF, 0xFF, 0xFF, 0xFF, 0xFD, 0xBA,
    0x86, 0x42, 0x24, 0x68, 0xAB, 0xDF, 0xFF, 0xFF, 0xFF, 0xDC, 0xB8, 0x75,
    0x44, 0x56, 0x8A, 0xCF, 0xFF, 0xFF, 0xDF, 0xFD, 0xCB, 0x98, 0x76, 0x67,
    0x89, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xBA, 0xA9, 0x88, 0x89, 0xBB,
    0xCF, 0xFF, 0xFF, 0xDF, 0xFF, 0xCC, 0xBB, 0xAA, 0xAA, 0xBC, 0xDF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFD, 0xCC, 0xCC, 0xBC, 0xCC, 0xCF, 0xFF, 0xFF, 0xFF,
    0xCF, 0xFD, 0xFF, 0xCC, 0xDD, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDD, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7B, 0xCD, 0xDC, 0xCD, 0xDF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xDF, 0xFD, 0xCB, 0xBF, 0xBC, 0xDC, 0xBA, 0xCB, 0xCB, 0x7F, 0xDF,
    0xDD, 0xDF, 0xCC, 0xBC, 0xFC, 0xFC, 0xFF, 0xFF, 0xFC, 0xDD, 0xFF, 0xDD,
    0xDC, 0xFB, 0xDB, 0xCB, 0xCF, 0xDC, 0xFF, 0xBC, 0xFF, 0xFA, 0xFB, 0xFB,
    0xAB, 0xCC, 0xCC, 0xFF, 0xFF, 0xFF, 0xFD, 0xFC, 0xBB, 0xAA, 0xA9, 0x9A,
    0xBB, 0xCC, 0xCC, 0xFF, 0xCC, 0xFD, 0xCB, 0x9B, 0x89, 0x88, 0x99, 0xAB,
    0xAD, 0xCD, 0xFF, 0xFC, 0xBA, 0xAA, 0x97, 0x77, 0x78, 0x89, 0xAA, 0xBF,
    0xFF, 0xCB, 0xFC, 0xB9, 0x97, 0x76, 0x66, 0x77, 0x89, 0xAA, 0xFC, 0xFB,
    0xBC, 0xBB, 0xA9, 0x76, 0x54, 0x55, 0x67, 0x8A, 0xAC, 0xDC, 0xDD, 0xCC,
    0xB9, 0x97, 0x64, 0x23, 0x46, 0x78, 0x9C, 0xCB, 0xFC, 0xCF, 0xBB, 0xA8,
    0x76, 0x43, 0x24, 0x67, 0x99, 0xAC, 0xCF, 0xCF, 0xBC, 0xC9, 0x97, 0x65,
    0x44, 0x56, 0x78, 0x9A, 0xCD, 0xFF, 0xDC, 0xCA, 0xA9, 0x87, 0x66, 0x66,
    0x78, 0x9A, 0xBB, 0xFF, 0xFF, 0xFF, 0xCB, 0xA9, 0x87, 0x77, 0x77, 0x8A,
    0xBC, 0xBC, 0xFC, 0xFC, 0xCF, 0xCC, 0x99, 0x98, 0x88, 0x99, 0x9A, 0xCF,
    0xCF, 0xFF, 0xFF, 0xFC, 0xCB, 0xAA, 0x9A, 0xA9, 0xAA, 0xCF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFE, 0xEC, 0xAA, 0xAB, 0xAC, 0xCC, 0xDF, 0xFF, 0xFC, 0xDF,
    0xCD, 0xCD, 0xBC, 0xCB, 0xCF, 0xFB, 0xDC, 0xFD, 0xFF, 0xDF, 0xFF, 0xDC,
    0xFD, 0xDC, 0xFC, 0xDF, 0xDD, 0xCF, 0xFF, 0xFA, 0xDC, 0xDF, 0xFD, 0xFD,
    0xCD, 0xDF, 0xDF, 0xDD, 0xDF, 0xFF, 0x6C, 0xBB, 0xCC, 0xCC, 0xDB, 0xFD,
    0xCF, 0xFF, 0xDD, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xCB, 0xAA, 0xAA, 0x99, 0x99, 0xA9, 0xAA, 0xAA, 0xAB, 0x8C, 0xCC,
    0xBB, 0xBA, 0xAA, 0xAA, 0xAA, 0xAB, 0xCB, 0xCD, 0xDB, 0xBC, 0xCA, 0xBA,
    0x9A, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCE, 0xCB, 0xBB, 0xAA, 0x99, 0x98,
    0x88, 0x89, 0x9A, 0xAB, 0xBC, 0xCB, 0xBB, 0xA9, 0x98, 0x88, 0x88, 0x88,
    0x89, 0x99, 0xAB, 0xBC, 0xBA, 0xBA, 0x98, 0x87, 0x77, 0x77, 0x78, 0x89,
    0x9A, 0xAB, 0xCB, 0xAB, 0xA9, 0x87, 0x77, 0x66, 0x67, 0x77, 0x89, 0x9A,
    0xBC, 0xBA, 0xA9, 0x98, 0x76, 0x66, 0x66, 0x66, 0x77, 0x89, 0x9A, 0xBB,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x56, 0x67, 0x78, 0x89, 0xAB, 0xBA, 0xA9,
    0x88, 0x76, 0x65, 0x44, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0x9A, 0x98, 0x87,
    0x66, 0x54, 0x45, 0x56, 0x78, 0x89, 0xAA, 0xB9, 0xA9, 0x88, 0x77, 0x65,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBB, 0x9A, 0xA9, 0x87, 0x76, 0x66, 0x56,
    0x66, 0x78, 0x99, 0xAB, 0xBA, 0xBA, 0x99, 0x87, 0x76, 0x66, 0x66, 0x77,
    0x89, 0xAB, 0xCB, 0xAB, 0xA9, 0x98, 0x88, 0x77, 0x77, 0x77, 0x88, 0x9A,
    0xBC, 0xDA, 0xBB, 0xA9, 0x98, 0x88, 0x87, 0x88, 0x88, 0x9A, 0xAB, 0xCB,
    0xAC, 0xBA, 0xAA, 0x99, 0x98, 0x88, 0x89, 0x99, 0xAB, 0xCD, 0xCA, 0xCB,
    0xBA, 0xBA, 0xA9, 0x99, 0x99, 0xAA, 0xAB, 0xCC, 0xDC, 0xBD, 0xCC, 0xBB,
    0xBA, 0xAA, 0xBA, 0xAA, 0xBB, 0xBE, 0xED, 0xCB, 0xCC, 0xDD, 0xCB, 0xBB,
    0xBB, 0xBB, 0xBB, 0xCD, 0xFE, 0xFE, 0x8C, 0xBB, 0xBB, 0xAA, 0xAB, 0xBB,
    0xBB, 0xCC, 0xCD, 0xDD, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xBB, 0xAA, 0xA9, 0x99, 0x99, 0x99, 0xAA, 0xAB, 0xBC, 0xAC, 0xCC,
    0xBA, 0xAA, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xBC, 0xDC, 0xBC, 0xBA, 0xA9,
    0x99, 0x98, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xBB, 0xBA, 0xA9, 0x98, 0x88,
    0x88, 0x88, 0x89, 0x9A, 0xAB, 0xCB, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77,
    0x88, 0x89, 0x9A, 0xBB, 0xBA, 0xA9, 0x98, 0x77, 0x77, 0x77, 0x77, 0x78,
    0x89, 0x9A, 0xBA, 0xAA, 0x98, 0x87, 0x76, 0x66, 0x66, 0x77, 0x78, 0x89,
    0xAB, 0xA9, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0x9A, 0xAA,
    0x99, 0x98, 0x77, 0x66, 0x65, 0x66, 0x66, 0x77, 0x89, 0x9A, 0xA9, 0x99,
    0x87, 0x76, 0x65, 0x55, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x99, 0x88, 0x77,
    0x66, 0x65, 0x55, 0x66, 0x77, 0x88, 0x9A, 0xA9, 0x99, 0x87, 0x76, 0x66,
    0x65, 0x66, 0x67, 0x78, 0x99, 0xAA, 0x99, 0x98, 0x87, 0x76, 0x66, 0x66,
    0x66, 0x77, 0x89, 0xAA, 0xA9, 0xA9, 0x88, 0x77, 0x76, 0x66, 0x66, 0x77,
    0x88, 0x9A, 0xBA, 0xAA, 0x99, 0x88, 0x77, 0x77, 0x77, 0x77, 0x88, 0x99,
    0xAB, 0xBA, 0xAA, 0x99, 0x88, 0x87, 0x77, 0x77, 0x88, 0x99, 0xAB, 0xBB,
    0xAB, 0xAA, 0x99, 0x88, 0x88, 0x88, 0x88, 0x99, 0xAA, 0xBC, 0xCB, 0xBB,
    0xAA, 0x99, 0x99, 0x98, 0x99, 0x99, 0xAA, 0xBC, 0xDC, 0xBC, 0xBB, 0xBA,
    0xAA, 0x99, 0x99, 0x9A, 0xAB, 0xBC, 0xCD, 0xDC, 0xDC, 0xCB, 0xBA, 0xAA,
    0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xED, 0xAC, 0xBB, 0xBA, 0xAA, 0xAA, 0xAA,
    0xAA, 0xBB, 0xCC, 0xDE, 0xD0, 0x00, 0x00, 0x00,
  },
  {
    0xBC, 0xBA, 0xBA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0x8C, 0xCC,
    0xBB, 0xBA, 0xAA, 0xAA, 0xBB, 0xBB, 0xCD, 0xDC, 0xDB, 0xBC, 0xBC, 0xA9,
    0x99, 0x99, 0x99, 0x9A, 0xAA, 0xBB, 0xCC, 0xAB, 0xCA, 0xAA, 0x98, 0x88,
    0x88, 0x89, 0x99, 0xAA, 0xCC, 0xBA, 0xBB, 0xA9, 0x98, 0x88, 0x78, 0x88,
    0x88, 0x99, 0xAA, 0xBB, 0xAA, 0xAA, 0x98, 0x87, 0x77, 0x77, 0x77, 0x88,
    0x99, 0xAA, 0xBA, 0xBA, 0x98, 0x87, 0x76, 0x66, 0x67, 0x77, 0x88, 0x9A,
    0xBA, 0xAA, 0xA9, 0x88, 0x76, 0x66, 0x66, 0x66, 0x77, 0x88, 0xAA, 0xAA,
    0xAA, 0x98, 0x87, 0x66, 0x55, 0x56, 0x67, 0x78, 0x99, 0xAA, 0xAA, 0xA9,
    0x88, 0x76, 0x65, 0x44, 0x56, 0x67, 0x88, 0x9A, 0xAA, 0x9A, 0x98, 0x87,
    0x66, 0x54, 0x45, 0x66, 0x78, 0x89, 0xAB, 0xAA, 0xB9, 0x98, 0x76, 0x66,
    0x55, 0x56, 0x67, 0x88, 0x9A, 0xBA, 0xAA, 0x99, 0x88, 0x77, 0x66, 0x66,
    0x66, 0x78, 0x99, 0xAB, 0xBA, 0xAA, 0x98, 0x87, 0x77, 0x66, 0x66, 0x77,
    0x89, 0x9A, 0xBB, 0xAB, 0xA9, 0x98, 0x87, 0x77, 0x77, 0x77, 0x89, 0x9A,
    0xBB, 0xAB, 0xDA, 0xA9, 0x98, 0x88, 0x77, 0x88, 0x88, 0x9A, 0xAC, 0xBB,
    0xBC, 0xAB, 0xA9, 0x99, 0x98, 0x88, 0x89, 0x9A, 0xAA, 0xBD, 0xCB, 0xBB,
    0xBB, 0xA9, 0xA9, 0x99, 0x99, 0xAA, 0xAC, 0xBC, 0xCC, 0xBC, 0xCC, 0xBA,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xBC, 0xCD, 0xCB, 0xCD, 0xBB, 0xCB, 0xBA,
    0xBB, 0xBB, 0xAC, 0xBB, 0xDD, 0xDD, 0x7A, 0xAA, 0xAA, 0xBA, 0xAA, 0xAA,
    0xAB, 0xBB, 0xBB, 0xCD, 0xB0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBF, 0xDF, 0xBB, 0xAB, 0xBF, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xCC, 0xFD, 0xFF, 0xDF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFC,
    0xBB, 0xDF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBC, 0xBF,
    0xCF, 0xBF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFD, 0xFF, 0xBB, 0xBA, 0xAB, 0xFC,
    0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0xCA, 0x99, 0x99, 0xAC, 0xDF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xCD, 0xBA, 0x87, 0x77, 0x89, 0x9B, 0xBF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xCB, 0x97, 0x54, 0x46, 0x8A, 0xDB, 0xFF, 0xFF, 0xFF, 0xFF,
    0xCD, 0xA9, 0x64, 0x12, 0x57, 0x9B, 0xBF, 0xDF, 0xFF, 0xFF, 0xFF, 0xBA,
    0x97, 0x52, 0x24, 0x79, 0xAB, 0xCF, 0xFF, 0xFF, 0xFF, 0xFC, 0xA9, 0x86,
    0x54, 0x57, 0x9B, 0xFD, 0xFF, 0xFD, 0xFF, 0xFC, 0xCC, 0xA9, 0x87, 0x77,
    0x8A, 0xAC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0x99, 0x99, 0x9A, 0xAF,
    0xCF, 0xFF, 0xFF, 0xDF, 0xFF, 0xBF, 0xAC, 0xBA, 0xAA, 0xCC, 0xBF, 0xFF,
    0xFF, 0xFD, 0xFF, 0xFF, 0xCB, 0xBC, 0xBB, 0xDF, 0xDD, 0xFF, 0xFF, 0xFF,
    0xDF, 0xFF, 0xDF, 0xFC, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFD, 0xFD, 0xDF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFD,
    0xDF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6B, 0xCF, 0xDF, 0xDF, 0xFF, 0xCF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xAF, 0xFF, 0xBF, 0xAB, 0xFB, 0x9F, 0xBB, 0xAB, 0x6B, 0xFF,
    0xFB, 0xFF, 0xAF, 0xAA, 0xFB, 0xFA, 0xBB, 0xFF, 0xFF, 0xFF, 0xFB, 0xBF,
    0xB9, 0xFB, 0xBA, 0xBB, 0xBF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFA, 0xFB, 0xBB,
    0xAA, 0xFF, 0xFA, 0xBF, 0xBF, 0xFF, 0xBF, 0xFA, 0xAF, 0xBB, 0x99, 0x9A,
    0xA9, 0xBF, 0xFB, 0xFB, 0xAB, 0xFB, 0xBA, 0xA9, 0x98, 0x9A, 0x99, 0xAA,
    0xFB, 0xBB, 0xFF, 0xAF, 0xFA, 0xAA, 0x98, 0x78, 0x78, 0x89, 0xAF, 0xBF,
    0xAF, 0xFB, 0xBF, 0xBA, 0x99, 0x76, 0x66, 0x88, 0x99, 0xBF, 0xFF, 0xBF,
    0xFF, 0xFA, 0x98, 0x77, 0x54, 0x56, 0x79, 0x9B, 0xBF, 0xBB, 0xBB, 0xAF,
    0xAB, 0xA8, 0x64, 0x22, 0x57, 0x88, 0x9A, 0xFF, 0xAB, 0xAF, 0x99, 0xB8,
    0x77, 0x52, 0x25, 0x79, 0xA9, 0xAA, 0xFF, 0xFA, 0xBB, 0xBA, 0x98, 0x76,
    0x54, 0x66, 0x78, 0x99, 0xBF, 0xFB, 0x9F, 0xFA, 0x9A, 0x98, 0x76, 0x66,
    0x78, 0x8A, 0xFA, 0xAB, 0xAF, 0xFB, 0xBA, 0xB8, 0x98, 0x88, 0x78, 0x9A,
    0xAB, 0xFF, 0xFB, 0xAF, 0xBF, 0xBA, 0xAA, 0x99, 0xA9, 0x9F, 0x8A, 0xFA,
    0xFF, 0xAA, 0xFF, 0xBB, 0xAF, 0xA9, 0xA8, 0x89, 0xAB, 0xFA, 0xBB, 0xFF,
    0xFB, 0xFF, 0xFF, 0xFB, 0xA9, 0xAB, 0xAF, 0xBF, 0xBB, 0xBB, 0xBB, 0xFF,
    0xBF, 0xFB, 0xFF, 0xFA, 0xBF, 0xAF, 0xAF, 0xFB, 0xFF, 0xAF, 0xBF, 0xFF,
    0xFF, 0xBB, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFB, 0xFF, 0xFB, 0xFF, 0xFF, 0xFB, 0x6F, 0xAA, 0xAB, 0xAB, 0xBA, 0xFA,
    0xFA, 0xBB, 0xFF, 0xFB, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xDE, 0xFF, 0xFF, 0xFF, 0xDC, 0xCC, 0xCF, 0xCD, 0xCF, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFD, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xDC,
    0xFC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xCC, 0xDC, 0xDD,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xEB, 0xBA, 0xBB, 0xBC, 0xDD, 0xFD,
    0xDF, 0xFC, 0xFF, 0xDD, 0xCB, 0x98, 0x78, 0x9A, 0xCC, 0xFF, 0xFF, 0xFF,
    0xDF, 0xFF, 0xFD, 0xB8, 0x54, 0x46, 0x9B, 0xCD, 0xDF, 0xFF, 0xFF, 0xFF,
    0xCD, 0xDA, 0x74, 0x22, 0x48, 0xAC, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
    0xA7, 0x42, 0x14, 0x7A, 0xDF, 0xFF, 0xFF, 0xDD, 0xFF, 0xFD, 0xDA, 0x96,
    0x44, 0x58, 0xBC, 0xFD, 0xFF, 0xFF, 0xFF, 0xDF, 0xFC, 0xDA, 0x97, 0x78,
    0xAC, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFC, 0xCA, 0xAA, 0xAB, 0xCF,
    0xFF, 0xFD, 0xFF, 0xDF, 0xFF, 0xFD, 0xFC, 0xDC, 0xBC, 0xCD, 0xDF, 0xDF,
    0xFF, 0xFC, 0xFF, 0xFD, 0xFF, 0xDF, 0xCC, 0xFD, 0xFD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xDF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xDD, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xDF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6B, 0xDD, 0xCD, 0xDD, 0xFF, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xDD, 0xDD, 0xCD, 0xDD, 0xDE, 0xDF, 0xFF, 0xCF, 0xFF,
    0xFF, 0xDC, 0xCC, 0xCB, 0xCC, 0xBD, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xDC,
    0xBB, 0xBA, 0xAA, 0xBB, 0xCC, 0xDF, 0xEF, 0xFF, 0xFD, 0xCC, 0xBA, 0x99,
    0x99, 0x99, 0xAA, 0xBC, 0xDF, 0xFF, 0xFE, 0xDC, 0xAA, 0x98, 0x88, 0x88,
    0x89, 0xAB, 0xBC, 0xDE, 0xFF, 0xDC, 0xB9, 0x98, 0x77, 0x77, 0x77, 0x89,
    0xAA, 0xCC, 0xFF, 0xFC, 0xCA, 0x98, 0x76, 0x66, 0x66, 0x77, 0x89, 0xAB,
    0xCD, 0xFE, 0xCB, 0xA8, 0x76, 0x65, 0x55, 0x56, 0x77, 0x99, 0xBC, 0xDE,
    0xDC, 0xB9, 0x87, 0x65, 0x55, 0x55, 0x66, 0x78, 0x9A, 0xCD, 0xDC, 0xCA,
    0x98, 0x76, 0x55, 0x44, 0x55, 0x67, 0x89, 0xAB, 0xDD, 0xCC, 0xA9, 0x87,
    0x65, 0x54, 0x45, 0x56, 0x78, 0x9A, 0xCD, 0xEC, 0xCA, 0x98, 0x76, 0x55,
    0x55, 0x55, 0x67, 0x89, 0xAB, 0xDF, 0xCC, 0xB9, 0x87, 0x76, 0x55, 0x55,
    0x66, 0x78, 0xAB, 0xCF, 0xFD, 0xCB, 0xA9, 0x87, 0x76, 0x66, 0x66, 0x78,
    0x9A, 0xBC, 0xFF, 0xDD, 0xCA, 0xA9, 0x87, 0x77, 0x77, 0x78, 0x9A, 0xBC,
    0xDF, 0xFD, 0xDC, 0xBA, 0xA9, 0x88, 0x88, 0x88, 0x9A, 0xAC, 0xDF, 0xFF,
    0xFF, 0xDC, 0xBA, 0xA9, 0x99, 0x99, 0xAA, 0xBB, 0xDF, 0xFF, 0xFF, 0xFF,
    0xDD, 0xCB, 0xBA, 0xAA, 0xAB, 0xBC, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDC,
    0xDC, 0xCC, 0xCC, 0xCD, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xDD,
    0xDD, 0xDE, 0xEF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFE, 0xFE, 0xDD, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xCF, 0xFE, 0xFD, 0xDC, 0xCF, 0xFD, 0xED, 0xCC, 0xBC, 0xEC, 0x7F, 0xEF,
    0xFF, 0xEF, 0xEF, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDF, 0xDD, 0xFF,
    0xDD, 0xFD, 0xEF, 0xEF, 0xEE, 0xEF, 0xFF, 0xCF, 0xEF, 0xFF, 0xDF, 0xEF,
    0xDF, 0xDE, 0xEF, 0xEF, 0xFF, 0xFD, 0xEE, 0xFD, 0xFD, 0xDD, 0xDD, 0xCC,
    0xDD, 0xEE, 0xFE, 0xFD, 0xED, 0xFF, 0xEE, 0xDC, 0xCC, 0xBC, 0xBC, 0xCE,
    0xED, 0xFF, 0xFE, 0xEF, 0xCD, 0xFF, 0xBB, 0xAA, 0xAA, 0xBC, 0xDD, 0xEE,
    0xFF, 0xFF, 0xFF, 0xFC, 0xCB, 0x98, 0x77, 0x89, 0xBC, 0xDE, 0xFF, 0xFD,
    0xDE, 0xDF, 0xDC, 0xA8, 0x54, 0x46, 0x8A, 0xCF, 0xEF, 0xEF, 0xDC, 0xFF,
    0xDC, 0xCA, 0x74, 0x12, 0x47, 0xAC, 0xED, 0xEE, 0xFE, 0xEE, 0xEF, 0xFB,
    0xA7, 0x42, 0x24, 0x7A, 0xBD, 0xEE, 0xEF, 0xDE, 0xED, 0xDE, 0xCA, 0x86,
    0x44, 0x68, 0xAD, 0xDD, 0xEE, 0xFD, 0xDE, 0xEE, 0xFC, 0xB9, 0x87, 0x78,
    0xAB, 0xCF, 0xDD, 0xFF, 0xFD, 0xFF, 0xFC, 0xCC, 0xBA, 0x9A, 0xAB, 0xBE,
    0xEF, 0xEF, 0xFD, 0xDF, 0xFF, 0xFD, 0xCC, 0xCC, 0xCC, 0xDC, 0xCD, 0xFF,
    0xFF, 0xEF, 0xFF, 0xFE, 0xDE, 0xDD, 0xCC, 0xFD, 0xEF, 0xDF, 0xFF, 0xFE,
    0xFF, 0xFF, 0xED, 0xDD, 0xDD, 0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0xDE, 0xFF,
    0xFE, 0xFF, 0xED, 0xFE, 0xFE, 0xFF, 0xEF, 0xFF, 0xFF, 0xCE, 0xEF, 0xFF,
    0xFF, 0xFD, 0xDE, 0xFF, 0xEF, 0xFF, 0xFF, 0xFD, 0xFF, 0xEF, 0xFE, 0xEE,
    0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0xDD, 0xCC, 0xCC, 0xCE, 0xCE,
    0xCE, 0xED, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x8F, 0xF8, 0xF8, 0xF9, 0xF8, 0x5F, 0xFF,
    0xF9, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF,
    0xF8, 0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF,
    0x88, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFE, 0x8F, 0x8F,
    0x8F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0x78, 0xFF, 0xFF,
    0xF8, 0x8F, 0xFF, 0xFF, 0xFF, 0xF9, 0x8F, 0xF8, 0xF9, 0xF9, 0x8F, 0xFF,
    0x8F, 0x8F, 0xF8, 0x89, 0x8F, 0x68, 0x68, 0x88, 0x88, 0xF8, 0xFF, 0xFF,
    0xFF, 0xF8, 0x88, 0x78, 0x64, 0x56, 0xFF, 0x8F, 0xF8, 0xFF, 0xFF, 0xF8,
    0xFF, 0x88, 0x64, 0x22, 0x48, 0x88, 0x8F, 0xFF, 0xFF, 0xE9, 0x8F, 0xFF,
    0xF7, 0x52, 0x25, 0x78, 0x8F, 0xF8, 0xFF, 0xFF, 0x9F, 0xFF, 0xF8, 0x87,
    0x44, 0x58, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x8F, 0xF7, 0x76,
    0x88, 0xF9, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0x79, 0x88, 0xF9, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF8, 0xFF, 0xFF, 0x98, 0xFF, 0xFF, 0x8F, 0xF9, 0xFF, 0x8F, 0xFF, 0xFF,
    0x8F, 0xFF, 0xFF, 0xF8, 0xFF, 0x98, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0x8F, 0xFF, 0xFF,
    0xFF, 0x8F, 0xFF, 0x8F, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0x99, 0xFF, 0xCF, 0xF8, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x7F, 0x87, 0x87, 0x66, 0x68, 0x87, 0x77, 0x77, 0x68, 0xFF, 0x57, 0xFF,
    0x88, 0xFF, 0x88, 0x88, 0x8F, 0x88, 0xFF, 0xFF, 0xF8, 0x6F, 0xF7, 0x78,
    0xF8, 0x8F, 0x87, 0x78, 0x87, 0xFF, 0xF7, 0x87, 0xF7, 0xF8, 0x7F, 0xF8,
    0x88, 0x88, 0x87, 0x88, 0x8F, 0x87, 0xF8, 0x88, 0xF7, 0xF7, 0xFF, 0x8F,
    0x88, 0x7F, 0x8F, 0xF8, 0xF7, 0x8F, 0x8F, 0xF7, 0x77, 0xF7, 0x68, 0x8F,
    0x8F, 0xFF, 0xF7, 0x69, 0x8F, 0x88, 0x76, 0x78, 0x6F, 0x77, 0x6F, 0xFF,
    0x7F, 0x88, 0xF8, 0x8F, 0xF7, 0x87, 0x88, 0xF7, 0x7F, 0xF8, 0x8F, 0x77,
    0x68, 0x87, 0xF7, 0x86, 0x87, 0x67, 0x67, 0x7F, 0x78, 0xF8, 0x77, 0x77,
    0x88, 0x67, 0xF7, 0x76, 0x88, 0x78, 0x77, 0xFF, 0x8F, 0x7F, 0x88, 0x87,
    0x67, 0x67, 0x77, 0x77, 0x78, 0x8F, 0x7F, 0x77, 0x7F, 0x87, 0x76, 0x68,
    0x87, 0x77, 0x67, 0x7F, 0x7E, 0xE8, 0xCB, 0x88, 0x7F, 0xF7, 0x77, 0x87,
    0x6F, 0x8F, 0x87, 0x7F, 0x68, 0x88, 0xF7, 0x88, 0xF7, 0xF6, 0x87, 0xF8,
    0x87, 0xFF, 0xF7, 0x88, 0xF8, 0x8F, 0x8F, 0xF7, 0x88, 0x7F, 0xFF, 0x8F,
    0xFF, 0x77, 0xF8, 0x88, 0x78, 0x8F, 0xF7, 0x78, 0x77, 0x88, 0x8F, 0xF7,
    0x8F, 0xF8, 0xFF, 0xF8, 0x8F, 0x88, 0x78, 0x77, 0x7F, 0xF8, 0x78, 0xF8,
    0x88, 0x88, 0x7F, 0x8F, 0x7F, 0x8F, 0xA7, 0x78, 0x7F, 0xFF, 0xFF, 0x87,
    0x8F, 0x78, 0x87, 0x8F, 0x8F, 0x87, 0x8F, 0x77, 0xF8, 0xF7, 0x88, 0x8F,
    0x8F, 0xFF, 0xF8, 0x87, 0x7F, 0xF8, 0x8F, 0x87, 0x8F, 0x87, 0x78, 0x7F,
    0xF7, 0x77, 0x78, 0xF8, 0x70, 0x00, 0x00, 0x00,
  },
  {
    0x57, 0x78, 0x66, 0x77, 0x66, 0x76, 0x77, 0x76, 0x87, 0x79, 0x68, 0xAD,
    0x98, 0x89, 0x98, 0xDA, 0xB9, 0x99, 0x99, 0x9D, 0x98, 0x79, 0xAA, 0x89,
    0x98, 0x88, 0x88, 0x98, 0xAA, 0x88, 0x9A, 0x87, 0x89, 0xA9, 0x99, 0x89,
    0x98, 0x98, 0x99, 0x89, 0xA9, 0x99, 0x7A, 0x88, 0x79, 0x98, 0x88, 0x87,
    0x87, 0x98, 0x88, 0x9A, 0x76, 0x98, 0x77, 0x88, 0x87, 0x97, 0x88, 0x98,
    0x98, 0x99, 0x88, 0x79, 0x89, 0x99, 0x78, 0x87, 0x88, 0x88, 0x89, 0xA9,
    0x98, 0x87, 0x99, 0x87, 0x78, 0x78, 0x87, 0x87, 0x87, 0x97, 0x99, 0x97,
    0x79, 0x98, 0x98, 0x78, 0x87, 0x98, 0x87, 0x78, 0x88, 0x9A, 0x76, 0x99,
    0x77, 0x78, 0x78, 0x77, 0x87, 0x78, 0x88, 0x99, 0xA7, 0x79, 0x88, 0x89,
    0x87, 0x77, 0x87, 0x88, 0x78, 0x88, 0x89, 0x77, 0x88, 0x97, 0x88, 0x87,
    0x87, 0x67, 0x88, 0x89, 0x89, 0x88, 0x79, 0x89, 0x88, 0x78, 0x87, 0x77,
    0x77, 0x78, 0x89, 0x8A, 0x76, 0x89, 0x97, 0x77, 0x97, 0x87, 0x77, 0x99,
    0x89, 0x99, 0x96, 0x6A, 0xA8, 0x88, 0x88, 0x88, 0x89, 0x87, 0x88, 0x88,
    0x99, 0x87, 0x9A, 0xA8, 0x88, 0x98, 0x78, 0x88, 0x88, 0x88, 0x99, 0x98,
    0x79, 0x99, 0x88, 0x88, 0x98, 0x88, 0x87, 0x88, 0x88, 0xA9, 0x78, 0xAA,
    0x98, 0x98, 0xA8, 0x88, 0x88, 0x88, 0x88, 0x88, 0xA7, 0x8A, 0x98, 0x89,
    0x8A, 0x88, 0x88, 0x9A, 0x89, 0x89, 0x99, 0x78, 0xA9, 0x99, 0xD8, 0x89,
    0x98, 0x8A, 0x89, 0x98, 0xAA, 0x87, 0x69, 0x88, 0x87, 0x87, 0x78, 0x77,
    0x67, 0x87, 0x77, 0x79, 0x50, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x85, 0x68, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xF5, 0x12, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x61, 0x15, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
    0x65, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xAF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xBB, 0xFF, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFB,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0x99, 0xBF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x97, 0x66, 0x88, 0xBF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFB, 0xB7, 0x53, 0x45, 0x7A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xF9, 0x63, 0x22, 0x46, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x96, 0x42, 0x24, 0x79, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0x85,
    0x44, 0x57, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x86, 0x67,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xF9, 0x99, 0xBF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xBB, 0xBF, 0xFD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0x5F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xF6, 0x12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xF3, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
    0xBC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xE5, 0xEF, 0xFF, 0xFF, 0x3F, 0xFF,
    0xEE, 0xEE, 0xE5, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x5E,
    0x5E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xF4, 0x5F, 0x5F, 0xFF, 0xF5,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x54, 0x55, 0x5F, 0x5F, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x5F, 0x4F, 0xFF, 0x54, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xEE, 0xEE, 0x4E, 0xE5, 0xE6, 0xEE, 0x5E, 0xEE, 0xEE, 0xEE, 0xEE, 0xE5,
    0xE5, 0xE5, 0xEE, 0x5E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x5E,
    0xEE, 0x44, 0xEE, 0xEE, 0xEE, 0xEE, 0x5E, 0xEF, 0xFF, 0xF5, 0x45, 0x3F,
    0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0xFF, 0xFF, 0xFF, 0x4F, 0x4F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0x5F, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0xFF, 0x5F, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF,
    0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xFF, 0xFE, 0xFF, 0xFE, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xAF, 0x5F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFA, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF,
    0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0x99, 0x9B, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA7, 0x67, 0x7F, 0xAB, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xA7, 0x54, 0x45, 0x79, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x64, 0x22, 0x47, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xA6, 0x42, 0x23, 0x69, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x75,
    0x43, 0x57, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x77, 0x67,
    0x9A, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xF9, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xBA, 0xAA, 0xAF, 0x5F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x99, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFC, 0x65, 0x56, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF,
    0xFF, 0xFF, 0x94, 0x12, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF9, 0x52, 0x14, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x97,
    0x54, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA,
    0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFA, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x9F, 0xFF, 0xBF, 0xFB, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAF, 0xFF, 0xA9, 0xAA, 0xFF, 0x5F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xAF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F,
    0xAF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFA, 0xFF, 0xAF, 0xFF, 0xAF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0xA7, 0x67, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xD7, 0x53, 0x45, 0x7A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFA, 0x64, 0x22, 0x47, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xF9,
    0x97, 0x42, 0x24, 0x68, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x76,
    0x44, 0x58, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x76, 0x67,
    0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xA9, 0xAF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCA, 0xAF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFA, 0xFA, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4F, 0xA9, 0xAF, 0xFF, 0xFA, 0x9F,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x5F, 0xEF, 0x56, 0x6F, 0xF6, 0x66, 0xEE, 0xEF, 0x6F, 0xFF, 0x56, 0xE6,
    0xE6, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEE, 0xE6, 0xEE,
    0xEE, 0xEE, 0xE6, 0xEE, 0xEE, 0xEE, 0xEE, 0xEF, 0xFF, 0xFF, 0x6F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xEE, 0xEE, 0xE6, 0xEE, 0xEE, 0x6E,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x6E, 0x4E, 0x6E, 0xEE, 0xEE, 0xEE,
    0xE6, 0xEE, 0xEE, 0xEF, 0xF6, 0xF5, 0x6F, 0x56, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xF5, 0xFF, 0xFF, 0xFF, 0xF4, 0x6F, 0x6F, 0xFF, 0xFF, 0xFF, 0xFE,
    0xEE, 0xE5, 0xE6, 0x66, 0x65, 0x6E, 0xE5, 0xEE, 0xE6, 0xEE, 0xEE, 0xEE,
    0xEE, 0xE5, 0x56, 0x45, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xE6, 0xE6, 0x65, 0x65, 0xEE, 0xEE, 0xEE, 0xE6, 0xEE, 0xEE, 0xE6, 0x66,
    0x6E, 0x6E, 0xEE, 0xEE, 0xE6, 0xEE, 0x6E, 0xEF, 0xF6, 0xF6, 0xFF, 0x56,
    0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x6F,
    0x66, 0xF5, 0xF6, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xF5, 0xF6, 0xFF, 0x6F, 0xFE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE6, 0xEE, 0xEE, 0xFE, 0x6E, 0xFE,
    0xFF, 0xFE, 0xFF, 0x6E, 0xF6, 0xFE, 0xFF, 0x66, 0xFF, 0xFE, 0xFF, 0xFE,
    0xEF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x5F, 0xFF, 0xFE, 0xFF, 0xFF, 0x5F, 0xFF, 0x65, 0x6F, 0xF6, 0xFE,
    0x66, 0xFE, 0x66, 0x5E, 0x50, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xA8, 0xFF, 0xFF, 0xF7, 0xFF, 0x3F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFE, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x76, 0x77, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x86, 0x54, 0x45, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xF9, 0x64, 0x22, 0x48, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF6, 0x42, 0x24, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xF5,
    0x44, 0x5B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xF6,
    0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0x7F, 0x8F,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xEE, 0xEE, 0xEE, 0xDE, 0xEE, 0xEE, 0xED, 0xD5, 0xEE, 0xEE, 0x3E, 0xEE,
    0xEE, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xE4, 0x21, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xDD,
    0xDD, 0xD1, 0x1D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xED, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFE, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x75, 0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xF4, 0x12, 0x47, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x42, 0x14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x54, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFC, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x67, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xF6, 0x44, 0x45, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xF6, 0x54, 0x22, 0x46, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF5, 0x42, 0x34, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x75,
    0x43, 0x4F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x56,
    0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  },
  {
    0xEE, 0xEE, 0xEE, 0xDE, 0xEE, 0xEE, 0xED, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0x53, 0x4E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xE5, 0x12, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0xDD, 0xDD, 0xDD,
    0xDD, 0xD2, 0x24, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xD3, 0x3D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x3E, 0xE5, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xED, 0xE0, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
  {
    0x88, 0x88, 0x88, 0x78, 0x88, 0x88, 0x87, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00,
  },
 },
};

#endif /* AVCODEC_RALFDATA_H */
