/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.gnu.pilotlink.AddressRecord;
import org.gnu.pilotlink.PilotLink;
import org.gnu.pilotlink.PilotLinkException;
import org.gnu.pilotlink.Record;
import org.gnu.pilotlink.SysInfo;
import org.gnu.pilotlink.User;

public class adrtest {
    public static void main(String[] stringArray) {
        Object object;
        test test2 = new test();
        JFrame jFrame = new JFrame("Progress");
        jFrame.getContentPane().setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Reading in");
        jFrame.getContentPane().add((Component)jLabel, "North");
        JProgressBar jProgressBar = new JProgressBar(0, 100);
        jFrame.getContentPane().add((Component)jProgressBar, "Center");
        jFrame.setSize(300, 50);
        jFrame.setVisible(true);
        String string = stringArray.length == 0 ? "/dev/usb/tts/1" : stringArray[0];
        File file = new File(string);
        System.out.println("looking for file " + string);
        if (!file.exists()) {
            System.out.println("File does not exist... USB? Waiting for port to appear");
            while (!file.exists()) {
                System.out.print(".");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        PilotLink pilotLink = null;
        try {
            pilotLink = new PilotLink(string);
            if (!pilotLink.isConnected()) {
                System.out.println("Something went wrong. Check output!");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            object = pilotLink.getUserInfo();
            System.out.println("User: " + ((User)object).getName());
            System.out.println("Last Synchronization Date: " + ((User)object).getLastSyncDate());
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        System.out.println("GEtting App...");
        pilotLink.getAppInfoBlock("AddressDB");
        try {
            object = pilotLink.getSysInfo();
            System.out.println("Product ID: '" + ((SysInfo)object).getProdID() + "'");
            System.out.println("Rom Version: " + ((SysInfo)object).getRomVersion());
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        try {
            System.out.println("Opening DatebookDB");
            int n = pilotLink.openDB("AddressDB");
            System.out.println("addresses opened!");
            Record record = pilotLink.getRecordByIndex(n, 0);
            jProgressBar.setMaximum(pilotLink.getRecordCount(n));
            for (int i = 0; i < pilotLink.getRecordCount(n); ++i) {
                record = pilotLink.getRecordByIndex(n, i);
                jProgressBar.setValue(i);
                if (record == null) {
                    System.out.println("Fehler beim einlesen...");
                    break;
                }
                if (record.getBuffer() == null || record.getBuffer().length == 0) {
                    System.out.println("0-sized record? Deleting...");
                    pilotLink.deleteRecordById(n, record.getId());
                }
                AddressRecord addressRecord = new AddressRecord(record);
                System.out.println("Name: " + addressRecord.getField(0) + " " + addressRecord.getField(1) + " " + addressRecord.getField(2));
                if (!addressRecord.isDeleted()) continue;
                System.out.println("IS DELETED!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            pilotLink.endSync();
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        pilotLink.close();
        jFrame.dispose();
        System.exit(0);
    }
}

