//Auto-generated by kalyptus. DO NOT EDIT.
namespace Phonon {
    using Phonon;
    using System;
    using Qyoto;
    /// <remarks> \class MediaController mediacontroller.h Phonon/MediaController
    ///  \brief Controls optional features of a media file/device like title, chapter, angle.
    ///  \ingroup Playback
    ///  \author Matthias Kretz <kretz@kde.org>
    ///   See <see cref="IMediaControllerSignals"></see> for signals emitted by MediaController
    /// </remarks>        <short>   \class MediaController mediacontroller.</short>
    [SmokeClass("Phonon::MediaController")]
    public class MediaController : QObject, IDisposable {
        protected MediaController(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(MediaController), this);
        }
        public enum Feature {
            Angles = 1,
            Chapters = 2,
            Titles = 4,
        }
        // Phonon::ObjectDescription<Phonon::AudioChannelType> currentAudioChannel(); >>>> NOT CONVERTED
        // Phonon::ObjectDescription<Phonon::SubtitleType> currentSubtitle(); >>>> NOT CONVERTED
        // QList<Phonon::ObjectDescription<Phonon::AudioChannelType> > availableAudioChannels(); >>>> NOT CONVERTED
        // QList<Phonon::ObjectDescription<Phonon::SubtitleType> > availableSubtitles(); >>>> NOT CONVERTED
        // void setCurrentAudioChannel(const Phonon::ObjectDescription<Phonon::AudioChannelType>& arg1); >>>> NOT CONVERTED
        // void setCurrentSubtitle(const Phonon::ObjectDescription<Phonon::SubtitleType>& arg1); >>>> NOT CONVERTED
        public MediaController(Phonon.MediaObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MediaController#", "MediaController(Phonon::MediaObject*)", typeof(void), typeof(Phonon.MediaObject), parent);
        }
        public uint SupportedFeatures() {
            return (uint) interceptor.Invoke("supportedFeatures", "supportedFeatures() const", typeof(uint));
        }
        public int AvailableAngles() {
            return (int) interceptor.Invoke("availableAngles", "availableAngles() const", typeof(int));
        }
        public int CurrentAngle() {
            return (int) interceptor.Invoke("currentAngle", "currentAngle() const", typeof(int));
        }
        public int AvailableChapters() {
            return (int) interceptor.Invoke("availableChapters", "availableChapters() const", typeof(int));
        }
        public int CurrentChapter() {
            return (int) interceptor.Invoke("currentChapter", "currentChapter() const", typeof(int));
        }
        public int AvailableTitles() {
            return (int) interceptor.Invoke("availableTitles", "availableTitles() const", typeof(int));
        }
        public int CurrentTitle() {
            return (int) interceptor.Invoke("currentTitle", "currentTitle() const", typeof(int));
        }
        public bool AutoplayTitles() {
            return (bool) interceptor.Invoke("autoplayTitles", "autoplayTitles() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the selected audio stream.
        ///  \see availableAudioChannels
        ///  \see setCurrentAudioChannel
        ///          </remarks>        <short>    Returns the selected audio stream.</short>
        /// <remarks>
        ///  Returns the selected subtitle stream.
        ///  \see availableSubtitles
        ///  \see setCurrentSubtitle
        ///          </remarks>        <short>    Returns the selected subtitle stream.</short>
        /// <remarks>
        ///  Returns the audio streams that can be selected by the user. The
        ///  strings can directly be used in the user interface.
        ///  \see selectedAudioChannel
        ///  \see setCurrentAudioChannel
        ///          </remarks>        <short>    Returns the audio streams that can be selected by the user.</short>
        /// <remarks>
        ///  Returns the subtitle streams that can be selected by the user. The
        ///  strings can directly be used in the user interface.
        ///  \see selectedSubtitle
        ///  \see setCurrentSubtitle
        ///          </remarks>        <short>    Returns the subtitle streams that can be selected by the user.</short>
        /// <remarks>
        ///  Selects an audio stream from the media.
        ///  Some media formats allow multiple audio streams to be stored in
        ///  the same file. Normally only one should be played back.
        ///  \param stream Description of an audio stream
        ///  \see availableAudioChannels()
        ///  \see currentAudioChannel()
        ///          </remarks>        <short>    Selects an audio stream from the media.</short>
        /// <remarks>
        ///  Selects a subtitle stream from the media.
        ///  Some media formats allow multiple subtitle streams to be stored in
        ///  the same file. Normally only one should be displayed.
        ///  \param stream description of a subtitle stream
        ///  \see availableSubtitles()
        ///  \see currentSubtitle()
        ///          </remarks>        <short>    Selects a subtitle stream from the media.</short>
        [Q_SLOT("void setCurrentAngle(int)")]
        public void SetCurrentAngle(int angleNumber) {
            interceptor.Invoke("setCurrentAngle$", "setCurrentAngle(int)", typeof(void), typeof(int), angleNumber);
        }
        [Q_SLOT("void setCurrentChapter(int)")]
        public void SetCurrentChapter(int chapterNumber) {
            interceptor.Invoke("setCurrentChapter$", "setCurrentChapter(int)", typeof(void), typeof(int), chapterNumber);
        }
        /// <remarks>
        ///  Skips to the given title <pre>titleNumber</pre>.
        ///  If it was playing before the title change it will start playback on the new title if
        ///  autoplayTitles is enabled.
        ///          </remarks>        <short>    Skips to the given title \p titleNumber.</short>
        [Q_SLOT("void setCurrentTitle(int)")]
        public void SetCurrentTitle(int titleNumber) {
            interceptor.Invoke("setCurrentTitle$", "setCurrentTitle(int)", typeof(void), typeof(int), titleNumber);
        }
        [Q_SLOT("void setAutoplayTitles(bool)")]
        public void SetAutoplayTitles(bool arg1) {
            interceptor.Invoke("setAutoplayTitles$", "setAutoplayTitles(bool)", typeof(void), typeof(bool), arg1);
        }
        /// <remarks>
        ///  Skips to the next title.
        ///  If it was playing before the title change it will start playback on the next title if
        ///  autoplayTitles is enabled.
        ///          </remarks>        <short>    Skips to the next title.</short>
        [Q_SLOT("void nextTitle()")]
        public void NextTitle() {
            interceptor.Invoke("nextTitle", "nextTitle()", typeof(void));
        }
        /// <remarks>
        ///  Skips to the previous title.
        ///  If it was playing before the title change it will start playback on the previous title if
        ///  autoplayTitles is enabled.
        ///          </remarks>        <short>    Skips to the previous title.</short>
        [Q_SLOT("void previousTitle()")]
        public void PreviousTitle() {
            interceptor.Invoke("previousTitle", "previousTitle()", typeof(void));
        }
        ~MediaController() {
            interceptor.Invoke("~MediaController", "~MediaController()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~MediaController", "~MediaController()", typeof(void));
        }
        protected new IMediaControllerSignals Emit {
            get { return (IMediaControllerSignals) Q_EMIT; }
        }
    }

    public interface IMediaControllerSignals : IQObjectSignals {
        [Q_SIGNAL("void availableSubtitlesChanged()")]
        void AvailableSubtitlesChanged();
        [Q_SIGNAL("void availableAudioChannelsChanged()")]
        void AvailableAudioChannelsChanged();
        [Q_SIGNAL("void availableAnglesChanged(int)")]
        void AvailableAnglesChanged(int availableAngles);
        [Q_SIGNAL("void angleChanged(int)")]
        void AngleChanged(int angleNumber);
        [Q_SIGNAL("void availableChaptersChanged(int)")]
        void AvailableChaptersChanged(int availableChapters);
        [Q_SIGNAL("void chapterChanged(int)")]
        void ChapterChanged(int chapterNumber);
        [Q_SIGNAL("void availableTitlesChanged(int)")]
        void AvailableTitlesChanged(int availableTitles);
        [Q_SIGNAL("void titleChanged(int)")]
        void TitleChanged(int titleNumber);
    }
}
