#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <stdint.h>

#include <asm/ioctl.h>
#include <linux/types.h>

#include "ioctldefs.h"
#include <linux/atmioc.h>

struct ioctlent {
	const char*	header;
	const char*	name;
	unsigned long	code;
};

struct ioctlent ioctls[] = {
#include "ioctls.h"
};

int nioctls = sizeof(ioctls) / sizeof(ioctls[0]);


int compare(const void* a, const void* b) {
	unsigned long code1 = ((struct ioctlent *) a)->code;
	unsigned long code2 = ((struct ioctlent *) b)->code;
	const char *name1 = ((struct ioctlent *) a)->name;
	const char *name2 = ((struct ioctlent *) b)->name;
	return (code1 > code2) ? 1 : (code1 < code2) ? -1 : strcmp (name1, name2);
}


int main(int argc, char** argv) {
	int i;

#if defined(POWERPC) || defined(__powerpc__)			/* unspeakable kludge */
	for (i = 0; i < nioctls; i++)
		ioctls[i].code &= ~_IOC_DIRMASK;
#endif

	qsort(ioctls, nioctls, sizeof(ioctls[0]), compare);
	puts ("\t/* Generated by ioctlsort */");
	for (i = 0; i < nioctls; i++)
		if (i == 0 || ioctls[i].code != ioctls[i-1].code ||
		    strcmp (ioctls[i].name, ioctls[i-1].name))
			printf("\t{\"%s\",\t\"%s\",\t%#lx},\n",
				ioctls[i].header, ioctls[i].name, ioctls[i].code);

	return 0;
}
