/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.openrdf.sail.rdbms.schema.RdbmsTable;

public class Batch {
    public static Batch CLOSED_SIGNAL = new Batch();
    private RdbmsTable temporary;
    private PreparedStatement insertBatch;
    private PreparedStatement insertSelect;
    private int maxBatchSize;
    private int batchCount;

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int batchSize) {
        this.maxBatchSize = batchSize;
    }

    public void setTemporary(RdbmsTable temporary) {
        assert (temporary != null);
        this.temporary = temporary;
    }

    public void setBatchStatement(PreparedStatement insert) {
        assert (insert != null);
        this.insertBatch = insert;
    }

    public void setInsertStatement(PreparedStatement insert) {
        assert (insert != null);
        this.insertSelect = insert;
    }

    public int size() {
        return this.batchCount;
    }

    public boolean isFull() {
        return this.batchCount >= this.getMaxBatchSize();
    }

    public boolean isReady() {
        return true;
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.insertBatch.setObject(parameterIndex, x);
    }

    public void addBatch() throws SQLException {
        this.insertBatch.addBatch();
        ++this.batchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush() throws SQLException {
        if (this.insertBatch == null) {
            return -1;
        }
        try {
            int count;
            if (this.temporary == null) {
                int[] results = this.insertBatch.executeBatch();
                count = results.length;
            } else {
                RdbmsTable rdbmsTable = this.temporary;
                synchronized (rdbmsTable) {
                    this.insertBatch.executeBatch();
                    count = this.insertSelect.executeUpdate();
                    this.temporary.clear();
                }
            }
            int n = count;
            return n;
        }
        finally {
            this.insertBatch.close();
            this.insertBatch = null;
        }
    }
}

