/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.text;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtil {
    private static final DateFormat timeFormat = new SimpleDateFormat("HH:mm");
    private static final long TWENTY_FOUR_HOURS = 86400000L;
    private static long today0_00h = 0L;
    private static long yesterday0_00h = 0L;
    private static long halfyearago0_00h = 0L;
    private static long tomorrow0_00h = 0L;
    private static long dayaftertomorrow0_00h = 0L;
    private static long halfyearfromnow0_00h = 0L;

    private static void _initTimeVariables() {
        if (tomorrow0_00h == 0L || System.currentTimeMillis() >= tomorrow0_00h) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(14, 0);
            today0_00h = calendar.getTimeInMillis();
            yesterday0_00h = today0_00h - 86400000L;
            halfyearago0_00h = today0_00h - 15811200000L;
            tomorrow0_00h = today0_00h + 86400000L;
            dayaftertomorrow0_00h = tomorrow0_00h + 86400000L;
            halfyearfromnow0_00h = today0_00h + 15811200000L;
        }
    }

    public static String getNiceDateTimeString(long date) {
        return DateTimeUtil.getNiceDateTimeString(new Date(date));
    }

    public static String getNiceDateTimeString(Date date) {
        DateTimeUtil._initTimeVariables();
        long time = date.getTime();
        if (time >= today0_00h && time < tomorrow0_00h) {
            return timeFormat.format(date);
        }
        if (time >= yesterday0_00h && time < today0_00h) {
            return "Yesterday " + timeFormat.format(date);
        }
        if (time >= tomorrow0_00h && time < dayaftertomorrow0_00h) {
            return "Tomorrow " + timeFormat.format(date);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        String monthString = null;
        switch (calendar.get(2)) {
            case 0: {
                monthString = "Jan";
                break;
            }
            case 1: {
                monthString = "Feb";
                break;
            }
            case 2: {
                monthString = "Mar";
                break;
            }
            case 3: {
                monthString = "Apr";
                break;
            }
            case 4: {
                monthString = "May";
                break;
            }
            case 5: {
                monthString = "Jun";
                break;
            }
            case 6: {
                monthString = "Jul";
                break;
            }
            case 7: {
                monthString = "Aug";
                break;
            }
            case 8: {
                monthString = "Sep";
                break;
            }
            case 9: {
                monthString = "Oct";
                break;
            }
            case 10: {
                monthString = "Nov";
                break;
            }
            case 11: {
                monthString = "Dec";
                break;
            }
            default: {
                throw new IllegalStateException("illegal month: " + calendar.get(2));
            }
        }
        StringBuilder buffer = new StringBuilder(14);
        buffer.append(monthString);
        buffer.append(' ');
        buffer.append(calendar.get(5));
        if (time >= halfyearago0_00h && time <= halfyearfromnow0_00h) {
            buffer.append("  ");
            buffer.append(timeFormat.format(date));
        } else {
            buffer.append(", ");
            buffer.append(calendar.get(1));
        }
        return buffer.toString();
    }

    public static String getNiceDurationString(long duration) {
        if (duration < 1000L) {
            return String.valueOf(duration) + " ms";
        }
        if (duration < 60000L) {
            int seconds = (int)Math.round((double)duration / 1000.0);
            if (seconds == 1) {
                return "1 second";
            }
            return seconds + " seconds";
        }
        if (duration < 3600000L) {
            int minutes = (int)Math.round((double)duration / 60000.0);
            if (minutes == 1) {
                return "1 minute";
            }
            return minutes + " minutes";
        }
        if (duration < 86400000L) {
            int hours = (int)Math.round((double)duration / 3600000.0);
            if (hours == 1) {
                return "1 hour";
            }
            return hours + " hours";
        }
        int days = (int)Math.round((double)duration / 8.64E7);
        if (days == 1) {
            return "1 day";
        }
        return days + " days";
    }
}

