.\" Man page for man (and the former manpath)
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\" Slovenski prevod Primo Peterlin <primoz.peterlin@biofiz.mf.uni-lj.si>,
.\" julij 1996.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.\" Many changes - aeb
.\"
.TH man 1 "2. september 1995"
.LO 1
.SH IME
man \- oblikovanje in prikaz strani on-line prironika
.br
manpath \- prikaz poti do imenikov, kjer man ie prironike
.SH SINTAKSA
.\" man [\-acdfhkKtwW] [\-m system] [\-p string] [\-C config_file] [\-M path]
.\" [\-P pager] [\-S section_list] [section] name ...
man [\-adfhkKtwW] [\-m sistem] [\-p niz] [\-C nastavitvena_datoteka] 
[\-M pot] [\-P paginator] [\-S seznam_poglavij] [poglavje] ime ...
.SH OPIS
.B man
oblikuje in prikae strani on-line prironika.  Ta izvedba pozna
spremenljivki
.B MANPATH
in
.BR (MAN)PAGER ,
tako da si lahko pripravite
lasten nabor osebnih strani prironika in izberete va najljubi
program za prikaz oblikovanih strani.
e je doloeno 
.I poglavje,
.B man
ie samo v tem poglavju prironika.
Iz ukazne vrstice ali prek spremenljivk okolja lahko doloite 
tudi vrsti red poglavij, ki jih 
.B man
preie, ter katere predprocesorje se pred prikazom uporabijo na 
izvornem besedilu.
e
.I ime
vsebuje znak /, se najprej preveri, e obstaja datoteka s tem
imenom.  Ukaz
.B "man ./foo.5"
ali celo
.B "man /cd/foo/bar.1.gz\fR.\fP"
sta zato povsem veljavna.
.SH IZBIRE
.TP
.B \-\^C " nastavitvena_datoteka"
Doloimo nastavitveno datoteko man.conf, ki jo elimo
uporabljati; privzeta izbira je
@man_config_file@. (glejte man.conf(5).)
.TP
.B \-\^M " pot"
Doloimo seznam imenikov, v katerih se ie za stranmi
prironika.  e izbira ni podana, se uporabi spremenljivka okolja
.B MANPATH
e tudi spremenljivke s tem imenom ni, se uporabi privzeta izbira
iz nastavitvene datoteke @man_config_file@. 
Prazen niz v MANPATH implicira privzet seznam imenikov.
.TP
.B \-\^P " paginator"
Doloimo paginator.  Ta izbira ima prednost pred spremenljivko
okolja
.B MANPAGER,
ki ima nadalje prednost pred spremenljivko okolja 
.B PAGER.
Privzeta izbira za paginator je 
.BR @pager@ .
.TP
.B \-\^S " seznam_poglavij"
Seznam_poglavij je z dvopiji loen seznam poglavij prironika, 
v katerem se ie geslo.  Ta izbira ima prednost pred
spremenljivko okolja
.B MANSECT.
.TP
.B \-\^a
Sam po sebi man prikae prvo stran, ki ustreza imenu 
.B name.
S to izbiro zahtevamo, da prikae vse strani, ki ustrezajo
pogoju, ne le prve.
.TP
.B \-\^c
Izrecno zahtevamo ponovno oblikovanje strani, etudi e
oblikovana stran obstaja.  Izbira je lahko smiselna, e je bila
stran oblikovana za drugano irino zaslona.
.TP
.B \-\^d
Ne prikai oblikovane strani, ampak le "debugging" informacije.
.TP
.B \-\^D
Prikai tako oblikovano stran kot tudi "debugging" informacije.
.TP
.B \-\^f
Isto kot
.B whatis.
.TP
.B \-\^h
Izpii eno vrstico navodila in konaj.
.TP
.B \-\^k
Isto kot
.B apropos.
.TP
.B \-\^K
Preii *vse* strani prironika za dani niz.  Pozor: to zelo
verjetno vzame kar nekaj asa!  Hitreje gre, e iskanje omejimo
na poglavje.
(Kot grob primer: na avtorjevem raunalniku traja iskanje prek
500 strani prironika priblino minuto.)
.TP
.B \-\^m " sistem"
Doloimo alternativni nabor strani prironika na podanem
sistemu.
.TP
.B \-\^p " niz"
Doloimo zaporedje predprocesorjev, ki se poenejo pred nroff ali
troff.  
Nekateri od predprocesorjev, in njihove enorkovne okrajave:
eqn (e), grap (g), pic (p), tbl (t), vgrind (v), refer (r).
Ni nujno, da so na vaem sistemu vsi nateti
predprocesorji na voljo.
Ta izbira ima prednost pred spremenljivko okolja
.B MANROFFSEQ.
.TP
.B \-\^t
Uporabi
.B @troff@
za oblikovanje strani prironika in usmeri izhod na standardni
izhod
.B stdout.
Lahko, da je izhod iz
.B @troff@
pred tiskom potrebno obdelati s e kaknim filtrom.
.TP
.B \-\^w \fRali\fP \-\-path
Ne prikai oblikovanih strani prironika, ampak pot do datotek,
ki bi bile oblikovane in prikazane.  e je izbira brez argumenta,
prikai pot do imenikov, v katerih 
.B man
ie strani prironika.  e je
.B manpath
povezava na man, tedaj je "manpath" enakovredno "man --path".
.TP
.B \-\^W
Kot \-\^w, le da prikae po eno ime datoteke v vrstici in brez
dodatnih informacij.
To je lahko uporabno v ukazih ukazne lupine, kot npr.
.ft CW
man -aW man | xargs ls -l
.ft

.SH "OBLIKOVANE STRANI"
Man poskusi shraniti oblikovane strani in tako prihraniti as, 
potreben za oblikovanje, ko se stran naslednji rabi.
Tradicionalno se oblikovane strani iz imenikov DIR/manX
shranjujejo v imenike DIR/catX, drugaen dogovor glede preslikave
med izvornimi in oblikovanimi razliicami pa je mono doloiti v
@man_config_file@.
Oblikovane strani se ne shranijo, e ustrezni imenik ne obstaja.
.TP
Program man je mono pripisati (SUID) uporabniku z imenom man.  V
tem primeru, kadar je imenik z oblikovanimi stranmi v lasti man,
nain zaite pa 0755 (dovoljeno pisanje samo lastniku -- man),
oblikovane datoteke pa so zaitene z 0644 ali 0444 (dovoljeno
pisanje samo lastniku, ali pa sploh prepovedano pisanje), nihe
od uporabnikov ne more ne more spreminjati oblikovanih strani ali
puati svojih datotek v imeniku z oblikovanimi stranmi.  e man
ni v lasti (SUID) uporabnika man, mora biti imenik z oblikovanimi
stranmi dovoljen za pisanje (0777), e naj bo tam vsem uporabnikom
dovoljeno puati oblikovane strani.
.TP
Izbira \-\^c zahteva ponovno oblikovanje strani, etudi recentna
oblikovana stran e obstaja.


.SH SPREMENLJIVKE OKOLJA
.TP
.B MANPATH
e nastavimo spremenljivko
.B MANPATH,
se njena vrednost uporabi za pot do strani prironika.
.TP
.B MANROFFSEQ
e nastavimo spremenljivko
.B MANROFFSEQ,
z njeno vrednostjo doloimo zaporedje predprocesorjev, ki
obdelajo stran pred nroff ali troff.  Privzeta izbira je
tabelarni predprocesor tbl.
.TP
.B MANSECT
e nastavimo spremenljivko
.B MANSECT,
njena vrednost doloa poglavja v prironiku, v katerih man ie
zahtevano stran.
.TP
.B MANWIDTH
e nastavimo spremenljivko
.B MANWIDTH,
njena vrednost doloa irino zaslona, za katero se oblikujejo
strani prironika.  Privzeta izbira je cela irina zaslona.
.TP
.B MANPAGER
e nastavimo spremenljivko
.B MANPAGER,
njena vrednost doloa paginator -- program, ki prikae oblikovano
stran.  e spremenljivka ni nastavljena, se uporabi vrednost
spremenljivke 
.B PAGER.
e tudi ta ni nastavljena, se uporabi privzeta izbira
.B @pager@.
.TP
.B LANG
e nastavimo spremenljivko
.B LANG,
njena vrednost doloa podimenik, v katerem man najprej poskusi
poiskati stran prironika.  Na primer, pri ukazu ,,LANG=dk man 1 foo''
man najprej poskusi poiskati ustrezno stran prironika v
datoteki .../dk/man1/foo.1, e ta ne obstaja, pa v .../man1/foo.1.
Pri tem je ... eden od imenikov, v katerih man ie strani.
.TP
.B "NLSPATH, LC_MESSAGES, LANG"
Spremenljivki
.B NLSPATH
in
.B LC_MESSAGES
(ali
.B LANG
e LC_MESSAGES ne obstaja)
doloajo katalog s sporoili programa.
(Angleka sporoila so izjema, ker so e vkljuena v program,
tako da zanje ne potrebujemo posebnega kataloga.)
Programi kot npr. col(1), ki ga klie man, prav tako uporabljajo
lokalizacijske spremenljivke (npr. LC_CTYPE).
.TP
.B PATH
.B PATH
se uporablja za sestavljanje privzete poti, v katerih man ie
strani prironika.
.TP
.B SYSTEM
.B SYSTEM
se uporablja za doloitev imena alternativnega sistema (z izbiro
.B \-m).
.SH "GLEJTE TUDI"
apropos(1), whatis(1), less(1), groff(1).
.SH NAPAKE
The
.B \-t
deluje samo, kadar je na voljo troff ali drug enakovreden program.
.br
e namesto pomiljajev vidite utripajoe \e255 or <AD>, dodajte
med spremenljivke okolja `LESSCHARSET=latin1'.
