/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_ntsvcs.h"

static enum ndr_err_code ndr_push_PNP_HwProfInfo(struct ndr_push *ndr, int ndr_flags, const struct PNP_HwProfInfo *r)
{
	uint32_t cntr_friendly_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->profile_handle));
		for (cntr_friendly_name_0 = 0; cntr_friendly_name_0 < 80; cntr_friendly_name_0++) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->friendly_name[cntr_friendly_name_0]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_HwProfInfo(struct ndr_pull *ndr, int ndr_flags, struct PNP_HwProfInfo *r)
{
	uint32_t cntr_friendly_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->profile_handle));
		for (cntr_friendly_name_0 = 0; cntr_friendly_name_0 < 80; cntr_friendly_name_0++) {
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->friendly_name[cntr_friendly_name_0]));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_HwProfInfo(struct ndr_print *ndr, const char *name, const struct PNP_HwProfInfo *r)
{
	uint32_t cntr_friendly_name_0;
	ndr_print_struct(ndr, name, "PNP_HwProfInfo");
	ndr->depth++;
	ndr_print_uint32(ndr, "profile_handle", r->profile_handle);
	ndr->print(ndr, "%s: ARRAY(%d)", "friendly_name", (int)80);
	ndr->depth++;
	for (cntr_friendly_name_0=0;cntr_friendly_name_0<80;cntr_friendly_name_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_friendly_name_0) != -1) {
			ndr_print_uint16(ndr, "friendly_name", r->friendly_name[cntr_friendly_name_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_Disconnect(struct ndr_push *ndr, int flags, const struct PNP_Disconnect *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_Disconnect(struct ndr_pull *ndr, int flags, struct PNP_Disconnect *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_Disconnect(struct ndr_print *ndr, const char *name, int flags, const struct PNP_Disconnect *r)
{
	ndr_print_struct(ndr, name, "PNP_Disconnect");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_Disconnect");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_Disconnect");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_Connect(struct ndr_push *ndr, int flags, const struct PNP_Connect *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_Connect(struct ndr_pull *ndr, int flags, struct PNP_Connect *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_Connect(struct ndr_print *ndr, const char *name, int flags, const struct PNP_Connect *r)
{
	ndr_print_struct(ndr, name, "PNP_Connect");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_Connect");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_Connect");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetVersion(struct ndr_push *ndr, int flags, const struct PNP_GetVersion *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.version == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.version));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetVersion(struct ndr_pull *ndr, int flags, struct PNP_GetVersion *r)
{
	TALLOC_CTX *_mem_save_version_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.version);
		ZERO_STRUCTP(r->out.version);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.version);
		}
		_mem_save_version_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.version, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.version));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_version_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetVersion(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetVersion *r)
{
	ndr_print_struct(ndr, name, "PNP_GetVersion");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetVersion");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetVersion");
		ndr->depth++;
		ndr_print_ptr(ndr, "version", r->out.version);
		ndr->depth++;
		ndr_print_uint16(ndr, "version", *r->out.version);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetGlobalState(struct ndr_push *ndr, int flags, const struct PNP_GetGlobalState *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetGlobalState(struct ndr_pull *ndr, int flags, struct PNP_GetGlobalState *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetGlobalState(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetGlobalState *r)
{
	ndr_print_struct(ndr, name, "PNP_GetGlobalState");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetGlobalState");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetGlobalState");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_InitDetection(struct ndr_push *ndr, int flags, const struct PNP_InitDetection *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_InitDetection(struct ndr_pull *ndr, int flags, struct PNP_InitDetection *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_InitDetection(struct ndr_print *ndr, const char *name, int flags, const struct PNP_InitDetection *r)
{
	ndr_print_struct(ndr, name, "PNP_InitDetection");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_InitDetection");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_InitDetection");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_ReportLogOn(struct ndr_push *ndr, int flags, const struct PNP_ReportLogOn *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_ReportLogOn(struct ndr_pull *ndr, int flags, struct PNP_ReportLogOn *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_ReportLogOn(struct ndr_print *ndr, const char *name, int flags, const struct PNP_ReportLogOn *r)
{
	ndr_print_struct(ndr, name, "PNP_ReportLogOn");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_ReportLogOn");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_ReportLogOn");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_ValidateDeviceInstance(struct ndr_push *ndr, int flags, const struct PNP_ValidateDeviceInstance *r)
{
	if (flags & NDR_IN) {
		if (r->in.devicepath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicepath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicepath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.devicepath, ndr_charset_length(r->in.devicepath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_ValidateDeviceInstance(struct ndr_pull *ndr, int flags, struct PNP_ValidateDeviceInstance *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.devicepath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.devicepath));
		if (ndr_get_array_length(ndr, &r->in.devicepath) > ndr_get_array_size(ndr, &r->in.devicepath)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.devicepath), ndr_get_array_length(ndr, &r->in.devicepath));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.devicepath), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.devicepath, ndr_get_array_length(ndr, &r->in.devicepath), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_ValidateDeviceInstance(struct ndr_print *ndr, const char *name, int flags, const struct PNP_ValidateDeviceInstance *r)
{
	ndr_print_struct(ndr, name, "PNP_ValidateDeviceInstance");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_ValidateDeviceInstance");
		ndr->depth++;
		ndr_print_ptr(ndr, "devicepath", r->in.devicepath);
		ndr->depth++;
		ndr_print_string(ndr, "devicepath", r->in.devicepath);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_ValidateDeviceInstance");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetRootDeviceInstance(struct ndr_push *ndr, int flags, const struct PNP_GetRootDeviceInstance *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetRootDeviceInstance(struct ndr_pull *ndr, int flags, struct PNP_GetRootDeviceInstance *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetRootDeviceInstance(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetRootDeviceInstance *r)
{
	ndr_print_struct(ndr, name, "PNP_GetRootDeviceInstance");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetRootDeviceInstance");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetRootDeviceInstance");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetRelatedDeviceInstance(struct ndr_push *ndr, int flags, const struct PNP_GetRelatedDeviceInstance *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetRelatedDeviceInstance(struct ndr_pull *ndr, int flags, struct PNP_GetRelatedDeviceInstance *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetRelatedDeviceInstance(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetRelatedDeviceInstance *r)
{
	ndr_print_struct(ndr, name, "PNP_GetRelatedDeviceInstance");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetRelatedDeviceInstance");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetRelatedDeviceInstance");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_EnumerateSubKeys(struct ndr_push *ndr, int flags, const struct PNP_EnumerateSubKeys *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_EnumerateSubKeys(struct ndr_pull *ndr, int flags, struct PNP_EnumerateSubKeys *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_EnumerateSubKeys(struct ndr_print *ndr, const char *name, int flags, const struct PNP_EnumerateSubKeys *r)
{
	ndr_print_struct(ndr, name, "PNP_EnumerateSubKeys");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_EnumerateSubKeys");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_EnumerateSubKeys");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetDeviceList(struct ndr_push *ndr, int flags, const struct PNP_GetDeviceList *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetDeviceList(struct ndr_pull *ndr, int flags, struct PNP_GetDeviceList *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetDeviceList(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetDeviceList *r)
{
	ndr_print_struct(ndr, name, "PNP_GetDeviceList");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetDeviceList");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetDeviceList");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetDeviceListSize(struct ndr_push *ndr, int flags, const struct PNP_GetDeviceListSize *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.devicename));
		if (r->in.devicename) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicename, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicename, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.devicename, ndr_charset_length(r->in.devicename, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.size));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetDeviceListSize(struct ndr_pull *ndr, int flags, struct PNP_GetDeviceListSize *r)
{
	uint32_t _ptr_devicename;
	TALLOC_CTX *_mem_save_devicename_0;
	TALLOC_CTX *_mem_save_size_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_devicename));
		if (_ptr_devicename) {
			NDR_PULL_ALLOC(ndr, r->in.devicename);
		} else {
			r->in.devicename = NULL;
		}
		if (r->in.devicename) {
			_mem_save_devicename_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.devicename, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.devicename));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.devicename));
			if (ndr_get_array_length(ndr, &r->in.devicename) > ndr_get_array_size(ndr, &r->in.devicename)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.devicename), ndr_get_array_length(ndr, &r->in.devicename));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.devicename), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.devicename, ndr_get_array_length(ndr, &r->in.devicename), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devicename_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.size);
		ZERO_STRUCTP(r->out.size);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.size);
		}
		_mem_save_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_size_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetDeviceListSize(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetDeviceListSize *r)
{
	ndr_print_struct(ndr, name, "PNP_GetDeviceListSize");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetDeviceListSize");
		ndr->depth++;
		ndr_print_ptr(ndr, "devicename", r->in.devicename);
		ndr->depth++;
		if (r->in.devicename) {
			ndr_print_string(ndr, "devicename", r->in.devicename);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetDeviceListSize");
		ndr->depth++;
		ndr_print_ptr(ndr, "size", r->out.size);
		ndr->depth++;
		ndr_print_uint32(ndr, "size", *r->out.size);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetDepth(struct ndr_push *ndr, int flags, const struct PNP_GetDepth *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetDepth(struct ndr_pull *ndr, int flags, struct PNP_GetDepth *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetDepth(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetDepth *r)
{
	ndr_print_struct(ndr, name, "PNP_GetDepth");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetDepth");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetDepth");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetDeviceRegProp(struct ndr_push *ndr, int flags, const struct PNP_GetDeviceRegProp *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetDeviceRegProp(struct ndr_pull *ndr, int flags, struct PNP_GetDeviceRegProp *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetDeviceRegProp(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetDeviceRegProp *r)
{
	ndr_print_struct(ndr, name, "PNP_GetDeviceRegProp");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetDeviceRegProp");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetDeviceRegProp");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_SetDeviceRegProp(struct ndr_push *ndr, int flags, const struct PNP_SetDeviceRegProp *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_SetDeviceRegProp(struct ndr_pull *ndr, int flags, struct PNP_SetDeviceRegProp *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_SetDeviceRegProp(struct ndr_print *ndr, const char *name, int flags, const struct PNP_SetDeviceRegProp *r)
{
	ndr_print_struct(ndr, name, "PNP_SetDeviceRegProp");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_SetDeviceRegProp");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_SetDeviceRegProp");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetClassInstance(struct ndr_push *ndr, int flags, const struct PNP_GetClassInstance *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetClassInstance(struct ndr_pull *ndr, int flags, struct PNP_GetClassInstance *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetClassInstance(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetClassInstance *r)
{
	ndr_print_struct(ndr, name, "PNP_GetClassInstance");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetClassInstance");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetClassInstance");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_CreateKey(struct ndr_push *ndr, int flags, const struct PNP_CreateKey *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_CreateKey(struct ndr_pull *ndr, int flags, struct PNP_CreateKey *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_CreateKey(struct ndr_print *ndr, const char *name, int flags, const struct PNP_CreateKey *r)
{
	ndr_print_struct(ndr, name, "PNP_CreateKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_CreateKey");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_CreateKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_DeleteRegistryKey(struct ndr_push *ndr, int flags, const struct PNP_DeleteRegistryKey *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_DeleteRegistryKey(struct ndr_pull *ndr, int flags, struct PNP_DeleteRegistryKey *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_DeleteRegistryKey(struct ndr_print *ndr, const char *name, int flags, const struct PNP_DeleteRegistryKey *r)
{
	ndr_print_struct(ndr, name, "PNP_DeleteRegistryKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_DeleteRegistryKey");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_DeleteRegistryKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetClassCount(struct ndr_push *ndr, int flags, const struct PNP_GetClassCount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetClassCount(struct ndr_pull *ndr, int flags, struct PNP_GetClassCount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetClassCount(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetClassCount *r)
{
	ndr_print_struct(ndr, name, "PNP_GetClassCount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetClassCount");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetClassCount");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetClassName(struct ndr_push *ndr, int flags, const struct PNP_GetClassName *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetClassName(struct ndr_pull *ndr, int flags, struct PNP_GetClassName *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetClassName(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetClassName *r)
{
	ndr_print_struct(ndr, name, "PNP_GetClassName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetClassName");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetClassName");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_DeleteClassKey(struct ndr_push *ndr, int flags, const struct PNP_DeleteClassKey *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_DeleteClassKey(struct ndr_pull *ndr, int flags, struct PNP_DeleteClassKey *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_DeleteClassKey(struct ndr_print *ndr, const char *name, int flags, const struct PNP_DeleteClassKey *r)
{
	ndr_print_struct(ndr, name, "PNP_DeleteClassKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_DeleteClassKey");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_DeleteClassKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetInterfaceDeviceAlias(struct ndr_push *ndr, int flags, const struct PNP_GetInterfaceDeviceAlias *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetInterfaceDeviceAlias(struct ndr_pull *ndr, int flags, struct PNP_GetInterfaceDeviceAlias *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetInterfaceDeviceAlias(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetInterfaceDeviceAlias *r)
{
	ndr_print_struct(ndr, name, "PNP_GetInterfaceDeviceAlias");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetInterfaceDeviceAlias");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetInterfaceDeviceAlias");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetInterfaceDeviceList(struct ndr_push *ndr, int flags, const struct PNP_GetInterfaceDeviceList *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetInterfaceDeviceList(struct ndr_pull *ndr, int flags, struct PNP_GetInterfaceDeviceList *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetInterfaceDeviceList(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetInterfaceDeviceList *r)
{
	ndr_print_struct(ndr, name, "PNP_GetInterfaceDeviceList");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetInterfaceDeviceList");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetInterfaceDeviceList");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetInterfaceDeviceListSize(struct ndr_push *ndr, int flags, const struct PNP_GetInterfaceDeviceListSize *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetInterfaceDeviceListSize(struct ndr_pull *ndr, int flags, struct PNP_GetInterfaceDeviceListSize *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetInterfaceDeviceListSize(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetInterfaceDeviceListSize *r)
{
	ndr_print_struct(ndr, name, "PNP_GetInterfaceDeviceListSize");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetInterfaceDeviceListSize");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetInterfaceDeviceListSize");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RegisterDeviceClassAssociation(struct ndr_push *ndr, int flags, const struct PNP_RegisterDeviceClassAssociation *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RegisterDeviceClassAssociation(struct ndr_pull *ndr, int flags, struct PNP_RegisterDeviceClassAssociation *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RegisterDeviceClassAssociation(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RegisterDeviceClassAssociation *r)
{
	ndr_print_struct(ndr, name, "PNP_RegisterDeviceClassAssociation");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RegisterDeviceClassAssociation");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RegisterDeviceClassAssociation");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_UnregisterDeviceClassAssociation(struct ndr_push *ndr, int flags, const struct PNP_UnregisterDeviceClassAssociation *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_UnregisterDeviceClassAssociation(struct ndr_pull *ndr, int flags, struct PNP_UnregisterDeviceClassAssociation *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_UnregisterDeviceClassAssociation(struct ndr_print *ndr, const char *name, int flags, const struct PNP_UnregisterDeviceClassAssociation *r)
{
	ndr_print_struct(ndr, name, "PNP_UnregisterDeviceClassAssociation");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_UnregisterDeviceClassAssociation");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_UnregisterDeviceClassAssociation");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetClassRegProp(struct ndr_push *ndr, int flags, const struct PNP_GetClassRegProp *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetClassRegProp(struct ndr_pull *ndr, int flags, struct PNP_GetClassRegProp *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetClassRegProp(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetClassRegProp *r)
{
	ndr_print_struct(ndr, name, "PNP_GetClassRegProp");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetClassRegProp");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetClassRegProp");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_SetClassRegProp(struct ndr_push *ndr, int flags, const struct PNP_SetClassRegProp *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_SetClassRegProp(struct ndr_pull *ndr, int flags, struct PNP_SetClassRegProp *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_SetClassRegProp(struct ndr_print *ndr, const char *name, int flags, const struct PNP_SetClassRegProp *r)
{
	ndr_print_struct(ndr, name, "PNP_SetClassRegProp");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_SetClassRegProp");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_SetClassRegProp");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_CreateDevInst(struct ndr_push *ndr, int flags, const struct PNP_CreateDevInst *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_CreateDevInst(struct ndr_pull *ndr, int flags, struct PNP_CreateDevInst *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_CreateDevInst(struct ndr_print *ndr, const char *name, int flags, const struct PNP_CreateDevInst *r)
{
	ndr_print_struct(ndr, name, "PNP_CreateDevInst");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_CreateDevInst");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_CreateDevInst");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_DeviceInstanceAction(struct ndr_push *ndr, int flags, const struct PNP_DeviceInstanceAction *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_DeviceInstanceAction(struct ndr_pull *ndr, int flags, struct PNP_DeviceInstanceAction *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_DeviceInstanceAction(struct ndr_print *ndr, const char *name, int flags, const struct PNP_DeviceInstanceAction *r)
{
	ndr_print_struct(ndr, name, "PNP_DeviceInstanceAction");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_DeviceInstanceAction");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_DeviceInstanceAction");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetDeviceStatus(struct ndr_push *ndr, int flags, const struct PNP_GetDeviceStatus *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetDeviceStatus(struct ndr_pull *ndr, int flags, struct PNP_GetDeviceStatus *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetDeviceStatus(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetDeviceStatus *r)
{
	ndr_print_struct(ndr, name, "PNP_GetDeviceStatus");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetDeviceStatus");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetDeviceStatus");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_SetDeviceProblem(struct ndr_push *ndr, int flags, const struct PNP_SetDeviceProblem *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_SetDeviceProblem(struct ndr_pull *ndr, int flags, struct PNP_SetDeviceProblem *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_SetDeviceProblem(struct ndr_print *ndr, const char *name, int flags, const struct PNP_SetDeviceProblem *r)
{
	ndr_print_struct(ndr, name, "PNP_SetDeviceProblem");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_SetDeviceProblem");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_SetDeviceProblem");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_DisableDevInst(struct ndr_push *ndr, int flags, const struct PNP_DisableDevInst *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_DisableDevInst(struct ndr_pull *ndr, int flags, struct PNP_DisableDevInst *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_DisableDevInst(struct ndr_print *ndr, const char *name, int flags, const struct PNP_DisableDevInst *r)
{
	ndr_print_struct(ndr, name, "PNP_DisableDevInst");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_DisableDevInst");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_DisableDevInst");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_UninstallDevInst(struct ndr_push *ndr, int flags, const struct PNP_UninstallDevInst *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_UninstallDevInst(struct ndr_pull *ndr, int flags, struct PNP_UninstallDevInst *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_UninstallDevInst(struct ndr_print *ndr, const char *name, int flags, const struct PNP_UninstallDevInst *r)
{
	ndr_print_struct(ndr, name, "PNP_UninstallDevInst");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_UninstallDevInst");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_UninstallDevInst");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_AddID(struct ndr_push *ndr, int flags, const struct PNP_AddID *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_AddID(struct ndr_pull *ndr, int flags, struct PNP_AddID *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_AddID(struct ndr_print *ndr, const char *name, int flags, const struct PNP_AddID *r)
{
	ndr_print_struct(ndr, name, "PNP_AddID");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_AddID");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_AddID");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RegisterDriver(struct ndr_push *ndr, int flags, const struct PNP_RegisterDriver *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RegisterDriver(struct ndr_pull *ndr, int flags, struct PNP_RegisterDriver *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RegisterDriver(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RegisterDriver *r)
{
	ndr_print_struct(ndr, name, "PNP_RegisterDriver");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RegisterDriver");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RegisterDriver");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_QueryRemove(struct ndr_push *ndr, int flags, const struct PNP_QueryRemove *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_QueryRemove(struct ndr_pull *ndr, int flags, struct PNP_QueryRemove *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_QueryRemove(struct ndr_print *ndr, const char *name, int flags, const struct PNP_QueryRemove *r)
{
	ndr_print_struct(ndr, name, "PNP_QueryRemove");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_QueryRemove");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_QueryRemove");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RequestDeviceEject(struct ndr_push *ndr, int flags, const struct PNP_RequestDeviceEject *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RequestDeviceEject(struct ndr_pull *ndr, int flags, struct PNP_RequestDeviceEject *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RequestDeviceEject(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RequestDeviceEject *r)
{
	ndr_print_struct(ndr, name, "PNP_RequestDeviceEject");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RequestDeviceEject");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RequestDeviceEject");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_IsDockStationPresent(struct ndr_push *ndr, int flags, const struct PNP_IsDockStationPresent *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_IsDockStationPresent(struct ndr_pull *ndr, int flags, struct PNP_IsDockStationPresent *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_IsDockStationPresent(struct ndr_print *ndr, const char *name, int flags, const struct PNP_IsDockStationPresent *r)
{
	ndr_print_struct(ndr, name, "PNP_IsDockStationPresent");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_IsDockStationPresent");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_IsDockStationPresent");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RequestEjectPC(struct ndr_push *ndr, int flags, const struct PNP_RequestEjectPC *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RequestEjectPC(struct ndr_pull *ndr, int flags, struct PNP_RequestEjectPC *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RequestEjectPC(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RequestEjectPC *r)
{
	ndr_print_struct(ndr, name, "PNP_RequestEjectPC");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RequestEjectPC");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RequestEjectPC");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_HwProfFlags(struct ndr_push *ndr, int flags, const struct PNP_HwProfFlags *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown1));
		if (r->in.devicepath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicepath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicepath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.devicepath, ndr_charset_length(r->in.devicepath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown2));
		if (r->in.unknown3 == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.unknown3));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.unknown4));
		if (r->in.unknown4) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.unknown4));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.unknown5));
		if (r->in.unknown5) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.unknown5, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.unknown5, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.unknown5, ndr_charset_length(r->in.unknown5, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown7));
	}
	if (flags & NDR_OUT) {
		if (r->out.unknown3 == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.unknown3));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.unknown4));
		if (r->out.unknown4) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.unknown4));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.unknown5a));
		if (r->out.unknown5a) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.unknown5a));
			if (*r->out.unknown5a) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.unknown5a, CH_UTF16)));
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.unknown5a, CH_UTF16)));
				NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.unknown5a, ndr_charset_length(*r->out.unknown5a, CH_UTF16), sizeof(uint16_t), CH_UTF16));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_HwProfFlags(struct ndr_pull *ndr, int flags, struct PNP_HwProfFlags *r)
{
	uint32_t _ptr_unknown4;
	uint32_t _ptr_unknown5;
	uint32_t _ptr_unknown5a;
	TALLOC_CTX *_mem_save_unknown3_0;
	TALLOC_CTX *_mem_save_unknown4_0;
	TALLOC_CTX *_mem_save_unknown5_0;
	TALLOC_CTX *_mem_save_unknown5a_0;
	TALLOC_CTX *_mem_save_unknown5a_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown1));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.devicepath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.devicepath));
		if (ndr_get_array_length(ndr, &r->in.devicepath) > ndr_get_array_size(ndr, &r->in.devicepath)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.devicepath), ndr_get_array_length(ndr, &r->in.devicepath));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.devicepath), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.devicepath, ndr_get_array_length(ndr, &r->in.devicepath), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown2));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.unknown3);
		}
		_mem_save_unknown3_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.unknown3, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.unknown3));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown3_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown4));
		if (_ptr_unknown4) {
			NDR_PULL_ALLOC(ndr, r->in.unknown4);
		} else {
			r->in.unknown4 = NULL;
		}
		if (r->in.unknown4) {
			_mem_save_unknown4_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.unknown4, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.unknown4));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown4_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown5));
		if (_ptr_unknown5) {
			NDR_PULL_ALLOC(ndr, r->in.unknown5);
		} else {
			r->in.unknown5 = NULL;
		}
		if (r->in.unknown5) {
			_mem_save_unknown5_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.unknown5, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.unknown5));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.unknown5));
			if (ndr_get_array_length(ndr, &r->in.unknown5) > ndr_get_array_size(ndr, &r->in.unknown5)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.unknown5), ndr_get_array_length(ndr, &r->in.unknown5));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.unknown5), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.unknown5, ndr_get_array_length(ndr, &r->in.unknown5), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown5_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown7));
		NDR_PULL_ALLOC(ndr, r->out.unknown3);
		*r->out.unknown3 = *r->in.unknown3;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.unknown3);
		}
		_mem_save_unknown3_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.unknown3, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.unknown3));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown3_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown4));
		if (_ptr_unknown4) {
			NDR_PULL_ALLOC(ndr, r->out.unknown4);
		} else {
			r->out.unknown4 = NULL;
		}
		if (r->out.unknown4) {
			_mem_save_unknown4_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.unknown4, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.unknown4));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown4_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown5a));
		if (_ptr_unknown5a) {
			NDR_PULL_ALLOC(ndr, r->out.unknown5a);
		} else {
			r->out.unknown5a = NULL;
		}
		if (r->out.unknown5a) {
			_mem_save_unknown5a_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.unknown5a, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown5a));
			if (_ptr_unknown5a) {
				NDR_PULL_ALLOC(ndr, *r->out.unknown5a);
			} else {
				*r->out.unknown5a = NULL;
			}
			if (*r->out.unknown5a) {
				_mem_save_unknown5a_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.unknown5a, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, r->out.unknown5a));
				NDR_CHECK(ndr_pull_array_length(ndr, r->out.unknown5a));
				if (ndr_get_array_length(ndr, r->out.unknown5a) > ndr_get_array_size(ndr, r->out.unknown5a)) {
					return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, r->out.unknown5a), ndr_get_array_length(ndr, r->out.unknown5a));
				}
				NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, r->out.unknown5a), sizeof(uint16_t)));
				NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.unknown5a, ndr_get_array_length(ndr, r->out.unknown5a), sizeof(uint16_t), CH_UTF16));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown5a_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown5a_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_HwProfFlags(struct ndr_print *ndr, const char *name, int flags, const struct PNP_HwProfFlags *r)
{
	ndr_print_struct(ndr, name, "PNP_HwProfFlags");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_HwProfFlags");
		ndr->depth++;
		ndr_print_uint32(ndr, "unknown1", r->in.unknown1);
		ndr_print_ptr(ndr, "devicepath", r->in.devicepath);
		ndr->depth++;
		ndr_print_string(ndr, "devicepath", r->in.devicepath);
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown2", r->in.unknown2);
		ndr_print_ptr(ndr, "unknown3", r->in.unknown3);
		ndr->depth++;
		ndr_print_uint32(ndr, "unknown3", *r->in.unknown3);
		ndr->depth--;
		ndr_print_ptr(ndr, "unknown4", r->in.unknown4);
		ndr->depth++;
		if (r->in.unknown4) {
			ndr_print_uint16(ndr, "unknown4", *r->in.unknown4);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "unknown5", r->in.unknown5);
		ndr->depth++;
		if (r->in.unknown5) {
			ndr_print_string(ndr, "unknown5", r->in.unknown5);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown6", r->in.unknown6);
		ndr_print_uint32(ndr, "unknown7", r->in.unknown7);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_HwProfFlags");
		ndr->depth++;
		ndr_print_ptr(ndr, "unknown3", r->out.unknown3);
		ndr->depth++;
		ndr_print_uint32(ndr, "unknown3", *r->out.unknown3);
		ndr->depth--;
		ndr_print_ptr(ndr, "unknown4", r->out.unknown4);
		ndr->depth++;
		if (r->out.unknown4) {
			ndr_print_uint16(ndr, "unknown4", *r->out.unknown4);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "unknown5a", r->out.unknown5a);
		ndr->depth++;
		if (r->out.unknown5a) {
			ndr_print_ptr(ndr, "unknown5a", *r->out.unknown5a);
			ndr->depth++;
			if (*r->out.unknown5a) {
				ndr_print_string(ndr, "unknown5a", *r->out.unknown5a);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetHwProfInfo(struct ndr_push *ndr, int flags, const struct PNP_GetHwProfInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.idx));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_PNP_HwProfInfo(ndr, NDR_SCALARS, r->in.info));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_PNP_HwProfInfo(ndr, NDR_SCALARS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetHwProfInfo(struct ndr_pull *ndr, int flags, struct PNP_GetHwProfInfo *r)
{
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.idx));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_PNP_HwProfInfo(ndr, NDR_SCALARS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.info);
		*r->out.info = *r->in.info;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_PNP_HwProfInfo(ndr, NDR_SCALARS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetHwProfInfo(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetHwProfInfo *r)
{
	ndr_print_struct(ndr, name, "PNP_GetHwProfInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetHwProfInfo");
		ndr->depth++;
		ndr_print_uint32(ndr, "idx", r->in.idx);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_PNP_HwProfInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_uint32(ndr, "size", r->in.size);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetHwProfInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_PNP_HwProfInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_AddEmptyLogConf(struct ndr_push *ndr, int flags, const struct PNP_AddEmptyLogConf *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_AddEmptyLogConf(struct ndr_pull *ndr, int flags, struct PNP_AddEmptyLogConf *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_AddEmptyLogConf(struct ndr_print *ndr, const char *name, int flags, const struct PNP_AddEmptyLogConf *r)
{
	ndr_print_struct(ndr, name, "PNP_AddEmptyLogConf");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_AddEmptyLogConf");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_AddEmptyLogConf");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_FreeLogConf(struct ndr_push *ndr, int flags, const struct PNP_FreeLogConf *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_FreeLogConf(struct ndr_pull *ndr, int flags, struct PNP_FreeLogConf *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_FreeLogConf(struct ndr_print *ndr, const char *name, int flags, const struct PNP_FreeLogConf *r)
{
	ndr_print_struct(ndr, name, "PNP_FreeLogConf");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_FreeLogConf");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_FreeLogConf");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetFirstLogConf(struct ndr_push *ndr, int flags, const struct PNP_GetFirstLogConf *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetFirstLogConf(struct ndr_pull *ndr, int flags, struct PNP_GetFirstLogConf *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetFirstLogConf(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetFirstLogConf *r)
{
	ndr_print_struct(ndr, name, "PNP_GetFirstLogConf");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetFirstLogConf");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetFirstLogConf");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetNextLogConf(struct ndr_push *ndr, int flags, const struct PNP_GetNextLogConf *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetNextLogConf(struct ndr_pull *ndr, int flags, struct PNP_GetNextLogConf *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetNextLogConf(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetNextLogConf *r)
{
	ndr_print_struct(ndr, name, "PNP_GetNextLogConf");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetNextLogConf");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetNextLogConf");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetLogConfPriority(struct ndr_push *ndr, int flags, const struct PNP_GetLogConfPriority *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetLogConfPriority(struct ndr_pull *ndr, int flags, struct PNP_GetLogConfPriority *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetLogConfPriority(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetLogConfPriority *r)
{
	ndr_print_struct(ndr, name, "PNP_GetLogConfPriority");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetLogConfPriority");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetLogConfPriority");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_AddResDes(struct ndr_push *ndr, int flags, const struct PNP_AddResDes *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_AddResDes(struct ndr_pull *ndr, int flags, struct PNP_AddResDes *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_AddResDes(struct ndr_print *ndr, const char *name, int flags, const struct PNP_AddResDes *r)
{
	ndr_print_struct(ndr, name, "PNP_AddResDes");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_AddResDes");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_AddResDes");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_FreeResDes(struct ndr_push *ndr, int flags, const struct PNP_FreeResDes *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_FreeResDes(struct ndr_pull *ndr, int flags, struct PNP_FreeResDes *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_FreeResDes(struct ndr_print *ndr, const char *name, int flags, const struct PNP_FreeResDes *r)
{
	ndr_print_struct(ndr, name, "PNP_FreeResDes");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_FreeResDes");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_FreeResDes");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetNextResDes(struct ndr_push *ndr, int flags, const struct PNP_GetNextResDes *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetNextResDes(struct ndr_pull *ndr, int flags, struct PNP_GetNextResDes *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetNextResDes(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetNextResDes *r)
{
	ndr_print_struct(ndr, name, "PNP_GetNextResDes");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetNextResDes");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetNextResDes");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetResDesData(struct ndr_push *ndr, int flags, const struct PNP_GetResDesData *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetResDesData(struct ndr_pull *ndr, int flags, struct PNP_GetResDesData *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetResDesData(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetResDesData *r)
{
	ndr_print_struct(ndr, name, "PNP_GetResDesData");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetResDesData");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetResDesData");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetResDesDataSize(struct ndr_push *ndr, int flags, const struct PNP_GetResDesDataSize *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetResDesDataSize(struct ndr_pull *ndr, int flags, struct PNP_GetResDesDataSize *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetResDesDataSize(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetResDesDataSize *r)
{
	ndr_print_struct(ndr, name, "PNP_GetResDesDataSize");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetResDesDataSize");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetResDesDataSize");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_ModifyResDes(struct ndr_push *ndr, int flags, const struct PNP_ModifyResDes *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_ModifyResDes(struct ndr_pull *ndr, int flags, struct PNP_ModifyResDes *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_ModifyResDes(struct ndr_print *ndr, const char *name, int flags, const struct PNP_ModifyResDes *r)
{
	ndr_print_struct(ndr, name, "PNP_ModifyResDes");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_ModifyResDes");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_ModifyResDes");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_DetectResourceLimit(struct ndr_push *ndr, int flags, const struct PNP_DetectResourceLimit *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_DetectResourceLimit(struct ndr_pull *ndr, int flags, struct PNP_DetectResourceLimit *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_DetectResourceLimit(struct ndr_print *ndr, const char *name, int flags, const struct PNP_DetectResourceLimit *r)
{
	ndr_print_struct(ndr, name, "PNP_DetectResourceLimit");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_DetectResourceLimit");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_DetectResourceLimit");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_QueryResConfList(struct ndr_push *ndr, int flags, const struct PNP_QueryResConfList *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_QueryResConfList(struct ndr_pull *ndr, int flags, struct PNP_QueryResConfList *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_QueryResConfList(struct ndr_print *ndr, const char *name, int flags, const struct PNP_QueryResConfList *r)
{
	ndr_print_struct(ndr, name, "PNP_QueryResConfList");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_QueryResConfList");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_QueryResConfList");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_SetHwProf(struct ndr_push *ndr, int flags, const struct PNP_SetHwProf *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_SetHwProf(struct ndr_pull *ndr, int flags, struct PNP_SetHwProf *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_SetHwProf(struct ndr_print *ndr, const char *name, int flags, const struct PNP_SetHwProf *r)
{
	ndr_print_struct(ndr, name, "PNP_SetHwProf");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_SetHwProf");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_SetHwProf");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_QueryArbitratorFreeData(struct ndr_push *ndr, int flags, const struct PNP_QueryArbitratorFreeData *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_QueryArbitratorFreeData(struct ndr_pull *ndr, int flags, struct PNP_QueryArbitratorFreeData *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_QueryArbitratorFreeData(struct ndr_print *ndr, const char *name, int flags, const struct PNP_QueryArbitratorFreeData *r)
{
	ndr_print_struct(ndr, name, "PNP_QueryArbitratorFreeData");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_QueryArbitratorFreeData");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_QueryArbitratorFreeData");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_QueryArbitratorFreeSize(struct ndr_push *ndr, int flags, const struct PNP_QueryArbitratorFreeSize *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_QueryArbitratorFreeSize(struct ndr_pull *ndr, int flags, struct PNP_QueryArbitratorFreeSize *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_QueryArbitratorFreeSize(struct ndr_print *ndr, const char *name, int flags, const struct PNP_QueryArbitratorFreeSize *r)
{
	ndr_print_struct(ndr, name, "PNP_QueryArbitratorFreeSize");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_QueryArbitratorFreeSize");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_QueryArbitratorFreeSize");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RunDetection(struct ndr_push *ndr, int flags, const struct PNP_RunDetection *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RunDetection(struct ndr_pull *ndr, int flags, struct PNP_RunDetection *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RunDetection(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RunDetection *r)
{
	ndr_print_struct(ndr, name, "PNP_RunDetection");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RunDetection");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RunDetection");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RegisterNotification(struct ndr_push *ndr, int flags, const struct PNP_RegisterNotification *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RegisterNotification(struct ndr_pull *ndr, int flags, struct PNP_RegisterNotification *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RegisterNotification(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RegisterNotification *r)
{
	ndr_print_struct(ndr, name, "PNP_RegisterNotification");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RegisterNotification");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RegisterNotification");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_UnregisterNotification(struct ndr_push *ndr, int flags, const struct PNP_UnregisterNotification *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_UnregisterNotification(struct ndr_pull *ndr, int flags, struct PNP_UnregisterNotification *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_UnregisterNotification(struct ndr_print *ndr, const char *name, int flags, const struct PNP_UnregisterNotification *r)
{
	ndr_print_struct(ndr, name, "PNP_UnregisterNotification");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_UnregisterNotification");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_UnregisterNotification");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetCustomDevProp(struct ndr_push *ndr, int flags, const struct PNP_GetCustomDevProp *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetCustomDevProp(struct ndr_pull *ndr, int flags, struct PNP_GetCustomDevProp *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetCustomDevProp(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetCustomDevProp *r)
{
	ndr_print_struct(ndr, name, "PNP_GetCustomDevProp");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetCustomDevProp");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetCustomDevProp");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetVersionInternal(struct ndr_push *ndr, int flags, const struct PNP_GetVersionInternal *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetVersionInternal(struct ndr_pull *ndr, int flags, struct PNP_GetVersionInternal *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetVersionInternal(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetVersionInternal *r)
{
	ndr_print_struct(ndr, name, "PNP_GetVersionInternal");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetVersionInternal");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetVersionInternal");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetBlockedDriverInfo(struct ndr_push *ndr, int flags, const struct PNP_GetBlockedDriverInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetBlockedDriverInfo(struct ndr_pull *ndr, int flags, struct PNP_GetBlockedDriverInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetBlockedDriverInfo(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetBlockedDriverInfo *r)
{
	ndr_print_struct(ndr, name, "PNP_GetBlockedDriverInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetBlockedDriverInfo");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetBlockedDriverInfo");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetServerSideDeviceInstallFlags(struct ndr_push *ndr, int flags, const struct PNP_GetServerSideDeviceInstallFlags *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetServerSideDeviceInstallFlags(struct ndr_pull *ndr, int flags, struct PNP_GetServerSideDeviceInstallFlags *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetServerSideDeviceInstallFlags(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetServerSideDeviceInstallFlags *r)
{
	ndr_print_struct(ndr, name, "PNP_GetServerSideDeviceInstallFlags");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetServerSideDeviceInstallFlags");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetServerSideDeviceInstallFlags");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call ntsvcs_calls[] = {
	{
		"PNP_Disconnect",
		sizeof(struct PNP_Disconnect),
		(ndr_push_flags_fn_t) ndr_push_PNP_Disconnect,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_Disconnect,
		(ndr_print_function_t) ndr_print_PNP_Disconnect,
		false,
	},
	{
		"PNP_Connect",
		sizeof(struct PNP_Connect),
		(ndr_push_flags_fn_t) ndr_push_PNP_Connect,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_Connect,
		(ndr_print_function_t) ndr_print_PNP_Connect,
		false,
	},
	{
		"PNP_GetVersion",
		sizeof(struct PNP_GetVersion),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetVersion,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetVersion,
		(ndr_print_function_t) ndr_print_PNP_GetVersion,
		false,
	},
	{
		"PNP_GetGlobalState",
		sizeof(struct PNP_GetGlobalState),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetGlobalState,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetGlobalState,
		(ndr_print_function_t) ndr_print_PNP_GetGlobalState,
		false,
	},
	{
		"PNP_InitDetection",
		sizeof(struct PNP_InitDetection),
		(ndr_push_flags_fn_t) ndr_push_PNP_InitDetection,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_InitDetection,
		(ndr_print_function_t) ndr_print_PNP_InitDetection,
		false,
	},
	{
		"PNP_ReportLogOn",
		sizeof(struct PNP_ReportLogOn),
		(ndr_push_flags_fn_t) ndr_push_PNP_ReportLogOn,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_ReportLogOn,
		(ndr_print_function_t) ndr_print_PNP_ReportLogOn,
		false,
	},
	{
		"PNP_ValidateDeviceInstance",
		sizeof(struct PNP_ValidateDeviceInstance),
		(ndr_push_flags_fn_t) ndr_push_PNP_ValidateDeviceInstance,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_ValidateDeviceInstance,
		(ndr_print_function_t) ndr_print_PNP_ValidateDeviceInstance,
		false,
	},
	{
		"PNP_GetRootDeviceInstance",
		sizeof(struct PNP_GetRootDeviceInstance),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetRootDeviceInstance,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetRootDeviceInstance,
		(ndr_print_function_t) ndr_print_PNP_GetRootDeviceInstance,
		false,
	},
	{
		"PNP_GetRelatedDeviceInstance",
		sizeof(struct PNP_GetRelatedDeviceInstance),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetRelatedDeviceInstance,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetRelatedDeviceInstance,
		(ndr_print_function_t) ndr_print_PNP_GetRelatedDeviceInstance,
		false,
	},
	{
		"PNP_EnumerateSubKeys",
		sizeof(struct PNP_EnumerateSubKeys),
		(ndr_push_flags_fn_t) ndr_push_PNP_EnumerateSubKeys,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_EnumerateSubKeys,
		(ndr_print_function_t) ndr_print_PNP_EnumerateSubKeys,
		false,
	},
	{
		"PNP_GetDeviceList",
		sizeof(struct PNP_GetDeviceList),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetDeviceList,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetDeviceList,
		(ndr_print_function_t) ndr_print_PNP_GetDeviceList,
		false,
	},
	{
		"PNP_GetDeviceListSize",
		sizeof(struct PNP_GetDeviceListSize),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetDeviceListSize,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetDeviceListSize,
		(ndr_print_function_t) ndr_print_PNP_GetDeviceListSize,
		false,
	},
	{
		"PNP_GetDepth",
		sizeof(struct PNP_GetDepth),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetDepth,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetDepth,
		(ndr_print_function_t) ndr_print_PNP_GetDepth,
		false,
	},
	{
		"PNP_GetDeviceRegProp",
		sizeof(struct PNP_GetDeviceRegProp),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetDeviceRegProp,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetDeviceRegProp,
		(ndr_print_function_t) ndr_print_PNP_GetDeviceRegProp,
		false,
	},
	{
		"PNP_SetDeviceRegProp",
		sizeof(struct PNP_SetDeviceRegProp),
		(ndr_push_flags_fn_t) ndr_push_PNP_SetDeviceRegProp,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_SetDeviceRegProp,
		(ndr_print_function_t) ndr_print_PNP_SetDeviceRegProp,
		false,
	},
	{
		"PNP_GetClassInstance",
		sizeof(struct PNP_GetClassInstance),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetClassInstance,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetClassInstance,
		(ndr_print_function_t) ndr_print_PNP_GetClassInstance,
		false,
	},
	{
		"PNP_CreateKey",
		sizeof(struct PNP_CreateKey),
		(ndr_push_flags_fn_t) ndr_push_PNP_CreateKey,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_CreateKey,
		(ndr_print_function_t) ndr_print_PNP_CreateKey,
		false,
	},
	{
		"PNP_DeleteRegistryKey",
		sizeof(struct PNP_DeleteRegistryKey),
		(ndr_push_flags_fn_t) ndr_push_PNP_DeleteRegistryKey,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_DeleteRegistryKey,
		(ndr_print_function_t) ndr_print_PNP_DeleteRegistryKey,
		false,
	},
	{
		"PNP_GetClassCount",
		sizeof(struct PNP_GetClassCount),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetClassCount,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetClassCount,
		(ndr_print_function_t) ndr_print_PNP_GetClassCount,
		false,
	},
	{
		"PNP_GetClassName",
		sizeof(struct PNP_GetClassName),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetClassName,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetClassName,
		(ndr_print_function_t) ndr_print_PNP_GetClassName,
		false,
	},
	{
		"PNP_DeleteClassKey",
		sizeof(struct PNP_DeleteClassKey),
		(ndr_push_flags_fn_t) ndr_push_PNP_DeleteClassKey,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_DeleteClassKey,
		(ndr_print_function_t) ndr_print_PNP_DeleteClassKey,
		false,
	},
	{
		"PNP_GetInterfaceDeviceAlias",
		sizeof(struct PNP_GetInterfaceDeviceAlias),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetInterfaceDeviceAlias,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetInterfaceDeviceAlias,
		(ndr_print_function_t) ndr_print_PNP_GetInterfaceDeviceAlias,
		false,
	},
	{
		"PNP_GetInterfaceDeviceList",
		sizeof(struct PNP_GetInterfaceDeviceList),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetInterfaceDeviceList,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetInterfaceDeviceList,
		(ndr_print_function_t) ndr_print_PNP_GetInterfaceDeviceList,
		false,
	},
	{
		"PNP_GetInterfaceDeviceListSize",
		sizeof(struct PNP_GetInterfaceDeviceListSize),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetInterfaceDeviceListSize,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetInterfaceDeviceListSize,
		(ndr_print_function_t) ndr_print_PNP_GetInterfaceDeviceListSize,
		false,
	},
	{
		"PNP_RegisterDeviceClassAssociation",
		sizeof(struct PNP_RegisterDeviceClassAssociation),
		(ndr_push_flags_fn_t) ndr_push_PNP_RegisterDeviceClassAssociation,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RegisterDeviceClassAssociation,
		(ndr_print_function_t) ndr_print_PNP_RegisterDeviceClassAssociation,
		false,
	},
	{
		"PNP_UnregisterDeviceClassAssociation",
		sizeof(struct PNP_UnregisterDeviceClassAssociation),
		(ndr_push_flags_fn_t) ndr_push_PNP_UnregisterDeviceClassAssociation,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_UnregisterDeviceClassAssociation,
		(ndr_print_function_t) ndr_print_PNP_UnregisterDeviceClassAssociation,
		false,
	},
	{
		"PNP_GetClassRegProp",
		sizeof(struct PNP_GetClassRegProp),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetClassRegProp,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetClassRegProp,
		(ndr_print_function_t) ndr_print_PNP_GetClassRegProp,
		false,
	},
	{
		"PNP_SetClassRegProp",
		sizeof(struct PNP_SetClassRegProp),
		(ndr_push_flags_fn_t) ndr_push_PNP_SetClassRegProp,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_SetClassRegProp,
		(ndr_print_function_t) ndr_print_PNP_SetClassRegProp,
		false,
	},
	{
		"PNP_CreateDevInst",
		sizeof(struct PNP_CreateDevInst),
		(ndr_push_flags_fn_t) ndr_push_PNP_CreateDevInst,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_CreateDevInst,
		(ndr_print_function_t) ndr_print_PNP_CreateDevInst,
		false,
	},
	{
		"PNP_DeviceInstanceAction",
		sizeof(struct PNP_DeviceInstanceAction),
		(ndr_push_flags_fn_t) ndr_push_PNP_DeviceInstanceAction,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_DeviceInstanceAction,
		(ndr_print_function_t) ndr_print_PNP_DeviceInstanceAction,
		false,
	},
	{
		"PNP_GetDeviceStatus",
		sizeof(struct PNP_GetDeviceStatus),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetDeviceStatus,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetDeviceStatus,
		(ndr_print_function_t) ndr_print_PNP_GetDeviceStatus,
		false,
	},
	{
		"PNP_SetDeviceProblem",
		sizeof(struct PNP_SetDeviceProblem),
		(ndr_push_flags_fn_t) ndr_push_PNP_SetDeviceProblem,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_SetDeviceProblem,
		(ndr_print_function_t) ndr_print_PNP_SetDeviceProblem,
		false,
	},
	{
		"PNP_DisableDevInst",
		sizeof(struct PNP_DisableDevInst),
		(ndr_push_flags_fn_t) ndr_push_PNP_DisableDevInst,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_DisableDevInst,
		(ndr_print_function_t) ndr_print_PNP_DisableDevInst,
		false,
	},
	{
		"PNP_UninstallDevInst",
		sizeof(struct PNP_UninstallDevInst),
		(ndr_push_flags_fn_t) ndr_push_PNP_UninstallDevInst,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_UninstallDevInst,
		(ndr_print_function_t) ndr_print_PNP_UninstallDevInst,
		false,
	},
	{
		"PNP_AddID",
		sizeof(struct PNP_AddID),
		(ndr_push_flags_fn_t) ndr_push_PNP_AddID,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_AddID,
		(ndr_print_function_t) ndr_print_PNP_AddID,
		false,
	},
	{
		"PNP_RegisterDriver",
		sizeof(struct PNP_RegisterDriver),
		(ndr_push_flags_fn_t) ndr_push_PNP_RegisterDriver,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RegisterDriver,
		(ndr_print_function_t) ndr_print_PNP_RegisterDriver,
		false,
	},
	{
		"PNP_QueryRemove",
		sizeof(struct PNP_QueryRemove),
		(ndr_push_flags_fn_t) ndr_push_PNP_QueryRemove,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_QueryRemove,
		(ndr_print_function_t) ndr_print_PNP_QueryRemove,
		false,
	},
	{
		"PNP_RequestDeviceEject",
		sizeof(struct PNP_RequestDeviceEject),
		(ndr_push_flags_fn_t) ndr_push_PNP_RequestDeviceEject,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RequestDeviceEject,
		(ndr_print_function_t) ndr_print_PNP_RequestDeviceEject,
		false,
	},
	{
		"PNP_IsDockStationPresent",
		sizeof(struct PNP_IsDockStationPresent),
		(ndr_push_flags_fn_t) ndr_push_PNP_IsDockStationPresent,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_IsDockStationPresent,
		(ndr_print_function_t) ndr_print_PNP_IsDockStationPresent,
		false,
	},
	{
		"PNP_RequestEjectPC",
		sizeof(struct PNP_RequestEjectPC),
		(ndr_push_flags_fn_t) ndr_push_PNP_RequestEjectPC,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RequestEjectPC,
		(ndr_print_function_t) ndr_print_PNP_RequestEjectPC,
		false,
	},
	{
		"PNP_HwProfFlags",
		sizeof(struct PNP_HwProfFlags),
		(ndr_push_flags_fn_t) ndr_push_PNP_HwProfFlags,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_HwProfFlags,
		(ndr_print_function_t) ndr_print_PNP_HwProfFlags,
		false,
	},
	{
		"PNP_GetHwProfInfo",
		sizeof(struct PNP_GetHwProfInfo),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetHwProfInfo,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetHwProfInfo,
		(ndr_print_function_t) ndr_print_PNP_GetHwProfInfo,
		false,
	},
	{
		"PNP_AddEmptyLogConf",
		sizeof(struct PNP_AddEmptyLogConf),
		(ndr_push_flags_fn_t) ndr_push_PNP_AddEmptyLogConf,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_AddEmptyLogConf,
		(ndr_print_function_t) ndr_print_PNP_AddEmptyLogConf,
		false,
	},
	{
		"PNP_FreeLogConf",
		sizeof(struct PNP_FreeLogConf),
		(ndr_push_flags_fn_t) ndr_push_PNP_FreeLogConf,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_FreeLogConf,
		(ndr_print_function_t) ndr_print_PNP_FreeLogConf,
		false,
	},
	{
		"PNP_GetFirstLogConf",
		sizeof(struct PNP_GetFirstLogConf),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetFirstLogConf,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetFirstLogConf,
		(ndr_print_function_t) ndr_print_PNP_GetFirstLogConf,
		false,
	},
	{
		"PNP_GetNextLogConf",
		sizeof(struct PNP_GetNextLogConf),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetNextLogConf,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetNextLogConf,
		(ndr_print_function_t) ndr_print_PNP_GetNextLogConf,
		false,
	},
	{
		"PNP_GetLogConfPriority",
		sizeof(struct PNP_GetLogConfPriority),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetLogConfPriority,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetLogConfPriority,
		(ndr_print_function_t) ndr_print_PNP_GetLogConfPriority,
		false,
	},
	{
		"PNP_AddResDes",
		sizeof(struct PNP_AddResDes),
		(ndr_push_flags_fn_t) ndr_push_PNP_AddResDes,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_AddResDes,
		(ndr_print_function_t) ndr_print_PNP_AddResDes,
		false,
	},
	{
		"PNP_FreeResDes",
		sizeof(struct PNP_FreeResDes),
		(ndr_push_flags_fn_t) ndr_push_PNP_FreeResDes,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_FreeResDes,
		(ndr_print_function_t) ndr_print_PNP_FreeResDes,
		false,
	},
	{
		"PNP_GetNextResDes",
		sizeof(struct PNP_GetNextResDes),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetNextResDes,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetNextResDes,
		(ndr_print_function_t) ndr_print_PNP_GetNextResDes,
		false,
	},
	{
		"PNP_GetResDesData",
		sizeof(struct PNP_GetResDesData),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetResDesData,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetResDesData,
		(ndr_print_function_t) ndr_print_PNP_GetResDesData,
		false,
	},
	{
		"PNP_GetResDesDataSize",
		sizeof(struct PNP_GetResDesDataSize),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetResDesDataSize,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetResDesDataSize,
		(ndr_print_function_t) ndr_print_PNP_GetResDesDataSize,
		false,
	},
	{
		"PNP_ModifyResDes",
		sizeof(struct PNP_ModifyResDes),
		(ndr_push_flags_fn_t) ndr_push_PNP_ModifyResDes,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_ModifyResDes,
		(ndr_print_function_t) ndr_print_PNP_ModifyResDes,
		false,
	},
	{
		"PNP_DetectResourceLimit",
		sizeof(struct PNP_DetectResourceLimit),
		(ndr_push_flags_fn_t) ndr_push_PNP_DetectResourceLimit,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_DetectResourceLimit,
		(ndr_print_function_t) ndr_print_PNP_DetectResourceLimit,
		false,
	},
	{
		"PNP_QueryResConfList",
		sizeof(struct PNP_QueryResConfList),
		(ndr_push_flags_fn_t) ndr_push_PNP_QueryResConfList,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_QueryResConfList,
		(ndr_print_function_t) ndr_print_PNP_QueryResConfList,
		false,
	},
	{
		"PNP_SetHwProf",
		sizeof(struct PNP_SetHwProf),
		(ndr_push_flags_fn_t) ndr_push_PNP_SetHwProf,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_SetHwProf,
		(ndr_print_function_t) ndr_print_PNP_SetHwProf,
		false,
	},
	{
		"PNP_QueryArbitratorFreeData",
		sizeof(struct PNP_QueryArbitratorFreeData),
		(ndr_push_flags_fn_t) ndr_push_PNP_QueryArbitratorFreeData,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_QueryArbitratorFreeData,
		(ndr_print_function_t) ndr_print_PNP_QueryArbitratorFreeData,
		false,
	},
	{
		"PNP_QueryArbitratorFreeSize",
		sizeof(struct PNP_QueryArbitratorFreeSize),
		(ndr_push_flags_fn_t) ndr_push_PNP_QueryArbitratorFreeSize,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_QueryArbitratorFreeSize,
		(ndr_print_function_t) ndr_print_PNP_QueryArbitratorFreeSize,
		false,
	},
	{
		"PNP_RunDetection",
		sizeof(struct PNP_RunDetection),
		(ndr_push_flags_fn_t) ndr_push_PNP_RunDetection,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RunDetection,
		(ndr_print_function_t) ndr_print_PNP_RunDetection,
		false,
	},
	{
		"PNP_RegisterNotification",
		sizeof(struct PNP_RegisterNotification),
		(ndr_push_flags_fn_t) ndr_push_PNP_RegisterNotification,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RegisterNotification,
		(ndr_print_function_t) ndr_print_PNP_RegisterNotification,
		false,
	},
	{
		"PNP_UnregisterNotification",
		sizeof(struct PNP_UnregisterNotification),
		(ndr_push_flags_fn_t) ndr_push_PNP_UnregisterNotification,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_UnregisterNotification,
		(ndr_print_function_t) ndr_print_PNP_UnregisterNotification,
		false,
	},
	{
		"PNP_GetCustomDevProp",
		sizeof(struct PNP_GetCustomDevProp),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetCustomDevProp,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetCustomDevProp,
		(ndr_print_function_t) ndr_print_PNP_GetCustomDevProp,
		false,
	},
	{
		"PNP_GetVersionInternal",
		sizeof(struct PNP_GetVersionInternal),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetVersionInternal,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetVersionInternal,
		(ndr_print_function_t) ndr_print_PNP_GetVersionInternal,
		false,
	},
	{
		"PNP_GetBlockedDriverInfo",
		sizeof(struct PNP_GetBlockedDriverInfo),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetBlockedDriverInfo,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetBlockedDriverInfo,
		(ndr_print_function_t) ndr_print_PNP_GetBlockedDriverInfo,
		false,
	},
	{
		"PNP_GetServerSideDeviceInstallFlags",
		sizeof(struct PNP_GetServerSideDeviceInstallFlags),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetServerSideDeviceInstallFlags,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetServerSideDeviceInstallFlags,
		(ndr_print_function_t) ndr_print_PNP_GetServerSideDeviceInstallFlags,
		false,
	},
	{ NULL, 0, NULL, NULL, NULL, false }
};

static const char * const ntsvcs_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\ntsvcs]", 
};

static const struct ndr_interface_string_array ntsvcs_endpoints = {
	.count	= 1,
	.names	= ntsvcs_endpoint_strings
};

static const char * const ntsvcs_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array ntsvcs_authservices = {
	.count	= 1,
	.names	= ntsvcs_authservice_strings
};


const struct ndr_interface_table ndr_table_ntsvcs = {
	.name		= "ntsvcs",
	.syntax_id	= {
		{0x8d9f4e40,0xa03d,0x11ce,{0x8f,0x69},{0x08,0x00,0x3e,0x30,0x05,0x1b}},
		NDR_NTSVCS_VERSION
	},
	.helpstring	= NDR_NTSVCS_HELPSTRING,
	.num_calls	= 65,
	.calls		= ntsvcs_calls,
	.endpoints	= &ntsvcs_endpoints,
	.authservices	= &ntsvcs_authservices
};

