#! /usr/bin/perl
# Author: Thomas E. Dickey
# $XTermId: 256colres.pl,v 1.15 2007/06/08 23:58:37 tom Exp $
# $XFree86: xc/programs/xterm/256colres.pl,v 1.8 2002/10/05 17:57:11 dickey Exp $

# Construct a header file defining default resources for the 256-color model
# of xterm.  This is modeled after the 256colors2.pl script.

# use the resources for colors 0-15 - usually more-or-less a
# reproduction of the standard ANSI colors, but possibly more
# pleasing shades

use strict;

our ( $line1, $line2, $line3 );
our ( $red, $green, $blue, $gray );
our ( $level, $code, @steps );

print <<EOF;
/*
 * This header file was generated by $0
 */
/* \$XTermId\$ */

#ifndef included_256colres_h
#define included_256colres_h

EOF

$line1="COLOR_RES(\"%d\",";
$line2="\tscreen.Acolors[%d],";
$line3="\tDFT_COLOR(\"rgb:%2.2x/%2.2x/%2.2x\")),\n";

# colors 16-231 are a 6x6x6 color cube
for ($red = 0; $red < 6; $red++) {
    for ($green = 0; $green < 6; $green++) {
	for ($blue = 0; $blue < 6; $blue++) {
	    $code = 16 + ($red * 36) + ($green * 6) + $blue;
	    printf($line1, $code);
	    printf($line2, $code);
	    printf($line3,
		   ($red ? ($red * 40 + 55) : 0),
		   ($green ? ($green * 40 + 55) : 0),
		   ($blue ? ($blue * 40 + 55) : 0));
	}
    }
}

# colors 232-255 are a grayscale ramp, intentionally leaving out
# black and white
$code=232;
for ($gray = 0; $gray < 24; $gray++) {
    $level = ($gray * 10) + 8;
    $code = 232 + $gray;
    printf($line1, $code);
    printf($line2, $code);
    printf($line3,
	   $level, $level, $level);
}

print <<EOF;

#endif /* included_256colres_h */
EOF
