#!/bin/sh -x

# Settings
JS='../kjscmd --noexec'
REF='jsref'

# Examples and changelog
(cd examples ; w3m -dump index.html > README)

# Constructor Index
$JS write_classes.js > $REF/classes.html

# Constructor Index
$JS write_widgets.js > $REF/widgets.html

# Global Objects
$JS write_docs.js 'this' 'this' 'Default context scripts are executed in.' > $REF/this.html

$JS write_docs.js 'Global' 'global' 'The global object.' > $REF/global.html
$JS write_docs.js 'Application' 'application' 'Global application object.' > $REF/application.html
$JS write_docs.js 'Part' 'part' 'Part used by the interpreter.' > $REF/part.html
$JS write_docs.js 'StdDirs' 'StdDirs' 'Provides access to KStandardDirs.' > $REF/stddirs.html
$JS write_docs.js 'StdIcons' 'StdIcons' 'Provides access to the KIconLoader.' > $REF/stdicons.html

# Custom Objects
$JS write_docs.js 'Image' 'new Image()' 'Bindings to the QImage class.' > $REF/image.html
$JS write_docs.js 'Pixmap' 'new Pixmap()' 'Bindings to the QPixmap class.' > $REF/pixmap.html
$JS write_docs.js 'Painter' 'new Painter()' 'Bindings for painting on Pixmaps.' > $REF/painter.html
$JS write_docs.js 'NetAccess' 'new NetAccess()' 'Bindings for KIO::NetAccess.' > $REF/netaccess.html
$JS write_docs.js 'DCOPObject' 'new DCOPObject()' 'Provides support for DCOP.' > $REF/dcop.html
$JS write_docs.js 'SqlDatabase' 'new SqlDatabase()' 'Provides support for QtSQL Databases.' > $REF/sqldatabase.html
$JS write_docs.js 'SqlQuery' 'new SqlQuery()' 'Provides support for QtSQL Queries.' > $REF/sqlquery.html
$JS write_docs.js 'TextStream' 'System.stdin' 'Bindings for QTextSteam.' > $REF/textstream.html
$JS write_docs.js 'Config' 'new Config()' 'Bindings to the KConfig class.' > $REF/config.html

# Qt Objects
OBJECTS="QPushButton QToolButton QCheckBox QRadioButton"
OBJECTS="$OBJECTS QGroupBox QButtonGroup QIconView QTable"
OBJECTS="$OBJECTS QListBox QListView QLineEdit QSpinBox"
OBJECTS="$OBJECTS QMultiLineEdit QLabel TextLabel PixmapLabel"
OBJECTS="$OBJECTS QLayoutWidget QTabWidget QComboBox"
OBJECTS="$OBJECTS QWidget QDialog QWizard QLCDNumber"
OBJECTS="$OBJECTS QProgressBar QTextView QTextBrowser"
OBJECTS="$OBJECTS QDial QSlider QFrame Line QTextEdit"
OBJECTS="$OBJECTS QDateEdit QTimeEdit QDateTimeEdit QScrollBar"
OBJECTS="$OBJECTS QPopupMenu QWidgetStack QMainWindow"
OBJECTS="$OBJECTS QDataTable QDataBrowser QDataView"
OBJECTS="$OBJECTS QVBox QHBox QGrid"

for OBJ in $OBJECTS ;
do
  FILENAME=`echo $OBJ | tr '[A-Z]' '[a-z]'`
  $JS write_docs.js "$OBJ" "new $OBJ()" "Bindings for a $OBJ." > "$REF/$FILENAME.html" ;
done

OBJECTS=""

OBJECTS="$OBJECTS KActiveLabel KCharSelect KColorButton KColorCombo"
OBJECTS="$OBJECTS KComboBox KCModule KDateWidget KDatePicker KDialog"
OBJECTS="$OBJECTS KDualColorButton KEditListBox KFontCombo KGradientSelector"
OBJECTS="$OBJECTS KHistoryCombo KHSSelector KLed KListBox KListView"
OBJECTS="$OBJECTS KLineEdit KPasswordEdit KProgress KPushButton"
OBJECTS="$OBJECTS KRestrictedLine KIconButton KIntSpinBox KRuler"
OBJECTS="$OBJECTS KSqueezedTextLabel KTextBrowser KTextEdit"
OBJECTS="$OBJECTS KURLLabel KURLRequester"
OBJECTS="$OBJECTS KIntNumInput KDoubleNumInput KDoubleSpinBox"

for OBJ in $OBJECTS ;
do
  FILENAME=`echo $OBJ | tr '[A-Z]' '[a-z]'`
  $JS write_docs.js "$OBJ" "new $OBJ()" "Bindings for a $OBJ." > "$REF/$FILENAME.html" ;
done


OBJECTS="$OBJECTS QSplitter"
OBJECTS="$OBJECTS QObject QTimer"

OBJECTS="$OBJECTS KMainWindow KAction KToggleAction"

for OBJ in $OBJECTS ;
do
  FILENAME=`echo $OBJ | tr '[A-Z]' '[a-z]'`
  $JS write_docs.js "$OBJ" "new $OBJ()" "Bindings for a $OBJ." > "$REF/$FILENAME.html" ;
done



