/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.compiler;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.compiler.OopMap;
import sun.jvm.hotspot.compiler.OopMapStream;
import sun.jvm.hotspot.compiler.OopMapValue;
import sun.jvm.hotspot.compiler.OopMapVisitor;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class OopMapSet
extends VMObject {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.compiler.OopMapSet.DEBUG") != null;
    private static CIntegerField omCountField;
    private static CIntegerField omSizeField;
    private static AddressField omDataField;
    private static int REG_COUNT;
    private static int SAVED_ON_ENTRY_REG_COUNT;
    private static int C_SAVED_ON_ENTRY_REG_COUNT;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("OopMapSet");
        omCountField = type.getCIntegerField("_om_count");
        omSizeField = type.getCIntegerField("_om_size");
        omDataField = type.getAddressField("_om_data");
        if (!VM.getVM().isCore()) {
            REG_COUNT = db.lookupIntConstant("REG_COUNT");
            if (VM.getVM().isServerCompiler()) {
                SAVED_ON_ENTRY_REG_COUNT = db.lookupIntConstant("SAVED_ON_ENTRY_REG_COUNT");
                C_SAVED_ON_ENTRY_REG_COUNT = db.lookupIntConstant("C_SAVED_ON_ENTRY_REG_COUNT");
            }
        }
    }

    public OopMapSet(Address addr) {
        super(addr);
    }

    public long getSize() {
        return omCountField.getValue(this.addr);
    }

    public OopMap getMapAt(int index) {
        Address omDataAddr;
        Address oopMapAddr;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(index >= 0 && (long)index <= this.getSize(), "bad index");
        }
        if ((oopMapAddr = (omDataAddr = omDataField.getValue(this.addr)).getAddressAt((long)index * VM.getVM().getAddressSize())) == null) {
            return null;
        }
        return new OopMap(oopMapAddr);
    }

    public OopMap findMapAtOffset(long pcOffset, boolean debugging) {
        int i;
        int len = (int)this.getSize();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(len > 0, "must have pointer maps");
        }
        for (i = 0; i < len && this.getMapAt(i).getOffset() < pcOffset; ++i) {
        }
        if (!debugging) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(i < len, "oopmap not found for pcOffset = " + pcOffset + "; len = " + len);
                Assert.that(this.getMapAt(i).getOffset() == pcOffset, "oopmap not found");
            }
        } else if (i == len) {
            if (DEBUG) {
                System.out.println("can't find oopmap at " + pcOffset);
                System.out.print("Oopmap offsets are [ ");
                for (i = 0; i < len; ++i) {
                    System.out.print(this.getMapAt(i).getOffset());
                }
                System.out.println("]");
            }
            i = len - 1;
            return this.getMapAt(i);
        }
        OopMap m = this.getMapAt(i);
        return m;
    }

    public static void oopsDo(Frame fr, CodeBlob cb, RegisterMap regMap, AddressVisitor oopVisitor, boolean debugging) {
        OopMapSet.allDo(fr, cb, regMap, new MyVisitor(oopVisitor), debugging);
    }

    public static void allDo(Frame fr, CodeBlob cb, RegisterMap regMap, OopMapVisitor visitor, boolean debugging) {
        OopMapValue omv;
        if (Assert.ASSERTS_ENABLED) {
            CodeBlob tmpCB = VM.getVM().getCodeCache().findBlob(fr.getPC());
            Assert.that(tmpCB != null && cb.equals(tmpCB), "wrong codeblob passed in");
        }
        OopMapSet maps = cb.getOopMaps();
        OopMap map = cb.getOopMapForReturnAddress(fr.getPC(), debugging);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "no ptr map found");
        }
        OopMapStream oms = new OopMapStream(map, OopMapValue.OopTypes.DERIVED_OOP_VALUE);
        while (!oms.isDone()) {
            Address loc;
            if (VM.getVM().isClientCompiler()) {
                Assert.that(false, "should not reach here");
            }
            if ((loc = fr.oopMapRegToLocation((omv = oms.getCurrent()).getReg(), regMap)) != null) {
                Address baseLoc = fr.oopMapRegToLocation(omv.getContentReg(), regMap);
                Address derivedLoc = loc;
                visitor.visitDerivedOopLocation(baseLoc, derivedLoc);
            }
            oms.next();
        }
        OopMapValue.OopTypes[] values = new OopMapValue.OopTypes[]{OopMapValue.OopTypes.OOP_VALUE, OopMapValue.OopTypes.VALUE_VALUE, OopMapValue.OopTypes.DEAD_VALUE};
        OopMapStream oms2 = new OopMapStream(map, values);
        while (!oms2.isDone()) {
            omv = oms2.getCurrent();
            Address loc = fr.oopMapRegToLocation(omv.getReg(), regMap);
            if (loc != null) {
                if (omv.getType() == OopMapValue.OopTypes.OOP_VALUE) {
                    visitor.visitOopLocation(loc);
                } else if (omv.getType() == OopMapValue.OopTypes.VALUE_VALUE) {
                    visitor.visitValueLocation(loc);
                } else if (omv.getType() == OopMapValue.OopTypes.DEAD_VALUE) {
                    visitor.visitDeadLocation(loc);
                }
            }
            oms2.next();
        }
    }

    public static void updateRegisterMap(Frame fr, CodeBlob cb, RegisterMap regMap, boolean debugging) {
        OopMapSet maps;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!VM.getVM().isCore(), "non-core builds only");
        }
        if (!VM.getVM().isDebugging()) {
            if (Assert.ASSERTS_ENABLED) {
                maps = cb.getOopMaps();
                Assert.that(maps != null && maps.getSize() > 0L, "found null or empty OopMapSet for CodeBlob");
            }
        } else {
            maps = cb.getOopMaps();
            if (maps == null || maps.getSize() == 0L) {
                return;
            }
        }
        regMap.setIncludeArgumentOops(cb.callerMustGCArguments(regMap.getThread()));
        int nofCallee = 0;
        Address[] locs = new Address[2 * REG_COUNT + 1];
        VMReg[] regs = new VMReg[2 * REG_COUNT + 1];
        OopMap map = cb.getOopMapForReturnAddress(fr.getPC(), debugging);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "no ptr map found");
        }
        OopMapValue omv = null;
        OopMapStream oms = new OopMapStream(map, OopMapValue.OopTypes.CALLEE_SAVED_VALUE);
        while (!oms.isDone()) {
            omv = oms.getCurrent();
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(nofCallee < 2 * REG_COUNT, "overflow");
            }
            regs[nofCallee] = omv.getContentReg();
            locs[nofCallee] = fr.oopMapRegToLocation(omv.getReg(), regMap);
            ++nofCallee;
            oms.next();
        }
        if (Assert.ASSERTS_ENABLED && VM.getVM().isServerCompiler()) {
            Assert.that(!cb.isRuntimeStub() || nofCallee >= SAVED_ON_ENTRY_REG_COUNT || nofCallee >= C_SAVED_ON_ENTRY_REG_COUNT, "must save all");
        }
        for (int i = 0; i < nofCallee; ++i) {
            regMap.setLocation(regs[i], locs[i]);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                OopMapSet.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    private static class MyVisitor
    implements OopMapVisitor {
        private AddressVisitor addressVisitor;

        public MyVisitor(AddressVisitor oopVisitor) {
            this.setAddressVisitor(oopVisitor);
        }

        public void setAddressVisitor(AddressVisitor addressVisitor) {
            this.addressVisitor = addressVisitor;
        }

        public void visitOopLocation(Address oopAddr) {
            this.addressVisitor.visitAddress(oopAddr);
        }

        public void visitDerivedOopLocation(Address baseOopAddr, Address derivedOopAddr) {
            if (VM.getVM().isClientCompiler()) {
                Assert.that(false, "should not reach here");
            } else if (VM.getVM().isServerCompiler() && VM.getVM().useDerivedPointerTable()) {
                Assert.that(false, "FIXME: add derived pointer table");
            }
        }

        public void visitValueLocation(Address valueAddr) {
        }

        public void visitDeadLocation(Address deadAddr) {
        }
    }
}

