/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#ifndef AREAPERIMETERWIDGET_H
#define AREAPERIMETERWIDGET_H

#include <qptrvector.h>

#include <kmtmoduleview.h>

class QLabel;

class KComboBox;
class KLineEdit;


class AreaPerimeterWidget : public ImageModuleView
{
  Q_OBJECT

  public:
    enum Type { Circle, Rectangle, Square };

    AreaPerimeterWidget(Type type, QWidget* parent, const char* name = 0);

    virtual void aboutToActivate( );

  protected slots:
    virtual void slotCalculate( );
    virtual void slotClearInput( );

  private:
    enum Error { ZeroInput, InvalidRect };
    void errorMessage(Error err);
    void rectFields(int item, int& a, int& b);

  private slots:
    void slotItemSelected(int item);
    void slotInputChanged( );

  private:
    Type _type;

    KComboBox* select;
    QPtrVector<QLabel> labels;
    QPtrVector<KLineEdit> inputs;
};

#endif // AREAPERIMETERWIDGET_H
