/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#include <qstringlist.h>

#include <klocale.h>

#include "kmtmodule.h"
#include "kmtmoduleview.h"
#include "kmttreeview.h"


ModuleTreeItem::ModuleTreeItem(QListView* parent, const QString& text)
  : QListViewItem(parent, text), _module(0), _view(0)
{
}

ModuleTreeItem::ModuleTreeItem(QListViewItem* parent, const QString& text)
  : QListViewItem(parent, text), _module(0), _view(0)
{
}


ModuleTreeView::ModuleTreeView(QWidget* parent, const char* name)
  : QListView(parent, name)
{
  setRootIsDecorated(true);
  setResizeMode(QListView::LastColumn);

  addColumn(i18n("Tools"));

  connect(this, SIGNAL(currentChanged(QListViewItem*)),
    this, SLOT(slotItemSelected(QListViewItem*)));
}

void ModuleTreeView::createTreeItems(KMathToolModule* module)
{
  ModuleTreeItem* item;

  ModuleViewList views = module->views( );
  for (ModuleView* v = views.first( ); v; v = views.next( )) {
    ModuleTreeItem* parent = createGroupItems(v->groups( ));
    if (parent)
      item = new ModuleTreeItem(parent, v->name( ));
    else
      item = new ModuleTreeItem(this, v->name( ));
    item->setModule(module);
    item->setModuleView(v);
  }
}

ModuleTreeItem* ModuleTreeView::createGroupItems(const QStringList& groups)
{
  if (groups.isEmpty( ))
    return 0;

  uint i = 0;
  ModuleTreeItem *item = 0, *temp;
  do {
    temp = findChildItem(item, groups[i]);
    if (temp) {
      item = temp;
      i++;
    }
  } while (temp);

  for (uint j = i; j < groups.count( ); j++) {
    if (item)
      item = new ModuleTreeItem(item, groups[j]);
    else
      item = new ModuleTreeItem(this, groups[j]);
  }
  return item;
}

ModuleTreeItem* ModuleTreeView::findChildItem(ModuleTreeItem* parent, const QString& label)
{
  ModuleTreeItem* item;
  if (parent)
    item = static_cast<ModuleTreeItem*>(parent->firstChild( ));
  else
    item = static_cast<ModuleTreeItem*>(this->firstChild( ));

  while (item) {
    if (item->text(0) == label)
      return item;
    item = static_cast<ModuleTreeItem*>(item->nextSibling( ));
  }
  return 0;
}

void ModuleTreeView::slotItemSelected(QListViewItem* item)
{
  ModuleTreeItem* i = static_cast<ModuleTreeItem*>(item);
  KMathToolModule* module = i->module( );
  ModuleView* view = i->view( );
  if (module && view)
    emit signalShowView(module, view);
}

#include "kmttreeview.moc"
