#!/bin/bash

# Return +1 if $k > $v
# Return  0 if $k = $v
# Return -1 if $k < $v
function cmp_kver {
    local kv=$1
    shift
    local vv=$1
    shift

    if [ -z "$kv" -o -z "$vv" ]; then
    	return 0;
    fi

    local k1=`echo $kv | sed -e "s/\([0-9][0-9]*\)\..*/\1/"`
    local k2=`echo $kv | sed -e "s/[^.]*\.\([0-9][0-9]*\)\..*/\1/"`
    local k3=`echo $kv | sed -e "s/[^.]*\.[^.]*\.\([0-9][0-9]*\)/\1/"`
   
    local v1=`echo $vv | sed -e "s/\([0-9][0-9]*\)\..*/\1/"`
    local v2=`echo $vv | sed -e "s/[^.]*\.\([0-9][0-9]*\)\..*/\1/"`
    local v3=`echo $vv | sed -e "s/[^.]*\.[^.]*\.\([0-9][0-9]*\)/\1/"`

    #echo "$k1 $k2 $k3";
    #echo "$v1 $v2 $v3";
    if [ $v1 -lt $k1 ]; then return 1; fi
    if [ $v1 -gt $k1 ]; then return -1; fi
    if [ $v2 -lt $k2 ]; then return 1; fi
    if [ $v2 -gt $k2 ]; then return -1; fi
    if [ $v3 -lt $k3 ]; then return 1; fi
    if [ $v3 -gt $k3 ]; then return -1; fi
    return 0;
}

kver=$1
shift

if [ -z "$kver" ]; then
	echo "Usage: select_fragments [kernel_version]"
	exit 1;
fi

if [ `echo $kver | sed -e '/\([0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*\)/d'` ];
then
    echo "Please give kernel version in form #.#.## eg., 2.4.12";
    exit 2;
fi

k=`echo $kver | sed -e 's|\([0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*\).*|\1|'`;

#cmp_kver $k 2.4.3
best="0.0.0"
for f in fragments-*; do
    if ! [ `echo $f | \
    	sed -e "/fragments-[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*/d"` ]; 
    then
    	v=`echo $f | \
	    sed -e "s|fragments-\([0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*\)|\1|"`
	cmp_kver $k $v; 
	# assign it to ret in case we want to debug
	ret=$?
	#echo $ret
	if [ $ret -ge 0 ]; then
	    #echo "2 - $b $v"
	    cmp_kver $b $v
	    ret=$?
	    #echo $ret
	    if [ -z "$best" -o $ret -le 0 ]; then 
	    	#echo Setting
		best=$f;
		b=$v;
	    fi;
	fi;
    fi;
done

if [ -z "$best" ]; then 
    echo "No Go"
    exit 0;
fi

cat `cat $best | sed -e "s/\#.*//" -e "s/^[[:blank:]]*$//"`

