#
# Tests interaction with Photo product
#

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase

have_photo = ZopeTestCase.hasProduct('Photo')

if have_photo:
    ZopeTestCase.installProduct('ExtFile')
    ZopeTestCase.installProduct('Photo')

from Products.ExtFile.tests.ExtFileTestCase import ExtFileTestCase
from Products.ExtFile.tests.ExtFileTestCase import gifImage
from Acquisition import aq_base

folder_name = ZopeTestCase.folder_name
user_name = ZopeTestCase.user_name
photo_perms = ['Add Photos', 'Change Photos', 'Add Documents, Images, and Files']

import base64
auth_info = 'Basic %s' % base64.encodestring('%s:secret' % user_name)


class TestPhoto(ExtFileTestCase):

    def testAddPhoto(self):
        factory = self.folder.manage_addProduct['Photo']
        factory.manage_addPhoto('foo', '', open(gifImage, 'rb'), 'image/gif', store='ExtImage', engine='PIL', pregen=0)
        self.folder.foo._original._finish()
        self.failUnless(self._exists('foo.gif'))

    def testAddPhotoWithDisplays(self):
        factory = self.folder.manage_addProduct['Photo']
        factory.manage_addPhoto('foo', '', open(gifImage, 'rb'), 'image/gif', store='ExtImage', engine='PIL', pregen=1)
        self.folder.foo._original._finish()
        self.failUnless(self._exists('foo.gif'))

        for id in self.folder.foo.displayIds(None):
            self.folder.foo._photos[id]._finish()
        self.failUnless(self._exists('foo_large.gif'))
        self.failUnless(self._exists('foo_medium.gif'))
        self.failUnless(self._exists('foo_small.gif'))
        self.failUnless(self._exists('foo_thumbnail.gif'))
        self.failUnless(self._exists('foo_xlarge.gif'))
        self.failUnless(self._exists('foo_xsmall.gif'))


class TestPUTPhoto(ExtFileTestCase):

    def afterSetUp(self):
        ExtFileTestCase.afterSetUp(self)

        request = self.app.REQUEST
        request['PARENTS'] = [self.app]

        # Fake a dav PUT request
        request['BODYFILE'] = open(gifImage, 'rb')
        request.environ['CONTENT_TYPE'] = 'image/gif'
        request.environ['REQUEST_METHOD'] = 'PUT'
        request._auth = auth_info
        request.RESPONSE._auth = 1
        request.maybe_webdav_client = 1

    def testPUTPhoto(self):
        # XXX: Photo breaks in Zope 2.7.4 because of changes to NullResource.PUT

        def PUT_factory(name, typ, body):
            """Creates a Photo."""
            from Products.Photo.Photo import Photo
            return Photo(name, '', body, content_type=typ, store='ExtImage', engine='PIL', pregen=0)

        self.folder.PUT_factory = PUT_factory
        self.setPermissions(photo_perms)

        request = self.app.REQUEST
        put = request.traverse('/%s/image' % folder_name)
        put(request, request.RESPONSE)
        self.failUnless(hasattr(aq_base(self.folder), 'image'))
        self.folder.image._original._finish()
        self.failUnless(self._exists('image.gif'))

    def testPUTPhotoWithDisplays(self):
        # XXX: Photo breaks in Zope 2.7.4 because of changes to NullResource.PUT

        def PUT_factory(name, typ, body):
            """Creates a Photo."""
            from Products.Photo.Photo import Photo
            return Photo(name, '', body, content_type=typ, store='ExtImage', engine='PIL', pregen=1)

        self.folder.PUT_factory = PUT_factory
        self.setPermissions(photo_perms)

        request = self.app.REQUEST
        put = request.traverse('/%s/image' % folder_name)
        put(request, request.RESPONSE)
        self.failUnless(hasattr(aq_base(self.folder), 'image'))
        self.folder.image._original._finish()
        self.failUnless(self._exists('image.gif'))

        for id in self.folder.image.displayIds(None):
            self.folder.image._photos[id]._finish()
        self.failUnless(self._exists('image_large.gif'))
        self.failUnless(self._exists('image_medium.gif'))
        self.failUnless(self._exists('image_small.gif'))
        self.failUnless(self._exists('image_thumbnail.gif'))
        self.failUnless(self._exists('image_xlarge.gif'))
        self.failUnless(self._exists('image_xsmall.gif'))


def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    if have_photo:
        suite.addTest(makeSuite(TestPhoto))
        suite.addTest(makeSuite(TestPUTPhoto))
    return suite

if __name__ == '__main__':
    framework()

