from Acquisition import aq_base

import Products.Archetypes.Field as field
from Products.Archetypes.Field import ObjectField, encode, decode

def get(self, instance, **kwargs):
    value = ObjectField.get(self, instance, **kwargs)
    if not getattr(self, 'raw', False):
        value = encode(value, instance, **kwargs)
    return value

def set(self, instance, value, **kwargs):
    kwargs['field'] = self
    # Remove acquisition wrappers
    value = aq_base(value)
    if not getattr(self, 'raw', False):
        value = decode(value, instance, **kwargs)
    self.getStorage(instance).set(self.getName(), instance, value, **kwargs)

field.StringField.get = get
field.StringField.set = set
