############################################################################
#                                                                          #
#             copyright (c) 2004 ITB, Humboldt-University Berlin           #
#             written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                          #
############################################################################

"""RISParser class (Research Information Systems/Reference Manager)"""

# Python stuff
import os

# Zope stuff
from Globals import InitializeClass
from App.Dialogs import MessageDialog

# Bibliography stuff
from Products.CMFBibliographyAT.tool.parsers.base \
     import IBibliographyParser, BibliographyParser

try:
    import _bibtex
    from Products.CMFBibliographyAT.tool.parsers.pyblbibtex \
         import PyBlBibtexParser as BaseParser
except ImportError:
    from Products.CMFBibliographyAT.tool.parsers.bibtex \
         import BibtexParser as BaseParser


class RISParser(BaseParser):
    """
    specific parser to process input in RIS format
    (Research Information Systems/Reference Manager)
    """

    __implements__ = (IBibliographyParser ,)

    meta_type = "RIS Parser"

    format = {'name':'RIS',
              'extension':'ris'}

    def __init__(self,
                 id = 'ris',
                 title = "RIS format parser"
                 ):
        """
        initializes including the regular expression patterns
        """
        BaseParser.__init__(self, id=id, title=title)   

    # Here we need to provide 'checkFormat' and 'preprocess'

    def checkFormat(self, source):
        """
        is this RIS format?
        (Research Information Systems/Reference Manager)
        """
        teststring = source[:200].lower()
        ai = teststring.find('AU ')
        ei = teststring.find('TI ')
        di = teststring.find('PY ')
        if ai + ei + di > -2:
            return 1
        else:
            return 0

    def preprocess(self, source):
        """
        convert RIS to BibTeX
        """
        # open a pipe
        (fi, fo, fe) = os.popen3('ris2xml | xml2bib ', 't')
        # provide the input
        fi.write(source)
        fi.close()
        # get the output
        bibtex = fo.read()
        fo.close()
        # get the staus/error message
        # (this isn't used but we don't want it in the output)
        error = fe.read()
        fe.close()
        # done
        return bibtex

    # all the rest we inherit from our parent BibTeX(!) parser

 # Class instanciation
InitializeClass(RISParser)

   
def manage_addRISParser(self, REQUEST=None):
    """ """
    try:
        self._setObject('ris', RISParser())
    except:
        return MessageDialog(
            title='Bibliography tool warning message',
            message='The parser you attempted to add already exists.',
            action='manage_main')    
    return self.manage_main(self, REQUEST)
