package Zim::GUI::NotebookDialog;

use strict;
use File::BaseDir 0.03 qw/config_home config_files/;
use Zim::Utils;
use Zim::GUI::Component;

our $VERSION = '0.23';
our @ISA = qw/Zim::GUI::Component/;

=head1 NAME

Zim::GUI::NotebookDialog - Chooser dialog with notebooks

=head1 DESCRIPTION

FIXME descriptve text

=head1 METHODS

=over 4

=cut

sub init {
	my $self = shift;
	$self->{app} || $self;
}

=item C<show(CALLBACK)>

Constructs a new dialog.

If CALLBACK is specified it will be called to open a notebook,
else a new instance of zim is started.

=cut

sub show {
	my $self = shift;
	my $cb = shift;

	my $dialog = Gtk2::Dialog->new(
		__("Open notebook"), undef, #. dialog title
	       	[qw/destroy-with-parent no-separator/],
		'gtk-help'   => 'help',
		'gtk-cancel' => 'cancel',
		'gtk-open'   => 'ok',
	);
	#$dialog->set_type_hint('utility');
	$dialog->set_default_size(100,250);
	$dialog->set_border_width(5);
	$dialog->set_icon(
		Gtk2::Gdk::Pixbuf->new_from_file($Zim::ICON) );
			# defined in Component.pm
	$dialog->set_default_response('ok');

	unless ($self->{app}{window}) { # no parent
		$self->{on_top} = 1;
		$self->{app}{window} = $dialog;
	}
	
	$dialog->vbox->set_spacing(5);
	$dialog->vbox->pack_start(
		Gtk2::Label->new(__('Please choose a notebook')), 0,1,0 );
	
	my $hbox = Gtk2::HBox->new(0, 12);
	$dialog->vbox->add($hbox);
	
	my $list = Gtk2::SimpleList->new('Notebook' => 'text');
	$list->set_headers_visible(0);
	$list->get_selection->set_mode('browse');
	$list->signal_connect(
		row_activated => sub { $dialog->response('ok') });
	$hbox->add($list);
	
	# load list
	my ($source, $order) = ({}, []);
	my $file = config_files('zim', 'notebooks.list');
	$file ||= config_files('zim', 'repositories.list');
		# backwards compatibility to versions < 0.23
	if (defined $file) {
		$file = Zim::File->new($file);
		($source, $order) = $file->read_config;
		@$order = grep {! /^_/} @$order;
		@{$list->{data}} = @$order;
		$self->{default} = $$source{_default_};
	}
	
	my $vbox1 = Gtk2::VBox->new(0,0);
	$hbox->pack_start($vbox1, 0,0,0);

	my $vbox = Gtk2::VButtonBox->new();
	$vbox->set_layout('start');
	$vbox1->pack_start($vbox, 0,0,0);
	
	my @buttons = map Gtk2::Button->new_from_stock($_),
		qw/gtk-add gtk-remove/;
	splice @buttons, 1, 0, $self->new_button(
		'gtk-properties', __('Cha_nge')); #. button
	$vbox->add($_) for @buttons;
	
	my $modified = 0;
	my $modify = sub {
		my ($i, $name, $dir);
		if (pop @_) { #boolean user data
			($i) = $list->get_selected_indices;
			($name) = @{$list->{data}[$i]};
			$dir = $$source{$name};
		}
		else { $i = scalar @{$list->{data}} }
		($name, $dir) = $self->prompt_new_notebook($name, $dir);
		return unless defined $name;
		$$source{$name} = $dir;
		splice @{$list->{data}}, $i, 1, $name;
		$modified = 1;
		$list->select($i);
	};
	$buttons[0]->signal_connect(clicked => $modify, 0);
	$buttons[1]->signal_connect(clicked => $modify, 1);
	$buttons[2]->signal_connect(clicked => sub {
			my ($i) = $list->get_selected_indices;
			splice @{$list->{data}}, $i, 1;
			$modified = 1;
		} );
	
	my $default_button = $self->new_button(
		'gtk-home', __('Set _Default') ); #. button
	$vbox1->pack_end($default_button, 0,0,0);
	$default_button->signal_connect(
			clicked => sub {$self->prompt_default; $modified = 1} );

	$dialog->signal_connect(response => sub {
		my ($dialog, $response) = @_;
		
		# Save list
		if ($modified) {
			@$order = ('_default_', map $$_[0], @{$list->{data}});
			$$source{_default_} = $self->{default};
			$file = Zim::File->new(
				config_home('zim', 'notebooks.list') );
			$file->write_config($source, $order);
		}

		if ($response eq 'help') {
			return $self->ShowHelp('zim:usage:notebooks');
		}
		elsif ($response ne 'ok') {
			$dialog->destroy;
			Gtk2->main_quit if $self->{on_top};
			return;
		}

		my ($i) = (@{$list->{data}} == 1)
			? (0) : ($list->get_selected_indices);
		return $self->error_dialog(
			__("Please select a notebook first.") ) #. error
			unless defined $i;
	
		my ($name) = @{$list->{data}[$i]};
		my $src = Zim::File->abs_path($$source{$name}, $ENV{HOME});
		return $self->error_dialog(
			__("No such directory: {name}", name => $src) ) #. error
			unless -d $src;
		if ($cb) { $cb->($name, $src)                            }
		else     { $self->exec_new_window('--name', $name, $src) }
		$dialog->destroy;
	} );
	
	$dialog->show_all;
}

=item C<prompt_new_notebook(NAME, DIR)>

=cut

sub prompt_new_notebook {
	my $self = shift;
	my $val = $self->run_prompt(
		__('New notebook'), #. dialog title
		['name', 'dir'], {
			name => [__('Name'), 'string', $_[0]], #. input
			dir  => [__('Directory'), 'dir', $_[1]], #. input
		}, undef, undef,
		'<i>'.__("Please give a directory to store your pages.\nFor a new notebook this should be an empty directory.\nFor example a \"Notes\" directory in your home dir.").'</i>' )
		or return undef;
	
	my ($name, $dir) = @$val;
	return undef unless $dir =~ /\S/;
	$name = $dir unless $name =~ /\S/;
	
	return ($name, $dir);
}

=item C<prompt_default()>

Ask for default notebook.

=cut

sub prompt_default {
	my $self = shift;
	my $val = $self->run_prompt(
		__('Set default notebook'), #. dialog title
		['root'], {
			root => [__('Notebook'), 'notebook', $self->{default}] #. input
		}, undef, undef,
		'<i>'.__("Please select a default notebook here").'</i>' )
		or return undef;
	$self->{default} = $$val[0];
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2007 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

