use strict;

# This file gives a template for a simple plugin
# that adds just one function to the Tools menu.

=head1 NAME

[Name of this plugin]

=head1 VERSION

[Version number]

=head1 DESCRIPTION

[Description]

=head1 AUTHOR

[Name and email of the author]

Copyright (c) [year] [Name author]. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut

my $app  = Zim::GUI->current;

# Specify properties for the menu item
$app->{actions}->add_actions( [
	[	'MenuAction',		# Name - used below in xml
		'gtk-open',		# Stock icon name
		'Do action',		# Menu text
		undef,			# Keybinding
		'Do some action',	# Tooltip text
		\&on_MenuAction,	# Callback code
	],
] );

# Specify the menu layout
$app->{ui}->add_ui_from_string( q{
<ui>
	<menubar name='MenuBar'>
		<menu action='ToolsMenu'>
			<menuitem action='MenuAction'/>
		</menu>
	</menubar>
</ui> } );

# Functionality goes below
#
# The functions on_MenuAction is called when the menu
# item is activated.

sub on_MenuAction {
	print "Some action triggered !\n";
}

