/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGridGUI.Application.Editor;
import IceGridGUI.Utils;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class MapField
extends JTable {
    private final int _vectorSize;
    private DefaultTableModel _model;
    private Vector _columnNames;
    private boolean _editable = false;
    private boolean _substituteKey;
    private Editor _editor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MapField(Editor editor, String headKey, String[] headValues, boolean substituteKey) {
        this._editor = editor;
        this._substituteKey = substituteKey;
        this._vectorSize = headValues.length + 1;
        this._columnNames = new Vector(this._vectorSize);
        this._columnNames.add(headKey);
        for (int i = 0; i < headValues.length; ++i) {
            this._columnNames.add(headValues[i]);
        }
        if (!$assertionsDisabled && this._vectorSize < 2) {
            throw new AssertionError();
        }
        AbstractAction deleteRow = new AbstractAction("Delete selected row(s)"){

            public void actionPerformed(ActionEvent e) {
                if (MapField.this._editable) {
                    int selectedRow;
                    if (MapField.this.isEditing()) {
                        MapField.this.getCellEditor().stopCellEditing();
                    }
                    while ((selectedRow = MapField.this.getSelectedRow()) != -1) {
                        MapField.this._model.removeRow(selectedRow);
                    }
                }
            }
        };
        this.getActionMap().put("delete", deleteRow);
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
    }

    public MapField(Editor editor, String headKey, String headValue, boolean substituteKey) {
        this(editor, headKey, new String[]{headValue}, substituteKey);
    }

    public void set(Map map, Utils.Resolver resolver, boolean editable) {
        this._editable = editable;
        Vector vector = new Vector(map.size());
        Iterator p = map.entrySet().iterator();
        while (p.hasNext()) {
            Vector<String> row = new Vector<String>(this._vectorSize);
            Map.Entry entry = p.next();
            if (this._substituteKey) {
                row.add(Utils.substitute((String)entry.getKey(), resolver));
            } else {
                row.add((String)entry.getKey());
            }
            if (this._vectorSize == 2) {
                row.add(Utils.substitute((String)entry.getValue(), resolver));
            } else {
                String[] val = (String[])entry.getValue();
                for (int i = 0; i < val.length; ++i) {
                    row.add(Utils.substitute(val[i], resolver));
                }
            }
            vector.add(row);
        }
        if (this._editable) {
            Vector<String> newRow = new Vector<String>(this._vectorSize);
            for (int i = 0; i < this._vectorSize; ++i) {
                newRow.add("");
            }
            vector.add(newRow);
        }
        this._model = new DefaultTableModel(vector, this._columnNames){

            public boolean isCellEditable(int row, int column) {
                return MapField.this._editable;
            }
        };
        this._model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (MapField.this._editable) {
                    Object lastKey = MapField.this._model.getValueAt(MapField.this._model.getRowCount() - 1, 0);
                    if (lastKey != null && !lastKey.equals("")) {
                        Object[] emptyRow = new Object[MapField.this._vectorSize];
                        for (int i = 0; i < MapField.this._vectorSize; ++i) {
                            emptyRow[i] = "";
                        }
                        MapField.this._model.addRow(emptyRow);
                    }
                    MapField.this._editor.updated();
                }
            }
        });
        this.setModel(this._model);
        this.setCellSelectionEnabled(this._editable);
        this.setOpaque(this._editable);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(this._editable);
    }

    public TreeMap get() {
        if (!$assertionsDisabled && !this._editable) {
            throw new AssertionError();
        }
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        Vector<Vector> vector = this._model.getDataVector();
        TreeMap<String, String[]> result = new TreeMap<String, String[]>();
        Iterator<Vector> p = vector.iterator();
        while (p.hasNext()) {
            Object val;
            Vector row = p.next();
            String key = (String)row.elementAt(0);
            if (key == null || (key = key.trim()).equals("")) continue;
            if (this._vectorSize == 2) {
                val = (String[])row.elementAt(1);
                if (val == null) {
                    val = "";
                }
                result.put(key, (String[])val);
                continue;
            }
            val = new String[this._vectorSize - 1];
            for (int i = 1; i < this._vectorSize; ++i) {
                val[i - 1] = (String)row.elementAt(i);
                if (val[i - 1] != null) continue;
                val[i - 1] = "";
            }
            result.put(key, (String[])val);
        }
        return result;
    }

    static {
        $assertionsDisabled = !MapField.class.desiredAssertionStatus();
    }
}

