Name: zbar
Summary: bar code scanning and decoding
Version: 0.8
Release: 1
License: LGPL
Group: Development/Libraries
URL: http://zbar.sourceforge.net
Packager: Vit Hrachovy <fangorn34@users.sourceforge.net>
Source: zbar-%{version}.tar.gz
Requires: ImageMagick-c++
BuildPreReq: pkgconfig, libX11-devel, python-devel, gtk2-devel, pygtk2-devel, qt-devel >= 4, ImageMagick-c++-devel
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

%description
The ZBar Bar Code Reader is a library for scanning and decoding bar
codes from various sources such as video streams, image files or raw
intensity sensors.  It supports EAN, UPC, Code 128, Code 39 and
Interleaved 2 of 5. The flexible, layered architecture features a
fast, streaming interface with a minimal memory footprint.

%package devel
Group: Development/Libraries
Summary: bar code library extra development files
Requires: %{name} = %{version}

%description devel
The ZBar Bar Code Reader is a library for scanning and decoding bar
codes from various sources such as video streams, image files or raw
intensity sensors.  It supports EAN, UPC, Code 128, Code 39 and
Interleaved 2 of 5. The flexible, layered architecture features a
fast, streaming interface with a minimal memory footprint.

This package contains header files and additional libraries used for
developing applications that read bar codes with this library.

%package gtk
Group: Development/Libraries
Summary: bar code reader GTK widget
Requires: %{name} = %{version}, gtk2

%description gtk
The ZBar Bar Code Reader is a library for scanning and decoding bar
codes from various sources such as video streams, image files or raw
intensity sensors.  It supports EAN, UPC, Code 128, Code 39 and
Interleaved 2 of 5. The flexible, layered architecture features a
fast, streaming interface with a minimal memory footprint.

This package contains a bar code scanning widget for use with GUI
applications based on GTK+-2.0.

%package gtk-devel
Group: Development/Libraries
Summary: bar code reader GTK widget extra development files
Requires: %{name}-gtk = %{version}, %{name}-devel = %{version}, gtk2-devel

%description gtk-devel
The ZBar Bar Code Reader is a library for scanning and decoding bar
codes from various sources such as video streams, image files or raw
intensity sensors.  It supports EAN, UPC, Code 128, Code 39 and
Interleaved 2 of 5. The flexible, layered architecture features a
fast, streaming interface with a minimal memory footprint.

This package contains header files and additional libraries used for
developing GUI applications based on GTK+-2.0 that include a bar code
scanning widget.

%package pygtk
Group: Development/Libraries
Summary: bar code reader PyGTK widget
Requires: %{name} = %{version}, pygtk2

%description pygtk
The ZBar Bar Code Reader is a library for scanning and decoding bar
codes from various sources such as video streams, image files or raw
intensity sensors.  It supports EAN, UPC, Code 128, Code 39 and
Interleaved 2 of 5. The flexible, layered architecture features a
fast, streaming interface with a minimal memory footprint.

This package contains a bar code scanning widget for use in GUI
applications based on PyGTK.

%package qt
Group: Development/Libraries
Summary: bar code reader Qt widget
Requires: %{name} = %{version}, qt >= 4

%description qt
The ZBar Bar Code Reader is a library for scanning and decoding bar
codes from various sources such as video streams, image files or raw
intensity sensors.  It supports EAN, UPC, Code 128, Code 39 and
Interleaved 2 of 5. The flexible, layered architecture features a
fast, streaming interface with a minimal memory footprint.

This package contains a bar code scanning widget for use with GUI
applications based on Qt4.

%package qt-devel
Group: Development/Libraries
Summary: bar code reader Qt widget extra development files
Requires: %{name}-qt = %{version}, %{name}-devel = %{version}, qt-devel >= 4

%description qt-devel
The ZBar Bar Code Reader is a library for scanning and decoding bar
codes from various sources such as video streams, image files or raw
intensity sensors.  It supports EAN, UPC, Code 128, Code 39 and
Interleaved 2 of 5. The flexible, layered architecture features a
fast, streaming interface with a minimal memory footprint.

This package contains header files and additional libraries used for
developing GUI applications based on Qt4 that include a bar code
scanning widget.

%prep
%setup -q -n zbar-%{version}

%build
./configure --host=%{_host} --build=%{_build} \
  CFLAGS="${CFLAGS:-%optflags}" \
  CXXFLAGS="${CXXFLAGS:-%optflags}" \
  --prefix=$RPM_BUILD_ROOT/%{_prefix} \
  --docdir=$RPM_BUILD_ROOT/%{_docdir}/%{name}-%{version}
make

%install
rm -rf $RPM_BUILD_ROOT
make install

%clean
rm -rf $RPM_BUILD_ROOT

%post
ldconfig

%postun
ldconfig

%files
%defattr(-,root,root)
%{_bindir}/zbarimg
%{_bindir}/zbarcam
%{_libdir}/libzbar.so.*
%{_datadir}/man/man1/*
%doc %{_docdir}/%{name}-%{version}/COPYING.LIB
%doc %{_docdir}/%{name}-%{version}/HACKING
%doc %{_docdir}/%{name}-%{version}/INSTALL
%doc %{_docdir}/%{name}-%{version}/NEWS
%doc %{_docdir}/%{name}-%{version}/README
%doc %{_docdir}/%{name}-%{version}/TODO

%files devel
%defattr(-,root,root)
%{_libdir}/libzbar.la
%{_libdir}/libzbar.a
%{_libdir}/libzbar.so
%{_libdir}/pkgconfig/zbar.pc
%{_includedir}/zbar.h
%{_includedir}/zbar/Exception.h
%{_includedir}/zbar/Symbol.h
%{_includedir}/zbar/Image.h
%{_includedir}/zbar/Scanner.h
%{_includedir}/zbar/Decoder.h
%{_includedir}/zbar/ImageScanner.h
%{_includedir}/zbar/Video.h
%{_includedir}/zbar/Window.h
%{_includedir}/zbar/Processor.h

%files gtk
%defattr(-,root,root)
%{_libdir}/libzbargtk.so.*

%files gtk-devel
%defattr(-,root,root)
%{_libdir}/libzbargtk.la
%{_libdir}/libzbargtk.a
%{_libdir}/libzbargtk.so
%{_libdir}/pkgconfig/zbar-gtk.pc
%{_includedir}/zbar/zbargtk.h

%files pygtk
%defattr(-,root,root)
%{_libdir}/python*

%files qt
%defattr(-,root,root)
%{_libdir}/libzbarqt.so.*

%files qt-devel
%defattr(-,root,root)
%{_libdir}/libzbarqt.la
%{_libdir}/libzbarqt.a
%{_libdir}/libzbarqt.so
%{_libdir}/pkgconfig/zbar-qt.pc
%{_includedir}/zbar/QZBar*.h

%changelog
* Thu Apr 21 2009 spadix <spadix@users.sourceforge.net>
- version 0.7 project name change

* Thu Jul 24 2008 spadix <spadix@users.sourceforge.net>
- version 0.5 updates (new widget packages)

* Sat May 31 2008 spadix <spadix@users.sourceforge.net>
- version 0.4 updates (description and library version)

* Tue Feb 19 2008 spadix <spadix@users.sourceforge.net>
- version 0.3 updates (dependencies and files)

* Fri Jun 08 2007 spadix <spadix@users.sourceforge.net>
- first release

* Tue May 22 2007 Vt Hrachov <fangorn34@users.sourceforge.net>
- Initial draft
