/*  
	Copyright (C) 2006 Salvatore Scarciglia <laas.mono@gmail.com>
	http://laas.altervista.org

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This code is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

using Gtk;
using System;
using System.Runtime.InteropServices;

public class YTTrayIcon {
 	private ImageMenuItem 	menuPopup1;
 	private ImageMenuItem 	menuPopup2;
 	private ImageMenuItem 	menuPopup3;
 	private Window			mainWin;
 	private ytApp			yta;
 	public 	bool			mainWinOnScreen;
	
	public YTTrayIcon(Window mwin,ytApp y) {
		mainWin = mwin;
		yta = y;
		EventBox eb = new EventBox();
		//eb.Add(new Image(new Gdk.Pixbuf(null,"yTicon.png",16,16))); // Gtk# 2.4 
		eb.Add(new Image((new Gdk.Pixbuf(null,"yTicon.png")).ScaleSimple(16,16,0)));
		eb.ButtonPressEvent += new ButtonPressEventHandler (this.OnImageClick);
		TrayIcon icon = new TrayIcon("YouTranslate!");
		mainWinOnScreen = true;
		icon.Add(eb);
		icon.ShowAll();
	}
	
	private void OnImageClick (object o, ButtonPressEventArgs args) {
   		if (args.Event.Button == 1) {
   			mainWinOnScreen = true;
   			mainWin.Visible = true;
   			
   		}
   		else if (args.Event.Button == 3) {
      		Menu popupMenu = new Menu(); 
      		menuPopup1 = new ImageMenuItem ("Restore");
      		menuPopup2 = new ImageMenuItem ("Preferences");
      		menuPopup3 = new ImageMenuItem ("Quit");
      		
      		Image appimg1 = new Image(Stock.Home, IconSize.Menu);
      		Image appimg2 = new Image(Stock.Preferences, IconSize.Menu);
      		Image appimg3 = new Image(Stock.Quit, IconSize.Menu);
      		menuPopup1.Image = appimg1; 
      		menuPopup2.Image = appimg2;
      		menuPopup3.Image = appimg3;
      		
      		popupMenu.Add(menuPopup1); 
      		popupMenu.Add(menuPopup2); 
      		popupMenu.Add(menuPopup3); 
      		
      		menuPopup1.Activated += new EventHandler(this.OnPopupClick);
      		menuPopup2.Activated += new EventHandler(this.OnPopupClick);
      		menuPopup3.Activated += new EventHandler(this.OnPopupClick);
			
			if(mainWinOnScreen==true) {
				menuPopup1.Sensitive = false;
				menuPopup2.Sensitive = false;
			}			
												
			popupMenu.ShowAll(); 

      		//popupMenu.Popup(null, null, null, args.Event.Button, args.Event.Time);
      		popupMenu.Popup(null, null, null, IntPtr.Zero, args.Event.Button, args.Event.Time); 
   		}
	}
	
	private void OnPopupClick(object o, EventArgs args) {
		ImageMenuItem sender = (ImageMenuItem) o;  
		if(sender==menuPopup1) {
			mainWinOnScreen = true;
			mainWin.Visible = true;
		}
		else if(sender==menuPopup2) {
			yta.showPrefs();
		}
		else if(sender==menuPopup3) {
			yta.savePrefs();
			Application.Quit();
		}
	}
	
}