/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _HTTP_H
#define _HTTP_H

typedef struct {
	char *key, *value;
} ValuePair;

#define HTTP_SERVER_RETURN_VALUE_CONTINUE                      (100)
#define HTTP_SERVER_RETURN_VALUE_SWITCHING_PROTOCOLS           (101)
#define HTTP_SERVER_RETURN_VALUE_OK                            (200)
#define HTTP_SERVER_RETURN_VALUE_CREATED                       (201)
#define HTTP_SERVER_RETURN_VALUE_ACCEPTED                      (202)
#define HTTP_SERVER_RETURN_VALUE_NONAUTH_INFO                  (203)
#define HTTP_SERVER_RETURN_VALUE_NO_CONTENT                    (204)
#define HTTP_SERVER_RETURN_VALUE_RESET_CONTENT                 (205)
#define HTTP_SERVER_RETURN_VALUE_PARTIAL_CONTENT               (206)
#define HTTP_SERVER_RETURN_VALUE_MULTIPLE_CHOICES              (300)
#define HTTP_SERVER_RETURN_VALUE_MOVED_PERMANENTLY             (301)
#define HTTP_SERVER_RETURN_VALUE_FOUND                         (302)
#define HTTP_SERVER_RETURN_VALUE_SEE_OTHER                     (303)
#define HTTP_SERVER_RETURN_VALUE_NOT_MODIFIED                  (304)
#define HTTP_SERVER_RETURN_VALUE_USE_PROXY                     (305)
#define HTTP_SERVER_RETURN_VALUE_TEMPORARY_REDIRECT            (307)
#define HTTP_SERVER_RETURN_VALUE_BAD_REQUEST                   (400)
#define HTTP_SERVER_RETURN_VALUE_UNAUTHORIZED                  (401)
#define HTTP_SERVER_RETURN_VALUE_FORBIDDEN                     (403)
#define HTTP_SERVER_RETURN_VALUE_NOT_FOUND                     (404)
#define HTTP_SERVER_RETURN_VALUE_METHOD_NOT_ALLOWED            (405)
#define HTTP_SERVER_RETURN_VALUE_NOT_ACCEPTABLE                (406)
#define HTTP_SERVER_RETURN_VALUE_PROXY_AUTH_REQUIRED           (407)
#define HTTP_SERVER_RETURN_VALUE_REQUEST_TIMEOUT               (408)
#define HTTP_SERVER_RETURN_VALUE_CONFLICT                      (409)
#define HTTP_SERVER_RETURN_VALUE_GONE                          (410)
#define HTTP_SERVER_RETURN_VALUE_LENGTH_REQUIRED               (411)
#define HTTP_SERVER_RETURN_VALUE_PRECONDITION_FAILED           (412)
#define HTTP_SERVER_RETURN_VALUE_REQUEST_ENTITY_TOO_LARGE      (413)
#define HTTP_SERVER_RETURN_VALUE_REQUEST_URI_TOO_LONG          (414)
#define HTTP_SERVER_RETURN_VALUE_UNSUPPORTED_MEDIA_TYPE        (415)
#define HTTP_SERVER_RETURN_VALUE_REQUEST_RANGE_NOT_SATISFIABLE (416)
#define HTTP_SERVER_RETURN_VALUE_EXPECTATION_FAILED            (417)
#define HTTP_SERVER_RETURN_VALUE_INTERNAL_SERVER_ERROR         (500)
#define HTTP_SERVER_RETURN_VALUE_NOT_IMPLEMENTED               (501)
#define HTTP_SERVER_RETURN_VALUE_BAD_GATEWAY                   (502)
#define HTTP_SERVER_RETURN_VALUE_SERVICE_UNAVAILABLE           (503)
#define HTTP_SERVER_RETURN_VALUE_GATEWAY_TIMEOUT               (504)
#define HTTP_SERVER_RETURN_VALUE_VERSION_NOT_SUPPORTED         (505)

extern int http_get(char *server, char *path, ValuePair form[], char *cookies[], int *);

#endif
