/* Generated by re2c 0.9.1-C on Wed Jul 12 20:29:42 2006
 */
#line 1 "./modules/parsers/gas/gas-token.re"
/*
 * GAS-compatible re2c lexer
 *
 *  Copyright (C) 2005  Peter Johnson
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND OTHER CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR OTHER CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#include <util.h>
RCSID("$Id: gas-token.re 1591 2006-07-13 03:25:38Z peter $");

#define YASM_LIB_INTERNAL
#include <libyasm.h>

#include "modules/parsers/gas/gas-parser.h"
#include "modules/parsers/gas/gas-defs.h"


#define BSIZE	8192

#define YYCURSOR	cursor
#define YYLIMIT		(s->lim)
#define YYMARKER	(s->ptr)
#define YYFILL(n)	{cursor = fill(parser_gas, cursor);}

#define RETURN(i)	{s->cur = cursor; return i;}

#define SCANINIT()	{ \
	s->tchar = cursor - s->pos; \
	s->tline = s->cline; \
	s->tok = cursor; \
    }

#define TOK		((char *)s->tok)
#define TOKLEN		(size_t)(cursor-s->tok)

static size_t
rept_input(yasm_parser_gas *parser_gas, /*@out@*/ YYCTYPE *buf,
	   size_t max_size)
{
    gas_rept *rept = parser_gas->rept;
    size_t numleft = max_size;
    YYCTYPE *bufp = buf;

    /* If numrept is 0, copy out just the line end characters */
    if (rept->numrept == 0) {
	/* Skip first line, which contains .line */
	rept->line = STAILQ_NEXT(rept->line, link);
	if (!rept->line) {
	    rept->numrept = 1;
	    rept->numdone = 1;
	}
	while (rept->numrept == 0 && numleft > 0) {
	    *bufp++ = rept->line->data[rept->line->len-1];
	    rept->line = STAILQ_NEXT(rept->line, link);
	    if (!rept->line) {
		rept->numrept = 1;
		rept->numdone = 1;
	    }
	}
    }

    /* Copy out the previous fill buffer until we're *really* done */
    if (rept->numdone == rept->numrept) {
	size_t numcopy = rept->oldbuflen - rept->oldbufpos;
	if (numcopy > numleft)
	    numcopy = numleft;
	memcpy(bufp, &rept->oldbuf[rept->oldbufpos], numcopy);
	numleft -= numcopy;
	bufp += numcopy;
	rept->oldbufpos += numcopy;

	if (rept->oldbufpos == rept->oldbuflen) {
	    /* Delete lines, then delete rept and clear rept state */
	    gas_rept_line *cur, *next;
	    cur = STAILQ_FIRST(&rept->lines);
	    while (cur) {
		next = STAILQ_NEXT(cur, link);
		yasm_xfree(cur->data);
		yasm_xfree(cur);
		cur = next;
	    }
	    yasm_xfree(rept->oldbuf);
	    yasm_xfree(rept);
	    parser_gas->rept = NULL;
	}
    }

    while (numleft > 0 && rept->numdone < rept->numrept) {
	/* Copy from line data to buf */
	size_t numcopy = rept->line->len - rept->linepos;
	if (numcopy > numleft)
	    numcopy = numleft;
	memcpy(bufp, &rept->line->data[rept->linepos], numcopy);
	numleft -= numcopy;
	bufp += numcopy;
	rept->linepos += numcopy;

	/* Update locations if needed */
	if (rept->linepos == rept->line->len) {
	    rept->line = STAILQ_NEXT(rept->line, link);
	    rept->linepos = 0;
	}
	if (rept->line == NULL) {
	    rept->numdone++;
	    rept->line = STAILQ_FIRST(&rept->lines);
	}
    }

    return (max_size-numleft);
}

static YYCTYPE *
fill(yasm_parser_gas *parser_gas, YYCTYPE *cursor)
{
    Scanner *s = &parser_gas->s;
    int first = 0;
    if(!s->eof){
	size_t cnt = s->tok - s->bot;
	if(cnt){
	    memmove(s->bot, s->tok, (size_t)(s->lim - s->tok));
	    s->tok = s->bot;
	    s->ptr -= cnt;
	    cursor -= cnt;
	    s->pos -= cnt;
	    s->lim -= cnt;
	}
	if (!s->bot)
	    first = 1;
	if((s->top - s->lim) < BSIZE){
	    YYCTYPE *buf = yasm_xmalloc((size_t)(s->lim - s->bot) + BSIZE);
	    memcpy(buf, s->tok, (size_t)(s->lim - s->tok));
	    s->tok = buf;
	    s->ptr = &buf[s->ptr - s->bot];
	    cursor = &buf[cursor - s->bot];
	    s->pos = &buf[s->pos - s->bot];
	    s->lim = &buf[s->lim - s->bot];
	    s->top = &s->lim[BSIZE];
	    if (s->bot)
		yasm_xfree(s->bot);
	    s->bot = buf;
	}
	if (parser_gas->rept && parser_gas->rept->ended) {
	    /* Pull from rept lines instead of preproc */
	    cnt = rept_input(parser_gas, s->lim, BSIZE);
	} else if((cnt = yasm_preproc_input(parser_gas->preproc,
					    (char *)s->lim, BSIZE)) == 0) {
	    s->eof = &s->lim[cnt]; *s->eof++ = '\n';
	}
	s->lim += cnt;
	if (first && parser_gas->save_input) {
	    int i;
	    YYCTYPE *saveline;
	    parser_gas->save_last ^= 1;
	    saveline = parser_gas->save_line[parser_gas->save_last];
	    /* save next line into cur_line */
	    for (i=0; i<79 && &s->tok[i] < s->lim && s->tok[i] != '\n'; i++)
		saveline[i] = s->tok[i];
	    saveline[i] = '\0';
	}
    }
    return cursor;
}

static YYCTYPE *
save_line(yasm_parser_gas *parser_gas, YYCTYPE *cursor)
{
    Scanner *s = &parser_gas->s;
    int i = 0;
    YYCTYPE *saveline;

    parser_gas->save_last ^= 1;
    saveline = parser_gas->save_line[parser_gas->save_last];

    /* save next line into cur_line */
    if ((YYLIMIT - YYCURSOR) < 80)
	YYFILL(80);
    for (i=0; i<79 && &cursor[i] < s->lim && cursor[i] != '\n'; i++)
	saveline[i] = cursor[i];
    saveline[i] = '\0';
    return cursor;
}

void
gas_parser_cleanup(yasm_parser_gas *parser_gas)
{
    if (parser_gas->s.bot)
	yasm_xfree(parser_gas->s.bot);
}

/* starting size of string buffer */
#define STRBUF_ALLOC_SIZE	128

/* string buffer used when parsing strings/character constants */
static YYCTYPE *strbuf = NULL;

/* length of strbuf (including terminating NULL character) */
static size_t strbuf_size = 0;

static void
strbuf_append(size_t count, YYCTYPE *cursor, Scanner *s, unsigned long line,
	      int ch)
{
    if (cursor == s->eof)
	yasm__error(line, N_("unexpected end of file in string"));

    if (count >= strbuf_size) {
	strbuf = yasm_xrealloc(strbuf, strbuf_size + STRBUF_ALLOC_SIZE);
	strbuf_size += STRBUF_ALLOC_SIZE;
    }
    strbuf[count] = ch;
}

#line 244 "./modules/parsers/gas/gas-token.re"



int
gas_parser_lex(YYSTYPE *lvalp, yasm_parser_gas *parser_gas)
{
    /*@null@*/ gas_rept *rept = parser_gas->rept;
    Scanner *s = &parser_gas->s;
    YYCTYPE *cursor = s->cur;
    size_t count;
    YYCTYPE savech;
    int linestart;
    gas_rept_line *new_line;

    /* Catch EOF */
    if (s->eof && cursor == s->eof)
	return 0;

    /* Handle rept */
    if (rept && !rept->ended)
	goto rept_directive;

    /* Jump to proper "exclusive" states */
    switch (parser_gas->state) {
	case SECTION_DIRECTIVE:
	    goto section_directive;
	default:
	    break;
    }

scan:
    SCANINIT();

    {
	static unsigned char yybm[] = {
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   3,   0,   2,   2,   3,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  3,   2,   2,   2,   6,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   6,   2, 
	254, 254, 190, 190, 190, 190, 190, 190, 
	158, 158,   2,   2,   2,   2,   2,   2, 
	  2, 142, 142, 142, 142, 142, 142,  14, 
	 14,  14,  14,  14,  14,  14,  14,  14, 
	 14,  14,  14,  14,  14,  14,  14,  14, 
	 14,  14,  14,   2,   2,   2,   2,   6, 
	  2, 142, 142, 142, 142, 142, 142,  14, 
	 14,  14,  14,  14,  14,  14,  14,  14, 
	 14,  14,  14,  14,  14,  14,  14,  14, 
	 14,  14,  14,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	  2,   2,   2,   2,   2,   2,   2,   2, 
	};

#line 308 "gas-token.c"
{
	YYCTYPE yych;
	unsigned int yyaccept;
	goto yy0;
	++YYCURSOR;
yy0:
	if((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	if(yych <= '0'){
		if(yych <= '"'){
			if(yych <= '\f'){
				if(yych <= '\b')	goto yy31;
				if(yych <= '\t')	goto yy27;
				if(yych <= '\n')	goto yy29;
				goto yy31;
			} else {
				if(yych <= '\037'){
					if(yych <= '\r')	goto yy27;
					goto yy31;
				} else {
					if(yych <= ' ')	goto yy27;
					if(yych <= '!')	goto yy13;
					goto yy7;
				}
			}
		} else {
			if(yych <= '&'){
				if(yych <= '#')	goto yy25;
				if(yych == '%')	goto yy21;
				goto yy13;
			} else {
				if(yych <= '-'){
					if(yych <= '\'')	goto yy5;
					goto yy13;
				} else {
					if(yych <= '.')	goto yy17;
					if(yych <= '/')	goto yy13;
					goto yy2;
				}
			}
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '<'){
				if(yych <= '9')	goto yy4;
				if(yych <= ':')	goto yy13;
				if(yych <= ';')	goto yy15;
				goto yy9;
			} else {
				if(yych <= '>'){
					if(yych <= '=')	goto yy13;
					goto yy11;
				} else {
					if(yych <= '?')	goto yy31;
					if(yych <= '@')	goto yy13;
					goto yy23;
				}
			}
		} else {
			if(yych <= 'z'){
				if(yych <= '^'){
					if(yych <= ']')	goto yy31;
					goto yy13;
				} else {
					if(yych <= '_')	goto yy19;
					if(yych <= '`')	goto yy31;
					goto yy23;
				}
			} else {
				if(yych <= '|'){
					if(yych <= '{')	goto yy31;
					goto yy13;
				} else {
					if(yych == '~')	goto yy13;
					goto yy31;
				}
			}
		}
	}
yy2:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 32) {
		goto yy304;
	}
	if(yych <= 'X'){
		if(yych <= 'F'){
			if(yych == 'B')	goto yy307;
			if(yych >= 'D')	goto yy301;
			goto yy3;
		} else {
			if(yych == 'T')	goto yy301;
			if(yych >= 'X')	goto yy303;
			goto yy3;
		}
	} else {
		if(yych <= 'f'){
			if(yych == 'b')	goto yy307;
			if(yych >= 'd')	goto yy301;
			goto yy3;
		} else {
			if(yych <= 't'){
				if(yych >= 't')	goto yy301;
				goto yy3;
			} else {
				if(yych == 'x')	goto yy303;
				goto yy3;
			}
		}
	}
yy3:
#line 279 "./modules/parsers/gas/gas-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->intn = yasm_intnum_create_dec(TOK, cur_line);
	    s->tok[TOKLEN] = savech;
	    RETURN(INTNUM);
	}
#line 427 "gas-token.c"
yy4:	yych = *++YYCURSOR;
	goto yy300;
yy5:	yych = *++YYCURSOR;
	goto yy6;
yy6:
#line 325 "./modules/parsers/gas/gas-token.re"
{
	    goto charconst;
	}
#line 437 "gas-token.c"
yy7:	yych = *++YYCURSOR;
	goto yy8;
yy8:
#line 330 "./modules/parsers/gas/gas-token.re"
{
	    goto stringconst;
	}
#line 445 "gas-token.c"
yy9:	yych = *++YYCURSOR;
	if(yych == '<')	goto yy297;
	goto yy10;
yy10:
#line 337 "./modules/parsers/gas/gas-token.re"
{ RETURN(LEFT_OP); }
#line 452 "gas-token.c"
yy11:	yych = *++YYCURSOR;
	if(yych == '>')	goto yy295;
	goto yy12;
yy12:
#line 338 "./modules/parsers/gas/gas-token.re"
{ RETURN(RIGHT_OP); }
#line 459 "gas-token.c"
yy13:	yych = *++YYCURSOR;
	goto yy14;
yy14:
#line 339 "./modules/parsers/gas/gas-token.re"
{ RETURN(s->tok[0]); }
#line 465 "gas-token.c"
yy15:	yych = *++YYCURSOR;
	goto yy16;
yy16:
#line 340 "./modules/parsers/gas/gas-token.re"
{
	    parser_gas->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 474 "gas-token.c"
yy17:	yych = *++YYCURSOR;
	switch(yych){
	case '2':	goto yy50;
	case '4':	goto yy51;
	case '8':	goto yy52;
	case 'A':	case 'a':	goto yy53;
	case 'B':	case 'b':	goto yy54;
	case 'C':	case 'c':	goto yy55;
	case 'D':	case 'd':	goto yy56;
	case 'E':	case 'e':	goto yy57;
	case 'F':	case 'f':	goto yy58;
	case 'G':	case 'g':	goto yy59;
	case 'H':	case 'h':	goto yy60;
	case 'I':	case 'i':	goto yy61;
	case 'L':	case 'l':	goto yy62;
	case 'O':	case 'o':	goto yy63;
	case 'P':	case 'p':	goto yy64;
	case 'Q':	case 'q':	goto yy65;
	case 'R':	case 'r':	goto yy66;
	case 'S':	case 's':	goto yy67;
	case 'T':	case 't':	goto yy68;
	case 'U':	case 'u':	goto yy69;
	case 'V':	case 'v':	goto yy70;
	case 'W':	case 'w':	goto yy71;
	case 'Z':	case 'z':	goto yy72;
	default:	goto yy49;
	}
yy18:
#line 401 "./modules/parsers/gas/gas-token.re"
{
	    lvalp->str_val = yasm__xstrndup(TOK, TOKLEN);
	    RETURN(DIR_ID);
	}
#line 508 "gas-token.c"
yy19:	yych = *++YYCURSOR;
	goto yy47;
yy20:
#line 407 "./modules/parsers/gas/gas-token.re"
{
	    lvalp->str_val = yasm__xstrndup(TOK, TOKLEN);
	    RETURN(ID);
	}
#line 517 "gas-token.c"
yy21:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy43;
	}
	goto yy22;
yy22:
#line 491 "./modules/parsers/gas/gas-token.re"
{
	    yasm__warning(YASM_WARN_UNREC_CHAR, cur_line,
			  N_("ignoring unrecognized character `%s'"),
			  yasm__conv_unprint(s->tok[0]));
	    goto scan;
	}
#line 531 "gas-token.c"
yy23:	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 4) {
		goto yy36;
	}
	if(yych <= '\r'){
		if(yych == '\t')	goto yy38;
		if(yych >= '\r')	goto yy38;
		goto yy24;
	} else {
		if(yych <= ' '){
			if(yych >= ' ')	goto yy38;
			goto yy24;
		} else {
			if(yych == ':')	goto yy41;
			goto yy24;
		}
	}
yy24:
#line 454 "./modules/parsers/gas/gas-token.re"
{
	    /* Can only be an instruction/prefix when not inside an
	     * instruction or directive.
	     */
	    if (parser_gas->state != INSTDIR) {
		savech = s->tok[TOKLEN];
		s->tok[TOKLEN] = '\0';
		switch (yasm_arch_parse_check_insnprefix
			(parser_gas->arch, lvalp->arch_data, TOK, TOKLEN,
			 cur_line)) {
		    case YASM_ARCH_INSN:
			s->tok[TOKLEN] = savech;
			parser_gas->state = INSTDIR;
			RETURN(INSN);
		    case YASM_ARCH_PREFIX:
			s->tok[TOKLEN] = savech;
			RETURN(PREFIX);
		    default:
			s->tok[TOKLEN] = savech;
		}
	    }
	    /* Just an identifier, return as such. */
	    lvalp->str_val = yasm__xstrndup(TOK, TOKLEN);
	    RETURN(ID);
	}
#line 577 "gas-token.c"
yy25:	yych = *++YYCURSOR;
	goto yy35;
yy26:
#line 480 "./modules/parsers/gas/gas-token.re"
{ goto scan; }
#line 583 "gas-token.c"
yy27:	yych = *++YYCURSOR;
	goto yy33;
yy28:
#line 482 "./modules/parsers/gas/gas-token.re"
{ goto scan; }
#line 589 "gas-token.c"
yy29:	yych = *++YYCURSOR;
	goto yy30;
yy30:
#line 484 "./modules/parsers/gas/gas-token.re"
{
	    if (parser_gas->save_input && cursor != s->eof)
		cursor = save_line(parser_gas, cursor);
	    parser_gas->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 600 "gas-token.c"
yy31:	yych = *++YYCURSOR;
	goto yy22;
yy32:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy33;
yy33:	if(yybm[0+yych] & 1) {
		goto yy32;
	}
	goto yy28;
yy34:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy35;
yy35:	if(yybm[0+yych] & 2) {
		goto yy34;
	}
	goto yy26;
yy36:	yyaccept = 1;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy37;
yy37:	if(yybm[0+yych] & 4) {
		goto yy36;
	}
	if(yych <= '\r'){
		if(yych == '\t')	goto yy38;
		if(yych <= '\f')	goto yy24;
		goto yy38;
	} else {
		if(yych <= ' '){
			if(yych <= '\037')	goto yy24;
			goto yy38;
		} else {
			if(yych == ':')	goto yy41;
			goto yy24;
		}
	}
yy38:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy39;
yy39:	if(yych <= '\r'){
		if(yych == '\t')	goto yy38;
		if(yych >= '\r')	goto yy38;
		goto yy40;
	} else {
		if(yych <= ' '){
			if(yych >= ' ')	goto yy38;
			goto yy40;
		} else {
			if(yych == ':')	goto yy41;
			goto yy40;
		}
	}
yy40:	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 0:	goto yy3;
	case 2:	goto yy302;
	case 1:	goto yy24;
	}
yy41:	yych = *++YYCURSOR;
	goto yy42;
yy42:
#line 442 "./modules/parsers/gas/gas-token.re"
{
	    /* strip off colon and any whitespace */
	    count = TOKLEN-1;
	    while (s->tok[count] == ' ' || s->tok[count] == '\t'
		   || s->tok[count] == '\r')
		count--;
	    /* Just an identifier, return as such. */
	    lvalp->str_val = yasm__xstrndup(TOK, count);
	    RETURN(LABEL);
	}
#line 677 "gas-token.c"
yy43:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy44;
yy44:	if(yybm[0+yych] & 8) {
		goto yy43;
	}
	goto yy45;
yy45:
#line 413 "./modules/parsers/gas/gas-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    switch (yasm_arch_parse_check_regtmod
		    (parser_gas->arch, lvalp->arch_data, TOK+1, TOKLEN-1,
		     cur_line)) {
		case YASM_ARCH_REG:
		    s->tok[TOKLEN] = savech;
		    RETURN(REG);
		case YASM_ARCH_REGGROUP:
		    s->tok[TOKLEN] = savech;
		    RETURN(REGGROUP);
		case YASM_ARCH_SEGREG:
		    s->tok[TOKLEN] = savech;
		    RETURN(SEGREG);
		default:
		    break;
	    }
	    yasm__error(cur_line, N_("Unrecognized register name `%s'"),
			s->tok);
	    s->tok[TOKLEN] = savech;
	    lvalp->arch_data[0] = 0;
	    lvalp->arch_data[1] = 0;
	    lvalp->arch_data[2] = 0;
	    lvalp->arch_data[3] = 0;
	    RETURN(REG);
	}
#line 715 "gas-token.c"
yy46:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy47;
yy47:	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy46;
			goto yy20;
		} else {
			if(yych == '/')	goto yy20;
			goto yy46;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy20;
			if(yych <= 'Z')	goto yy46;
			goto yy20;
		} else {
			if(yych == '`')	goto yy20;
			if(yych <= 'z')	goto yy46;
			goto yy20;
		}
	}
yy48:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy49;
yy49:	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy18;
		} else {
			if(yych == '/')	goto yy18;
			goto yy48;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy18;
			if(yych <= 'Z')	goto yy48;
			goto yy18;
		} else {
			if(yych == '`')	goto yy18;
			if(yych <= 'z')	goto yy48;
			goto yy18;
		}
	}
yy50:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy290;
	if(yych == 'b')	goto yy290;
	goto yy49;
yy51:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy285;
	if(yych == 'b')	goto yy285;
	goto yy49;
yy52:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy280;
	if(yych == 'b')	goto yy280;
	goto yy49;
yy53:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'L')	goto yy268;
		if(yych <= 'R')	goto yy49;
		goto yy269;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy49;
			goto yy268;
		} else {
			if(yych == 's')	goto yy269;
			goto yy49;
		}
	}
yy54:	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych <= 'R'){
			if(yych == 'A')	goto yy255;
			goto yy49;
		} else {
			if(yych <= 'S')	goto yy256;
			if(yych <= 'X')	goto yy49;
			goto yy257;
		}
	} else {
		if(yych <= 'r'){
			if(yych == 'a')	goto yy255;
			goto yy49;
		} else {
			if(yych <= 's')	goto yy256;
			if(yych == 'y')	goto yy257;
			goto yy49;
		}
	}
yy55:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy251;
	if(yych == 'o')	goto yy251;
	goto yy49;
yy56:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'A')	goto yy241;
		if(yych <= 'N')	goto yy49;
		goto yy242;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy49;
			goto yy241;
		} else {
			if(yych == 'o')	goto yy242;
			goto yy49;
		}
	}
yy57:	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych <= 'P'){
			if(yych == 'N')	goto yy228;
			goto yy49;
		} else {
			if(yych <= 'Q')	goto yy229;
			if(yych <= 'W')	goto yy49;
			goto yy230;
		}
	} else {
		if(yych <= 'p'){
			if(yych == 'n')	goto yy228;
			goto yy49;
		} else {
			if(yych <= 'q')	goto yy229;
			if(yych == 'x')	goto yy230;
			goto yy49;
		}
	}
yy58:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych == 'I')	goto yy217;
		if(yych <= 'K')	goto yy49;
		goto yy218;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy49;
			goto yy217;
		} else {
			if(yych == 'l')	goto yy218;
			goto yy49;
		}
	}
yy59:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy209;
	if(yych == 'l')	goto yy209;
	goto yy49;
yy60:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy204;
	if(yych == 'w')	goto yy204;
	goto yy49;
yy61:	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'D')	goto yy196;
		if(yych <= 'M')	goto yy49;
		goto yy197;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy49;
			goto yy196;
		} else {
			if(yych == 'n')	goto yy197;
			goto yy49;
		}
	}
yy62:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'H'){
			if(yych == 'C')	goto yy178;
			goto yy49;
		} else {
			if(yych <= 'I')	goto yy179;
			if(yych <= 'N')	goto yy49;
			goto yy180;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'c')	goto yy178;
			goto yy49;
		} else {
			if(yych <= 'i')	goto yy179;
			if(yych == 'o')	goto yy180;
			goto yy49;
		}
	}
yy63:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'C')	goto yy171;
		if(yych <= 'Q')	goto yy49;
		goto yy172;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy49;
			goto yy171;
		} else {
			if(yych == 'r')	goto yy172;
			goto yy49;
		}
	}
yy64:	yych = *++YYCURSOR;
	if(yych == '2')	goto yy164;
	goto yy49;
yy65:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy160;
	if(yych == 'u')	goto yy160;
	goto yy49;
yy66:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy156;
	if(yych == 'e')	goto yy156;
	goto yy49;
yy67:	yych = *++YYCURSOR;
	switch(yych){
	case 'E':	case 'e':	goto yy111;
	case 'H':	case 'h':	goto yy112;
	case 'I':	case 'i':	goto yy113;
	case 'K':	case 'k':	goto yy114;
	case 'L':	case 'l':	goto yy115;
	case 'P':	case 'p':	goto yy116;
	case 'T':	case 't':	goto yy117;
	default:	goto yy49;
	}
yy68:	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy49;
			goto yy97;
		} else {
			if(yych <= 'F')	goto yy98;
			if(yych <= 'X')	goto yy49;
			goto yy99;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'd')	goto yy49;
			if(yych <= 'e')	goto yy97;
			goto yy98;
		} else {
			if(yych == 'y')	goto yy99;
			goto yy49;
		}
	}
yy69:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy90;
	if(yych == 'l')	goto yy90;
	goto yy49;
yy70:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy85;
	if(yych == 'a')	goto yy85;
	goto yy49;
yy71:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'E')	goto yy77;
		if(yych <= 'N')	goto yy49;
		goto yy78;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy49;
			goto yy77;
		} else {
			if(yych == 'o')	goto yy78;
			goto yy49;
		}
	}
yy72:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy73;
	if(yych != 'e')	goto yy49;
	goto yy73;
yy73:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy74;
	if(yych != 'r')	goto yy49;
	goto yy74;
yy74:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy75;
	if(yych != 'o')	goto yy49;
	goto yy75;
yy75:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy76;
		} else {
			if(yych != '/')	goto yy48;
			goto yy76;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy76;
			if(yych <= 'Z')	goto yy48;
			goto yy76;
		} else {
			if(yych == '`')	goto yy76;
			if(yych <= 'z')	goto yy48;
			goto yy76;
		}
	}
yy76:
#line 398 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_ZERO); }
#line 1015 "gas-token.c"
yy77:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy82;
	if(yych == 'a')	goto yy82;
	goto yy49;
yy78:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy79;
	if(yych != 'r')	goto yy49;
	goto yy79;
yy79:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy80;
	if(yych != 'd')	goto yy49;
	goto yy80;
yy80:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy81;
		} else {
			if(yych != '/')	goto yy48;
			goto yy81;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy81;
			if(yych <= 'Z')	goto yy48;
			goto yy81;
		} else {
			if(yych == '`')	goto yy81;
			if(yych <= 'z')	goto yy48;
			goto yy81;
		}
	}
yy81:
#line 397 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_WORD); }
#line 1051 "gas-token.c"
yy82:	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy83;
	if(yych != 'k')	goto yy49;
	goto yy83;
yy83:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy84;
		} else {
			if(yych != '/')	goto yy48;
			goto yy84;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy84;
			if(yych <= 'Z')	goto yy48;
			goto yy84;
		} else {
			if(yych == '`')	goto yy84;
			if(yych <= 'z')	goto yy48;
			goto yy84;
		}
	}
yy84:
#line 396 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_WEAK); }
#line 1079 "gas-token.c"
yy85:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy86;
	if(yych != 'l')	goto yy49;
	goto yy86;
yy86:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy87;
	if(yych != 'u')	goto yy49;
	goto yy87;
yy87:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy88;
	if(yych != 'e')	goto yy49;
	goto yy88;
yy88:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy89;
		} else {
			if(yych != '/')	goto yy48;
			goto yy89;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy89;
			if(yych <= 'Z')	goto yy48;
			goto yy89;
		} else {
			if(yych == '`')	goto yy89;
			if(yych <= 'z')	goto yy48;
			goto yy89;
		}
	}
yy89:
#line 395 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_VALUE); }
#line 1115 "gas-token.c"
yy90:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy91;
	if(yych != 'e')	goto yy49;
	goto yy91;
yy91:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy92;
	if(yych != 'b')	goto yy49;
	goto yy92;
yy92:	yych = *++YYCURSOR;
	if(yych != '1')	goto yy49;
	goto yy93;
yy93:	yych = *++YYCURSOR;
	if(yych != '2')	goto yy49;
	goto yy94;
yy94:	yych = *++YYCURSOR;
	if(yych != '8')	goto yy49;
	goto yy95;
yy95:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy96;
		} else {
			if(yych != '/')	goto yy48;
			goto yy96;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy96;
			if(yych <= 'Z')	goto yy48;
			goto yy96;
		} else {
			if(yych == '`')	goto yy96;
			if(yych <= 'z')	goto yy48;
			goto yy96;
		}
	}
yy96:
#line 394 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_ULEB128); }
#line 1156 "gas-token.c"
yy97:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy108;
	if(yych == 'x')	goto yy108;
	goto yy49;
yy98:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy103;
	if(yych == 'l')	goto yy103;
	goto yy49;
yy99:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy100;
	if(yych != 'p')	goto yy49;
	goto yy100;
yy100:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy101;
	if(yych != 'e')	goto yy49;
	goto yy101;
yy101:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy102;
		} else {
			if(yych != '/')	goto yy48;
			goto yy102;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy102;
			if(yych <= 'Z')	goto yy48;
			goto yy102;
		} else {
			if(yych == '`')	goto yy102;
			if(yych <= 'z')	goto yy48;
			goto yy102;
		}
	}
yy102:
#line 392 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_TYPE); }
#line 1196 "gas-token.c"
yy103:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy104;
	if(yych != 'o')	goto yy49;
	goto yy104;
yy104:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy105;
	if(yych != 'a')	goto yy49;
	goto yy105;
yy105:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy106;
	if(yych != 't')	goto yy49;
	goto yy106;
yy106:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy107;
		} else {
			if(yych != '/')	goto yy48;
			goto yy107;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy107;
			if(yych <= 'Z')	goto yy48;
			goto yy107;
		} else {
			if(yych == '`')	goto yy107;
			if(yych <= 'z')	goto yy48;
			goto yy107;
		}
	}
yy107:
#line 391 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_TFLOAT); }
#line 1232 "gas-token.c"
yy108:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy109;
	if(yych != 't')	goto yy49;
	goto yy109;
yy109:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy110;
		} else {
			if(yych != '/')	goto yy48;
			goto yy110;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy110;
			if(yych <= 'Z')	goto yy48;
			goto yy110;
		} else {
			if(yych == '`')	goto yy110;
			if(yych <= 'z')	goto yy48;
			goto yy110;
		}
	}
yy110:
#line 390 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_TEXT); }
#line 1260 "gas-token.c"
yy111:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych == 'C')	goto yy148;
		if(yych <= 'S')	goto yy49;
		goto yy149;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy49;
			goto yy148;
		} else {
			if(yych == 't')	goto yy149;
			goto yy49;
		}
	}
yy112:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy144;
	if(yych == 'o')	goto yy144;
	goto yy49;
yy113:	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych == 'N')	goto yy136;
		if(yych <= 'Y')	goto yy49;
		goto yy137;
	} else {
		if(yych <= 'n'){
			if(yych <= 'm')	goto yy49;
			goto yy136;
		} else {
			if(yych == 'z')	goto yy137;
			goto yy49;
		}
	}
yy114:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy133;
	if(yych == 'i')	goto yy133;
	goto yy49;
yy115:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy127;
	if(yych == 'e')	goto yy127;
	goto yy49;
yy116:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy123;
	if(yych == 'a')	goto yy123;
	goto yy49;
yy117:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy118;
	if(yych != 'r')	goto yy49;
	goto yy118;
yy118:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy119;
	if(yych != 'i')	goto yy49;
	goto yy119;
yy119:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy120;
	if(yych != 'n')	goto yy49;
	goto yy120;
yy120:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy121;
	if(yych != 'g')	goto yy49;
	goto yy121;
yy121:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy122;
		} else {
			if(yych != '/')	goto yy48;
			goto yy122;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy122;
			if(yych <= 'Z')	goto yy48;
			goto yy122;
		} else {
			if(yych == '`')	goto yy122;
			if(yych <= 'z')	goto yy48;
			goto yy122;
		}
	}
yy122:
#line 389 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_ASCIZ); }
#line 1344 "gas-token.c"
yy123:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy124;
	if(yych != 'c')	goto yy49;
	goto yy124;
yy124:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy125;
	if(yych != 'e')	goto yy49;
	goto yy125;
yy125:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy126;
		} else {
			if(yych != '/')	goto yy48;
			goto yy126;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy126;
			if(yych <= 'Z')	goto yy48;
			goto yy126;
		} else {
			if(yych == '`')	goto yy126;
			if(yych <= 'z')	goto yy48;
			goto yy126;
		}
	}
yy126:
#line 388 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_SKIP); }
#line 1376 "gas-token.c"
yy127:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy128;
	if(yych != 'b')	goto yy49;
	goto yy128;
yy128:	yych = *++YYCURSOR;
	if(yych != '1')	goto yy49;
	goto yy129;
yy129:	yych = *++YYCURSOR;
	if(yych != '2')	goto yy49;
	goto yy130;
yy130:	yych = *++YYCURSOR;
	if(yych != '8')	goto yy49;
	goto yy131;
yy131:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy132;
		} else {
			if(yych != '/')	goto yy48;
			goto yy132;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy132;
			if(yych <= 'Z')	goto yy48;
			goto yy132;
		} else {
			if(yych == '`')	goto yy132;
			if(yych <= 'z')	goto yy48;
			goto yy132;
		}
	}
yy132:
#line 387 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_SLEB128); }
#line 1413 "gas-token.c"
yy133:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy134;
	if(yych != 'p')	goto yy49;
	goto yy134;
yy134:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy135;
		} else {
			if(yych != '/')	goto yy48;
			goto yy135;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy135;
			if(yych <= 'Z')	goto yy48;
			goto yy135;
		} else {
			if(yych == '`')	goto yy135;
			if(yych <= 'z')	goto yy48;
			goto yy135;
		}
	}
yy135:
#line 386 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_SKIP); }
#line 1441 "gas-token.c"
yy136:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy140;
	if(yych == 'g')	goto yy140;
	goto yy49;
yy137:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy138;
	if(yych != 'e')	goto yy49;
	goto yy138;
yy138:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy139;
		} else {
			if(yych != '/')	goto yy48;
			goto yy139;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy139;
			if(yych <= 'Z')	goto yy48;
			goto yy139;
		} else {
			if(yych == '`')	goto yy139;
			if(yych <= 'z')	goto yy48;
			goto yy139;
		}
	}
yy139:
#line 385 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_SIZE); }
#line 1473 "gas-token.c"
yy140:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy141;
	if(yych != 'l')	goto yy49;
	goto yy141;
yy141:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy142;
	if(yych != 'e')	goto yy49;
	goto yy142;
yy142:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy143;
		} else {
			if(yych != '/')	goto yy48;
			goto yy143;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy143;
			if(yych <= 'Z')	goto yy48;
			goto yy143;
		} else {
			if(yych == '`')	goto yy143;
			if(yych <= 'z')	goto yy48;
			goto yy143;
		}
	}
yy143:
#line 384 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_FLOAT); }
#line 1505 "gas-token.c"
yy144:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy145;
	if(yych != 'r')	goto yy49;
	goto yy145;
yy145:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy146;
	if(yych != 't')	goto yy49;
	goto yy146;
yy146:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy147;
		} else {
			if(yych != '/')	goto yy48;
			goto yy147;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy147;
			if(yych <= 'Z')	goto yy48;
			goto yy147;
		} else {
			if(yych == '`')	goto yy147;
			if(yych <= 'z')	goto yy48;
			goto yy147;
		}
	}
yy147:
#line 383 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_SHORT); }
#line 1537 "gas-token.c"
yy148:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy151;
	if(yych == 't')	goto yy151;
	goto yy49;
yy149:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy150;
		} else {
			if(yych != '/')	goto yy48;
			goto yy150;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy150;
			if(yych <= 'Z')	goto yy48;
			goto yy150;
		} else {
			if(yych == '`')	goto yy150;
			if(yych <= 'z')	goto yy48;
			goto yy150;
		}
	}
yy150:
#line 382 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_EQU); }
#line 1565 "gas-token.c"
yy151:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy152;
	if(yych != 'i')	goto yy49;
	goto yy152;
yy152:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy153;
	if(yych != 'o')	goto yy49;
	goto yy153;
yy153:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy154;
	if(yych != 'n')	goto yy49;
	goto yy154;
yy154:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy155;
		} else {
			if(yych != '/')	goto yy48;
			goto yy155;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy155;
			if(yych <= 'Z')	goto yy48;
			goto yy155;
		} else {
			if(yych == '`')	goto yy155;
			if(yych <= 'z')	goto yy48;
			goto yy155;
		}
	}
yy155:
#line 378 "./modules/parsers/gas/gas-token.re"
{
	    parser_gas->state = SECTION_DIRECTIVE;
	    RETURN(DIR_SECTION);
	}
#line 1604 "gas-token.c"
yy156:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy157;
	if(yych != 'p')	goto yy49;
	goto yy157;
yy157:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy158;
	if(yych != 't')	goto yy49;
	goto yy158;
yy158:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy159;
		} else {
			if(yych != '/')	goto yy48;
			goto yy159;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy159;
			if(yych <= 'Z')	goto yy48;
			goto yy159;
		} else {
			if(yych == '`')	goto yy159;
			if(yych <= 'z')	goto yy48;
			goto yy159;
		}
	}
yy159:
#line 377 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_REPT); }
#line 1636 "gas-token.c"
yy160:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy161;
	if(yych != 'a')	goto yy49;
	goto yy161;
yy161:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy162;
	if(yych != 'd')	goto yy49;
	goto yy162;
yy162:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy163;
		} else {
			if(yych != '/')	goto yy48;
			goto yy163;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy163;
			if(yych <= 'Z')	goto yy48;
			goto yy163;
		} else {
			if(yych == '`')	goto yy163;
			if(yych <= 'z')	goto yy48;
			goto yy163;
		}
	}
yy163:
#line 393 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_QUAD); }
#line 1668 "gas-token.c"
yy164:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy165;
	if(yych != 'a')	goto yy49;
	goto yy165;
yy165:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy166;
	if(yych != 'l')	goto yy49;
	goto yy166;
yy166:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy167;
	if(yych != 'i')	goto yy49;
	goto yy167;
yy167:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy168;
	if(yych != 'g')	goto yy49;
	goto yy168;
yy168:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy169;
	if(yych != 'n')	goto yy49;
	goto yy169;
yy169:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy170;
		} else {
			if(yych != '/')	goto yy48;
			goto yy170;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy170;
			if(yych <= 'Z')	goto yy48;
			goto yy170;
		} else {
			if(yych == '`')	goto yy170;
			if(yych <= 'z')	goto yy48;
			goto yy170;
		}
	}
yy170:
#line 376 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_P2ALIGN); }
#line 1712 "gas-token.c"
yy171:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy175;
	if(yych == 't')	goto yy175;
	goto yy49;
yy172:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy173;
	if(yych != 'g')	goto yy49;
	goto yy173;
yy173:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy174;
		} else {
			if(yych != '/')	goto yy48;
			goto yy174;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy174;
			if(yych <= 'Z')	goto yy48;
			goto yy174;
		} else {
			if(yych == '`')	goto yy174;
			if(yych <= 'z')	goto yy48;
			goto yy174;
		}
	}
yy174:
#line 375 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_ORG); }
#line 1744 "gas-token.c"
yy175:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy176;
	if(yych != 'a')	goto yy49;
	goto yy176;
yy176:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy177;
		} else {
			if(yych != '/')	goto yy48;
			goto yy177;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy177;
			if(yych <= 'Z')	goto yy48;
			goto yy177;
		} else {
			if(yych == '`')	goto yy177;
			if(yych <= 'z')	goto yy48;
			goto yy177;
		}
	}
yy177:
#line 374 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_OCTA); }
#line 1772 "gas-token.c"
yy178:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy192;
	if(yych == 'o')	goto yy192;
	goto yy49;
yy179:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy189;
	if(yych == 'n')	goto yy189;
	goto yy49;
yy180:	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'C')	goto yy181;
		if(yych <= 'M')	goto yy49;
		goto yy183;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy49;
			goto yy181;
		} else {
			if(yych == 'n')	goto yy183;
			goto yy49;
		}
	}
yy181:	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy182;
		} else {
			if(yych == '/')	goto yy182;
			if(yych <= '9')	goto yy48;
			goto yy182;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'A')	goto yy186;
			if(yych <= 'Z')	goto yy48;
			if(yych >= '_')	goto yy48;
			goto yy182;
		} else {
			if(yych <= '`')	goto yy182;
			if(yych <= 'a')	goto yy186;
			if(yych <= 'z')	goto yy48;
			goto yy182;
		}
	}
yy182:
#line 371 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_LOC); }
#line 1821 "gas-token.c"
yy183:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy184;
	if(yych != 'g')	goto yy49;
	goto yy184;
yy184:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy185;
		} else {
			if(yych != '/')	goto yy48;
			goto yy185;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy185;
			if(yych <= 'Z')	goto yy48;
			goto yy185;
		} else {
			if(yych == '`')	goto yy185;
			if(yych <= 'z')	goto yy48;
			goto yy185;
		}
	}
yy185:
#line 373 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_INT); }
#line 1849 "gas-token.c"
yy186:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy187;
	if(yych != 'l')	goto yy49;
	goto yy187;
yy187:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy188;
		} else {
			if(yych != '/')	goto yy48;
			goto yy188;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy188;
			if(yych <= 'Z')	goto yy48;
			goto yy188;
		} else {
			if(yych == '`')	goto yy188;
			if(yych <= 'z')	goto yy48;
			goto yy188;
		}
	}
yy188:
#line 372 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_LOCAL); }
#line 1877 "gas-token.c"
yy189:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy190;
	if(yych != 'e')	goto yy49;
	goto yy190;
yy190:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy191;
		} else {
			if(yych != '/')	goto yy48;
			goto yy191;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy191;
			if(yych <= 'Z')	goto yy48;
			goto yy191;
		} else {
			if(yych == '`')	goto yy191;
			if(yych <= 'z')	goto yy48;
			goto yy191;
		}
	}
yy191:
#line 370 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_LINE); }
#line 1905 "gas-token.c"
yy192:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy193;
	if(yych != 'm')	goto yy49;
	goto yy193;
yy193:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy194;
	if(yych != 'm')	goto yy49;
	goto yy194;
yy194:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy195;
		} else {
			if(yych != '/')	goto yy48;
			goto yy195;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy195;
			if(yych <= 'Z')	goto yy48;
			goto yy195;
		} else {
			if(yych == '`')	goto yy195;
			if(yych <= 'z')	goto yy48;
			goto yy195;
		}
	}
yy195:
#line 369 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_LCOMM); }
#line 1937 "gas-token.c"
yy196:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy200;
	if(yych == 'e')	goto yy200;
	goto yy49;
yy197:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy198;
	if(yych != 't')	goto yy49;
	goto yy198;
yy198:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy199;
		} else {
			if(yych != '/')	goto yy48;
			goto yy199;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy199;
			if(yych <= 'Z')	goto yy48;
			goto yy199;
		} else {
			if(yych == '`')	goto yy199;
			if(yych <= 'z')	goto yy48;
			goto yy199;
		}
	}
yy199:
#line 368 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_INT); }
#line 1969 "gas-token.c"
yy200:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy201;
	if(yych != 'n')	goto yy49;
	goto yy201;
yy201:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy202;
	if(yych != 't')	goto yy49;
	goto yy202;
yy202:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy203;
		} else {
			if(yych != '/')	goto yy48;
			goto yy203;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy203;
			if(yych <= 'Z')	goto yy48;
			goto yy203;
		} else {
			if(yych == '`')	goto yy203;
			if(yych <= 'z')	goto yy48;
			goto yy203;
		}
	}
yy203:
#line 367 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_IDENT); }
#line 2001 "gas-token.c"
yy204:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy205;
	if(yych != 'o')	goto yy49;
	goto yy205;
yy205:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy206;
	if(yych != 'r')	goto yy49;
	goto yy206;
yy206:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy207;
	if(yych != 'd')	goto yy49;
	goto yy207;
yy207:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy208;
		} else {
			if(yych != '/')	goto yy48;
			goto yy208;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy208;
			if(yych <= 'Z')	goto yy48;
			goto yy208;
		} else {
			if(yych == '`')	goto yy208;
			if(yych <= 'z')	goto yy48;
			goto yy208;
		}
	}
yy208:
#line 366 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_SHORT); }
#line 2037 "gas-token.c"
yy209:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy210;
	if(yych != 'o')	goto yy49;
	goto yy210;
yy210:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy211;
	if(yych != 'b')	goto yy49;
	goto yy211;
yy211:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych == 'A')	goto yy212;
		if(yych <= 'K')	goto yy49;
		goto yy213;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy49;
			goto yy212;
		} else {
			if(yych == 'l')	goto yy213;
			goto yy49;
		}
	}
yy212:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy215;
	if(yych == 'l')	goto yy215;
	goto yy49;
yy213:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy214;
		} else {
			if(yych != '/')	goto yy48;
			goto yy214;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy214;
			if(yych <= 'Z')	goto yy48;
			goto yy214;
		} else {
			if(yych == '`')	goto yy214;
			if(yych <= 'z')	goto yy48;
			goto yy214;
		}
	}
yy214:
#line 365 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_GLOBAL); }
#line 2087 "gas-token.c"
yy215:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy216;
		} else {
			if(yych != '/')	goto yy48;
			goto yy216;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy216;
			if(yych <= 'Z')	goto yy48;
			goto yy216;
		} else {
			if(yych == '`')	goto yy216;
			if(yych <= 'z')	goto yy48;
			goto yy216;
		}
	}
yy216:
#line 364 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_GLOBAL); }
#line 2111 "gas-token.c"
yy217:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy223;
	if(yych == 'l')	goto yy223;
	goto yy49;
yy218:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy219;
	if(yych != 'o')	goto yy49;
	goto yy219;
yy219:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy220;
	if(yych != 'a')	goto yy49;
	goto yy220;
yy220:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy221;
	if(yych != 't')	goto yy49;
	goto yy221;
yy221:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy222;
		} else {
			if(yych != '/')	goto yy48;
			goto yy222;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy222;
			if(yych <= 'Z')	goto yy48;
			goto yy222;
		} else {
			if(yych == '`')	goto yy222;
			if(yych <= 'z')	goto yy48;
			goto yy222;
		}
	}
yy222:
#line 363 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_FLOAT); }
#line 2151 "gas-token.c"
yy223:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych == 'E')	goto yy224;
		if(yych <= 'K')	goto yy49;
		goto yy226;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy49;
			goto yy224;
		} else {
			if(yych == 'l')	goto yy226;
			goto yy49;
		}
	}
yy224:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy225;
		} else {
			if(yych != '/')	goto yy48;
			goto yy225;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy225;
			if(yych <= 'Z')	goto yy48;
			goto yy225;
		} else {
			if(yych == '`')	goto yy225;
			if(yych <= 'z')	goto yy48;
			goto yy225;
		}
	}
yy225:
#line 361 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_FILE); }
#line 2189 "gas-token.c"
yy226:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy227;
		} else {
			if(yych != '/')	goto yy48;
			goto yy227;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy227;
			if(yych <= 'Z')	goto yy48;
			goto yy227;
		} else {
			if(yych == '`')	goto yy227;
			if(yych <= 'z')	goto yy48;
			goto yy227;
		}
	}
yy227:
#line 362 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_FILL); }
#line 2213 "gas-token.c"
yy228:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy238;
	if(yych == 'd')	goto yy238;
	goto yy49;
yy229:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy236;
	if(yych == 'u')	goto yy236;
	goto yy49;
yy230:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy231;
	if(yych != 't')	goto yy49;
	goto yy231;
yy231:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy232;
	if(yych != 'e')	goto yy49;
	goto yy232;
yy232:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy233;
	if(yych != 'r')	goto yy49;
	goto yy233;
yy233:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy234;
	if(yych != 'n')	goto yy49;
	goto yy234;
yy234:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy235;
		} else {
			if(yych != '/')	goto yy48;
			goto yy235;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy235;
			if(yych <= 'Z')	goto yy48;
			goto yy235;
		} else {
			if(yych == '`')	goto yy235;
			if(yych <= 'z')	goto yy48;
			goto yy235;
		}
	}
yy235:
#line 360 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_EXTERN); }
#line 2261 "gas-token.c"
yy236:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy237;
		} else {
			if(yych != '/')	goto yy48;
			goto yy237;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy237;
			if(yych <= 'Z')	goto yy48;
			goto yy237;
		} else {
			if(yych == '`')	goto yy237;
			if(yych <= 'z')	goto yy48;
			goto yy237;
		}
	}
yy237:
#line 359 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_EQU); }
#line 2285 "gas-token.c"
yy238:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy239;
	if(yych != 'r')	goto yy49;
	goto yy239;
yy239:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy240;
		} else {
			if(yych != '/')	goto yy48;
			goto yy240;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy240;
			if(yych <= 'Z')	goto yy48;
			goto yy240;
		} else {
			if(yych == '`')	goto yy240;
			if(yych <= 'z')	goto yy48;
			goto yy240;
		}
	}
yy240:
#line 358 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_ENDR); }
#line 2313 "gas-token.c"
yy241:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy248;
	if(yych == 't')	goto yy248;
	goto yy49;
yy242:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy243;
	if(yych != 'u')	goto yy49;
	goto yy243;
yy243:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy244;
	if(yych != 'b')	goto yy49;
	goto yy244;
yy244:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy245;
	if(yych != 'l')	goto yy49;
	goto yy245;
yy245:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy246;
	if(yych != 'e')	goto yy49;
	goto yy246;
yy246:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy247;
		} else {
			if(yych != '/')	goto yy48;
			goto yy247;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy247;
			if(yych <= 'Z')	goto yy48;
			goto yy247;
		} else {
			if(yych == '`')	goto yy247;
			if(yych <= 'z')	goto yy48;
			goto yy247;
		}
	}
yy247:
#line 357 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_DOUBLE); }
#line 2357 "gas-token.c"
yy248:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy249;
	if(yych != 'a')	goto yy49;
	goto yy249;
yy249:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy250;
		} else {
			if(yych != '/')	goto yy48;
			goto yy250;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy250;
			if(yych <= 'Z')	goto yy48;
			goto yy250;
		} else {
			if(yych == '`')	goto yy250;
			if(yych <= 'z')	goto yy48;
			goto yy250;
		}
	}
yy250:
#line 356 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_DATA); }
#line 2385 "gas-token.c"
yy251:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy252;
	if(yych != 'm')	goto yy49;
	goto yy252;
yy252:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy253;
	if(yych != 'm')	goto yy49;
	goto yy253;
yy253:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy254;
		} else {
			if(yych != '/')	goto yy48;
			goto yy254;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy254;
			if(yych <= 'Z')	goto yy48;
			goto yy254;
		} else {
			if(yych == '`')	goto yy254;
			if(yych <= 'z')	goto yy48;
			goto yy254;
		}
	}
yy254:
#line 355 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_COMM); }
#line 2417 "gas-token.c"
yy255:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy263;
	if(yych == 'l')	goto yy263;
	goto yy49;
yy256:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy261;
	if(yych == 's')	goto yy261;
	goto yy49;
yy257:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy258;
	if(yych != 't')	goto yy49;
	goto yy258;
yy258:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy259;
	if(yych != 'e')	goto yy49;
	goto yy259;
yy259:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy260;
		} else {
			if(yych != '/')	goto yy48;
			goto yy260;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy260;
			if(yych <= 'Z')	goto yy48;
			goto yy260;
		} else {
			if(yych == '`')	goto yy260;
			if(yych <= 'z')	goto yy48;
			goto yy260;
		}
	}
yy260:
#line 354 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_BYTE); }
#line 2457 "gas-token.c"
yy261:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy262;
		} else {
			if(yych != '/')	goto yy48;
			goto yy262;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy262;
			if(yych <= 'Z')	goto yy48;
			goto yy262;
		} else {
			if(yych == '`')	goto yy262;
			if(yych <= 'z')	goto yy48;
			goto yy262;
		}
	}
yy262:
#line 353 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_BSS); }
#line 2481 "gas-token.c"
yy263:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy264;
	if(yych != 'i')	goto yy49;
	goto yy264;
yy264:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy265;
	if(yych != 'g')	goto yy49;
	goto yy265;
yy265:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy266;
	if(yych != 'n')	goto yy49;
	goto yy266;
yy266:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy267;
		} else {
			if(yych != '/')	goto yy48;
			goto yy267;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy267;
			if(yych <= 'Z')	goto yy48;
			goto yy267;
		} else {
			if(yych == '`')	goto yy267;
			if(yych <= 'z')	goto yy48;
			goto yy267;
		}
	}
yy267:
#line 352 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_BALIGN); }
#line 2517 "gas-token.c"
yy268:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy276;
	if(yych == 'i')	goto yy276;
	goto yy49;
yy269:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy270;
	if(yych != 'c')	goto yy49;
	goto yy270;
yy270:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy271;
	if(yych != 'i')	goto yy49;
	goto yy271;
yy271:	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych == 'I')	goto yy272;
		if(yych <= 'Y')	goto yy49;
		goto yy274;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy49;
			goto yy272;
		} else {
			if(yych == 'z')	goto yy274;
			goto yy49;
		}
	}
yy272:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy273;
		} else {
			if(yych != '/')	goto yy48;
			goto yy273;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy273;
			if(yych <= 'Z')	goto yy48;
			goto yy273;
		} else {
			if(yych == '`')	goto yy273;
			if(yych <= 'z')	goto yy48;
			goto yy273;
		}
	}
yy273:
#line 350 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_ASCII); }
#line 2567 "gas-token.c"
yy274:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy275;
		} else {
			if(yych != '/')	goto yy48;
			goto yy275;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy275;
			if(yych <= 'Z')	goto yy48;
			goto yy275;
		} else {
			if(yych == '`')	goto yy275;
			if(yych <= 'z')	goto yy48;
			goto yy275;
		}
	}
yy275:
#line 351 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_ASCIZ); }
#line 2591 "gas-token.c"
yy276:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy277;
	if(yych != 'g')	goto yy49;
	goto yy277;
yy277:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy278;
	if(yych != 'n')	goto yy49;
	goto yy278;
yy278:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy279;
		} else {
			if(yych != '/')	goto yy48;
			goto yy279;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy279;
			if(yych <= 'Z')	goto yy48;
			goto yy279;
		} else {
			if(yych == '`')	goto yy279;
			if(yych <= 'z')	goto yy48;
			goto yy279;
		}
	}
yy279:
#line 349 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_ALIGN); }
#line 2623 "gas-token.c"
yy280:	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy281;
	if(yych != 'y')	goto yy49;
	goto yy281;
yy281:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy282;
	if(yych != 't')	goto yy49;
	goto yy282;
yy282:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy283;
	if(yych != 'e')	goto yy49;
	goto yy283;
yy283:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy284;
		} else {
			if(yych != '/')	goto yy48;
			goto yy284;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy284;
			if(yych <= 'Z')	goto yy48;
			goto yy284;
		} else {
			if(yych == '`')	goto yy284;
			if(yych <= 'z')	goto yy48;
			goto yy284;
		}
	}
yy284:
#line 348 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_QUAD); }
#line 2659 "gas-token.c"
yy285:	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy286;
	if(yych != 'y')	goto yy49;
	goto yy286;
yy286:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy287;
	if(yych != 't')	goto yy49;
	goto yy287;
yy287:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy288;
	if(yych != 'e')	goto yy49;
	goto yy288;
yy288:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy289;
		} else {
			if(yych != '/')	goto yy48;
			goto yy289;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy289;
			if(yych <= 'Z')	goto yy48;
			goto yy289;
		} else {
			if(yych == '`')	goto yy289;
			if(yych <= 'z')	goto yy48;
			goto yy289;
		}
	}
yy289:
#line 347 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_4BYTE); }
#line 2695 "gas-token.c"
yy290:	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy291;
	if(yych != 'y')	goto yy49;
	goto yy291;
yy291:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy292;
	if(yych != 't')	goto yy49;
	goto yy292;
yy292:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy293;
	if(yych != 'e')	goto yy49;
	goto yy293;
yy293:	yych = *++YYCURSOR;
	if(yych <= '9'){
		if(yych <= '-'){
			if(yych == '$')	goto yy48;
			goto yy294;
		} else {
			if(yych != '/')	goto yy48;
			goto yy294;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy294;
			if(yych <= 'Z')	goto yy48;
			goto yy294;
		} else {
			if(yych == '`')	goto yy294;
			if(yych <= 'z')	goto yy48;
			goto yy294;
		}
	}
yy294:
#line 346 "./modules/parsers/gas/gas-token.re"
{ parser_gas->state = INSTDIR; RETURN(DIR_2BYTE); }
#line 2731 "gas-token.c"
yy295:	yych = *++YYCURSOR;
	goto yy296;
yy296:
#line 336 "./modules/parsers/gas/gas-token.re"
{ RETURN(RIGHT_OP); }
#line 2737 "gas-token.c"
yy297:	yych = *++YYCURSOR;
	goto yy298;
yy298:
#line 335 "./modules/parsers/gas/gas-token.re"
{ RETURN(LEFT_OP); }
#line 2743 "gas-token.c"
yy299:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy300;
yy300:	if(yybm[0+yych] & 16) {
		goto yy299;
	}
	goto yy3;
yy301:	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '+')	goto yy314;
	if(yych == '-')	goto yy314;
	goto yy315;
yy302:
#line 316 "./modules/parsers/gas/gas-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->flt = yasm_floatnum_create(TOK+2);
	    s->tok[TOKLEN] = savech;
	    RETURN(FLTNUM);
	}
#line 2766 "gas-token.c"
yy303:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 128) {
		goto yy311;
	}
	goto yy40;
yy304:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy305;
yy305:	if(yybm[0+yych] & 32) {
		goto yy304;
	}
	goto yy306;
yy306:
#line 297 "./modules/parsers/gas/gas-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->intn = yasm_intnum_create_oct(TOK, cur_line);
	    s->tok[TOKLEN] = savech;
	    RETURN(INTNUM);
	}
#line 2789 "gas-token.c"
yy307:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 64) {
		goto yy308;
	}
	goto yy40;
yy308:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy309;
yy309:	if(yybm[0+yych] & 64) {
		goto yy308;
	}
	goto yy310;
yy310:
#line 288 "./modules/parsers/gas/gas-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->intn = yasm_intnum_create_bin(TOK+2, cur_line);
	    s->tok[TOKLEN] = savech;
	    RETURN(INTNUM);
	}
#line 2812 "gas-token.c"
yy311:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy312;
yy312:	if(yybm[0+yych] & 128) {
		goto yy311;
	}
	goto yy313;
yy313:
#line 306 "./modules/parsers/gas/gas-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    /* skip 0 and x */
	    lvalp->intn = yasm_intnum_create_hex(TOK+2, cur_line);
	    s->tok[TOKLEN] = savech;
	    RETURN(INTNUM);
	}
#line 2831 "gas-token.c"
yy314:	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
	yych = *YYCURSOR;
	goto yy315;
yy315:	if(yych <= '9'){
		if(yych == '.')	goto yy316;
		if(yych <= '/')	goto yy302;
		goto yy314;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy302;
			goto yy318;
		} else {
			if(yych == 'e')	goto yy318;
			goto yy302;
		}
	}
yy316:	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
	yych = *YYCURSOR;
	goto yy317;
yy317:	if(yych <= 'D'){
		if(yych <= '/')	goto yy302;
		if(yych <= '9')	goto yy316;
		goto yy302;
	} else {
		if(yych <= 'E')	goto yy318;
		if(yych != 'e')	goto yy302;
		goto yy318;
	}
yy318:	yych = *++YYCURSOR;
	if(yych <= ','){
		if(yych != '+')	goto yy40;
		goto yy319;
	} else {
		if(yych <= '-')	goto yy319;
		if(yych <= '/')	goto yy40;
		if(yych <= '9')	goto yy320;
		goto yy40;
	}
yy319:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy40;
	if(yych >= ':')	goto yy40;
	goto yy320;
yy320:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy321;
yy321:	if(yych <= '/')	goto yy302;
	if(yych <= '9')	goto yy320;
	goto yy302;
}
}
#line 497 "./modules/parsers/gas/gas-token.re"


    /* .section directive (the section name portion thereof) */
section_directive:
    SCANINIT();

    {
	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,  64,   0,   0,   0,  64,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	 64,   0,   0,   0, 128,   0,   0,   0, 
	  0,   0,   0,   0,   0, 128, 128,   0, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128,   0,   0,   0,   0,   0,   0, 
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0,   0, 128, 
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};

#line 2930 "gas-token.c"
{
	YYCTYPE yych;
	goto yy322;
	++YYCURSOR;
yy322:
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= '$'){
		if(yych <= '\r'){
			if(yych <= '\t'){
				if(yych <= '\b')	goto yy334;
				goto yy328;
			} else {
				if(yych <= '\n')	goto yy332;
				if(yych <= '\f')	goto yy334;
				goto yy328;
			}
		} else {
			if(yych <= '!'){
				if(yych == ' ')	goto yy328;
				goto yy334;
			} else {
				if(yych <= '"')	goto yy326;
				if(yych <= '#')	goto yy334;
				goto yy324;
			}
		}
	} else {
		if(yych <= '@'){
			if(yych <= '.'){
				if(yych <= '+')	goto yy334;
				if(yych <= ',')	goto yy330;
				goto yy324;
			} else {
				if(yych <= '/')	goto yy334;
				if(yych >= ':')	goto yy334;
				goto yy324;
			}
		} else {
			if(yych <= '_'){
				if(yych <= 'Z')	goto yy324;
				if(yych <= '^')	goto yy334;
				goto yy324;
			} else {
				if(yych <= '`')	goto yy334;
				if(yych >= '{')	goto yy334;
				goto yy324;
			}
		}
	}
yy324:	yych = *++YYCURSOR;
	goto yy339;
yy325:
#line 504 "./modules/parsers/gas/gas-token.re"
{
	    lvalp->str_val = yasm__xstrndup(TOK, TOKLEN);
	    parser_gas->state = INITIAL;
	    RETURN(ID);
	}
#line 2990 "gas-token.c"
yy326:	yych = *++YYCURSOR;
	goto yy327;
yy327:
#line 510 "./modules/parsers/gas/gas-token.re"
{ goto stringconst; }
#line 2996 "gas-token.c"
yy328:	yych = *++YYCURSOR;
	goto yy337;
yy329:
#line 512 "./modules/parsers/gas/gas-token.re"
{ goto section_directive; }
#line 3002 "gas-token.c"
yy330:	yych = *++YYCURSOR;
	goto yy331;
yy331:
#line 514 "./modules/parsers/gas/gas-token.re"
{
	    parser_gas->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 3011 "gas-token.c"
yy332:	yych = *++YYCURSOR;
	goto yy333;
yy333:
#line 519 "./modules/parsers/gas/gas-token.re"
{
	    if (parser_gas->save_input && cursor != s->eof)
		cursor = save_line(parser_gas, cursor);
	    parser_gas->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 3022 "gas-token.c"
yy334:	yych = *++YYCURSOR;
	goto yy335;
yy335:
#line 526 "./modules/parsers/gas/gas-token.re"
{
	    yasm__warning(YASM_WARN_UNREC_CHAR, cur_line,
			  N_("ignoring unrecognized character `%s'"),
			  yasm__conv_unprint(s->tok[0]));
	    goto section_directive;
	}
#line 3033 "gas-token.c"
yy336:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy337;
yy337:	if(yybm[0+yych] & 64) {
		goto yy336;
	}
	goto yy329;
yy338:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy339;
yy339:	if(yybm[0+yych] & 128) {
		goto yy338;
	}
	goto yy325;
}
}
#line 532 "./modules/parsers/gas/gas-token.re"


    /* character constant values */
charconst:
    /*TODO*/

    /* string constant values */
stringconst:
    strbuf = yasm_xmalloc(STRBUF_ALLOC_SIZE);
    strbuf_size = STRBUF_ALLOC_SIZE;
    count = 0;

stringconst_scan:
    SCANINIT();

    {
	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128,   0,   0,   0,   0,   0,   0, 
	  0, 128, 128, 128, 128, 128, 128,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0, 128, 128, 128, 128, 128, 128,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};

#line 3104 "gas-token.c"
{
	YYCTYPE yych;
	unsigned int yyaccept;
	goto yy340;
	++YYCURSOR;
yy340:
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if(yych == '"')	goto yy344;
	if(yych != '\\')	goto yy346;
	goto yy342;
yy342:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'b'){
		if(yych <= 'W'){
			if(yych <= '"'){
				if(yych >= '"')	goto yy347;
				goto yy343;
			} else {
				if(yych <= '/')	goto yy343;
				if(yych <= '9')	goto yy353;
				goto yy343;
			}
		} else {
			if(yych <= '['){
				if(yych <= 'X')	goto yy351;
				goto yy343;
			} else {
				if(yych <= '\\')	goto yy349;
				if(yych >= 'b')	goto yy362;
				goto yy343;
			}
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'f'){
				if(yych >= 'f')	goto yy360;
				goto yy343;
			} else {
				if(yych == 'n')	goto yy358;
				goto yy343;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'r')	goto yy356;
				if(yych >= 't')	goto yy354;
				goto yy343;
			} else {
				if(yych == 'x')	goto yy351;
				goto yy343;
			}
		}
	}
yy343:
#line 611 "./modules/parsers/gas/gas-token.re"
{
	    strbuf_append(count++, cursor, s, cur_line, s->tok[0]);
	    goto stringconst_scan;
	}
#line 3164 "gas-token.c"
yy344:	yych = *++YYCURSOR;
	goto yy345;
yy345:
#line 604 "./modules/parsers/gas/gas-token.re"
{
	    strbuf_append(count, cursor, s, cur_line, '\0');
	    lvalp->str.contents = (char *)strbuf;
	    lvalp->str.len = count;
	    RETURN(STRING);
	}
#line 3175 "gas-token.c"
yy346:	yych = *++YYCURSOR;
	goto yy343;
yy347:	yych = *++YYCURSOR;
	goto yy348;
yy348:
#line 595 "./modules/parsers/gas/gas-token.re"
{
	    strbuf_append(count++, cursor, s, cur_line, '"');
	    goto stringconst_scan;
	}
#line 3186 "gas-token.c"
yy349:	yych = *++YYCURSOR;
	goto yy350;
yy350:
#line 591 "./modules/parsers/gas/gas-token.re"
{
	    strbuf_append(count++, cursor, s, cur_line, '\\');
	    goto stringconst_scan;
	}
#line 3195 "gas-token.c"
yy351:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 128) {
		goto yy367;
	}
	goto yy352;
yy352:	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 0:	goto yy343;
	}
yy353:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy352;
	if(yych <= '9')	goto yy364;
	goto yy352;
yy354:	yych = *++YYCURSOR;
	goto yy355;
yy355:
#line 565 "./modules/parsers/gas/gas-token.re"
{
	    strbuf_append(count++, cursor, s, cur_line, '\t');
	    goto stringconst_scan;
	}
#line 3217 "gas-token.c"
yy356:	yych = *++YYCURSOR;
	goto yy357;
yy357:
#line 561 "./modules/parsers/gas/gas-token.re"
{
	    strbuf_append(count++, cursor, s, cur_line, '\r');
	    goto stringconst_scan;
	}
#line 3226 "gas-token.c"
yy358:	yych = *++YYCURSOR;
	goto yy359;
yy359:
#line 557 "./modules/parsers/gas/gas-token.re"
{
	    strbuf_append(count++, cursor, s, cur_line, '\n');
	    goto stringconst_scan;
	}
#line 3235 "gas-token.c"
yy360:	yych = *++YYCURSOR;
	goto yy361;
yy361:
#line 553 "./modules/parsers/gas/gas-token.re"
{
	    strbuf_append(count++, cursor, s, cur_line, '\f');
	    goto stringconst_scan;
	}
#line 3244 "gas-token.c"
yy362:	yych = *++YYCURSOR;
	goto yy363;
yy363:
#line 549 "./modules/parsers/gas/gas-token.re"
{
	    strbuf_append(count++, cursor, s, cur_line, '\b');
	    goto stringconst_scan;
	}
#line 3253 "gas-token.c"
yy364:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy352;
	if(yych >= ':')	goto yy352;
	goto yy365;
yy365:	yych = *++YYCURSOR;
	goto yy366;
yy366:
#line 569 "./modules/parsers/gas/gas-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->intn = yasm_intnum_create_oct(TOK+1, cur_line);
	    s->tok[TOKLEN] = savech;

	    strbuf_append(count++, cursor, s, cur_line,
			  yasm_intnum_get_int(lvalp->intn));
	    yasm_intnum_destroy(lvalp->intn);
	    goto stringconst_scan;
	}
#line 3273 "gas-token.c"
yy367:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy368;
yy368:	if(yybm[0+yych] & 128) {
		goto yy367;
	}
	goto yy369;
yy369:
#line 580 "./modules/parsers/gas/gas-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->intn = yasm_intnum_create_hex(TOK+2, cur_line);
	    s->tok[TOKLEN] = savech;

	    strbuf_append(count++, cursor, s, cur_line,
			  yasm_intnum_get_int(lvalp->intn));
	    yasm_intnum_destroy(lvalp->intn);
	    goto stringconst_scan;
	}
#line 3295 "gas-token.c"
}
}
#line 615 "./modules/parsers/gas/gas-token.re"


rept_directive:
    strbuf = yasm_xmalloc(STRBUF_ALLOC_SIZE);
    strbuf_size = STRBUF_ALLOC_SIZE;
    count = 0;
    linestart = 1;


rept_scan:
    SCANINIT();

    {

#line 3313 "gas-token.c"
{
	YYCTYPE yych;
	unsigned int yyaccept;
	goto yy370;
	++YYCURSOR;
yy370:
	if((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if(yych <= '-'){
		if(yych != '\n')	goto yy376;
		goto yy372;
	} else {
		if(yych <= '.')	goto yy374;
		if(yych != ';')	goto yy376;
		goto yy372;
	}
yy372:	yych = *++YYCURSOR;
	goto yy373;
yy373:
#line 628 "./modules/parsers/gas/gas-token.re"
{
	    /* Line ending, save in lines */
	    new_line = yasm_xmalloc(sizeof(gas_rept_line));
	    if (cursor == s->eof) {
		yasm_xfree(strbuf);
		return 0;
	    }
	    strbuf_append(count++, cursor, s, cur_line, s->tok[0]);
	    new_line->data = strbuf;
	    new_line->len = count;
	    STAILQ_INSERT_TAIL(&rept->lines, new_line, link);
	    /* Allocate new strbuf */
	    strbuf = yasm_xmalloc(STRBUF_ALLOC_SIZE);
	    strbuf_size = STRBUF_ALLOC_SIZE;
	    count = 0;
	    /* Mark start of line */
	    linestart = 1;
	    goto rept_scan;
	}
#line 3353 "gas-token.c"
yy374:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych == 'E')	goto yy377;
		if(yych >= 'R')	goto yy379;
		goto yy375;
	} else {
		if(yych <= 'e'){
			if(yych >= 'e')	goto yy377;
			goto yy375;
		} else {
			if(yych == 'r')	goto yy379;
			goto yy375;
		}
	}
yy375:
#line 706 "./modules/parsers/gas/gas-token.re"
{
	    if (cursor == s->eof) {
		yasm_xfree(strbuf);
		return 0;
	    }
	    strbuf_append(count++, cursor, s, cur_line, s->tok[0]);
	    linestart = 0;
	    goto rept_scan;
	}
#line 3380 "gas-token.c"
yy376:	yych = *++YYCURSOR;
	goto yy375;
yy377:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy384;
	if(yych == 'n')	goto yy384;
	goto yy378;
yy378:	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 0:	goto yy375;
	}
yy379:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy380;
	if(yych != 'e')	goto yy378;
	goto yy380;
yy380:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy381;
	if(yych != 'p')	goto yy378;
	goto yy381;
yy381:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy382;
	if(yych != 't')	goto yy378;
	goto yy382;
yy382:	yych = *++YYCURSOR;
	goto yy383;
yy383:
#line 647 "./modules/parsers/gas/gas-token.re"
{
	    int i;
	    if (linestart) {
		/* We don't support nested right now, error */
		yasm__error(cur_line, N_("nested rept not supported"));
	    }
	    for (i=0; i<6; i++)
		strbuf_append(count++, cursor, s, cur_line, s->tok[i]);
	    goto rept_scan;
	}
#line 3417 "gas-token.c"
yy384:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy385;
	if(yych != 'd')	goto yy378;
	goto yy385;
yy385:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy386;
	if(yych != 'r')	goto yy378;
	goto yy386;
yy386:	yych = *++YYCURSOR;
	goto yy387;
yy387:
#line 657 "./modules/parsers/gas/gas-token.re"
{
	    if (linestart) {
		/* We're done, kick off the main lexer */
		rept->line = STAILQ_FIRST(&rept->lines);
		if (!rept->line) {
		    /* Didn't get any intervening data?  Empty repeat, so
		     * don't even bother.
		     */
		    yasm_xfree(strbuf);
		    yasm_xfree(rept);
		    parser_gas->rept = NULL;
		} else {
		    rept->ended = 1;

		    /* Add .line as first line to get line numbers correct */
		    new_line = yasm_xmalloc(sizeof(gas_rept_line));
		    new_line->data = yasm_xmalloc(40);
		    sprintf((char *)new_line->data, ".line %lu;",
			    rept->startline+1);
		    new_line->len = strlen((char *)new_line->data);
		    STAILQ_INSERT_HEAD(&rept->lines, new_line, link);

		    /* Save previous fill buffer */
		    rept->oldbuf = parser_gas->s.bot;
		    rept->oldbuflen = s->lim - s->bot;
		    rept->oldbufpos = cursor - s->bot;

		    /* Reset fill */
		    s->bot = NULL;
		    s->tok = NULL;
		    s->ptr = NULL;
		    s->cur = NULL;
		    s->pos = NULL;
		    s->lim = NULL;
		    s->top = NULL;
		    s->eof = NULL;
		    cursor = NULL;
		    YYFILL(1);
		}

		goto scan;
	    } else {
		int i;
		for (i=0; i<6; i++)
		    strbuf_append(count++, cursor, s, cur_line, s->tok[i]);
		goto rept_scan;
	    }
	}
#line 3478 "gas-token.c"
}
}
#line 715 "./modules/parsers/gas/gas-token.re"


}
