#!perl -w
#
# OpenFirmwareDev -- the probed values for an OpenFirmware device, as found in /sys.
#   this file is based on PciDev which is
#   Copyright (C) 2005  Erik van Konijnenburg
#   and modified for OpenFirmware by Bernhard R. Link in 2006
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
#
use strict;
use warnings;
use Base;
package OpenFirmwareDev;
use base 'Obj';

sub fill {
	my $self = shift;
	$self->SUPER::fill();
	$self->takeArgs ('path');
	my $path = $self->path;
	my $devspec = Base::getStringFile ("$path/devspec");
	$devspec =~ s/.*\///;
	$devspec =~ s/@[^@]*$//;
	$self->{name} = $devspec;
}

sub path	{ return $_[0]->{path}; }
sub name	{ return $_[0]->{name}; }

1;
