#include "file_option.h"
#include "cppdir.h"

using namespace CppDir;

Arg::FileOptionRule::FileOptionRule( FileType type )
  : AnyStringRule(),
    type( type )
{
  continue_on_fail = false;

  error = "value is not a valid ";

  switch( type )
    {
    case FILE_DIR:     description = "DIR";  error += " directory";         break;
    case FILE_LINK:    description = "LINK"; error += " symlink";           break;
    case FILE_REGULAR: description = "FILE"; error += " regular file";      break;
    case FILE_ANY:     description = "FILE"; error += " file or directory"; break;
    case FILE_LINK_TO_DIR: description = "LINK"; error += " link to directory"; break;
    case FILE_LINK_TO_REGULAR: description = "LINK"; error += " link to a regular file"; break;
    }
}

bool Arg::FileOptionRule::match( const std::string &name ) const
{
  File file( name );

  if( !file )
    return false;

  switch( type )
    {
    case FILE_LINK_TO_DIR: if( (file.get_type() == File::DIR) && file.is_link() ) return true; break;
    case FILE_LINK_TO_REGULAR: if( file.get_type() == File::REGULAR && file.is_link() ) return true; break;
    case FILE_DIR:     if( file.get_type() == File::DIR ) return true; break;
    case FILE_LINK:    if( file.is_link() ) return true; break;
    case FILE_REGULAR: if( file.get_type() == File::REGULAR ) return true; break;
    case FILE_ANY:     return true;
    }

  return false;
}


Arg::FileOption::FileOption( FileType type )
  : StringOption()
{
  value_rule = new FileOptionRule( type );

  setMaxValues( 1 );
  setMinValues( 1 );
}

Arg::FileOption::FileOption( const std::string &name, FileType type )
  : StringOption( name )
{
  value_rule = new FileOptionRule( type );

  setMaxValues( 1 );
  setMinValues( 1 );
}

Arg::EmptyFileOption::EmptyFileOption( FileType type )
  : EmptyStringOption()
{
  value_rule = new FileOptionRule( type );

  setMaxValues( 1 );
  setMinValues( 1 );
}
