/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EMUDIALOG_H
#define EMUDIALOG_H

#include "wrapper/emucfg.h"

#include "EmuDialogData.h"

class EmuDialog : public EmuDialogData
{
    Q_OBJECT

public:

    EmuDialog(QWidget* parent = 0, const char* name = 0);
    
    void setConfig(const emuConfig&);
    const emuConfig& getConfig() const;

 public slots:

    void receiveConfig(const emuConfig&);

 protected:

    emuConfig config;
    
 protected slots:

    void newCLKsetting(int);
    void newMPUsetting(int);
    void newEMUsetting(int);
    void newSIDsetting(int);

 signals:

    void changed(const emuConfig&);

 private:
    
    void setButtons();
    
    bool changedSignalEnabled;
    void enableChangedSignal(bool);
    void emitChangedIfEnabled();

};

#endif  /* EMUDIALOG_H */
