/*
 * Copyright 2005 Luc Verhaegen.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_CH7XXX_H_
#define _VIA_CH7XXX_H_ 1

/*
 * All the info here is nicely documented in Chrontel datasheets.
 * Chrontel makes these freely available. Don't you just love 'em?
 *
 * We currently only implement PAL and NTSC. We don't care about
 * NTSC (dotcrawl reduction), PAL-M or PAL-N.
 */

static struct CH7011ClockRec {
    int Clock;
    Bool    PLLCap;
    CARD16  PLLM;
    CARD16  PLLN;
} CH7011Clocks[] = {
    { 13500, TRUE,   33,  31 },
    { 20140, FALSE,  89, 126 },
    { 21000, TRUE,   13,  20 },
    { 21147, FALSE,  63,  94 },
    { 23790, FALSE,  63, 106 },
    { 24671, FALSE,  63, 110 },
    { 25000, FALSE,  61, 108 },
    { 26182, TRUE,   33,  62 },
    { 26250, TRUE,    4,   9 },
    { 27563, TRUE,   38,  75 },
    { 27755, FALSE,  63, 124 },
    { 28125, TRUE,   26,  53 },
    { 28196, FALSE,  63, 126 },
    { 29455, TRUE,   33,  70 },
    { 29500, FALSE, 313, 647 },
    { 30210, FALSE,  89, 190 },
    { 31500, TRUE,    3,   9 },
    { 31720, FALSE,  63, 142 },
    { 33750, TRUE,   12,  31 },
    { 33986, FALSE,  89, 214 },
    { 36000, TRUE,   33,  86 },
    { 39375, TRUE,    2,   9 },
    { 42000, TRUE,   13,  42 },
    { 43636, TRUE,   19,  62 },
    { 47832, FALSE,  89, 302 },
    { 52364, TRUE,   33, 126 },
    { 58406, FALSE, 137, 565 },
    { 61250, TRUE,   16,  75 },
    { 65706, FALSE,  71, 333 },
    { 70000, TRUE,    7,  42 },
    { 73510, FALSE, 177, 917 },
    { 78750, TRUE,    2,  20 },
    { 0, FALSE, 0, 0 },
};

#define CH7011ID { 'C', 'H', '7', '0', '1', '1', 0, 0, 0, 0, 0, 0 }

struct CH7011TableRec {
    char    ID[12]; /* "CH7xxx" */
    int     Standard;
    CARD8   Mode;
    CARD32  FSCI;
    CARD16  HPosition; /* touch me. */
    CARD16  VPosition; /* touch me. */
};

static struct CH7011TableRec CH7011TVTable[40] = {
    { CH7011ID, TVSTANDARD_PAL,  0x00, 806021060, 0x028, 0x0FA }, /* 00 */
    { CH7011ID, TVSTANDARD_PAL,  0x01, 644816848, 0x028, 0x138 }, /* 01 */
    { CH7011ID, TVSTANDARD_NTSC, 0x08, 763363328, 0x028, 0x0D2 }, /* 02 */
    { CH7011ID, TVSTANDARD_NTSC, 0x09, 623153737, 0x028, 0x106 }, /* 03 */
    { CH7011ID, TVSTANDARD_PAL,  0x20, 601829058, 0x028, 0x0FA }, /* 04 */
    { CH7011ID, TVSTANDARD_PAL,  0x21, 470178951, 0x028, 0x138 }, /* 05 */
    { CH7011ID, TVSTANDARD_NTSC, 0x28, 574429782, 0x028, 0x0D2 }, /* 06 */
    { CH7011ID, TVSTANDARD_NTSC, 0x29, 463962517, 0x028, 0x106 }, /* 07 */
    { CH7011ID, TVSTANDARD_PAL,  0x40, 677057690, 0x028, 0x0FA }, /* 08 */
    { CH7011ID, TVSTANDARD_PAL,  0x41, 537347373, 0x028, 0x138 }, /* 09 */
    { CH7011ID, TVSTANDARD_NTSC, 0x48, 646233505, 0x028, 0x0D2 }, /* 10 */
    { CH7011ID, TVSTANDARD_NTSC, 0x49, 521957831, 0x028, 0x106 }, /* 11 */
    { CH7011ID, TVSTANDARD_NTSC, 0x4A, 452363454, 0x028, 0x12C }, /* 12 */
    { CH7011ID, TVSTANDARD_PAL,  0x60, 806021060, 0x01B, 0x12D }, /* 13 */
    { CH7011ID, TVSTANDARD_PAL,  0x61, 644816848, 0x035, 0x133 }, /* 14 */
    { CH7011ID, TVSTANDARD_PAL,  0x62, 537347373, 0x028, 0x177 }, /* 15 */
    { CH7011ID, TVSTANDARD_NTSC, 0x69, 623153737, 0x019, 0x100 }, /* 16 */
    { CH7011ID, TVSTANDARD_NTSC, 0x6A, 545259520, 0x02E, 0x104 }, /* 17 */
    { CH7011ID, TVSTANDARD_NTSC, 0x6B, 508908885, 0x028, 0x13B }, /* 18 */
    { CH7011ID, TVSTANDARD_NTSC, 0x89, 553914433, 0x028, 0x106 }, /* 19 */
    { CH7011ID, TVSTANDARD_NTSC, 0x8A, 484675129, 0x028, 0x12C }, /* 20 */
    { CH7011ID, TVSTANDARD_NTSC, 0x8B, 452363454, 0x028, 0x13B }, /* 21 */
    { CH7011ID, TVSTANDARD_PAL,  0xA1, 690875194, 0x028, 0x138 }, /* 22 */
    { CH7011ID, TVSTANDARD_PAL,  0xA2, 564214742, 0x028, 0x177 }, /* 23 */
    { CH7011ID, TVSTANDARD_PAL,  0xA3, 483612636, 0x028, 0x1B5 }, /* 24 */
    { CH7011ID, TVSTANDARD_PAL,  0xC1, 645499916, 0x01D, 0x136 }, /* 25 */
    { CH7011ID, TVSTANDARD_PAL,  0xC3, 528951320, 0x03F, 0x138 }, /* 26 */
    { CH7011ID, TVSTANDARD_PAL,  0xC4, 453386846, 0x028, 0x1B5 }, /* 27 */
    { CH7011ID, TVSTANDARD_NTSC, 0xCE, 469762048, 0x02E, 0x110 }, /* 28 */
    { CH7011ID, TVSTANDARD_NTSC, 0xCF, 428554851, 0x03C, 0x115 }, /* 29 */
    { CH7011ID, TVSTANDARD_NTSC, 0xCD, 391468373, 0x028, 0x1A4 }, /* 30 */
    { CH7011ID, TVSTANDARD_PAL,  0xE4, 621787675, 0x028, 0x137 }, /* 31 */
    { CH7011ID, TVSTANDARD_PAL,  0xE5, 544064215, 0x03E, 0x14A }, /* 32 */
    { CH7011ID, TVSTANDARD_PAL,  0xE6, 483612636, 0x028, 0x1FF }, /* 33 */
    { CH7011ID, TVSTANDARD_NTSC, 0xED, 526457468, 0x020,     0 }, /* 34 */
    { CH7011ID, TVSTANDARD_NTSC, 0xEE, 467962193, 0x032, 0x009 }, /* 35 */
    { CH7011ID, TVSTANDARD_NTSC, 0xEF, 418281276, 0x028, 0x1FF }, /* 36 */
    { CH7011ID, TVSTANDARD_PAL,  0xA0, 705268427, 0x028, 0x138 }, /* 37 */
    { CH7011ID, TVSTANDARD_NTSC, 0x88, 569408543, 0x028, 0x106 }, /* 38 */
};

#define MODEPREFIX(name) NULL, NULL, name, 0,M_T_DEFAULT
#define MODESUFFIX(bleh)       0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE, \
sizeof(struct CH7011TableRec), (void *)&CH7011TVTable[(bleh)],0,0.0,0.0

/*
 * HSync: 31.47-56.64
 * VRefresh: 59.94Hz
 */
static DisplayModeRec CH7011TVModesNTSC[] = {
    { MODEPREFIX("640x480Over"),  24671,  640,  656,  752,  784, 0,  480,  494,  496,  525, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX(16) }, /* 16 */
    { MODEPREFIX("640x480"),      28196,  640,  656,  752,  784, 0,  480,  520,  528,  600, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX(17) }, /* 17 */
    { MODEPREFIX("800x600Over"),  43636,  800,  840,  960, 1040, 0,  600,  602,  608,  700, 0, V_PHSYNC | V_PVSYNC, MODESUFFIX(28) }, /* 28 */
    { MODEPREFIX("800x600"),      47832,  800,  840,  976, 1064, 0,  600,  604,  608,  750, 0, V_PHSYNC | V_PVSYNC, MODESUFFIX(29) }, /* 29 */
    { MODEPREFIX("1024x768Over"), 58406, 1024, 1032, 1088, 1160, 0,  768,  772,  784,  840, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX(34) }, /* 34 */
    { MODEPREFIX("1024x768"),     65706, 1024, 1032, 1088, 1160, 0,  768,  780,  784,  945, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX(35) }, /* 35 */
    { MODEPREFIX(NULL), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE, 0, NULL, 0,0.0,0.0},
};

/*
 * HSync: 25.0-68.6
 * VRefresh: 50.0Hz
 */
static DisplayModeRec CH7011TVModesPAL[] = {
    { MODEPREFIX("640x480Over"),  21000,  640,  664,  792,  840, 0,  480,  485,  496,  500, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX(13) }, /* 13 */
    { MODEPREFIX("640x480"),      26250,  640,  664,  792,  840, 0,  480,  529,  544,  625, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX(14) }, /* 14 */
    { MODEPREFIX("800x600Over"),  29500,  800,  824,  896,  944, 0,  600,  602,  608,  625, 0, V_PHSYNC | V_PVSYNC, MODESUFFIX(25) }, /* 25 */
    { MODEPREFIX("800x600"),      36000,  800,  824,  904,  960, 0,  600,  638,  640,  750, 0, V_PHSYNC | V_PVSYNC, MODESUFFIX(26) }, /* 26 */
    { MODEPREFIX("1024x768Over"), 61250, 1024, 1056, 1208, 1400, 0,  768,  775,  784,  875, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX(31) }, /* 31 */
    { MODEPREFIX("1024x768"),     70000, 1024, 1048, 1208, 1400, 0,  768,  785,  800, 1000, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX(32) }, /* 32 */
    { MODEPREFIX(NULL), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE, 0, NULL, 0,0.0,0.0},
};

#endif /* _VIA_CH7XXX_H_ */
