/*
 * Copyright (c) 2001-2007
 *     DecisionSoft Limited. All rights reserved.
 * Copyright (c) 2004-2007
 *     Oracle. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: UApplyUpdates.hpp,v 1.4 2007/11/28 13:13:25 jpcs Exp $
 */

#ifndef _UAPPLYUPDATE_HPP
#define _UAPPLYUPDATE_HPP

#include <xqilla/framework/XQillaExport.hpp>
#include <xqilla/ast/ASTNodeImpl.hpp>
#include <xqilla/schema/DocumentCache.hpp>

class XQILLA_API UApplyUpdates : public ASTNodeImpl
{
public:
  UApplyUpdates(ASTNode *expr, XPath2MemoryManager* memMgr);

  virtual ASTNode *staticResolution(StaticContext *context);
  virtual ASTNode *staticTyping(StaticContext *context);
  virtual Sequence createSequence(DynamicContext* context, int flags=0) const;

  const ASTNode *getExpression() const { return expr_; }
  void setExpression(ASTNode *expr) { expr_ = expr; }

  DocumentCache::ValidationMode getRevalidationMode() const { return valMode_; }

protected:
  ASTNode *expr_;
  DocumentCache::ValidationMode valMode_;
};

#endif
