/*

    xpuyopuyo - pkey-gtk.c          Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org           http://chaos2.org/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdlib.h>
#include <stdio.h>
#include <config.h>
#include <pkey-gtk.h>
#include <psnprintf.h>
#include <pdialog-gtk.h>
#include <pfile.h>



static inline const char *p_key_name(int keytype) {

   switch(keytype) {
      case P_KEY_LEFT: return("Left");
      case P_KEY_RIGHT:return("Right");
      case P_KEY_UP:   return("Rotate");
      case P_KEY_DOWN: return("Drop");
   }
   return("Unknown");
   
}



static inline void p_key_save_line(FILE *f, int who, int key, int alt, guint keysym) {

   if(keysym == 0) fprintf(f, "%d:%d:%d=<none>\n", who, key, alt);
   else            fprintf(f, "%d:%d:%d=%s\n", who, key, alt, gdk_keyval_name(keysym));
   return;

}



static void p_key_save(pwindow_gtk *w) {

   FILE *f;
   int i;
   int j;
   int k;
   
   if((f = p_file_open_write(P_KEY_FILE)) == NULL) return;
   
   fprintf(f, "# xpuyopuyo key configuration file - automatically generated\n#\n");
   fprintf(f, "# WARNING:  There is no error checking on input values in this file\n");
   fprintf(f, "# Do not edit these directly unless you know what you are doing.  \n#\n");
                  
   for(j = 0; j < P_NUM_PLAYERS; j++) {
      for(i = 0; i < P_NUM_ALTERNATE_KEYS; i++) {
         for(k = 0; k < P_NUM_KEY_TYPES; k++) {
            p_key_save_line(f, j, k, i, P_KEYW(w, j, k, i));
         }
      }
   }

   fclose(f);
   return;

}



void p_key_load_keys(pwindow_gtk *w) {

   char buf[P_IO_BUFFER];
   char *peq;
   char *pcol;
   char *pcol2;
   FILE *f;
   guint keysym;
   int whichplayer;
   int whichkey;
   int whichalt;
   int i;
   
   for(i = 0; i < P_NUM_KEYS; i++) {
      P_KEY_IW(w, i) = 0;
   }
   
   if((f = p_file_open_read(P_KEY_FILE)) == NULL) {
      printf("key_load:  generating new default keys.\n");
      P_KEYW(w, 0, P_KEY_LEFT, 0) = GDK_A;
      P_KEYW(w, 0, P_KEY_RIGHT, 0)= GDK_D;
      P_KEYW(w, 0, P_KEY_UP, 0)   = GDK_S;
      P_KEYW(w, 0, P_KEY_DOWN, 0) = GDK_X;
      P_KEYW(w, 0, P_KEY_DOWN, 1) = GDK_Z;
      P_KEYW(w, 1, P_KEY_LEFT, 0) = GDK_Left;
      P_KEYW(w, 1, P_KEY_LEFT, 1) = GDK_KP_4;
      P_KEYW(w, 1, P_KEY_RIGHT,0) = GDK_Right;
      P_KEYW(w, 1, P_KEY_RIGHT,1) = GDK_KP_6;
      P_KEYW(w, 1, P_KEY_UP, 0)   = GDK_Up;
      P_KEYW(w, 1, P_KEY_UP, 1)   = GDK_KP_8;
      P_KEYW(w, 1, P_KEY_DOWN, 0) = GDK_Down;
      P_KEYW(w, 1, P_KEY_DOWN, 1) = GDK_KP_5;
      P_KEYW(w, 1, P_KEY_DOWN, 1) = GDK_KP_2;
      p_key_save(w);
   } else {
      while(p_file_read_line(buf, P_IO_BUFFER, f)) {
         if((peq = p_file_break(buf, '='))) {
            if(!(pcol = p_file_break(buf, ':'))) {
               printf("key_load:  Need a colon after player value:  \"%s\"\n", buf);
            } else {
               if(!(pcol2 = p_file_break(pcol, ':'))) {
                  printf("key_load:  Need a colon after key type value:  \"%s\"\n", pcol);
               } else {
                  whichplayer = atoi(buf) % P_NUM_PLAYERS;
                  whichkey =    atoi(pcol) % P_NUM_KEY_TYPES;
                  whichalt =    atoi(pcol2)% P_NUM_ALTERNATE_KEYS;
                  if(strcmp(peq + 1, "<none>") == 0) {
                     keysym = 0;
                  } else {
                     keysym = gdk_keyval_from_name(peq);
                     if(keysym == GDK_VoidSymbol) {
                        printf("key_load:  Key symbol \"%s\" is invalid; assuming \"<none>\"\n", peq + 1);
                        keysym = 0;
                     }
                  }
                  P_KEYW(w, whichplayer, whichkey, whichalt) = keysym;
               } /* Found second : */
            } /* Found first : */
         } /* Found = */
      } /* While reading file */
      fclose(f);
   }
               
   return;

}



static gboolean p_key_record(GtkWidget *edit, GdkEventKey *event, gpointer data) {

   if(event->keyval == GDK_Escape) {
      gtk_entry_set_text(GTK_ENTRY(edit), "");
   } else {
      gtk_entry_set_text(GTK_ENTRY(edit), gdk_keyval_name(gdk_keyval_to_upper(event->keyval)));
   }
   return(TRUE);

}



static void p_key_boxes(pwindow_gtk *w, GtkWidget *grid, int player, int whichkey, GtkWidget **edits) {

   GtkWidget *label;
   GtkWidget *edit;
   const char *key;
   int row;
   int i;
   
   row = player * (P_NUM_KEY_TYPES + 2) + 1 + whichkey;
   
   label = gtk_label_new(p_key_name(whichkey));
   gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
   gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
   gtk_table_attach(GTK_TABLE(grid), label, 0, 1, row, row + 1, GTK_FILL, GTK_FILL, 2, 2);
   for(i = 0; i < P_NUM_ALTERNATE_KEYS; i++) {
      edit = gtk_entry_new_with_max_length(0x20);
      key = gdk_keyval_name(P_KEYW(w, player, whichkey, i));
      if(!key) key = "";
      gtk_entry_set_text(GTK_ENTRY(edit), key);
      gtk_entry_set_editable(GTK_ENTRY(edit), FALSE);
      gtk_widget_set_events(edit, GDK_KEY_PRESS_MASK);
      gtk_signal_connect(GTK_OBJECT(edit), "key_press_event", GTK_SIGNAL_FUNC(p_key_record), NULL);
      gtk_table_attach(GTK_TABLE(grid), edit, 1 + i, 2 + i, row, row + 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
      edits[P_KEY_INDEX(player, whichkey, i)] = edit;
   }

}



void p_key_ok_clicked(p_dialog_window *dw) {

   pwindow_gtk *w = dw->w;
   GtkWidget **entry = dw->data;
   char buf[0x1000];
   guint key;
   guint keysym[P_NUM_PLAYERS * P_NUM_KEYS_PER_PLAYER];
   int i;
   int j;
   int k;
   int l;
   
   /* Search for duplicate entries */
   for(i = 0; i < P_NUM_PLAYERS; i++) {
      for(j = 0; j < P_NUM_KEY_TYPES; j++) {
         for(k = 0; k < P_NUM_ALTERNATE_KEYS; k++) {
            key = gdk_keyval_from_name(gtk_entry_get_text(GTK_ENTRY(entry[P_KEY_INDEX(i, j, k)])));
            if(key == GDK_VoidSymbol) key = 0;
            keysym[P_KEY_INDEX(i, j, k)] = key;
            if(key != 0) for(l = P_KEY_INDEX(i, j, k) - 1; l > 0; l--) {
               if(key == keysym[l]) {
                  p_snprintf(buf, 0x1000, "Two or more fields are using the same key:  \"%s\"", gdk_keyval_name(key));
                  p_dialog_error(w, buf);
                  return;
               }
            }
         }
      }
   }
   
   /* Copy keys */
   for(i = 0; i < P_NUM_PLAYERS; i++) {
      for(j = 0; j < P_NUM_KEY_TYPES; j++) {
         for(k = 0; k < P_NUM_ALTERNATE_KEYS; k++) {
            P_KEYW(w, i, j, k) = keysym[P_KEY_INDEX(i, j, k)];
         }
      }
   }

   p_key_save(w);
   return;

}



void p_key_select_keys(pwindow_gtk *w) {

   p_dialog_window dw;
   char buf[P_GTK_STRING_BUFFER];
   GtkWidget *entry[P_NUM_KEYS];
   GtkWidget *grid;
   GtkWidget *label;
   int i;

   p_dialog_window_new(&dw, w, "Set New Keys", 
                       "Select new keys for player 1 and player 2 by clicking on the appropriate field below, "
                       "and pressing the new key.  Press Escape in a field to clear "
                       "the value for a specific key.\n", P_DIALOG_QUERY);
   p_dialog_window_set_apply(&dw, p_key_ok_clicked);
   p_dialog_window_set_data(&dw, entry);

   grid = gtk_table_new(P_NUM_PLAYERS * 6, P_NUM_ALTERNATE_KEYS + 1, FALSE);
   gtk_container_set_border_width(GTK_CONTAINER(grid), 10);
   gtk_box_pack_start(GTK_BOX(dw.container), grid, TRUE, TRUE, 0);
   
   for(i = 0; i < P_NUM_PLAYERS; i++) {
      p_snprintf(buf, P_GTK_STRING_BUFFER, "Player %d keys", i + 1);
      label = gtk_label_new(buf);
      gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
      gtk_table_attach(GTK_TABLE(grid), label, 0, P_NUM_ALTERNATE_KEYS + 1, i * 6, 1 + i * 6, GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
      p_key_boxes(w, grid, i, P_KEY_LEFT, entry);
      p_key_boxes(w, grid, i, P_KEY_RIGHT,entry);
      p_key_boxes(w, grid, i, P_KEY_UP,   entry);
      p_key_boxes(w, grid, i, P_KEY_DOWN, entry);
      label = gtk_label_new(" ");
      gtk_table_attach(GTK_TABLE(grid), label, 0, P_NUM_ALTERNATE_KEYS + 1, 5 + i * 6, 6 + i * 6, GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
   }

   p_dialog_window_run(&dw);
   return;
   
}
