/*

    xpuyopuyo - ptime.h       Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Macros for manipulating time
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __ptime_h_defined
#define __ptime_h_defined


#if TIME_WITH_SYS_TIME        /* Setup time headers */
#  include <sys/time.h>
#  include <time.h>
#else
#  if HAVE_SYS_TIME_H
#    include <sys/time.h>
#  else
#    include <time.h>
#  endif
#endif


/* Time value macros */
#define TV_USEC_IN_SEC     1000000
#define TV_MSEC_IN_SEC     1000
#define TV_USEC_IN_MSEC    (TV_USEC_IN_SEC / TV_MSEC_IN_SEC)
#define TV_SEC_IN_MIN      60
#define TV_MIN_IN_HOUR     60
#define TV_SEC_IN_HOUR     (TV_SEC_IN_MIN * TV_MIN_IN_HOUR)
#define TV_COPY(a,b)       (a).tv_sec = (b).tv_sec;    \
                           (a).tv_usec = (b).tv_usec
#define TV_SET(a,s,u)      (a).tv_sec = s;             \
                           (a).tv_usec = u
#define TV_ZERO(a)         TV_SET((a), 0, 0)
#define TV_CLEAR(a)        TV_ZERO((a))

/* Addition, subtraction of times */
#define TV_ADD(a,b)        (a).tv_usec += (b).tv_usec; \
                           if((a).tv_usec >= TV_USEC_IN_SEC) {\
                              (a).tv_usec -= TV_USEC_IN_SEC;  \
                              (a).tv_sec++;            \
                           }                           \
                           (a).tv_sec += (b).tv_sec
#define TV_SUB(a,b)        (a).tv_usec -= (b).tv_usec; \
                           if((a).tv_usec < 0) {\
                              (a).tv_usec += TV_USEC_IN_SEC;  \
                              (a).tv_sec--;            \
                           }                           \
                           (a).tv_sec -= (b).tv_sec

/* Comparison of times */
#define TV_EQUAL(a,b)      ((a).tv_sec == (b).tv_sec && (a).tv_usec == (b).tv_usec)
#define TV_GREATER(a,b)    ((a).tv_sec > (b).tv_sec || ((a).tv_sec == (b).tv_sec && (a).tv_usec > (b).tv_usec))
#define TV_GREATER_EQUAL(a,b) (TV_GREATER((a), (b)) || TV_EQUAL((a), (b)))
#define TV_UNEQUAL(a,b)    !TV_EQUAL((a), (b))
#define TV_LESS(a,b)       !TV_GREATER_EQUAL((a), (b))
#define TV_LESS_EQUAL(a,b) !TV_GREATER((a), (b))

/* Conversion to/from unsigned long milliseconds */
#define TV_MILLISEC(a)     ((a).tv_sec * TV_MSEC_IN_SEC + (a).tv_usec / TV_USEC_IN_MSEC)
#define TV_FROM_MILLISEC(a,d) TV_SET((a), (d) / TV_MSEC_IN_SEC, ((d) % TV_MSEC_IN_SEC) * TV_USEC_IN_MSEC)


#endif
