/*
* Copyright (C) 2013 Canonical Ltd
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 3 as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#ifndef _XPATHQUERYPART_H
#define _XPATHQUERYPART_H

#include <string>
#include <vector>
#include <memory>

#include <boost/optional/optional.hpp>

#include "node.h"

namespace xpathselect
{
    // stores a parameter name, value pair.
    struct XPathQueryParam
    {
        std::string param_name;
        std::string param_value;
    };

    // Stores a part of an XPath query.
    struct XPathQueryPart
    {
    public:
        enum class QueryPartType {Normal, Search};

        bool Matches(Node::Ptr const& node) const
        {
            bool matches = (node_name_ == "*" || node->GetName() == node_name_);
            if (parameter)
            {
                matches &= node->MatchProperty(parameter->param_name, parameter->param_value);
            }

            return matches;
        }

        QueryPartType Type() const { return (node_name_ == "") ? QueryPartType::Search :  QueryPartType::Normal; }

        std::string node_name_;
        boost::optional<XPathQueryParam> parameter;
    };



    typedef std::vector<XPathQueryPart> QueryList;

}

#endif
