/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/redist_transaction4_xif.cc,v 1.21 2009/01/05 18:31:13 jtc Exp $"

#include "redist_transaction4_xif.hh"

bool
XrlRedistTransaction4V0p1Client::send_start_transaction(
	const char*	dst_xrl_target_name,
	const StartTransactionCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "redist_transaction4/0.1/start_transaction");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlRedistTransaction4V0p1Client::unmarshall_start_transaction, cb));
}


/* Unmarshall start_transaction */
void
XrlRedistTransaction4V0p1Client::unmarshall_start_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	StartTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t tid;
    try {
	a->get("tid", tid);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &tid);
}

bool
XrlRedistTransaction4V0p1Client::send_commit_transaction(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const CommitTransactionCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "redist_transaction4/0.1/commit_transaction");
        x->args().add(XrlAtom(tid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, tid);

    return _sender->send(*x, callback(this, &XrlRedistTransaction4V0p1Client::unmarshall_commit_transaction, cb));
}


/* Unmarshall commit_transaction */
void
XrlRedistTransaction4V0p1Client::unmarshall_commit_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	CommitTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRedistTransaction4V0p1Client::send_abort_transaction(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const AbortTransactionCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "redist_transaction4/0.1/abort_transaction");
        x->args().add(XrlAtom(tid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, tid);

    return _sender->send(*x, callback(this, &XrlRedistTransaction4V0p1Client::unmarshall_abort_transaction, cb));
}


/* Unmarshall abort_transaction */
void
XrlRedistTransaction4V0p1Client::unmarshall_abort_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	AbortTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRedistTransaction4V0p1Client::send_add_route(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const IPv4Net&	dst,
	const IPv4&	nexthop,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	admin_distance,
	const string&	cookie,
	const string&	protocol_origin,
	const AddRouteCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "redist_transaction4/0.1/add_route");
        x->args().add(XrlAtom(tid));
        x->args().add(XrlAtom(dst));
        x->args().add(XrlAtom(nexthop));
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(metric));
        x->args().add(XrlAtom(admin_distance));
        x->args().add(XrlAtom(cookie));
        x->args().add(XrlAtom(protocol_origin));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, tid);
    x->args().set_arg(1, dst);
    x->args().set_arg(2, nexthop);
    x->args().set_arg(3, ifname);
    x->args().set_arg(4, vifname);
    x->args().set_arg(5, metric);
    x->args().set_arg(6, admin_distance);
    x->args().set_arg(7, cookie);
    x->args().set_arg(8, protocol_origin);

    return _sender->send(*x, callback(this, &XrlRedistTransaction4V0p1Client::unmarshall_add_route, cb));
}


/* Unmarshall add_route */
void
XrlRedistTransaction4V0p1Client::unmarshall_add_route(
	const XrlError&	e,
	XrlArgs*	a,
	AddRouteCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRedistTransaction4V0p1Client::send_delete_route(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const IPv4Net&	dst,
	const IPv4&	nexthop,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	admin_distance,
	const string&	cookie,
	const string&	protocol_origin,
	const DeleteRouteCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "redist_transaction4/0.1/delete_route");
        x->args().add(XrlAtom(tid));
        x->args().add(XrlAtom(dst));
        x->args().add(XrlAtom(nexthop));
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(metric));
        x->args().add(XrlAtom(admin_distance));
        x->args().add(XrlAtom(cookie));
        x->args().add(XrlAtom(protocol_origin));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, tid);
    x->args().set_arg(1, dst);
    x->args().set_arg(2, nexthop);
    x->args().set_arg(3, ifname);
    x->args().set_arg(4, vifname);
    x->args().set_arg(5, metric);
    x->args().set_arg(6, admin_distance);
    x->args().set_arg(7, cookie);
    x->args().set_arg(8, protocol_origin);

    return _sender->send(*x, callback(this, &XrlRedistTransaction4V0p1Client::unmarshall_delete_route, cb));
}


/* Unmarshall delete_route */
void
XrlRedistTransaction4V0p1Client::unmarshall_delete_route(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteRouteCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRedistTransaction4V0p1Client::send_delete_all_routes(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	cookie,
	const DeleteAllRoutesCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "redist_transaction4/0.1/delete_all_routes");
        x->args().add(XrlAtom(tid));
        x->args().add(XrlAtom(cookie));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, tid);
    x->args().set_arg(1, cookie);

    return _sender->send(*x, callback(this, &XrlRedistTransaction4V0p1Client::unmarshall_delete_all_routes, cb));
}


/* Unmarshall delete_all_routes */
void
XrlRedistTransaction4V0p1Client::unmarshall_delete_all_routes(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllRoutesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}
