/*
 * Copyright (c) 2001-2008 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/fea_base.cc,v 1.83 2008/01/04 03:18:07 pavlin Exp $"


#include "fea_base.hh"


XrlFeaTargetBase::XrlFeaTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlFeaTargetBase::~XrlFeaTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlFeaTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlFeaTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_finder_event_observer_0_1_xrl_target_birth(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_birth");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_birth(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_birth", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_finder_event_observer_0_1_xrl_target_death(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_death");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_death(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_death", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_load_click(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/load_click");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_load_click();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/load_click", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_unload_click(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/unload_click");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_unload_click();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/unload_click", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_enable_click(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/enable_click");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_enable_click(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/enable_click", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_start_click(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/start_click");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_start_click();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/start_click", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_stop_click(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/stop_click");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_stop_click();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/stop_click", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_enable_duplicate_routes_to_kernel(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/enable_duplicate_routes_to_kernel");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_enable_duplicate_routes_to_kernel(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/enable_duplicate_routes_to_kernel", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_enable_kernel_click(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/enable_kernel_click");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_enable_kernel_click(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/enable_kernel_click", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_enable_kernel_click_install_on_startup(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/enable_kernel_click_install_on_startup");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_enable_kernel_click_install_on_startup(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/enable_kernel_click_install_on_startup", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_set_kernel_click_modules(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/set_kernel_click_modules");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_set_kernel_click_modules(
	    xa_inputs.get_string("modules"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/set_kernel_click_modules", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_set_kernel_click_mount_directory(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/set_kernel_click_mount_directory");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_set_kernel_click_mount_directory(
	    xa_inputs.get_string("directory"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/set_kernel_click_mount_directory", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_set_kernel_click_config_generator_file(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/set_kernel_click_config_generator_file");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_set_kernel_click_config_generator_file(
	    xa_inputs.get_string("kernel_click_config_generator_file"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/set_kernel_click_config_generator_file", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_enable_user_click(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/enable_user_click");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_enable_user_click(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/enable_user_click", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_command_file(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/set_user_click_command_file");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_set_user_click_command_file(
	    xa_inputs.get_string("user_click_command_file"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/set_user_click_command_file", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_command_extra_arguments(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/set_user_click_command_extra_arguments");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_set_user_click_command_extra_arguments(
	    xa_inputs.get_string("user_click_command_extra_arguments"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/set_user_click_command_extra_arguments", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_command_execute_on_startup(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/set_user_click_command_execute_on_startup");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_set_user_click_command_execute_on_startup(
	    xa_inputs.get_bool("user_click_command_execute_on_startup"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/set_user_click_command_execute_on_startup", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_control_address(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/set_user_click_control_address");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_set_user_click_control_address(
	    xa_inputs.get_ipv4("user_click_control_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/set_user_click_control_address", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_control_socket_port(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/set_user_click_control_socket_port");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_set_user_click_control_socket_port(
	    xa_inputs.get_uint32("user_click_control_socket_port"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/set_user_click_control_socket_port", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_startup_config_file(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/set_user_click_startup_config_file");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_set_user_click_startup_config_file(
	    xa_inputs.get_string("user_click_startup_config_file"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/set_user_click_startup_config_file", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_config_generator_file(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_click/0.1/set_user_click_config_generator_file");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_click_0_1_set_user_click_config_generator_file(
	    xa_inputs.get_string("user_click_config_generator_file"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_click/0.1/set_user_click_config_generator_file", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_fib_0_1_add_fib_client4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "fea_fib/0.1/add_fib_client4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_fib_0_1_add_fib_client4(
	    xa_inputs.get_string("client_target_name"),
	    xa_inputs.get_bool("send_updates"),
	    xa_inputs.get_bool("send_resolves"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_fib/0.1/add_fib_client4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_fib_0_1_add_fib_client6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "fea_fib/0.1/add_fib_client6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_fib_0_1_add_fib_client6(
	    xa_inputs.get_string("client_target_name"),
	    xa_inputs.get_bool("send_updates"),
	    xa_inputs.get_bool("send_resolves"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_fib/0.1/add_fib_client6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_fib_0_1_delete_fib_client4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_fib/0.1/delete_fib_client4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_fib_0_1_delete_fib_client4(
	    xa_inputs.get_string("client_target_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_fib/0.1/delete_fib_client4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_fib_0_1_delete_fib_client6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fea_fib/0.1/delete_fib_client6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_fib_0_1_delete_fib_client6(
	    xa_inputs.get_string("client_target_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_fib/0.1/delete_fib_client6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_restore_original_config_on_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_restore_original_config_on_shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_restore_original_config_on_shutdown(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_restore_original_config_on_shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_names(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_interface_names");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList ifnames;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_interface_names(
	    ifnames);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_interface_names", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("ifnames", ifnames);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_names(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_vif_names");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList vifs;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_names(
	    xa_inputs.get_string("ifname"),
	    vifs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_names", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("vifs", vifs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_flags(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_vif_flags");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    bool broadcast;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_flags(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    enabled,
	    broadcast,
	    loopback,
	    point_to_point,
	    multicast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_flags", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
	pxa_outputs->add("broadcast", broadcast);
	pxa_outputs->add("loopback", loopback);
	pxa_outputs->add("point_to_point", point_to_point);
	pxa_outputs->add("multicast", multicast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_pif_index(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_vif_pif_index");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t pif_index;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_pif_index(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    pif_index);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_pif_index", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("pif_index", pif_index);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_addresses4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_vif_addresses4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList addresses;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_addresses4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    addresses);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_addresses4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("addresses", addresses);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_addresses6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_vif_addresses6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList addresses;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_addresses6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    addresses);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_addresses6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("addresses", addresses);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_flags4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_address_flags4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    bool broadcast;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_address_flags4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    enabled,
	    broadcast,
	    loopback,
	    point_to_point,
	    multicast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_address_flags4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
	pxa_outputs->add("broadcast", broadcast);
	pxa_outputs->add("loopback", loopback);
	pxa_outputs->add("point_to_point", point_to_point);
	pxa_outputs->add("multicast", multicast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_flags6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_address_flags6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_address_flags6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    enabled,
	    loopback,
	    point_to_point,
	    multicast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_address_flags6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
	pxa_outputs->add("loopback", loopback);
	pxa_outputs->add("point_to_point", point_to_point);
	pxa_outputs->add("multicast", multicast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_enabled(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_interface_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_interface_enabled(
	    xa_inputs.get_string("ifname"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_interface_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_discard(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_interface_discard");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool discard;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_interface_discard(
	    xa_inputs.get_string("ifname"),
	    discard);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_interface_discard", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("discard", discard);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_unreachable(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_interface_unreachable");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool unreachable;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_interface_unreachable(
	    xa_inputs.get_string("ifname"),
	    unreachable);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_interface_unreachable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("unreachable", unreachable);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_management(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_interface_management");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool management;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_interface_management(
	    xa_inputs.get_string("ifname"),
	    management);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_interface_management", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("management", management);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_mac(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_mac");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    Mac mac;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_mac(
	    xa_inputs.get_string("ifname"),
	    mac);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_mac", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("mac", mac);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_mtu(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_mtu");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t mtu;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_mtu(
	    xa_inputs.get_string("ifname"),
	    mtu);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_mtu", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("mtu", mtu);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_no_carrier(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_no_carrier");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool no_carrier;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_no_carrier(
	    xa_inputs.get_string("ifname"),
	    no_carrier);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_no_carrier", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("no_carrier", no_carrier);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_enabled(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_vif_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_enabled(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_prefix4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_prefix4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t prefix_len;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_prefix4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    prefix_len);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_prefix4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("prefix_len", prefix_len);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_broadcast4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_broadcast4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 broadcast;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_broadcast4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    broadcast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_broadcast4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("broadcast", broadcast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_endpoint4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_endpoint4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 endpoint;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_endpoint4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    endpoint);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_endpoint4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("endpoint", endpoint);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_prefix6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_prefix6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t prefix_len;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_prefix6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    prefix_len);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_prefix6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("prefix_len", prefix_len);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_endpoint6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_endpoint6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv6 endpoint;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_endpoint6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    endpoint);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_endpoint6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("endpoint", endpoint);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_start_transaction(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/start_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t tid;
    try {
	XrlCmdError e = ifmgr_0_1_start_transaction(
	    tid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/start_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("tid", tid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_commit_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/commit_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_commit_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/commit_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_abort_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/abort_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_abort_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/abort_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_create_interface(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/create_interface");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_create_interface(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/create_interface", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_delete_interface(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/delete_interface");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_delete_interface(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/delete_interface", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_configure_all_interfaces_from_system(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/configure_all_interfaces_from_system");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_configure_all_interfaces_from_system(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/configure_all_interfaces_from_system", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_configure_interface_from_system(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/configure_interface_from_system");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_configure_interface_from_system(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/configure_interface_from_system", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_interface_enabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_interface_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_interface_enabled(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_interface_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_interface_discard(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_interface_discard");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_interface_discard(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_bool("discard"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_interface_discard", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_interface_unreachable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_interface_unreachable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_interface_unreachable(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_bool("unreachable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_interface_unreachable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_interface_management(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_interface_management");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_interface_management(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_bool("management"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_interface_management", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_mac(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_mac");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_mac(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_mac("mac"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_mac", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_restore_original_mac(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/restore_original_mac");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_restore_original_mac(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/restore_original_mac", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_mtu(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_mtu");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_mtu(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_uint32("mtu"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_mtu", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_restore_original_mtu(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/restore_original_mtu");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_restore_original_mtu(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/restore_original_mtu", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_create_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/create_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_create_vif(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/create_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_delete_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/delete_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_delete_vif(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/delete_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_vif_enabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_vif_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_vif_enabled(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_vif_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_vif_vlan(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_vif_vlan");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_vif_vlan(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_uint32("vlan_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_vif_vlan", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_create_address4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/create_address4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_create_address4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/create_address4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_delete_address4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/delete_address4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_delete_address4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/delete_address4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_address_enabled4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_address_enabled4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_address_enabled4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_address_enabled4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_enabled4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_address_enabled4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_address_enabled4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_address_enabled4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_prefix4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_prefix4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_prefix4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    xa_inputs.get_uint32("prefix_len"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_prefix4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_broadcast4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_broadcast4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_broadcast4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    xa_inputs.get_ipv4("broadcast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_broadcast4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_endpoint4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_endpoint4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_endpoint4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    xa_inputs.get_ipv4("endpoint"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_endpoint4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_create_address6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/create_address6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_create_address6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/create_address6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_delete_address6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/delete_address6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_delete_address6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/delete_address6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_address_enabled6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_address_enabled6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_address_enabled6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_address_enabled6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_enabled6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/get_configured_address_enabled6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_address_enabled6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_address_enabled6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_prefix6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_prefix6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_prefix6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    xa_inputs.get_uint32("prefix_len"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_prefix6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_endpoint6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "ifmgr/0.1/set_endpoint6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_endpoint6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    xa_inputs.get_ipv6("endpoint"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_endpoint6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_replicator_0_1_register_ifmgr_mirror(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr_replicator/0.1/register_ifmgr_mirror");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_replicator_0_1_register_ifmgr_mirror(
	    xa_inputs.get_string("clientname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr_replicator/0.1/register_ifmgr_mirror", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_replicator_0_1_unregister_ifmgr_mirror(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr_replicator/0.1/unregister_ifmgr_mirror");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_replicator_0_1_unregister_ifmgr_mirror(
	    xa_inputs.get_string("clientname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr_replicator/0.1/unregister_ifmgr_mirror", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_lookup_route_by_dest4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/lookup_route_by_dest4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4Net netmask;
    IPv4 nexthop;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	XrlCmdError e = fti_0_2_lookup_route_by_dest4(
	    xa_inputs.get_ipv4("dst"),
	    netmask,
	    nexthop,
	    ifname,
	    vifname,
	    metric,
	    admin_distance,
	    protocol_origin);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/lookup_route_by_dest4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("netmask", netmask);
	pxa_outputs->add("nexthop", nexthop);
	pxa_outputs->add("ifname", ifname);
	pxa_outputs->add("vifname", vifname);
	pxa_outputs->add("metric", metric);
	pxa_outputs->add("admin_distance", admin_distance);
	pxa_outputs->add("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_lookup_route_by_dest6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/lookup_route_by_dest6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv6Net netmask;
    IPv6 nexthop;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	XrlCmdError e = fti_0_2_lookup_route_by_dest6(
	    xa_inputs.get_ipv6("dst"),
	    netmask,
	    nexthop,
	    ifname,
	    vifname,
	    metric,
	    admin_distance,
	    protocol_origin);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/lookup_route_by_dest6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("netmask", netmask);
	pxa_outputs->add("nexthop", nexthop);
	pxa_outputs->add("ifname", ifname);
	pxa_outputs->add("vifname", vifname);
	pxa_outputs->add("metric", metric);
	pxa_outputs->add("admin_distance", admin_distance);
	pxa_outputs->add("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_lookup_route_by_network4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/lookup_route_by_network4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 nexthop;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	XrlCmdError e = fti_0_2_lookup_route_by_network4(
	    xa_inputs.get_ipv4net("dst"),
	    nexthop,
	    ifname,
	    vifname,
	    metric,
	    admin_distance,
	    protocol_origin);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/lookup_route_by_network4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("nexthop", nexthop);
	pxa_outputs->add("ifname", ifname);
	pxa_outputs->add("vifname", vifname);
	pxa_outputs->add("metric", metric);
	pxa_outputs->add("admin_distance", admin_distance);
	pxa_outputs->add("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_lookup_route_by_network6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/lookup_route_by_network6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv6 nexthop;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	XrlCmdError e = fti_0_2_lookup_route_by_network6(
	    xa_inputs.get_ipv6net("dst"),
	    nexthop,
	    ifname,
	    vifname,
	    metric,
	    admin_distance,
	    protocol_origin);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/lookup_route_by_network6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("nexthop", nexthop);
	pxa_outputs->add("ifname", ifname);
	pxa_outputs->add("vifname", vifname);
	pxa_outputs->add("metric", metric);
	pxa_outputs->add("admin_distance", admin_distance);
	pxa_outputs->add("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_have_ipv4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/have_ipv4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool result;
    try {
	XrlCmdError e = fti_0_2_have_ipv4(
	    result);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/have_ipv4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("result", result);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_have_ipv6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/have_ipv6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool result;
    try {
	XrlCmdError e = fti_0_2_have_ipv6(
	    result);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/have_ipv6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("result", result);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_get_unicast_forwarding_enabled4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/get_unicast_forwarding_enabled4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = fti_0_2_get_unicast_forwarding_enabled4(
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/get_unicast_forwarding_enabled4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_get_unicast_forwarding_enabled6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/get_unicast_forwarding_enabled6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = fti_0_2_get_unicast_forwarding_enabled6(
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/get_unicast_forwarding_enabled6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_enabled4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/set_unicast_forwarding_enabled4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_set_unicast_forwarding_enabled4(
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/set_unicast_forwarding_enabled4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_enabled6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/set_unicast_forwarding_enabled6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_set_unicast_forwarding_enabled6(
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/set_unicast_forwarding_enabled6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_entries_retain_on_startup4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/set_unicast_forwarding_entries_retain_on_startup4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_set_unicast_forwarding_entries_retain_on_startup4(
	    xa_inputs.get_bool("retain"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/set_unicast_forwarding_entries_retain_on_startup4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_entries_retain_on_shutdown4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/set_unicast_forwarding_entries_retain_on_shutdown4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_set_unicast_forwarding_entries_retain_on_shutdown4(
	    xa_inputs.get_bool("retain"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/set_unicast_forwarding_entries_retain_on_shutdown4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_entries_retain_on_startup6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/set_unicast_forwarding_entries_retain_on_startup6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_set_unicast_forwarding_entries_retain_on_startup6(
	    xa_inputs.get_bool("retain"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/set_unicast_forwarding_entries_retain_on_startup6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_entries_retain_on_shutdown6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/set_unicast_forwarding_entries_retain_on_shutdown6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_set_unicast_forwarding_entries_retain_on_shutdown6(
	    xa_inputs.get_bool("retain"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/set_unicast_forwarding_entries_retain_on_shutdown6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_table_id4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/set_unicast_forwarding_table_id4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_set_unicast_forwarding_table_id4(
	    xa_inputs.get_bool("is_configured"),
	    xa_inputs.get_uint32("table_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/set_unicast_forwarding_table_id4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_table_id6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "fti/0.2/set_unicast_forwarding_table_id6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_set_unicast_forwarding_table_id6(
	    xa_inputs.get_bool("is_configured"),
	    xa_inputs.get_uint32("table_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/set_unicast_forwarding_table_id6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction4_0_1_start_transaction(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/start_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t tid;
    try {
	XrlCmdError e = redist_transaction4_0_1_start_transaction(
	    tid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/start_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("tid", tid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction4_0_1_commit_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/commit_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_commit_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/commit_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction4_0_1_abort_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/abort_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_abort_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/abort_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction4_0_1_add_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/add_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_add_route(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv4net("dst"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("admin_distance"),
	    xa_inputs.get_string("cookie"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/add_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction4_0_1_delete_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/delete_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_delete_route(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv4net("dst"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("admin_distance"),
	    xa_inputs.get_string("cookie"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/delete_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction4_0_1_delete_all_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/delete_all_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_delete_all_routes(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/delete_all_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction6_0_1_start_transaction(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/start_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t tid;
    try {
	XrlCmdError e = redist_transaction6_0_1_start_transaction(
	    tid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/start_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("tid", tid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction6_0_1_commit_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/commit_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_commit_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/commit_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction6_0_1_abort_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/abort_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_abort_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/abort_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction6_0_1_add_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/add_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_add_route(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv6net("dst"),
	    xa_inputs.get_ipv6("nexthop"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("admin_distance"),
	    xa_inputs.get_string("cookie"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/add_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction6_0_1_delete_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/delete_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_delete_route(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv6net("dst"),
	    xa_inputs.get_ipv6("nexthop"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("admin_distance"),
	    xa_inputs.get_string("cookie"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/delete_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction6_0_1_delete_all_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/delete_all_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_delete_all_routes(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/delete_all_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_link_0_1_send(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "raw_link/0.1/send");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_link_0_1_send(
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_mac("src_address"),
	    xa_inputs.get_mac("dst_address"),
	    xa_inputs.get_uint32("ether_type"),
	    xa_inputs.get_binary("payload"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_link/0.1/send", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_link_0_1_register_receiver(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "raw_link/0.1/register_receiver");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_link_0_1_register_receiver(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ether_type"),
	    xa_inputs.get_string("filter_program"),
	    xa_inputs.get_bool("enable_multicast_loopback"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_link/0.1/register_receiver", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_link_0_1_unregister_receiver(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "raw_link/0.1/unregister_receiver");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_link_0_1_unregister_receiver(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ether_type"),
	    xa_inputs.get_string("filter_program"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_link/0.1/unregister_receiver", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_link_0_1_join_multicast_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "raw_link/0.1/join_multicast_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_link_0_1_join_multicast_group(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ether_type"),
	    xa_inputs.get_string("filter_program"),
	    xa_inputs.get_mac("group_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_link/0.1/join_multicast_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_link_0_1_leave_multicast_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "raw_link/0.1/leave_multicast_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_link_0_1_leave_multicast_group(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ether_type"),
	    xa_inputs.get_string("filter_program"),
	    xa_inputs.get_mac("group_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_link/0.1/leave_multicast_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet4_0_1_send(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 10) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(10), XORP_UINT_CAST(xa_inputs.size()), "raw_packet4/0.1/send");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet4_0_1_send(
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_ipv4("src_address"),
	    xa_inputs.get_ipv4("dst_address"),
	    xa_inputs.get_uint32("ip_protocol"),
	    xa_inputs.get_int32("ip_ttl"),
	    xa_inputs.get_int32("ip_tos"),
	    xa_inputs.get_bool("ip_router_alert"),
	    xa_inputs.get_bool("ip_internet_control"),
	    xa_inputs.get_binary("payload"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet4/0.1/send", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet4_0_1_register_receiver(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "raw_packet4/0.1/register_receiver");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet4_0_1_register_receiver(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ip_protocol"),
	    xa_inputs.get_bool("enable_multicast_loopback"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet4/0.1/register_receiver", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet4_0_1_unregister_receiver(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "raw_packet4/0.1/unregister_receiver");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet4_0_1_unregister_receiver(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ip_protocol"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet4/0.1/unregister_receiver", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet4_0_1_join_multicast_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "raw_packet4/0.1/join_multicast_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet4_0_1_join_multicast_group(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ip_protocol"),
	    xa_inputs.get_ipv4("group_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet4/0.1/join_multicast_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet4_0_1_leave_multicast_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "raw_packet4/0.1/leave_multicast_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet4_0_1_leave_multicast_group(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ip_protocol"),
	    xa_inputs.get_ipv4("group_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet4/0.1/leave_multicast_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet6_0_1_send(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 12) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(12), XORP_UINT_CAST(xa_inputs.size()), "raw_packet6/0.1/send");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet6_0_1_send(
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_ipv6("src_address"),
	    xa_inputs.get_ipv6("dst_address"),
	    xa_inputs.get_uint32("ip_protocol"),
	    xa_inputs.get_int32("ip_ttl"),
	    xa_inputs.get_int32("ip_tos"),
	    xa_inputs.get_bool("ip_router_alert"),
	    xa_inputs.get_bool("ip_internet_control"),
	    xa_inputs.get_list("ext_headers_type"),
	    xa_inputs.get_list("ext_headers_payload"),
	    xa_inputs.get_binary("payload"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet6/0.1/send", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet6_0_1_register_receiver(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "raw_packet6/0.1/register_receiver");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet6_0_1_register_receiver(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ip_protocol"),
	    xa_inputs.get_bool("enable_multicast_loopback"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet6/0.1/register_receiver", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet6_0_1_unregister_receiver(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "raw_packet6/0.1/unregister_receiver");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet6_0_1_unregister_receiver(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ip_protocol"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet6/0.1/unregister_receiver", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet6_0_1_join_multicast_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "raw_packet6/0.1/join_multicast_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet6_0_1_join_multicast_group(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ip_protocol"),
	    xa_inputs.get_ipv6("group_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet6/0.1/join_multicast_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet6_0_1_leave_multicast_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "raw_packet6/0.1/leave_multicast_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet6_0_1_leave_multicast_group(
	    xa_inputs.get_string("xrl_target_instance_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ip_protocol"),
	    xa_inputs.get_ipv6("group_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet6/0.1/leave_multicast_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_tcp_open(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/tcp_open");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_tcp_open(
	    xa_inputs.get_string("creator"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/tcp_open", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_udp_open(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/udp_open");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_udp_open(
	    xa_inputs.get_string("creator"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/udp_open", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_tcp_open_and_bind(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/tcp_open_and_bind");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_tcp_open_and_bind(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv4("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/tcp_open_and_bind", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_udp_open_and_bind(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/udp_open_and_bind");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_udp_open_and_bind(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv4("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/udp_open_and_bind", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_udp_open_bind_join(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/udp_open_bind_join");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_udp_open_bind_join(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv4("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv4("mcast_addr"),
	    xa_inputs.get_uint32("ttl"),
	    xa_inputs.get_bool("reuse"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/udp_open_bind_join", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_tcp_open_bind_connect(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/tcp_open_bind_connect");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_tcp_open_bind_connect(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv4("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv4("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/tcp_open_bind_connect", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_udp_open_bind_connect(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/udp_open_bind_connect");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_udp_open_bind_connect(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv4("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv4("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/udp_open_bind_connect", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_bind(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/bind");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_bind(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("local_addr"),
	    xa_inputs.get_uint32("local_port"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/bind", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_udp_join_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/udp_join_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_udp_join_group(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("mcast_addr"),
	    xa_inputs.get_ipv4("join_if_addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/udp_join_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_udp_leave_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/udp_leave_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_udp_leave_group(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("mcast_addr"),
	    xa_inputs.get_ipv4("leave_if_addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/udp_leave_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_close(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/close");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_close(
	    xa_inputs.get_string("sockid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/close", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_tcp_listen(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/tcp_listen");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_tcp_listen(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_uint32("backlog"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/tcp_listen", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_send(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/send");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_send(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/send", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_send_to(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/send_to");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_send_to(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/send_to", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_send_from_multicast_if(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/send_from_multicast_if");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_send_from_multicast_if(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("group_addr"),
	    xa_inputs.get_uint32("group_port"),
	    xa_inputs.get_ipv4("ifaddr"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/send_from_multicast_if", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_0_1_set_socket_option(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket4/0.1/set_socket_option");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_set_socket_option(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_string("optname"),
	    xa_inputs.get_uint32("optval"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/set_socket_option", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_tcp_open(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/tcp_open");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_tcp_open(
	    xa_inputs.get_string("creator"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/tcp_open", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_udp_open(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/udp_open");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_udp_open(
	    xa_inputs.get_string("creator"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/udp_open", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_tcp_open_and_bind(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/tcp_open_and_bind");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_tcp_open_and_bind(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv6("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/tcp_open_and_bind", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_udp_open_and_bind(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/udp_open_and_bind");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_udp_open_and_bind(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv6("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/udp_open_and_bind", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_udp_open_bind_join(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/udp_open_bind_join");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_udp_open_bind_join(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv6("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv6("mcast_addr"),
	    xa_inputs.get_uint32("ttl"),
	    xa_inputs.get_bool("reuse"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/udp_open_bind_join", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_tcp_open_bind_connect(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/tcp_open_bind_connect");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_tcp_open_bind_connect(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv6("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv6("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/tcp_open_bind_connect", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_udp_open_bind_connect(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/udp_open_bind_connect");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_udp_open_bind_connect(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv6("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv6("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/udp_open_bind_connect", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_bind(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/bind");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_bind(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv6("local_addr"),
	    xa_inputs.get_uint32("local_port"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/bind", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_udp_join_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/udp_join_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_udp_join_group(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv6("mcast_addr"),
	    xa_inputs.get_ipv6("join_if_addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/udp_join_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_udp_leave_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/udp_leave_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_udp_leave_group(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv6("mcast_addr"),
	    xa_inputs.get_ipv6("leave_if_addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/udp_leave_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_close(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/close");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_close(
	    xa_inputs.get_string("sockid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/close", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_tcp_listen(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/tcp_listen");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_tcp_listen(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_uint32("backlog"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/tcp_listen", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_send(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/send");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_send(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/send", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_send_to(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/send_to");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_send_to(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv6("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/send_to", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_send_from_multicast_if(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/send_from_multicast_if");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_send_from_multicast_if(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv6("group_addr"),
	    xa_inputs.get_uint32("group_port"),
	    xa_inputs.get_ipv6("ifaddr"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/send_from_multicast_if", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_0_1_set_socket_option(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket6/0.1/set_socket_option");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_set_socket_option(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_string("optname"),
	    xa_inputs.get_uint32("optval"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/set_socket_option", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_profile_0_1_enable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/enable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_enable(
	    xa_inputs.get_string("pname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/enable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_profile_0_1_disable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/disable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_disable(
	    xa_inputs.get_string("pname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/disable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_profile_0_1_get_entries(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/get_entries");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_get_entries(
	    xa_inputs.get_string("pname"),
	    xa_inputs.get_string("instance_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/get_entries", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_profile_0_1_clear(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/clear");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_clear(
	    xa_inputs.get_string("pname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/clear", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_profile_0_1_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string info;
    try {
	XrlCmdError e = profile_0_1_list(
	    info);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("info", info);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

void
XrlFeaTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlFeaTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlFeaTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlFeaTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlFeaTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_birth",
	    callback(this, &XrlFeaTargetBase::handle_finder_event_observer_0_1_xrl_target_birth)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "finder_event_observer/0.1/xrl_target_birth");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_death",
	    callback(this, &XrlFeaTargetBase::handle_finder_event_observer_0_1_xrl_target_death)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "finder_event_observer/0.1/xrl_target_death");
	}
	if (_cmds->add_handler("fea_click/0.1/load_click",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_load_click)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/load_click");
	}
	if (_cmds->add_handler("fea_click/0.1/unload_click",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_unload_click)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/unload_click");
	}
	if (_cmds->add_handler("fea_click/0.1/enable_click",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_enable_click)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/enable_click");
	}
	if (_cmds->add_handler("fea_click/0.1/start_click",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_start_click)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/start_click");
	}
	if (_cmds->add_handler("fea_click/0.1/stop_click",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_stop_click)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/stop_click");
	}
	if (_cmds->add_handler("fea_click/0.1/enable_duplicate_routes_to_kernel",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_enable_duplicate_routes_to_kernel)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/enable_duplicate_routes_to_kernel");
	}
	if (_cmds->add_handler("fea_click/0.1/enable_kernel_click",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_enable_kernel_click)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/enable_kernel_click");
	}
	if (_cmds->add_handler("fea_click/0.1/enable_kernel_click_install_on_startup",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_enable_kernel_click_install_on_startup)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/enable_kernel_click_install_on_startup");
	}
	if (_cmds->add_handler("fea_click/0.1/set_kernel_click_modules",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_set_kernel_click_modules)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/set_kernel_click_modules");
	}
	if (_cmds->add_handler("fea_click/0.1/set_kernel_click_mount_directory",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_set_kernel_click_mount_directory)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/set_kernel_click_mount_directory");
	}
	if (_cmds->add_handler("fea_click/0.1/set_kernel_click_config_generator_file",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_set_kernel_click_config_generator_file)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/set_kernel_click_config_generator_file");
	}
	if (_cmds->add_handler("fea_click/0.1/enable_user_click",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_enable_user_click)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/enable_user_click");
	}
	if (_cmds->add_handler("fea_click/0.1/set_user_click_command_file",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_command_file)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/set_user_click_command_file");
	}
	if (_cmds->add_handler("fea_click/0.1/set_user_click_command_extra_arguments",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_command_extra_arguments)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/set_user_click_command_extra_arguments");
	}
	if (_cmds->add_handler("fea_click/0.1/set_user_click_command_execute_on_startup",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_command_execute_on_startup)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/set_user_click_command_execute_on_startup");
	}
	if (_cmds->add_handler("fea_click/0.1/set_user_click_control_address",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_control_address)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/set_user_click_control_address");
	}
	if (_cmds->add_handler("fea_click/0.1/set_user_click_control_socket_port",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_control_socket_port)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/set_user_click_control_socket_port");
	}
	if (_cmds->add_handler("fea_click/0.1/set_user_click_startup_config_file",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_startup_config_file)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/set_user_click_startup_config_file");
	}
	if (_cmds->add_handler("fea_click/0.1/set_user_click_config_generator_file",
	    callback(this, &XrlFeaTargetBase::handle_fea_click_0_1_set_user_click_config_generator_file)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_click/0.1/set_user_click_config_generator_file");
	}
	if (_cmds->add_handler("fea_fib/0.1/add_fib_client4",
	    callback(this, &XrlFeaTargetBase::handle_fea_fib_0_1_add_fib_client4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_fib/0.1/add_fib_client4");
	}
	if (_cmds->add_handler("fea_fib/0.1/add_fib_client6",
	    callback(this, &XrlFeaTargetBase::handle_fea_fib_0_1_add_fib_client6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_fib/0.1/add_fib_client6");
	}
	if (_cmds->add_handler("fea_fib/0.1/delete_fib_client4",
	    callback(this, &XrlFeaTargetBase::handle_fea_fib_0_1_delete_fib_client4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_fib/0.1/delete_fib_client4");
	}
	if (_cmds->add_handler("fea_fib/0.1/delete_fib_client6",
	    callback(this, &XrlFeaTargetBase::handle_fea_fib_0_1_delete_fib_client6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_fib/0.1/delete_fib_client6");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_restore_original_config_on_shutdown",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_restore_original_config_on_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_restore_original_config_on_shutdown");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_interface_names",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_names)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_interface_names");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_names",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_names)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_names");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_flags",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_flags)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_flags");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_pif_index",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_pif_index)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_pif_index");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_addresses4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_addresses4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_addresses4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_addresses6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_addresses6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_addresses6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_address_flags4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_flags4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_address_flags4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_address_flags6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_flags6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_address_flags6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_interface_enabled",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_interface_enabled");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_interface_discard",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_discard)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_interface_discard");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_interface_unreachable",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_unreachable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_interface_unreachable");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_interface_management",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_management)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_interface_management");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_mac",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_mac)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_mac");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_mtu",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_mtu)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_mtu");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_no_carrier",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_no_carrier)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_no_carrier");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_enabled",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_enabled");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_prefix4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_prefix4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_prefix4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_broadcast4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_broadcast4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_broadcast4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_endpoint4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_endpoint4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_endpoint4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_prefix6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_prefix6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_prefix6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_endpoint6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_endpoint6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_endpoint6");
	}
	if (_cmds->add_handler("ifmgr/0.1/start_transaction",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_start_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/start_transaction");
	}
	if (_cmds->add_handler("ifmgr/0.1/commit_transaction",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_commit_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/commit_transaction");
	}
	if (_cmds->add_handler("ifmgr/0.1/abort_transaction",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_abort_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/abort_transaction");
	}
	if (_cmds->add_handler("ifmgr/0.1/create_interface",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_create_interface)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/create_interface");
	}
	if (_cmds->add_handler("ifmgr/0.1/delete_interface",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_delete_interface)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/delete_interface");
	}
	if (_cmds->add_handler("ifmgr/0.1/configure_all_interfaces_from_system",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_configure_all_interfaces_from_system)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/configure_all_interfaces_from_system");
	}
	if (_cmds->add_handler("ifmgr/0.1/configure_interface_from_system",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_configure_interface_from_system)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/configure_interface_from_system");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_interface_enabled",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_interface_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_interface_enabled");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_interface_discard",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_interface_discard)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_interface_discard");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_interface_unreachable",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_interface_unreachable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_interface_unreachable");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_interface_management",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_interface_management)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_interface_management");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_mac",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_mac)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_mac");
	}
	if (_cmds->add_handler("ifmgr/0.1/restore_original_mac",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_restore_original_mac)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/restore_original_mac");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_mtu",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_mtu)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_mtu");
	}
	if (_cmds->add_handler("ifmgr/0.1/restore_original_mtu",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_restore_original_mtu)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/restore_original_mtu");
	}
	if (_cmds->add_handler("ifmgr/0.1/create_vif",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_create_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/create_vif");
	}
	if (_cmds->add_handler("ifmgr/0.1/delete_vif",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_delete_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/delete_vif");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_vif_enabled",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_vif_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_vif_enabled");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_vif_vlan",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_vif_vlan)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_vif_vlan");
	}
	if (_cmds->add_handler("ifmgr/0.1/create_address4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_create_address4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/create_address4");
	}
	if (_cmds->add_handler("ifmgr/0.1/delete_address4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_delete_address4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/delete_address4");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_address_enabled4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_address_enabled4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_address_enabled4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_address_enabled4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_enabled4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_address_enabled4");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_prefix4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_prefix4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_prefix4");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_broadcast4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_broadcast4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_broadcast4");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_endpoint4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_endpoint4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_endpoint4");
	}
	if (_cmds->add_handler("ifmgr/0.1/create_address6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_create_address6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/create_address6");
	}
	if (_cmds->add_handler("ifmgr/0.1/delete_address6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_delete_address6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/delete_address6");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_address_enabled6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_address_enabled6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_address_enabled6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_address_enabled6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_enabled6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_address_enabled6");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_prefix6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_prefix6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_prefix6");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_endpoint6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_endpoint6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_endpoint6");
	}
	if (_cmds->add_handler("ifmgr_replicator/0.1/register_ifmgr_mirror",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_replicator_0_1_register_ifmgr_mirror)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr_replicator/0.1/register_ifmgr_mirror");
	}
	if (_cmds->add_handler("ifmgr_replicator/0.1/unregister_ifmgr_mirror",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_replicator_0_1_unregister_ifmgr_mirror)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr_replicator/0.1/unregister_ifmgr_mirror");
	}
	if (_cmds->add_handler("fti/0.2/lookup_route_by_dest4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_lookup_route_by_dest4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/lookup_route_by_dest4");
	}
	if (_cmds->add_handler("fti/0.2/lookup_route_by_dest6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_lookup_route_by_dest6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/lookup_route_by_dest6");
	}
	if (_cmds->add_handler("fti/0.2/lookup_route_by_network4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_lookup_route_by_network4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/lookup_route_by_network4");
	}
	if (_cmds->add_handler("fti/0.2/lookup_route_by_network6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_lookup_route_by_network6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/lookup_route_by_network6");
	}
	if (_cmds->add_handler("fti/0.2/have_ipv4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_have_ipv4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/have_ipv4");
	}
	if (_cmds->add_handler("fti/0.2/have_ipv6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_have_ipv6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/have_ipv6");
	}
	if (_cmds->add_handler("fti/0.2/get_unicast_forwarding_enabled4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_get_unicast_forwarding_enabled4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/get_unicast_forwarding_enabled4");
	}
	if (_cmds->add_handler("fti/0.2/get_unicast_forwarding_enabled6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_get_unicast_forwarding_enabled6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/get_unicast_forwarding_enabled6");
	}
	if (_cmds->add_handler("fti/0.2/set_unicast_forwarding_enabled4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_enabled4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/set_unicast_forwarding_enabled4");
	}
	if (_cmds->add_handler("fti/0.2/set_unicast_forwarding_enabled6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_enabled6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/set_unicast_forwarding_enabled6");
	}
	if (_cmds->add_handler("fti/0.2/set_unicast_forwarding_entries_retain_on_startup4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_entries_retain_on_startup4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/set_unicast_forwarding_entries_retain_on_startup4");
	}
	if (_cmds->add_handler("fti/0.2/set_unicast_forwarding_entries_retain_on_shutdown4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_entries_retain_on_shutdown4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/set_unicast_forwarding_entries_retain_on_shutdown4");
	}
	if (_cmds->add_handler("fti/0.2/set_unicast_forwarding_entries_retain_on_startup6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_entries_retain_on_startup6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/set_unicast_forwarding_entries_retain_on_startup6");
	}
	if (_cmds->add_handler("fti/0.2/set_unicast_forwarding_entries_retain_on_shutdown6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_entries_retain_on_shutdown6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/set_unicast_forwarding_entries_retain_on_shutdown6");
	}
	if (_cmds->add_handler("fti/0.2/set_unicast_forwarding_table_id4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_table_id4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/set_unicast_forwarding_table_id4");
	}
	if (_cmds->add_handler("fti/0.2/set_unicast_forwarding_table_id6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_table_id6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/set_unicast_forwarding_table_id6");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/start_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction4_0_1_start_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction4/0.1/start_transaction");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/commit_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction4_0_1_commit_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction4/0.1/commit_transaction");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/abort_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction4_0_1_abort_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction4/0.1/abort_transaction");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/add_route",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction4_0_1_add_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction4/0.1/add_route");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/delete_route",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction4_0_1_delete_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction4/0.1/delete_route");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/delete_all_routes",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction4_0_1_delete_all_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction4/0.1/delete_all_routes");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/start_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction6_0_1_start_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction6/0.1/start_transaction");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/commit_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction6_0_1_commit_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction6/0.1/commit_transaction");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/abort_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction6_0_1_abort_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction6/0.1/abort_transaction");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/add_route",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction6_0_1_add_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction6/0.1/add_route");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/delete_route",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction6_0_1_delete_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction6/0.1/delete_route");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/delete_all_routes",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction6_0_1_delete_all_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction6/0.1/delete_all_routes");
	}
	if (_cmds->add_handler("raw_link/0.1/send",
	    callback(this, &XrlFeaTargetBase::handle_raw_link_0_1_send)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_link/0.1/send");
	}
	if (_cmds->add_handler("raw_link/0.1/register_receiver",
	    callback(this, &XrlFeaTargetBase::handle_raw_link_0_1_register_receiver)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_link/0.1/register_receiver");
	}
	if (_cmds->add_handler("raw_link/0.1/unregister_receiver",
	    callback(this, &XrlFeaTargetBase::handle_raw_link_0_1_unregister_receiver)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_link/0.1/unregister_receiver");
	}
	if (_cmds->add_handler("raw_link/0.1/join_multicast_group",
	    callback(this, &XrlFeaTargetBase::handle_raw_link_0_1_join_multicast_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_link/0.1/join_multicast_group");
	}
	if (_cmds->add_handler("raw_link/0.1/leave_multicast_group",
	    callback(this, &XrlFeaTargetBase::handle_raw_link_0_1_leave_multicast_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_link/0.1/leave_multicast_group");
	}
	if (_cmds->add_handler("raw_packet4/0.1/send",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet4_0_1_send)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet4/0.1/send");
	}
	if (_cmds->add_handler("raw_packet4/0.1/register_receiver",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet4_0_1_register_receiver)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet4/0.1/register_receiver");
	}
	if (_cmds->add_handler("raw_packet4/0.1/unregister_receiver",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet4_0_1_unregister_receiver)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet4/0.1/unregister_receiver");
	}
	if (_cmds->add_handler("raw_packet4/0.1/join_multicast_group",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet4_0_1_join_multicast_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet4/0.1/join_multicast_group");
	}
	if (_cmds->add_handler("raw_packet4/0.1/leave_multicast_group",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet4_0_1_leave_multicast_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet4/0.1/leave_multicast_group");
	}
	if (_cmds->add_handler("raw_packet6/0.1/send",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet6_0_1_send)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet6/0.1/send");
	}
	if (_cmds->add_handler("raw_packet6/0.1/register_receiver",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet6_0_1_register_receiver)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet6/0.1/register_receiver");
	}
	if (_cmds->add_handler("raw_packet6/0.1/unregister_receiver",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet6_0_1_unregister_receiver)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet6/0.1/unregister_receiver");
	}
	if (_cmds->add_handler("raw_packet6/0.1/join_multicast_group",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet6_0_1_join_multicast_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet6/0.1/join_multicast_group");
	}
	if (_cmds->add_handler("raw_packet6/0.1/leave_multicast_group",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet6_0_1_leave_multicast_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet6/0.1/leave_multicast_group");
	}
	if (_cmds->add_handler("socket4/0.1/tcp_open",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_tcp_open)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/tcp_open");
	}
	if (_cmds->add_handler("socket4/0.1/udp_open",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_udp_open)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/udp_open");
	}
	if (_cmds->add_handler("socket4/0.1/tcp_open_and_bind",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_tcp_open_and_bind)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/tcp_open_and_bind");
	}
	if (_cmds->add_handler("socket4/0.1/udp_open_and_bind",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_udp_open_and_bind)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/udp_open_and_bind");
	}
	if (_cmds->add_handler("socket4/0.1/udp_open_bind_join",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_udp_open_bind_join)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/udp_open_bind_join");
	}
	if (_cmds->add_handler("socket4/0.1/tcp_open_bind_connect",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_tcp_open_bind_connect)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/tcp_open_bind_connect");
	}
	if (_cmds->add_handler("socket4/0.1/udp_open_bind_connect",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_udp_open_bind_connect)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/udp_open_bind_connect");
	}
	if (_cmds->add_handler("socket4/0.1/bind",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_bind)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/bind");
	}
	if (_cmds->add_handler("socket4/0.1/udp_join_group",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_udp_join_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/udp_join_group");
	}
	if (_cmds->add_handler("socket4/0.1/udp_leave_group",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_udp_leave_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/udp_leave_group");
	}
	if (_cmds->add_handler("socket4/0.1/close",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_close)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/close");
	}
	if (_cmds->add_handler("socket4/0.1/tcp_listen",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_tcp_listen)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/tcp_listen");
	}
	if (_cmds->add_handler("socket4/0.1/send",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_send)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/send");
	}
	if (_cmds->add_handler("socket4/0.1/send_to",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_send_to)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/send_to");
	}
	if (_cmds->add_handler("socket4/0.1/send_from_multicast_if",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_send_from_multicast_if)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/send_from_multicast_if");
	}
	if (_cmds->add_handler("socket4/0.1/set_socket_option",
	    callback(this, &XrlFeaTargetBase::handle_socket4_0_1_set_socket_option)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4/0.1/set_socket_option");
	}
	if (_cmds->add_handler("socket6/0.1/tcp_open",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_tcp_open)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/tcp_open");
	}
	if (_cmds->add_handler("socket6/0.1/udp_open",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_udp_open)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/udp_open");
	}
	if (_cmds->add_handler("socket6/0.1/tcp_open_and_bind",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_tcp_open_and_bind)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/tcp_open_and_bind");
	}
	if (_cmds->add_handler("socket6/0.1/udp_open_and_bind",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_udp_open_and_bind)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/udp_open_and_bind");
	}
	if (_cmds->add_handler("socket6/0.1/udp_open_bind_join",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_udp_open_bind_join)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/udp_open_bind_join");
	}
	if (_cmds->add_handler("socket6/0.1/tcp_open_bind_connect",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_tcp_open_bind_connect)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/tcp_open_bind_connect");
	}
	if (_cmds->add_handler("socket6/0.1/udp_open_bind_connect",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_udp_open_bind_connect)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/udp_open_bind_connect");
	}
	if (_cmds->add_handler("socket6/0.1/bind",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_bind)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/bind");
	}
	if (_cmds->add_handler("socket6/0.1/udp_join_group",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_udp_join_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/udp_join_group");
	}
	if (_cmds->add_handler("socket6/0.1/udp_leave_group",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_udp_leave_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/udp_leave_group");
	}
	if (_cmds->add_handler("socket6/0.1/close",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_close)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/close");
	}
	if (_cmds->add_handler("socket6/0.1/tcp_listen",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_tcp_listen)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/tcp_listen");
	}
	if (_cmds->add_handler("socket6/0.1/send",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_send)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/send");
	}
	if (_cmds->add_handler("socket6/0.1/send_to",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_send_to)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/send_to");
	}
	if (_cmds->add_handler("socket6/0.1/send_from_multicast_if",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_send_from_multicast_if)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/send_from_multicast_if");
	}
	if (_cmds->add_handler("socket6/0.1/set_socket_option",
	    callback(this, &XrlFeaTargetBase::handle_socket6_0_1_set_socket_option)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6/0.1/set_socket_option");
	}
	if (_cmds->add_handler("profile/0.1/enable",
	    callback(this, &XrlFeaTargetBase::handle_profile_0_1_enable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "profile/0.1/enable");
	}
	if (_cmds->add_handler("profile/0.1/disable",
	    callback(this, &XrlFeaTargetBase::handle_profile_0_1_disable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "profile/0.1/disable");
	}
	if (_cmds->add_handler("profile/0.1/get_entries",
	    callback(this, &XrlFeaTargetBase::handle_profile_0_1_get_entries)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "profile/0.1/get_entries");
	}
	if (_cmds->add_handler("profile/0.1/clear",
	    callback(this, &XrlFeaTargetBase::handle_profile_0_1_clear)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "profile/0.1/clear");
	}
	if (_cmds->add_handler("profile/0.1/list",
	    callback(this, &XrlFeaTargetBase::handle_profile_0_1_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "profile/0.1/list");
	}
	_cmds->finalize();
}

void
XrlFeaTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_birth");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_death");
	_cmds->remove_handler("fea_click/0.1/load_click");
	_cmds->remove_handler("fea_click/0.1/unload_click");
	_cmds->remove_handler("fea_click/0.1/enable_click");
	_cmds->remove_handler("fea_click/0.1/start_click");
	_cmds->remove_handler("fea_click/0.1/stop_click");
	_cmds->remove_handler("fea_click/0.1/enable_duplicate_routes_to_kernel");
	_cmds->remove_handler("fea_click/0.1/enable_kernel_click");
	_cmds->remove_handler("fea_click/0.1/enable_kernel_click_install_on_startup");
	_cmds->remove_handler("fea_click/0.1/set_kernel_click_modules");
	_cmds->remove_handler("fea_click/0.1/set_kernel_click_mount_directory");
	_cmds->remove_handler("fea_click/0.1/set_kernel_click_config_generator_file");
	_cmds->remove_handler("fea_click/0.1/enable_user_click");
	_cmds->remove_handler("fea_click/0.1/set_user_click_command_file");
	_cmds->remove_handler("fea_click/0.1/set_user_click_command_extra_arguments");
	_cmds->remove_handler("fea_click/0.1/set_user_click_command_execute_on_startup");
	_cmds->remove_handler("fea_click/0.1/set_user_click_control_address");
	_cmds->remove_handler("fea_click/0.1/set_user_click_control_socket_port");
	_cmds->remove_handler("fea_click/0.1/set_user_click_startup_config_file");
	_cmds->remove_handler("fea_click/0.1/set_user_click_config_generator_file");
	_cmds->remove_handler("fea_fib/0.1/add_fib_client4");
	_cmds->remove_handler("fea_fib/0.1/add_fib_client6");
	_cmds->remove_handler("fea_fib/0.1/delete_fib_client4");
	_cmds->remove_handler("fea_fib/0.1/delete_fib_client6");
	_cmds->remove_handler("ifmgr/0.1/set_restore_original_config_on_shutdown");
	_cmds->remove_handler("ifmgr/0.1/get_configured_interface_names");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_names");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_flags");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_pif_index");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_addresses4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_addresses6");
	_cmds->remove_handler("ifmgr/0.1/get_configured_address_flags4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_address_flags6");
	_cmds->remove_handler("ifmgr/0.1/get_configured_interface_enabled");
	_cmds->remove_handler("ifmgr/0.1/get_configured_interface_discard");
	_cmds->remove_handler("ifmgr/0.1/get_configured_interface_unreachable");
	_cmds->remove_handler("ifmgr/0.1/get_configured_interface_management");
	_cmds->remove_handler("ifmgr/0.1/get_configured_mac");
	_cmds->remove_handler("ifmgr/0.1/get_configured_mtu");
	_cmds->remove_handler("ifmgr/0.1/get_configured_no_carrier");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_enabled");
	_cmds->remove_handler("ifmgr/0.1/get_configured_prefix4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_broadcast4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_endpoint4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_prefix6");
	_cmds->remove_handler("ifmgr/0.1/get_configured_endpoint6");
	_cmds->remove_handler("ifmgr/0.1/start_transaction");
	_cmds->remove_handler("ifmgr/0.1/commit_transaction");
	_cmds->remove_handler("ifmgr/0.1/abort_transaction");
	_cmds->remove_handler("ifmgr/0.1/create_interface");
	_cmds->remove_handler("ifmgr/0.1/delete_interface");
	_cmds->remove_handler("ifmgr/0.1/configure_all_interfaces_from_system");
	_cmds->remove_handler("ifmgr/0.1/configure_interface_from_system");
	_cmds->remove_handler("ifmgr/0.1/set_interface_enabled");
	_cmds->remove_handler("ifmgr/0.1/set_interface_discard");
	_cmds->remove_handler("ifmgr/0.1/set_interface_unreachable");
	_cmds->remove_handler("ifmgr/0.1/set_interface_management");
	_cmds->remove_handler("ifmgr/0.1/set_mac");
	_cmds->remove_handler("ifmgr/0.1/restore_original_mac");
	_cmds->remove_handler("ifmgr/0.1/set_mtu");
	_cmds->remove_handler("ifmgr/0.1/restore_original_mtu");
	_cmds->remove_handler("ifmgr/0.1/create_vif");
	_cmds->remove_handler("ifmgr/0.1/delete_vif");
	_cmds->remove_handler("ifmgr/0.1/set_vif_enabled");
	_cmds->remove_handler("ifmgr/0.1/set_vif_vlan");
	_cmds->remove_handler("ifmgr/0.1/create_address4");
	_cmds->remove_handler("ifmgr/0.1/delete_address4");
	_cmds->remove_handler("ifmgr/0.1/set_address_enabled4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_address_enabled4");
	_cmds->remove_handler("ifmgr/0.1/set_prefix4");
	_cmds->remove_handler("ifmgr/0.1/set_broadcast4");
	_cmds->remove_handler("ifmgr/0.1/set_endpoint4");
	_cmds->remove_handler("ifmgr/0.1/create_address6");
	_cmds->remove_handler("ifmgr/0.1/delete_address6");
	_cmds->remove_handler("ifmgr/0.1/set_address_enabled6");
	_cmds->remove_handler("ifmgr/0.1/get_configured_address_enabled6");
	_cmds->remove_handler("ifmgr/0.1/set_prefix6");
	_cmds->remove_handler("ifmgr/0.1/set_endpoint6");
	_cmds->remove_handler("ifmgr_replicator/0.1/register_ifmgr_mirror");
	_cmds->remove_handler("ifmgr_replicator/0.1/unregister_ifmgr_mirror");
	_cmds->remove_handler("fti/0.2/lookup_route_by_dest4");
	_cmds->remove_handler("fti/0.2/lookup_route_by_dest6");
	_cmds->remove_handler("fti/0.2/lookup_route_by_network4");
	_cmds->remove_handler("fti/0.2/lookup_route_by_network6");
	_cmds->remove_handler("fti/0.2/have_ipv4");
	_cmds->remove_handler("fti/0.2/have_ipv6");
	_cmds->remove_handler("fti/0.2/get_unicast_forwarding_enabled4");
	_cmds->remove_handler("fti/0.2/get_unicast_forwarding_enabled6");
	_cmds->remove_handler("fti/0.2/set_unicast_forwarding_enabled4");
	_cmds->remove_handler("fti/0.2/set_unicast_forwarding_enabled6");
	_cmds->remove_handler("fti/0.2/set_unicast_forwarding_entries_retain_on_startup4");
	_cmds->remove_handler("fti/0.2/set_unicast_forwarding_entries_retain_on_shutdown4");
	_cmds->remove_handler("fti/0.2/set_unicast_forwarding_entries_retain_on_startup6");
	_cmds->remove_handler("fti/0.2/set_unicast_forwarding_entries_retain_on_shutdown6");
	_cmds->remove_handler("fti/0.2/set_unicast_forwarding_table_id4");
	_cmds->remove_handler("fti/0.2/set_unicast_forwarding_table_id6");
	_cmds->remove_handler("redist_transaction4/0.1/start_transaction");
	_cmds->remove_handler("redist_transaction4/0.1/commit_transaction");
	_cmds->remove_handler("redist_transaction4/0.1/abort_transaction");
	_cmds->remove_handler("redist_transaction4/0.1/add_route");
	_cmds->remove_handler("redist_transaction4/0.1/delete_route");
	_cmds->remove_handler("redist_transaction4/0.1/delete_all_routes");
	_cmds->remove_handler("redist_transaction6/0.1/start_transaction");
	_cmds->remove_handler("redist_transaction6/0.1/commit_transaction");
	_cmds->remove_handler("redist_transaction6/0.1/abort_transaction");
	_cmds->remove_handler("redist_transaction6/0.1/add_route");
	_cmds->remove_handler("redist_transaction6/0.1/delete_route");
	_cmds->remove_handler("redist_transaction6/0.1/delete_all_routes");
	_cmds->remove_handler("raw_link/0.1/send");
	_cmds->remove_handler("raw_link/0.1/register_receiver");
	_cmds->remove_handler("raw_link/0.1/unregister_receiver");
	_cmds->remove_handler("raw_link/0.1/join_multicast_group");
	_cmds->remove_handler("raw_link/0.1/leave_multicast_group");
	_cmds->remove_handler("raw_packet4/0.1/send");
	_cmds->remove_handler("raw_packet4/0.1/register_receiver");
	_cmds->remove_handler("raw_packet4/0.1/unregister_receiver");
	_cmds->remove_handler("raw_packet4/0.1/join_multicast_group");
	_cmds->remove_handler("raw_packet4/0.1/leave_multicast_group");
	_cmds->remove_handler("raw_packet6/0.1/send");
	_cmds->remove_handler("raw_packet6/0.1/register_receiver");
	_cmds->remove_handler("raw_packet6/0.1/unregister_receiver");
	_cmds->remove_handler("raw_packet6/0.1/join_multicast_group");
	_cmds->remove_handler("raw_packet6/0.1/leave_multicast_group");
	_cmds->remove_handler("socket4/0.1/tcp_open");
	_cmds->remove_handler("socket4/0.1/udp_open");
	_cmds->remove_handler("socket4/0.1/tcp_open_and_bind");
	_cmds->remove_handler("socket4/0.1/udp_open_and_bind");
	_cmds->remove_handler("socket4/0.1/udp_open_bind_join");
	_cmds->remove_handler("socket4/0.1/tcp_open_bind_connect");
	_cmds->remove_handler("socket4/0.1/udp_open_bind_connect");
	_cmds->remove_handler("socket4/0.1/bind");
	_cmds->remove_handler("socket4/0.1/udp_join_group");
	_cmds->remove_handler("socket4/0.1/udp_leave_group");
	_cmds->remove_handler("socket4/0.1/close");
	_cmds->remove_handler("socket4/0.1/tcp_listen");
	_cmds->remove_handler("socket4/0.1/send");
	_cmds->remove_handler("socket4/0.1/send_to");
	_cmds->remove_handler("socket4/0.1/send_from_multicast_if");
	_cmds->remove_handler("socket4/0.1/set_socket_option");
	_cmds->remove_handler("socket6/0.1/tcp_open");
	_cmds->remove_handler("socket6/0.1/udp_open");
	_cmds->remove_handler("socket6/0.1/tcp_open_and_bind");
	_cmds->remove_handler("socket6/0.1/udp_open_and_bind");
	_cmds->remove_handler("socket6/0.1/udp_open_bind_join");
	_cmds->remove_handler("socket6/0.1/tcp_open_bind_connect");
	_cmds->remove_handler("socket6/0.1/udp_open_bind_connect");
	_cmds->remove_handler("socket6/0.1/bind");
	_cmds->remove_handler("socket6/0.1/udp_join_group");
	_cmds->remove_handler("socket6/0.1/udp_leave_group");
	_cmds->remove_handler("socket6/0.1/close");
	_cmds->remove_handler("socket6/0.1/tcp_listen");
	_cmds->remove_handler("socket6/0.1/send");
	_cmds->remove_handler("socket6/0.1/send_to");
	_cmds->remove_handler("socket6/0.1/send_from_multicast_if");
	_cmds->remove_handler("socket6/0.1/set_socket_option");
	_cmds->remove_handler("profile/0.1/enable");
	_cmds->remove_handler("profile/0.1/disable");
	_cmds->remove_handler("profile/0.1/get_entries");
	_cmds->remove_handler("profile/0.1/clear");
	_cmds->remove_handler("profile/0.1/list");
}
